/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.BgOrgDialog;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.VisualItemInfo;
import com.kingdee.eas.ma.mbg.client.AbstractProjectSameFormulaUI;
import com.kingdee.eas.ma.mbg.client.BgElementDialog;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.FormulaUtils;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ProjectSameFormulaUI
extends AbstractProjectSameFormulaUI
implements IGetSchemeHelper {
    private static final long serialVersionUID = -4193118118904767479L;
    private static final Logger logger = CoreUIObject.getLogger(ProjectSameFormulaUI.class);
    private BgSchemeDimensionHelper schemeHelper = null;
    private String[] expressionStrs = null;
    private Set<String> expressionType = new HashSet<String>();

    public String[] getExpressionStrs() {
        return this.expressionStrs;
    }

    public Set<String> getExpressionType() {
        return this.expressionType;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    @Override
    public BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            if (this.budgetBgScheme.getData() instanceof String) {
                this.schemeHelper = new BgSchemeDimensionHelper(null, (String)this.budgetBgScheme.getData(), true);
            } else if (this.budgetBgScheme.getData() instanceof BgSchemeInfo) {
                this.schemeHelper = new BgSchemeDimensionHelper(null, ((BgSchemeInfo)this.budgetBgScheme.getData()).getId().toString(), false);
            }
            if (this.schemeHelper == null) {
                this.schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
            }
        }
        return this.schemeHelper;
    }

    protected void init() throws Exception {
        this.initOrgUnit();
        this.initBgScheme();
        this.initBgScenario();
        this.initDimItem();
        this.initPeriod();
        this.initVersion();
        this.initCurrency();
        this.initBgElement();
        this.initDataState();
        this.initProcessType();
    }

    protected void initOrgUnit() {
        BgOrgDialog dialog = new BgOrgDialog();
        dialog.setOrgUnit((OrgUnitInfo)SysContext.getSysContext().getCurrentCtrlUnit());
        this.budgetOrg.setSelector((KDPromptSelector)dialog);
        this.budgetOrg.setEditable(false);
    }

    protected void initBgScheme() throws Exception {
        this.initBgSchemeData();
    }

    protected void initBgSchemeData() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        BOSUuid orgUnitId = null;
        Object obj = this.budgetOrg.getData();
        if (obj != null) {
            OrgUnitInfo[] orgUnits;
            if (obj instanceof BgOrgUnitInfo) {
                orgUnitId = ((BgOrgUnitInfo)obj).getId();
            } else if (obj instanceof OrgUnitInfo[] && (orgUnits = (OrgUnitInfo[])obj).length > 0) {
                orgUnitId = orgUnits[0].getId();
            }
        } else {
            orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId();
        }
        Set<BOSUuid> tmpList = this.getBgSchemeIds(orgUnitId);
        if (tmpList != null && !tmpList.isEmpty()) {
            HashSet<String> temStr = new HashSet<String>();
            for (BOSUuid id : tmpList) {
                temStr.add(id.toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("id", temStr, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"#", CompareType.EQUALS));
        }
        view.setFilter(filter);
        this.budgetBgScheme.setEntityViewInfo(view);
    }

    protected void initBgScenario() throws EASBizException, BOSException {
        this.prmtBgScenario.setQueryInfo("com.kingdee.eas.ma.base.BgScenarioQuery");
        this.prmtBgScenario.setDisplayFormat("$name$");
        this.prmtBgScenario.setCommitFormat("$number$");
        this.prmtBgScenario.setEditFormat("$number$");
        this.prmtBgScenario.setEditable(false);
        DimensionMemberSelectHelper.addIdFilter(this.prmtBgScenario, DimensionConstants.DEF_SCENARIO_NUMBER, this.getSchemeHelper());
    }

    protected void initDimItem() throws EASBizException, BOSException {
        NewDimensionMemberSelectDialog dialog = new NewDimensionMemberSelectDialog();
        if (this.getSchemeHelper() != null) {
            dialog.setBgSchemeId(this.getSchemeHelper().getBgSchemeId());
        }
        dialog.setOwner((Component)((Object)this));
        dialog.setFormulaWizard(true);
        dialog.setMulti(false);
        dialog.setSelectCombinItem(true);
        dialog.setOnlySelectItem(true);
        this.budgetProject.setSelector((KDPromptSelector)dialog);
        if (this.budgetOrg.getData() == null) {
            if (this.getUIContext().get("ORGUNIT_ID") != null) {
                String orgId = this.getUIContext().get("ORGUNIT_ID").toString();
                dialog.setOrgId(orgId);
            }
        } else {
            FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)Array.get(this.budgetOrg.getData(), 0);
            dialog.setOrgUnit(orgUnitInfo);
        }
        DimensionMemberSelectHelper.checkItemComb(this.budgetProject, this.getSchemeHelper());
    }

    protected void initPeriod() throws EASBizException, BOSException {
        BgPeriodDialog boxPeriod = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBeginPeriod.setSelector((KDPromptSelector)boxPeriod);
        this.prmtBeginPeriod.setEditable(false);
        this.prmtEndPeriod.setSelector((KDPromptSelector)boxPeriod);
        this.prmtEndPeriod.setEditable(false);
        boxPeriod.setBgPeriodTypeNumbers(this.getSchemeHelper().getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        boxPeriod.setBgSchemeID(this.schemeHelper.getBgSchemeId());
        DimensionMemberSelectHelper.checkPeriod(this.prmtEndPeriod, this.getSchemeHelper());
        DimensionMemberSelectHelper.checkPeriod(this.prmtBeginPeriod, this.getSchemeHelper());
    }

    protected void initVersion() throws EASBizException, BOSException {
        this.prmtBgVersion.setQueryInfo("com.kingdee.eas.ma.base.BgVersionQuery");
        this.prmtBgVersion.setDisplayFormat("$name$");
        this.prmtBgVersion.setCommitFormat("$number$");
        this.prmtBgVersion.setEditFormat("$number$");
        DimensionMemberSelectHelper.addIdFilter(this.prmtBgVersion, DimensionConstants.DEF_VERSION_NUMBER, this.getSchemeHelper());
    }

    protected void initCurrency() throws EASBizException, BOSException {
        this.budgetCurrency.setEditable(false);
        DimensionMemberSelectHelper.addIdFilter(this.budgetCurrency, DimensionConstants.DEF_CURRENCY_NUMBER, this.getSchemeHelper());
    }

    protected void initBgElement() throws EASBizException, BOSException {
        BgElementDialog boxElement = new BgElementDialog((IUIObject)this);
        this.budgetElement.setSelector((KDPromptSelector)boxElement);
        this.budgetElement.setEditable(false);
        DimensionMemberSelectHelper.checkMember(this.budgetElement, DimensionConstants.DEF_ELEMENT_NUMBER, this.getSchemeHelper());
    }

    protected void initDataState() {
        this.cbxDataState.addItem((Object)"");
        this.cbxDataState.addItem((Object)BgDataStateEnum.Edited);
        this.cbxDataState.addItem((Object)BgDataStateEnum.UnEditeable);
        this.cbxDataState.addItem((Object)BgDataStateEnum.Adjust);
        this.cbxDataState.addItem((Object)BgDataStateEnum.Approved);
    }

    protected void initProcessType() {
        this.cbBgProcessType.addItem((Object)"");
        this.cbBgProcessType.addItem((Object)BgProcessEnum.C01);
        this.cbBgProcessType.addItem((Object)BgProcessEnum.C02);
        this.cbBgProcessType.addItem((Object)BgProcessEnum.C03);
        this.cbBgProcessType.addItem((Object)BgProcessEnum.C04);
    }

    @Override
    protected void budgetBgScheme_willShow(SelectorEvent e) throws Exception {
        super.budgetBgScheme_willShow(e);
        this.initBgSchemeData();
        this.initDimItem();
    }

    @Override
    protected void budgetOrg_dataChanged(DataChangeEvent e) throws Exception {
        super.budgetOrg_dataChanged(e);
        this.initBgSchemeData();
        this.initDimItem();
    }

    protected IBgScheme getInterface() throws Exception {
        return BgSchemeFactory.getRemoteInstance();
    }

    protected Set<BOSUuid> getBgSchemeIds(BOSUuid orgUnitId) throws Exception {
        return this.getInterface().getCollection(orgUnitId);
    }

    @Override
    protected void budgetBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.budgetBgScheme_dataChanged(e);
        BgSchemeInfo oldInfo = (BgSchemeInfo)e.getOldValue();
        BgSchemeInfo newInfo = (BgSchemeInfo)e.getNewValue();
        if (!BgCommCHelper.isEqualsPK((IObjectValue)newInfo, (IObjectValue)oldInfo)) {
            this.schemeHelper = null;
            this.initBgScenario();
            this.initDimItem();
            this.initPeriod();
            this.initVersion();
            this.initCurrency();
            this.initBgElement();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo[] orgUnits;
        this.expressionStrs = new String[11];
        Object obj = this.budgetOrg.getData();
        if (obj instanceof BgOrgUnitInfo) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_ORG] = ((BgOrgUnitInfo)obj).getNumber();
        } else if (obj instanceof OrgUnitInfo[] && (orgUnits = (OrgUnitInfo[])obj).length > 0) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_ORG] = orgUnits[0].getNumber();
        }
        obj = this.budgetBgScheme.getData();
        if (obj instanceof BgSchemeInfo) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_SCHEME] = ((BgSchemeInfo)obj).getNumber();
        }
        if ((obj = this.prmtBgScenario.getData()) instanceof BgScenarioInfo) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_SCENARIO] = ((BgScenarioInfo)obj).getNumber();
        }
        if ((obj = this.budgetProject.getData()) instanceof VisualItemInfo) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_DIMITEM] = ((VisualItemInfo)obj).getNumber();
        }
        if ((obj = this.prmtBeginPeriod.getData()) instanceof BgPeriodInfo) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_PERIOD_BEGIN] = ((BgPeriodInfo)obj).getNumber();
        }
        if ((obj = this.prmtEndPeriod.getData()) instanceof BgPeriodInfo) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_PERIOD_END] = ((BgPeriodInfo)obj).getNumber();
        }
        if ((obj = this.prmtBgVersion.getData()) instanceof BgVersionInfo) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_VERSION] = ((BgVersionInfo)obj).getNumber();
        }
        if ((obj = this.budgetCurrency.getData()) instanceof CurrencyInfo) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_CURRENCY] = ((CurrencyInfo)obj).getNumber();
        }
        if ((obj = this.budgetElement.getData()) instanceof BgElementInfo) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_ELEMENT] = ((BgElementInfo)obj).getNumber();
        }
        if ((obj = this.cbxDataState.getSelectedItem()) instanceof BgDataStateEnum) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_DATASTATE] = BgDataStateEnum.UnEditeable.equals(obj) ? "Approving" : ((BgDataStateEnum)((Object)obj)).getName();
        }
        if ((obj = this.cbBgProcessType.getSelectedItem()) instanceof BgProcessEnum) {
            this.expressionStrs[FormulaUtils.ARRAY_INDEX_PROCESSTYPE] = ((BgProcessEnum)((Object)obj)).getName();
        }
        this.getExpressionType().clear();
        if (this.chBox_bgFormula.isSelected()) {
            this.getExpressionType().add("MbgFormula".toLowerCase());
        }
        if (this.chBox_bgActualS.isSelected()) {
            this.getExpressionType().add("MbgActuals".toLowerCase());
        }
        if (this.chBox_MbgAggregate.isSelected()) {
            this.getExpressionType().add("MbgAggregate".toLowerCase());
        }
        if (this.getExpressionType().isEmpty()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"355_ProjectSameFormulaUI"));
            return;
        }
        this.getUIWindow().close();
    }
}

