/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.BgPeriodDialog;
import com.kingdee.eas.ma.base.client.utils.ISimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.client.utils.SimpleQuickQueryHandler;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.AssignSolutionCollection;
import com.kingdee.eas.ma.mbg.AssignSolutionFactory;
import com.kingdee.eas.ma.mbg.AssignSolutionInfo;
import com.kingdee.eas.ma.mbg.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.ReCalculateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractReCalculateFilterUI;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.ma.mbg.client.BgNewOrgSelectMemberDialog;
import com.kingdee.eas.ma.mbg.client.BgRecalculateReportUI;
import com.kingdee.eas.ma.mbg.client.ProgressUI;
import com.kingdee.eas.ma.mbg.client.common.BgProcessSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.AssignSolutionInterface;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.ma.mbg.utils.CalcuFilterParam;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.RecalculateObjInfo;
import com.kingdee.eas.ma.mbg.utils.VOComparator;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ReCalculateFilterUI
extends AbstractReCalculateFilterUI
implements AssignSolutionInterface {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.client.ReCalculateFilterUI");
    private static final long serialVersionUID = -7677030206472649075L;
    private static final String resourcePath = "com.kingdee.eas.ma.mbg.client.BgRptResource";
    private CalcuFilterParam filterParam;
    private List allBgFormInfoList;
    private FullOrgUnitInfo orgUnit = null;
    private BgSchemeInfo bgScheme = null;
    public static final String COL_number = "number";
    public static final String COL_name = "name";
    public static final String COL_id = "id";
    private SimpleQuickQueryHandler leftQuickQuery = null;
    private SimpleQuickQueryHandler rightQuickQuery = null;
    List<BgDimensionMember> defOrgUnits = null;
    private Set<String> schPer = null;

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblLeft.checkParsed();
        this.tblLeft.getSelectManager().setSelectMode(10);
        this.tblLeft.setEditable(false);
        this.tblRight.checkParsed();
        this.tblRight.getSelectManager().setSelectMode(10);
        this.tblRight.setEditable(false);
    }

    public void onLoad() throws Exception {
        this.orgUnit = (FullOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        super.onLoad();
        this.bgScheme = (BgSchemeInfo)this.getUIContext().get(BgBaseConstants.BGSCHEME_INFO);
        try {
            BgNFCHelper.setPermitedSchemeView(this.prmtBgScheme, (OrgUnitInfo)this.orgUnit, null, false, BgNFCHelper.getSourceType((IUIObject)this), false, true);
            if (this.bgScheme != null) {
                this.prmtBgScheme.setData((Object)this.bgScheme);
            }
        }
        catch (Exception e1) {
            this.handUIException(e1);
        }
        BgProcessSelectDialog dialog = new BgProcessSelectDialog((IUIObject)this, true);
        this.prmtProcessType.setSelector((KDPromptSelector)dialog);
        this.prmtProcessType.addDataChangeListener((DataChangeListener)dialog);
        this.leftQuickQuery = new SimpleQuickQueryHandler(this.txtLeftSearch, (ISimpleQuickQueryHandler)new SimpleQuick(this.txtLeftSearch, this.tblLeft), "");
        this.rightQuickQuery = new SimpleQuickQueryHandler(this.txtRightSearch, (ISimpleQuickQueryHandler)new SimpleQuick(this.txtRightSearch, this.tblRight), "");
        this.tblLeft.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    ReCalculateFilterUI.this.tblLeft_tableClicked(e);
                }
                catch (Exception e1) {
                    ReCalculateFilterUI.this.handUIExceptionAndAbort(e1);
                }
            }
        });
    }

    protected void checkSelectBgScheme() {
        if (this.prmtBgScheme.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgScheme"));
            SysUtil.abort();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnMoveLeft.setIcon(EASResource.getIcon((String)"imgTbtn_move_left"));
        this.btnMoveRight.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveAllLeft.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_left"));
        this.btnMoveAllRight.setIcon(EASResource.getIcon((String)"imgTbtn_moveall_right"));
        this.prmtBgOrgUnit.setDisplayFormatter((IFormatter)new MemberFormatter());
        this.btnLeftSearch.setIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)"prompt_off.gif")));
        this.btnRightSearch.setIcon((Icon)new ImageIcon(KDResourceManager.getImageOfRapid((String)"prompt_off.gif")));
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtBgScheme_willShow(e);
    }

    @Override
    protected void prmtCurrency_willShow(SelectorEvent e) throws Exception {
        super.prmtCurrency_willShow(e);
        try {
            this.checkSelectBgScheme();
        }
        catch (Exception e2) {
            e.setCanceled(true);
        }
    }

    @Override
    protected void prmtBgVersion_willShow(SelectorEvent e) throws Exception {
        super.prmtBgVersion_willShow(e);
        try {
            this.checkSelectBgScheme();
        }
        catch (Exception e2) {
            e.setCanceled(true);
        }
        BgNFormListUI.addRollVersionFilter(this.prmtBgVersion);
    }

    @Override
    protected void prmtPeriod_willShow(SelectorEvent e) throws Exception {
        super.prmtPeriod_willShow(e);
        try {
            this.checkSelectBgScheme();
        }
        catch (Exception e2) {
            e.setCanceled(true);
        }
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtPeriod.setValue(null);
        BgSchemeInfo info = (BgSchemeInfo)this.prmtBgScheme.getData();
        if (info == null) {
            this.prmtCurrency.setData(null);
            this.prmtBgVersion.setData(null);
            this.prmtPeriod.setValue(null);
            this.prmtBgOrgUnit.setData(null);
            return;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(info.getId().toString());
        BgPeriodDialog beginF7 = new BgPeriodDialog((CoreUIObject)this, true);
        beginF7.setBgPeriodBeginDate(info.getDateFrom());
        beginF7.setBgPeriodEndDate(info.getDateTo());
        beginF7.setBgPeriodTypeNumbers(schemeHelper.getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        beginF7.setBgSchemeID(schemeHelper.getBgSchemeId());
        this.prmtPeriod.setSelector((KDPromptSelector)beginF7);
        this.prmtPeriod.addDataChangeListener((DataChangeListener)beginF7);
        DimensionMemberSelectHelper.addIdFilter(this.prmtCurrency, DimensionConstants.DEF_CURRENCY_NUMBER, schemeHelper);
        DimensionMemberSelectHelper.addIdFilter(this.prmtBgVersion, DimensionConstants.DEF_VERSION_NUMBER, schemeHelper);
        BgSchemeUtils.setDefualtMembers(schemeHelper, (JComponent)this.prmtBgVersion, (JComponent)this.prmtPeriod, (JComponent)this.prmtCurrency, false, false);
        Object data = this.prmtPeriod.getData();
        if (data != null) {
            this.prmtPeriod.setData(null);
            if (data instanceof Object[]) {
                this.prmtPeriod.setData(data);
            } else {
                this.prmtPeriod.setData((Object)new Object[]{data});
            }
        }
        this.initBgOrgUnitF7(schemeHelper);
        this.initBgTemplateList();
    }

    @Override
    protected void prmtBgOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgOrgUnit_dataChanged(e);
        this.initBgTemplateList();
    }

    @Override
    protected void prmtBgOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtBgOrgUnit_willShow(e);
        try {
            this.checkSelectBgScheme();
        }
        catch (Exception e2) {
            e.setCanceled(true);
        }
    }

    private void initBgTemplateList() throws BOSException {
        if (!(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
            return;
        }
        this.tblLeft.removeRows();
        this.tblRight.removeRows();
        this.txtLeftSearch.setText("");
        this.txtRightSearch.setText("");
        BgSchemeInfo info = (BgSchemeInfo)this.prmtBgScheme.getData();
        Set<String> orgUnitIds = this.getSelectOrgUnits();
        List templateList = ReCalculateFacadeFactory.getRemoteInstance().getTemplateBySchemeId(info.getId().toString(), orgUnitIds);
        if (templateList != null) {
            Collections.sort(templateList, new VOComparator(new String[]{COL_number}));
        }
        BgTemplateInfo tempInfo = null;
        IRow row = null;
        int num = templateList.size();
        for (int i = 0; i < num; ++i) {
            tempInfo = (BgTemplateInfo)templateList.get(i);
            if (BgTemFormTypeEnum.VIEWFORM == tempInfo.getFormType() || BgTemFormTypeEnum.VIEWLIST == tempInfo.getFormType()) continue;
            row = this.tblLeft.addRow();
            this.loadToRow(row, tempInfo);
        }
    }

    protected Set<String> getSelectOrgUnits() {
        HashSet<String> orgUnitIds = new HashSet<String>();
        if (this.prmtBgOrgUnit.getData() instanceof List) {
            List orgs = (List)this.prmtBgOrgUnit.getData();
            for (int i = 0; i < orgs.size(); ++i) {
                orgUnitIds.add(((BgDimensionMember)orgs.get(i)).getAttribute());
            }
        }
        return orgUnitIds;
    }

    protected void initBgOrgUnitF7(BgSchemeDimensionHelper schemeHelper) {
        Object oldOrg = this.prmtBgOrgUnit.getData();
        this.prmtBgOrgUnit.setDataNoNotify(null);
        this.prmtBgOrgUnit.setEditable(false);
        if (schemeHelper == null) {
            return;
        }
        BgNewOrgSelectMemberDialog dialog = new BgNewOrgSelectMemberDialog(this);
        dialog.setBgOrgViewId(schemeHelper.getBgOrgViewId());
        dialog.setOrgUnitId(this.orgUnit.getId().toString());
        dialog.setPermissionNumber((String)this.getUIContext().get("permissionNumber"));
        dialog.setIsorgOnPageOrView(true);
        this.prmtBgOrgUnit.setSelector((KDPromptSelector)dialog);
        this.prmtBgOrgUnit.addDataChangeListener((DataChangeListener)dialog);
        if (oldOrg == this.getDefOrgUnits()) {
            try {
                if (BgOrgUnitFactory.getRemoteInstance().exists("where viewId = '" + schemeHelper.getBgOrgViewId() + "' and orgUnitId = '" + this.orgUnit.getId() + "'")) {
                    this.prmtBgOrgUnit.setData(oldOrg);
                }
            }
            catch (EASBizException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
    }

    CalcuFilterParam getFilterParam() {
        if (this.filterParam == null) {
            this.filterParam = new CalcuFilterParam();
        }
        return this.filterParam;
    }

    public List<BgDimensionMember> getDefOrgUnits() {
        if (this.defOrgUnits == null) {
            this.defOrgUnits = BgNewOrgSelectMemberDialog.transOrgUnit(this.orgUnit);
        }
        return this.defOrgUnits;
    }

    @Override
    public void clear() throws Exception {
        this.prmtCurrency.setValue(null);
        this.prmtPeriod.setValue(null);
        this.prmtBgVersion.setValue(null);
        this.prmtBgScheme.setData((Object)this.bgScheme);
        DataChangeEvent event = new DataChangeEvent((Object)this.prmtBgScheme, (Object)this.bgScheme, null);
        this.prmtBgScheme_dataChanged(event);
        this.prmtBgOrgUnit.setData(this.getDefOrgUnits());
        this.prmtProcessType.setData((Object)new BgProcessEnum[]{BgProcessEnum.C01});
    }

    @Override
    public Object saveSolution() throws Exception {
        this.verifyData();
        this.filterParam = this.getFilterParam();
        this.fillDataToCalcuFilterParam();
        return this.filterParam;
    }

    private Set<String> getBgSchemePermissionIDs() throws Exception {
        if (this.schPer == null) {
            this.schPer = BgNFCHelper.getPermitedSchemeIDs((OrgUnitInfo)this.orgUnit, BgNFCHelper.getSourceType((IUIObject)this));
        }
        return this.schPer;
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        if (o == null) {
            return;
        }
        this.filterParam = (CalcuFilterParam)o;
        BgSchemeInfo bgSchemeInfo = this.filterParam.getBgSchemeInfo();
        BgSchemeInfo bgScheAllInfo = BgSchemeFactory.getRemoteInstance().getValue(bgSchemeInfo.getId());
        if (bgScheAllInfo == null) {
            logger.error((Object)("" + bgSchemeInfo.getId() + ": has wrong"));
            return;
        }
        if (this.getBgSchemePermissionIDs().contains(bgScheAllInfo.getId().toString())) {
            this.prmtBgScheme.setData((Object)bgScheAllInfo);
        } else {
            this.prmtBgScheme.setData(null);
        }
        if (this.filterParam.getOrgUnitMembers() != null) {
            this.prmtBgOrgUnit.setData(this.filterParam.getOrgUnitMembers());
        } else {
            this.prmtBgOrgUnit.setData(BgNewOrgSelectMemberDialog.transOrgUnit(this.orgUnit));
        }
        this.prmtCurrency.setValue((Object)this.filterParam.getCurrencyInfo());
        this.prmtBgVersion.setValue((Object)this.filterParam.getBgVersionInfo());
        this.prmtPeriod.setValue((Object)this.filterParam.getPeriodInfo());
        KDList list = this.filterParam.getSelectedElementList();
        HashMap<String, Integer> templateRowIndex = new HashMap<String, Integer>();
        for (int r = 0; r < this.tblLeft.getRowCount(); ++r) {
            templateRowIndex.put(((BgTemplateInfo)this.tblLeft.getRow(r).getUserObject()).getId().toString(), r);
        }
        this.tblRight.removeRows();
        this.txtLeftSearch.setText("");
        this.txtRightSearch.setText("");
        ArrayList<Integer> selectRowIndexes = new ArrayList<Integer>();
        if (list.getElementCount() > 0) {
            ArrayList<Object> selectedElementList = new ArrayList<Object>();
            int num = list.getElementCount();
            for (int i = 0; i < num; ++i) {
                selectedElementList.add(list.getElement(i));
            }
            int size = selectedElementList.size();
            if (size != 0) {
                for (int i = 0; i < size; ++i) {
                    Object obj = selectedElementList.get(i);
                    if (!templateRowIndex.containsKey(((BgTemplateInfo)obj).getId().toString())) continue;
                    selectRowIndexes.add((Integer)templateRowIndex.get(((BgTemplateInfo)obj).getId().toString()));
                }
            }
            this.addToRight(selectRowIndexes, true);
        } else {
            List<BgTemplateInfo> selectTable = this.getFilterParam().getSelectTable();
            int num = selectTable.size();
            for (int i = 0; i < num; ++i) {
                BgTemplateInfo obj = selectTable.get(i);
                if (!templateRowIndex.containsKey(obj.getId().toString())) continue;
                selectRowIndexes.add((Integer)templateRowIndex.get(obj.getId().toString()));
            }
            this.addToRight(selectRowIndexes, true);
        }
        this.prmtProcessType.setData((Object)this.filterParam.getProcessTypes());
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    @Override
    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        String uiName = (String)uicontext.get("selfPanelUiName");
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = (String)uicontext.get(BgBaseConstants.ORGUNIT_CU);
            if (StringUtils.isEmpty((String)cuid)) {
                cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            }
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = this.orgUnit.getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        if (uiName != null) {
            oql.append(" and uiName='" + uiName + "' ");
        }
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    @Override
    public void verifyData() throws Exception {
        if (this.prmtBgScheme == null) {
            this.prmtBgScheme.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"msgSelectBgScheme"));
            SysUtil.abort();
        }
        if (DimensionCommonHelper.isEmpty(this.prmtBgOrgUnit.getData())) {
            this.prmtBgOrgUnit.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgOrgUnitReource", (String)"EmptyBgOrgUnit"));
            SysUtil.abort();
        }
        if (this.tblRight.getRowCount() == 0) {
            this.tblRight.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"ReSelectBgTemplate"));
            SysUtil.abort();
        }
        if (DimensionCommonHelper.isEmpty(this.prmtPeriod.getData())) {
            this.prmtPeriod.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BgPeriondNotNull"));
            SysUtil.abort();
        }
        if (this.prmtCurrency.getValue() == null) {
            this.prmtCurrency.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CurrencyNotNull"));
            SysUtil.abort();
        }
        if (this.prmtBgVersion.getValue() == null) {
            this.prmtBgVersion.requestFocus();
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"BgVersionNotNull"));
            SysUtil.abort();
        }
    }

    private void fillDataToCalcuFilterParam() {
        CalcuFilterParam param = this.getFilterParam();
        param.setCurrencyInfo((CurrencyInfo)this.prmtCurrency.getValue());
        param.setBgVersionInfo((BgVersionInfo)this.prmtBgVersion.getValue());
        param.setBgSchemeInfo((BgSchemeInfo)this.prmtBgScheme.getData());
        param.setOrgUnitMembers((List)this.prmtBgOrgUnit.getData());
        BgPeriodInfo[] periodInfos = null;
        if (this.prmtPeriod.getData() instanceof BgPeriodInfo) {
            periodInfos = new BgPeriodInfo[]{(BgPeriodInfo)this.prmtPeriod.getData()};
        } else if (this.prmtPeriod.getData() instanceof BgPeriodInfo) {
            periodInfos = (BgPeriodInfo[])this.prmtPeriod.getData();
        } else if (this.prmtPeriod.getData() instanceof Object[]) {
            Object[] objs = (Object[])this.prmtPeriod.getData();
            periodInfos = new BgPeriodInfo[objs.length];
            System.arraycopy(objs, 0, periodInfos, 0, objs.length);
        }
        param.setPeriodInfo(periodInfos);
        param.setSelectedElementList(new KDList());
        ArrayList<BgTemplateInfo> tempList = new ArrayList<BgTemplateInfo>();
        for (int i = 0; i < this.tblRight.getRowCount(); ++i) {
            tempList.add((BgTemplateInfo)this.tblRight.getRow(i).getUserObject());
        }
        param.setSelectTable(tempList);
        Object[] types = DimensionCommonHelper.getValues(this.prmtProcessType.getData());
        BgProcessEnum[] enms = null;
        if (types != null) {
            enms = new BgProcessEnum[types.length];
            for (int i = 0; i < types.length; ++i) {
                enms[i] = (BgProcessEnum)((Object)types[i]);
            }
        }
        this.filterParam.setProcessTypes(enms);
    }

    @Override
    public boolean conferm(Object invokeUi) throws Exception {
        this.verifyData();
        this.fillDataToCalcuFilterParam();
        String schemeID = this.getFilterParam().getBgSchemeInfo().getId().toString();
        BgPeriodInfo[] periodInfoAry = this.getFilterParam().getPeriodInfo();
        String currencyID = this.getFilterParam().getCurrencyInfo().getId().toString();
        String bgVersionId = this.getFilterParam().getBgVersionInfo().getId().toString();
        KDList list = this.getFilterParam().getSelectedElementList();
        ArrayList<BgTemplateInfo> templateList = new ArrayList<BgTemplateInfo>();
        if (list.getElementCount() > 0) {
            int num = list.getElementCount();
            for (int i = 0; i < num; ++i) {
                BgTemplateInfo info = (BgTemplateInfo)list.getElement(i);
                templateList.add(info);
            }
        } else {
            List<BgTemplateInfo> selectTable = this.getFilterParam().getSelectTable();
            int num = selectTable.size();
            for (int i = 0; i < num; ++i) {
                BgTemplateInfo info = selectTable.get(i);
                templateList.add(info);
            }
        }
        this.allBgFormInfoList = ReCalculateFacadeFactory.getRemoteInstance().getBgForm(schemeID, this.getSelectOrgUnits(), templateList, periodInfoAry, currencyID, bgVersionId, this.getFilterParam().getProcessTypes());
        if (!this.hasCalculateBgForm(this.allBgFormInfoList)) {
            HashMap<String, Object> ctx = new HashMap<String, Object>();
            ctx.put("Owner", this);
            ctx.put("bgFormList", this.allBgFormInfoList);
            ctx.put("beginTime", new Date(System.currentTimeMillis()).toLocaleString());
            ctx.put("ORGUNIT_COST", this.orgUnit);
            try {
                IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow messageDialog = uiFactory.create(BgRecalculateReportUI.class.getName(), ctx);
                messageDialog.show();
            }
            catch (UIException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        } else {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    ReCalculateFilterUI.this.createProcessUI(ReCalculateFilterUI.this.allBgFormInfoList);
                }
            };
            thread.start();
        }
        return true;
    }

    private void createProcessUI(List bgFormInfoList) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", this);
        ctx.put("allBgFormInfoList", bgFormInfoList);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow messageDialog = uiFactory.create(ProgressUI.class.getName(), ctx);
            messageDialog.show();
            this.createReportUI(((ProgressUI)messageDialog.getUIObject()).getAllBgFormInfoList());
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    private void createReportUI(List bgFormList) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        Date beginTime = new Date(System.currentTimeMillis());
        ctx.put("Owner", this);
        ctx.put("bgFormList", bgFormList);
        ctx.put("beginTime", beginTime.toLocaleString());
        ctx.put("ORGUNIT_COST", this.orgUnit);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow messageDialog = uiFactory.create(BgRecalculateReportUI.class.getName(), ctx);
            messageDialog.show();
        }
        catch (UIException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
    }

    @Override
    public boolean cancel() throws Exception {
        return true;
    }

    @Override
    public Map getReturnData() throws Exception {
        return null;
    }

    @Override
    public String getNewConfermLabel() {
        return null;
    }

    @Override
    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        StringBuffer oql = new StringBuffer("where issystemsolution =1 ");
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        oql.append(" and userId='" + userId + "' ");
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        AssignSolutionInfo assignSolutionInfo = null;
        AssignSolutionCollection assignSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        if (assignSolutionCol.size() > 0) {
            assignSolutionInfo = assignSolutionCol.get(0);
        }
        return assignSolutionInfo;
    }

    private boolean hasCalculateBgForm(List allBgFormInfoList) {
        int num = allBgFormInfoList.size();
        for (int i = 0; i < num; ++i) {
            RecalculateObjInfo info = (RecalculateObjInfo)allBgFormInfoList.get(i);
            if (!info.getRecalculateResult().equals("cancel")) continue;
            return true;
        }
        return false;
    }

    protected void doQuickQuery(KDTextField txtSearch, KDTable table) {
        String searchText = txtSearch.getText().trim();
        if (table == this.tblRight) {
            boolean isEnable = StringUtils.isEmpty((String)searchText);
            this.btnDown.setEnabled(isEnable);
            this.btnUp.setEnabled(isEnable);
        }
        boolean isMarch = false;
        IRow row = null;
        for (int r = 0; r < table.getRowCount(); ++r) {
            row = table.getRow(r);
            isMarch = false;
            if (StringUtils.isEmpty((String)searchText)) {
                isMarch = true;
            } else {
                for (int c = 0; c < table.getColumnCount(); ++c) {
                    if (table.getColumn(c).getStyleAttributes().isHided() || String.valueOf(row.getCell(c).getValue()).indexOf(searchText) < 0) continue;
                    isMarch = true;
                    break;
                }
            }
            row.getStyleAttributes().setHided(!isMarch);
        }
    }

    @Override
    protected void btnLeftSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnLeftSearch_actionPerformed(e);
        this.doQuickQuery(this.txtLeftSearch, this.tblLeft);
    }

    @Override
    protected void btnRightSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnRightSearch_actionPerformed(e);
        this.doQuickQuery(this.txtRightSearch, this.tblRight);
    }

    protected void tblLeft_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.btnMoveRight_actionPerformed(null);
        }
    }

    @Override
    public void btnMoveRight_actionPerformed(ActionEvent e) throws Exception {
        List rowIndexs = BgCommCHelper.getSelectRowIndexes((KDTable)this.tblLeft);
        this.addToRight(rowIndexs, false);
    }

    @Override
    public void btnMoveAllRight_actionPerformed(ActionEvent e) throws Exception {
        List rowIndexs = BgCommCHelper.getSelectAllRowIndexes((KDTable)this.tblLeft);
        this.addToRight(rowIndexs, false);
    }

    private void addToRight(List<Integer> rowIndexs, boolean isLoadField) {
        if (rowIndexs == null || rowIndexs.isEmpty()) {
            return;
        }
        Map<String, BgTemplateInfo> selectedMap = this.getSelectBgTemplateMap();
        IRow row = null;
        BgTemplateInfo info = null;
        if (!isLoadField) {
            Collections.sort(rowIndexs);
        }
        ArrayList<Integer> removeIndexes = new ArrayList<Integer>();
        for (int rowIndex : rowIndexs) {
            row = this.tblLeft.getRow(rowIndex);
            if (this.tblLeft.getRow(rowIndex).getStyleAttributes().isHided()) continue;
            removeIndexes.add(rowIndex);
            info = (BgTemplateInfo)row.getUserObject();
            if (selectedMap.containsKey(info.getNumber() + info.getId())) continue;
            this.loadToRow(this.tblRight.addRow(), info);
        }
        Collections.sort(removeIndexes);
        Collections.reverse(removeIndexes);
        for (int rowIndex : removeIndexes) {
            this.tblLeft.removeRow(rowIndex);
        }
    }

    private void loadToRow(IRow row, BgTemplateInfo bgTemplateInfo) {
        row.setUserObject((Object)bgTemplateInfo);
        row.getCell(COL_number).setValue((Object)bgTemplateInfo.getNumber());
        row.getCell(COL_name).setValue((Object)bgTemplateInfo.getName());
        row.getCell(COL_id).setValue((Object)bgTemplateInfo.getId().toString());
    }

    @Override
    public void btnMoveLeft_actionPerformed(ActionEvent e) throws Exception {
        this.removeFromRight(BgCommCHelper.getSelectRowIndexes((KDTable)this.tblRight));
    }

    @Override
    public void btnMoveAllLeft_actionPerformed(ActionEvent e) throws Exception {
        this.removeFromRight(BgCommCHelper.getSelectAllRowIndexes((KDTable)this.tblRight));
    }

    protected void removeFromRight(List<Integer> rowIndexs) {
        if (rowIndexs == null || rowIndexs.isEmpty()) {
            return;
        }
        Collections.reverse(rowIndexs);
        HashMap<String, BgTemplateInfo> selectBgTemplateMap = new HashMap<String, BgTemplateInfo>();
        IRow row = null;
        BgTemplateInfo info = null;
        for (int rowIndex : rowIndexs) {
            row = this.tblRight.getRow(rowIndex);
            if (row.getStyleAttributes().isHided()) continue;
            info = (BgTemplateInfo)row.getUserObject();
            selectBgTemplateMap.put(info.getNumber().toLowerCase() + "000000000000000000000000000=" + info.getId(), info);
            this.tblRight.removeRow(rowIndex);
        }
        if (selectBgTemplateMap.isEmpty()) {
            return;
        }
        ArrayList addNumbers = new ArrayList(selectBgTemplateMap.keySet());
        Collections.sort(addNumbers);
        Collections.reverse(addNumbers);
        String key = null;
        for (int rowIndex = this.tblLeft.getRowCount() - 1; rowIndex >= 0; --rowIndex) {
            row = this.tblLeft.getRow(rowIndex);
            info = (BgTemplateInfo)row.getUserObject();
            key = info.getNumber().toLowerCase() + "000000000000000000000000000=" + info.getId();
            while (addNumbers.size() > 0 && key.compareTo((String)addNumbers.get(0)) <= 0) {
                if (this.tblLeft.getRowCount() == rowIndex + 1) {
                    this.loadToRow(this.tblLeft.addRow(), (BgTemplateInfo)selectBgTemplateMap.get(addNumbers.remove(0)));
                    continue;
                }
                this.loadToRow(this.tblLeft.addRow(rowIndex + 1), (BgTemplateInfo)selectBgTemplateMap.get(addNumbers.remove(0)));
            }
        }
        for (int i = 0; i < addNumbers.size(); ++i) {
            this.loadToRow(this.tblLeft.addRow(0), (BgTemplateInfo)selectBgTemplateMap.get(addNumbers.get(i)));
        }
    }

    @Override
    public void btnDown_actionPerformed(ActionEvent e) throws Exception {
        BgCommCHelper.moveDown((KDTable)this.tblRight);
    }

    @Override
    public void btnUp_actionPerformed(ActionEvent e) throws Exception {
        BgCommCHelper.moveUp((KDTable)this.tblRight);
    }

    private Map<String, BgTemplateInfo> getSelectBgTemplateMap() {
        LinkedHashMap<String, BgTemplateInfo> bgTemplateMap = new LinkedHashMap<String, BgTemplateInfo>();
        BgTemplateInfo info = null;
        for (int r = 0; r < this.tblRight.getRowCount(); ++r) {
            info = (BgTemplateInfo)this.tblRight.getRow(r).getUserObject();
            bgTemplateMap.put(info.getNumber() + info.getId(), info);
        }
        return bgTemplateMap;
    }

    private class SimpleQuick
    implements ISimpleQuickQueryHandler {
        private KDTable table = null;
        private KDTextField txtSearch = null;

        public SimpleQuick(KDTextField txtSearch, KDTable table) {
            this.txtSearch = txtSearch;
            this.table = table;
        }

        public void doQuickQuery() {
            ReCalculateFilterUI.this.doQuickQuery(this.txtSearch, this.table);
        }
    }

    class MemberFormatter
    implements IFormatter {
        MemberFormatter() {
        }

        public String valueToString(Object o) {
            if (o instanceof List) {
                StringBuffer convertArray = new StringBuffer();
                List members = (List)o;
                for (int i = 0; i < members.size(); ++i) {
                    if (convertArray.length() > 0) {
                        convertArray.append(";");
                    }
                    convertArray.append(((BgDimensionMember)members.get(i)).getName());
                }
                return convertArray == null ? "" : convertArray.toString();
            }
            if (o != null) {
                return o.toString();
            }
            return "";
        }

        public void applyPattern(String pattern) {
        }
    }
}

