/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.client.AbstractReferBgFormListUI;
import com.kingdee.eas.ma.mbg.client.BgNFormListUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReferBgFormListUI
extends AbstractReferBgFormListUI {
    private static final Logger logger = CoreUIObject.getLogger(ReferBgFormListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.processReferBgFormInfo();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                Object row = null;
                if (e.getClickCount() == 2) {
                    try {
                        ReferBgFormListUI.this.openWindow(e.getRowIndex());
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1);
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            }
        });
    }

    private void processReferBgFormInfo() {
        Object objexpsBgForms = this.getUIContext().get("expsBgForms");
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.getUIContext().get("BgPeriodInfo");
        ArrayList<Object[]> sortedList = new ArrayList<Object[]>();
        if (objexpsBgForms == null) {
            return;
        }
        Map expsBgForms = (Map)objexpsBgForms;
        Object bgForms = null;
        Object[] dataObj = null;
        IRow row = null;
        this.tblMain.checkParsed();
        this.tblMain.reLayoutAndPaint();
        this.tblMain.getStyleAttributes().setLocked(true);
        for (Object expName : expsBgForms.keySet()) {
            dataObj = (Object[])expsBgForms.get(expName);
            Object[] sortedObj = new Object[]{dataObj[0], dataObj[1], dataObj[2], bgPeriodInfo.getName(), dataObj[4], expName, dataObj[5], bgPeriodInfo.getLongNumber(), dataObj[7], dataObj[8]};
            sortedList.add(sortedObj);
        }
        Collections.sort(sortedList, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                Object[] objs1 = (Object[])obj1;
                Object[] objs2 = (Object[])obj2;
                if (objs1 == null || objs2 == null) {
                    return 0;
                }
                String orgUnit1 = (String)objs1[6];
                String orgUnit2 = (String)objs2[6];
                String period1 = (String)objs1[7];
                String period2 = (String)objs2[7];
                int compare1 = orgUnit1.compareToIgnoreCase(orgUnit2);
                if (compare1 != 0) {
                    return compare1;
                }
                return period1.compareToIgnoreCase(period2);
            }
        });
        Object[] cellData2 = null;
        for (Object[] cellData2 : sortedList) {
            Object expName;
            Object bgFormId = cellData2[0];
            Object sourceBgform = cellData2[1];
            Object orgUnit = cellData2[2];
            Object period = cellData2[3];
            Object currency = cellData2[4];
            expName = cellData2[5];
            Object bgVersion = cellData2[8];
            Object processType = cellData2[9];
            row = this.tblMain.addRow();
            row.getCell(0).setValue(expName);
            row.getCell(1).setValue(sourceBgform);
            row.getCell(2).setValue(orgUnit);
            row.getCell(3).setValue(bgVersion);
            row.getCell(4).setValue(period);
            row.getCell(5).setValue(currency);
            row.getCell(7).setValue(bgFormId);
            row.getCell(6).setValue(processType);
        }
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        this.openWindow(rowIndex);
    }

    protected void openWindow(int rowIndex) throws Exception {
        IRow row = this.tblMain.getRow(rowIndex);
        String bgFormId = null;
        if (row != null && row.getCell("bgForm.id").getValue() != null) {
            bgFormId = row.getCell("bgForm.id").getValue().toString();
        }
        ReferBgFormListUI.openWindow(this, bgFormId);
    }

    public static void openWindow(CoreUI owner, String bgFormId) throws BOSException, EASBizException, UIException {
        ReferBgFormListUI.openWindow(owner, bgFormId, null);
    }

    public static void openWindow(CoreUI owner, String bgFormId, String formula) throws BOSException, EASBizException, UIException {
        if (StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        IBgForm ibgForm = BgFormFactory.getRemoteInstance();
        BgFormInfo info = (BgFormInfo)ibgForm.getValue("select id , bgTemplate.id, bgTemplate.formType, processType, orgUnit.id, orgUnit.name, orgUnit.number where id = '" + bgFormId + "'");
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"ID", (Object)bgFormId);
        if (!StringUtils.isEmpty((String)formula)) {
            uiContext.put((Object)"FORMULA", (Object)formula);
        }
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, (Object)info.getOrgUnit());
        BgPermissionUtil.checkPermission((OrgUnitInfo)info.getOrgUnit(), (String)"mbg_form05_view");
        IUIWindow uiWindow = null;
        String processName = BgNFormListUI.getProcessUIName(info.getProcessType().getValue(), info.getBgTemplate().getFormType().getValue());
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(processName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

