/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.client.utils.IViewDimensionMemberF7;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.IDimensionRelationshipGroup;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.AbstractRelationDimensionMemberF7UI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionRelationClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberRelationShipHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;
import org.apache.log4j.Logger;

public class RelationDimensionMemberF7UI
extends AbstractRelationDimensionMemberF7UI
implements IViewDimensionMemberF7,
IGetSchemeHelper {
    private static final long serialVersionUID = -1058954141916206599L;
    private static final Logger logger = CoreUIObject.getLogger(RelationDimensionMemberF7UI.class);
    public static final String COL_SELECT = "select";
    public static final String COL_NUMBER = "number";
    public static final String COL_NAME = "name";
    public static final String COL_DIMENSION = "dimension";
    public static final String COL_LOWSHOW = "isLowShow";
    private String bgSchemeId = null;
    private BgSchemeDimensionHelper schemeHelper = null;
    private BgDimensionBaseInfo dimension = null;
    private CostCenterOrgUnitInfo orgUnit = null;
    private FullOrgUnitInfo unionGroupInfo = null;
    private BOSUuid orgTreeId = null;
    private boolean isCancel = true;
    private MbgViewListResultData data = null;
    private DimensionRelationshipGroupInfo selectGroupInfo = null;

    public FullOrgUnitInfo getUnionGroupInfo() {
        return this.unionGroupInfo;
    }

    public void setUnionGroupInfo(FullOrgUnitInfo unionGroupInfo) {
        this.unionGroupInfo = unionGroupInfo;
    }

    @Override
    public final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
            if (this.schemeHelper == null) {
                this.schemeHelper = new BgSchemeDimensionHelper(null, this.bgSchemeId);
            }
        }
        return this.schemeHelper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.orgTreeId = (BOSUuid)this.getUIContext().get(DimensionConstants.DEF_CSL_NUMBER);
        this.schemeHelper = (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
        this.dimension = (BgDimensionBaseInfo)this.getUIContext().get(COL_DIMENSION);
        this.bgSchemeId = (String)this.getUIContext().get("BGSCHEME_ID");
        this.orgUnit = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectStringPK((String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID)));
        if (this.getUIContext().get("GROUPORG_ID") != null) {
            this.unionGroupInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK((String)this.getUIContext().get("GROUPORG_ID")));
        }
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblGroup.checkParsed();
        KDCheckBox rd = new KDCheckBox();
        this.tblGroup.getColumn(COL_SELECT).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)rd));
        this.tblRelationShip.checkParsed();
    }

    protected void executeQueryGroup() throws EASBizException, BOSException {
        int i;
        List res = TemplateFacadeFactory.getRemoteInstance().getDimensionRelationGroup(this.dimension, this.bgSchemeId, this.orgTreeId);
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.schemeHelper != null) {
            List<BgDimensionInfo> alldims = this.schemeHelper.getAllDimensions();
            for (i = 0; i < alldims.size(); ++i) {
                map.put(alldims.get(i).getNumber(), alldims.get(i).getName());
            }
        }
        this.tblGroup.removeRows();
        if (res != null && res.size() > 0) {
            StringBuffer name = new StringBuffer();
            for (i = 0; i < res.size(); ++i) {
                DimensionRelationshipGroupInfo info = (DimensionRelationshipGroupInfo)res.get(i);
                if (!this.isShow(info)) continue;
                name.setLength(0);
                for (int e = 0; e < info.getEntries().size(); ++e) {
                    if (e > 0) {
                        name.append(",");
                    }
                    if (map.containsKey(info.getEntries().get(e).getDimNumber())) {
                        info.getEntries().get(e).setDimName((String)map.get(info.getEntries().get(e).getDimNumber()));
                    }
                    name.append(info.getEntries().get(e).getDimName());
                }
                if (!StringUtils.isEmpty((String)this.txtGroupSearch.getText())) {
                    String filter = this.txtGroupSearch.getText();
                    if (info.getNumber().indexOf(filter) < 0 && String.valueOf(info.getName()).indexOf(filter) < 0 && name.toString().indexOf(filter) < 0) continue;
                }
                IRow row = this.tblGroup.addRow();
                row.setUserObject((Object)info);
                row.getCell(COL_SELECT, true).setValue((Object)(this.selectGroupInfo != null && info.getId().equals((Object)this.selectGroupInfo.getId()) ? 1 : 0));
                row.getCell(COL_NUMBER, true).setValue((Object)info.getNumber());
                row.getCell(COL_NAME, true).setValue((Object)info.getName());
                row.getCell(COL_DIMENSION, true).setValue((Object)name.toString());
                row.getCell(COL_LOWSHOW, true).setValue((Object)info.getIsLowerShow());
            }
        }
    }

    @Override
    protected void tblGroup_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblGroup_editValueChanged(e);
        if (e.getOldValue() == e.getValue()) {
            return;
        }
        String colKey = this.tblGroup.getColumnKey(e.getColIndex());
        if (COL_SELECT.equals(colKey)) {
            if (e.getValue() instanceof Boolean) {
                boolean isSelect = (Boolean)e.getValue();
                if (isSelect) {
                    for (int r = 0; r < this.tblGroup.getRowCount(); ++r) {
                        if (r != e.getRowIndex()) {
                            this.tblGroup.getCell(r, COL_SELECT).setValue((Object)false);
                            continue;
                        }
                        this.selectGroupInfo = (DimensionRelationshipGroupInfo)this.tblGroup.getRow(r).getUserObject();
                    }
                } else {
                    this.selectGroupInfo = null;
                }
                this.loadTempTable();
            }
            this.executeQueryShip();
        }
    }

    protected void loadTempTable() throws EASBizException, BOSException {
        DimensionRelationClientHelper.loadTempTable(this, this.tblRelationShip, this.selectGroupInfo, this.orgUnit, this.getUnionGroupInfo(), this.schemeHelper, false);
        if (this.selectGroupInfo != null) {
            this.tblRelationShip.getColumn(DimensionConstants.ORGUNIT2).getStyleAttributes().setHided(true);
            this.tblRelationShip.getColumn(DimensionConstants.ISENABLE2).getStyleAttributes().setHided(true);
        }
    }

    protected void executeQueryShip() {
        this.tblRelationShip.removeRows();
        if (this.selectGroupInfo == null) {
            return;
        }
        try {
            String filterStr = this.txtRelationShipSearch.getText();
            DimensionMemberRelationShipHelper shipHelper = DimensionFormulaFacadeFactory.getRemoteInstance().buildRelationHelper(this.selectGroupInfo.getId().toString(), this.orgUnit.getId().toString(), null);
            if (shipHelper == null || shipHelper.getGroup() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"selectRelation"));
                SysUtil.abort();
            }
            DimensionRelationshipCollection dimRelationCol = shipHelper.getCol();
            IRow row = null;
            int rowSize = 0;
            DimensionRelationshipInfo shipInfo = null;
            int j = dimRelationCol.size();
            for (int i = 0; i < j; ++i) {
                shipInfo = dimRelationCol.get(i);
                if (!StringUtils.isEmpty((String)filterStr) && shipInfo.getDimensionName().indexOf(filterStr) < 0 && shipInfo.getDimensionNumber().indexOf(filterStr) < 0) continue;
                row = this.tblRelationShip.addRow();
                row.setUserObject((Object)shipInfo);
                row.getCell(COL_SELECT).setValue((Object)false);
                row.getCell(DimensionConstants.DIMENSION_NUMBER).setValue((Object)shipInfo.getDimensionNumber());
                row.getCell(DimensionConstants.DIMENSION_NAME).setValue((Object)shipInfo.getDimensionName());
                row.getCell(DimensionConstants.DIMENSION_ORGUNIT).setValue((Object)this.orgUnit);
                row.getCell(DimensionConstants.DIMENSION_ORGUNIT_ID).setValue((Object)this.orgUnit.getId().toString());
                ++rowSize;
            }
            KDTDataRequestEvent e1 = new KDTDataRequestEvent(this.tblRelationShip);
            e1.setFirstRow(0);
            e1.setLastRow(rowSize - 1);
            DimensionRelationClientHelper.initRowValue(this, e1, this.tblRelationShip, this.selectGroupInfo, true, this.orgUnit, this.getUnionGroupInfo(), this.getSchemeHelper());
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException((Exception)((Object)e));
            SysUtil.abort();
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handleException((Exception)((Object)e));
            SysUtil.abort();
        }
    }

    protected boolean isShow(DimensionRelationshipGroupInfo info) {
        return true;
    }

    @Override
    protected void btnGroupSearch_actionPerformed(ActionEvent e) throws Exception {
        this.executeQueryGroup();
    }

    @Override
    protected void txtGroupSearch_focusGained(FocusEvent e) throws Exception {
    }

    @Override
    protected void txtGroupSearch_focusLost(FocusEvent e) throws Exception {
        this.executeQueryGroup();
    }

    @Override
    protected void txtRelationShipSearch_focusGained(FocusEvent e) throws Exception {
    }

    @Override
    protected void txtRelationShipSearch_focusLost(FocusEvent e) throws Exception {
        this.executeQueryShip();
    }

    @Override
    protected void btnRelationShipSearch_actionPerformed(ActionEvent e) throws Exception {
        if (this.selectGroupInfo == null) {
            return;
        }
        String filterStr = this.txtRelationShipSearch.getText();
        IRow row = null;
        int size = this.tblRelationShip.getRowCount();
        for (int index = 0; index < size; ++index) {
            row = this.tblRelationShip.getRow(index);
            if (StringUtils.isEmpty((String)filterStr)) {
                row.getStyleAttributes().setHided(false);
                continue;
            }
            if (row.getCell(DimensionConstants.DIMENSION_NUMBER).getValue() == null || row.getCell(DimensionConstants.DIMENSION_NAME).getValue() == null) continue;
            String number = (String)row.getCell(DimensionConstants.DIMENSION_NUMBER).getValue();
            String name = (String)row.getCell(DimensionConstants.DIMENSION_NAME).getValue();
            if (number.indexOf(filterStr) < 0 && name.indexOf(filterStr) < 0) {
                row.getStyleAttributes().setHided(true);
                continue;
            }
            row.getStyleAttributes().setHided(false);
        }
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.setAllSelect(false);
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setAllSelect(true);
    }

    private void setAllSelect(boolean isSelect) {
        int size = this.tblRelationShip.getRowCount();
        for (int index = 0; index < size; ++index) {
            if (this.tblRelationShip.getCell(index, COL_SELECT).getStyleAttributes().isLocked() || this.tblRelationShip.getRow(index).getStyleAttributes().isHided()) continue;
            this.tblRelationShip.getCell(index, COL_SELECT).setValue((Object)isSelect);
        }
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        if (this.selectGroupInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"selectRelationGroup"));
            return;
        }
        MbgViewListResultData newData = new MbgViewListResultData();
        newData.setRelationMap(new MbgRelationMap(null));
        newData.getRelationMap().setGroup(this.selectGroupInfo);
        DimensionRelationshipCollection ships = new DimensionRelationshipCollection();
        for (int r = 0; r < this.tblRelationShip.getRowCount(); ++r) {
            if (!Boolean.TRUE.equals(this.tblRelationShip.getCell(r, COL_SELECT).getValue())) continue;
            ships.add((DimensionRelationshipInfo)this.tblRelationShip.getRow(r).getUserObject());
        }
        if (!ships.isEmpty()) {
            newData.getRelationMap().setRelationShips(ships);
        }
        newData.getRelationMap().setFillWhereNull(this.rdoFill.isSelected());
        this.data = newData;
        this.isCancel = false;
        this.destroyWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.destroyWindow();
    }

    public Object getData() {
        return this.data;
    }

    public void dataChanged(DataChangeEvent eventObj) {
        if (eventObj.getNewValue() == null || eventObj.getNewValue() instanceof MbgViewListResultData) {
            this.data = (MbgViewListResultData)eventObj.getNewValue();
        }
    }

    public boolean isCanceled() {
        return this.isCancel;
    }

    public void reShow() {
        this.txtGroupSearch.setText("");
        this.txtRelationShipSearch.setText("");
        this.rdoNoFill.setSelected(true);
        if (this.data != null) {
            this.selectGroupInfo = this.data.getRelationMap().getGroup();
            if (this.data.getRelationMap().isFillWhereNull()) {
                this.rdoFill.setSelected(true);
            }
        } else {
            this.selectGroupInfo = null;
        }
        try {
            IDimensionRelationshipGroup iDimensionRelationshipGroup;
            if (this.selectGroupInfo != null && this.selectGroupInfo.getId() != null && !(iDimensionRelationshipGroup = DimensionRelationshipGroupFactory.getRemoteInstance()).exists((IObjectPK)new ObjectUuidPK(this.selectGroupInfo.getId()))) {
                return;
            }
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            this.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        try {
            this.executeQueryGroup();
            this.loadTempTable();
            this.executeQueryShip();
            this.selectShips();
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    private void selectShips() {
        int i;
        if (this.data == null || this.data.getRelationMap() == null || this.data.getRelationMap().getRelationShips() == null) {
            return;
        }
        HashSet<String> ships = new HashSet<String>();
        for (i = 0; i < this.data.getRelationMap().getRelationShips().size(); ++i) {
            ships.add(this.data.getRelationMap().getRelationShips().get(i).getDimensionNumber());
        }
        if (ships.isEmpty()) {
            return;
        }
        for (i = 0; i < this.tblRelationShip.getRowCount(); ++i) {
            this.tblRelationShip.getCell(i, COL_SELECT).setValue((Object)ships.contains(((DimensionRelationshipInfo)this.tblRelationShip.getRow(i).getUserObject()).getDimensionNumber()));
        }
    }

    public void setMultiSelect(boolean multiSelect) {
    }

    @Override
    protected void btnUnSelect_actionPerformed(ActionEvent e) throws Exception {
        int size = this.tblRelationShip.getRowCount();
        for (int index = 0; index < size; ++index) {
            if (this.tblRelationShip.getCell(index, COL_SELECT).getStyleAttributes().isLocked()) continue;
            if (this.tblRelationShip.getCell(index, COL_SELECT).getValue() instanceof Boolean && ((Boolean)this.tblRelationShip.getCell(index, COL_SELECT).getValue()).booleanValue()) {
                this.tblRelationShip.getCell(index, COL_SELECT).setValue((Object)false);
                continue;
            }
            this.tblRelationShip.getCell(index, COL_SELECT).setValue((Object)true);
        }
    }
}

