/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.bicomponent.layout.DivSpanPanel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.TemplateException;
import com.kingdee.eas.ma.mbg.client.AbstractSetLayoutUI;
import com.kingdee.eas.ma.mbg.client.common.ComponentDragSourceForSetLayout;
import com.kingdee.eas.ma.mbg.client.common.PanelDropTargetForMBGView;
import com.kingdee.eas.ma.mbg.client.common.PanelDropTargetForSetLayout;
import com.kingdee.eas.ma.mbg.client.utils.SetLayoutHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SetLayoutUI
extends AbstractSetLayoutUI
implements PanelDropTargetForMBGView.IGetComponent {
    private static final long serialVersionUID = 1L;
    private boolean isCancel = true;
    private IBgDimensionManager dimensionManager = null;
    protected FullOrgUnitInfo orgUnitInfo = null;
    protected Map<String, List<BgDimensionInfo>> returnMap = new HashMap<String, List<BgDimensionInfo>>();
    public static final String ISROLL = "ISROLL";
    public static final String SHOW_HIDE_PANEL = "SHOW_HIDE_PANEL";
    private Map dimComponentMap = new HashMap();
    private Map<String, KDWorkButton> componentMap = new HashMap<String, KDWorkButton>();
    private DivSpanPanel dsp = new DivSpanPanel();
    ContainerListener cl = new ContainerListener(){

        @Override
        public void componentAdded(ContainerEvent e) {
            this.fireSpanChanged();
            ((KDPanel)e.getSource()).updateUI();
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            this.fireSpanChanged();
            ((KDPanel)e.getSource()).updateUI();
        }

        private void fireSpanChanged() {
            int r = SetLayoutUI.this.pnlLeftBottom.getComponentCount();
            int c = SetLayoutUI.this.pnlRightTop.getComponentCount();
            String[] rows = new String[r];
            String[] cols = new String[c];
            SetLayoutUI.this.dsp.setDiv(rows, cols);
            SetLayoutUI.this.dsp.updateUI();
        }
    };

    public void onLoad() throws Exception {
        super.onLoad();
        this.dimensionManager = (IBgDimensionManager)this.getUIContext().get("dimensionManager");
        this.orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("orgUnitInfo");
        this.loadData();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.enableEvents(64L);
        this.pnlPage.setLayout((LayoutManager)new FlowLayout(3));
        this.pnlLeftBottom.setLayout((LayoutManager)new FlowLayout(3));
        this.pnlRightTop.setLayout((LayoutManager)new FlowLayout(3));
        this.pnlHide.setLayout((LayoutManager)new FlowLayout(3));
        this.pnlPage.setName(Integer.toString(2));
        this.pnlLeftBottom.setName(Integer.toString(3));
        this.pnlRightTop.setName(Integer.toString(4));
        this.pnlHide.setName(Integer.toString(6));
        boolean isRoll = Boolean.TRUE.equals(this.getUIContext().get(ISROLL));
        new PanelDropTargetForSetLayout(this, (JPanel)this.pnlLeftBottom, 3, null, isRoll);
        new PanelDropTargetForSetLayout(this, (JPanel)this.pnlRightTop, 4, null, isRoll);
        new PanelDropTargetForSetLayout(this, (JPanel)this.pnlPage, 2, null, isRoll);
        new PanelDropTargetForSetLayout(this, (JPanel)this.pnlHide, 6, null, isRoll);
        this.pnlLeftBottom.addContainerListener(this.cl);
        this.pnlRightTop.addContainerListener(this.cl);
        this.pnlPage.addContainerListener(this.cl);
        this.pnlHide.addContainerListener(this.cl);
        this.pnlLeftTop.setLayout((LayoutManager)new BorderLayout());
        this.pnlLeftTop.add((Component)this.dsp, (Object)"Center");
        this.setHidePanel();
    }

    private void setHidePanel() {
        if (!Boolean.TRUE.equals(this.getUIContext().get(SHOW_HIDE_PANEL))) {
            this.pnlLayout.remove((Component)this.lblHide);
            this.pnlLayout.remove((Component)this.pnlHide);
            int width = this.pnlHide.getX() - this.pnlPage.getX() - this.pnlPage.getWidth() + this.pnlHide.getWidth();
            this.resizeOther((JComponent)this.pnlPage, width);
            this.resizeOther((JComponent)this.pnlRightTop, width);
            this.resizeOther((JComponent)this.pnlData, width);
        }
    }

    private void resizeOther(JComponent comp, int width) {
        if (comp.getClientProperty(BgBaseConstants.KDLAYOUT) instanceof KDLayout.Constraints) {
            KDLayout.Constraints cst = (KDLayout.Constraints)comp.getClientProperty(BgBaseConstants.KDLAYOUT);
            cst.originalBounds.width += width;
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.tblColumnEdit.setColumnMoveable(true);
        this.btnCancel.setEnabled(true);
        this.btnOK.setEnabled(true);
    }

    public void loadData() throws EASBizException, BOSException {
        super.loadFields();
        this.loadLayout(this.getDimensionManager().getPageDisplayDimension(), this.pnlPage);
        this.loadLayout(this.getDimensionManager().getRowDisplayDimension(), this.pnlLeftBottom);
        this.loadLayout(this.getDimensionManager().getColDisplayDimension(), this.pnlRightTop);
        this.loadLayout(this.getDimensionManager().getHideDisplayDimension(), this.pnlHide);
        this.loadTblColumnEdit();
    }

    public void loadTblColumnEdit() throws BOSException, EASBizException {
        SetLayoutHelper.loadTblColumnEdit(this.tblColumnEdit, this.getDimensionManager());
    }

    private void loadLayout(List dimensions, KDPanel pnl) {
        BgDimensionInfo bgDimensionInfo = null;
        for (int i = 0; i < dimensions.size(); ++i) {
            bgDimensionInfo = (BgDimensionInfo)dimensions.get(i);
            KDWorkButton btn = new KDWorkButton();
            btn.setText(bgDimensionInfo.getName());
            btn.setName(bgDimensionInfo.getNumber());
            int type = 2;
            ComponentDragSourceForSetLayout.createDragSource(this, (Component)btn, bgDimensionInfo, type);
            pnl.add((Component)btn, null);
            this.dimComponentMap.put(bgDimensionInfo.getNumber(), bgDimensionInfo);
            this.componentMap.put(bgDimensionInfo.getNumber(), btn);
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionOK_actionPerformed(e);
        this.verifyData();
        this.setCancel(false);
        this.returnMap.clear();
        this.returnMap.put("page", this.getCurPageDimensions());
        this.returnMap.put("row", this.getCurRowDimensions());
        this.returnMap.put("col", this.getCurColDimensions());
        this.returnMap.put("hide", this.getCurHideDimensions());
        this.storeTblColumn();
        this.getUIWindow().close();
    }

    public Map<String, List<BgDimensionInfo>> getReturnMap() {
        return this.returnMap;
    }

    public void verifyData() throws Exception {
        List<BgDimensionInfo> rowDimensions = this.getRowDimensionsFromPnl();
        if (rowDimensions == null || rowDimensions.size() == 0) {
            throw new TemplateException(TemplateException.ROWORCOLDIMENSIONISNULL);
        }
        List<BgDimensionInfo> colDimensions = this.getColDimensionsFromPnl();
        if (colDimensions == null || colDimensions.size() == 0) {
            throw new TemplateException(TemplateException.ROWORCOLDIMENSIONISNULL);
        }
    }

    private List<BgDimensionInfo> getRowDimensionsFromPnl() {
        return this.getDimension(this.pnlLeftBottom);
    }

    private List<BgDimensionInfo> getColDimensionsFromPnl() {
        return this.getDimension(this.pnlRightTop);
    }

    private void storeTblColumn() {
        SetLayoutHelper.storeTblColumn(this.tblColumnEdit, this.getDimensionManager());
    }

    private List<BgDimensionInfo> getCurPageDimensions() {
        return this.getDimension(this.pnlPage);
    }

    private List<BgDimensionInfo> getCurRowDimensions() {
        return this.getDimension(this.pnlLeftBottom);
    }

    private List<BgDimensionInfo> getCurColDimensions() {
        return this.getDimension(this.pnlRightTop);
    }

    private List<BgDimensionInfo> getCurHideDimensions() {
        return this.getDimension(this.pnlHide);
    }

    private List<BgDimensionInfo> getDimension(KDPanel parent) {
        ArrayList<BgDimensionInfo> hList = new ArrayList<BgDimensionInfo>();
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            if (!this.dimComponentMap.containsKey(c.getName())) continue;
            hList.add((BgDimensionInfo)this.dimComponentMap.get(c.getName()));
        }
        return hList;
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.setCancel(true);
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public IBgDimensionManager getDimensionManager() {
        return this.dimensionManager;
    }

    public void reloadTblColumn() {
        try {
            this.storeTblColumn();
            SetLayoutHelper.loadTblColumnEdit(this.tblColumnEdit, this.getDimensionManager(), this.getCurRowDimensions(), this.getCurColDimensions());
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    @Override
    public JComponent getDimensionComponent(Object dimension) {
        if (dimension instanceof BgDimensionInfo) {
            return (JComponent)this.componentMap.get(((BgDimensionInfo)dimension).getNumber());
        }
        return null;
    }
}

