/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgItemCollection;
import com.kingdee.eas.ma.base.BgItemInfo;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.client.AbstractSumBgItemFormulaPickerUI;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.client.utils.SumNewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgItemObject;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaCheckHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class SumBgItemFormulaPickerUI
extends AbstractSumBgItemFormulaPickerUI {
    private static final Logger logger = CoreUIObject.getLogger(SumBgItemFormulaPickerUI.class);
    public String sumItemFormula = null;
    public BgItemCollection subItems = null;

    public SumBgItemFormulaPickerUI() throws Exception {
        this.lblSumFormula.setIcon(EASResource.getIcon((String)"imgLableword_btn"));
        this.btnPlus.setText(null);
        this.btnPlus.setIcon(EASResource.getIcon((String)"imgTbtn_plussign"));
        this.btnMinus.setText(null);
        this.btnMinus.setIcon(EASResource.getIcon((String)"imgTbtn_minussign"));
        this.btnMultiply.setText(null);
        this.btnMultiply.setIcon(EASResource.getIcon((String)"imgTbtn_multiplysign"));
        this.btnDivide.setText(null);
        this.btnDivide.setIcon(EASResource.getIcon((String)"imgTbtn_dividesign"));
        this.btnClear.setText(null);
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnInsert.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.txtExpression.setMaxLength(4000);
        this.mltBgItemF7.setEditable(false);
        this.btnMultiply.setVisible(false);
        this.btnMultiply.setEnabled(false);
        this.btnDivide.setVisible(false);
        this.btnDivide.setEnabled(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiCtx = super.getUIContext();
        this.sumItemFormula = uiCtx.get("SUMITEMFORMULA") != null ? uiCtx.get("SUMITEMFORMULA").toString() : "";
        NewDimensionMemberSelectDialog memberF7 = this.getDimensionMemberSelectDialog();
        this.mltBgItemF7.setSelector((KDPromptSelector)memberF7);
        this.txtExpression.setSelectAllOnFocus(false);
        this.txtExpression.setText(this.sumItemFormula);
    }

    protected NewDimensionMemberSelectDialog getDimensionMemberSelectDialog() {
        return new SumNewDimensionMemberSelectDialog(this, (DimensionInfo)null, SysContext.getSysContext().getCurrentCostUnit().getId().toString(), false, false);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (!this.checkFormula(this.txtExpression.getText().toString())) {
            return;
        }
        this.sumItemFormula = this.txtExpression.getText() != null ? this.txtExpression.getText().toString() : "";
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        super.btnClear_actionPerformed(e);
        this.txtExpression.setText("");
        this.txtExpression.requestFocus();
    }

    @Override
    public void insertOperatorAction_actionPerformed(ActionEvent e) throws Exception {
        super.insertOperatorAction_actionPerformed(e);
        int ch = 0;
        Object src = e.getSource();
        if (src == this.btnPlus) {
            ch = 43;
        } else if (src == this.btnMinus) {
            ch = 45;
        } else if (src == this.btnMultiply) {
            ch = 42;
        } else if (src == this.btnDivide) {
            ch = 47;
        } else if (src == this.btnInsert) {
            ch = 105;
        }
        this.insertOperator((char)ch);
        this.txtExpression.setCaretPosition(this.txtExpression.getText().length());
    }

    private void insertOperator(char ch) {
        String txtInsert = null;
        int pos = this.txtExpression.getCaretPosition();
        if (this.canInsert(ch)) {
            if (ch != '(') {
                if (ch == 'i') {
                    if (this.mltBgItemF7.getValue() != null) {
                        if (this.mltBgItemF7.getValue() instanceof BgItemInfo) {
                            txtInsert = ((BgItemInfo)this.mltBgItemF7.getValue()).getNumber().trim();
                        } else if (this.mltBgItemF7.getValue() instanceof BgItemCollection) {
                            BgItemCollection itemCollection = ((BgItemObject)this.mltBgItemF7.getValue()).getResult();
                            txtInsert = itemCollection.get(0).getNumber().trim();
                        } else if (this.mltBgItemF7.getValue() instanceof List) {
                            List members = (List)this.mltBgItemF7.getValue();
                            BgDimensionMember member = (BgDimensionMember)members.get(0);
                            txtInsert = "\"" + DimensionFormulaHelper.getCombination(member.getSrcNumber(), member.getNumber()) + "\"";
                        }
                    }
                } else {
                    txtInsert = Character.toString(ch);
                }
                this.txtExpression.insert(txtInsert, pos);
            } else {
                this.txtExpression.insert("()", pos);
                this.txtExpression.setCaretPosition(pos + 1);
            }
        }
    }

    private boolean canInsert(char ch) {
        boolean res = false;
        String line = this.txtExpression.getText();
        String regexp = null;
        if (ch == 'i') {
            regexp = "[\\+|\\-|\\*|\\/]{1}+";
        } else if (ch == '+' || ch == '-' || ch == '*' || ch == '/') {
            regexp = "[^\\+|^\\-|^\\*|^\\/|^\\s]{1,}";
        }
        Pattern pt = Pattern.compile(regexp);
        Matcher matcher = pt.matcher(line);
        int scanIndex = line.length() == 0 ? line.length() : line.length() - 1;
        res = matcher.find(scanIndex) | (ch == 'i' && line.length() == 0);
        return res;
    }

    private boolean checkFormula(String s) throws EASBizException {
        if (s == null || s.length() == 0) {
            return true;
        }
        DimensionFormulaCheckHelper parser2 = new DimensionFormulaCheckHelper();
        parser2.checkExpress(s);
        return true;
    }
}

