/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.newrpt.client.designer.io.WizzardIO;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;

public class TemplateWizzardIO
extends WizzardIO {
    protected BgTemplateInfo bgTemplate = null;
    protected OrgUnitInfo orgUnitInfo = null;
    private final SimpleFileFilter Filter_PDF = new SimpleFileFilter("pdf", "pdf" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_HTML = new SimpleFileFilter(new String[]{"htm", "html"}, this.getLocalText("Key_Page"));
    private final SimpleFileFilter Filter_Excel2003 = new SimpleFileFilter("xls", "MS Excel2003" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_Excel2007 = new SimpleFileFilter("xlsx", "MS Excel2007" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_KDF = new SimpleFileFilter("kdf", "KDTable" + this.getLocalText("Key_File"));
    private final SimpleFileFilter Filter_XML = new SimpleFileFilter("xml", "xml" + this.getLocalText("Key_Table"));
    private File file = new File(System.getProperty("user.dir") + "\\export.properties");

    public BgTemplateInfo getBgTemplate() {
        return this.bgTemplate;
    }

    public OrgUnitInfo getOrgUnitInfo() {
        return this.orgUnitInfo;
    }

    public TemplateWizzardIO(Dialog parent, SpreadContext context) {
        super(parent, context);
    }

    public TemplateWizzardIO(Frame parent, SpreadContext context) {
        super(parent, context);
    }

    public TemplateWizzardIO(Dialog parent, SpreadContext context, OrgUnitInfo orgUnitInfo, BgTemplateInfo bgTemplate) {
        super(parent, context);
        this.orgUnitInfo = orgUnitInfo;
        this.bgTemplate = bgTemplate;
        this.initDialog();
    }

    public TemplateWizzardIO(Frame parent, SpreadContext context, OrgUnitInfo orgUnitInfo, BgTemplateInfo bgTemplate) {
        super(parent, context);
        this.orgUnitInfo = orgUnitInfo;
        this.bgTemplate = bgTemplate;
        this.initDialog();
    }

    private void initDialog() {
        this.setSize(500, 300);
        this.setResizable(false);
        this._chsFile = this.createFileChooser();
    }

    private KDFileChooser createFileChooser() {
        KDFileChooser chsFile = new KDFileChooser();
        chsFile.setDialogTitle(this.getLocalText("Key_File"));
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_XML);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_Excel2003);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_Excel2007);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_KDF);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_PDF);
        chsFile.addChoosableFileFilter((FileFilter)this.Filter_HTML);
        chsFile.setFileFilter((FileFilter)this.Filter_XML);
        return chsFile;
    }

    private String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, WizzardIO.class, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"23_WizzardIO"));
    }

    public boolean prepare() {
        boolean prepare = super.prepare();
        if (this._isForImport) {
            this.setDefaultFilePath();
        }
        return prepare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDefaultFilePath() {
        InputStream is = null;
        try {
            if (this.file.exists()) {
                Properties properties = new Properties();
                is = new FileInputStream(this.file);
                properties.load(is);
                String value = properties.getProperty("exportPath");
                if (!StringUtils.isEmpty((String)value)) {
                    File tmp = new File(value);
                    String path = tmp.getParent();
                    String filename = tmp.getName();
                    String fileType = filename.substring(filename.lastIndexOf(".") + 1);
                    if ("xml".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
                    } else if ("xls".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_Excel2003);
                    } else if ("xlsx".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_Excel2007);
                    } else if ("pdf".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_PDF);
                    } else if ("htm".equalsIgnoreCase(fileType) || "html".equalsIgnoreCase(fileType)) {
                        this._chsFile.setFileFilter((FileFilter)this.Filter_HTML);
                    }
                    String separator = File.separator;
                    this._chsFile.setCurrentDirectory(new File(path));
                }
            } else {
                File file = this._chsFile.getCurrentDirectory();
                if (file != null) {
                    file = new File(file.getPath());
                    this._chsFile.setFileFilter((FileFilter)this.Filter_XML);
                    this._chsFile.setSelectedFile(file);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

