/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.mbg.UserGroupFactory;
import com.kingdee.eas.ma.mbg.UserGroupInfo;
import com.kingdee.eas.ma.mbg.UserGroupRefFactory;
import com.kingdee.eas.ma.mbg.UserGroupRefInfo;
import com.kingdee.eas.ma.mbg.client.AbstractUserGroupListUI;
import com.kingdee.eas.ma.mbg.client.UserGroupEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class UserGroupListUI
extends AbstractUserGroupListUI {
    private static final long serialVersionUID = -6700884635106080300L;
    private static final Logger logger = CoreUIObject.getLogger(UserGroupListUI.class);
    private static final String RES = "com.kingdee.eas.ma.mbg.MbgPermissionResource";
    private static final String COL_ID = "id";
    private static final String COL_USER = "user";
    private IMutexServiceControl imsc = MutexServiceControlFactory.getRemoteInstance();

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn(COL_USER).setRenderer((IBasicRender)new UserRander());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        int first = e.getFirstRow();
        int last = e.getLastRow();
        HashMap<String, TreeSet<UserInfo>> userMap = new HashMap<String, TreeSet<UserInfo>>();
        HashSet<String> groupIDs = new HashSet<String>();
        for (int rowIndex = first; rowIndex <= last; ++rowIndex) {
            groupIDs.add(this.tblMain.getRow(rowIndex).getCell(COL_ID).getValue().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("userGroup.id", groupIDs, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo(COL_ID));
        selector.add(new SelectorItemInfo("user.id"));
        selector.add(new SelectorItemInfo("user.number"));
        selector.add(new SelectorItemInfo("user.name"));
        view.setSelector(selector);
        CoreBaseCollection colls = null;
        try {
            colls = UserGroupRefFactory.getRemoteInstance().getCollection(view);
        }
        catch (BOSException exc) {
            this.handUIException(exc);
        }
        if (colls != null && colls.size() > 0) {
            for (int i = 0; i < colls.size(); ++i) {
                String groupID = ((UserGroupRefInfo)colls.get(i)).getUserGroup().getId().toString();
                UserInfo user = ((UserGroupRefInfo)colls.get(i)).getUser();
                TreeSet<UserInfo> userSet = (TreeSet<UserInfo>)userMap.get(groupID);
                if (userSet == null) {
                    userSet = new TreeSet<UserInfo>(new Comparator<UserInfo>(){

                        @Override
                        public int compare(UserInfo o1, UserInfo o2) {
                            return o1.getNumber().compareTo(o2.getNumber());
                        }
                    });
                    userMap.put(groupID, userSet);
                }
                userSet.add(user);
            }
        }
        for (int rowIndex = first; rowIndex <= last; ++rowIndex) {
            IRow row = this.tblMain.getRow(rowIndex);
            Set userSet = (Set)userMap.get(row.getCell(COL_ID).getValue().toString());
            if (userSet == null) continue;
            row.getCell(COL_USER).setValue((Object)userSet);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int isComfirm;
        this.checkSelected();
        if (!this.requestMutexLock(this.getSelectedKeyValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"lockMsg"));
            SysUtil.abort();
        }
        if ((isComfirm = MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"confirmDel"))) != 0) {
            return;
        }
        HashSet idSet = new HashSet(this.getSelectedIdValues());
        Map deleteBatch = UserGroupFactory.getRemoteInstance().deleteBatch(idSet);
        Set cantDelGroups = (Set)deleteBatch.get("PER");
        Set bgUGLightAppSettingRefs = (Set)deleteBatch.get("LA");
        if (cantDelGroups.size() == 0 && bgUGLightAppSettingRefs.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"deleteSuccess"));
        } else {
            int failCount = cantDelGroups.size() + bgUGLightAppSettingRefs.size();
            int successCount = idSet.size() - failCount;
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(EASResource.getString((String)RES, (String)"delPartialSuccess", (Object[])new Object[]{idSet.size()}));
            if (successCount > 0) {
                errorMsg.append(EASResource.getString((String)RES, (String)"delSuccessItem", (Object[])new Object[]{successCount}));
            }
            errorMsg.append(EASResource.getString((String)RES, (String)"delFailItem", (Object[])new Object[]{failCount}));
            StringBuffer errorDetail = new StringBuffer();
            for (UserGroupInfo userGroup : cantDelGroups) {
                errorDetail.append(EASResource.getString((String)RES, (String)"delFailDetail", (Object[])new Object[]{userGroup.getNumber()})).append("\n");
            }
            for (UserGroupInfo info : bgUGLightAppSettingRefs) {
                errorDetail.append(EASResource.getString((String)RES, (String)"delFailDetail1", (Object[])new Object[]{info.getNumber()})).append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)errorMsg.toString(), (String)errorDetail.toString(), (int)2);
        }
        this.refreshList();
    }

    protected String getEditUIName() {
        return UserGroupEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return UserGroupFactory.getRemoteInstance();
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        EntityViewInfo view = (EntityViewInfo)viewInfo.clone();
        FilterInfo filter = view.getFilter();
        if (filter != null) {
            if (filter.getFilterItems().size() > 0 && filter.getMaskString() != null && filter.getMaskString().length() > 0) {
                filter.setMaskString("(" + filter.getMaskString() + ")");
            }
        } else {
            filter = new FilterInfo();
            filter.setMaskString("");
        }
        view.setFilter(filter);
        OrgUnitInfo currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)currOrgUnit.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.longnumber", (Object)(currOrgUnit.getLongNumber() + "!%"), CompareType.LIKE));
        if (filter.getFilterItems().size() <= 2) {
            filter.setMaskString("( #0 or #1 )");
        } else {
            filter.setMaskString(filter.getMaskString() + " and ( #" + (filter.getFilterItems().size() - 2) + " or #" + (filter.getFilterItems().size() - 1) + " )");
        }
        return super.getQueryExecutor(queryPK, view);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    public void onShow() throws Exception {
        super.onShow();
        IUIWindow window = this.getUIWindow();
        if (!(window instanceof KDFrame) && window instanceof Dialog) {
            ((Dialog)window).setSize(Toolkit.getDefaultToolkit().getScreenSize());
        }
    }

    protected boolean requestMutexLock(String id) {
        return this.imsc.requestObjIDForUpdate(id);
    }

    private class UserRander
    extends CellTextRender {
        private UserRander() {
        }

        public String getText(Object text) {
            if (text instanceof Set) {
                StringBuffer userBuf = new StringBuffer();
                for (Object obj : (Set)text) {
                    if (!(obj instanceof UserInfo)) continue;
                    UserInfo user = (UserInfo)obj;
                    userBuf.append(user.getName()).append("; ");
                }
                if (userBuf.length() > 0) {
                    userBuf.delete(userBuf.length() - 2, userBuf.length());
                }
                return userBuf.toString();
            }
            return super.getText(text);
        }
    }
}

