/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.VersionCopyFactory;
import com.kingdee.eas.ma.mbg.VersionCopyInfo;
import com.kingdee.eas.ma.mbg.client.AbstractVersionConvertUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class VersionConvertUI
extends AbstractVersionConvertUI {
    private static final long serialVersionUID = -5147151927231101451L;
    private static final Logger logger = CoreUIObject.getLogger(VersionConvertUI.class);
    private BgSchemeDimensionHelper schemeHelper = null;

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("InitDataObject") instanceof VersionCopyInfo) {
            VersionCopyInfo info = (VersionCopyInfo)this.getUIContext().get("InitDataObject");
            this.prmtBgScheme.setData((Object)info.getBgScheme());
            this.prmtTargetVersion.setData((Object)info.getTargetVersion());
            this.prmtSourceVersion.setData((Object)info.getSourceVersion());
        }
        this.initBgSchemeF7();
    }

    private OrgUnitInfo getCurrCostCenter() {
        return SysContext.getSysContext().getCurrentCostUnit();
    }

    protected void initBgSchemeF7() throws Exception {
        BgNFCHelper.setSchemeView(this.prmtBgScheme, this.getCurrCostCenter(), false, BgNFCHelper.getSourceType((IUIObject)this), false, true);
        BgNFCHelper.setDefaultBgScheme(this.prmtBgScheme, BgNFCHelper.getSourceType((IUIObject)this), this.getCurrCostCenter());
    }

    @Override
    protected void prmtBgScheme_willShow(SelectorEvent e) throws Exception {
        super.prmtBgScheme_willShow(e);
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        BgSchemeInfo oldValue = (BgSchemeInfo)e.getOldValue();
        BgSchemeInfo newValue = (BgSchemeInfo)e.getNewValue();
        if (BgCommCHelper.isEqualsPK((IObjectValue)newValue, (IObjectValue)oldValue) || newValue == null) {
            return;
        }
        this.schemeHelper = new BgSchemeDimensionHelper(newValue.getId().toString());
        this.prmtSourceVersion.setValue(null);
        DimensionMemberSelectHelper.addIdFilter(this.prmtSourceVersion, DimensionConstants.DEF_VERSION_NUMBER, this.schemeHelper);
        this.prmtTargetVersion.setValue(null);
        DimensionMemberSelectHelper.addIdFilter(this.prmtTargetVersion, DimensionConstants.DEF_VERSION_NUMBER, this.schemeHelper);
    }

    @Override
    protected void prmtSourceVersion_willShow(SelectorEvent e) throws Exception {
        super.prmtSourceVersion_willShow(e);
        this.checkSelectBgScheme(e);
    }

    @Override
    protected void prmtTargetVersion_willShow(SelectorEvent e) throws Exception {
        super.prmtTargetVersion_willShow(e);
        this.checkSelectBgScheme(e);
    }

    protected void checkSelectBgScheme(SelectorEvent e) {
        if (!(this.prmtBgScheme.getData() instanceof BgSchemeInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeResource", (String)"please.choose.scheme"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnConvert_actionPerformed(ActionEvent e) throws Exception {
        super.btnConvert_actionPerformed(e);
        if (!this.verify()) {
            return;
        }
        LongTimeDialog dialog = null;
        if (dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                VersionCopyFactory.getRemoteInstance().startConvert(((BgSchemeInfo)VersionConvertUI.this.prmtBgScheme.getData()).getId().toString(), ((BgVersionInfo)VersionConvertUI.this.prmtTargetVersion.getData()).getId().toString(), ((BgVersionInfo)VersionConvertUI.this.prmtSourceVersion.getData()).getId().toString());
                MsgBox.showInfo((Component)((Object)VersionConvertUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource", (String)"convertSuccess"));
                return "success";
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    public boolean verify() {
        StringBuffer stringInfo = new StringBuffer();
        if (this.prmtBgScheme.getData() == null) {
            this.prmtBgScheme.requestFocus();
            stringInfo.append(this.contBgScheme.getBoundLabelText());
            stringInfo.append(",");
        }
        if (this.prmtSourceVersion.getData() == null) {
            this.prmtSourceVersion.requestFocus();
            stringInfo.append(this.contSourceVersion.getBoundLabelText());
            stringInfo.append(",");
        }
        if (this.prmtTargetVersion.getData() == null) {
            this.prmtTargetVersion.requestFocus();
            stringInfo.append(this.contTargetVersion.getBoundLabelText());
            stringInfo.append(",");
        }
        if (stringInfo.length() != 0) {
            stringInfo.deleteCharAt(stringInfo.length() - 1);
            MsgBox.showWarning((Component)((Object)this), (String)(stringInfo + EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource.versionCopyVerify")));
            return false;
        }
        BgVersionInfo source = (BgVersionInfo)this.prmtSourceVersion.getData();
        BgVersionInfo target = (BgVersionInfo)this.prmtTargetVersion.getData();
        if (source.getId().equals((Object)target.getId())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.VersionCopyResource", (String)"sourceAndTargetVersionSame"));
            return false;
        }
        return true;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }
}

