/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.client.utils.IViewDimensionMemberF7;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.client.AbstractViewListFormRelationBaseF7UI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.client.utils.DimensionRelationClientHelper;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.util.StringUtils;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public abstract class ViewListFormRelationBaseF7UI
extends AbstractViewListFormRelationBaseF7UI
implements IViewDimensionMemberF7,
IGetSchemeHelper {
    private static final long serialVersionUID = -2323303316975669224L;
    private static final Logger logger = CoreUIObject.getLogger(ViewListFormRelationBaseF7UI.class);
    protected boolean isCancel = true;
    protected MbgViewListResultData data = null;
    private CostCenterOrgUnitInfo orgUnit = null;
    private FullOrgUnitInfo unionGroupInfo = null;
    private DimensionCacheHelper cacheHelper = new DimensionCacheHelper(null);

    public CostCenterOrgUnitInfo getOrgUnit() {
        return this.orgUnit;
    }

    public FullOrgUnitInfo getUnionGroupInfo() {
        return this.unionGroupInfo;
    }

    public DimensionCacheHelper getCacheHelper() {
        return this.cacheHelper;
    }

    public void onLoad() throws Exception {
        this.readOrgUnit();
        super.onLoad();
    }

    private void readOrgUnit() throws Exception {
        if (this.getUIContext().get("ROWCOLORG_ID") != null) {
            String rowColOrgId = (String)this.getUIContext().get("ROWCOLORG_ID");
            this.orgUnit = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectStringPK(rowColOrgId));
        } else {
            String orgId = (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
            this.orgUnit = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectStringPK(orgId));
        }
        String groupOrgId = (String)this.getUIContext().get("GROUPORG_ID");
        if (groupOrgId != null) {
            this.unionGroupInfo = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectStringPK(groupOrgId));
        }
    }

    public void dataChanged(DataChangeEvent eventObj) {
        if (this.data == eventObj.getNewValue()) {
            return;
        }
        this.data = (MbgViewListResultData)eventObj.getNewValue();
        this.cbxGroup.removeAllItems();
        this.cbxGroup.addItem((Object)this.data.getRelationMap().getGroup());
    }

    @Override
    public final BgSchemeDimensionHelper getSchemeHelper() throws EASBizException, BOSException {
        if (this.getUIContext().get("BGSCHEME_HELPER") != null) {
            return (BgSchemeDimensionHelper)this.getUIContext().get("BGSCHEME_HELPER");
        }
        return DimensionMemberSelectHelper.getSchemeHelper(this.getUIContext().get("Owner"));
    }

    @Override
    protected void cbxGroup_itemStateChanged(ItemEvent e) throws Exception {
        DimensionRelationshipGroupInfo group;
        super.cbxGroup_itemStateChanged(e);
        if (e != null && e.getStateChange() == 1) {
            DimensionRelationshipGroupInfo group2 = (DimensionRelationshipGroupInfo)e.getItem();
            this.tblMain.removeRows();
            this.loadTempTable();
            this.fillValueToTable(group2);
            this.tblMain.getColumn(DimensionConstants.ORGUNIT2).getStyleAttributes().setHided(true);
            if (this.tblMain.getColumn(DimensionConstants.ISENABLE2) != null) {
                this.tblMain.getColumn(DimensionConstants.ISENABLE2).getStyleAttributes().setHided(true);
            }
        } else if (e != null && e.getStateChange() == 2 && (group = (DimensionRelationshipGroupInfo)e.getItem()) == null) {
            return;
        }
    }

    protected void loadTempTable() throws Exception {
        if (this.getGroupInfo() != null) {
            DimensionRelationClientHelper.loadTempTable(this, this.tblMain, this.getGroupInfo(), this.orgUnit, this.getUnionGroupInfo(), this.getSchemeHelper(), false);
        }
    }

    protected DimensionRelationshipGroupInfo getGroupInfo() {
        if (this.cbxGroup.getSelectedItem() != null) {
            return this.getCacheHelper().getRelationGroup(((DimensionRelationshipGroupInfo)this.cbxGroup.getSelectedItem()).getId().toString());
        }
        return null;
    }

    protected void fillValueToTable(DimensionRelationshipGroupInfo group) throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
    }

    public static void processPeriodN(DimensionRelationshipCollection shipCol) throws EASBizException, BOSException {
        int i;
        HashSet<String> bgPeriodNumbers = new HashSet<String>();
        DimensionRelationshipInfo info = null;
        String oldDimNum = null;
        String oldDimName = null;
        Object newDimNum = null;
        String newDimName = null;
        for (int i2 = 0; i2 < shipCol.size(); ++i2) {
            info = shipCol.get(i2);
            oldDimNum = info.getDimensionNumber();
            oldDimName = info.getDimensionName();
            Object newNumber = null;
            String[] arrNums = oldDimNum.split(",");
            for (int m = 0; m < arrNums.length; ++m) {
                String[] strNums;
                String arrNum = arrNums[m];
                if (arrNum.indexOf(":") <= 0 || !DimensionConstants.DEF_PERIOD_SRCNUMBER.equals((strNums = arrNum.split(":"))[0])) continue;
                bgPeriodNumbers.add(strNums[1]);
            }
        }
        HashMap<String, BgPeriodInfo> periodMap = new HashMap<String, BgPeriodInfo>();
        EntityViewInfo views = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", bgPeriodNumbers, CompareType.INCLUDE));
        views.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isLeaf");
        sic.add("longnumber");
        views.getSelector().addObjectCollection((IObjectCollection)sic);
        SorterItemInfo sore = new SorterItemInfo("longNumber");
        sore.setSortType(SortType.DESCEND);
        views.getSorter().add(sore);
        BgPeriodCollection coll = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(views);
        if (coll != null) {
            for (i = 0; i < coll.size(); ++i) {
                periodMap.put(coll.get(i).getNumber(), coll.get(i));
            }
        }
        if (!periodMap.isEmpty()) {
            block3: for (i = 0; i < shipCol.size(); ++i) {
                info = shipCol.get(i);
                oldDimNum = info.getDimensionNumber();
                oldDimName = info.getDimensionName();
                String newNumber = null;
                String[] arrNums = oldDimNum.split(",");
                String[] arrNames = oldDimName.split(DimensionConstants.TICK_SEPARATOR);
                for (int m = 0; m < arrNums.length; ++m) {
                    String[] strNums;
                    String arrNum = arrNums[m];
                    String arrName = arrNames[m];
                    if (arrNum.indexOf(":") <= 0 || !DimensionConstants.DEF_PERIOD_SRCNUMBER.equals((strNums = arrNum.split(":"))[0])) continue;
                    newNumber = strNums[1];
                    if (!periodMap.containsKey(newNumber) || !BgPeriodNVariableHelper.checkCanConvert((String)arrName)) continue block3;
                    newDimName = oldDimName.replace(arrName, ((BgPeriodInfo)periodMap.get(newNumber)).getName());
                    info.setDimensionName(newDimName);
                    continue block3;
                }
            }
        }
    }

    protected void fillValueToTable(DimensionRelationshipCollection dimRelationCol, DimensionRelationshipGroupInfo groupInfo, String filterStr) throws EASBizException, BOSException {
        DimensionRelationshipInfo shipInfo = null;
        ViewListFormRelationBaseF7UI.processPeriodN(dimRelationCol);
        HashSet<String> relationDimNumber = new HashSet<String>();
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            relationDimNumber.add((String)row.getCell(DimensionConstants.DIMENSION_NUMBER).getValue());
        }
        boolean CanDeleteTemplateMembers = this.isCanDeleteTemplateMembers();
        int rowSize = 0;
        int startRow = this.tblMain.getRowCount();
        int j = dimRelationCol.size();
        for (int i = 0; i < j; ++i) {
            shipInfo = dimRelationCol.get(i);
            if (!StringUtils.isEmpty((String)filterStr) && shipInfo.getDimensionName().indexOf(filterStr) < 0 && shipInfo.getDimensionNumber().indexOf(filterStr) < 0 || relationDimNumber.contains(shipInfo.getDimensionNumber())) continue;
            relationDimNumber.add(shipInfo.getDimensionNumber());
            row = this.tblMain.addRow();
            row.setUserObject((Object)shipInfo);
            if (shipInfo.isFromTemplate() && !CanDeleteTemplateMembers) {
                row.getCell("select").getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(BgNConstants.LOCK_COLOR);
            }
            row.getCell("select").setValue((Object)false);
            row.getCell(DimensionConstants.DIMENSION_NUMBER).setValue((Object)shipInfo.getDimensionNumber());
            row.getCell(DimensionConstants.DIMENSION_NAME).setValue((Object)shipInfo.getDimensionName());
            row.getCell(DimensionConstants.DIMENSION_ORGUNIT).setValue((Object)this.orgUnit);
            row.getCell(DimensionConstants.DIMENSION_ORGUNIT_ID).setValue((Object)this.orgUnit.getId().toString());
            ++rowSize;
        }
        KDTDataRequestEvent e1 = new KDTDataRequestEvent(this.tblMain);
        e1.setFirstRow(startRow);
        e1.setLastRow(startRow + rowSize - 1);
        DimensionRelationClientHelper.initRowValue(this, e1, this.tblMain, groupInfo, true, this.getOrgUnit(), this.getUnionGroupInfo(), this.getSchemeHelper());
    }

    protected boolean isCanDeleteTemplateMembers() {
        boolean canDeleteTemplateMembers = false;
        try {
            IMbgViewBase viewBase;
            ViewListProvider provider;
            if (this.getUIContext().get("provider") instanceof ViewListProvider && (provider = (ViewListProvider)this.getUIContext().get("provider")).getEditValue() instanceof BgFormInfo && (viewBase = ((BgFormInfo)provider.getEditValue()).getBgTemplate().getView()) instanceof MbgViewListManager) {
                canDeleteTemplateMembers = ((MbgViewListSheetManager)((MbgViewListManager)viewBase).getSheetManagers().get(0)).isCanDeleteTemplateMembers();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return canDeleteTemplateMembers;
    }

    public void setMultiSelect(boolean multiSelect) {
    }

    public Object getData() throws BOSException, EASBizException {
        return this.data;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public boolean isCanceled() {
        return this.isCancel;
    }
}

