/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.DimensionRelationshipCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.client.AbstractViewListFormRelationDeleteF7UI;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ViewListFormRelationDeleteF7UI
extends AbstractViewListFormRelationDeleteF7UI {
    private static final long serialVersionUID = 2576186065237525323L;
    private static final Logger logger = CoreUIObject.getLogger(ViewListFormRelationDeleteF7UI.class);
    private Map<String, Map<String, BgNViewDataInfo>> bgDataMap = null;
    private Map<String, Map<String, BgAdjustFormDiversityData>> adjustMap = null;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtSearch, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtSearch.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    try {
                        ViewListFormRelationDeleteF7UI.this.btnSearch_actionPerformed(null);
                    }
                    catch (Exception e1) {
                        ViewListFormRelationDeleteF7UI.this.handUIExceptionAndAbort(e1);
                    }
                }
            }
        });
    }

    @Override
    protected void fillValueToTable(DimensionRelationshipGroupInfo group) throws EASBizException, BOSException {
        this.tblMain.checkParsed();
        this.tblMain.removeRows();
        if (this.data != null && this.data.getRelationMap() != null) {
            this.fillValueToTable(this.data.getRelationMap().getRelationShips(), this.data.getRelationMap().getGroup(), this.txtSearch.getText());
        }
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        int type;
        super.btnDelete_actionPerformed(e);
        LinkedHashMap<String, DimensionRelationshipInfo> numbers = new LinkedHashMap<String, DimensionRelationshipInfo>();
        Sheet curSheet = (Sheet)this.getUIContext().get("sheet");
        int size = this.tblMain.getRowCount();
        for (int rowIndex = 0; rowIndex < size; ++rowIndex) {
            IRow row = this.tblMain.getRow(rowIndex);
            if (!((Boolean)row.getCell("select").getValue()).booleanValue()) continue;
            DimensionRelationshipInfo info = (DimensionRelationshipInfo)row.getUserObject();
            numbers.put(info.getDimensionNumber(), info);
        }
        if (numbers.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        if (this.kDDeleteData.isSelected()) {
            type = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionAddNewResource", (String)"synDelFormAndDimensionRelaRecord"));
            if (type == 2 || type == 1) {
                return;
            }
            type = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionAddNewResource", (String)"deleRelationAndData"));
            if (type == 2 || type == 1) {
                return;
            }
            HashMap<String, Object> paramete = new HashMap<String, Object>();
            paramete.put("paramete", new HashSet(numbers.keySet()));
            paramete.put("groupInfo", this.getGroupInfo());
            paramete.put("ORGUNIT_ID", this.getOrgUnit().getId().toString());
            if (this.getGroupInfo().isIsCsl()) {
                paramete.put("GROUPORG_ID", this.getUnionGroupInfo().getId().toString());
            }
            curSheet.setUserObject("deletedRelations", paramete);
        } else {
            type = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionAddNewResource", (String)"deleRelationAndData"));
            if (type == 2 || type == 1) {
                return;
            }
        }
        String bgFormId = (String)this.getUIContext().get("BGFORM_ID");
        String orgId = null;
        orgId = this.getUIContext().get("ROWCOLORG_ID") != null ? (String)this.getUIContext().get("ROWCOLORG_ID") : (String)this.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        String groupUnitId = (String)this.getUIContext().get("GROUPORG_ID");
        MbgViewListSheetManager sheet = (MbgViewListSheetManager)this.getUIContext().get("sheetManager");
        MbgViewListManager view = sheet.getView();
        MbgViewListDimensionInfo dimension = (MbgViewListDimensionInfo)this.getUIContext().get("dimension");
        ViewListProvider provider = (ViewListProvider)this.getUIContext().get("provider");
        List versionNumbers = this.getVerisonNumbers(sheet, numbers);
        Object[] layouts = DimensionCommonHelper.searchViewListLayout(sheet, dimension);
        String layout = (String)layouts[0];
        int layoutIndex = (Integer)layouts[1];
        StringBuffer sb = new StringBuffer();
        Set<String> formulas = this.getFormulas(bgFormId, orgId, view, sheet.getSheetIndex(), layout, layoutIndex, this.getGroupInfo().getId().toString(), new HashSet(numbers.keySet()), this.getSchemeHelper(), groupUnitId);
        String currentFormulas = this.getFormulaString(orgId, formulas);
        if (curSheet.getUserObject("deletedFormulasFromAddMember") != null) {
            sb.append((String)curSheet.getUserObject("deletedFormulasFromAddMember").getValue());
            sb.append("@@");
        }
        sb.append(currentFormulas);
        curSheet.setUserObject("deletedFormulasFromAddMember", (Object)sb.toString());
        MbgViewListResultData data1 = new MbgViewListResultData();
        MbgRelationMap relationMap = new MbgRelationMap(null);
        relationMap.setGroup(this.data.getRelationMap().getGroup());
        relationMap.getRelationShips().addCollection(this.data.getRelationMap().getRelationShips());
        data1.setRelationMap(relationMap);
        DimensionRelationshipCollection colls = relationMap.getRelationShips();
        for (int index = colls.size() - 1; index >= 0; --index) {
            DimensionRelationshipInfo shipInfo = colls.get(index);
            if (!numbers.containsKey(shipInfo.getDimensionNumber())) continue;
            colls.remove(shipInfo);
        }
        this.data = data1;
        this.txtSearch.setText("");
        this.fillValueToTable(this.getGroupInfo());
        this.isCancel = false;
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        int size = this.tblMain.getRowCount();
        for (int index = 0; index < size; ++index) {
            if (this.tblMain.getCell(index, "select").getStyleAttributes().isLocked()) continue;
            this.tblMain.getCell(index, "select").setValue((Object)true);
        }
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnClearAll_actionPerformed(e);
        int size = this.tblMain.getRowCount();
        for (int index = 0; index < size; ++index) {
            this.tblMain.getCell(index, "select").setValue((Object)false);
        }
    }

    @Override
    protected void btnSearch_actionPerformed(ActionEvent e) throws Exception {
        super.btnSearch_actionPerformed(e);
        this.fillValueToTable(this.getGroupInfo());
    }

    @Override
    protected void txtSearch_focusLost(FocusEvent e) throws Exception {
        super.txtSearch_focusLost(e);
        this.fillValueToTable(this.getGroupInfo());
    }

    @Override
    protected void txtSearch_focusGained(FocusEvent e) throws Exception {
        super.txtSearch_focusGained(e);
        this.fillValueToTable(this.getGroupInfo());
    }

    public void reShow() {
    }

    private Set<String> getFormulas(String bgFormId, String orgUnitId, MbgViewListManager viewManager, int sheetIndex, String layout, int layoutIndex, String relationGroupId, Set relationDimNumber, BgSchemeDimensionHelper schemeHelper, String groupUnitId) throws BOSException {
        Object formulaString = null;
        MbgViewListSheetManager _sheet = null;
        _sheet = viewManager.getSheetManagers().size() == 1 ? (MbgViewListSheetManager)viewManager.getSheetManagers().get(0) : (MbgViewListSheetManager)viewManager.getSheetManagers().get(sheetIndex);
        MbgViewListSheetManager sheet = DimensionCommonHelper.cloneSheetManager(_sheet);
        MbgRelationMap relation = null;
        if ("page".equals(layout)) {
            relation = this.searchRelationMap(relationGroupId, sheet.getDimensionManager().getPageRelationMaps());
        } else {
            List<IMbgViewListObject> rows = null;
            rows = "row".equals(layout) ? sheet.getDimensionManager().getRows() : sheet.getDimensionManager().getColumns();
            MbgViewListRowCol rowObj = (MbgViewListRowCol)rows.get(layoutIndex);
            rows.clear();
            rows.add(rowObj);
            relation = this.searchRelationMap(relationGroupId, rowObj.getRelationMaps());
        }
        if (relation == null) {
            return null;
        }
        HashMap<String, DimensionRelationshipInfo> relationMap = new HashMap<String, DimensionRelationshipInfo>();
        for (int i = 0; i < relation.getRelationShips().size(); ++i) {
            relationMap.put(relation.getRelationShips().get(i).getDimensionNumber(), relation.getRelationShips().get(i));
        }
        HashSet<String> formulas = new HashSet<String>();
        DimensionRelationshipCollection backup = new DimensionRelationshipCollection();
        for (String dimNumber : relationDimNumber) {
            backup.clear();
            backup.addCollection(relation.getRelationShips());
            relation.getRelationShips().clear();
            if (relationMap.containsKey(dimNumber)) {
                relation.getRelationShips().add((DimensionRelationshipInfo)relationMap.get(dimNumber));
                formulas.addAll(MBGViewListFormClientHelper.buildFormula(sheet, schemeHelper, null));
            }
            relation.getRelationShips().clear();
            relation.getRelationShips().addCollection(backup);
        }
        return formulas;
    }

    private MbgRelationMap searchRelationMap(String relationGroupId, List<MbgRelationMap> relationMaps) {
        if (relationMaps == null || relationMaps.isEmpty() || relationGroupId == null) {
            return null;
        }
        for (int i = 0; i < relationMaps.size(); ++i) {
            if (!relationMaps.get(i).getGroup().getId().toString().equals(relationGroupId)) continue;
            return relationMaps.get(i);
        }
        return null;
    }

    public Map<String, Map<String, BgNViewDataInfo>> getBgDataMap() {
        return this.bgDataMap;
    }

    public void setBgDataMap(Map<String, Map<String, BgNViewDataInfo>> bgDataMap) {
        this.bgDataMap = bgDataMap;
    }

    public Map<String, Map<String, BgAdjustFormDiversityData>> getAdjustMap() {
        return this.adjustMap;
    }

    public void setAdjustMap(Map<String, Map<String, BgAdjustFormDiversityData>> adjustMap) {
        this.adjustMap = adjustMap;
    }

    private List getVerisonNumbers(MbgViewListSheetManager sheetManager, Map<String, DimensionRelationshipInfo> numbers) {
        ArrayList<String> versionNubmers;
        block8: {
            List selectMembers;
            block9: {
                MbgViewListDimensionInfo dimension;
                block7: {
                    versionNubmers = new ArrayList<String>();
                    dimension = (MbgViewListDimensionInfo)this.getUIContext().get("dimension");
                    String versionNumber = (String)this.getUIContext().get("ROWCOLVERSION_NUMBER");
                    selectMembers = null;
                    if (versionNumber == null) break block7;
                    versionNubmers.add(versionNumber);
                    break block8;
                }
                if (!dimension.getNumber().equalsIgnoreCase(MBGLayoutConstants.BG_VERSION)) break block9;
                for (String next : numbers.keySet()) {
                    versionNubmers.add(numbers.get(next).getDimensionGroup().getNumber());
                }
                break block8;
            }
            BgDimensionBaseInfo searchDimension = DimensionCommonHelper.searchDimension(MBGLayoutConstants.BG_VERSION, sheetManager.getDimensionManager().getDimension());
            if (searchDimension.getLayout().equals("row")) {
                searchDimension = DimensionCommonHelper.searchDimension(MBGLayoutConstants.BG_VERSION, sheetManager.getDimensionManager().getRowDimension());
                selectMembers = searchDimension.getSelectMembers();
            } else if (searchDimension.getLayout().equals("col")) {
                searchDimension = DimensionCommonHelper.searchDimension(MBGLayoutConstants.BG_VERSION, sheetManager.getDimensionManager().getColDimension());
                selectMembers = searchDimension.getSelectMembers();
            } else if (searchDimension.getLayout().equals("page")) {
                searchDimension = DimensionCommonHelper.searchDimension(MBGLayoutConstants.BG_VERSION, sheetManager.getDimensionManager().getPageDimension());
                selectMembers = searchDimension.getSelectMembers();
            }
            if (selectMembers == null) break block8;
            for (int i = 0; i < selectMembers.size(); ++i) {
                versionNubmers.add(BgViewHelper.getNumber(selectMembers.get(i)));
            }
        }
        return versionNubmers;
    }

    private String getFormulaString(String orgUnitId, Set<String> formulas) {
        String formulasString = null;
        if (formulas.size() > 0) {
            StringBuffer formulasSb = new StringBuffer();
            for (String formula : formulas) {
                String formulaStr = orgUnitId + "##" + formula;
                formulasSb.append(formulaStr).append("@@");
            }
            if (formulasSb.length() > 0) {
                formulasString = formulasSb.toString();
                formulasString = formulasString.substring(0, formulasString.length() - 2);
            }
        }
        return formulasString;
    }

    private void resetBgDataInfo(List formulas, String orgId, List versionNumbers) {
        for (int j = 0; j < formulas.size(); ++j) {
            for (int i = 0; i < versionNumbers.size(); ++i) {
                MBGViewListFormClientHelper.createNullData(this.getBgDataMap(), orgId, (String)formulas.get(j), (String)versionNumbers.get(i));
            }
        }
    }

    private void resetBgAdjustData(List formulas, String orgId) {
        for (int j = 0; j < formulas.size(); ++j) {
            String formula = (String)formulas.get(j);
            if (this.getAdjustMap() == null || orgId == null) {
                return;
            }
            Map<String, BgAdjustFormDiversityData> subMap = null;
            if (!this.getAdjustMap().containsKey(orgId) || !(subMap = this.getAdjustMap().get(orgId)).containsKey(formula.toString())) continue;
            BgAdjustFormDiversityData data = subMap.get(formula.toString());
            data.setNewValue(null);
        }
    }
}

