/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.mbg.client.AbstractViewListRowColPropertySetUI;
import com.kingdee.eas.ma.mbg.client.ViewListLayoutDesignerUI;
import com.kingdee.eas.ma.mbg.common.IMbgViewListStyle;
import com.kingdee.eas.ma.mbg.common.MBgViewListStyleAttributes;
import com.kingdee.eas.ma.mbg.utils.ViewListStyleHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ViewListRowColPropertySetUI
extends AbstractViewListRowColPropertySetUI {
    private static final long serialVersionUID = -5956271381194954036L;
    private static final Logger logger = CoreUIObject.getLogger(ViewListRowColPropertySetUI.class);
    private Map<String, String> sizeStrMapToPt = new HashMap<String, String>();
    private Map<String, String> sizePtMapToStr = new HashMap<String, String>();
    protected List<IMbgViewListStyle> styles = null;
    private MBgViewListStyleAttributes style = null;
    private IMbgViewListStyle styleObject = null;
    private MBgViewListStyleAttributes oldStyle = null;
    private boolean isModifySave = false;

    public void setModifySave(boolean isModifySave) {
        this.isModifySave = isModifySave;
    }

    public boolean isModifySave() {
        return this.isModifySave;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnBold.setOpaque(false);
        this.btnBold.setBorder(null);
        this.btnBold.setFactType(0);
        this.btnItalic.setOpaque(false);
        this.btnItalic.setBorder(null);
        this.btnItalic.setFactType(0);
        this.btnUnderLine.setOpaque(false);
        this.btnUnderLine.setBorder(null);
        this.btnUnderLine.setFactType(0);
        this.initFontComb();
        this.initFontSizeComb();
        this.initFontComboColor();
        this.styleObject = this.loadStyleData();
        this.oldStyle = this.styleObject == null || this.styleObject.getStyle() == null ? this.loadDefaultStyle() : this.styleObject.getStyle();
        this.style = this.oldStyle.clone();
        this.loadData();
    }

    private MBgViewListStyleAttributes loadDefaultStyle() {
        MBgViewListStyleAttributes style = new MBgViewListStyleAttributes();
        style.setFont(ViewListStyleHelper.DEFAULT_FONT);
        return style;
    }

    protected void loadData() {
        if (this.style.getFont() != null) {
            this.setSelectFont(this.style.getFont());
            this.setSelectFontSize(this.style.getFontSize());
        }
        this.btnBold.setSelected(this.style.isBold());
        this.btnItalic.setSelected(this.style.isItalic());
        this.btnUnderLine.setSelected(this.style.isUnderline());
        if (this.style.getFontColor() != null) {
            this.cboColor.setColor(this.style.getFontColor());
        }
        if (this.style.getBackgroundColor() != null) {
            this.cboBackground.setColor(this.style.getBackgroundColor());
        }
        if (Boolean.TRUE.equals(this.getUIContext().get("isReadonly"))) {
            this.chkReadonly.setEnabled(false);
            this.chkReadonly.setSelected(true);
        } else if (this.styleObject != null) {
            this.chkReadonly.setSelected(this.styleObject.isReadonly());
        }
    }

    protected void storeData() {
        this.style.setFont(new Font(this.getSelectFontName(), 0, this.getSelectFontSize()));
        this.style.setBold(this.btnBold.isSelected());
        this.style.setItalic(this.btnItalic.isSelected());
        this.style.setUnderline(this.btnUnderLine.isSelected());
        this.style.setFontColor(this.cboColor.getColor());
        this.style.setBackgroundColor(this.cboBackground.getColor());
    }

    public MBgViewListStyleAttributes getStyle() {
        return this.style;
    }

    public IMbgViewListStyle getStyleObject() {
        return this.styleObject;
    }

    protected IMbgViewListStyle loadStyleData() throws Exception {
        if (this.getUIContext().get("InitDataObject") instanceof List) {
            this.styles = (List)this.getUIContext().get("InitDataObject");
            if (this.styles != null && !this.styles.isEmpty()) {
                return this.styles.get(0);
            }
        }
        return null;
    }

    protected void storeStyleData() {
        if (this.styles != null) {
            for (int i = 0; i < this.styles.size(); ++i) {
                this.styles.get(i).setStyle(this.getStyle());
                this.styles.get(i).setReadonly(this.chkReadonly.isSelected());
            }
        }
    }

    private void initFontComboColor() {
        this.cboColor.setViewType(2);
        this.cboColor.setPictureForViewPic(ResourceManager.getImageIcon((String)"tbtn_fontcolor.gif"));
        this.cboBackground.setViewType(2);
        this.cboBackground.setPictureForViewPic(ResourceManager.getImageIcon((String)"tbtn_fillbgcolor.gif"));
        this.cboBackground.setDefaultColor(KDComboColor.TRANSPARENTCOLOR);
        this.cboBackground.setDefaultColorPrompt(MultiLanguageKeys.getLocalText((String)"KEY_NOFILLCOLOR"));
        this.cboBackground.setColor(KDComboColor.TRANSPARENTCOLOR);
    }

    private void initFontSizeComb() {
        String[][] sysFontSizeAll = new String[][]{{this.getMLS("sizeValue0", "\u521d\u53f7"), "42"}, {this.getMLS("sizeValue1", "\u5c0f\u521d"), "36"}, {this.getMLS("sizeValue2", "\u4e00\u53f7"), "26"}, {this.getMLS("sizeValue3", "\u5c0f\u4e00"), "24"}, {this.getMLS("sizeValue4", "\u4e8c\u53f7"), "22"}, {this.getMLS("sizeValue5", "\u5c0f\u4e8c"), "18"}, {this.getMLS("sizeValue6", "\u4e09\u53f7"), "16"}, {this.getMLS("sizeValue7", "\u5c0f\u4e09"), "15"}, {this.getMLS("sizeValue8", "\u56db\u53f7"), "14"}, {this.getMLS("sizeValue9", "\u5c0f\u56db"), "12"}, {this.getMLS("sizeValue10", "\u4e94\u53f7"), "11"}, {this.getMLS("sizeValue11", "\u5c0f\u4e94"), "9"}, {this.getMLS("sizeValue12", "\u516d\u53f7"), "8"}, {this.getMLS("sizeValue13", "\u5c0f\u516d"), "7"}, {this.getMLS("sizeValue14", "\u4e03\u53f7"), "6"}, {this.getMLS("sizeValue15", "\u516b\u53f7"), "5"}, {"5", "5"}, {"6", "6"}, {"7", "7"}, {"8", "8"}, {"9", "9"}, {"10", "10"}, {"11", "11"}, {"12", "12"}, {"14", "14"}, {"16", "16"}, {"18", "18"}, {"20", "20"}, {"22", "22"}, {"24", "24"}, {"26", "26"}, {"28", "28"}, {"36", "36"}, {"48", "48"}, {"72", "72"}};
        Object[] combValue = new String[sysFontSizeAll.length];
        for (int i = 0; i < sysFontSizeAll.length; ++i) {
            if (StringUtil.equalsIgnoreCase((String)Locale.getDefault().getLanguage(), (String)"en")) {
                this.sizeStrMapToPt.put(sysFontSizeAll[i][0], sysFontSizeAll[i][1]);
                combValue[i] = sysFontSizeAll[i][1];
                this.sizePtMapToStr.put(sysFontSizeAll[i][1], sysFontSizeAll[i][1]);
                continue;
            }
            this.sizeStrMapToPt.put(sysFontSizeAll[i][0], sysFontSizeAll[i][1]);
            if (!this.sizePtMapToStr.containsKey(sysFontSizeAll[i][1])) {
                this.sizePtMapToStr.put(sysFontSizeAll[i][1], sysFontSizeAll[i][0]);
            }
            combValue[i] = sysFontSizeAll[i][0];
        }
        this.cbxFontSize.addItems(combValue);
        this.setSelectFontSize(ViewListStyleHelper.DEFAULT_FONT.getSize());
    }

    private String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)"com.kingdee.bos.ctrl.swing.KDFontChooser", (String)defaultValue);
    }

    private void setSelectFontSize(int fontSize) {
        this.cbxFontSize.setSelectedItem((Object)this.sizePtMapToStr.get(String.valueOf(fontSize)));
    }

    private int getSelectFontSize() {
        String fontSize = (String)this.cbxFontSize.getSelectedItem();
        if (this.sizeStrMapToPt.containsKey(fontSize)) {
            return Integer.parseInt(this.sizeStrMapToPt.get(fontSize));
        }
        return ViewListStyleHelper.DEFAULT_FONT.getSize();
    }

    private void initFontComb() {
        Object[] sysFamilyName = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.cbxFont.addItems(sysFamilyName);
        this.setSelectFont(ViewListStyleHelper.DEFAULT_FONT);
    }

    private void setSelectFont(Font font) {
        this.cbxFont.setSelectedItem((Object)font.getName());
    }

    private String getSelectFontName() {
        return (String)this.cbxFont.getSelectedItem();
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.storeData();
        this.storeStyleData();
        this.synCellData();
        this.setModifySave(true);
        this.getUIWindow().close();
    }

    protected void synCellData() {
        if (this.getUIContext().get("Owner") instanceof ViewListLayoutDesignerUI) {
            ((ViewListLayoutDesignerUI)this.getUIContext().get("Owner")).synCellData(this.styles);
        }
    }

    public boolean isModify() {
        boolean oldReadonly;
        this.storeData();
        boolean bl = oldReadonly = this.styleObject != null && this.styleObject.isReadonly() || Boolean.TRUE.equals(this.getUIContext().get("isReadonly"));
        if (oldReadonly != this.chkReadonly.isSelected()) {
            return true;
        }
        return !this.oldStyle.equals(this.style);
    }

    public boolean checkBeforeWindowClosing() {
        boolean b = super.checkBeforeWindowClosing();
        if (!b) {
            return b;
        }
        if (!this.isModifySave() && this.isModify()) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                this.storeStyleData();
            } else {
                return result == 1;
            }
        }
        return b;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.actionExitCurrent_actionPerformed(e);
    }
}

