/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions;

import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.mbg.BgExamineFacadeFactory;
import com.kingdee.eas.ma.mbg.BgExamineResult;
import com.kingdee.eas.ma.mbg.BgFormAuditFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.IBgExamineFacade;
import com.kingdee.eas.ma.mbg.IBgFormAuditFacade;
import com.kingdee.eas.ma.mbg.client.BgFormAuditIdeaEditUI;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.utils.BgFormAuditClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBgExamineClientUtils;
import com.kingdee.eas.ma.mbg.client.utils.MbgCHelper;
import com.kingdee.eas.ma.mbg.designer.IContextManager;
import com.kingdee.eas.ma.nbudget.BgCourseOperateEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public abstract class ActionBaseAudit
extends AbstractAction {
    private static final long serialVersionUID = -7716343608269661202L;
    private boolean hasExamineCheck = false;
    public LongTimeDialog dialog = null;

    @Override
    protected String getName() {
        return null;
    }

    public void setHasExamineCheck(boolean hasExamineCheck) {
        this.hasExamineCheck = hasExamineCheck;
    }

    public boolean isHasExamineCheck() {
        return this.hasExamineCheck;
    }

    protected void examineCheck(final ActionBaseAudit action, final String billId, final String faceMethod, final boolean showReport) {
        Window win = SwingUtilities.getWindowAncestor((Component)this.uiObj);
        if (win instanceof Frame) {
            this.dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            this.dialog = new LongTimeDialog((Dialog)win);
        }
        if (this.dialog == null) {
            return;
        }
        this.setHasExamineCheck(false);
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                ArrayList<String> billIds = new ArrayList<String>();
                billIds.add(billId);
                Object obj = null;
                try {
                    obj = ActionBaseAudit.this.getBgExamineInterface().examines(billIds);
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)((Component)ActionBaseAudit.this.uiObj), (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                catch (Exception ex) {
                    throw ex;
                }
                return obj;
            }

            public void afterExec(Object result) throws Exception {
                BgExamineResult checkResult = null;
                if (result instanceof List) {
                    result = ((List)result).get(0);
                }
                if (result instanceof BgExamineResult) {
                    checkResult = (BgExamineResult)result;
                    if (!checkResult.result) {
                        MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkExamineNoAudit"));
                    } else {
                        ActionBaseAudit.this.setHasExamineCheck(true);
                    }
                    boolean re = true;
                    if (!StringUtils.isEmpty((String)faceMethod)) {
                        try {
                            Method method = ((Object)((Object)action)).getClass().getMethod(faceMethod, String.class);
                            if (method != null) {
                                re = (Boolean)method.invoke((Object)action, billId);
                            }
                        }
                        catch (Exception ex) {
                            ActionBaseAudit.this.uiObj.handUIException((Throwable)ex);
                        }
                    }
                    BOSUuid bgOrgViewId = null;
                    Object viewId = ActionBaseAudit.this.uiObj.getUIContext().get("BGORGVIEW_ID");
                    if (viewId instanceof BOSUuid) {
                        bgOrgViewId = (BOSUuid)viewId;
                    } else if (viewId instanceof String) {
                        bgOrgViewId = BOSUuid.read((String)viewId.toString());
                    }
                    ArrayList<String> billIds = new ArrayList<String>();
                    billIds.add(billId);
                    if (showReport && re) {
                        MBgExamineClientUtils.getInstance().showCheckReport(checkResult, bgOrgViewId, faceMethod == null, billIds);
                    }
                } else {
                    MsgBox.showError((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkExamineError"));
                }
            }
        });
        this.dialog.show();
    }

    public abstract boolean afterAudit(String var1) throws Exception;

    protected IBgExamineFacade getBgExamineInterface() throws Exception {
        return BgExamineFacadeFactory.getRemoteInstance();
    }

    protected void audit() throws Exception {
        final BgSpreadCoreViewUI baseUI = (BgSpreadCoreViewUI)this.uiObj;
        IContextManager contextManager = baseUI.getContextManager();
        BgFormInfo editData = (BgFormInfo)contextManager.getProvider().getEditValue();
        final String billId = editData.getId().toString();
        final ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(editData.getId().toString());
        final HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_SCHEME_ID", editData.getBgScheme().getId().toString());
        auditParams.put("AUDIT_ORGUNIT_ID", (String)baseUI.getUIContext().get("AUDIT_ORGUNIT_ID"));
        auditParams.put("AUDIT_USER_ID", (String)baseUI.getUIContext().get("AUDIT_USER_ID"));
        auditParams.put("AUDIT_DATA_STATE", String.valueOf(9));
        auditParams.put("AUDIT_BILL_STATE", String.valueOf(2));
        auditParams.put("CHECK_MUTEX", String.valueOf(true));
        auditParams.put("CHECK_REPORT", String.valueOf(true));
        auditParams.put("CHECK_EXAMINE", String.valueOf(true));
        auditParams.put("CHECK_WORKFLOW", String.valueOf(true));
        auditParams.put("AUDIT_COURSE_COMMENT_STATE", BgCourseOperateEnum.Confirm.getName());
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor((Component)this.uiObj);
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
        }
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map obj = null;
                try {
                    obj = BgFormAuditFacadeFactory.getRemoteInstance().auditCheck(billIds, auditParams);
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)((Object)baseUI), (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                return obj;
            }

            public void afterExec(Object _result) throws Exception {
                BOSUuid bgOrgViewId = null;
                Object viewId = ActionBaseAudit.this.uiObj.getUIContext().get("BGORGVIEW_ID");
                if (viewId instanceof BOSUuid) {
                    bgOrgViewId = (BOSUuid)viewId;
                } else if (viewId instanceof String) {
                    bgOrgViewId = BOSUuid.read((String)viewId.toString());
                }
                boolean check = BgFormAuditClientHelper.showCheckResult((Component)((Object)baseUI), bgOrgViewId, billIds, _result);
                if (check) {
                    ActionBaseAudit.this.afterAudit(billId, auditParams);
                }
            }
        });
        this.dialog.show();
    }

    protected boolean afterAudit(String billId, Map<String, String> auditParams) throws Exception {
        boolean audit = false;
        if (billId == null || auditParams == null) {
            return audit;
        }
        BgSpreadCoreViewUI baseUI = (BgSpreadCoreViewUI)this.uiObj;
        IContextManager contextManager = baseUI.getContextManager();
        BgFormInfo editData = (BgFormInfo)contextManager.getProvider().getEditValue();
        int re = MsgBox.showConfirm2((String)(this.getMessageStr("com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", "auditIdea") + editData.getName() + this.getMessageStr("com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", "bgForm")));
        if (re == 1 || re == 2) {
            return audit;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGFORM_PROCESSUI", (Object)baseUI);
        uiContext.put((Object)"BGFORM_AUDIT_TYPE", (Object)"BGFORM_AUDIT");
        uiContext.put((Object)"AUDIT_PARAM", auditParams);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgFormAuditIdeaEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (uiWindow != null && uiWindow.getUIObject() instanceof BgFormAuditIdeaEditUI && !((BgFormAuditIdeaEditUI)uiWindow.getUIObject()).isCancel()) {
            audit = true;
            baseUI.getUIWindow().close();
            MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)baseUI.getUIContext().get("Owner"));
        }
        return audit;
    }

    protected IBgFormAuditFacade getInterface() throws Exception {
        return BgFormAuditFacadeFactory.getRemoteInstance();
    }

    protected String getMessageStr(String sourceStr, String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)sourceStr, (String)key) : "";
    }
}

