/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.base.message.client.MsgAwokeManager;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.progress.IProgressMonitor;
import com.kingdee.eas.fi.newrpt.client.progress.IRunnableWithProgress;
import com.kingdee.eas.fi.newrpt.client.progress.ProgressDialogNew;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.IActionHide;
import com.kingdee.eas.ma.mbg.designer.IContextManager;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ActionCalculate
extends AbstractAction {
    private static final long serialVersionUID = -4319452162791051199L;
    private static final Logger logger = Logger.getLogger((String)ActionCalculate.class.getName());
    private ProgressDialogNew progressDialog;
    private TimeMark mk = null;

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_autocount");
    }

    @Override
    protected boolean hasKeyStroke() {
        return true;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke("F9");
    }

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionCalculator");
    }

    public void actionPerformed(ActionEvent e) {
        BgSpreadCoreViewUI processUI = (BgSpreadCoreViewUI)this.uiObj;
        BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        Book _book = contextManager.getSpreadContext().getBook();
        boolean oldstate = _book.isAutoCalculate();
        _book.setCalculate(true);
        this.calculate(processUI, contextManager.isRunThreadCalc());
        contextManager.setRunThreadCalc(true);
        contextManager.getSpreadContext().getSpread().repaint();
        _book.setCalculate(oldstate);
    }

    public static ProgressDialogNew createProgressDialogNew(CoreUI owner, boolean model) {
        Window ance = null;
        if (owner != null) {
            ance = SwingUtilities.getWindowAncestor((Component)owner);
        }
        MyProgressDialogNew dialog = null;
        if (ance == null) {
            dialog = new MyProgressDialogNew();
        } else if (ance instanceof Dialog) {
            dialog = new MyProgressDialogNew((Dialog)ance, model);
        } else if (ance instanceof Frame) {
            dialog = new MyProgressDialogNew((Frame)ance, model);
        }
        if (dialog != null) {
            dialog.setOwner(owner);
        }
        return dialog;
    }

    protected void calculate(final BgSpreadCoreViewUI processUI, boolean isRunThreadCalc) {
        final BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        if (this.progressDialog == null) {
            this.progressDialog = ActionCalculate.createProgressDialogNew(processUI, true);
        }
        if (this.progressDialog.isVisible()) {
            return;
        }
        try {
            if (isRunThreadCalc) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        MsgAwokeManager msgAwokeManager = MsgAwokeManager.getInstance();
                        synchronized (msgAwokeManager) {
                            try {
                                MsgAwokeManager.getInstance().wait(10000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }.start();
                this.progressDialog.run(false, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        TimeMark mark = ActionCalculate.this.getTimeMark(processUI);
                        try {
                            if (mark != null) {
                                mark.Start();
                            }
                            monitor.beginTask(DesignerResource.getString((String)"calculateBook"), -1);
                            monitor.setTaskName(DesignerResource.getString((String)"calculateBook_PlsWait"));
                            monitor.subTaskBegin(DesignerResource.getString((String)"prepareData"));
                            monitor.subTaskBegin(DesignerResource.getString((String)"calculate"));
                            ActionCalculate.this.runCal();
                            monitor.subTaskBegin(DesignerResource.getString((String)"calculateComplete"));
                        }
                        finally {
                            monitor.done();
                            contextManager.getSpreadContext().getBook().setSkipListeners(false);
                            contextManager.getSpreadContext().getSpread().repaint();
                            if (mark != null) {
                                mark.Stop();
                            }
                            contextManager.getModifyManager().setModified();
                        }
                    }
                }, this.progressDialog);
            } else {
                this.runcalcWithoutThread(processUI);
            }
        }
        catch (Exception e) {
            logger.error((Object)"ActionCalculate error:", (Throwable)e);
        }
    }

    private void runcalcWithoutThread(BgSpreadCoreViewUI processUI) throws Exception {
        TimeMark mark = this.getTimeMark(processUI);
        try {
            if (mark != null) {
                mark.Start();
                mark.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource.runcalc"));
            }
            this.runCal();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ((BookContextManager)processUI.getContextManager()).setRunThreadCalc(true);
            if (mark != null) {
                mark.Stop();
            }
        }
    }

    public void runCal() {
        BgSpreadCoreViewUI processUI = (BgSpreadCoreViewUI)this.getUIObject();
        BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        contextManager.getSpreadContext().getBook().setSkipListeners(true);
        this.beforeCalculate(processUI.getContextManager());
        contextManager.getSpreadContext().getBook().calc();
        this.afterCalculate(processUI.getContextManager());
        contextManager.getSpreadContext().getBook().setSkipListeners(false);
        this.saveBgValue(contextManager.getSpreadContext().getBook());
    }

    protected void beforeCalculate(IContextManager contextManager) {
    }

    protected void afterCalculate(IContextManager contextManager) {
        if (contextManager.getProvider() instanceof ViewListProvider) {
            Book book = ((BookContextManager)contextManager).getSpreadContext().getBook();
            ((ViewListProvider)contextManager.getProvider()).filterDesc(book, book.getActiveSheet());
        }
        this.doHide();
    }

    protected void saveBgValue(Book book) {
        Sheet _sheet = null;
        Cell _cell = null;
        int count = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < count; ++sheetIndex) {
            _sheet = book.getSheet(sheetIndex);
            int rowCount = _sheet.getMaxRowIndex();
            int colCount = _sheet.getMaxColIndex();
            for (int rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (int colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    this.updateCellChangeValueInfo(_cell);
                }
            }
        }
    }

    protected void updateCellChangeValueInfo(Cell cell) {
        if (cell == null) {
            return;
        }
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            Object _obj = null;
            BigDecimal _newValue = null;
            _obj = BgNFSHelper.getValue(cell);
            if (_obj == null) {
                return;
            }
            if (_obj instanceof BigDecimal) {
                _newValue = (BigDecimal)_obj;
            } else {
                try {
                    _newValue = new BigDecimal(_obj.toString());
                }
                catch (Exception ex) {
                    BgNFSHelper.setValue(cell, BgNConstants.ZERO);
                    _newValue = BgNConstants.ZERO;
                }
            }
            this.setBudgetValue(cell, _newValue);
        }
    }

    protected void setBudgetValue(Cell cell, BigDecimal _newValue) {
        BgNFSHelper.setBudgetValue(cell, _newValue);
    }

    protected TimeMark getTimeMark(BgSpreadCoreViewUI ui) {
        if (this.mk == null) {
            this.mk = new TimeMark(ui);
        }
        if (this.mk.isRuning()) {
            return null;
        }
        return this.mk;
    }

    @Override
    protected String getShortDescription() {
        return BgViewClientHelper.getString("ActionCalculateName");
    }

    @Override
    protected String getLongDescription() {
        return BgViewClientHelper.getString("ActionCalculateName");
    }

    protected void doHide() {
        BgSpreadCoreViewUI ui = (BgSpreadCoreViewUI)this.uiObj;
        if (ui != null && ui instanceof IActionHide) {
            try {
                ((IActionHide)((Object)ui)).doHide();
            }
            catch (Exception e1) {
                ui.handUIExceptionAndAbort(e1);
            }
        }
    }

    class TimeMark {
        BgSpreadCoreViewUI ui;
        boolean isRuning = false;
        long time = 0L;

        public TimeMark(BgSpreadCoreViewUI _ui) {
            this.ui = _ui;
        }

        public boolean isRuning() {
            return this.isRuning;
        }

        public void Start() {
            this.isRuning = true;
            this.time = System.currentTimeMillis();
        }

        public void Stop() {
            StringBuffer msg = new StringBuffer();
            msg.append(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.RptMenuTextResource.calcTime"));
            msg.append(Long.toString(System.currentTimeMillis() - this.time));
            msg.append(" ms");
            this.showSuccessMsg(msg.toString());
            this.isRuning = false;
        }

        public void showSuccessMsg(String msg) {
            this.ui.setMessageIcon(BgSpreadCoreViewUI.SHOW_MESSAGE_ICON_OK);
            this.ui.setMessageBgcolor(BgSpreadCoreViewUI.SHOW_MESSAGE_BG_OK);
            this.ui.setMessageText(msg);
            this.ui.showMessage();
        }
    }

    private static class MyProgressDialogNew
    extends ProgressDialogNew {
        private static final long serialVersionUID = 1L;

        protected MyProgressDialogNew() {
        }

        protected MyProgressDialogNew(Frame owner, boolean modal) {
            super(owner, modal);
        }

        protected MyProgressDialogNew(Dialog owner, boolean modal) {
            super(owner, modal);
        }

        protected void setOwner(CoreUI owner) {
            this.owner = owner;
        }

        public void dispose() {
            super.dispose();
            if (this.owner != null) {
                BgSpreadCoreViewUI processUi;
                this.owner.requestFocus();
                if (this.owner instanceof BgSpreadCoreViewUI && (processUi = (BgSpreadCoreViewUI)this.owner).getContextManager() instanceof BookContextManager) {
                    ((BookContextManager)processUi.getContextManager()).getSpreadContext().getSpread().requestFocus();
                }
            }
        }
    }
}

