/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.mbg.AbstractBgDecomposeFormInfo;
import com.kingdee.eas.ma.mbg.BgDecomposeFormInfo;
import com.kingdee.eas.ma.mbg.BgDecomposeManagerFactory;
import com.kingdee.eas.ma.mbg.BgDecomposeRefOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.BgDecomposerScaleUI;
import com.kingdee.eas.ma.mbg.client.BgFormDecomposeViewProcessUI;
import com.kingdee.eas.ma.mbg.client.BgFormViewListDecomposeProcessUI;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.RangeDecomposeCellUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.decprocess.BgFormDecomposeViewListProvider;
import com.kingdee.eas.ma.mbg.client.decprocess.BgFormDecomposeViewProvider;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewBase;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.AbstractProvider;
import com.kingdee.eas.ma.mbg.utils.BgDecomposeManageHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class ActionDecomposeManage
extends AbstractAction {
    private static final long serialVersionUID = -3271273894418553687L;
    private static final Logger logger = Logger.getLogger((String)ActionDecomposeManage.class.getName());
    private static LongTimeDialog longTimeDialog = null;
    private BookContextManager contextManager = null;
    private SpreadContext spreadContext = null;
    private Sheet sheet = null;
    private BgSchemeDimensionHelper schemeHelper = null;

    public BookContextManager getContextManager() {
        return this.contextManager;
    }

    public SpreadContext getSpreadContext() {
        return this.spreadContext;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    protected String getType() {
        return null;
    }

    protected String getTitle() {
        return null;
    }

    protected String getState() {
        return null;
    }

    @Override
    protected Icon getIcon() {
        if (this.getType() != null) {
            if (this.getType().equals("0") || this.getType().equals("1") || this.getType().equals("2")) {
                return EASResource.getIcon((String)"imgTbtn_courseweave");
            }
            if (this.getType().equals("3")) {
                return EASResource.getIcon((String)"imgTbtn_declarecollect");
            }
            if (this.getType().equals("4")) {
                return EASResource.getIcon((String)"imgTbtn_linkviewlist");
            }
        }
        return EASResource.getIcon((String)"imgTbtn_courseweave");
    }

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected String getName() {
        return null;
    }

    protected String getDecomposerManageUI() {
        if (this.getType().equals("0") || this.getType().equals("1") || this.getType().equals("2")) {
            return BgDecomposerScaleUI.class.getName();
        }
        if (this.getType().equals("3") || this.getType().equals("4")) {
            return RangeDecomposeCellUI.class.getName();
        }
        return BgDecomposerScaleUI.class.getName();
    }

    public BgSchemeDimensionHelper getSchemeHelper(String schemeid) throws EASBizException, BOSException {
        if (this.schemeHelper == null) {
            this.schemeHelper = new BgSchemeDimensionHelper(schemeid);
        }
        return this.schemeHelper;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.getType().equals("0") || this.getType().equals("1") || this.getType().equals("2")) {
            this.actionPerformScale();
        } else if (this.getType().equals("3") || this.getType().equals("4")) {
            this.actionPerformRange();
        }
    }

    protected void actionPerformScale() {
        AbstractProvider provider;
        BgSpreadCoreViewUI baseUI = (BgSpreadCoreViewUI)this.getUIObject();
        this.contextManager = (BookContextManager)baseUI.getContextManager();
        this.spreadContext = this.contextManager.getSpreadContext();
        Book book = this.spreadContext.getBook();
        BgDecomposeFormInfo info = null;
        if (this.getUIObject() instanceof BgFormViewListDecomposeProcessUI) {
            provider = (BgFormDecomposeViewListProvider)this.contextManager.getProvider();
            info = ((BgFormDecomposeViewListProvider)provider).getBgDecomposeFormInfo();
        } else if (this.getUIObject() instanceof BgFormDecomposeViewProcessUI) {
            provider = (BgFormDecomposeViewProvider)this.contextManager.getProvider();
            info = ((BgFormDecomposeViewProvider)provider).getBgDecomposeFormInfo();
        }
        if (info == null) {
            return;
        }
        BgDecomposeRefOrgUnitCollection collection = info.getRefOrgUnit();
        HashSet<BOSUuid> orgIds = new HashSet<BOSUuid>();
        orgIds.add(info.getOrgUnit().getId());
        for (int i = 0; i < collection.size(); ++i) {
            orgIds.add(collection.get(i).getOrgUnitID());
        }
        try {
            this.decomposeScale(baseUI, this.contextManager.getProvider(), book, orgIds, info);
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    protected void decomposeScale(CoreUI baseUI, final IProvider provider, final Book book, final Set orgIds, final BgDecomposeFormInfo info) throws Exception {
        UIContext uiContext = new UIContext((Object)baseUI);
        this.sheet = book.getActiveSheet();
        this.getSchemeHelper(info.getBgScheme().getId().toString());
        TreeModel treeModel = BgOrgUnitUtils.loadBgOrgTreeModel(null, null, null, this.schemeHelper.getBgOrgViewId(), true, null, false);
        BgOrgUnitCollection coll = BgDecomposeManageHelper.allOrgTree(treeModel);
        BgOrgUnitCollection colls = BgDecomposeManageHelper.getDecomposeRefOrgUnit(orgIds, this.schemeHelper.getBgOrgViewId());
        Vector<BgOrgUnitInfo> orgUnits = new Vector<BgOrgUnitInfo>();
        HashMap<String, BgOrgUnitInfo> haveDataOrg = new HashMap<String, BgOrgUnitInfo>();
        for (int i = 0; i < colls.size(); ++i) {
            BgOrgUnitInfo cCOrginfo = colls.get(i);
            orgUnits.add(cCOrginfo);
            haveDataOrg.put(cCOrginfo.getId().toString(), cCOrginfo);
        }
        Map<String, BigDecimal> formulas = null;
        Map formula = null;
        if (this.getType().equals("2")) {
            formulas = BgDecomposeManageHelper.dealWithRangeFormula(this.getSheet(), info.getOrgUnit().getNumber(), info.getBgForm().getBgVersion().getNumber());
            if (formulas.isEmpty()) {
                MsgBox.showWarning((Component)baseUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"formulaDataScale"));
                return;
            }
            if (formulas.containsKey("exitsOtherOrg")) {
                MsgBox.showWarning((Component)baseUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"exitsOtherOrg"));
                return;
            }
            if (formulas.containsKey("exitsOtherVersion")) {
                MsgBox.showWarning((Component)baseUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"exitsOtherVersion"));
                return;
            }
            formula = BgDecomposeManagerFactory.getRemoteInstance().checkCanEditDataMap(null, formulas, info);
            if (formula.isEmpty()) {
                MsgBox.showWarning((Component)baseUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"formulaDataScale"));
                return;
            }
        }
        uiContext.put((Object)"decomposeFormInfo", (Object)info);
        uiContext.put((Object)"perantLNum", (Object)((BgOrgUnitInfo)orgUnits.get(orgUnits.size() - 1)).getLongNumber());
        uiContext.put((Object)"orgUnits", orgUnits);
        uiContext.put((Object)"refOrgUnitCol", (Object)coll);
        uiContext.put((Object)"haveDataOrg", haveDataOrg);
        uiContext.put((Object)"book", (Object)book);
        uiContext.put((Object)"type", (Object)this.getType());
        uiContext.put((Object)"UI_Title", (Object)this.getTitle());
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getDecomposerManageUI(), (Map)uiContext, null, OprtState.EDIT);
            uiWindow.show();
        }
        catch (UIException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        if (uiWindow != null && ((BgDecomposerScaleUI)uiWindow.getUIObject()).isCancel()) {
            return;
        }
        final BgDecomposerScaleUI scaleUI = (BgDecomposerScaleUI)uiWindow.getUIObject();
        final Map orgProportion = scaleUI.getData();
        if (orgProportion == null) {
            return;
        }
        try {
            LongTimeDialog dialog = null;
            if (dialog == null) {
                IUIWindow win = this.uiObj.getUIWindow();
                if (win instanceof Frame) {
                    dialog = new LongTimeDialog((Frame)win);
                } else if (win instanceof Dialog) {
                    dialog = new LongTimeDialog((Dialog)win);
                }
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    Map<String, BigDecimal> formula = ActionDecomposeManage.this.dealWithFormula(provider, book, scaleUI, orgIds, info);
                    ActionDecomposeManage.this.saveDecomposeManage(orgProportion, formula, info);
                    return null;
                }

                public void afterExec(Object result) throws Exception {
                }
            });
            dialog.show();
        }
        catch (Exception exc) {
            logger.error((Object)"", (Throwable)exc);
            ExceptionHandler.handle((Throwable)exc);
        }
    }

    protected Map<String, BigDecimal> dealWithFormula(IProvider provider, Book book, BgDecomposerScaleUI scaleUI, Set orgIds, BgDecomposeFormInfo info) throws Exception {
        Map dataMap = null;
        Map<String, BigDecimal> formulas = null;
        Map bgDataInfoMap = null;
        BgNViewDataInfo bgDataInfo = null;
        String[] str = null;
        if (this.getType().equals("0") || this.getType().equals("1")) {
            if (provider != null) {
                List sheetList = BgNFSHelper.toList(scaleUI.getSheetName());
                dataMap = BgDecomposeManagerFactory.getRemoteInstance().queryAllBookBgData((IObjectValue)info.getBgForm(), sheetList);
                Iterator iterOrg = dataMap.entrySet().iterator();
                while (iterOrg.hasNext()) {
                    Map.Entry entryOrg = iterOrg.next();
                    bgDataInfoMap = (Map)entryOrg.getValue();
                    if (!((String)entryOrg.getKey()).equals(info.getOrgUnit().getId().toString())) {
                        iterOrg.remove();
                        continue;
                    }
                    Iterator iterData = bgDataInfoMap.entrySet().iterator();
                    while (iterData.hasNext()) {
                        Map.Entry entryData = iterData.next();
                        str = ((String)entryData.getKey()).split("_");
                        if (!str[1].equals(info.getBgForm().getBgVersion().getNumber())) {
                            iterData.remove();
                            continue;
                        }
                        bgDataInfo = (BgNViewDataInfo)entryData.getValue();
                        if (bgDataInfo.getActualValueNoDef() == null) continue;
                        iterData.remove();
                    }
                }
            } else {
                formulas = BgDecomposeManageHelper.getFormulaMapOfBook(book, scaleUI.getSheetName(), info.getOrgUnit().getNumber(), info.getBgForm().getBgVersion().getNumber());
            }
        } else if (this.getType().equals("2")) {
            formulas = BgDecomposeManageHelper.dealWithRangeFormula(this.getSheet(), info.getOrgUnit().getNumber(), info.getBgForm().getBgVersion().getNumber());
        }
        Map formula = BgDecomposeManagerFactory.getRemoteInstance().checkCanEditDataMap(dataMap, formulas, info);
        return formula;
    }

    protected void saveDecomposeManage(Map<String, BigDecimal> orgProportion, Map<String, BigDecimal> formula, BgDecomposeFormInfo info) throws EASBizException, BOSException {
        BgDecomposeManagerFactory.getRemoteInstance().saveDecomposeManageCollection(orgProportion, formula, (IObjectValue)info, this.getType());
    }

    protected void actionPerformRange() {
        IMbgViewBase viewManager;
        BgSpreadCoreViewUI ui = (BgSpreadCoreViewUI)this.getUIObject();
        BookContextManager contextManager = (BookContextManager)ui.getContextManager();
        Book book = contextManager.getSpreadContext().getBook();
        AbstractBgDecomposeFormInfo info = null;
        String orgViewId = null;
        AbstractProvider provider = null;
        IBgDimensionManagerBase dimManager = null;
        IBgDimensionManagerBase baseDimManager = null;
        BgOrgUnitInfo ccOrgUnit = (BgOrgUnitInfo)ui.getUIContext().get("BGORGUNIT_INFO");
        if (contextManager.getProvider() instanceof BgFormDecomposeViewProvider) {
            provider = (BgFormDecomposeViewProvider)contextManager.getProvider();
            viewManager = (IMbgViewManager)provider.getBgViewManagerForMulOrg().get(provider.getOrgUnitInfo().getNumber());
            dimManager = viewManager.getSheetManagers().get(book.getActiveSheetIndex()).getDimensionManager();
            baseDimManager = ((IMbgViewManager)((BgFormDecomposeViewProvider)provider).getCurMbgViewManager()).getSheetManagers().get(book.getActiveSheetIndex()).getDimensionManager();
            info = ((BgFormDecomposeViewProvider)provider).getBgDecomposeFormInfo();
            orgViewId = provider.getOrgViewId();
        } else if (contextManager.getProvider() instanceof BgFormDecomposeViewListProvider) {
            provider = (BgFormDecomposeViewListProvider)contextManager.getProvider();
            viewManager = (MbgViewListManager)((BgFormDecomposeViewListProvider)provider).getBgViewManagerForMulOrg().get(provider.getOrgUnitInfo().getNumber());
            dimManager = ((MbgViewListSheetManager)((AbstractMbgViewBase)viewManager).getSheetManagers().get(book.getActiveSheetIndex())).getDimensionManager();
            baseDimManager = ((MbgViewListSheetManager)((MbgViewListManager)((BgFormDecomposeViewListProvider)provider).getCurMbgViewManager()).getSheetManagers().get(book.getActiveSheetIndex())).getDimensionManager();
            info = ((BgFormDecomposeViewListProvider)provider).getBgDecomposeFormInfo();
            orgViewId = provider.getOrgViewId();
        }
        Sheet _sheet = book.getActiveSheet();
        String orgUnitNum = null;
        if (info != null) {
            orgUnitNum = BgDecomposeManageHelper.dealWithRangeFormulaOrg(_sheet, ccOrgUnit.getNumber(), info.getBgForm().getBgVersion().getNumber());
        }
        if (orgUnitNum != null && orgUnitNum.equals("exitsOtherOrg")) {
            MsgBox.showWarning((Component)((Object)ui), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"exitsOtherOrg"));
            return;
        }
        if (orgUnitNum != null && orgUnitNum.equals("exitsOtherVersion")) {
            MsgBox.showWarning((Component)((Object)ui), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"exitsOtherVersion"));
            return;
        }
        if (orgUnitNum != null) {
            if (provider instanceof BgFormDecomposeViewProvider && ((BgFormDecomposeViewProvider)provider).getBgViewManagerForMulOrg().containsKey(orgUnitNum)) {
                dimManager = ((IMbgViewManager)((BgFormDecomposeViewProvider)provider).getBgViewManagerForMulOrg().get(orgUnitNum)).getSheetManagers().get(_sheet.getSheetIndex()).getDimensionManager();
            } else if (provider instanceof BgFormDecomposeViewListProvider && ((BgFormDecomposeViewListProvider)provider).getBgViewManagerForMulOrg().containsKey(orgUnitNum)) {
                dimManager = ((MbgViewListSheetManager)((MbgViewListManager)((BgFormDecomposeViewListProvider)provider).getBgViewManagerForMulOrg().get(orgUnitNum)).getSheetManagers().get(book.getActiveSheetIndex())).getDimensionManager();
            }
        }
        BgOrgUnitInfo bgOrgUnit = null;
        HashMap<String, BgOrgUnitInfo> bgOrgMap = new HashMap<String, BgOrgUnitInfo>();
        IRowSet rst = null;
        if (ccOrgUnit == null && info != null) {
            BgOrgUnitCollection coll = null;
            try {
                coll = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection("where number ='" + info.getOrgUnit().getNumber() + "' and viewId = '" + orgViewId + "' and isVirtual = 0");
            }
            catch (BOSException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
            if (coll != null && !coll.isEmpty()) {
                ccOrgUnit = coll.get(0);
            }
        }
        if (!ccOrgUnit.getNumber().equals(orgUnitNum)) {
            StringBuffer sql = new StringBuffer();
            sql.append("select FID, FNumber, FLongNumber, FViewId, FOrgUnitId FROM T_MBG_BgOrgUnit where FViewId = '" + orgViewId + "' and FNumber = '" + orgUnitNum + "' AND FIsVirtual=0");
            try {
                rst = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
                while (rst.next()) {
                    bgOrgUnit = new BgOrgUnitInfo();
                    bgOrgUnit.setId(BOSUuid.read((String)rst.getString("FID")));
                    bgOrgUnit.setNumber(rst.getString("FNumber"));
                    bgOrgUnit.setLongNumber(rst.getString("FLongNumber"));
                    bgOrgUnit.setViewID(rst.getString("FViewId"));
                    bgOrgUnit.setOrgUnitID(rst.getString("FOrgUnitId"));
                    bgOrgMap.put(bgOrgUnit.getNumber(), bgOrgUnit);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
            if (!bgOrgMap.isEmpty() && !StringUtils.isEmpty((String)orgUnitNum) && bgOrgMap.containsKey(orgUnitNum)) {
                bgOrgUnit = (BgOrgUnitInfo)bgOrgMap.get(orgUnitNum);
            }
        } else {
            bgOrgUnit = ccOrgUnit;
        }
        try {
            this.rangeDecompose(ui, book, (BgDecomposeFormInfo)info, dimManager, baseDimManager);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public void rangeDecompose(CoreUI baseUI, Book book, BgDecomposeFormInfo info, IBgDimensionManagerBase dimManager) throws Exception {
        this.rangeDecompose(baseUI, book, info, dimManager, null);
    }

    public void rangeDecompose(CoreUI baseUI, Book book, BgDecomposeFormInfo info, IBgDimensionManagerBase dimManager, IBgDimensionManagerBase baseDimManager) throws Exception {
        this.getSchemeHelper(info.getBgScheme().getId().toString());
        Map scenarioMap = BgScenarioHelper.getScenariooObjMap();
        BgDecomposeRefOrgUnitCollection collection = info.getRefOrgUnit();
        HashSet<BOSUuid> orgIds = new HashSet<BOSUuid>();
        orgIds.add(info.getOrgUnit().getId());
        for (int i = 0; i < collection.size(); ++i) {
            orgIds.add(collection.get(i).getOrgUnitID());
        }
        BgOrgUnitCollection colls = BgDecomposeManageHelper.getDecomposeRefOrgUnit(orgIds, this.schemeHelper.getBgOrgViewId());
        Vector<BgOrgUnitInfo> orgUnits = new Vector<BgOrgUnitInfo>();
        HashMap<String, BgOrgUnitInfo> haveDataOrg = new HashMap<String, BgOrgUnitInfo>();
        for (int i = 0; i < colls.size(); ++i) {
            BgOrgUnitInfo cCOrginfo = colls.get(i);
            orgUnits.add(cCOrginfo);
            haveDataOrg.put(cCOrginfo.getId().toString(), cCOrginfo);
        }
        TreeModel treeModel = BgOrgUnitUtils.loadBgOrgTreeModel(null, null, null, this.schemeHelper.getBgOrgViewId(), true, null, false);
        BgOrgUnitCollection coll = BgDecomposeManageHelper.allOrgTree(treeModel);
        Sheet _sheet = book.getActiveSheet();
        Range range = _sheet.getSelectionRange();
        if (range == null) {
            if (this.getState().equals(OprtState.EDIT)) {
                MsgBox.showWarning((Component)baseUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"formulaDataEdit"));
            } else if (this.getState().equals(OprtState.VIEW)) {
                MsgBox.showWarning((Component)baseUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"formulaDataView"));
            }
            return;
        }
        HashSet<String> formulas = new HashSet<String>();
        HashSet<String> versions = new HashSet<String>();
        Map<String, BigDecimal> formulaMap = BgDecomposeManageHelper.dealWithRangeFormulaVersion(_sheet, formulas, versions, scenarioMap);
        Map formulaMaps = BgDecomposeManagerFactory.getRemoteInstance().checkCanEditDataMap(null, formulaMap, info);
        if (formulaMaps == null || formulaMaps.isEmpty()) {
            if (this.getState().equals(OprtState.EDIT)) {
                MsgBox.showWarning((Component)baseUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"formulaDataEdit"));
            } else if (this.getState().equals(OprtState.VIEW)) {
                MsgBox.showWarning((Component)baseUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgDecomposeResource", (String)"formulaDataView"));
            }
            return;
        }
        if (dimManager == null) {
            try {
                BgDimensionBaseInfo versionDim;
                IMbgViewBase view = DimensionFormulaHelper.buildViewMamager(null, formulas, null);
                if (view == null || view.getSheetManagers().isEmpty()) {
                    return;
                }
                if (view instanceof IMbgViewManager) {
                    view = TemplateFacadeFactory.getRemoteInstance().loadViewManager(info.getOrgUnit().getId().toString(), info.getBgScheme().getId().toString(), (IMbgViewManager)view);
                    dimManager = view.getSheetManagers().get(0).getDimensionManager();
                    if (dimManager instanceof IBgDimensionManager) {
                        ((IBgDimensionManager)dimManager).reloadDefaultDisplayDimension();
                    }
                } else if (view instanceof MbgViewListManager) {
                    view = MBGViewListFormFacadeFactory.getRemoteInstance().loadViewListManager(info.getBgForm().getId().toString(), this.schemeHelper.getBgOrgViewId(), (MbgViewListManager)view, null, info.getOrgUnit().getId().toString(), false, false);
                    dimManager = ((MbgViewListSheetManager)((MbgViewListManager)view).getSheetManagers().get(book.getActiveSheetIndex())).getDimensionManager();
                }
                if ((versionDim = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_VERSION_NUMBER, dimManager.getDimension())) != null && versionDim.getMember().isEmpty()) {
                    BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_VERSION_NUMBER, DimensionConstants.DEF_VERSION_NUMBER, info.getBgForm().getBgVersion().getName(), info.getBgForm().getBgVersion().getNumber());
                    member.setSrcNumber(DimensionConstants.DEF_VERSION_SRCNUMBER);
                    versionDim.getMember().add(member);
                }
                versions.add(info.getBgForm().getBgVersion().getNumber());
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
        }
        UIContext uiContext = new UIContext((Object)baseUI);
        uiContext.put((Object)"perantLNum", (Object)((BgOrgUnitInfo)orgUnits.get(orgUnits.size() - 1)).getLongNumber());
        uiContext.put((Object)"orgUnits", orgUnits);
        uiContext.put((Object)"refOrgUnitCol", (Object)coll);
        uiContext.put((Object)"haveDataOrg", haveDataOrg);
        uiContext.put((Object)"BGFORM_INFO", (Object)info);
        uiContext.put((Object)"FORMULA_VALUE", (Object)formulaMaps);
        uiContext.put((Object)DimensionConstants.DIMENSION, (Object)dimManager);
        uiContext.put((Object)DimensionConstants.CALCMEMBER, (Object)baseDimManager);
        uiContext.put((Object)"OPEN_STATE", (Object)this.getState());
        uiContext.put((Object)"BGFORM_OPEN_STATE", (Object)this.getType());
        uiContext.put((Object)"BGORGVIEW_ID", (Object)this.schemeHelper.getBgOrgViewId());
        uiContext.put((Object)"UI_Title", (Object)this.getTitle());
        if (baseUI != null) {
            uiContext.put((Object)"BGFROM_DATA_STATE", baseUI.getUIContext().get("BGFROM_DATA_STATE"));
        }
        IUIWindow uiCell = null;
        try {
            uiCell = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getDecomposerManageUI(), (Map)uiContext, null, this.getState());
            uiCell.show();
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }
}

