/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.mbg.BgCommonException;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgGatherFactory;
import com.kingdee.eas.ma.mbg.BgGatherInfo;
import com.kingdee.eas.ma.mbg.client.BgGatherViewUI;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.utils.DimensionClientHelper;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.provider.AbstractProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class ActionGatherView
extends AbstractAction {
    private static final long serialVersionUID = 1578150494171106952L;

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionGatherView");
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_seegather");
    }

    @Override
    protected boolean hasIcon() {
        return true;
    }

    protected BgSpreadCoreViewUI getProcessUI() {
        return (BgSpreadCoreViewUI)this.getUIObject();
    }

    protected BookContextManager getContextManager() {
        return (BookContextManager)this.getProcessUI().getContextManager();
    }

    protected IProvider getProvider() {
        return this.getContextManager().getProvider();
    }

    public void actionPerformed(ActionEvent e) {
        BgFormInfo bgFormInfo = (BgFormInfo)this.getProvider().getEditValue();
        Book book = this.getContextManager().getSpreadContext().getBook();
        ActionGatherView.showGatherView(this.getUIObject(), bgFormInfo, book, this.getProvider().getCheckFactory(), this.getProvider().getCurMbgViewManager(), ((AbstractProvider)this.getProvider()).getGatherInfos());
    }

    public static void showGatherView(Object ownerUi, BgFormInfo bgFormInfo, Book book, DimensionMemberCheckFactory checkFactory, IMbgViewBase view, List<BgGatherInfo> tmpGatherInfos) {
        ItemFormula itemFormula;
        if (ownerUi == null || bgFormInfo == null || book == null) {
            return;
        }
        String formula = null;
        String orgUnitId = null;
        String versionNumber = null;
        if (book.getActiveSheet() != null && (itemFormula = BgNFSHelper.getItemFormula(book.getActiveSheet().getActiveCell())) != null) {
            formula = itemFormula.getFormula();
            versionNumber = itemFormula.getExt("Version");
            orgUnitId = itemFormula.getExt("ORGUNITID");
        }
        if (StringUtils.isEmpty(formula)) {
            MsgBox.showInfo((Component)((Component)ownerUi), (String)new BgCommonException(BgCommonException.SELECTEDFORMULAOFCELL).getMessage());
            return;
        }
        if (orgUnitId == null) {
            orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        }
        if (versionNumber == null) {
            versionNumber = bgFormInfo.getBgVersion().getNumber();
        }
        try {
            String[] formulaParams = BgNFSHelper.parseFormulaPara(formula);
            if (!checkFactory.getCacheHelper().getBudgetScens().contains(formulaParams[3])) {
                throw new BgCommonException(BgCommonException.SELECTNOBUDGETSCENARIO);
            }
            if (!DimensionClientHelper.isDetailDataCell(bgFormInfo, checkFactory, formula, orgUnitId, view, null)) {
                throw new BgCommonException(BgCommonException.SELECTDETAILFORMULA);
            }
            List gatherInfos = BgGatherFactory.getRemoteInstance().queryGaherInfo(bgFormInfo.getBgScheme().getId().toString(), orgUnitId, formula, versionNumber, tmpGatherInfos);
            if (gatherInfos == null || gatherInfos.isEmpty()) {
                throw new BgCommonException(BgCommonException.SELECTNOFOUNTGATHER);
            }
            UIContext uiContext = new UIContext(ownerUi);
            uiContext.put((Object)"InitDataObject", (Object)gatherInfos);
            uiContext.put((Object)"BGFORM_INFO", (Object)bgFormInfo);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgGatherViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW, 64);
            if (window instanceof UINewFrame) {
                UINewFrame frame = (UINewFrame)window;
                frame.getUIMenuBar().setVisible(false);
                frame.getStatusBar().setVisible(false);
            }
            window.show();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Component)ownerUi), (Throwable)e);
        }
    }
}

