/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.SortedColumnArray;
import com.kingdee.bos.ctrl.excel.model.struct.SortedRowArray;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgHideItemEnum;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.MbgViewListFormProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionHide
extends AbstractAction {
    private static final long serialVersionUID = -9097084980699290115L;

    @Override
    protected String getName() {
        return null;
    }

    protected Map<Integer, Map<BgHideItemEnum, List<Integer>>> findHideRow() {
        Book book = this.getBook();
        HashMap<Integer, Map<BgHideItemEnum, List<Integer>>> sheetMap = new HashMap<Integer, Map<BgHideItemEnum, List<Integer>>>(0);
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            ArrayList<Integer> zeroRowNumList = new ArrayList<Integer>(0);
            ArrayList<Integer> emptyRowNumList = new ArrayList<Integer>(0);
            ArrayList<Integer> zeroOrEmptyRowNumList = new ArrayList<Integer>(0);
            HashMap<BgHideItemEnum, ArrayList<Integer>> rowMap = new HashMap<BgHideItemEnum, ArrayList<Integer>>(0);
            ArrayList<Integer> hideRows = new ArrayList<Integer>();
            SortedRowArray rows = book.getSheet(sheetIndex).getRows();
            int dataCellCounter = 0;
            int zeroCellCounter = 0;
            int emptyCellCounter = 0;
            int zeroOrEmptyCellCounter = 0;
            Row row = null;
            SortedColumnArray cols = book.getSheet(sheetIndex).getCols();
            for (int j = 0; j < rows.size(); ++j) {
                dataCellCounter = 0;
                zeroCellCounter = 0;
                emptyCellCounter = 0;
                zeroOrEmptyCellCounter = 0;
                row = rows.getAt(j);
                Cell cell = null;
                for (int k = 0; k < cols.size(); ++k) {
                    cell = row.getCell(k, false);
                    if (BgNFSHelper.checkHasFormulaOfCell(cell) || BgNFSHelper.checkHasExpression(cell)) {
                        ++dataCellCounter;
                        if (!BgNFSHelper.checkIsEmptyValue(cell) && cell.getValue().equals((Object)Variant.zeroBigDecimal)) {
                            ++zeroCellCounter;
                            ++zeroOrEmptyCellCounter;
                        } else if (BgNFSHelper.checkIsEmptyValue(cell)) {
                            ++emptyCellCounter;
                            ++zeroOrEmptyCellCounter;
                        } else if (cell.isHidden() && row.getUserObject("IS_SET_WIDTH") != null) {
                            hideRows.add(cell.getRow());
                            row.removeUserObject("IS_SET_WIDTH");
                        }
                    }
                    if (dataCellCounter != zeroCellCounter && dataCellCounter != emptyCellCounter && dataCellCounter != zeroOrEmptyCellCounter) break;
                }
                if (dataCellCounter == 0) continue;
                if (dataCellCounter == zeroCellCounter) {
                    zeroRowNumList.add(row.getRow());
                }
                if (dataCellCounter == emptyCellCounter) {
                    emptyRowNumList.add(row.getRow());
                }
                if (dataCellCounter != zeroOrEmptyCellCounter) continue;
                zeroOrEmptyRowNumList.add(row.getRow());
            }
            Range range = null;
            for (Integer rowIndex : hideRows) {
                CellBlock cb = CellBlock.getNewCellBlock((int)rowIndex, (int)0, (int)rowIndex, (int)16383);
                if (range == null) {
                    range = book.getSheet(sheetIndex).getRange(cb);
                    continue;
                }
                range.append((Object)cb);
            }
            this.setHidden(range, false, true);
            rowMap.put(BgHideItemEnum.HIDE_ZERO, zeroRowNumList);
            rowMap.put(BgHideItemEnum.HIDE_EMPTY, emptyRowNumList);
            rowMap.put(BgHideItemEnum.HIDE_ZERO_OR_EMPTY, zeroOrEmptyRowNumList);
            sheetMap.put(sheetIndex, rowMap);
        }
        return sheetMap;
    }

    protected Map<Integer, Map<BgHideItemEnum, List<Integer>>> findHideCol() {
        Book book = this.getBook();
        HashMap<Integer, Map<BgHideItemEnum, List<Integer>>> sheetMap = new HashMap<Integer, Map<BgHideItemEnum, List<Integer>>>(0);
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            ArrayList<Integer> zeroColNumList = new ArrayList<Integer>(0);
            ArrayList<Integer> emptyColNumList = new ArrayList<Integer>(0);
            ArrayList<Integer> zeroOrEmptyColNumList = new ArrayList<Integer>(0);
            HashMap<BgHideItemEnum, ArrayList<Integer>> colMap = new HashMap<BgHideItemEnum, ArrayList<Integer>>(0);
            ArrayList<Integer> hideCols = new ArrayList<Integer>();
            SortedRowArray rows = book.getSheet(sheetIndex).getRows();
            SortedColumnArray cols = book.getSheet(sheetIndex).getCols();
            int dataCellCounter = 0;
            int zeroCellCounter = 0;
            int emptyCellCounter = 0;
            int zeroOrEmptyCellCounter = 0;
            Column col = null;
            for (int j = 0; j < cols.size(); ++j) {
                dataCellCounter = 0;
                zeroCellCounter = 0;
                emptyCellCounter = 0;
                zeroOrEmptyCellCounter = 0;
                col = cols.getAt(j);
                Cell cell = null;
                for (int k = 0; k < rows.size(); ++k) {
                    Row rowsAt = rows.getAt(k);
                    cell = rowsAt.getCell(col.getCol(), false);
                    if (BgNFSHelper.checkHasFormulaOfCell(cell) || BgNFSHelper.checkHasExpression(cell)) {
                        ++dataCellCounter;
                        if (!BgNFSHelper.checkIsEmptyValue(cell) && cell.getValue().equals((Object)Variant.zeroBigDecimal)) {
                            ++zeroCellCounter;
                            ++zeroOrEmptyCellCounter;
                        } else if (BgNFSHelper.checkIsEmptyValue(cell)) {
                            ++emptyCellCounter;
                            ++zeroOrEmptyCellCounter;
                        } else if (cell.isHidden() && col.getUserObject("IS_SET_WIDTH") != null) {
                            hideCols.add(cell.getCol());
                            col.removeUserObject("IS_SET_WIDTH");
                        }
                    }
                    if (dataCellCounter != zeroCellCounter && dataCellCounter != emptyCellCounter && dataCellCounter != zeroOrEmptyCellCounter) break;
                }
                if (dataCellCounter == 0) continue;
                if (dataCellCounter == zeroCellCounter) {
                    zeroColNumList.add(col.getCol());
                }
                if (dataCellCounter == emptyCellCounter) {
                    emptyColNumList.add(col.getCol());
                }
                if (dataCellCounter != zeroOrEmptyCellCounter) continue;
                zeroOrEmptyColNumList.add(col.getCol());
            }
            Range range = null;
            for (Integer colIndex : hideCols) {
                CellBlock cb = CellBlock.getNewCellBlock((int)0, (int)colIndex, (int)1048575, (int)colIndex);
                if (range == null) {
                    range = book.getSheet(sheetIndex).getRange(cb);
                    continue;
                }
                range.append((Object)cb);
            }
            this.setHidden(range, false, false);
            colMap.put(BgHideItemEnum.HIDE_ZERO, zeroColNumList);
            colMap.put(BgHideItemEnum.HIDE_EMPTY, emptyColNumList);
            colMap.put(BgHideItemEnum.HIDE_ZERO_OR_EMPTY, zeroOrEmptyColNumList);
            sheetMap.put(sheetIndex, colMap);
        }
        return sheetMap;
    }

    protected void setHidden(Range range, boolean isHide, boolean bRow) {
        StyleAttributes sa = Styles.getEmptySA();
        if (range != null) {
            range.setIgnoreProtected(true);
            range.setStyle(sa, Styles.getEmptySA());
            range.setHidden(isHide, bRow);
        }
    }

    protected void hideRange(Map<Integer, Map<BgHideItemEnum, List<Integer>>> hide, BgHideItemEnum hideType, boolean bRow, boolean isHide) {
        if (hide == null) {
            return;
        }
        Book book = this.getBook();
        for (Integer sheetIndex : hide.keySet()) {
            CellBlock cb;
            Range zeroRange = null;
            Range emptyRange = null;
            Range zeroOrEmptyRange = null;
            Range finalRange = null;
            List<Integer> zeroNumList = hide.get(sheetIndex).get((Object)BgHideItemEnum.HIDE_ZERO);
            List<Integer> emptyNumList = hide.get(sheetIndex).get((Object)BgHideItemEnum.HIDE_EMPTY);
            List<Integer> zeroOrEmptyNumList = hide.get(sheetIndex).get((Object)BgHideItemEnum.HIDE_ZERO_OR_EMPTY);
            if (bRow) {
                Row row;
                for (Integer rowIndex : zeroNumList) {
                    cb = CellBlock.getNewCellBlock((int)rowIndex, (int)0, (int)rowIndex, (int)16383);
                    if (zeroRange == null) {
                        zeroRange = book.getSheet(sheetIndex.intValue()).getRange(cb);
                    } else {
                        zeroRange.append((Object)cb);
                    }
                    row = book.getSheet(sheetIndex.intValue()).getRow(rowIndex.intValue(), false);
                    if (isHide) {
                        row.setUserObject("IS_SET_WIDTH", (Object)false);
                        continue;
                    }
                    row.removeUserObject("IS_SET_WIDTH");
                }
                for (Integer rowIndex : emptyNumList) {
                    cb = CellBlock.getNewCellBlock((int)rowIndex, (int)0, (int)rowIndex, (int)16383);
                    if (emptyRange == null) {
                        emptyRange = book.getSheet(sheetIndex.intValue()).getRange(cb);
                    } else {
                        emptyRange.append((Object)cb);
                    }
                    row = book.getSheet(sheetIndex.intValue()).getRow(rowIndex.intValue(), false);
                    if (isHide) {
                        row.setUserObject("IS_SET_WIDTH", (Object)false);
                        continue;
                    }
                    row.removeUserObject("IS_SET_WIDTH");
                }
                for (Integer rowIndex : zeroOrEmptyNumList) {
                    cb = CellBlock.getNewCellBlock((int)rowIndex, (int)0, (int)rowIndex, (int)16383);
                    if (zeroOrEmptyRange == null) {
                        zeroOrEmptyRange = book.getSheet(sheetIndex.intValue()).getRange(cb);
                    } else {
                        zeroOrEmptyRange.append((Object)cb);
                    }
                    row = book.getSheet(sheetIndex.intValue()).getRow(rowIndex.intValue(), false);
                    if (isHide) {
                        row.setUserObject("IS_SET_WIDTH", (Object)false);
                        continue;
                    }
                    row.removeUserObject("IS_SET_WIDTH");
                }
            } else {
                Column col;
                for (Integer colIndex : zeroNumList) {
                    cb = CellBlock.getNewCellBlock((int)0, (int)colIndex, (int)1048575, (int)colIndex);
                    if (zeroRange == null) {
                        zeroRange = book.getSheet(sheetIndex.intValue()).getRange(cb);
                    } else {
                        zeroRange.append((Object)cb);
                    }
                    col = book.getSheet(sheetIndex.intValue()).getColumn(colIndex.intValue(), false);
                    if (isHide) {
                        col.setUserObject("IS_SET_WIDTH", (Object)false);
                        continue;
                    }
                    col.removeUserObject("IS_SET_WIDTH");
                }
                for (Integer colIndex : emptyNumList) {
                    cb = CellBlock.getNewCellBlock((int)0, (int)colIndex, (int)1048575, (int)colIndex);
                    if (emptyRange == null) {
                        emptyRange = book.getSheet(sheetIndex.intValue()).getRange(cb);
                    } else {
                        emptyRange.append((Object)cb);
                    }
                    col = book.getSheet(sheetIndex.intValue()).getColumn(colIndex.intValue(), false);
                    if (isHide) {
                        col.setUserObject("IS_SET_WIDTH", (Object)false);
                        continue;
                    }
                    col.removeUserObject("IS_SET_WIDTH");
                }
                for (Integer colIndex : zeroOrEmptyNumList) {
                    cb = CellBlock.getNewCellBlock((int)0, (int)colIndex, (int)1048575, (int)colIndex);
                    if (zeroOrEmptyRange == null) {
                        zeroOrEmptyRange = book.getSheet(sheetIndex.intValue()).getRange(cb);
                    } else {
                        zeroOrEmptyRange.append((Object)cb);
                    }
                    col = book.getSheet(sheetIndex.intValue()).getColumn(colIndex.intValue(), false);
                    if (isHide) {
                        col.setUserObject("IS_SET_WIDTH", (Object)false);
                        continue;
                    }
                    col.removeUserObject("IS_SET_WIDTH");
                }
            }
            finalRange = hideType.equals((Object)BgHideItemEnum.HIDE_ZERO) ? zeroRange : (hideType.equals((Object)BgHideItemEnum.HIDE_EMPTY) ? emptyRange : zeroOrEmptyRange);
            this.setHidden(finalRange, isHide, bRow);
        }
    }

    protected BOSUuid getUserID() {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userInfo.getId();
    }

    protected BOSUuid getFormID() {
        BgFormInfo bgFormInfo = (BgFormInfo)this.getBookContextManager().getProvider().getEditValue();
        return bgFormInfo.getId();
    }

    protected Book getBook() {
        Book book = this.getBookContextManager().getSpreadContext().getBook();
        return book;
    }

    protected BookContextManager getBookContextManager() {
        BgSpreadCoreViewUI processUI = (BgSpreadCoreViewUI)this.getUIObject();
        BookContextManager contextManager = (BookContextManager)processUI.getContextManager();
        return contextManager;
    }

    public BgHideItemEnum getRowHideItem() {
        if (this.getUIObject() instanceof MBGFormProcessUI) {
            return ((MBGFormProcessUI)this.getUIObject()).getRowHideItem();
        }
        if (this.getUIObject() instanceof MbgViewListFormProcessUI) {
            return ((MbgViewListFormProcessUI)this.getUIObject()).getRowHideItem();
        }
        return BgHideItemEnum.UNHIDE;
    }

    public BgHideItemEnum getColHideItem() {
        if (this.getUIObject() instanceof MBGFormProcessUI) {
            return ((MBGFormProcessUI)this.getUIObject()).getColHideItem();
        }
        if (this.getUIObject() instanceof MbgViewListFormProcessUI) {
            return ((MbgViewListFormProcessUI)this.getUIObject()).getColHideItem();
        }
        return BgHideItemEnum.UNHIDE;
    }
}

