/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgPeriodDecomposeFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.IBgPeriodDecomposeFacade;
import com.kingdee.eas.ma.mbg.client.BgNFProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNFormProcessUI;
import com.kingdee.eas.ma.mbg.client.BgPeriodDecomposeResultUI;
import com.kingdee.eas.ma.mbg.client.BgPeriodDecomposeUI;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.MbgViewListFormProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.common.BgDecomposeError;
import com.kingdee.eas.ma.mbg.common.BgDecomposeParameter;
import com.kingdee.eas.ma.mbg.common.BgDecomposeResult;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgPeriodDecomposeUtils;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.designer.IProvider;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.SheetInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ActionPeriodDecompose
extends AbstractAction {
    private static final long serialVersionUID = -3553181869375462729L;
    private static final Logger logger = Logger.getLogger((String)ActionPeriodDecompose.class.getName());
    private static LongTimeDialog longTimeDialog = null;

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_courseweave");
    }

    @Override
    protected String getName() {
        return BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionPeriodDecompose");
    }

    public void actionPerformed(ActionEvent e) {
        BgSpreadCoreViewUI baseUI = (BgSpreadCoreViewUI)this.getUIObject();
        BookContextManager contextManager = (BookContextManager)baseUI.getContextManager();
        Book book = contextManager.getSpreadContext().getBook();
        BgSchemeInfo bgSchemeInfo = contextManager.getProvider().getBgSchemeInfo();
        BgFormInfo bgFormInfo = (BgFormInfo)contextManager.getProvider().getEditValue();
        try {
            ActionPeriodDecompose.bgPeriodDecompose(baseUI, contextManager.getProvider(), book, bgSchemeInfo, bgFormInfo);
        }
        catch (BOSException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    public static void bgPeriodDecompose(CoreUI baseUI, IProvider provider, Book book, BgSchemeInfo bgSchemeInfo, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        IMbgViewBase viewManager = null;
        if (bgFormInfo.getFormType().equals((Object)BgTemFormTypeEnum.VIEWFORM) || bgFormInfo.getFormType().equals((Object)BgTemFormTypeEnum.VIEWLIST)) {
            viewManager = provider.getCurMbgViewManager();
        } else {
            viewManager = DimensionCommonHelper.getBgFormView(null, bgFormInfo);
            if (bgFormInfo.getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM) && baseUI.getOprtState().equals(OprtState.ADDNEW) && book != null) {
                try {
                    bgFormInfo.setBook(book);
                }
                catch (IOException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
        }
        UIContext uiContext = ActionPeriodDecompose.prepareUIContext(baseUI, viewManager, book, bgSchemeInfo, bgFormInfo);
        if (uiContext == null) {
            return;
        }
        IUIWindow bgPeriodDecomposeUI = null;
        try {
            bgPeriodDecomposeUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgPeriodDecomposeUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            bgPeriodDecomposeUI.show();
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
        if (bgPeriodDecomposeUI != null && ((BgPeriodDecomposeUI)bgPeriodDecomposeUI.getUIObject()).isCancel()) {
            return;
        }
        BgDecomposeParameter paramter = ((BgPeriodDecomposeUI)bgPeriodDecomposeUI.getUIObject()).getBgPeriodDecParameter();
        paramter.setBgFormInfo(bgFormInfo);
        paramter.setSourceData(ActionPeriodDecompose.getSourceData(baseUI, provider, viewManager, bgFormInfo, book, paramter.getSourceNumber(), paramter.getSheetInfos()));
        paramter.setViewManager(viewManager);
        BgDecomposeParameter bgDecomposeParameter = paramter;
        Object result = BgPeriodDecomposeFacadeFactory.getRemoteInstance().bgPeriodDec(bgDecomposeParameter);
        ActionPeriodDecompose.doResult(baseUI, bgFormInfo, book, result);
    }

    protected static UIContext prepareUIContext(CoreUI baseUI, IMbgViewBase viewManager, Book book, BgSchemeInfo bgSchemeInfo, BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        Set<String> sourceBgPeriodNumbs = null;
        Set<String> sourceBgScenarioNums = null;
        Set<String> sourceBgElementNums = null;
        List<BgPeriodTypeInfo> sourceBgPeriodTypes = null;
        Set<String> targeBgPeriodNumbs = null;
        Set<String> targeBgScenarioNums = null;
        Set<String> targeBgElementNums = null;
        List<BgPeriodTypeInfo> targeBgPeriodTypes = null;
        int activeIndex = book.getActiveSheetIndex();
        if (bgFormInfo.getFormType().equals((Object)BgTemFormTypeEnum.FIXEDFORM) || bgFormInfo.getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM)) {
            Set<String> sformulas = BgPeriodDecomposeUtils.getFormulasBySheet(book.getActiveSheet());
            sourceBgPeriodNumbs = sourceBgPeriodNumbs == null ? BgPeriodDecomposeUtils.getBgPeriodNumsByFormulas(sformulas) : sourceBgPeriodNumbs;
            sourceBgScenarioNums = sourceBgScenarioNums == null ? BgPeriodDecomposeUtils.getBgScenarioNumsByFormulas(sformulas) : sourceBgScenarioNums;
            sourceBgElementNums = sourceBgElementNums == null ? BgPeriodDecomposeUtils.getBgElementNumsByFormulas(sformulas) : sourceBgElementNums;
            sourceBgPeriodTypes = sourceBgPeriodTypes == null ? BgPeriodDecomposeUtils.queryBgPeriodTypes(BgPeriodDecomposeUtils.getBgPeriodTypeNumsByFormulas(sformulas), SortType.ASCEND) : sourceBgPeriodTypes;
        } else {
            List<? extends IMbgSheetBase> sheetManagers = viewManager.getSheetManagers();
            Map<String, Map<String, BgDimensionMember>> currentMemberMap = BgPeriodDecomposeUtils.getViewMembers(sheetManagers.get(activeIndex).getDimensionManager(), bgFormInfo);
            sourceBgPeriodNumbs = BgPeriodDecomposeUtils.getMemberNums(currentMemberMap, DimensionConstants.DEF_PERIOD_NUMBER);
            sourceBgScenarioNums = BgPeriodDecomposeUtils.getMemberNums(currentMemberMap, DimensionConstants.DEF_SCENARIO_NUMBER);
            sourceBgElementNums = BgPeriodDecomposeUtils.getMemberNums(currentMemberMap, DimensionConstants.DEF_ELEMENT_NUMBER);
            if (sourceBgPeriodNumbs != null && !sourceBgPeriodNumbs.isEmpty()) {
                sourceBgPeriodTypes = BgPeriodDecomposeUtils.queryBgPeriodTypes(BgPeriodDecomposeUtils.getBgPeriodTypeNumsByNumbers(sourceBgPeriodNumbs), SortType.ASCEND);
            }
        }
        if (sourceBgPeriodTypes == null || sourceBgPeriodNumbs == null || sourceBgPeriodNumbs.isEmpty()) {
            MsgBox.showInfo((Component)baseUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"noFormula"));
            return null;
        }
        Map<String, Map<String, BgDimensionMember>> allMemberMap = BgPeriodDecomposeUtils.getViewMembers(viewManager, bgFormInfo);
        targeBgPeriodNumbs = BgPeriodDecomposeUtils.getMemberNums(allMemberMap, DimensionConstants.DEF_PERIOD_NUMBER);
        targeBgScenarioNums = BgPeriodDecomposeUtils.getMemberNums(allMemberMap, DimensionConstants.DEF_SCENARIO_NUMBER);
        targeBgElementNums = BgPeriodDecomposeUtils.getMemberNums(allMemberMap, DimensionConstants.DEF_ELEMENT_NUMBER);
        if (targeBgPeriodNumbs != null && !targeBgPeriodNumbs.isEmpty()) {
            targeBgPeriodTypes = BgPeriodDecomposeUtils.queryBgPeriodTypes(BgPeriodDecomposeUtils.getBgPeriodTypeNumsByNumbers(targeBgPeriodNumbs), SortType.DESCEND);
        }
        if (targeBgPeriodTypes == null || targeBgPeriodTypes.size() <= 1) {
            MsgBox.showInfo((Component)baseUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"OnlyOneType"));
            return null;
        }
        UIContext uiContext = new UIContext((Object)baseUI);
        uiContext.put((Object)"SOURCE_PERIOD_TYPE", sourceBgPeriodTypes);
        uiContext.put((Object)"SOURCE_PERIODS", sourceBgPeriodNumbs);
        uiContext.put((Object)"TARGE_PERIOD_TYPE", targeBgPeriodTypes);
        uiContext.put((Object)"TARGE_PERIODS", targeBgPeriodNumbs);
        uiContext.put((Object)"SOURCE_BGSCENARIOS", sourceBgScenarioNums);
        uiContext.put((Object)"TARGE_BGSCENARIOS", targeBgScenarioNums);
        uiContext.put((Object)"SOURCE_BGELEMENTS", sourceBgElementNums);
        uiContext.put((Object)"TARGE_BGELEMENTS", targeBgElementNums);
        uiContext.put((Object)"BGSCHEME_INFO", (Object)bgSchemeInfo);
        uiContext.put((Object)"BOOK_STR", (Object)book);
        return uiContext;
    }

    protected static void doResult(CoreUI baseUI, BgFormInfo bgFormInfo, Book book, Object obj) throws EASBizException, BOSException {
        if (obj instanceof BgDecomposeResult) {
            BgDecomposeResult result = (BgDecomposeResult)obj;
            Map bgDecDataMap = result.getDataResult();
            if (bgDecDataMap != null && !bgDecDataMap.isEmpty()) {
                ActionPeriodDecompose.reFillValue(baseUI, result, bgFormInfo, book);
                ActionPeriodDecompose.doAfterDecompose(baseUI, result);
            }
            if ((result = ActionPeriodDecompose.processResult(result)).getErrors() != null && !result.getErrors().isEmpty()) {
                ActionPeriodDecompose.showResult(baseUI, result.getErrors());
            } else {
                MsgBox.showInfo((Component)baseUI, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"decSuccess"));
            }
        }
    }

    protected static void doAfterDecompose(CoreUI baseUI, BgDecomposeResult result) throws EASBizException, BOSException {
        Map bgDecDataMap = result.getDataResult();
        if (baseUI == null || bgDecDataMap == null || bgDecDataMap.isEmpty()) {
            return;
        }
        if (baseUI instanceof BgNFormProcessUI) {
            ((BgNFormProcessUI)baseUI).setBgDecomposeDataMap(bgDecDataMap);
        } else if (baseUI instanceof MbgViewListFormProcessUI) {
            ((MbgViewListFormProcessUI)baseUI).setBgDecomposeDataMap(bgDecDataMap);
        } else if (baseUI instanceof MBGFormProcessUI) {
            ((MBGFormProcessUI)baseUI).setBgDecomposeDataMap(bgDecDataMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void reFillValue(CoreUI baseUI, BgDecomposeResult result, BgFormInfo bgFormInfo, Book book) throws EASBizException, BOSException {
        Map resultMap = result.getDataResult();
        if (resultMap.isEmpty() || bgFormInfo == null || book == null) {
            return;
        }
        boolean isView = ActionPeriodDecompose.isView(bgFormInfo);
        ItemFormula formula = null;
        String orgUnitId = null;
        String versionNumber = null;
        IBgNData bgData = null;
        String formulaStr = null;
        String tmpKey = null;
        Sheet sheet = null;
        Cell cell = null;
        HashSet<String> unLockKeys = new HashSet<String>();
        Map bgDataMap = resultMap;
        Set<String> actScenario = new DimensionCacheHelper(null).getActualScens();
        try {
            BgNFSHelper.disableUndo(book);
            BgNFSHelper.disableCal(book);
            for (int s = 0; s < book.getSheetCount(); ++s) {
                sheet = book.getSheet(s);
                for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                    for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                        cell = sheet.getCell(r, c, false);
                        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                        formula = BgNFSHelper.getItemFormula(cell);
                        formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                        if (actScenario.contains(BgNFSHelper.parseFormulaPara(formulaStr)[3])) continue;
                        if (!isView) {
                            orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
                            versionNumber = bgFormInfo.getBgVersion().getNumber();
                        } else {
                            orgUnitId = formula.getExt("ORGUNITID");
                            versionNumber = formula.getExt("Version");
                        }
                        tmpKey = DimUtils.getDimDataKey(formulaStr, versionNumber);
                        if (!bgDataMap.containsKey(orgUnitId) || !((Map)bgDataMap.get(orgUnitId)).containsKey(tmpKey) || (bgData = (IBgNData)((Map)bgDataMap.get(orgUnitId)).get(tmpKey)) == null) continue;
                        String orgVerFormula = orgUnitId + ";" + versionNumber + ";" + formulaStr;
                        if (!cell.isLocked()) {
                            if (BgNFSHelper.checkHasExpression(cell)) {
                                BgNFSHelper.setExpression(cell, null);
                            }
                            BgNFSHelper.setValue(cell, bgData.getBudgetValue());
                            unLockKeys.add(orgVerFormula);
                            result.removeError(orgUnitId, versionNumber, formulaStr);
                            continue;
                        }
                        if (unLockKeys.contains(orgVerFormula)) continue;
                        BgDecomposeError existError = result.getError(orgUnitId, versionNumber, formulaStr);
                        if (existError != null) {
                            if (!existError.getErrors().contains(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"cellLocked"))) {
                                existError.getErrors().add(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"cellLocked"));
                            }
                        } else {
                            existError = new BgDecomposeError();
                            existError.setOrgUnitId(orgUnitId);
                            existError.setBgVersionNumber(versionNumber);
                            existError.setFormula(formulaStr);
                            existError.getErrors().add(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"cellLocked"));
                            result.getErrors().add(existError);
                        }
                        ((Map)bgDataMap.get(orgUnitId)).remove(tmpKey);
                    }
                }
            }
        }
        finally {
            BgNFSHelper.enableCal(book);
            BgNFSHelper.enableUndo(book);
        }
        baseUI.updateUI();
    }

    protected static Map getSourceData(CoreUI baseUI, IProvider provider, IMbgViewBase viewManager, BgFormInfo bgFormInfo, Book book, Map<String, List<String>> sourceNumbers, SheetInfo[] sheetInfos) throws EASBizException, BOSException {
        if (bgFormInfo == null || book == null || sourceNumbers.isEmpty()) {
            return null;
        }
        DimensionMemberCheckHelper checkHelper = null;
        if (baseUI instanceof BgNFProcessUI) {
            checkHelper = ((BgNFProcessUI)baseUI).getCheckHelper();
        }
        ItemFormula formula = null;
        String formulaStr = null;
        String orgId = bgFormInfo.getOrgUnit().getId().toString();
        String versionNumber = bgFormInfo.getBgVersion().getNumber();
        HashMap dataMap = new HashMap();
        Map<String, BigDecimal> subMap = null;
        String bgPeriodNumber = null;
        String bgScenarioNumber = null;
        String bgElementNumber = null;
        HashSet<String> sheetNames = new HashSet<String>();
        if (sheetInfos != null && sheetInfos.length > 0) {
            for (int i = 0; i < sheetInfos.length; ++i) {
                sheetNames.add(sheetInfos[i].getSheetName());
            }
        }
        Sheet sheet = null;
        Cell cell = null;
        for (int b = 0; b < book.getSheetCount(); ++b) {
            sheet = book.getSheet(b);
            if (!sheetNames.isEmpty() && !sheetNames.contains(sheet.getSheetName())) continue;
            int rowCount = sheet.getMaxRowIndex();
            int colCount = sheet.getMaxColIndex();
            for (int r = 0; r <= rowCount; ++r) {
                for (int c = 0; c <= colCount; ++c) {
                    cell = sheet.getCell(r, c, false);
                    if (cell == null || !BgNFSHelper.checkHasItemFormula(cell)) continue;
                    formula = BgNFSHelper.getItemFormula(cell);
                    if (ActionPeriodDecompose.isView(bgFormInfo)) {
                        orgId = formula.getExt("ORGUNITID");
                        versionNumber = formula.getExt("Version");
                        checkHelper = provider.getCheckFactory().getHelper(orgId, viewManager);
                    }
                    if (!dataMap.containsKey(orgId)) {
                        dataMap.put(orgId, new HashMap());
                    }
                    if (!((Map)dataMap.get(orgId)).containsKey(versionNumber)) {
                        subMap = new HashMap();
                        ((Map)dataMap.get(orgId)).put(versionNumber, subMap);
                    } else {
                        subMap = (Map)((Map)dataMap.get(orgId)).get(versionNumber);
                    }
                    formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                    if (checkHelper == null || !checkHelper.canSave(formulaStr, null, versionNumber)) continue;
                    String[] params = BgNFSHelper.parseFormulaPara(formulaStr);
                    bgPeriodNumber = params[1];
                    bgScenarioNumber = params[3];
                    bgElementNumber = params[2];
                    BigDecimal value = BgViewHelper.getNumeric(cell, null);
                    if (!sourceNumbers.get(DimensionConstants.DEF_PERIOD_NUMBER).contains(bgPeriodNumber) || value == null || sourceNumbers.containsKey(DimensionConstants.DEF_SCENARIO_NUMBER) && !sourceNumbers.get(DimensionConstants.DEF_SCENARIO_NUMBER).contains(bgScenarioNumber) || sourceNumbers.containsKey(DimensionConstants.DEF_ELEMENT_NUMBER) && !sourceNumbers.get(DimensionConstants.DEF_ELEMENT_NUMBER).contains(bgElementNumber)) continue;
                    subMap.put(formulaStr, value);
                }
            }
        }
        return dataMap;
    }

    protected static Map getSourceData(CoreUI baseUI, IProvider provider, IMbgViewBase viewManager, BgFormInfo bgFormInfo, Sheet sheet, Map<String, List<String>> sourceNumbers) throws EASBizException, BOSException {
        if (bgFormInfo == null || sheet == null || sourceNumbers.isEmpty()) {
            return null;
        }
        DimensionMemberCheckHelper checkHelper = null;
        if (baseUI instanceof BgNFProcessUI) {
            checkHelper = ((BgNFProcessUI)baseUI).getCheckHelper();
        }
        ItemFormula formula = null;
        String formulaStr = null;
        String orgId = bgFormInfo.getOrgUnit().getId().toString();
        String versionNumber = bgFormInfo.getBgVersion().getNumber();
        HashMap dataMap = new HashMap();
        Map<String, BigDecimal> subMap = null;
        String bgPeriodNumber = null;
        String bgScenarioNumber = null;
        String bgElementNumber = null;
        Cell cell = null;
        int rowCount = sheet.getMaxRowIndex();
        int colCount = sheet.getMaxColIndex();
        for (int r = 0; r <= rowCount; ++r) {
            for (int c = 0; c <= colCount; ++c) {
                cell = sheet.getCell(r, c, false);
                if (cell == null || !BgNFSHelper.checkHasItemFormula(cell)) continue;
                formula = BgNFSHelper.getItemFormula(cell);
                if (ActionPeriodDecompose.isView(bgFormInfo)) {
                    orgId = formula.getExt("ORGUNITID");
                    versionNumber = formula.getExt("Version");
                    checkHelper = provider.getCheckFactory().getHelper(orgId, viewManager);
                }
                if (!dataMap.containsKey(orgId)) {
                    dataMap.put(orgId, new HashMap());
                }
                if (!((Map)dataMap.get(orgId)).containsKey(versionNumber)) {
                    subMap = new HashMap();
                    ((Map)dataMap.get(orgId)).put(versionNumber, subMap);
                } else {
                    subMap = (Map)((Map)dataMap.get(orgId)).get(versionNumber);
                }
                formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                if (checkHelper == null || !checkHelper.canSave(formulaStr, null, versionNumber)) continue;
                String[] params = BgNFSHelper.parseFormulaPara(formulaStr);
                bgPeriodNumber = params[1];
                bgScenarioNumber = params[3];
                bgElementNumber = params[2];
                BigDecimal value = BgViewHelper.getNumeric(cell, null);
                if (!sourceNumbers.get(DimensionConstants.DEF_PERIOD_NUMBER).contains(bgPeriodNumber) || value == null || sourceNumbers.containsKey(DimensionConstants.DEF_SCENARIO_NUMBER) && !sourceNumbers.get(DimensionConstants.DEF_SCENARIO_NUMBER).contains(bgScenarioNumber) || sourceNumbers.containsKey(DimensionConstants.DEF_ELEMENT_NUMBER) && !sourceNumbers.get(DimensionConstants.DEF_ELEMENT_NUMBER).contains(bgElementNumber)) continue;
                subMap.put(formulaStr, value);
            }
        }
        return dataMap;
    }

    protected static void showResult(CoreUI baseUI, List<BgDecomposeError> errors) {
        UIContext uiContext = new UIContext((Object)baseUI);
        uiContext.put((Object)"ERROR_RESULTS", errors);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgPeriodDecomposeResultUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    protected static boolean isView(BgFormInfo bgFormInfo) {
        return bgFormInfo.getFormType().equals((Object)BgTemFormTypeEnum.VIEWFORM) || bgFormInfo.getFormType().equals((Object)BgTemFormTypeEnum.VIEWLIST);
    }

    protected static BgDecomposeResult processResult(BgDecomposeResult result) throws EASBizException, BOSException {
        if (result == null) {
            return result;
        }
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        BgNViewDataInfo data2 = null;
        Map bgDataMap = result.getDataResult();
        Map subMap = null;
        Iterator it = bgDataMap.keySet().iterator();
        while (it.hasNext()) {
            subMap = (Map)bgDataMap.get(it.next());
            for (BgNViewDataInfo data2 : subMap.values()) {
                data2.setUpdateTime(ts);
            }
        }
        result = ActionPeriodDecompose.getBizFacade().processResult(result);
        return result;
    }

    protected static IBgPeriodDecomposeFacade getBizFacade() throws BOSException {
        return BgPeriodDecomposeFacadeFactory.getRemoteInstance();
    }
}

