/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions.form;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgViewFacadeFactory;
import com.kingdee.eas.ma.mbg.client.BgNewOrgSelectMemberDialog;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.form.BgViewAdjustContextManager;
import com.kingdee.eas.ma.mbg.client.form.BgViewAdjustProvider;
import com.kingdee.eas.ma.mbg.client.form.MBGBaseFormContextManager;
import com.kingdee.eas.ma.mbg.client.form.MBGFormContextManager;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.MbgPermissionUtil;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.form.MBGBaseFormProvider;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormProvider;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ActionOrgAdd
extends AbstractAction {
    private static final Logger logger = Logger.getLogger((String)ActionOrgAdd.class.getName());
    private static final long serialVersionUID = -5224354907151369447L;

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionOrgAdd");
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_upenumnew");
    }

    @Override
    protected boolean hasIcon() {
        return true;
    }

    protected BgSpreadCoreViewUI getProcessUI() {
        return (MBGFormProcessUI)this.getUIObject();
    }

    protected MBGBaseFormContextManager getContextManager() {
        return (MBGFormContextManager)this.getProcessUI().getContextManager();
    }

    protected MBGBaseFormProvider getProvider() {
        return (MBGFormProvider)this.getContextManager().getProvider();
    }

    public void actionPerformed(ActionEvent e) {
        boolean hasChange;
        IMbgSheetManager sheetManger = (IMbgSheetManager)this.getProvider().getCurMbgSheetManager();
        BgDimensionInfo orgDimension = (BgDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, sheetManger.getDimensionManager().getDimension());
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(sheetManger.getDimensionManager());
        boolean isorgOnView = MBgTemplateHelper.isOrgOnView(sheetManger.getDimensionManager());
        if (isorgOnView) {
            String title = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)"isViewDim");
            MsgBox.showInfo((Component)((CoreUI)this.getUIObject()), (String)title);
            return;
        }
        BgNewOrgSelectMemberDialog dialog = new BgNewOrgSelectMemberDialog(this.getProcessUI());
        BgSchemeInfo bgScheme = null;
        BOSUuid orgUnitId = null;
        try {
            bgScheme = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, orgUnit.id where id = '" + this.getProvider().getBgFormInfo().getBgScheme().getId().toString() + "'");
            if (bgScheme == null) {
                return;
            }
            orgUnitId = BgOrgUnitFactory.getRemoteInstance().getBuildTreeOrgUnitId(bgScheme.getOrgUnit().getId(), this.getProvider().getBgOrgViewId());
        }
        catch (EASBizException e1) {
            logger.error((Object)"", (Throwable)e1);
            ExceptionHandler.handle((Component)((Object)this.getProcessUI()), (Throwable)e1);
            SysUtil.abort();
        }
        catch (BOSException e1) {
            logger.error((Object)"", (Throwable)e1);
            ExceptionHandler.handle((Component)((Object)this.getProcessUI()), (Throwable)e1);
            SysUtil.abort();
        }
        dialog.setBgOrgViewId(this.getProvider().getOrgViewId());
        dialog.setOrgUnitId(orgUnitId.toString());
        dialog.setPermissionNumber(this.getViewPermissionNumber());
        dialog.setSelectMembers(orgDimension.getMember());
        dialog.setCurrentOrgId(this.getProvider().getOrgUnitId());
        dialog.setIsorgOnPageOrView(isorgOnPageOrView);
        dialog.setNoLeaf(this.getProvider().isDecompose());
        dialog.setShowVirtualNode(true);
        dialog.show();
        if (dialog.isCanceled()) {
            return;
        }
        List newMembers = (List)dialog.getData();
        MbgPermissionUtil.checkBgOrgPerFormOrgAdd(this.getProcessUI(), this.getProvider().getBgFormInfo(), newMembers, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        boolean bl = hasChange = newMembers.size() != orgDimension.getMember().size();
        if (!hasChange) {
            for (int i = 0; i < newMembers.size(); ++i) {
                if (((BgDimensionMember)newMembers.get(i)).getNumber().equals(((BgDimensionMember)orgDimension.getMember().get(i)).getNumber())) continue;
                hasChange = true;
                break;
            }
        }
        if (!hasChange) {
            return;
        }
        try {
            this.execBatchAddNew(this.getProvider().getBgFormInfo().getId().toString(), newMembers);
            orgDimension.getMember().clear();
            orgDimension.getMember().addAll(newMembers);
            orgDimension.setValue(orgDimension.unParseMember());
            this.getContextManager().save();
            if (OprtState.ADDNEW.equals(this.getProcessUI().getOprtState())) {
                this.getProcessUI().setOprtState(OprtState.EDIT);
            }
            this.getContextManager().getProvider().getCheckFactory().clear();
            BgViewClientHelper.reloadBookFormBgForm(this.getContextManager());
            if (this.getContextManager() instanceof BgViewAdjustContextManager) {
                ((BgViewAdjustProvider)this.getContextManager().getProvider()).setAdjustSave(false);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActionOrgAdd.this.getContextManager().reExtractData();
                }
            });
            this.getProcessUI().updateUI();
            this.getProcessUI().setMessageText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)"overMessage"));
            this.getProcessUI().showMessage();
        }
        catch (Exception e1) {
            this.getProcessUI().handUIExceptionAndAbort(e1);
        }
    }

    protected void execBatchAddNew(String bgFormId, List<BgDimensionMember> newMembers) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)bgFormId) || newMembers == null || newMembers.isEmpty()) {
            return;
        }
        HashMap<String, BgDimensionMember> numbers = new HashMap<String, BgDimensionMember>();
        for (int i = 0; i < newMembers.size(); ++i) {
            numbers.put(newMembers.get(i).getNumber(), newMembers.get(i));
        }
        Map result = this.getMessage(bgFormId, numbers);
        if (result == null || result.isEmpty()) {
            return;
        }
        String title = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)((String)result.remove("result")));
        if (result.isEmpty() || result != null && result.size() == 1 && result.containsKey("successFromViews")) {
            MsgBox.showInfo((Component)((CoreUI)this.getUIObject()), (String)title);
            return;
        }
        StringBuffer detail = ActionOrgAdd.buildDetailMessage(newMembers, numbers, result);
        MsgBox.showDetailAndOK((Component)((CoreUI)this.getUIObject()), (String)title, (String)detail.toString(), (int)1);
    }

    protected Map getMessage(String bgFormId, Map<String, BgDimensionMember> numbers) throws BOSException, EASBizException {
        return BgViewFacadeFactory.getRemoteInstance().addNewViewInfo(bgFormId, new HashSet<BgDimensionMember>(numbers.values()), this.getAddNewPermissionNumber());
    }

    public static StringBuffer buildDetailMessage(List<BgDimensionMember> newMembers, Map<String, BgDimensionMember> numbers, Map result) {
        StringBuffer detail = new StringBuffer();
        Map orgs = null;
        String msgKey2 = null;
        String msg = null;
        Object[] orgNumbers = null;
        for (String msgKey2 : result.keySet()) {
            if ("auditBgFormState".equals(msgKey2) || msgKey2.equals(MbgViewListDescriptionHelper.successFromViews) || !(result.get(msgKey2) instanceof Map)) continue;
            orgs = (Map)result.get(msgKey2);
            msg = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)msgKey2);
            orgNumbers = orgs.keySet().toArray();
            Arrays.sort(orgNumbers);
            for (int i = 0; i < orgNumbers.length; ++i) {
                if (detail.length() > 0) {
                    detail.append("\r\n");
                }
                if (newMembers != null && numbers != null) {
                    newMembers.remove(numbers.get(orgNumbers[i]));
                }
                detail.append(MessageFormat.format(msg, ((DataBaseInfo)orgs.get(orgNumbers[i])).getName()));
            }
        }
        return detail;
    }

    protected String getViewPermissionNumber() {
        return "mbg_form05_view";
    }

    protected String getAddNewPermissionNumber() {
        return "mbg_form02_addNew";
    }
}

