/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions.form;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.BgNFormAdjustProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNFormProcessUI;
import com.kingdee.eas.ma.mbg.client.BgPastRecordViewUI;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.form.BgViewAdjustProvider;
import com.kingdee.eas.ma.mbg.client.form.MBGFormContextManager;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.IAdjust;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public class ActionPastRecordView
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final String RES = "com.kingdee.eas.ma.mbg.client.BgViewFormAdjustResource";

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"393_ActionPastRecordView");
    }

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_linkviewlist");
    }

    public void actionPerformed(ActionEvent e) {
        BgSpreadCoreViewUI baseUI = (BgSpreadCoreViewUI)this.uiObj;
        MBGFormContextManager manager = (MBGFormContextManager)baseUI.getContextManager();
        MBGFormProvider provider = (MBGFormProvider)manager.getProvider();
        IAdjust adjust = null;
        if (provider instanceof IAdjust) {
            adjust = (IAdjust)((Object)provider);
        }
        BgFormInfo info = (BgFormInfo)provider.getEditValue();
        ActionPastRecordView.pastRecordView(baseUI, manager.getSpreadContext().getBook(), info, adjust, provider);
    }

    public static void pastRecordView(CoreUI ownerUI, Book book, BgFormInfo info, IAdjust adjust, MBGFormProvider provider) {
        Cell cell;
        Sheet sheet = book.getActiveSheet();
        if (sheet == null) {
            return;
        }
        HashSet<String> formulaSet = new HashSet<String>();
        Range range = sheet.getSelectionRange();
        String orgIdItem = null;
        String versionNumber = null;
        HashSet<String> versionNumSet = new HashSet<String>();
        HashSet<String> orgIdSet = new HashSet<String>();
        if (range != null && !range.isEmpty()) {
            Object[] arr = range.getArray();
            for (int i = 0; i < arr.length; ++i) {
                CellBlock block = (CellBlock)arr[i];
                if (block == null) continue;
                int startRow = block.getRow();
                int endRow = Math.min(sheet.getMaxRowIndex(), block.getRow2());
                int startCol = block.getCol();
                int endCol = Math.min(sheet.getMaxColIndex(), block.getCol2());
                for (int rowIndex = startRow; rowIndex <= endRow; ++rowIndex) {
                    for (int colIndex = startCol; colIndex <= endCol; ++colIndex) {
                        cell = sheet.getCell(rowIndex, colIndex, false);
                        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                        versionNumber = BgNFSHelper.getItemFormula(cell).getExt("Version");
                        if (versionNumber != null) {
                            versionNumSet.add(versionNumber);
                        }
                        formulaSet.add(BgNFSHelper.getFormulaOfCell(cell));
                        orgIdItem = ((ItemFormula)cell.getUserObjectValue("ITEM")).getExt("ORGUNITID");
                        if (StringUtils.isEmpty((String)orgIdItem)) continue;
                        orgIdSet.add(orgIdItem);
                    }
                }
            }
        }
        boolean isQueryAll = false;
        if (formulaSet.isEmpty()) {
            for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    versionNumber = BgNFSHelper.getItemFormula(cell).getExt("Version");
                    if (versionNumber != null) {
                        versionNumSet.add(versionNumber);
                    }
                    formulaSet.add(BgNFSHelper.getFormulaOfCell(cell));
                }
            }
            isQueryAll = true;
        }
        if (versionNumber == null) {
            versionNumber = info.getBgVersion().getNumber();
            versionNumSet.add(versionNumber);
        }
        if (formulaSet.isEmpty()) {
            MsgBox.showInfo((Component)ownerUI, (String)EASResource.getString((String)RES, (String)"cellNoFormula"));
            return;
        }
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        parameter.put("billId", info.getAdjust().getId().toString());
        parameter.put("formula", formulaSet);
        parameter.put("Version", versionNumSet);
        parameter.put("ORGUNIT_ID", info.getOrgUnit().getId().toString());
        parameter.put("BGFORM_INFO", info);
        if (adjust != null) {
            parameter.put("adjustMap", adjust.getAdjustMap());
        }
        parameter.put("BGFORM_AUDIT_TYPE", ownerUI.getUIContext().get("BGFORM_AUDIT_TYPE"));
        try {
            Map rs = null;
            if (adjust != null && adjust instanceof BgNFormAdjustProcessUI || ownerUI instanceof BgNFormProcessUI) {
                String orgUnitId = info.getOrgUnit().getId().toString();
                orgIdSet = new HashSet();
                if (!StringUtils.isEmpty((String)orgUnitId)) {
                    orgIdSet.add(orgUnitId);
                }
                rs = BgAdjustFacadaFactory.getRemoteInstance().pastDataView(parameter, orgIdSet);
            } else if (isQueryAll) {
                rs = BgAdjustFacadaFactory.getRemoteInstance().pastDataView(parameter, provider.getOrgIdSetByCurSheet());
            } else if (orgIdSet != null && !orgIdSet.isEmpty()) {
                rs = BgAdjustFacadaFactory.getRemoteInstance().pastDataView(parameter, orgIdSet);
            }
            UIContext uiContext = new UIContext((Object)ownerUI);
            uiContext.putAll(parameter);
            uiContext.put((Object)"processType", (Object)info.getProcessType());
            BgSchemeInfo scheme = info.getBgScheme();
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(scheme.getId().toString());
            uiContext.put((Object)"schemeHelper", (Object)schemeHelper);
            if (rs != null && !rs.isEmpty() && rs.get("success") instanceof List) {
                uiContext.put((Object)"data", rs.get("success"));
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgPastRecordViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Component)ownerUI, (Throwable)e1);
        }
    }

    protected static Map getPastDataForBgNForm(IAdjust adjust, Map parameter) throws BOSException, EASBizException {
        String orgUnitId = ((BgNFormAdjustProcessUI)adjust).getOrgUnitId();
        HashSet<String> orgIdSet = new HashSet<String>();
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            orgIdSet.add(orgUnitId);
        }
        Map rs = BgAdjustFacadaFactory.getRemoteInstance().pastDataView(parameter, orgIdSet);
        return rs;
    }

    protected static Map getPastData(IAdjust adjust, Map parameter, BgFormInfo info, Set<String> orgIdSet, boolean isQueryAll, MBGFormProvider provider) throws BOSException, EASBizException {
        Set<String> orgIdSetByCurSheet = provider.getOrgIdSetByCurSheet();
        if (orgIdSetByCurSheet != null && !orgIdSetByCurSheet.isEmpty() && isQueryAll) {
            return BgAdjustFacadaFactory.getRemoteInstance().pastDataView(parameter, orgIdSetByCurSheet);
        }
        if (!isQueryAll) {
            return BgAdjustFacadaFactory.getRemoteInstance().pastDataView(parameter, orgIdSet);
        }
        return null;
    }

    protected static Map getPastDataForAdjust(IAdjust adjust, Map parameter, BgFormInfo info, Set<String> orgIdSet, boolean isQueryAll, MBGFormProvider provider) throws BOSException, EASBizException {
        if (adjust != null) {
            Set<String> orgIdSetByCurSheet;
            BgViewAdjustProvider providerAdjust = (BgViewAdjustProvider)adjust;
            if (orgIdSet != null && !orgIdSet.isEmpty() && !isQueryAll) {
                return BgAdjustFacadaFactory.getRemoteInstance().pastDataView(parameter, orgIdSet);
            }
            if (!isQueryAll && (orgIdSet == null || orgIdSet.isEmpty())) {
                return null;
            }
            if (isQueryAll && (orgIdSetByCurSheet = providerAdjust.getOrgIdSetByCurSheet()) != null && !orgIdSetByCurSheet.isEmpty()) {
                return BgAdjustFacadaFactory.getRemoteInstance().pastDataView(parameter, orgIdSetByCurSheet);
            }
        }
        return null;
    }
}

