/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions.form;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.form.BgViewAdjustProvider;
import com.kingdee.eas.ma.mbg.client.form.MBGFormContextManager;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.MbgAdjustHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public class ActionShowAdjust
extends AbstractAction {
    private static final String SHOW_ADJUST = "showAdjust";
    private static final String HIDE_ADJUST = "hideAdjust";
    private static final long serialVersionUID = 1L;

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)SHOW_ADJUST);
    }

    @Override
    protected boolean hasIcon() {
        return super.hasIcon();
    }

    @Override
    protected Icon getIcon() {
        return super.getIcon();
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (!(this.getUIObject() instanceof MBGFormProcessUI)) {
            return;
        }
        MBGFormProcessUI ui = (MBGFormProcessUI)this.getUIObject();
        MBGFormContextManager context = (MBGFormContextManager)ui.getContextManager();
        MBGFormProvider provider = (MBGFormProvider)context.getProvider();
        Map adjustMap = null;
        if (provider instanceof BgViewAdjustProvider) {
            adjustMap = ((BgViewAdjustProvider)provider).getAdjustMap();
        }
        ActionShowAdjust.showAdjust(ui, ui.getShowAdjustMenuItem(), context.getSpreadContext().getBook(), null, provider.getBgFormInfo().getBgScheme().getId().toString(), adjustMap, provider.getBgFormInfo().getBgVersion().getNumber(), provider.getBgFormInfo().getProcessType());
    }

    public static void showAdjust(CoreUI ownerUI, KDMenuItem memuItemShowAdjust, Book book, String orgUnitId, String bgSchemeId, Map adjustMap, String versionNum, BgProcessEnum processType) {
        ShowAdjustSwingWorker worker = new ShowAdjustSwingWorker(ownerUI, memuItemShowAdjust, book, orgUnitId, bgSchemeId, false, adjustMap, versionNum, processType);
        worker.start();
    }

    public static void showAdjust(Book book, String orgUnitId, String bgSchemeId, boolean isShowAdjust, Map adjustMap, String versionNum, BgProcessEnum processType) {
        ShowAdjustSwingWorker worker = new ShowAdjustSwingWorker(null, null, book, orgUnitId, bgSchemeId, isShowAdjust, adjustMap, versionNum, processType);
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runShowAdjust(CoreUI owner, KDMenuItem memuItemShowAdjust, Book book, String orgUnitId, String bgSchemeId, Map adjsutMap, String versionNum, BgProcessEnum processType) throws EASBizException, BOSException {
        if (book == null || memuItemShowAdjust == null) {
            return;
        }
        try {
            boolean isShowAdjust = ActionShowAdjust.isShowAdjust(memuItemShowAdjust);
            memuItemShowAdjust.setEnabled(false);
            ActionShowAdjust.runShowAdjust(book, orgUnitId, bgSchemeId, isShowAdjust, adjsutMap, versionNum, processType);
            memuItemShowAdjust.setUserObject((Object)(isShowAdjust ? HIDE_ADJUST : SHOW_ADJUST));
            memuItemShowAdjust.setText(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)(isShowAdjust ? HIDE_ADJUST : SHOW_ADJUST)));
        }
        finally {
            memuItemShowAdjust.setEnabled(true);
        }
    }

    public static boolean isShowAdjust(KDMenuItem memuItemShowAdjust) {
        return !HIDE_ADJUST.equals(memuItemShowAdjust.getUserObject());
    }

    private static void runShowAdjust(Book book, String orgUnitId, String bgSchemeId, boolean isShowAdjust, Map adjustMap, String versionNum, BgProcessEnum processType) throws BOSException, EASBizException {
        String orgId;
        ItemFormula itemFormula;
        Cell cell;
        Sheet sheet;
        Map<String, Set<String>> formulas = new HashMap();
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    cell = sheet.getCell(r, c, false);
                    itemFormula = BgNFSHelper.getItemFormula(cell);
                    if (itemFormula == null) continue;
                    orgId = itemFormula.getExt("ORGUNITID");
                    if (orgId == null) {
                        orgId = orgUnitId;
                    }
                    if (!formulas.containsKey(orgId)) {
                        formulas.put(orgId, new HashSet());
                    }
                    ((Set)formulas.get(orgId)).add(itemFormula.getFormula());
                }
            }
        }
        formulas = BgAdjustFacadaFactory.getRemoteInstance().checkHasAdjust(bgSchemeId, formulas, versionNum, processType);
        if (formulas.isEmpty()) {
            return;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgSchemeId);
        String bgOrgViewId = schemeHelper.getBgOrgViewId();
        HashMap<String, BgOrgUnitInfo> bgOrgUnitMap = new HashMap<String, BgOrgUnitInfo>();
        BgSheetRange editRange = null;
        BgSheetRange lockRange = null;
        boolean hasAdjust = false;
        StyleAttributes edit = Styles.getEmptySA();
        edit.setBackground(BgNConstants.EDIT_COLOR);
        StyleAttributes base = Styles.getEmptySA();
        base.setBackground(BgNConstants.BASE_COLOR);
        StyleAttributes lockStyle = Styles.getEmptySA();
        lockStyle.setBackground(BgNConstants.LOCK_COLOR);
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            editRange = new BgSheetRange(sheet);
            BgSheetRange baseRange = new BgSheetRange(sheet);
            lockRange = new BgSheetRange(sheet);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    BgOrgUnitInfo bgOrgUnitInfo;
                    cell = sheet.getCell(r, c, false);
                    itemFormula = BgNFSHelper.getItemFormula(cell);
                    if (itemFormula == null) continue;
                    orgId = itemFormula.getExt("ORGUNITID");
                    if (orgId == null) {
                        orgId = orgUnitId;
                    }
                    if (!bgOrgUnitMap.containsKey(orgId) && (bgOrgUnitInfo = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitInfo("select id, number, name, isLeaf, orgUnitID, viewID where viewID = '" + bgOrgViewId + "' and orgUnitID = '" + orgId + "' and isVirtual = 0")) != null) {
                        bgOrgUnitMap.put(orgId, bgOrgUnitInfo);
                    }
                    boolean bl = hasAdjust = ActionShowAdjust.checkHasAdjust(formulas, orgId, itemFormula.getFormula()) && isShowAdjust || ActionShowAdjust.checkHasAdjusting(adjustMap, orgId, itemFormula.getFormula());
                    if (hasAdjust) {
                        if (BgNConstants.EDIT_COLOR.equals(BgNFSHelper.getBackGroup(cell))) continue;
                        editRange.addCell(r, c);
                        if (BgNConstants.BASE_COLOR.equals(BgNFSHelper.getBackGroup(cell))) continue;
                        BgNFSHelper.setAdjustBeforeColor(cell, BgNFSHelper.getBackGroup(cell));
                        continue;
                    }
                    if (!BgNConstants.EDIT_COLOR.equals(BgNFSHelper.getBackGroup(cell)) || !ActionShowAdjust.checkHasAdjust(formulas, orgId, itemFormula.getFormula())) continue;
                    if (BgNFSHelper.getAdjustBeforeColor(cell) != null) {
                        BgNFSHelper.setBackGroup(cell, BgNFSHelper.getAdjustBeforeColor(cell));
                        continue;
                    }
                    if (!((BgOrgUnitInfo)bgOrgUnitMap.get(orgId)).isIsLeaf()) {
                        lockRange.addCell(r, c);
                        continue;
                    }
                    if (ActionShowAdjust.checkHasAdjusting(adjustMap, orgId, itemFormula.getFormula())) continue;
                    baseRange.addCell(r, c);
                }
            }
            Range rg = editRange.getRange();
            if (rg != null) {
                rg.setIgnoreProtected(true);
                rg.setStyle(edit, Styles.getEmptySA());
            }
            if ((rg = baseRange.getRange()) != null) {
                rg.setIgnoreProtected(true);
                rg.setStyle(base, Styles.getEmptySA());
            }
            if ((rg = lockRange.getRange()) == null) continue;
            rg.setIgnoreProtected(true);
            rg.setStyle(lockStyle, Styles.getEmptySA());
        }
    }

    private static boolean checkHasAdjust(Map<String, Set<String>> formulas, String orgId, String formula) {
        if (formulas == null || StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)formula) || !formulas.containsKey(orgId)) {
            return false;
        }
        return formulas.get(orgId).contains(formula);
    }

    private static boolean checkHasAdjusting(Map adjustMap, String orgId, String formula) {
        if (adjustMap == null || StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)formula) || !adjustMap.containsKey(orgId)) {
            return false;
        }
        BgAdjustFormDiversityData data = (BgAdjustFormDiversityData)((Map)adjustMap.get(orgId)).get(formula);
        if (data == null) {
            return false;
        }
        return !MbgAdjustHelper.compareDivValue(data.getNewValue(), data.getOldValue());
    }

    private static class ShowAdjustSwingWorker
    extends SwingWorker {
        private CoreUI owner;
        private Book book;
        private KDMenuItem memuItemShowAdjust;
        private String orgUnitId;
        private String bgSchemeId;
        private boolean isShowAdjust;
        private Map adjustMap;
        private String versionNum;
        private BgProcessEnum processType;

        private ShowAdjustSwingWorker(CoreUI owner, KDMenuItem memuItemShowAdjust, Book book, String orgUnitId, String bgSchemeId, boolean isShowAdjust, Map adjustMap, String versionNum, BgProcessEnum processType) {
            this.owner = owner;
            this.memuItemShowAdjust = memuItemShowAdjust;
            this.book = book;
            this.orgUnitId = orgUnitId;
            this.bgSchemeId = bgSchemeId;
            this.isShowAdjust = isShowAdjust;
            this.adjustMap = adjustMap;
            this.versionNum = versionNum;
            this.processType = processType;
        }

        public Object construct() {
            try {
                if (this.memuItemShowAdjust != null) {
                    ActionShowAdjust.runShowAdjust(this.owner, this.memuItemShowAdjust, this.book, this.orgUnitId, this.bgSchemeId, this.adjustMap, this.versionNum, this.processType);
                } else {
                    ActionShowAdjust.runShowAdjust(this.book, this.orgUnitId, this.bgSchemeId, this.isShowAdjust, this.adjustMap, this.versionNum, this.processType);
                }
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
            }
            return null;
        }
    }
}

