/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.action.actions.viewListForm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.Excel2007Reader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.ma.base.client.utils.BgFileUtil;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.MbgViewListFormProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.AbstractAction;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.viewListForm.MBGViewListBaseFormContextManager;
import com.kingdee.eas.ma.mbg.common.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormAdjustProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MbgViewlistMeasureUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.tools.datatask.util.GlobalFunction;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class ActionImport
extends AbstractAction {
    private static final long serialVersionUID = -1852291174579656944L;

    @Override
    protected boolean hasIcon() {
        return true;
    }

    @Override
    protected Icon getIcon() {
        return EASResource.getIcon((String)"imgTbtn_input");
    }

    @Override
    protected boolean hasKeyStroke() {
        return true;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(73, 2);
    }

    @Override
    protected String getName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.ActionResource", (String)"actionImport");
    }

    public void actionPerformed(ActionEvent e) {
        File file;
        BgSpreadCoreViewUI processUI = (BgSpreadCoreViewUI)this.uiObj;
        KDFileChooser fileChooser = null;
        BgFileUtil bgFileUtil = new BgFileUtil();
        try {
            fileChooser = bgFileUtil.getFileChooserForImp((Object)processUI);
        }
        catch (BOSException e1) {
            processUI.handUIExceptionAndAbort((Exception)((Object)e1));
        }
        fileChooser.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "fileImport"));
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        fileChooser.setFileFilter((FileFilter)new Excel2007FileFilter());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)processUI)) == 0 && (file = fileChooser.getSelectedFile()) != null && file.isFile()) {
            String fileName = file.getPath();
            String sen = GlobalFunction.getFileExtension((String)fileName);
            KDSBook books = null;
            if (sen.equals("xlsx")) {
                books = POIXlsxReader.parse((String)fileName);
                if (books == null) {
                    try {
                        books = new Excel2007Reader().parse(fileName);
                    }
                    catch (Exception exception) {}
                }
            } else {
                books = POIXlsReader.parse((String)fileName);
            }
            if (books == null) {
                MsgBox.showInfo((Component)((Object)processUI), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"openFileError"));
                return;
            }
            try {
                Method method = processUI.getClass().getMethod("isViewListImportCheck", null);
                boolean isViewListImportCheck = false;
                if (method != null) {
                    isViewListImportCheck = (Boolean)method.invoke((Object)processUI, null);
                }
                if (isViewListImportCheck) {
                    ActionImport.checkViewImport(books, ((MBGViewListBaseFormContextManager)processUI.getContextManager()).getSpreadContext().getBook(), null);
                }
                ActionImport.importBookContent(books, processUI);
                bgFileUtil.storeDefaultPathForIMP((Object)fileName, (Object)processUI);
                processUI.updateUI();
                processUI.setMessageText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"success"));
                processUI.showMessage();
            }
            catch (Exception ex) {
                processUI.handUIExceptionAndAbort(ex);
            }
        }
    }

    public static void importForm(File file, BgSpreadCoreViewUI processUI, String[] sheetNames) {
        BgFileUtil bgFileUtil = new BgFileUtil();
        if (file != null && file.isFile()) {
            String fileName = file.getPath();
            String sen = GlobalFunction.getFileExtension((String)fileName);
            KDSBook books = null;
            if (sen.equals("xlsx")) {
                books = POIXlsxReader.parse((String)fileName);
                if (books == null) {
                    try {
                        books = new Excel2007Reader().parse(fileName);
                    }
                    catch (Exception exception) {}
                }
            } else {
                books = POIXlsReader.parse((String)fileName);
            }
            if (books == null) {
                MsgBox.showInfo((Component)((Object)processUI), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"openFileError"));
                return;
            }
            try {
                Method method = processUI.getClass().getMethod("isViewListImportCheck", null);
                boolean isViewListImportCheck = false;
                if (method != null) {
                    isViewListImportCheck = (Boolean)method.invoke((Object)processUI, null);
                }
                if (isViewListImportCheck) {
                    ActionImport.checkViewImport(books, ((MBGViewListBaseFormContextManager)processUI.getContextManager()).getSpreadContext().getBook(), sheetNames);
                }
                ActionImport.importBookContent(books, processUI, sheetNames);
                bgFileUtil.storeDefaultPathForIMP((Object)fileName, (Object)processUI);
                processUI.updateUI();
                processUI.setMessageText(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"success"));
                processUI.showMessage();
            }
            catch (Exception ex) {
                processUI.handUIExceptionAndAbort(ex);
            }
        }
    }

    protected static void checkViewImport(KDSBook kdsBook, Book book, String[] sheetNames) throws Exception {
        for (int i = 0; i < sheetNames.length; ++i) {
            KDSSheet kdsSheet = kdsBook.getSheet((Object)sheetNames[i]);
            Sheet bookSheet = book.getSheet(sheetNames[i]);
            if (bookSheet == null) continue;
            ActionImport.checkSheet(kdsSheet, bookSheet);
        }
    }

    private static void checkSheet(KDSSheet kdsSheet, Sheet bookSheet) throws EASBizException {
        int kdsRowCount = kdsSheet.getRowCount();
        int kdsColCount = kdsSheet.getExpandedColumns() + 1;
        String sheetName = bookSheet.getSheetName();
        KDSCell kdsCell = null;
        Cell bookCell = null;
        for (int row = 0; row < kdsRowCount; ++row) {
            for (int col = 0; col < kdsColCount; ++col) {
                kdsCell = kdsSheet.getCell(row, col, false);
                if (kdsCell == null || (bookCell = bookSheet.getCell(row, col, true)).isLocked()) continue;
                String cellName = bookCell.getName(false, false);
                if (BgNFSHelper.checkHasItemFormula(bookCell)) {
                    Object replaceValue;
                    if (EmptyUtil.isEmpty((Object)kdsCell.getValue()) || 0 == kdsCell.getType()) continue;
                    if (kdsCell.getValue() != null && kdsCell.getValue().toString().indexOf("%") != -1) {
                        replaceValue = kdsCell.getValue().toString().replaceAll("%", "");
                        if (BgNFSHelper.checkIsNumeric(replaceValue)) continue;
                        Object[] sheetcell = new Object[]{sheetName, cellName};
                        throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"388_ActionImport", (Object[])sheetcell)));
                    }
                    if (kdsCell.getValue() != null) {
                        try {
                            replaceValue = new BigDecimal(kdsCell.getValue().toString());
                            continue;
                        }
                        catch (Exception e) {
                            Object[] sheetcell = new Object[]{sheetName, cellName};
                            throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"388_ActionImport", (Object[])sheetcell)));
                        }
                    }
                    Object[] sheetcell = new Object[]{sheetName, cellName};
                    throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"388_ActionImport", (Object[])sheetcell)));
                }
                if (MbgViewListDescriptionHelper.checkHashDescriptionFormula(ActionImport.getFirstCell(bookCell)) || ViewListHelper.checkIsEditNoteCell(ActionImport.getFirstCell(bookCell)) || (kdsCell.getValue() == null || StringUtils.isEmpty((String)kdsCell.getValue().toString())) && (bookCell.getValue() == Variant.nullVariant || bookCell.getValue() == null)) continue;
                CellBlock _mergeBlock = bookSheet.getMergeBlock(bookCell);
                if (_mergeBlock != null && Boolean.TRUE.equals(bookSheet.getRange(_mergeBlock).getUserObject("row_member_merge"))) {
                    bookCell = bookSheet.getCell(_mergeBlock.getRow(), _mergeBlock.getCol(), false);
                }
                ActionImport.checkImportData(sheetName, kdsCell, bookCell, cellName);
            }
        }
    }

    private static void checkImportData(String sheetName, KDSCell kdsCell, Cell bookCell, String cellName) throws EASBizException {
        Object[] sheetcell = new Object[]{sheetName, cellName};
        if (!StringUtils.isEmpty((String)kdsCell.getFormula()) && bookCell.hasFormula() && !kdsCell.getFormula().equals(bookCell.getFormula())) {
            throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"389_ActionImport", (Object[])sheetcell)));
        }
        if (kdsCell.getType() == 0) {
            try {
                new BigDecimal(kdsCell.getValue().toString());
            }
            catch (NumberFormatException e) {
                throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"390_ActionImport", (Object[])sheetcell)));
            }
            try {
                if (bookCell.getValue() != Variant.nullVariant) {
                    new BigDecimal(bookCell.getValue().toString());
                }
            }
            catch (NumberFormatException e) {
                throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"391_ActionImport", (Object[])sheetcell)));
            }
        }
        if ((bookCell = ActionImport.getFirstCell(bookCell)) == null || bookCell.getValue() != Variant.nullVariant && !kdsCell.getValue().toString().equals(bookCell.getValue().toString())) {
            throw new EASBizException(new NumericExceptionSubItem("021", BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"392_ActionImport")));
        }
    }

    protected static Cell getFirstCell(Cell bookCell) {
        if (bookCell != null && bookCell.getMerge(true) != null) {
            bookCell = bookCell.getSheet().getFirstCell(bookCell.getMerge(true), false);
        }
        return bookCell;
    }

    protected static void importBookContent(KDSBook kdsBook, BgSpreadCoreViewUI processUI, String[] sheetNames) throws Exception {
        if (kdsBook == null) {
            MsgBox.showWarning((Component)((Object)processUI), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"openFileError"));
            SysUtil.abort();
        }
        MBGViewListBaseFormContextManager contextManager = (MBGViewListBaseFormContextManager)processUI.getContextManager();
        Book _book = contextManager.getSpreadContext().getBook();
        _book.setCalculate(false);
        HashMap<String, Object> _tmpMap = new HashMap<String, Object>();
        _tmpMap.put("IMPORT_BOOK", _book);
        _tmpMap.put("IMPORT_KDSBOOK", kdsBook);
        _tmpMap.put("IMPORT_SHEET", sheetNames);
        _tmpMap.put("MbgViewlistMeasureUnitHelper", ActionImport.getViewlistMeasureUnitHelper(contextManager));
        _tmpMap.put("IMPORT_BGFORMULA", ((IBgNumberCellDisplayHelper)((Object)processUI)).getFormulaMap());
        _tmpMap.put("IMPORT_DATA", ActionImport.getImportData(processUI));
        _tmpMap.put("IMPORT_FIRECELLCHANGE", true);
        BgNFCHelper.importExcel(_tmpMap);
        Book backupBook = null;
        if (_book != null) {
            backupBook = IOHelper.unpackBook((byte[])IOHelper.packBook((Book)_book));
        }
        MBGViewListFormAdjustProvider adjustProvier = null;
        boolean isAdjustSave = true;
        if (contextManager.getProvider() instanceof MBGViewListFormAdjustProvider) {
            adjustProvier = (MBGViewListFormAdjustProvider)contextManager.getProvider();
            isAdjustSave = adjustProvier.isAdjustSave();
        }
        if (contextManager.getOwnerUI() instanceof MbgViewListFormProcessUI) {
            try {
                ((MbgViewListFormProcessUI)contextManager.getOwnerUI()).actionCalculate_actionPerformed(new ActionEvent(contextManager.getOwnerUI(), 0, MBGFormProcessUI.class.getName() + "$ActionCalculate"));
            }
            catch (Exception e1) {
                contextManager.getOwnerUI().handUIExceptionAndAbort(e1);
            }
        }
        if (backupBook != null) {
            ActionImport.synNoChangeData(_book, backupBook);
        }
        if (adjustProvier != null && !isAdjustSave) {
            adjustProvier.setAdjustSave(isAdjustSave);
        }
        contextManager.getSpreadContext().getSpread().repaint();
    }

    protected static void importBookContent(KDSBook kdsBook, BgSpreadCoreViewUI processUI) throws Exception {
        ActionImport.importBookContent(kdsBook, processUI, null);
    }

    private static void synNoChangeData(Book _book, Book backupBook) {
        if (_book == null || backupBook == null) {
            return;
        }
        Sheet _sheet = null;
        Sheet _backupSheet = null;
        Cell _cell = null;
        Cell _backupCell = null;
        for (int s = 0; s < _book.getSheetCount(); ++s) {
            _sheet = _book.getSheet(s);
            _backupSheet = backupBook.getSheet(s);
            for (int r = 0; r <= _sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= _sheet.getMaxColIndex(); ++c) {
                    _cell = _sheet.getCell(r, c, false);
                    _backupCell = _backupSheet.getCell(r, c, false);
                    if (!MbgViewListDescriptionHelper.checkHashDescriptionFormula(_cell)) continue;
                    BgNFSHelper.setValue(_cell, BgNFSHelper.getValue(_backupCell));
                }
            }
        }
    }

    protected static Boolean getImportData(BgSpreadCoreViewUI processUI) {
        return Boolean.TRUE;
    }

    @Override
    protected String getShortDescription() {
        return BgViewClientHelper.getString("ActionImportName");
    }

    @Override
    protected String getLongDescription() {
        return BgViewClientHelper.getString("ActionImportName");
    }

    private static MbgViewlistMeasureUnitHelper getViewlistMeasureUnitHelper(MBGViewListBaseFormContextManager contextManager) throws BOSException {
        Map elementObjMap = BgElementHelper.getElementoObjMap();
        MbgViewlistMeasureUnitHelper viewlistMeasureHelper = new MbgViewlistMeasureUnitHelper(contextManager.getProvider().getAccountDataTypeMap(), contextManager.getProvider().getTemplateStyle(), elementObjMap);
        return viewlistMeasureHelper;
    }
}

