/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.analysisReport;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.mutex.IVOChangeListener;
import com.kingdee.eas.framework.client.mutex.VOChangeEvent;
import com.kingdee.eas.ma.mbg.BgAnalysRptTemplateFactory;
import com.kingdee.eas.ma.mbg.client.BgAnalysReportListUI;
import com.kingdee.eas.ma.mbg.client.BgAnalysRptTemplateEditUI;
import com.kingdee.eas.ma.mbg.client.BgAnalysRptTemplateListUI;
import com.kingdee.eas.ma.mbg.client.analysisReport.FileHandle;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.utils.analysisReport.BgAnalysRptUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.NumericException;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class BgAnalysRptClientUtil {
    public static final String RES = "com.kingdee.eas.ma.mbg.BgAnalysRptTemplateResource";
    private static final Logger logger = CoreUIObject.getLogger(BgAnalysRptClientUtil.class);

    public static void saveThread(String filePath, String boID, String schemeId, IRow row, boolean isCanEdit, Component owner, boolean isRpt) throws Exception {
        BgAnalysRptClientUtil.saveThread(filePath, boID, schemeId, row, isCanEdit, owner, isRpt, false);
    }

    public static void saveThread(final String filePath, final String boID, final String schemeId, final IRow row, final boolean isCanEdit, final Component owner, final boolean isRpt, final boolean isAddNew) throws Exception {
        Thread.sleep(2000L);
        Thread saveThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    long time;
                    long timeout = 5000L;
                    for (time = 0L; time < timeout && BgAnalysRptUtil.isFileClose(filePath); time += 200L) {
                        Thread.sleep(200L);
                    }
                    if (time >= timeout) {
                        if (!isAddNew) {
                            BgAnalysRptClientUtil.closeOpenedFile(row, owner, isRpt);
                        }
                        return;
                    }
                    File file = new File(filePath);
                    if (!file.exists()) {
                        if (!isAddNew) {
                            BgAnalysRptClientUtil.closeOpenedFile(row, owner, isRpt);
                        }
                        return;
                    }
                    long lastModified = file.lastModified();
                    long length = file.length();
                    int outTime = 0;
                    while (true) {
                        if (file.lastModified() != lastModified || file.length() != length) {
                            if (!isCanEdit) {
                                owner.setVisible(true);
                                new Thread(){

                                    @Override
                                    public void run() {
                                        MsgBox.showError((Component)owner, (String)EASResource.getString((String)BgAnalysRptClientUtil.RES, (String)(isRpt ? "reportView" : "templateView")));
                                    }
                                }.start();
                                lastModified = file.lastModified();
                                length = file.length();
                                continue;
                            }
                            InputStream inputStream = null;
                            try {
                                if (!StringUtils.isEmpty((String)filePath)) {
                                    String msg;
                                    boolean canSave = true;
                                    inputStream = new FileInputStream(filePath);
                                    XWPFDocument xwpfDocument = new XWPFDocument(inputStream);
                                    Set<String> fetchformulasKeys = BgAnalysRptUtil.getTempWordFormulas(xwpfDocument);
                                    HashSet<String> dynformulasKeys = new HashSet<String>();
                                    BgAnalysRptUtil.getTableFormula(xwpfDocument, dynformulasKeys, true);
                                    if (!(fetchformulasKeys.isEmpty() && dynformulasKeys.isEmpty() || isRpt || StringUtils.isEmpty((String)(msg = BgAnalysRptUtil.checkIndexValide(fetchformulasKeys, dynformulasKeys, schemeId))))) {
                                        new Thread(){

                                            @Override
                                            public void run() {
                                                MsgBox.showDetailAndOK((Component)owner, (String)EASResource.getString((String)BgAnalysRptClientUtil.RES, (String)"saveFail"), (String)msg, (int)1);
                                            }
                                        }.start();
                                        canSave = false;
                                    }
                                    if (canSave) {
                                        if (!BgAnalysRptClientUtil.saveFileToEas(filePath, boID, row, owner, isRpt, isAddNew)) {
                                            new Thread(){

                                                @Override
                                                public void run() {
                                                    MsgBox.showError((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"22_saveError"));
                                                }
                                            }.start();
                                        } else if (owner instanceof BgAnalysRptTemplateEditUI) {
                                            BgNFCHelper.refreshListUI((CoreUI)((BgAnalysRptTemplateEditUI)((Object)owner)));
                                        }
                                        if (owner instanceof BgAnalysRptTemplateListUI) {
                                            BgNFCHelper.refreshListUI((CoreUI)((BgAnalysRptTemplateListUI)((Object)owner)));
                                        }
                                        if (owner instanceof BgAnalysReportListUI) {
                                            BgNFCHelper.refreshListUI((CoreUI)((BgAnalysReportListUI)((Object)owner)));
                                        }
                                        if (!isRpt) {
                                            fetchformulasKeys = BgAnalysRptUtil.getTempWordFormulas(xwpfDocument);
                                            dynformulasKeys = new HashSet();
                                            BgAnalysRptUtil.getTableFormula(xwpfDocument, dynformulasKeys, true);
                                            BgAnalysRptTemplateFactory.getRemoteInstance().saveRef(schemeId, 1, boID, fetchformulasKeys, dynformulasKeys);
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)"save error.", (Throwable)ex);
                                new Thread(){

                                    @Override
                                    public void run() {
                                        MsgBox.showError((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.rptnotes.ReportNotesResource", (String)"22_saveError"), (String)ex.getMessage());
                                    }
                                }.start();
                            }
                            finally {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                                System.gc();
                            }
                            lastModified = file.lastModified();
                            length = file.length();
                        }
                        if (outTime > 1000) {
                            try {
                                if (BgAnalysRptUtil.isFileClose(filePath)) {
                                    System.gc();
                                    BgAnalysRptClientUtil.deleteFile(filePath, null);
                                    if (!isAddNew) {
                                        BgAnalysRptClientUtil.closeOpenedFile(row, owner, isRpt);
                                    }
                                    return;
                                }
                            }
                            catch (Exception ex) {
                                logger.error((Object)"file is not closed.", (Throwable)ex);
                            }
                            outTime = 0;
                        }
                        1.sleep(600L);
                        outTime += 600;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"saveThread error.", (Throwable)e);
                    ((CoreUI)owner).handUIException((Throwable)e);
                    return;
                }
            }
        };
        saveThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openFile(String filePath) throws Exception {
        File tempbat = File.createTempFile("tempbat", ".bat");
        try (FileWriter fw = null;){
            fw = new FileWriter(tempbat);
            int lp = filePath.lastIndexOf(File.separator);
            filePath = lp == -1 ? "\"" + filePath + "\"" : filePath.substring(0, lp + 1) + "\"" + filePath.substring(lp + 1) + "\"";
            fw.write("start /I " + filePath);
            fw.close();
            String tempbatFullname = tempbat.getPath();
            logger.error((Object)("***tempbatFullname***" + tempbatFullname));
            Process process = Runtime.getRuntime().exec(tempbatFullname);
            while (BgAnalysRptClientUtil.isProcessAlive(process)) {
                Thread.sleep(200L);
            }
            BgAnalysRptClientUtil.deleteFile(tempbat.getPath(), null);
            logger.error((Object)"***open File***");
        }
    }

    private static boolean isProcessAlive(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    protected static void deleteFile(String filePath, String catchPath) throws Exception {
        File catchFile2;
        File file;
        if (!StringUtils.isEmpty((String)filePath) && !(file = new File(filePath)).delete()) {
            System.gc();
            file.delete();
        }
        if (!StringUtils.isEmpty((String)catchPath) && !(catchFile2 = new File(catchPath)).delete()) {
            System.gc();
            catchFile2.delete();
        }
    }

    public static boolean saveFileToEas(String filePath, String boID, IRow row, Component owner, boolean isRpt, boolean isAddNew) throws Exception {
        try {
            if (!StringUtils.isEmpty((String)filePath)) {
                AttachmentUIContextInfo info = new AttachmentUIContextInfo();
                info.setBoID(boID);
                info.setCode("");
                info.setEdit(true);
                info.setBeizhu(" ");
                File attachFile = new File(filePath);
                FileHandle uploadFile = new FileHandle();
                return uploadFile.uploadFile(attachFile, boID, info, owner, row, isRpt, isAddNew);
            }
        }
        catch (Exception e) {
            logger.error((Object)"saveFileToEas error.", (Throwable)e);
            throw new Exception(e);
        }
        return false;
    }

    public static void closeOpenedFile(IRow row, Component owner, boolean isRpt) throws Exception {
        String id = row.getCell("id").getValue().toString();
        if (isRpt) {
            ((BgAnalysReportListUI)((Object)owner)).closeFile(id);
        } else {
            ((BgAnalysRptTemplateListUI)((Object)owner)).closeFile(id);
        }
    }

    public static void handleMutexLock(IVOChangeListener listener, String id, Component owner, boolean requestLock) throws Exception {
        BgAnalysRptClientUtil.handleMutexLock(listener, id, owner, requestLock, true);
    }

    public static void handleMutexLock(IVOChangeListener listener, String id, Component owner, boolean requestLock, boolean isAbort) throws Exception {
        try {
            if (listener != null && id != null) {
                VOChangeEvent e = new VOChangeEvent((Object)owner);
                e.setState(requestLock ? OprtState.EDIT : "RELEASEALL");
                if (!StringUtils.isEmpty((String)id)) {
                    if (requestLock) {
                        e.setNewObjectId(id);
                    } else {
                        e.setCurrentObjectId(id);
                    }
                }
                listener.change(e);
            }
        }
        catch (Throwable e) {
            logger.error((Object)"handleMutexLock error.", e);
            if (isAbort) {
                ((ListUI)owner).handUIException(e);
                ((ListUI)owner).setCursorOfDefault();
                SysUtil.abort();
            }
            if (e instanceof NumericException) {
                throw new Exception(e.getMessage());
            }
            throw new Exception(e);
        }
    }

    public static IRow setSelectRow(KDTable tblMain, String keyField, Object keyValue) throws Exception {
        if (!StringUtils.isEmpty((String)keyField) && keyValue != null) {
            int rowCount = tblMain.getRowCount();
            Object curKey = null;
            IRow row = null;
            ICell cell = null;
            for (int i = 0; i < rowCount; ++i) {
                row = tblMain.getRow(i);
                if (row == null || (cell = row.getCell(keyField)) == null || (curKey = cell.getValue()) == null || !curKey.equals(keyValue)) continue;
                tblMain.getSelectManager().select(i, 0);
                tblMain.getLayoutManager().scrollRowToShow(i);
                return row;
            }
        }
        return null;
    }

    public static Object getSelectedKeyValue(KDTable tblMain, String keyField) throws Exception {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)tblMain);
        if (selectRows != null && selectRows.length > 0) {
            Object key = tblMain.getRow(selectRows[0]).getCell(keyField).getValue();
            return key;
        }
        return null;
    }
}

