/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.autoFilter;

import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.ma.mbg.client.autoFilter.DimensionMemberAutoFilterButton;
import com.kingdee.eas.ma.mbg.client.autoFilter.DimensionMemberAutoFilterHelper;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class AutoFilterRender
implements IRenderProvider,
IBasicRender {
    private BgDimensionBaseInfo dimension = null;
    private Icon icon = EASResource.getIcon((String)"imgTbtn_pzjlq");
    private BookContextManager context;
    private final Map<String, DimensionMemberAutoFilterButton> filterButtions = new HashMap<String, DimensionMemberAutoFilterButton>();

    public AutoFilterRender(BookContextManager context) {
        this.context = context;
    }

    public IBasicRender getRender(Cell cell, int viewMode) {
        DimensionMemberAutoFilterButton btn = null;
        if (!this.context.getProvider().getMemberFilter().isEnableFilter()) {
            this.filterButtions.clear();
            return null;
        }
        this.dimension = DimensionMemberAutoFilterHelper.getFilterDimension(cell);
        if (cell == null) {
            return null;
        }
        String cellName = this.getCellName(cell);
        if (this.dimension == null) {
            btn = this.filterButtions.remove(cellName);
            if (btn != null) {
                btn.getOwnerSv().remove((Component)((Object)btn));
            }
        } else {
            if (this.filterButtions.containsKey(cellName)) {
                btn = this.filterButtions.get(cellName);
            } else {
                btn = new DimensionMemberAutoFilterButton(this.context, cell);
                this.filterButtions.put(cellName, btn);
            }
            btn.resetIcon();
            SpreadView sv = this.getSpreadView(cell);
            if (sv == null) {
                return null;
            }
            sv.remove((Component)((Object)btn));
            Rectangle rect = SheetBaseMath.getActualCellRect((Sheet)cell.getSheet(), (int)cell.getRow(), (int)cell.getCol(), (boolean)true);
            btn.setBounds(rect.x + rect.width - 16, rect.y + rect.height - 16, 16, 16);
            btn.setPoplistDimension(new Dimension(rect.width, 16));
            btn.setOwnerSv(sv);
            sv.add((Component)((Object)btn));
        }
        return null;
    }

    private SpreadView getSpreadView(Cell cell) {
        KDSpread spread = this.context.getSpreadContext().getSpread();
        int fhC = spread.getFixHorizonCount();
        int fvC = spread.getFixVerticalCount();
        int hC = spread.getHorizonCount();
        int vC = spread.getVerticalCount();
        for (int i = fvC; i < vC; ++i) {
            for (int j = fhC; j < hC; ++j) {
                SpreadView sv = (SpreadView)spread.getView(i, j);
                if (sv.getFirstRow() > cell.getRow() || sv.getEndRow() < cell.getRow() || sv.getFirstCol() > cell.getCol() || sv.getEndCol() < cell.getCol()) continue;
                return sv;
            }
        }
        return null;
    }

    public static void clearButton(SpreadContext spreadContext) {
        KDSpread spread = spreadContext.getSpread();
        int fhC = spread.getFixHorizonCount();
        int fvC = spread.getFixVerticalCount();
        int hC = spread.getHorizonCount();
        int vC = spread.getVerticalCount();
        for (int i = fvC; i < vC; ++i) {
            for (int j = fhC; j < hC; ++j) {
                SpreadView sv = (SpreadView)spread.getView(i, j);
                for (int c = sv.getComponentCount() - 1; c >= 0; --c) {
                    if (!(sv.getComponent(c) instanceof DimensionMemberAutoFilterButton)) continue;
                    sv.remove(c);
                }
            }
        }
    }

    private String getCellName(Cell cell) {
        return cell.getName(false, true);
    }

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
    }

    public void fireDimensionChanged() {
        for (DimensionMemberAutoFilterButton btn : this.filterButtions.values()) {
            btn.getOwnerSv().remove((Component)((Object)btn));
        }
        this.filterButtions.clear();
    }
}

