/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.common;

import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.PromptPanel;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.FormulaPicker;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.event.FormulaPickListener;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.NewRptContextManager;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.client.common.AbstractFormulaManager;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.utils.ICanModifyItemFormula;
import com.kingdee.eas.ma.mbg.client.utils.MbgItemFormulaChangeEvent;
import com.kingdee.eas.ma.mbg.client.utils.MbgItemFormulaChangeListener;
import com.kingdee.eas.ma.mbg.client.utils.MbgItemFormulaPanel;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;

public class FormulaManager
extends AbstractFormulaManager {
    private BookContextManager contextManager;

    public FormulaManager(SpreadContext spreadContext, BookContextManager contextManager) {
        super(spreadContext);
        this.contextManager = contextManager;
    }

    @Override
    public void doInit() {
        this.registerDefaultFormulaWizard();
        this.registerDefaultItemFormulaWizard();
    }

    @Override
    public void registerDefaultFormulaWizard() {
        FormulaPicker wizzard = null;
        try {
            wizzard = new FormulaPicker((Component)this.getSpreadContext());
        }
        catch (Exception exception) {
            // empty catch block
        }
        wizzard.setRptContextManager((RptContextManager)this.getRptContext());
        this.getSpreadContext().getFacadeManager().putWizzard(FacadeManager.WIZZARD_Formula, (ISpreadWizzard)wizzard);
        wizzard.setFormulaPickListener(new FormulaPickListener(){

            public String pickFormulaLine() {
                Range range = FormulaManager.this.getSpreadContext().getBook().getActiveCellRange();
                return range.getFormula();
            }

            public void setFormulaLine(String line) {
                FormulaManager.this.getSpreadContext().getRangeManager().getActiveCellRange().setFormula('=' + line);
            }
        });
    }

    protected NewRptContextManager getRptContext() {
        NewRptContextManager ctx = new NewRptContextManager();
        ctx.setPropertyAdapter(this.getReportAdapter());
        return ctx;
    }

    public IReportPropertyAdapter getReportAdapter() {
        if (this.contextManager instanceof BookContextManager) {
            return this.contextManager.getReportAdapter();
        }
        return null;
    }

    @Override
    public void registerDefaultItemFormulaWizard() {
        this.setItemFormulaPanel(new MbgItemFormulaPanel(this.getSpreadContext()));
        FormulaManager.registerDefaultItemFormulaWizard(null, this.getSpreadContext(), this.getItemFormulaPanel(), this.isAdjustPanel());
    }

    public static void registerDefaultItemFormulaWizard(final CoreUI ownerUi, final SpreadContext spreadContext, final MbgItemFormulaPanel itemFormulaPanel, boolean isAdjustPanel) {
        FormulaManager.setItemFormulaLayout(spreadContext, (JComponent)((Object)itemFormulaPanel), isAdjustPanel);
        itemFormulaPanel.setStateChangeListener(new MbgItemFormulaPanel.ItemPanelStateChangeListener(){

            @Override
            public void changeWidth(int newWidth) {
                FormulaManager.setItemFormulaPanelWidth(spreadContext, newWidth);
            }
        });
        itemFormulaPanel.addItemFormulaChangeListener(new MbgItemFormulaChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void formulaChanged(MbgItemFormulaChangeEvent e) {
                Range range = spreadContext.getRangeManager().getActiveCellRange();
                if (StringUtils.isEmpty((String)e.getNewFormula())) {
                    range.setUserObject("ITEM", null);
                } else {
                    ICanModifyItemFormula processUi = null;
                    if (ownerUi instanceof ICanModifyItemFormula) {
                        processUi = (ICanModifyItemFormula)ownerUi;
                    }
                    try {
                        if (processUi != null) {
                            range.setIgnoreProtected(true);
                            processUi.setModifyItemFormula(true);
                        }
                        ItemFormula formula = new ItemFormula();
                        formula.FormulaToObject(e.getNewFormula());
                        range.setUserObject("ITEM", (Object)formula);
                    }
                    finally {
                        if (processUi != null) {
                            processUi.setModifyItemFormula(false);
                            range.setIgnoreProtected(false);
                        }
                    }
                }
            }
        });
        spreadContext.addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                if (e.isSheetActive()) {
                    itemFormulaPanel.refreshItemFormula(e.getSheet().getActiveCellRange(), e.getSheet().getSheetOption().getCellDisplayMode());
                }
            }
        });
        spreadContext.addSheetChangeListener(new SheetChangeListener(){

            public void changed(SheetChangeEvent e) {
                if (spreadContext.getBook().getActiveSheet() != e.getSheet()) {
                    return;
                }
                itemFormulaPanel.refreshItemFormula(e.getSheet().getActiveCellRange(), e.getSheet().getSheetOption().getCellDisplayMode());
            }
        });
    }

    private static void setItemFormulaLayout(SpreadContext spreadContext, JComponent component, boolean isAdjustPanel) {
        PromptPanel pp = spreadContext.getFacadeManager().getPromptPanel();
        pp.setRightComponent(component);
        pp.setAdjustable(isAdjustPanel);
        pp.setDependSecondSize(true);
    }

    protected boolean isAdjustPanel() {
        return true;
    }

    private static void setItemFormulaPanelWidth(SpreadContext spreadContext, int width) {
        PromptPanel pp = spreadContext.getFacadeManager().getPromptPanel();
        pp.getRightComponent().setPreferredSize(new Dimension(width, 10));
        pp.getRightComponent().invalidate();
        pp.validate();
        pp.repaint();
    }

    @Override
    public void setItemFormulaEnable(boolean enabled) {
        this.getItemFormulaPanel().setEnabled(enabled);
    }

    @Override
    public void setItemFormulaProvider(IItemFormulaProvider formulaProvider) {
        Book book;
        this.getItemFormulaPanel().setFormulaProvider(formulaProvider);
        if (this.getSpreadContext().getBook() != null && (book = this.getSpreadContext().getBook()).getActiveSelectionRange() != null) {
            this.getItemFormulaPanel().refreshItemFormula(book.getActiveSelectionRange(), book.getCellDisplayMode());
        }
    }
}

