/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.form;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.CellActionAfterListener;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.MBGAddActualFormProcessUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.template.MBGContextManager;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.MbgFormAnalyseCommonExplorer;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.FixAndMbgMeasureCellActionAfterListener;
import com.kingdee.eas.ma.mbg.common.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.provider.MBGProvider;
import com.kingdee.eas.ma.mbg.provider.form.MBGBaseFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class MBGBaseFormContextManager
extends MBGContextManager {
    private KDTabbedPane tabbedPane = null;
    private boolean initWebKit = false;
    private Set<String> refeshIds = new HashSet<String>();

    public MBGBaseFormContextManager(Map uiContext, CoreUI owner) {
        super(uiContext, owner);
    }

    @Override
    public Component getPageDimensionPanel(IMbgViewManager mbgViewManager) throws Exception {
        KDPanel kdPanel = this.getMainPanel();
        kdPanel.removeAll();
        if (this.tabbedPane == null) {
            this.tabbedPane = new KDTabbedPane();
        }
        kdPanel.add((Component)this.tabbedPane, (Object)"Center");
        Component component = null;
        SpreadContext sc = this.getSpreadContext();
        int activeSheetIndex = sc.getBook().getActiveSheetIndex();
        if (this.hasViewOrPageDimension(mbgViewManager, activeSheetIndex)) {
            component = this.parseViewOrPageBgDimension(activeSheetIndex);
        }
        MbgFormAnalyseCommonExplorer.addDataPanel(this.tabbedPane, component, sc);
        if (this.getProvider().getBgSchemeInfo().isIsEnableAnalyse()) {
            try {
                new MbgFormAnalyseCommonExplorer().addAnalysePanel(this.getProvider(), this.tabbedPane);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MBGBaseFormContextManager.this.viewShow_stateChanged(e);
            }
        });
        this.tabbedPane.setSelectedIndex(0);
        kdPanel.revalidate();
        return kdPanel;
    }

    protected void viewShow_stateChanged(ChangeEvent e) {
        KDTabbedPane tabPane = (KDTabbedPane)e.getSource();
        if (tabPane.getSelectedIndex() != 0 && tabPane.getSelectedIndex() == 1) {
            KDPanel analyse = (KDPanel)tabPane.getSelectedComponent();
            if (analyse.getComponentCount() == 0) {
                try {
                    MbgFormAnalyseCommonExplorer utils = new MbgFormAnalyseCommonExplorer(tabPane, analyse, this.getProvider());
                    utils.onLoad();
                    analyse.add((Component)((Object)utils));
                }
                catch (Exception e1) {
                    MsgBox.showWarning((Component)this.owner, (String)e1.getMessage());
                    SysUtil.abort();
                }
            } else {
                this.reExcute();
            }
        }
    }

    public void reExtractData() {
        MbgFormAnalyseCommonExplorer.reExtractData(this.tabbedPane, this.refeshIds);
    }

    public void reExcute() {
        MbgFormAnalyseCommonExplorer.reExcute(this.tabbedPane, this.refeshIds);
    }

    public boolean isModifyStyle() {
        return this.getProvider().getCurMbgViewManager().isModifyStyle();
    }

    public boolean isModifyMembers() {
        boolean isModify = false;
        Book book = this.getSpreadContext().getBook();
        for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
            if (!this.isModifyMembers(sheetIndex)) continue;
            isModify = true;
            break;
        }
        return isModify;
    }

    public boolean isModifyMembers(int sheetIndex) {
        Sheet sheet = this.getSpreadContext().getBook().getSheet(sheetIndex);
        if (sheet != null) {
            String curOrgNumForDimensionData = this.getProvider().getOrgNumsForCurSheet(sheetIndex, new HashSet<String>());
            IMbgViewManager iMbgViewManager = this.getProvider().getBgViewManagerForMulOrg().get(curOrgNumForDimensionData);
            if (iMbgViewManager != null && iMbgViewManager.getSheetManagers().size() > sheetIndex) {
                return iMbgViewManager.getSheetManagers().get(sheetIndex).getDimensionManager().isModifyMembers();
            }
        }
        return false;
    }

    public boolean isModifyData() throws EASBizException, BOSException {
        boolean isModify = false;
        Book book = this.getSpreadContext().getBook();
        if (book != null && book.getUndoManager().canUndo()) {
            for (int sheetIndex = 0; sheetIndex < book.getSheetCount(); ++sheetIndex) {
                isModify = this.isModifyData(book.getSheet(sheetIndex));
                if (!isModify) continue;
                return isModify;
            }
        }
        return isModify;
    }

    public boolean isModifyData(Sheet sheet) throws EASBizException, BOSException {
        return ((MBGBaseFormProvider)this.getProvider()).isModifyData(sheet);
    }

    @Override
    public void actionDimensionChange_dataChanged(DataChangeEvent eventObj) throws Exception {
        if (eventObj == null) {
            return;
        }
        KDBizPromptBox prmt = (KDBizPromptBox)eventObj.getSource();
        Object newValueObj = eventObj.getNewValue();
        Object oldValueObj = eventObj.getOldValue();
        if (newValueObj instanceof List && ((List)newValueObj).size() > 0) {
            newValueObj = ((List)newValueObj).get(0);
        }
        if (oldValueObj instanceof List && ((List)oldValueObj).size() > 0) {
            oldValueObj = ((List)oldValueObj).get(0);
        }
        String num1 = null;
        num1 = newValueObj instanceof BgDimensionMember ? ((BgDimensionMember)newValueObj).getNumber() : BgViewHelper.getNumber(newValueObj);
        String num2 = null;
        num2 = oldValueObj instanceof BgDimensionMember ? ((BgDimensionMember)oldValueObj).getNumber() : BgViewHelper.getNumber(oldValueObj);
        if (StringUtils.equals((String)num1, (String)num2)) {
            return;
        }
        this.getProvider().store(this.getSpreadContext().getBook().getActiveSheet());
        if (this.isModifyData(this.getSpreadContext().getBook().getActiveSheet())) {
            String message = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MBGFormResource", (String)"sheetDataChange");
            int flag = MsgBox.showConfirm3((Component)this.getOwnerUI(), (String)message);
            if (0 == flag) {
                try {
                    ActionEvent e = new ActionEvent(this.owner, 0, this.owner.getClass().getName() + "$ActionSave");
                    ((BgSpreadCoreViewUI)this.owner).getActionsManager().doAction(e);
                }
                catch (Exception e) {
                    prmt.setDataNoNotify(eventObj.getOldValue());
                    throw e;
                }
            } else if (1 != flag) {
                prmt.setDataNoNotify(eventObj.getOldValue());
                return;
            }
        }
        try {
            boolean isSuccess = this.getSpreadContext().getEditManager().stopEditing();
            this.refreshSheet(this.getProvider().getCurMbgSheetManager().getSheetIndex());
            if (isSuccess) {
                this.getSpreadContext().getEditManager().startEditing();
            }
        }
        catch (Exception e) {
            prmt.setDataNoNotify(eventObj.getOldValue());
            throw e;
        }
        if (MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(prmt.getName())) {
            BgViewClientHelper.checkItemDimeinsionEmpty(this.getOwnerUI(), this.getProvider().getBgDimensionManager());
        }
        this.getSpreadContext().getBook().getUndoManager().discardAllEdits();
        this.getOwnerUI().updateUI();
        if (this.getOwnerUI() instanceof MBGFormProcessUI) {
            ((MBGFormProcessUI)this.getOwnerUI()).actionCalculate_actionPerformed(new ActionEvent(this, 0, this.getClass().getName() + "$ActionCalculate"));
        } else if (this.getOwnerUI() instanceof MBGAddActualFormProcessUI) {
            ((MBGAddActualFormProcessUI)this.getOwnerUI()).actionCalculate_actionPerformed(new ActionEvent(this, 0, this.getClass().getName() + "$ActionCalculate"));
        }
    }

    @Override
    public boolean checkBefore() throws Exception {
        if (!OprtState.EDIT.equals(this.getOwnerUI().getOprtState()) && !OprtState.ADDNEW.equals(this.getOwnerUI().getOprtState())) {
            return true;
        }
        boolean isModifyStyle = this.isModifyStyle();
        boolean isModifyMembers = this.isModifyMembers();
        this.getProvider().store(this.getSpreadContext().getBook());
        boolean isModifyData = this.isModifyData();
        if (isModifyData || isModifyStyle || isModifyMembers) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int flag = MsgBox.showConfirm3((Component)this.getOwnerUI(), (String)message);
            if (0 == flag) {
                ActionEvent e = new ActionEvent(this.owner, 0, this.owner.getClass().getName() + "$ActionSave");
                ((BgSpreadCoreViewUI)this.owner).getActionsManager().doAction(e);
            } else if (1 != flag) {
                return false;
            }
        }
        return true;
    }

    @Override
    public IReportPropertyAdapter getReportAdapter() {
        BgRptReportPropertyAdapter adapter = new BgRptReportPropertyAdapter((BgFormInfo)this.getProvider().getEditValue());
        MBGProvider provider = (MBGProvider)this.getProvider();
        FullOrgUnitInfo org = provider.getOrgUnitForCurSheet(0);
        if (org == null) {
            org = provider.getOrgUnitInfo();
        }
        adapter.setOrgUnit(org);
        return adapter;
    }

    @Override
    public void initListener() {
        super.initListener();
        if (this.getOwnerUI() instanceof IBgNumberCellDisplayHelper) {
            this.getSpreadContext().getBook().setCellActionAfterListener((CellActionAfterListener)new FixAndMbgMeasureCellActionAfterListener((IBgNumberCellDisplayHelper)this.getOwnerUI()));
        }
    }
}

