/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.form;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellEditorProvider;
import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.biz.api.BizCalcCaller;
import com.kingdee.eas.ma.biz.api.IBizCalc;
import com.kingdee.eas.ma.mbg.BgDataAssistFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgNFormException;
import com.kingdee.eas.ma.mbg.client.BgSpreadCoreViewUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.autoFilter.DimensionMemberAutoFilterHelper;
import com.kingdee.eas.ma.mbg.client.form.MBGBaseFormContextManager;
import com.kingdee.eas.ma.mbg.client.utils.BgCommentClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgViewClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgPeriodDecomposeUtils;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.provider.IMBGProvider;
import com.kingdee.eas.ma.mbg.provider.form.MBGBaseFormProvider;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormProvider;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionDescriptionHelper;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MBGFormContextManager
extends MBGBaseFormContextManager
implements ICellEditorProvider {
    public MBGFormContextManager(Map uiContext, CoreUI owner) {
        super(uiContext, owner);
    }

    @Override
    protected IMBGProvider createProviderImpl() {
        MBGFormProvider provider = new MBGFormProvider();
        provider.setOwner((CoreUIObject)this.getOwnerUI());
        return provider;
    }

    @Override
    protected void initToolBar(IUIObject ui) {
        super.initToolBar(ui);
        ToolBarManager toolBarManager = this.getSpreadContext().getToolBarManager();
        toolBarManager.setItemVisible("ToolItem_Stylebrush", false);
        toolBarManager.setItemVisible("ToolItem_Merger", false);
        toolBarManager.setItemVisible("ToolItem_Sum", false);
        toolBarManager.setItemVisible("ToolItem_Cut", false);
        toolBarManager.setItemVisible("ToolItem_Hyperlink", false);
        toolBarManager.setItemVisible("ToolItem_Diagonal", false);
        toolBarManager.setItemVisible("ToolItem_SortAscend", false);
        toolBarManager.setItemVisible("ToolItem_SortDecsend", false);
        toolBarManager.setItemVisible("ToolItem_Comment", false);
        toolBarManager.setItemVisible("ToolItem_Locked", false);
        toolBarManager.setItemVisible("ToolItem_Style_Border", false);
        toolBarManager.setItemVisible("ToolItem_Style_Background", false);
        toolBarManager.setItemVisible("ToolItem_Style_FontColor", false);
        toolBarManager.setItemVisible("ToolItem_Style", false);
        toolBarManager.setItemVisible("ToolItem_Focus", false);
        toolBarManager.setItemVisible("ToolItem_CellValue_ToNumber", false);
    }

    @Override
    public void initData() throws Exception {
        super.initData();
        if (this.getOwnerUI() != null) {
            StringBuffer viewParam = new StringBuffer(BgViewClientHelper.getString("view"));
            viewParam.append(" - ");
            StringBuffer nameParam = new StringBuffer(" - ");
            nameParam.append(this.getProvider().getEditValue().get("name").toString());
            this.getOwnerUI().setUITitle(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgNFormResource", (String)this.getOwnerUI().getOprtState(), (Object[])new String[]{viewParam.toString(), nameParam.toString()}));
        }
    }

    @Override
    protected void afterSetEditValue() throws Exception {
        super.afterSetEditValue();
        DimensionMemberAutoFilterHelper.loadMemberFilterMenu((BgSpreadCoreViewUI)this.getOwnerUI(), true);
    }

    @Override
    public Map save() throws Exception {
        BgFormInfo form = (BgFormInfo)this.getProvider().getEditValue();
        BgNFCHelper.checkBgFormInProState((CoreUIObject)this.getOwnerUI(), (IObjectValue)form);
        BgFormHelper.checkBgRollRule(form, this.getProvider().getCurMbgViewManager());
        boolean isModifyStyle = this.isModifyStyle();
        if (isModifyStyle) {
            new MbgXMLParser();
            form.getEntries().get(0).setDimensionStyle(MbgXMLParser.unParseStyle(this.getProvider().getCurMbgViewManager()));
        }
        this.storeWidthStyle(this.getProvider().getCurMbgViewManager());
        this.storeSplitInfo(this.getProvider().getCurMbgViewManager());
        new MbgXMLParser();
        form.getEntries().get(0).setDimensionData(MbgXMLParser.unParse(this.getProvider().getCurMbgViewManager()));
        HashMap<String, IMbgViewManager> orgDimensionDataToSave = new HashMap<String, IMbgViewManager>();
        Map<String, IMbgViewManager> map = this.getProvider().getBgViewManagerForMulOrgByOrgId();
        Map.Entry<String, IMbgViewManager> entry2 = null;
        for (Map.Entry<String, IMbgViewManager> entry2 : map.entrySet()) {
            if (!entry2.getValue().isModifyMembers()) continue;
            if (entry2.getKey().equals(form.getOrgUnit().getId().toString())) {
                new MbgXMLParser();
                form.getEntries().get(0).setDimensionData(MbgXMLParser.unParse(entry2.getValue()));
            }
            orgDimensionDataToSave.put(entry2.getKey(), entry2.getValue());
        }
        this.beforeSaveCheck(this.getSpreadContext().getBook());
        this.getProvider().store(this.getSpreadContext().getBook());
        Map<String, Map<String, BgNViewDataInfo>> bgDataMap = ((MBGBaseFormProvider)this.getProvider()).getBgDataMap();
        BgPeriodDecomposeUtils.mergeBgDecomposeData((CoreUIObject)this.getOwnerUI(), bgDataMap);
        BgViewClientHelper.checkBgDataMap(bgDataMap, 1);
        BgFormFactory.getRemoteInstance().saveView(form, bgDataMap, orgDimensionDataToSave, this.getProvider().getGatherInfos());
        this.getProvider().getGatherInfos().clear();
        BgPeriodDecomposeUtils.clearBgDecomposeDataMap((CoreUIObject)this.getOwnerUI());
        BgDataAssistFactory.getRemoteInstance().saveAssist(((MBGBaseFormProvider)this.getProvider()).getBgFormInfo().getId().toString(), ((MBGBaseFormProvider)this.getProvider()).getBgDescriptionMap());
        BgCommentClientHelper.saveBgComments(this.getSpreadContext().getBook(), ((MBGBaseFormProvider)this.getProvider()).getBgFormInfo());
        ((MBGFormProvider)this.getProvider()).updateBackState(this.getSpreadContext().getBook());
        if (isModifyStyle) {
            this.getProvider().getCurMbgViewManager().copyStyleToOld();
        }
        Iterator iterator = orgDimensionDataToSave.entrySet().iterator();
        while (iterator.hasNext()) {
            ((IMbgViewManager)iterator.next().getValue()).copyAllowEditDimension();
        }
        this.getProvider().fillData(this.getSpreadContext().getBook());
        this.getModifyManager().discardAllEdits();
        this.getOwnerUI().repaint();
        this.showSuccessMsg(EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgViewTemplateResource", (String)"saveSuccess"));
        IBizCalc calc = BizCalcCaller.getInstance();
        calc.runBackUpdate(form.getBgScheme().getId(), form.getOrgUnit().getId(), form.getId());
        return null;
    }

    @Override
    public void afterInit() throws Exception {
        super.afterInit();
        this.getProvider().fillData(this.getSpreadContext().getBook());
    }

    public ICellEditor getEditor(Sheet sheet, int row, int col) {
        if (this.getOwnerUI() instanceof MBGFormProcessUI) {
            return ((MBGFormProcessUI)this.getOwnerUI()).getCellEditor(sheet, row, col);
        }
        return null;
    }

    @Override
    public void initListener() {
        super.initListener();
        this.getSpreadContext().getEditManager().setEditorProvider((ICellEditorProvider)this);
    }

    public void beforeSaveCheck(Book _book) throws Exception {
        Sheet _sheet = null;
        Cell _cell = null;
        boolean hasBgFormula = false;
        int rowCount = 0;
        int colCount = 0;
        int rowIndex = 0;
        int colIndex = 0;
        Object _obj = null;
        BigDecimal _value = null;
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
            _sheet = _book.getSheet(sheetIndex);
            rowCount = _sheet.getMaxRowIndex();
            colCount = _sheet.getMaxColIndex();
            for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                    _cell = _sheet.getCell(rowIndex, colIndex, false);
                    hasBgFormula = BgNFSHelper.checkHasFormulaOfCell(_cell);
                    if (!hasBgFormula || BgNFSHelper.checkIsEmptyValue(_cell)) continue;
                    _obj = BgNFSHelper.getValue(_cell);
                    if (_obj != null) {
                        if (_obj instanceof BigDecimal) {
                            _value = (BigDecimal)_obj;
                        } else {
                            try {
                                _value = new BigDecimal(_obj.toString().trim().replaceAll(",", ""));
                            }
                            catch (Exception ex) {
                                _value = BgNConstants.ZERO;
                            }
                        }
                    } else {
                        _value = BgNConstants.ZERO;
                    }
                    if (!MBGViewListFormClientHelper.checkCanSave(_cell, this.getProvider(), ((MBGFormProvider)this.getProvider()).getEditScenType())) continue;
                    MBGViewListFormClientHelper.checkFormulaValue(_value, rowIndex, colIndex);
                }
            }
            this.checkDesCellValue(_sheet);
        }
    }

    public void checkDesCellValue(Sheet sheet) throws Exception {
        if (sheet == null) {
            return;
        }
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        for (int r = 0; r <= maxRow; ++r) {
            for (int c = 0; c <= maxCol; ++c) {
                Cell cell = sheet.getCell(r, c, false);
                if (!DimensionDescriptionHelper.checkHashDescriptionFormula(cell)) continue;
                String value = null;
                if (Variant.isNull((Variant)cell.getValue()) || cell.getValue() == null || (value = String.valueOf(cell.getValue().getValue())).length() <= 255) continue;
                throw new BgNFormException(BgNFormException.DESCRIPTIONLONG, new String[]{cell.getName(false, false)});
            }
        }
    }
}

