/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.notify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.client.MainStatusBar;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CellDoubleClickListener {
    private static final Logger logger = CoreUIObject.getLogger(CellDoubleClickListener.class);
    private Cell _cell = null;
    private BgFormInfo _bgFormInfo = null;
    private BgActualRecordInfo _bgActualRecordInfo = null;
    private String _editScenario = null;
    private DimensionMemberCheckHelper _helper = null;
    private Map _bgdataMap = null;
    private MainStatusBar _statusBar = null;
    private String res = "com.kingdee.eas.ma.mbg.BgMbgPromtResource";
    private OrgUnitInfo orgInfo = null;
    private Set<String> canEditPeriodNumbers;

    public OrgUnitInfo getOrgInfo() {
        if (this.orgInfo == null) {
            try {
                if (!StringUtils.isEmpty((String)this._helper.getOrgId())) {
                    this.orgInfo = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(this._helper.getOrgId()));
                }
            }
            catch (EASBizException e) {
                logger.error((Object)"CellDoubleClickListener getOrgInfo error:", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"CellDoubleClickListener getOrgInfo error:", (Throwable)e);
            }
        }
        return this.orgInfo;
    }

    public CellDoubleClickListener(MainStatusBar statusBar, Cell cell, BgFormInfo bgFormInfo, String editScenario, DimensionMemberCheckHelper helper, Map bgdataMap) {
        this(statusBar, cell, bgFormInfo, editScenario, helper, bgdataMap, null);
    }

    public CellDoubleClickListener(MainStatusBar statusBar, Cell cell, BgFormInfo bgFormInfo, String editScenario, DimensionMemberCheckHelper helper, Map bgdataMap, Set<String> canEditPeriodNumbers) {
        this._statusBar = statusBar;
        this._cell = cell;
        this._bgFormInfo = bgFormInfo;
        this._editScenario = editScenario;
        this._helper = helper;
        this._bgdataMap = bgdataMap;
        this.canEditPeriodNumbers = canEditPeriodNumbers;
    }

    public CellDoubleClickListener(MainStatusBar statusBar, Cell cell, BgActualRecordInfo bgActualRecordInfo, BgFormInfo bgFormInfo, String editScenario, DimensionMemberCheckHelper helper, Map bgdataMap) {
        this(statusBar, cell, bgFormInfo, editScenario, helper, bgdataMap);
        this._bgActualRecordInfo = bgActualRecordInfo;
    }

    public void doubleClick() {
        String msg = null;
        if (this._cell != null && this._cell.isLocked()) {
            if (this._helper != null && !this._helper.isNeedCheck()) {
                if (this._helper.isDecompose() && BgNFSHelper.checkHasFormulaOfCell(this._cell)) {
                    if (this._bgFormInfo.getProcessType().getValue() == 3) {
                        String name = this._bgFormInfo.getProcessType().getAlias();
                        msg = EASResource.getString((String)this.res, (String)"mbgFormState", (Object[])new Object[]{name});
                    } else {
                        msg = EASResource.getString((String)this.res, (String)"mbgOrgnizationPromt");
                    }
                } else {
                    msg = this.checkVersion();
                    if (StringUtils.isEmpty((String)msg)) {
                        msg = this.checkDimensionMemberIsDetailOrNot();
                    }
                    if (StringUtils.isEmpty((String)msg)) {
                        msg = this.checkBgDataState();
                    }
                    if (StringUtils.isEmpty((String)msg)) {
                        msg = this.checkRollHisPeriod(msg);
                    }
                    if (StringUtils.isEmpty((String)msg)) {
                        msg = EASResource.getString((String)this.res, (String)"mbgLockPromt");
                    }
                }
            } else if (this._helper != null && BgNFSHelper.checkHasFormulaOfCell(this._cell)) {
                msg = this.checkVersion();
                if (StringUtils.isEmpty((String)msg)) {
                    msg = this.checkDimensionMemberIsDetailOrNot();
                }
                if (StringUtils.isEmpty((String)msg)) {
                    msg = this.checkBgDataState();
                }
                if (StringUtils.isEmpty((String)msg)) {
                    msg = this.checkRollHisPeriod(msg);
                }
                if (StringUtils.isEmpty((String)msg)) {
                    msg = EASResource.getString((String)this.res, (String)"mbgLockPromt");
                }
            } else {
                msg = this.checkHeadCell();
                if (StringUtils.isEmpty((String)msg)) {
                    msg = (ViewlistCombinHelper.checkRowIsCombin(this._cell).booleanValue() || ViewListHelper.getDimension(this._cell.getSheet().getRow(this._cell.getRow(), false)) instanceof MbgViewListRowCol && ViewListHelper.getDimension(this._cell.getSheet().getColumn(this._cell.getCol(), false)) instanceof MbgViewListRowCol) && !BgNFSHelper.checkHasFormulaOfCell(this._cell) && !BgNFSHelper.checkHasExpression(this._cell) ? EASResource.getString((String)this.res, (String)"memberNotFull") : EASResource.getString((String)this.res, (String)"mbgLockPromt");
                }
            }
        } else if (this._cell != null) {
            msg = this.checkOtherCell();
        }
        if (!StringUtils.isEmpty(msg)) {
            this.showPromt(msg);
        }
    }

    private String checkRollHisPeriod(String msg) {
        String formulaOfCell;
        if (this.canEditPeriodNumbers != null && !this.canEditPeriodNumbers.isEmpty() && !this.canEditPeriodNumbers.contains(BgNFSHelper.parseFormulaPara(formulaOfCell = BgNFSHelper.getFormulaOfCell(this._cell))[1])) {
            msg = EASResource.getString((String)this.res, (String)"bgRollHisPeriod");
        }
        return msg;
    }

    public void showPromt(final String msg) {
        final KDLabel barLabel = this._statusBar.getMsgLabel();
        barLabel.setBounds(barLabel.getX(), barLabel.getY(), 700, barLabel.getHeight());
        final Icon icon = EASResource.getIcon((String)"imgState_cue_2");
        final Color bg = new Color(170, 32, 50);
        Color fg = new Color(255, 246, 0);
        barLabel.setForeground(fg);
        if (icon != null) {
            barLabel.setIcon(icon);
        }
        barLabel.setText(msg);
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 10; ++i) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                barLabel.setBackground(bg);
                                barLabel.setIcon(icon);
                                barLabel.setText(msg);
                                barLabel.setOpaque(true);
                                barLabel.repaint();
                            }
                        });
                        Thread.sleep(200L);
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                barLabel.setOpaque(false);
                                barLabel.setIcon(icon);
                                barLabel.setText(msg);
                                barLabel.repaint();
                            }
                        });
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)"showPromt: ", (Throwable)e);
                    }
                }
                barLabel.setIcon(null);
                barLabel.setText(null);
                barLabel.repaint();
            }
        }).start();
    }

    private String checkHeadCell() {
        String msg = null;
        int formType = this._bgFormInfo.getBgTemplate().getFormType().getValue();
        if ((4 == formType || 2 == formType) && this._cell.getUserObject("isHeaderCell") != null) {
            msg = EASResource.getString((String)this.res, (String)"mbgTmplContentPromt");
            return msg;
        }
        return msg;
    }

    private String checkOtherCell() {
        String msg = null;
        int formType = this._bgFormInfo.getBgTemplate().getFormType().getValue();
        if (2 == formType) {
            int colIndex = this._cell.getCol();
            int rowIndex = this._cell.getRow();
            Row row = this._cell.getSheet().getRow(rowIndex, false);
            Column col = this._cell.getSheet().getColumn(colIndex, false);
            if (this._cell.getUserObject("editNote") == null && row.getUserObject("dimensino.member") == null && row.getUserObject("dimension.object") == null || col.getUserObject("dimensino.member") == null && col.getUserObject("dimension.object") == null) {
                msg = EASResource.getString((String)this.res, (String)"mbgOutOfTmplRange");
            }
        }
        return msg;
    }

    private String checkDimensionMemberIsDetailOrNot() {
        String msg = null;
        Map<String, Set<String>> leafMap = this._helper.getLeafMap();
        if (leafMap == null || leafMap.isEmpty()) {
            return msg;
        }
        String formula = BgNFSHelper.getFormulaOfCell(this._cell);
        String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
        String scen = formulaParam[3];
        try {
            BgScenarioInfo bgScenarioInfo = BgScenarioFactory.getRemoteInstance().getBgScenarioInfo("select type where number = '" + scen + "'");
            if (this._bgActualRecordInfo != null) {
                if (bgScenarioInfo.getType().getValue() == 0) {
                    msg = EASResource.getString((String)this.res, (String)"mbgBgScenario");
                    return msg;
                }
            } else if (bgScenarioInfo.getType().getValue() == 1) {
                msg = EASResource.getString((String)this.res, (String)"mbgActuScenario");
                return msg;
            }
        }
        catch (Exception e) {
            logger.error((Object)"BgScenario: ", (Throwable)e);
        }
        if (!StringUtils.isEmpty((String)this._editScenario)) {
            HashSet<String> editScenSet = new HashSet<String>();
            String[] tmpStrs = this._editScenario.split(",");
            if (tmpStrs != null) {
                int in = tmpStrs.length;
                for (int i = 0; i < in; ++i) {
                    editScenSet.add(tmpStrs[i]);
                }
            }
            if (scen == null || !editScenSet.isEmpty() && !editScenSet.contains(scen)) {
                msg = EASResource.getString((String)this.res, (String)"mbgScenario");
                return msg;
            }
        } else if (!this._helper.check(DimensionConstants.DEF_SCENARIO_SRCNUMBER, formulaParam[3])) {
            msg = EASResource.getString((String)this.res, (String)"mbgScenario");
            return msg;
        }
        if (!this._helper.check(DimensionConstants.DEF_CURRENCY_SRCNUMBER, formulaParam[5])) {
            msg = EASResource.getString((String)this.res, (String)"mbgCurrency");
            return msg;
        }
        if (!this._helper.check(DimensionConstants.DEF_ELEMENT_SRCNUMBER, formulaParam[2])) {
            msg = EASResource.getString((String)this.res, (String)"mbgElement");
            return msg;
        }
        msg = this.isDetailItem(formulaParam);
        if (!StringUtils.isEmpty((String)msg)) {
            return msg;
        }
        if (!this._helper.check(DimensionConstants.DEF_PERIOD_SRCNUMBER, formulaParam[1])) {
            msg = EASResource.getString((String)this.res, (String)"mbgPeriod");
            return msg;
        }
        return msg;
    }

    private String checkVersion() {
        ItemFormula itemFormula;
        String version;
        String msg = null;
        int formType = this._bgFormInfo.getBgTemplate().getFormType().getValue();
        if (!(4 != formType && 2 != formType || StringUtils.isEmpty((String)(version = (itemFormula = BgNFSHelper.getItemFormula(this._cell)).getExt("Version"))) || this._bgFormInfo.getBizVersion() == null || version.equals(this._bgFormInfo.getBizVersion().getNumber()))) {
            msg = EASResource.getString((String)this.res, (String)"mbgVersion");
        }
        return msg;
    }

    protected String isDetailItem(String[] formulaParam) {
        String msg = null;
        Map<String, Set<String>> leafMembers = this.queryLeafMembers(formulaParam);
        String[] itemNumbers = formulaParam[0].split(",");
        for (int i = 0; i < itemNumbers.length; ++i) {
            String number;
            String srcNumber;
            if (StringUtils.isEmpty((String)itemNumbers[i]) || this._helper.check(srcNumber = DimensionFormulaHelper.getSrcNumber(itemNumbers[i]), number = DimensionFormulaHelper.getMemberNumber(itemNumbers[i]))) continue;
            try {
                if ("Acc".equals(srcNumber)) {
                    msg = leafMembers.containsKey(srcNumber) && leafMembers.get(srcNumber).contains(number) && this.getOrgInfo() != null ? EASResource.getString((String)this.res, (String)"mbgMemberUnAddbyOrg", (Object[])new String[]{this.getOrgInfo().getName()}) : EASResource.getString((String)this.res, (String)"mbgAccountMember");
                    return msg;
                }
                MbgDimInfo info = MbgDimFactory.getRemoteInstance().getMbgDimInfo("select name where srcNumber = '" + srcNumber + "'");
                msg = leafMembers.containsKey(srcNumber) && leafMembers.get(srcNumber).contains(number) && this.getOrgInfo() != null ? EASResource.getString((String)this.res, (String)"mbgMemberUnAddbyOrg", (Object[])new String[]{this.getOrgInfo().getName()}) : EASResource.getString((String)this.res, (String)"mbgMember", (Object[])new Object[]{info.getName()});
                return msg;
            }
            catch (Exception e) {
                logger.error((Object)"isDetailItem: ", (Throwable)e);
            }
        }
        return msg;
    }

    protected Map<String, Set<String>> queryLeafMembers(String[] formulaParam) {
        Map<String, Set<String>> leafMembers = new HashMap<String, Set<String>>();
        HashMap queryMap = new HashMap();
        String[] itemNumbers = formulaParam[0].split(",");
        for (int i = 0; i < itemNumbers.length; ++i) {
            if (StringUtils.isEmpty((String)itemNumbers[i])) continue;
            String srcNumber = DimensionFormulaHelper.getSrcNumber(itemNumbers[i]);
            String number = DimensionFormulaHelper.getMemberNumber(itemNumbers[i]);
            if (!queryMap.containsKey(srcNumber)) {
                queryMap.put(srcNumber, new HashSet());
            }
            ((Set)queryMap.get(srcNumber)).add(number);
        }
        if (!queryMap.isEmpty() && !StringUtils.isEmpty((String)this._helper.getOrgId())) {
            try {
                leafMembers = DimensionFormulaFacadeFactory.getRemoteInstance().getLeafMember(this._helper.getOrgId(), this._helper.getSchemeHelper().getBgSchemeId(), queryMap);
            }
            catch (EASBizException e) {
                logger.error((Object)"isDetailItem: ", (Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)"isDetailItem: ", (Throwable)e);
            }
        }
        return leafMembers;
    }

    private String checkBgDataState() {
        String msg = null;
        String _tmpStr = BgNFSHelper.getFormulaOfCell(this._cell);
        BgNDataInfo _bgData = this.getDimData(_tmpStr);
        if (_bgData != null) {
            if (this._bgFormInfo.getState().getValue() == 4 || this._bgFormInfo.getState().getValue() == 2) {
                if (5 != _bgData.getState() && 9 != _bgData.getState()) {
                    String name = BgDataStateEnum.getEnum(_bgData.getState()).getAlias();
                    msg = EASResource.getString((String)this.res, (String)"mbgDataState", (Object[])new Object[]{name});
                }
            } else if (this._bgFormInfo.getProcessType().getValue() == 3) {
                String name = this._bgFormInfo.getProcessType().getAlias();
                msg = EASResource.getString((String)this.res, (String)"mbgFormState", (Object[])new Object[]{name});
            } else if (0 != _bgData.getState() && 1 != _bgData.getState()) {
                String name = BgDataStateEnum.getEnum(_bgData.getState()).getAlias();
                msg = EASResource.getString((String)this.res, (String)"mbgDataState", (Object[])new Object[]{name});
            }
        }
        return msg;
    }

    private BgNDataInfo getDimData(String formulaStr) {
        if (formulaStr == null) {
            return null;
        }
        String tmpKey = DimUtils.getDimDataKey(formulaStr, this._bgFormInfo.getBgVersion().getNumber());
        int formType = this._bgFormInfo.getBgTemplate().getFormType().getValue();
        BgNDataInfo bgNDataInfo = null;
        if (4 == formType || 2 == formType) {
            ItemFormula itemFormula = BgNFSHelper.getItemFormula(this._cell);
            String cellOrgId = itemFormula.getExt("ORGUNITID");
            bgNDataInfo = (BgNDataInfo)((Map)this._bgdataMap.get(cellOrgId)).get(tmpKey);
        } else {
            bgNDataInfo = (BgNDataInfo)this._bgdataMap.get(tmpKey);
        }
        return bgNDataInfo;
    }
}

