/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.template;

import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.TableMouseController;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.CellActionAfterListener;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.common.BookContextManager;
import com.kingdee.eas.ma.mbg.client.template.UserCellDisplayProvider;
import com.kingdee.eas.ma.mbg.client.template.ViewListRowColGroupRender;
import com.kingdee.eas.ma.mbg.client.template.ViewListTitleRender;
import com.kingdee.eas.ma.mbg.client.template.ViewListUserCellDisplayProvider;
import com.kingdee.eas.ma.mbg.client.viewListForm.ViewListCombinRender;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgNumberCellDisplayHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.ViewListMeasureCellActionAfterListener;
import com.kingdee.eas.ma.mbg.common.ViewListMemberRender;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.provider.IViewListProvider;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.IViewListCombinRender;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormAdjustProvider;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ViewListBookContextManager
extends BookContextManager {
    protected static final Logger logger = CoreUIObject.getLogger(ViewListBookContextManager.class);
    protected ViewListCombinRender combinRender = null;

    public ViewListBookContextManager(Map uiContext, CoreUI owner) {
        super(uiContext, owner);
    }

    @Override
    public IViewListProvider getProvider() {
        return (IViewListProvider)super.getProvider();
    }

    @Override
    protected IViewListProvider createProviderImpl() {
        return null;
    }

    @Override
    protected void initContext(IUIObject ui) {
        try {
            ui.getUIContentPane().add(this.getPageDimensionPanel(), "Center");
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
    }

    @Override
    protected void checkItemDimeinsionEmpty() {
    }

    public Component getPageDimensionPanel() throws Exception {
        KDPanel kdPanel = this.getMainPanel();
        kdPanel.removeAll();
        SpreadContext sc = this.getSpreadContext();
        int activeSheetIndex = sc.getBook().getActiveSheetIndex();
        kdPanel.add(this.parseViewOrPageBgDimension(activeSheetIndex), (Object)"North");
        kdPanel.add((Component)sc, (Object)"Center");
        kdPanel.revalidate();
        return kdPanel;
    }

    @Override
    protected Component parseViewOrPageBgDimension(int sheetIndex) throws Exception {
        return this.getProvider().getBookParseHelper().parseViewOrPageBgDimension((CoreUIObject)this.getOwnerUI(), true, sheetIndex);
    }

    @Override
    protected void active_Sheet_Changed(BookChangeEvent e) throws Exception {
        super.active_Sheet_Changed(e);
        if ("Sheet_Active".equals(e.getType()) && this.combinRender != null) {
            this.getCombinRender().clearCombinMembers();
            this.getCombinRender().initCombinMembers();
        }
    }

    @Override
    public IReportPropertyAdapter getReportAdapter() {
        return null;
    }

    public void refreshSheet() throws Exception {
    }

    public void reloadBook() throws Exception {
        Book book = this.getSpreadContext().getBook();
        this.getProvider().reloadBook(book);
        this.initContext((IUIObject)this.getOwnerUI());
    }

    @Override
    public UserCellDisplayProvider getCellDisplayProvider() {
        UserCellDisplayProvider userCellDisplayProvider = super.getCellDisplayProvider();
        IObjectValue editValue = this.getProvider().getEditValue();
        if (editValue != null) {
            UserCellDisplayProvider.addRenderProvider(new ViewListTitleRender(this.getProvider().getEditValue().get(this.getProvider().getEditValue().getPKField()).toString()));
        } else {
            UserCellDisplayProvider.addRenderProvider(new ViewListTitleRender(null));
        }
        UserCellDisplayProvider.addRenderProvider(new ViewListRowColGroupRender());
        this.addCombinRender(userCellDisplayProvider);
        ViewListUserCellDisplayProvider proxy = new ViewListUserCellDisplayProvider(userCellDisplayProvider);
        proxy.setDisplayValueProvider(this.getDisplayProvider());
        return proxy;
    }

    private void addCombinRender(UserCellDisplayProvider userCellDisplayProvider) {
        if (this.combinRender == null) {
            this.combinRender = this.createCombinRender();
            userCellDisplayProvider.addNoStaticRenderProvider(this.combinRender);
            this.loadCombinMembers();
        }
    }

    protected ViewListCombinRender createCombinRender() {
        return new ViewListCombinRender(this);
    }

    public void loadCombinMembers() {
    }

    public void removeCombinBoxs() {
        if (this.combinRender != null) {
            this.combinRender.removeAllKdBoxs();
        }
    }

    public ViewListCombinRender getCombinRender() {
        return this.combinRender;
    }

    @Override
    public void initListener() {
        super.initListener();
        this.getSpreadContext().getSpread().setMouseController(3, (IMouseController)new TableMouseController(this.getSpreadContext()){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && e.getButton() == 1) {
                    ViewListMemberRender.cell_mouseClicked((CoreUIObject)ViewListBookContextManager.this.getOwnerUI(), e, ViewListBookContextManager.this.getSpreadContext().getBook().getActiveSheet());
                }
                super.mouseClicked(e);
            }
        });
        if (this.getOwnerUI() instanceof IBgNumberCellDisplayHelper) {
            this.getSpreadContext().getBook().setCellActionAfterListener((CellActionAfterListener)new ViewListMeasureCellActionAfterListener((IBgNumberCellDisplayHelper)this.getOwnerUI()));
        }
    }

    @Override
    protected boolean isCalculatRowCol(Cell cell) {
        if (cell == null || cell.getSheet() == null) {
            return super.isCalculatRowCol(cell);
        }
        boolean isCalculatRowCol = true;
        if (ViewListHelper.getDimension(cell.getSheet().getRow(cell.getRow(), false)) instanceof MbgViewListRowCol || ViewListHelper.getDimension(cell.getSheet().getColumn(cell.getCol(), false)) instanceof MbgViewListRowCol) {
            return false;
        }
        return isCalculatRowCol;
    }

    protected void storeOthers(Book book) {
        for (int s = 0; s < book.getSheetCount(); ++s) {
            this.storeRemovedCombinData(book.getSheet(s));
            this.storeRemovedData(book.getSheet(s), 1);
        }
    }

    private void storeRemovedData(Sheet sheet, int resource) {
        if (!(this.getProvider() instanceof IViewListCombinRender)) {
            return;
        }
        Map<String, List<String>> deletedFormulasMap = this.getFormulasFromSheetUserObject(sheet, resource);
        if (deletedFormulasMap != null && deletedFormulasMap.size() > 0) {
            HashMap hasFormulas = new HashMap();
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    ItemFormula _formula = BgNFSHelper.getItemFormula(cell);
                    if (_formula == null) continue;
                    String version = _formula.getExt("Version");
                    if (this.getProvider().getEditValue() instanceof IDimDataQuery && !((IDimDataQuery)this.getProvider().getEditValue()).getBizVersion().getNumber().equals(version)) continue;
                    String orgId = _formula.getExt("ORGUNITID");
                    if (!hasFormulas.containsKey(orgId)) {
                        hasFormulas.put(orgId, new HashSet());
                    }
                    ((Set)hasFormulas.get(orgId)).add(_formula.getFormula());
                }
            }
            for (String orgid : deletedFormulasMap.keySet()) {
                List<String> versionNums;
                List<String> deletedFormulas = deletedFormulasMap.get(orgid);
                if (hasFormulas.get(orgid) != null) {
                    deletedFormulas.removeAll((Collection)hasFormulas.get(orgid));
                }
                ArrayList<String> extendFormulas = null;
                ArrayList<String> allExtendFormulas = new ArrayList<String>();
                allExtendFormulas.addAll(deletedFormulas);
                List pageDimensions = ((MbgViewListSheetManager)((ViewListProvider)this.getProvider()).getCurMbgSheetManager()).getDimensionManager().getPageDimension();
                if (pageDimensions != null && pageDimensions.size() > 0 && resource == 0) {
                    for (String formula : deletedFormulas) {
                        extendFormulas = new ArrayList<String>();
                        this.extendFormulaByItem(formula, pageDimensions, extendFormulas);
                        this.extendFormulaByPeriod(formula, pageDimensions, extendFormulas);
                        this.extendFormulaByElement(formula, pageDimensions, extendFormulas);
                        this.extendFormulaByScenario(formula, pageDimensions, extendFormulas);
                        this.extendFormulaByCurrency(formula, pageDimensions, extendFormulas);
                        allExtendFormulas.addAll(extendFormulas);
                    }
                }
                if (allExtendFormulas == null || allExtendFormulas.size() <= 0) continue;
                if (this.getProvider() instanceof MBGViewListFormAdjustProvider) {
                    Map subMap = (Map)((MBGViewListFormAdjustProvider)this.getProvider()).getAdjustMap().get(orgid);
                    int size = allExtendFormulas.size();
                    for (int i = 0; i < size; ++i) {
                        if (!subMap.containsKey(allExtendFormulas.get(i))) continue;
                        BgAdjustFormDiversityData data = (BgAdjustFormDiversityData)subMap.get(allExtendFormulas.get(i));
                        data.setNewValue(null);
                    }
                    allExtendFormulas.clear();
                    continue;
                }
                if (!(this.getProvider() instanceof ViewListProvider)) continue;
                List<Object> keys = new ArrayList();
                if (resource == 0) {
                    versionNums = this.getNumbers(pageDimensions, DimensionBaseConstants.DEF_VERSION_NUMBER);
                    keys = this.addVersion(versionNums, deletedFormulas, allExtendFormulas);
                }
                if (resource == 1) {
                    versionNums = new ArrayList<String>();
                    if (this.getProvider().getEditValue() instanceof BgFormInfo) {
                        versionNums.add(((BgFormInfo)this.getProvider().getEditValue()).getBgVersion().getNumber());
                    }
                    keys = this.addVersion(versionNums, deletedFormulas, null);
                }
                if (keys == null || keys.size() <= 0) continue;
                Map<String, BgNViewDataInfo> subMap = ((IViewListCombinRender)((Object)this.getProvider())).getBgDataMap().get(orgid);
                if (subMap == null) {
                    subMap = new HashMap<String, BgNViewDataInfo>();
                    ((IViewListCombinRender)((Object)this.getProvider())).getBgDataMap().put(orgid, subMap);
                }
                int size = keys.size();
                for (int i = 0; i < size; ++i) {
                    String key = (String)keys.get(i);
                    subMap.put(key, null);
                }
                keys.clear();
            }
            deletedFormulasMap.clear();
            if (resource == 0) {
                sheet.removeUserObject("deletedFormulas");
            }
            if (resource == 1) {
                sheet.removeUserObject("deletedFormulasFromAddMember");
            }
        }
    }

    private void storeRemovedCombinData(Sheet sheet) {
        this.storeRemovedData(sheet, 0);
    }

    private Map<String, List<String>> getFormulasFromSheetUserObject(Sheet sheet) {
        return this.getFormulasFromSheetUserObject(sheet, 0);
    }

    private Map<String, List<String>> getFormulasFromSheetUserObject(Sheet sheet, int resource) {
        HashMap deletedFormulasMap = null;
        String keyString = null;
        if (resource == 0) {
            keyString = "deletedFormulas";
        }
        if (resource == 1) {
            keyString = "deletedFormulasFromAddMember";
        }
        if (sheet.getUserObject(keyString) != null) {
            deletedFormulasMap = new HashMap();
            ArrayList<String> formulaLists = new ArrayList<String>();
            String formulasString = (String)sheet.getUserObject(keyString).getValue();
            String[] formulas = formulasString.split("@@");
            for (int i = 0; i < formulas.length; ++i) {
                String orgAFormula = formulas[i];
                String[] orgAFormulas = orgAFormula.split("##");
                if (orgAFormulas.length <= 1) continue;
                String orgid = orgAFormulas[0];
                String formula = orgAFormulas[1];
                if (deletedFormulasMap.containsKey(orgid)) {
                    ((List)deletedFormulasMap.get(orgid)).add(formula);
                    continue;
                }
                formulaLists.add(formula);
                deletedFormulasMap.put(orgid, formulaLists);
            }
        }
        return deletedFormulasMap;
    }

    private List<String> addVersion(List<String> versionNums, List<String> formulas, List<String> extendFormulas) {
        if (versionNums.size() > 0 && formulas.size() > 0) {
            Iterator<String> verIt = versionNums.iterator();
            ArrayList<String> exFormulas = new ArrayList<String>();
            while (verIt.hasNext()) {
                String formula;
                int i;
                String ver = verIt.next();
                if (versionNums.size() > 0 && formulas.size() > 0) {
                    for (i = 0; i < formulas.size(); ++i) {
                        formula = formulas.get(i);
                        formula = formula + "_" + ver;
                        exFormulas.add(formula);
                    }
                }
                if (extendFormulas == null || extendFormulas.size() <= 0) continue;
                for (i = 0; i < extendFormulas.size(); ++i) {
                    formula = extendFormulas.get(i);
                    formula = formula + "_" + ver;
                    exFormulas.add(formula);
                }
            }
            if (extendFormulas != null) {
                extendFormulas.clear();
            }
            return exFormulas;
        }
        return null;
    }

    private void extendFormulaByItem(String formula, List<MbgViewListDimensionInfo> pageDimensions, List<String> extendFormulas) {
        List<String> items = this.getItems(formula, pageDimensions);
        if (items.size() >= 1) {
            String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
            String itemNumber = formulaParam[0];
            String periodNumber = formulaParam[1];
            String elementNumber = formulaParam[2];
            String scenarioNumber = formulaParam[3];
            String currencyNumber = formulaParam[5];
            for (int i = 0; i < items.size(); ++i) {
                extendFormulas.add(BgNFSHelper.getFormulaFromParam(items.get(i), periodNumber, elementNumber, currencyNumber, scenarioNumber));
            }
            items.clear();
        }
    }

    private List<String> getItems(String formula, List<MbgViewListDimensionInfo> pageDimensions) {
        String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
        String[] itemNumbers = formulaParam[0].split(",");
        ArrayList<String> itemParams = new ArrayList<String>();
        int length = itemNumbers.length;
        for (int i = 0; i < length; ++i) {
            String num;
            if (StringUtils.isEmpty((String)itemNumbers[i])) continue;
            ArrayList<String> singleParams = new ArrayList<String>();
            String srcNumber = DimensionFormulaHelper.getSrcNumber(itemNumbers[i]);
            String number = DimensionFormulaHelper.getMemberNumber(itemNumbers[i]);
            int psize = pageDimensions.size();
            for (int j = 0; j < psize; ++j) {
                MbgViewListDimensionInfo info = pageDimensions.get(j);
                List mems = info.getMember();
                int size = mems.size();
                for (int k = 0; k < size; ++k) {
                    String memNum;
                    MbgViewListDimensionMember mem = (MbgViewListDimensionMember)mems.get(k);
                    if (!srcNumber.equals(mem.getSrcNumber()) || number.equals(memNum = mem.getNumber())) continue;
                    singleParams.add(memNum);
                }
            }
            if (singleParams.size() > 0) {
                Iterator spIt = singleParams.iterator();
                ArrayList<String> temp = null;
                while (spIt.hasNext()) {
                    num = (String)spIt.next();
                    num = srcNumber + ":" + num;
                    if (itemParams.size() > 0) {
                        if (temp == null) {
                            temp = new ArrayList<String>();
                        }
                        int size = itemParams.size();
                        for (int l = 0; l < size; ++l) {
                            String item = (String)itemParams.get(l);
                            item = item + "," + num;
                            temp.add(item);
                        }
                        continue;
                    }
                    if (temp == null) {
                        temp = new ArrayList();
                    }
                    temp.add(num);
                }
                if (temp == null || temp.size() <= 0) continue;
                itemParams.clear();
                itemParams.addAll((Collection<String>)temp);
                continue;
            }
            if (itemParams.size() > 0) {
                Iterator it = itemParams.iterator();
                ArrayList<String> temp = new ArrayList<String>();
                num = srcNumber + ":" + number;
                while (it.hasNext()) {
                    String item = (String)it.next();
                    item = item + "," + num;
                    temp.add(item);
                }
                if (temp == null || temp.size() <= 0) continue;
                itemParams.clear();
                itemParams.addAll(temp);
                continue;
            }
            String num2 = srcNumber + ":" + number;
            itemParams.add(num2);
        }
        return itemParams;
    }

    private void extendFormulaByPeriod(String formula, List<MbgViewListDimensionInfo> pageDimensions, List<String> extendFormulas) {
        List<String> periodNums = this.getNumbers(pageDimensions, DimensionBaseConstants.DEF_PERIOD_NUMBER);
        if (periodNums.size() > 1) {
            String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
            String itemNumber = formulaParam[0];
            String periodNumber = formulaParam[1];
            String elementNumber = formulaParam[2];
            String scenarioNumber = formulaParam[3];
            String currencyNumber = formulaParam[5];
            ArrayList<String> temp = new ArrayList<String>();
            for (int i = 0; i < periodNums.size(); ++i) {
                if (periodNumber.equals(periodNums.get(i))) continue;
                if (extendFormulas.size() > 0) {
                    int size = extendFormulas.size();
                    for (int j = 0; j < size; ++j) {
                        String nformula = extendFormulas.get(j);
                        String[] nformulaParam = BgNFSHelper.parseFormulaPara(nformula);
                        String nitemNumber = nformulaParam[0];
                        String nperiodNumber = nformulaParam[1];
                        String nelementNumber = nformulaParam[2];
                        String nscenarioNumber = nformulaParam[3];
                        String ncurrencyNumber = nformulaParam[5];
                        temp.add(BgNFSHelper.getFormulaFromParam(nitemNumber, periodNums.get(i), nelementNumber, ncurrencyNumber, nscenarioNumber));
                    }
                }
                temp.add(BgNFSHelper.getFormulaFromParam(itemNumber, periodNums.get(i), elementNumber, currencyNumber, scenarioNumber));
            }
            extendFormulas.addAll(temp);
            temp.clear();
            periodNums.clear();
        }
    }

    private void extendFormulaByScenario(String formula, List<MbgViewListDimensionInfo> pageDimensions, List<String> extendFormulas) {
        List<String> scenarioNums = this.getNumbers(pageDimensions, DimensionBaseConstants.DEF_SCENARIO_NUMBER);
        if (scenarioNums.size() > 1) {
            String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
            String itemNumber = formulaParam[0];
            String periodNumber = formulaParam[1];
            String elementNumber = formulaParam[2];
            String scenarioNumber = formulaParam[3];
            String currencyNumber = formulaParam[5];
            ArrayList<String> temp = new ArrayList<String>();
            for (int i = 0; i < scenarioNums.size(); ++i) {
                if (scenarioNumber.equals(scenarioNums.get(i))) continue;
                if (extendFormulas.size() > 0) {
                    int size = extendFormulas.size();
                    for (int j = 0; j < size; ++j) {
                        String nformula = extendFormulas.get(j);
                        String[] nformulaParam = BgNFSHelper.parseFormulaPara(nformula);
                        String nitemNumber = nformulaParam[0];
                        String nperiodNumber = nformulaParam[1];
                        String nelementNumber = nformulaParam[2];
                        String nscenarioNumber = nformulaParam[3];
                        String ncurrencyNumber = nformulaParam[5];
                        temp.add(BgNFSHelper.getFormulaFromParam(nitemNumber, nperiodNumber, nelementNumber, ncurrencyNumber, scenarioNums.get(i)));
                    }
                }
                temp.add(BgNFSHelper.getFormulaFromParam(itemNumber, periodNumber, elementNumber, currencyNumber, scenarioNums.get(i)));
            }
            extendFormulas.addAll(temp);
            temp.clear();
            scenarioNums.clear();
        }
    }

    private void extendFormulaByElement(String formula, List<MbgViewListDimensionInfo> pageDimensions, List<String> extendFormulas) {
        List<String> elementNums = this.getNumbers(pageDimensions, DimensionBaseConstants.DEF_ELEMENT_NUMBER);
        if (elementNums.size() > 1) {
            String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
            String itemNumber = formulaParam[0];
            String periodNumber = formulaParam[1];
            String elementNumber = formulaParam[2];
            String scenarioNumber = formulaParam[3];
            String currencyNumber = formulaParam[5];
            ArrayList<String> temp = new ArrayList<String>();
            for (int i = 0; i < elementNums.size(); ++i) {
                if (elementNumber.equals(elementNums.get(i))) continue;
                if (extendFormulas.size() > 0) {
                    int size = extendFormulas.size();
                    for (int j = 0; j < size; ++j) {
                        String nformula = extendFormulas.get(j);
                        String[] nformulaParam = BgNFSHelper.parseFormulaPara(nformula);
                        String nitemNumber = nformulaParam[0];
                        String nperiodNumber = nformulaParam[1];
                        String nelementNumber = nformulaParam[2];
                        String nscenarioNumber = nformulaParam[3];
                        String ncurrencyNumber = nformulaParam[5];
                        temp.add(BgNFSHelper.getFormulaFromParam(nitemNumber, nperiodNumber, elementNums.get(i), ncurrencyNumber, nscenarioNumber));
                    }
                }
                temp.add(BgNFSHelper.getFormulaFromParam(itemNumber, periodNumber, elementNums.get(i), currencyNumber, scenarioNumber));
            }
            extendFormulas.addAll(temp);
            temp.clear();
            elementNums.clear();
        }
    }

    private void extendFormulaByCurrency(String formula, List<MbgViewListDimensionInfo> pageDimensions, List<String> extendFormulas) {
        List<String> currencyNums = this.getNumbers(pageDimensions, DimensionBaseConstants.DEF_CURRENCY_NUMBER);
        if (currencyNums.size() > 1) {
            String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
            String itemNumber = formulaParam[0];
            String periodNumber = formulaParam[1];
            String elementNumber = formulaParam[2];
            String scenarioNumber = formulaParam[3];
            String currencyNumber = formulaParam[5];
            ArrayList<String> temp = new ArrayList<String>();
            for (int i = 0; i < currencyNums.size(); ++i) {
                if (currencyNumber.equals(currencyNums.get(i))) continue;
                if (extendFormulas.size() > 0) {
                    int size = extendFormulas.size();
                    for (int j = 0; j < size; ++j) {
                        String nformula = extendFormulas.get(j);
                        String[] nformulaParam = BgNFSHelper.parseFormulaPara(nformula);
                        String nitemNumber = nformulaParam[0];
                        String nperiodNumber = nformulaParam[1];
                        String nelementNumber = nformulaParam[2];
                        String nscenarioNumber = nformulaParam[3];
                        String ncurrencyNumber = nformulaParam[5];
                        temp.add(BgNFSHelper.getFormulaFromParam(nitemNumber, nperiodNumber, nelementNumber, currencyNums.get(i), nscenarioNumber));
                    }
                }
                temp.add(BgNFSHelper.getFormulaFromParam(itemNumber, periodNumber, elementNumber, currencyNums.get(i), scenarioNumber));
            }
            extendFormulas.addAll(temp);
            temp.clear();
            currencyNums.clear();
        }
    }

    private List<String> getNumbers(List<MbgViewListDimensionInfo> pageDimensions, String dimemesionNumber) {
        ArrayList<String> numbers = new ArrayList<String>();
        for (MbgViewListDimensionInfo info : pageDimensions) {
            if (!info.getNumber().equals(dimemesionNumber)) continue;
            List members = info.getMember();
            for (int i = 0; i < members.size(); ++i) {
                MbgViewListDimensionMember member = (MbgViewListDimensionMember)members.get(i);
                numbers.add(member.getNumber());
            }
        }
        return numbers;
    }
}

