/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.client.BgAdjustFormProcessUI;
import com.kingdee.eas.ma.mbg.client.BgAdjustViewFormProcessUI;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgAdjustProcessHelper {
    private String resource = null;
    private Map uiContext = null;
    private Component ui = null;

    private Map getUIContext() {
        return this.uiContext;
    }

    public BgAdjustProcessHelper(Map uiContext, String resource, Component ui) {
        this.uiContext = uiContext;
        this.resource = resource;
        this.ui = ui;
    }

    public boolean checkIsSameDim(List<ItemFormula> list) {
        String periodNumber = null;
        HashSet<String> periodNumberSet = new HashSet<String>();
        HashSet<String> versionNumberSet = new HashSet<String>();
        HashSet<String> eleNumberSet = new HashSet<String>();
        HashSet<String> scenNumberSet = new HashSet<String>();
        HashSet<String> currencyNumberSet = new HashSet<String>();
        String elementNumber = null;
        String scenNumber = null;
        String currencyNumber = null;
        String versionNum = null;
        for (ItemFormula formula : list) {
            String[] params = BgNFSHelper.parseFormulaPara(formula.getFormula());
            if (params == null || params.length == 0) {
                return true;
            }
            versionNum = formula.getExt("Version");
            if (!versionNumberSet.contains(versionNum)) {
                versionNumberSet.add(versionNum);
            }
            if (!periodNumberSet.contains(periodNumber = params[1])) {
                periodNumberSet.add(periodNumber);
            }
            if (!eleNumberSet.contains(elementNumber = params[2])) {
                eleNumberSet.add(elementNumber);
            }
            if (!scenNumberSet.contains(scenNumber = params[3])) {
                scenNumberSet.add(scenNumber);
            }
            if (currencyNumberSet.contains(currencyNumber = params[5])) continue;
            currencyNumberSet.add(currencyNumber);
        }
        return this.checkSetAndShowInfo(versionNumberSet, eleNumberSet, scenNumberSet, currencyNumberSet);
    }

    private boolean checkSetAndShowInfo(Set<String> versionNumberSet, Set<String> eleNumberSet, Set<String> scenNumberSet, Set<String> currencyNumberSet) {
        boolean isSame = true;
        boolean isAdjustEntryScenAndEle = false;
        if (this.getUIContext().get("isAdjustEntryScenAndEle") != null) {
            isAdjustEntryScenAndEle = (Boolean)this.getUIContext().get("isAdjustEntryScenAndEle");
        }
        if (currencyNumberSet.size() != 1 || versionNumberSet.size() != 1) {
            if (isAdjustEntryScenAndEle) {
                MsgBox.showInfo((Component)this.ui, (String)EASResource.getString((String)this.resource, (String)"notSameScenAndEle"));
            } else {
                MsgBox.showInfo((Component)this.ui, (String)EASResource.getString((String)this.resource, (String)"notSame"));
            }
            return !isSame;
        }
        String number = null;
        if (this.getUIContext().get(BgBaseConstants.BGVERSION_INFO) != null && this.getUIContext().get(BgBaseConstants.BGVERSION_INFO) instanceof BgVersionInfo) {
            number = ((BgVersionInfo)this.getUIContext().get(BgBaseConstants.BGVERSION_INFO)).getNumber();
            isSame = this.isSameFormAdjustBill(versionNumberSet, number);
        }
        if (!isAdjustEntryScenAndEle) {
            if (scenNumberSet.size() != 1 || eleNumberSet.size() != 1) {
                MsgBox.showInfo((Component)this.ui, (String)EASResource.getString((String)this.resource, (String)"notSame"));
                return !isSame;
            }
            if (this.getUIContext().get(BgBaseConstants.BGSCENARIO_INFO) != null && this.getUIContext().get(BgBaseConstants.BGSCENARIO_INFO) instanceof BgElementInfo && isSame) {
                number = ((BgElementInfo)this.getUIContext().get(BgBaseConstants.BGSCENARIO_INFO)).getNumber();
                isSame = this.isSameFormAdjustBill(scenNumberSet, number);
            }
            if (this.getUIContext().get(BgBaseConstants.BGELEMENT_INFO) != null && this.getUIContext().get(BgBaseConstants.BGELEMENT_INFO) instanceof BgElementInfo && isSame) {
                number = ((BgElementInfo)this.getUIContext().get(BgBaseConstants.BGELEMENT_INFO)).getNumber();
                isSame = this.isSameFormAdjustBill(eleNumberSet, number);
            }
        }
        if (this.getUIContext().get(BgBaseConstants.CURRENCY_INFO) != null && this.getUIContext().get(BgBaseConstants.CURRENCY_INFO) instanceof CurrencyInfo && isSame) {
            number = ((CurrencyInfo)this.getUIContext().get(BgBaseConstants.CURRENCY_INFO)).getNumber();
            isSame = this.isSameFormAdjustBill(currencyNumberSet, number);
        }
        if (this.getUIContext().get(BgBaseConstants.BGELEMENT_INFO) == null && this.getUIContext().get(BgBaseConstants.BGSCENARIO_INFO) == null && this.getUIContext().get(BgBaseConstants.BGVERSION_INFO) == null && this.getUIContext().get(BgBaseConstants.CURRENCY_INFO) == null) {
            this.setClearEntry();
            isSame = true;
        }
        if (!isSame) {
            int res = MsgBox.showConfirm2New((Component)this.ui, (String)EASResource.getString((String)this.resource, (String)"notSameIsContinue"));
            if (res == 0) {
                this.setClearEntry();
                return true;
            }
            return false;
        }
        return isSame;
    }

    private void setClearEntry() {
        if (this.ui instanceof BgAdjustViewFormProcessUI) {
            ((BgAdjustViewFormProcessUI)((Object)this.ui)).setClearEntry(true);
        }
        if (this.ui instanceof BgAdjustFormProcessUI) {
            ((BgAdjustFormProcessUI)((Object)this.ui)).setClearEntry(true);
        }
    }

    private boolean isSameFormAdjustBill(Set<String> versionNumberSet, String number) {
        return StringUtils.isEmpty((String)number) || versionNumberSet.contains(number);
    }
}

