/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.framework.client.popup.MenuSection;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgDimensionExtFacadeFactory;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.IBgDimensionFacade;
import com.kingdee.eas.ma.mbg.IMBGViewListFormFacade;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.MbgDataAnalyseNumberExpendRender;
import com.kingdee.eas.ma.mbg.client.utils.NumberExpandExtInfo;
import com.kingdee.eas.ma.mbg.common.BgAnalyseObjConstants;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDrillParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDrillResult;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.impl.DimDrillParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.dimension.vo.DimensionObject;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgAnalyseDrillTableHelper {
    private static final String RES_PATH = "com.kingdee.eas.ma.mbg.BudgetResource";
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseDrillTableHelper.class);
    private static final long serialVersionUID = 479833658155427210L;
    private KDTable tblMain = null;
    private MbgViewListManager view = null;
    private Map<String, Map<String, Map<String, BgNViewDataInfo>>> dataMap = null;
    private List<String> analyseObjTexts = null;
    private boolean isFirst = false;
    private MenuSection menuSectionAllExp = new MenuSection("allExpAction");
    KDMenuItem menuItemAllExp = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"allExpAction"));
    private MenuSection menuSectionNotAllExp = new MenuSection("notAllExpAction");
    KDMenuItem menuItemNotAllExp = new KDMenuItem(EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"notAllExpAction"));
    private boolean onlyBgDataType = false;
    private MbgViewListDimensionInfo removeScenDim = null;
    public static final String DIM = "dimension";
    public static final String MEM = "member";
    public static final String FORMULA = "formula";
    public static final String VERSION = "version";
    public static final String CURRENCY = "currency";
    public static final String ELEMENT = "element";
    public static final String ANALYSE_OBJ = "ANALYSE";
    private static final String ANALYSE_NAME = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BudgetResource", (String)"analyseObj");
    private static final Object MbgViewListDimensionInfo = null;
    private boolean isLoadTransitBudget;
    private Map<String, Integer> scenMap = null;
    private String bgschemeId = null;
    private String orgViewId;
    List<BgOrgUnitInfo> bgOrgs = null;
    protected MbgDataAnalyseNumberExpendRender render = null;
    private boolean isAduit = false;
    Component com = null;
    private BgProcessEnum processType = null;
    private Map<String, BgScenarioInfo> scenarioMap = new HashMap<String, BgScenarioInfo>();
    private Map<String, BgOrgUnitInfo> orgUnitMap = new HashMap<String, BgOrgUnitInfo>();
    private Map<String, String> vesionIdMap = new HashMap<String, String>();
    private Map<String, BgOrgUnitInfo> virtualOrgMap = new HashMap<String, BgOrgUnitInfo>();
    private Map<String, String> lastYearPeriodMap = new HashMap<String, String>();
    Map<String, Boolean> leafDataMap = null;
    private Map<String, String> mdxNumMap = null;
    Map<String, NumberExpandExtInfo> dimLongNumberMap = new HashMap<String, NumberExpandExtInfo>();
    private IDimDrillResult result = null;
    private Map<KDTCell, String> dataStatusMap = new HashMap<KDTCell, String>();
    private static final String ALL_EXPANDED = "all_expanded";
    private static final String SUB_EXPANDED = "sub_expanded";
    public static final String IS_HIDE_ROW = "IS_HIDE_ROW";
    public static final String IS_FIRST_ROW = "IS_FIRST_ROW";
    Map<String, NumberExpandExtInfo> orgLongNumberMap = new HashMap<String, NumberExpandExtInfo>();
    private BgSchemeDimensionHelper schemeDimensionHelper = null;
    private boolean isExpand = false;
    private Set<String> orgIds = null;
    private boolean hideMbgDim = false;
    private Set<BgOrgUnitInfo> bgOrgInfos = null;
    private List<BgPeriodInfo> periods = null;

    private List<String> analyseObjTexts() {
        return this.analyseObjTexts;
    }

    public void setFirst(boolean isFirst) {
        this.isFirst = isFirst;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    private String getBgschemeId() {
        return this.bgschemeId;
    }

    private String getOrgViewId() {
        return this.orgViewId;
    }

    private Map<String, Integer> getScenMap() {
        return this.scenMap;
    }

    public void setScenMap(Map<String, Integer> scenMap) {
        this.scenMap = scenMap;
    }

    private MbgViewListDimensionInfo getRemoveScenDim() {
        return this.removeScenDim;
    }

    private void setRemoveScenDim(MbgViewListDimensionInfo removeScenDim) {
        this.removeScenDim = removeScenDim;
    }

    private boolean isOnlyBgDataType() {
        return this.onlyBgDataType;
    }

    private List<BgOrgUnitInfo> getOrgUnits() {
        return this.bgOrgs;
    }

    public void setBgOrgUnits(List<BgOrgUnitInfo> bgOrgUnits) {
        this.bgOrgs = bgOrgUnits;
    }

    private Set<String> getFormulas() throws EASBizException, BOSException {
        Set formulas = MBGViewListFormFacadeFactory.getRemoteInstance().getFormulas(this.view, this.getBgschemeId());
        return formulas;
    }

    private Set<Integer> getViewStates() {
        HashSet<Integer> set = null;
        if (this.isAduit()) {
            set = new HashSet<Integer>();
            set.add(9);
            set.add(11);
            set.add(13);
        }
        return set;
    }

    public void setRender(MbgDataAnalyseNumberExpendRender render) {
        this.render = render;
    }

    public MbgDataAnalyseNumberExpendRender getRender() {
        return this.render;
    }

    private boolean isAduit() {
        return this.isAduit;
    }

    public void setShowAduitData(boolean onlyShowAuditBudgetData) {
        this.isAduit = onlyShowAuditBudgetData;
    }

    private Component getOwner() {
        return this.com;
    }

    public void setOwner(Component com) {
        this.com = com;
    }

    private BgProcessEnum getProcessType() {
        return this.processType;
    }

    public void setProcessType(BgProcessEnum processType) {
        this.processType = processType;
    }

    public int getValueType() {
        return DimensionCommonHelper.getDataType(this.getProcessType());
    }

    private Map<String, BgScenarioInfo> getScenarioMap() throws BOSException {
        this.scenarioMap = BgScenarioHelper.getScenariooObjMap();
        return this.scenarioMap;
    }

    private Map<String, BgOrgUnitInfo> getOrgUnitMap() throws EASBizException, Exception {
        Set<BgOrgUnitInfo> bgOrgInfos = this.getBgOrgUnits();
        for (BgOrgUnitInfo orgInfo : bgOrgInfos) {
            this.orgUnitMap.put(orgInfo.getOrgUnitID(), orgInfo);
        }
        return this.orgUnitMap;
    }

    private Map<String, String> getVersionIdMap() throws BOSException {
        MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)this.view.getSheetManagers().get(0)).getDimensionManager();
        List<IMbgViewListObject> rowCols = dimensionManager.getRowCols();
        HashSet<String> versionNumbers = new HashSet<String>();
        for (IMbgViewListObject item : rowCols) {
            MbgViewListRowCol rowCol = (MbgViewListRowCol)item;
            BgDimensionBaseInfo versionDimension = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_VERSION_NUMBER, rowCol.getDimensions());
            if (versionDimension == null) continue;
            List selectMembers = versionDimension.getSelectMembers();
            for (int i = 0; i < selectMembers.size(); ++i) {
                versionNumbers.add(((BgDimensionMember)selectMembers.get(i)).getNumber());
            }
        }
        if (!versionNumbers.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", versionNumbers, CompareType.INCLUDE));
            BgVersionCollection bgVersionCollection = BgVersionFactory.getRemoteInstance().getBgVersionCollection(evi);
            if (bgVersionCollection == null || bgVersionCollection.isEmpty()) {
                return this.vesionIdMap;
            }
            for (int i = 0; i < bgVersionCollection.size(); ++i) {
                BgVersionInfo bgVersionInfo = bgVersionCollection.get(i);
                this.vesionIdMap.put(bgVersionInfo.getNumber(), String.valueOf(bgVersionInfo.getVersionId()));
            }
        }
        return this.vesionIdMap;
    }

    private BgOrgUnitCollection getOrgColls(Set<String> ids) throws Exception, EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("orgUnitId");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("displayName");
        evi.getSelector().add("longNumber");
        evi.getSelector().add("level");
        evi.getSelector().add("isLeaf");
        evi.getSelector().add("polAlgorithm");
        evi.getSelector().add("isOUSealUp");
        evi.getSelector().add("isVirtual");
        evi.getSelector().add("parent");
        evi.getSelector().add("parent.longNumber");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)this.getOrgViewId()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", ids, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isOUSealUp", (Object)0));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0));
        BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(evi);
        return bgOrgUnitCollection;
    }

    public void setTblMain(KDTable tblMain) {
        this.tblMain = tblMain;
    }

    public void setView(MbgViewListManager view) {
        this.view = view;
    }

    public void setDataMap(Map<String, Map<String, Map<String, BgNViewDataInfo>>> dataMap) {
        this.dataMap = dataMap;
    }

    public void setAnalyseObjTexts(List<String> analyseObjTexts) {
        this.analyseObjTexts = analyseObjTexts;
    }

    public void setOnlyBgDataType(boolean onlyBgDataType) {
        this.onlyBgDataType = onlyBgDataType;
    }

    public void setBgschemeId(String bgschemeId) {
        this.bgschemeId = bgschemeId;
    }

    public void setOrgViewId(String orgViewId) {
        this.orgViewId = orgViewId;
    }

    private MbgViewListManager clone(MbgViewListManager view2) {
        MbgViewListManager _view = view2.clone();
        MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)_view.getSheetManagers().get(0)).getDimensionManager();
        dimensionManager.clone();
        List<IMbgViewListObject> rowCols = dimensionManager.getRowCols();
        for (int i = 0; i < rowCols.size(); ++i) {
            MbgViewListRowCol rowCol = (MbgViewListRowCol)rowCols.get(i);
            List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
            rowCol.setDimensions((List)((ArrayList)dimensions).clone());
        }
        return _view;
    }

    private void dealDims(int scenInColIndex, List<MbgViewListDimensionInfo> rowColDimensions) {
        rowColDimensions.add(scenInColIndex + 1, this.getAnalyseDim(rowColDimensions.get(scenInColIndex)));
        if (this.isOnlyBgDataType()) {
            this.setRemoveScenDim(rowColDimensions.remove(scenInColIndex));
        }
    }

    private MbgViewListSheetManager getSheet() {
        return (MbgViewListSheetManager)this.view.getSheetManagers().get(0);
    }

    private int getHeadRows() {
        return this.getColDimensions().size();
    }

    public int getHeadCols() {
        return this.getRowDimensions().size();
    }

    private boolean isOnRow(List<IMbgViewListObject> rowCols, String dimNumber) {
        BgDimensionBaseInfo dimension = this.getDimension(rowCols, dimNumber);
        return dimension != null;
    }

    private BgDimensionBaseInfo getDimension(List<IMbgViewListObject> rowCols, String dimNumber) {
        for (IMbgViewListObject item : rowCols) {
            MbgViewListRowCol rowCol = (MbgViewListRowCol)item;
            BgDimensionBaseInfo dim = DimensionCommonHelper.searchDimension(dimNumber, rowCol.getDimensions());
            if (dim == null) continue;
            return dim;
        }
        return null;
    }

    private List<IMbgViewListObject> getRows() {
        return this.getSheet().getDimensionManager().getRows();
    }

    private List<IMbgViewListObject> getCols() {
        return this.getSheet().getDimensionManager().getColumns();
    }

    private List<MbgViewListDimensionInfo> getRowDimensions() {
        return this.getSheet().getDimensionManager().getRowDimension();
    }

    private List<MbgViewListDimensionInfo> getColDimensions() {
        return this.getSheet().getDimensionManager().getColDimension();
    }

    private int getScenInRowColIndex(List rowColDimension) {
        for (int i = 0; i < rowColDimension.size(); ++i) {
            MbgViewListDimensionInfo dim = (MbgViewListDimensionInfo)rowColDimension.get(i);
            if (!DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dim.getNumber())) continue;
            return i;
        }
        return -1;
    }

    private int getAnalyseInRowColIndex(List rowColDimension) {
        for (int i = 0; i < rowColDimension.size(); ++i) {
            MbgViewListDimensionInfo dim = (MbgViewListDimensionInfo)rowColDimension.get(i);
            if (!ANALYSE_OBJ.equals(dim.getNumber())) continue;
            return i;
        }
        return -1;
    }

    private boolean isOrgOnCol() {
        List<MbgViewListDimensionInfo> colDimension = this.getColDimensions();
        for (int i = 0; i < colDimension.size(); ++i) {
            MbgViewListDimensionInfo dim = colDimension.get(i);
            if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
            return true;
        }
        return false;
    }

    private boolean isContainsScen(List<MbgViewListDimensionInfo> dims) {
        for (int i = 0; i < dims.size(); ++i) {
            MbgViewListDimensionInfo mbgViewListDimensionInfo = dims.get(i);
            if (!DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(mbgViewListDimensionInfo.getNumber())) continue;
            return true;
        }
        return false;
    }

    private MbgViewListDimensionInfo getAnalyseDim(MbgViewListDimensionInfo scentDimensionInfo) {
        BgDimensionMember member;
        MbgViewListDimensionInfo analyseDim = this.createAnalyseDimension(ANALYSE_NAME, ANALYSE_OBJ);
        for (int i = 0; i < this.analyseObjTexts.size(); ++i) {
            String analyseName = this.analyseObjTexts.get(i);
            String analyseScenNumber = null;
            if (this.isOnlyBgDataType()) {
                List selectMembers = scentDimensionInfo.getSelectMembers();
                for (int j = 0; j < selectMembers.size(); ++j) {
                    BgDimensionMember bgDimensionMember = (BgDimensionMember)selectMembers.get(j);
                    Integer scenType = this.getScenMap().get(bgDimensionMember.getNumber());
                    if (BgAnalyseObjConstants.r15.equals(analyseName)) {
                        analyseScenNumber = scenType == 0 ? BgAnalyseObjConstants.BA01 : BgAnalyseObjConstants.BA02;
                        member = new BgDimensionMember(ANALYSE_OBJ, ANALYSE_OBJ, bgDimensionMember.getName(), analyseScenNumber);
                    } else if (BgAnalyseObjConstants.r16.equals(analyseName)) {
                        analyseScenNumber = scenType == 0 ? BgAnalyseObjConstants.BPY : BgAnalyseObjConstants.APY;
                        member = new BgDimensionMember(ANALYSE_OBJ, ANALYSE_OBJ, bgDimensionMember.getName() + analyseName, analyseScenNumber);
                    } else if (BgAnalyseObjConstants.r17.equals(analyseName)) {
                        analyseScenNumber = scenType == 0 ? BgAnalyseObjConstants.BCYT : BgAnalyseObjConstants.ACYT;
                        member = new BgDimensionMember(ANALYSE_OBJ, ANALYSE_OBJ, bgDimensionMember.getName() + analyseName, analyseScenNumber);
                    } else {
                        if (!BgAnalyseObjConstants.r18.equals(analyseName)) continue;
                        analyseScenNumber = scenType == 0 ? BgAnalyseObjConstants.BPYGR : BgAnalyseObjConstants.APYGR;
                        member = new BgDimensionMember(ANALYSE_OBJ, ANALYSE_OBJ, bgDimensionMember.getName() + analyseName, analyseScenNumber);
                    }
                    analyseDim.getSelectMembers().add(member);
                }
                if (!BgAnalyseObjConstants.isSelectedExe(analyseName) && !BgAnalyseObjConstants.r2.equals(analyseName) && !BgAnalyseObjConstants.r3.equals(analyseName)) continue;
                analyseScenNumber = BgAnalyseObjConstants.getAnalyseScen(analyseName);
                member = new BgDimensionMember(ANALYSE_OBJ, ANALYSE_OBJ, analyseName, analyseScenNumber);
                analyseDim.getSelectMembers().add(member);
                continue;
            }
            analyseScenNumber = BgAnalyseObjConstants.getAnalyseScen(analyseName);
            member = new BgDimensionMember(ANALYSE_OBJ, ANALYSE_OBJ, analyseName, analyseScenNumber);
            analyseDim.getSelectMembers().add(member);
        }
        ArrayList<String> tmpAnalyses = new ArrayList<String>(this.analyseObjTexts);
        tmpAnalyses.retainAll(BgAnalyseObjConstants.transitBudgetList);
        if (!tmpAnalyses.isEmpty() && this.isLoadTransitBudget) {
            member = new BgDimensionMember(ANALYSE_OBJ, ANALYSE_OBJ, EASResource.getString((String)RES_PATH, (String)"transitBudget"), BgAnalyseObjConstants.BA03);
            List selectMembers = analyseDim.getSelectMembers();
            int index = 0;
            int in = selectMembers.size();
            for (int i = 0; i < in; ++i) {
                if (!BgAnalyseObjConstants.BA01.equals(((BgDimensionMember)selectMembers.get(i)).getNumber())) continue;
                index = ++i;
            }
            analyseDim.getSelectMembers().add(index, member);
        }
        return analyseDim;
    }

    private MbgViewListDimensionInfo createAnalyseDimension(String name, String number) {
        MbgViewListDimensionInfo dim = new MbgViewListDimensionInfo(null);
        dim.setName(name);
        dim.setNumber(number);
        return dim;
    }

    private String getRealNumber4Org(String virLongNumber) {
        if (this.virtualOrgMap.isEmpty()) {
            return null;
        }
        HashSet<String> orgIdSet = new HashSet<String>(this.virtualOrgMap.keySet());
        HashMap<String, String> map = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", orgIdSet, CompareType.INCLUDE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)this.getOrgViewId(), CompareType.EQUALS));
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("longNumber");
        view.getSelector().add("id");
        view.getSelector().add("orgUnitID");
        BgOrgUnitCollection bgOrgUnitCollection = null;
        try {
            bgOrgUnitCollection = BgOrgUnitFactory.getRemoteInstance().getBgOrgUnitCollection(view);
        }
        catch (BOSException e) {
            MsgBox.showError((String)e.getMessage());
            SysUtil.abort();
        }
        for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
            BgOrgUnitInfo bgOrgUnitInfo = bgOrgUnitCollection.get(i);
            map.put(bgOrgUnitInfo.getOrgUnitID(), bgOrgUnitInfo.getLongNumber());
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (String orgId : this.virtualOrgMap.keySet()) {
            BgOrgUnitInfo bgOrgUnitInfo = this.virtualOrgMap.get(orgId);
            String vLongNumber = bgOrgUnitInfo.getLongNumber();
            String rLongNumber = (String)map.get(orgId);
            returnMap.put(vLongNumber, rLongNumber);
        }
        if (returnMap.containsKey(virLongNumber)) {
            return (String)returnMap.get(virLongNumber);
        }
        return null;
    }

    private Map<String, String> getLastYearPeriodMap() {
        return this.lastYearPeriodMap;
    }

    public void buildTable() throws Exception {
        if (this.tblMain == null || this.view == null || this.dataMap == null || this.dataMap.isEmpty() || this.analyseObjTexts == null || this.analyseObjTexts == null) {
            return;
        }
        this.isLoadTransitBudget = BgParamCHelper.isLoadTransitBudget();
        this.clearTable();
        this.initMdxNumMap();
        this.getScenarioMap();
        this.getOrgUnitMap();
        this.getVersionIdMap();
        this.dealLastYear();
        this.getLeafMap();
        long start = System.currentTimeMillis();
        this.dealViewManager();
        long start1 = System.currentTimeMillis();
        this.dealRows();
        this.dealCols();
        logger.info((Object)("dealRowCols() cost time:" + (System.currentTimeMillis() - start1)));
        if (!this.isOnlyBgDataType()) {
            this.deleteRowsAndCols();
        }
        this.fillFormulas();
        this.fillData();
        for (int i = 0; i < this.getHeadCols(); ++i) {
            ICell cell = this.tblMain.getHeadRow(0).getCell(i);
            Object userObject = cell.getUserObject();
            MbgViewListDimensionInfo dim = (MbgViewListDimensionInfo)userObject;
            if (!DimensionConstants.DEF_CURRENCY_NUMBER.equals(dim.getNumber())) continue;
            this.tblMain.getColumn(i).getStyleAttributes().setHided(true);
            break;
        }
        this.removeEmptyRow();
        if (this.isHideMbgDim()) {
            this.hideColOfOnlyOneMem();
        }
        this.mergeCell1();
        this.tblMain.getViewManager().setFreezeView(0, this.getHeadCols());
        this.tblMain.repaint();
        logger.info((Object)("buildTable() cost time:" + (System.currentTimeMillis() - start)));
    }

    private void dealLastYear() {
        this.getLastYearPeriodMap().clear();
        List<BgPeriodInfo> periods = this.getPeriods();
        for (int i = 0; i < periods.size(); ++i) {
            BgPeriodInfo bgPeriodInfo = periods.get(i);
            String number = bgPeriodInfo.getNumber();
            String[] split = number.split("\\.");
            String year = split[1];
            String yearNumberString = year.substring(0, year.indexOf("Y"));
            Integer yearNumber = new Integer(yearNumberString);
            Integer lastYear = yearNumber - 1;
            split[1] = lastYear + "Y";
            StringBuilder perNumber = new StringBuilder();
            for (int j = 0; j < split.length; ++j) {
                if (j == split.length - 1) {
                    perNumber.append(split[j]);
                    continue;
                }
                perNumber.append(split[j]);
                perNumber.append(".");
            }
            this.getLastYearPeriodMap().put(number, perNumber.toString());
        }
    }

    private void initVirtualOrgMap() {
        this.virtualOrgMap.clear();
        Set<BgOrgUnitInfo> bgOrgInfos = this.getBgOrgUnits();
        for (BgOrgUnitInfo bgOrgInfo : bgOrgInfos) {
            if (bgOrgInfo == null || !bgOrgInfo.isIsVirtual()) continue;
            this.virtualOrgMap.put(bgOrgInfo.getOrgUnitID(), bgOrgInfo);
        }
    }

    private void hideColOfOnlyOneMem() {
        Set<String> dimNumberOfOnlyOneMem = this.getDimNumberOfOnlyOneMem();
        if (dimNumberOfOnlyOneMem != null && !dimNumberOfOnlyOneMem.isEmpty()) {
            for (int i = 0; i < this.getHeadCols(); ++i) {
                MbgViewListDimensionInfo dim;
                Object userObject = this.tblMain.getHeadRow(0).getCell(i).getUserObject();
                if (!(userObject instanceof MbgViewListDimensionInfo) || !dimNumberOfOnlyOneMem.contains((dim = (MbgViewListDimensionInfo)userObject).getNumber())) continue;
                this.tblMain.getColumn(i).getStyleAttributes().setHided(true);
            }
        }
    }

    private Set<String> getDimNumberOfOnlyOneMem() {
        HashSet<String> onlyOneExtDim = new HashSet<String>();
        List<IMbgViewListObject> rows = this.getRows();
        for (int i = 0; i < rows.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)rows.get(i);
            List<MbgViewListDimensionInfo> dimensions = rowColObj.getDimensions();
            for (int j = 0; j < dimensions.size(); ++j) {
                MbgViewListDimensionInfo mbgViewListDimensionInfo = dimensions.get(j);
                if (DimensionConstants.necessary.contains(mbgViewListDimensionInfo.getNumber()) || !this.isOnlyOneMember(mbgViewListDimensionInfo)) continue;
                onlyOneExtDim.add(mbgViewListDimensionInfo.getNumber());
            }
        }
        return onlyOneExtDim;
    }

    private boolean isOnlyOneMember(MbgViewListDimensionInfo mbgViewListDimensionInfo) {
        HashSet<String> numberSet = new HashSet<String>();
        for (int k = 0; k < mbgViewListDimensionInfo.getSelectMembers().size(); ++k) {
            BgDimensionMember mem = (BgDimensionMember)mbgViewListDimensionInfo.getSelectMembers().get(k);
            if (numberSet.size() > 1) {
                return false;
            }
            numberSet.add(mem.getNumber());
        }
        return numberSet.size() == 1;
    }

    private void getLeafMap() throws EASBizException, BOSException {
        IBgDimensionFacade remoteInstance = BgDimensionFacadeFactory.getRemoteInstance();
        HashMap dimNumberMap = new HashMap();
        List<IMbgViewListObject> rows = this.getRows();
        for (int i = 0; i < rows.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)rows.get(i);
            List<MbgViewListDimensionInfo> dimensions = rowColObj.getDimensions();
            for (int j = 0; j < dimensions.size(); ++j) {
                MbgViewListDimensionInfo mbgViewListDimensionInfo = dimensions.get(j);
                List selectMembers = mbgViewListDimensionInfo.getSelectMembers();
                String number = mbgViewListDimensionInfo.getNumber();
                if (selectMembers == null || selectMembers.isEmpty()) continue;
                for (int k = 0; k < selectMembers.size(); ++k) {
                    BgDimensionMember mem = (BgDimensionMember)selectMembers.get(k);
                    String srcNumber = mem.getSrcNumber();
                    if (!dimNumberMap.containsKey(srcNumber)) {
                        dimNumberMap.put(srcNumber, new LinkedHashSet());
                    }
                    ((Set)dimNumberMap.get(srcNumber)).add(mem.getNumber());
                }
            }
        }
        this.leafDataMap = remoteInstance.getDimNumberIsLeaf(dimNumberMap, this.getBgschemeId());
    }

    private void initRowRender() {
        int headCols = this.getHeadCols();
        for (int i = 0; i < headCols; ++i) {
            this.tblMain.getColumn(i).setRenderer((IBasicRender)this.getRender());
        }
    }

    private boolean isAnalyseOnCol() {
        List<MbgViewListDimensionInfo> colDimension = this.getColDimensions();
        for (int i = 0; i < colDimension.size(); ++i) {
            MbgViewListDimensionInfo dim = colDimension.get(i);
            if (!ANALYSE_OBJ.equals(dim.getNumber())) continue;
            return true;
        }
        return false;
    }

    private void removeEmptyRow() {
        ArrayList<Integer> deleteRows = new ArrayList<Integer>();
        int headCols = this.getHeadCols();
        int columnCount = this.tblMain.getColumnCount();
        int rowCount = this.tblMain.getRowCount3();
        boolean isAnalyseOnCol = this.isAnalyseOnCol();
        int analyseInRowColIndex = -1;
        if (isAnalyseOnCol) {
            analyseInRowColIndex = this.getAnalyseInRowColIndex(this.getColDimensions());
        }
        for (int r = 0; r < rowCount; ++r) {
            boolean isEmptyRow = true;
            for (int c = headCols; c < columnCount; ++c) {
                BgDimensionMember mem;
                ICell cell = this.tblMain.getCell(r, c);
                if (isAnalyseOnCol && (mem = BgAnalyseDrillTableHelper.getMem(this.getHeadCell(analyseInRowColIndex, c))) != null && BgAnalyseObjConstants.EB.equals(mem.getNumber()) || cell.getValue() == null) continue;
                isEmptyRow = false;
            }
            if (!isEmptyRow) continue;
            deleteRows.add(r);
        }
        if (!deleteRows.isEmpty()) {
            IRow removeRow = null;
            int count = 0;
            for (int i = 0; i < deleteRows.size(); ++i) {
                Map<Integer, List<Integer>> beforeMergeMap = this.getBeforeMergeMap(this.tblMain.getRow((Integer)deleteRows.get(i) - count));
                removeRow = this.tblMain.removeRow((Integer)deleteRows.get(i) - count);
                this.removeAfter(beforeMergeMap);
                if (removeRow == null) continue;
                ++count;
            }
        }
    }

    private void initMdxNumMap() throws BOSException, EASBizException {
        List<BgDimensionBaseInfo> dims = this.getDimLstByDimManager();
        this.mdxNumMap = BgDimensionExtFacadeFactory.getRemoteInstance().queryMember(BOSUuid.read((String)this.bgschemeId), BOSUuid.read((String)this.orgViewId), dims);
    }

    private void dealViewManager() {
        long start = System.currentTimeMillis();
        List<MbgViewListDimensionInfo> colDimension = this.getColDimensions();
        if (this.isScenOnCol(colDimension)) {
            int scenInColIndex = this.getScenInRowColIndex(colDimension);
            List<MbgViewListDimensionInfo> colDimensions = this.getColDimensions();
            this.dealDims(scenInColIndex, colDimensions);
            List<IMbgViewListObject> cols = this.getCols();
            for (int i = 0; i < cols.size(); ++i) {
                MbgViewListRowCol col = (MbgViewListRowCol)cols.get(i);
                List<MbgViewListDimensionInfo> dimensions = col.getDimensions();
                scenInColIndex = this.getScenInRowColIndex(dimensions);
                this.dealDims(scenInColIndex, dimensions);
            }
        } else {
            List<MbgViewListDimensionInfo> rowDimensions = this.getRowDimensions();
            int scenInColIndex = this.getScenInRowColIndex(rowDimensions);
            this.dealDims(scenInColIndex, rowDimensions);
            List<IMbgViewListObject> rows = this.getRows();
            for (int i = 0; i < rows.size(); ++i) {
                MbgViewListRowCol row = (MbgViewListRowCol)rows.get(i);
                List<MbgViewListDimensionInfo> dimensions = row.getDimensions();
                scenInColIndex = this.getScenInRowColIndex(dimensions);
                this.dealDims(scenInColIndex, dimensions);
            }
        }
        logger.info((Object)("dealViewManager()() cost time:" + (System.currentTimeMillis() - start)));
    }

    private boolean isScenOnCol(List colDimension) {
        int scenInColIndex = this.getScenInRowColIndex(colDimension);
        return scenInColIndex != -1;
    }

    private void deleteRowsAndCols() {
        block8: {
            block7: {
                List colDimension = this.getSheet().getDimensionManager().getColDimension();
                if (!this.isScenOnCol(colDimension)) break block7;
                int columnsCount = this.tblMain.getColumnCount();
                int headRowCount = this.tblMain.getHeadRowCount();
                ArrayList<Integer> deleteCols = new ArrayList<Integer>();
                for (int j = this.getHeadCols(); j < columnsCount; ++j) {
                    for (int i = 0; i < headRowCount - 1; ++i) {
                        Object userObject1 = this.tblMain.getHeadRow(i).getCell(j).getUserObject();
                        Object userObject2 = this.tblMain.getHeadRow(i + 1).getCell(j).getUserObject();
                        this.dealDeleteMem(deleteCols, j, userObject1, userObject2);
                    }
                }
                if (deleteCols.isEmpty()) break block8;
                IColumn removeColumn = null;
                int count = 0;
                for (int i = 0; i < deleteCols.size(); ++i) {
                    removeColumn = this.tblMain.removeColumn((Integer)deleteCols.get(i) - count);
                    if (removeColumn == null) continue;
                    ++count;
                }
                break block8;
            }
            ArrayList<Integer> deleteRows = new ArrayList<Integer>();
            int headCols = this.getHeadCols();
            for (int j = 0; j < this.tblMain.getRowCount3(); ++j) {
                for (int i = 0; i < headCols; ++i) {
                    Object userObject1 = this.tblMain.getRow(j).getCell(i).getUserObject();
                    Object userObject2 = this.tblMain.getRow(j).getCell(i + 1).getUserObject();
                    this.dealDeleteMem(deleteRows, j, userObject1, userObject2);
                }
            }
            if (!deleteRows.isEmpty()) {
                Object removeRow = null;
                boolean count = false;
                for (int i = 0; i < deleteRows.size(); ++i) {
                    this.tblMain.getRow(((Integer)deleteRows.get(i)).intValue()).getStyleAttributes().setHided(true);
                }
            }
        }
    }

    private void dealDeleteMem(List<Integer> deleteCols, int index, Object userObject1, Object userObject2) {
        if (userObject1 instanceof Map && userObject2 instanceof Map) {
            Map userMap1 = (Map)userObject1;
            BgDimensionMember mem1 = (BgDimensionMember)userMap1.get(MEM);
            MbgViewListDimensionInfo dim1 = (MbgViewListDimensionInfo)userMap1.get(DIM);
            Map userMap2 = (Map)userObject2;
            BgDimensionMember mem2 = (BgDimensionMember)userMap2.get(MEM);
            MbgViewListDimensionInfo dim2 = (MbgViewListDimensionInfo)userMap2.get(DIM);
            if (DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dim1.getNumber()) && ANALYSE_OBJ.equals(dim2.getNumber())) {
                int scenType;
                if (BgAnalyseObjConstants.r15.equals(mem2.getName()) || BgAnalyseObjConstants.r16.equals(mem2.getName()) || BgAnalyseObjConstants.r17.equals(mem2.getName()) || BgAnalyseObjConstants.r18.equals(mem2.getName())) {
                    return;
                }
                int scenTypeValue = this.getScenMap().get(mem1.getNumber());
                if (scenTypeValue != (scenType = BgAnalyseObjConstants.getScenType(mem2.getName()))) {
                    deleteCols.add(index);
                }
            }
        }
    }

    private void fillData() {
        long start = System.currentTimeMillis();
        int headCols = this.getHeadCols();
        int rowCount3 = this.tblMain.getRowCount3();
        int columnCount = this.tblMain.getColumnCount();
        for (int r = 0; r < rowCount3; ++r) {
            for (int c = headCols; c < columnCount; ++c) {
                Map<String, BgNViewDataInfo> map2;
                String transitAnalyseObj = null;
                ICell cell = this.tblMain.getCell(r, c);
                String formula = BgAnalyseDrillTableHelper.getFormula(cell);
                String version = this.getVersion(cell);
                String analyseObj = this.getAnalyseObj(cell);
                BgDimensionMember orgMember = BgAnalyseDrillTableHelper.getMem(cell);
                String orgId = orgMember.getAttribute();
                if (BgAnalyseObjConstants.isContainsEF(analyseObj)) {
                    analyseObj = BgAnalyseObjConstants.EF;
                } else if (BgAnalyseObjConstants.isLastYear(analyseObj)) {
                    analyseObj = BgAnalyseObjConstants.BYD;
                } else if (BgAnalyseObjConstants.isLastYearRate(analyseObj)) {
                    analyseObj = BgAnalyseObjConstants.BYGR;
                } else if (BgAnalyseObjConstants.isCurYear(analyseObj)) {
                    analyseObj = BgAnalyseObjConstants.CYTD;
                } else if (BgAnalyseObjConstants.BA03.equals(analyseObj)) {
                    transitAnalyseObj = analyseObj;
                    analyseObj = BgAnalyseObjConstants.BA01;
                }
                Map<String, Map<String, BgNViewDataInfo>> map = this.dataMap.get(analyseObj);
                if (!(map instanceof Map) || !((map2 = map.get(orgId)) instanceof Map)) continue;
                if (BgAnalyseObjConstants.isContainsEF(analyseObj)) {
                    String[] params = BgNFSHelper.parseFormulaPara(formula);
                    params[3] = BgAnalyseObjConstants.EF;
                    formula = BgNFSHelper.getFormulaFromParam(params);
                }
                BgNViewDataInfo dataValue = map2.get(formula + "_" + version);
                if (StringUtils.isEmpty((String)transitAnalyseObj)) {
                    this.setValue(cell, analyseObj, dataValue);
                    continue;
                }
                this.setValue(cell, analyseObj, dataValue, transitAnalyseObj);
            }
        }
        logger.info((Object)("fillData() cost time:" + (System.currentTimeMillis() - start)));
    }

    private void setValue(ICell cell, String analyseObj, BgNViewDataInfo dataValue, String transitAnalyseObj) {
        String analyseObjOfCell = null;
        if (dataValue != null) {
            if (BgAnalyseObjConstants.BA01.equals(analyseObj)) {
                BigDecimal budgetValueNoDef = BgAnalyseObjConstants.BA03.equals(transitAnalyseObj) ? dataValue.getTransitBudget() : dataValue.getBudgetValueNoDef();
                cell.setValue((Object)this.getValue(budgetValueNoDef));
            } else if (BgAnalyseObjConstants.BA02.equals(analyseObj)) {
                BigDecimal bizActualNoDef = dataValue.getBizActualNoDef();
                cell.setValue((Object)this.getValue(bizActualNoDef));
            } else if (BgAnalyseObjConstants.EF.equals(analyseObj)) {
                analyseObjOfCell = this.getAnalyseObj(cell);
                if (BgAnalyseObjConstants.EP.equals(analyseObjOfCell)) {
                    BigDecimal exeProcess = dataValue.getExeProcess();
                    cell.setValue((Object)this.getValue(exeProcess));
                } else if (BgAnalyseObjConstants.EF.equals(analyseObjOfCell)) {
                    BigDecimal exeDiff = dataValue.getExeDiff();
                    cell.setValue((Object)this.getValue(exeDiff));
                } else if (BgAnalyseObjConstants.EFR.equals(analyseObjOfCell)) {
                    BigDecimal exeDiffRate = dataValue.getExeDiffRate();
                    cell.setValue((Object)this.getValue(exeDiffRate));
                }
            } else if (BgAnalyseObjConstants.EB.equals(analyseObj)) {
                BigDecimal budgetValueNoDef = dataValue.getBudgetValueNoDef();
                cell.setValue((Object)this.getValue(budgetValueNoDef));
            } else if (BgAnalyseObjConstants.AD.equals(analyseObj)) {
                BigDecimal budgetValueNoDef = dataValue.getBudgetValueNoDef();
                cell.setValue((Object)this.getValue(budgetValueNoDef));
            } else if (BgAnalyseObjConstants.BBA.equals(analyseObj)) {
                BigDecimal budgetValueNoDef = dataValue.getBudgetValueNoDef();
                cell.setValue((Object)this.getValue(budgetValueNoDef));
            } else if (BgAnalyseObjConstants.BYD.equals(analyseObj)) {
                analyseObjOfCell = this.getAnalyseObj(cell);
                if (BgAnalyseObjConstants.BPY.equals(analyseObjOfCell)) {
                    BigDecimal budgetValueNoDef = dataValue.getBudgetValueNoDef();
                    cell.setValue((Object)this.getValue(budgetValueNoDef));
                } else if (BgAnalyseObjConstants.APY.equals(analyseObjOfCell)) {
                    BigDecimal actValueNoDef = dataValue.getBizActualNoDef();
                    cell.setValue((Object)this.getValue(actValueNoDef));
                }
            } else if (BgAnalyseObjConstants.BYGR.equals(analyseObj)) {
                analyseObjOfCell = this.getAnalyseObj(cell);
                if (BgAnalyseObjConstants.BPYGR.equals(analyseObjOfCell)) {
                    BigDecimal budgetValueNoDef = dataValue.getBeforeYearAddRate(BgScenarioType.BudgetData);
                    cell.setValue((Object)this.getValue(budgetValueNoDef));
                } else if (BgAnalyseObjConstants.APYGR.equals(analyseObjOfCell)) {
                    BigDecimal actActualNoDef = dataValue.getBeforeYearAddRate(BgScenarioType.ActualData);
                    cell.setValue((Object)this.getValue(actActualNoDef));
                }
            } else if (BgAnalyseObjConstants.CYTD.equals(analyseObj)) {
                analyseObjOfCell = this.getAnalyseObj(cell);
                BigDecimal curYearValue = dataValue.getCurYearValueNoDef();
                cell.setValue((Object)this.getValue(curYearValue));
            }
        }
    }

    private void setValue(ICell cell, String analyseObj, BgNViewDataInfo dataValue) {
        this.setValue(cell, analyseObj, dataValue, null);
    }

    private BigDecimal getValue(BigDecimal value) {
        return value == null || value.equals(BigDecimal.ZERO) ? null : value;
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (value instanceof BigDecimal) {
            // empty if block
        }
        return value;
    }

    private void fillFormulas() {
        long start = System.currentTimeMillis();
        if (this.tblMain == null) {
            return;
        }
        int headRows = this.getHeadRows();
        int headCols = this.getHeadCols();
        int rowCount3 = this.tblMain.getRowCount3();
        int columnCount = this.tblMain.getColumnCount();
        List<BgDimensionMember> rowMembers = null;
        List<BgDimensionMember> colMembers = null;
        ArrayList<BgDimensionMember> allMembers = null;
        for (int r = 0; r < rowCount3; ++r) {
            for (int c = headCols; c < columnCount; ++c) {
                allMembers = new ArrayList<BgDimensionMember>();
                ICell cell = this.tblMain.getCell(r, c);
                rowMembers = this.getMembersByCurRow(r, headCols);
                colMembers = this.getMembersByCurCol(c, headRows);
                allMembers.addAll(rowMembers);
                allMembers.addAll(colMembers);
                this.buildFormula(allMembers, cell);
            }
        }
        logger.info((Object)("fillFormulas() cost time:" + (System.currentTimeMillis() - start)));
    }

    private List<BgDimensionMember> getMembersByCurCol(int c, int headRows) {
        ArrayList<BgDimensionMember> mems = null;
        for (int r = 0; r < headRows; ++r) {
            if (mems == null) {
                mems = new ArrayList<BgDimensionMember>();
            }
            ICell cell = this.tblMain.getHeadRow(r).getCell(c);
            mems.add(BgAnalyseDrillTableHelper.getMem(cell));
        }
        return mems;
    }

    private List<BgDimensionMember> getMembersByCurRow(int r, int headCols) {
        ArrayList<BgDimensionMember> mems = null;
        for (int c = 0; c < headCols; ++c) {
            if (mems == null) {
                mems = new ArrayList<BgDimensionMember>();
            }
            ICell cell = this.tblMain.getCell(r, c);
            mems.add(BgAnalyseDrillTableHelper.getMem(cell));
        }
        return mems;
    }

    private void buildFormula(List<BgDimensionMember> members, ICell cell) {
        if (members == null || members.isEmpty() || cell == null) {
            return;
        }
        HashMap<Integer, String> _item = new HashMap<Integer, String>();
        String _element = null;
        String _period = null;
        String _currency = null;
        String _version = null;
        String _scenario = null;
        String _analyseNumber = null;
        BgDimensionMember _org = null;
        BgDimensionMember member = null;
        Integer scenType = -1;
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            member = members.get(i);
            if (member.getType() == null || member.getNumber() == null) continue;
            if (ANALYSE_OBJ.equals(member.getType())) {
                _analyseNumber = member.getNumber();
                if (!this.isOnlyBgDataType() && BgAnalyseObjConstants.isCurrPeriodDataByNumber(_analyseNumber)) {
                    _analyseNumber = scenType == 0 ? BgAnalyseObjConstants.BA01 : BgAnalyseObjConstants.BA02;
                    continue;
                }
                if (BgAnalyseObjConstants.BYD.equals(_analyseNumber)) {
                    _analyseNumber = scenType == 0 ? BgAnalyseObjConstants.BPY : BgAnalyseObjConstants.APY;
                    continue;
                }
                if (BgAnalyseObjConstants.CYTD.equals(_analyseNumber)) {
                    _analyseNumber = scenType == 0 ? BgAnalyseObjConstants.BCYT : BgAnalyseObjConstants.ACYT;
                    continue;
                }
                if (!BgAnalyseObjConstants.BYGR.equals(_analyseNumber)) continue;
                _analyseNumber = scenType == 0 ? BgAnalyseObjConstants.BPYGR : BgAnalyseObjConstants.APYGR;
                continue;
            }
            if (MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(member.getType())) {
                if ("BGPERIOD".equals(member.getNumber())) {
                    _period = "";
                    continue;
                }
                _period = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(member.getType())) {
                _element = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(member.getType())) {
                _currency = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType())) {
                _org = member;
                continue;
            }
            if (MBGLayoutConstants.BG_SCENARIO.equalsIgnoreCase(member.getType())) {
                _scenario = member.getNumber();
                scenType = this.getScenMap().get(_scenario);
                continue;
            }
            if (MBGLayoutConstants.BG_VERSION.equalsIgnoreCase(member.getType())) {
                _version = member.getNumber();
                continue;
            }
            if (member.getNumber() == null || member.getAttribute() == null) continue;
            _item.put(DimensionCommonHelper.getField(member.getAttribute().toUpperCase()), member.getSrcNumber() + ":" + member.getNumber());
        }
        if (_item.isEmpty() || _period == null || _element == null || _currency == null || _version == null || _analyseNumber == null) {
            return;
        }
        if (_scenario == null && this.isOnlyBgDataType()) {
            scenType = BgAnalyseObjConstants.getScenTypeByNumber(_analyseNumber);
            if (scenType != 2) {
                List selectMembers;
                MbgViewListDimensionInfo removeScenDimen = this.getRemoveScenDim();
                if (removeScenDimen != null && (selectMembers = removeScenDimen.getSelectMembers()) != null && !selectMembers.isEmpty()) {
                    for (int i = 0; i < selectMembers.size(); ++i) {
                        BgDimensionMember mem = (BgDimensionMember)selectMembers.get(i);
                        Integer memScenType = this.getScenMap().get(mem.getNumber());
                        if (scenType != memScenType) continue;
                        _scenario = mem.getNumber();
                    }
                }
            } else {
                _scenario = _analyseNumber;
            }
        }
        if (BgAnalyseObjConstants.isLastYear(_analyseNumber)) {
            _period = this.getLastYearPeriodMap().get(_period);
        }
        String _bgFormula = BgViewHelper.parseItemFormula(_element, _currency, _period, _scenario, _item);
        HashMap<String, Object> userMap = new HashMap<String, Object>(4);
        userMap.put(FORMULA, _bgFormula);
        userMap.put(MEM, _org);
        userMap.put(ANALYSE_OBJ, _analyseNumber);
        userMap.put(VERSION, _version);
        userMap.put(CURRENCY, _currency);
        userMap.put(ELEMENT, _element);
        cell.setUserObject(userMap);
    }

    public static BgDimensionMember getMem(ICell cell) {
        BgDimensionMember mem = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            mem = (BgDimensionMember)userMap.get(MEM);
        }
        return mem;
    }

    public static String getFormula(ICell cell) {
        String formula = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            formula = (String)userMap.get(FORMULA);
        }
        return formula;
    }

    private String getVersion(ICell cell) {
        String version = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            version = (String)userMap.get(VERSION);
        }
        return version;
    }

    private String getAnalyseObj(ICell cell) {
        String analyseObj = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            analyseObj = (String)userMap.get(ANALYSE_OBJ);
        }
        return analyseObj;
    }

    private String getEleObj(ICell cell) {
        String analyseObj = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            analyseObj = (String)userMap.get(ELEMENT);
        }
        return analyseObj;
    }

    private String getCurrencyObj(ICell cell) {
        String analyseObj = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            analyseObj = (String)userMap.get(CURRENCY);
        }
        return analyseObj;
    }

    private MbgViewListDimensionInfo getDim(ICell cell) {
        MbgViewListDimensionInfo dim = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            dim = (MbgViewListDimensionInfo)userMap.get(DIM);
        }
        return dim;
    }

    private void clearTable() {
        this.tblMain.removeRows();
        this.tblMain.removeHeadRows();
        this.tblMain.removeColumns();
    }

    private void dealCols() throws Exception {
        int headCols = this.getHeadCols();
        List<IMbgViewListObject> cols = this.getCols();
        this.initIndex(cols, headCols);
        this.initCols(cols);
        this.mergeAndSetCols(cols);
    }

    private void mergeAndSetCols(List<IMbgViewListObject> cols) {
        for (int i = 0; i < cols.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)cols.get(i);
            this.dealRowCol(rowColObj, true, 0);
        }
    }

    private void initCols(List<IMbgViewListObject> cols) {
        int count = 0;
        for (int i = 0; i < cols.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)cols.get(i);
            rowColObj.setIndex(i);
            List<MbgViewListDimensionInfo> dimensions = rowColObj.getDimensions();
            int addColCount = 1;
            for (int j = 0; j < dimensions.size(); ++j) {
                MbgViewListDimensionInfo mbgViewListDimensionInfo = dimensions.get(j);
                int size = mbgViewListDimensionInfo.getSelectMembers().size();
                addColCount *= size;
            }
            count += addColCount;
        }
        for (int j = 0; j < count; ++j) {
            this.tblMain.addColumn();
        }
    }

    private void dealCell(int rowIndex, int colIndex, int bottom, int right, MbgViewListDimensionInfo bgDimensionInfo, BgDimensionMember bgDimensionMember) {
        HashMap<String, Cloneable> userMap = new HashMap<String, Cloneable>(2);
        userMap.put(DIM, bgDimensionInfo);
        userMap.put(MEM, bgDimensionMember);
        for (int i = rowIndex; i <= bottom; ++i) {
            for (int j = colIndex; j <= right; ++j) {
                ICell cell = this.tblMain.getCell(i, j);
                cell.setValue((Object)bgDimensionMember.getName());
                cell.setUserObject(userMap);
            }
        }
    }

    private void dealHeadCell(int rowIndex, int colIndex, int bottom, int right, MbgViewListDimensionInfo bgDimensionInfo, BgDimensionMember bgDimensionMember) {
        HashMap<String, Cloneable> userMap = new HashMap<String, Cloneable>(2);
        userMap.put(DIM, bgDimensionInfo);
        userMap.put(MEM, bgDimensionMember);
        for (int i = rowIndex; i <= bottom; ++i) {
            for (int j = colIndex; j <= right; ++j) {
                ICell headCell = this.getHeadCell(i, j);
                headCell.setValue((Object)bgDimensionMember.getName());
                headCell.setUserObject(userMap);
            }
        }
    }

    private ICell getHeadCell(int rowIndex, int colIndex) {
        return this.tblMain.getHeadRow(rowIndex).getCell(colIndex);
    }

    private void dealRows() throws Exception {
        int headRows = this.getHeadRows();
        for (int i = 0; i < headRows; ++i) {
            this.tblMain.addHeadRow();
        }
        List<IMbgViewListObject> rows = this.getRows();
        List<MbgViewListDimensionInfo> rowDimensions = this.getRowDimensions();
        int colIndex = -1;
        for (int k = 0; k < rowDimensions.size(); ++k) {
            MbgViewListDimensionInfo bgDimensionInfo = rowDimensions.get(k);
            IColumn addColumn = this.tblMain.addColumn();
            addColumn.setRenderer((IBasicRender)this.getRender());
            this.tblMain.getHeadRow(0).getCell(++colIndex).setValue((Object)bgDimensionInfo.getName());
            this.tblMain.getHeadRow(0).getCell(colIndex).setUserObject((Object)bgDimensionInfo);
            this.tblMain.getHeadMergeManager().mergeBlock(0, colIndex, headRows - 1, colIndex);
        }
        this.initIndex(rows, 0);
        this.initRows(rows);
        this.mergeAndSetRow(rows);
    }

    private void mergeAndSetRow(List<IMbgViewListObject> rows) {
        for (int i = 0; i < rows.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)rows.get(i);
            List<MbgViewListDimensionInfo> dimensions = rowColObj.getDimensions();
            for (int j = 0; j < dimensions.size(); ++j) {
                MbgViewListDimensionInfo dimensionInfo = dimensions.get(j);
                List selectMembers = dimensionInfo.getSelectMembers();
                ArrayList orginalOrgList = new ArrayList();
                if (orginalOrgList.isEmpty()) {
                    orginalOrgList.addAll(selectMembers);
                }
                for (int k = 0; k < orginalOrgList.size(); ++k) {
                    BgDimensionMember member = (BgDimensionMember)orginalOrgList.get(k);
                    ArrayList<BgDimensionMember> orgList = new ArrayList<BgDimensionMember>();
                    orgList.add(member);
                    dimensionInfo.getSelectMembers().clear();
                    dimensionInfo.getSelectMembers().addAll(orgList);
                    this.dealRowCol(rowColObj, false, k);
                }
                dimensionInfo.getSelectMembers().clear();
                dimensionInfo.getSelectMembers().addAll(orginalOrgList);
            }
        }
    }

    private void initRows(List<IMbgViewListObject> rows) {
        int count = 0;
        for (int i = 0; i < rows.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)rows.get(i);
            rowColObj.setIndex(i);
            List<MbgViewListDimensionInfo> dimensions = rowColObj.getDimensions();
            int addRowCount = 1;
            for (int j = 0; j < dimensions.size(); ++j) {
                MbgViewListDimensionInfo mbgViewListDimensionInfo = dimensions.get(j);
                int size = mbgViewListDimensionInfo.getSelectMembers().size();
                addRowCount *= size;
            }
            count += addRowCount;
        }
        for (int j = 0; j < count; ++j) {
            IRow row = this.tblMain.addRow();
            this.setFirtRow(row);
        }
    }

    private void dealRowCol(MbgViewListRowCol rowColObj, boolean isHead, int orgIndex) {
        List<MbgViewListDimensionInfo> dimensions = rowColObj.getDimensions();
        for (int i = 0; i < dimensions.size(); ++i) {
            MbgViewListDimensionInfo mbgViewListDimensionInfo = dimensions.get(i);
            List selectMembers = mbgViewListDimensionInfo.getSelectMembers();
            int count = this.getBeforeDimMemsCount(dimensions, i);
            int startIndex = rowColObj.getStartIndex();
            int index = rowColObj.getIndex();
            if (!isHead) {
                startIndex += orgIndex;
            }
            for (int k = 0; k < count; ++k) {
                for (int j = 0; j < selectMembers.size(); ++j) {
                    startIndex = this.mergeSameDimMember(i, j, dimensions, startIndex, isHead, index);
                }
            }
        }
    }

    private int getBeforeDimMemsCount(List<MbgViewListDimensionInfo> dimensions, int i) {
        int count = 1;
        for (int j = i - 1; j >= 0; --j) {
            int size = dimensions.get(j).getSelectMembers().size();
            count *= size;
        }
        return count;
    }

    private int mergeSameDimMember(int dimIndex, int memIndex, List<MbgViewListDimensionInfo> dimensions, int startIndex, boolean isHead, int index) {
        int otherMemsCount = this.getOtherDimMemCount(dimIndex, dimensions);
        int left = -1;
        int right = -1;
        int top = -1;
        int bottom = -1;
        if (isHead) {
            top = dimIndex;
            bottom = dimIndex;
            left = startIndex;
            right = left + otherMemsCount - 1;
        } else {
            left = dimIndex;
            right = dimIndex;
            top = startIndex;
            bottom = top + otherMemsCount - 1;
        }
        MbgViewListDimensionInfo mbgViewListDimensionInfo = dimensions.get(dimIndex);
        BgDimensionMember member = (BgDimensionMember)mbgViewListDimensionInfo.getSelectMembers().get(memIndex);
        KDTMergeManager mergeManager = this.dealCell(isHead, top, left, bottom, right, mbgViewListDimensionInfo, member, index);
        mergeManager.mergeBlock(top, left, bottom, right);
        ICell leftTopCell = this.tblMain.getCell(top, left);
        for (int i = top; i < bottom + 1; ++i) {
            for (int j = left; j < left + 1; ++j) {
                ICell cell = this.tblMain.getCell(i, j);
                if (cell == null) continue;
                cell.setValue(leftTopCell.getValue());
            }
        }
        startIndex = isHead ? right + 1 : bottom + 1;
        return startIndex;
    }

    private KDTMergeManager dealCell(boolean isHead, int rowIndex, int colIndex, int bottom, int right, MbgViewListDimensionInfo mbgViewListDimensionInfo, BgDimensionMember member, int index) {
        KDTMergeManager mergeManager;
        if (isHead) {
            mergeManager = this.tblMain.getHeadMergeManager();
            this.dealHeadCell(rowIndex, colIndex, bottom, right, mbgViewListDimensionInfo, member);
        } else {
            mergeManager = this.tblMain.getMergeManager();
            this.dealCell(rowIndex, colIndex, bottom, right, mbgViewListDimensionInfo, member, isHead, index);
        }
        return mergeManager;
    }

    private void dealCell(int rowIndex, int colIndex, int bottom, int right, MbgViewListDimensionInfo bgDimensionInfo, BgDimensionMember bgDimensionMember, boolean isHead, int index) {
        HashMap<String, Cloneable> userMap = new HashMap<String, Cloneable>(2);
        userMap.put(DIM, bgDimensionInfo);
        userMap.put(MEM, bgDimensionMember);
        NumberExpandExtInfo expandInfo = null;
        for (int i = rowIndex; i <= bottom; ++i) {
            for (int j = colIndex; j <= right; ++j) {
                ICell cell = this.tblMain.getCell(i, j);
                if (isHead) {
                    cell.setValue((Object)bgDimensionMember.getName());
                } else {
                    String key = bgDimensionMember.getSrcNumber() + ":" + bgDimensionMember.getNumber();
                    if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(bgDimensionInfo.getNumber())) {
                        expandInfo = this.getOrgUnitExpandInfo(this.orgUnitMap.get(bgDimensionMember.getAttribute()), bgDimensionMember);
                        expandInfo.setLeaf(this.leafDataMap.get(key));
                        expandInfo.setIndex(index);
                        cell.setValue((Object)expandInfo);
                    } else {
                        expandInfo = this.getMemberExpandInfo(bgDimensionMember);
                        if (!this.leafDataMap.containsKey(key)) {
                            expandInfo.setLeaf(true);
                        } else {
                            expandInfo.setLeaf(this.leafDataMap.get(key));
                        }
                        expandInfo.setIndex(index);
                        cell.setValue((Object)expandInfo);
                    }
                }
                cell.setUserObject(userMap);
            }
        }
    }

    protected NumberExpandExtInfo getOrgUnitExpandInfo(BgOrgUnitInfo orgUnitInfo, BgDimensionMember bgDimensionMember) {
        return this.getOrgUnitExpandInfo(orgUnitInfo, null, 0, 0, bgDimensionMember);
    }

    private int getOtherDimMemCount(int dimIndex, List<MbgViewListDimensionInfo> dimensions) {
        int sum = 1;
        for (int i = dimIndex + 1; i < dimensions.size(); ++i) {
            MbgViewListDimensionInfo mbgViewListDimensionInfo2 = dimensions.get(i);
            int membersCount = mbgViewListDimensionInfo2.getSelectMembers().size();
            sum *= membersCount;
        }
        return sum;
    }

    private void initIndex(List<IMbgViewListObject> rows, int start) {
        for (int i = 0; i < rows.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)rows.get(i);
            rowColObj.setIndex(i);
            List<MbgViewListDimensionInfo> dimensions = rowColObj.getDimensions();
            int selectMemCount = 1;
            for (int j = 0; j < dimensions.size(); ++j) {
                MbgViewListDimensionInfo dimensionInfo = dimensions.get(j);
                List selectMembers = dimensionInfo.getSelectMembers();
                selectMemCount *= selectMembers.size();
            }
            if (i == 0) {
                rowColObj.setStartIndex(0 + start);
                rowColObj.setEndIndex(selectMemCount - 1 + start);
                continue;
            }
            rowColObj.setStartIndex(((MbgViewListRowCol)rows.get(i - 1)).getEndIndex() + 1);
            rowColObj.setEndIndex(rowColObj.getStartIndex() + selectMemCount - 1);
        }
    }

    private void addDimensionAfterScen(List<MbgViewListDimensionInfo> dimensions, MbgViewListDimensionInfo dimInfo) {
        for (int j = 0; j < dimensions.size(); ++j) {
            MbgViewListDimensionInfo dimensionInfo = dimensions.get(j);
            if (!DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dimensionInfo.getNumber())) continue;
            dimensions.add(j + 1, dimInfo);
        }
    }

    public static void dealDimAndIndexMember(AnalyseMember members, String dimNumber, String bgScehemeId) throws Exception {
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgScehemeId);
        String index = dimNumber.split(",")[0].split(":")[1];
        String indexSrc = dimNumber.split(",")[0].split(":")[0];
        BgDimensionInfo dimInfo = schemeHelper.getDimension(DimensionBaseConstants.DEF_ACCOUNT_NUMBER);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)dimInfo.getViewId(), CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)index, CompareType.EQUALS));
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("longNumber");
        view.getSelector().add("isLeaf");
        view.getSelector().add("level");
        BgAccountCollection col = BgAccountFactory.getRemoteInstance().getBgAccountCollection(view);
        BgDimensionMember indexMember = new BgDimensionMember(dimInfo.getType(), dimInfo.getAttribute(), col.get(0).getName(), index);
        indexMember.setLeaf(col.get(0).isIsLeaf());
        indexMember.setLevel(col.get(0).getLevel());
        indexMember.setSortValue((Comparable)((Object)col.get(0).getLongNumber()));
        indexMember.setSrcNumber(indexSrc);
        members.setBgIndex(indexMember);
        List<String> dimNumbers = schemeHelper.getAccAndOtherDim(true);
        BgDimensionInfo dimension = null;
        HashSet<String> viewidSet = new HashSet<String>();
        HashMap<String, String> viewMap = new HashMap<String, String>();
        ArrayList<BgDimensionInfo> dimensions = new ArrayList<BgDimensionInfo>();
        for (int i = 0; i < dimNumbers.size(); ++i) {
            dimension = schemeHelper.getDimension(dimNumbers.get(i));
            if (dimension == null) continue;
            dimensions.add(dimension);
            viewidSet.add(dimension.getViewId());
            viewMap.put(dimension.getViewId(), dimension.getAttribute() + ":" + dimension.getType());
        }
        String[] dims = dimNumber.split(",");
        HashMap<String, String> dimMap = new HashMap<String, String>();
        HashSet<String> numSet = new HashSet<String>();
        for (int i = 1; i < dims.length; ++i) {
            dimMap.put(dims[i].split(":")[0], dims[i].split(":")[1]);
            numSet.add(dims[i].split(":")[1]);
        }
        view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("viewId", viewidSet, CompareType.INCLUDE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("number", numSet, CompareType.INCLUDE));
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("mbgDim.srcNumber");
        view.getSelector().add("viewId");
        MbgMemberCollection colls = MbgMemberFactory.getRemoteInstance().getMbgMemberCollection(view);
        ArrayList<BgDimensionMember> dimMembers = new ArrayList<BgDimensionMember>();
        BgDimensionMember dimMember = null;
        BgDimensionMember combinMember = null;
        for (int i = 0; i < colls.size(); ++i) {
            MbgMemberInfo info = colls.get(i);
            if (!viewMap.containsKey(info.getViewId().toString()) || !dimMap.containsKey(info.getMbgDim().getSrcNumber()) || !info.getNumber().equals(dimMap.get(info.getMbgDim().getSrcNumber()))) continue;
            dimMember = new BgDimensionMember(((String)viewMap.get(info.getViewId().toString())).split(":")[1], ((String)viewMap.get(info.getViewId().toString())).split(":")[0], info.getName(), info.getNumber());
            dimMember.setSrcNumber(info.getMbgDim().getSrcNumber());
            dimMembers.add(dimMember);
        }
        Collections.sort(dimMembers, new Comparator<BgDimensionMember>(){

            @Override
            public int compare(BgDimensionMember o1, BgDimensionMember o2) {
                String str1 = o1.getAttribute().substring(1);
                String str2 = o2.getAttribute().substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        String combinAttribute = null;
        String combinName = null;
        String combinNumber = null;
        String combinSrc = null;
        String combinType = null;
        if (dimMembers.size() > 0) {
            for (int i = 0; i < dimMembers.size(); ++i) {
                combinAttribute = combinAttribute + "," + ((BgDimensionMember)dimMembers.get(i)).getAttribute();
                combinName = combinName + "," + ((BgDimensionMember)dimMembers.get(i)).getName();
                combinNumber = combinNumber + "," + ((BgDimensionMember)dimMembers.get(i)).getNumber();
                combinSrc = combinSrc + "," + ((BgDimensionMember)dimMembers.get(i)).getSrcNumber();
                combinType = combinType + "," + ((BgDimensionMember)dimMembers.get(i)).getType();
            }
            if (combinType != null && combinAttribute != null && combinName != null && combinNumber != null) {
                combinMember = new BgDimensionMember(combinType.substring(5), combinAttribute.substring(5), combinName.substring(5), combinNumber.substring(5));
                combinMember.setSrcNumber(combinSrc.substring(5));
                members.setDimMember(combinMember);
            }
        }
    }

    private Map<String, String> getMdxNumMap() {
        return this.mdxNumMap;
    }

    protected List<BgDimensionBaseInfo> getDimLstByDimManager() {
        return DimensionCommonHelper.getDimLstByDimManager(((MbgViewListSheetManager)this.view.getSheetManagers().get(0)).getDimensionManager());
    }

    private Map<String, NumberExpandExtInfo> getDimLongNumberMap() {
        return this.dimLongNumberMap;
    }

    protected NumberExpandExtInfo getMemberExpandInfo(BgDimensionMember member) {
        return this.getMemberExpandInfo(DimUtils.transDimMember(member), null, 0, 0, member);
    }

    protected NumberExpandExtInfo getMemberExpandInfo(IMember member, NumberExpandExtInfo parentInfo, int rowIndex, int colIndex, BgDimensionMember dimMember) {
        int sepCount;
        if (member == null) {
            return null;
        }
        NumberExpandExtInfo expandInfo = new NumberExpandExtInfo();
        String longNumber = null;
        if (this.getMdxNumMap().containsKey(member.getDimNumber())) {
            longNumber = this.getMdxNumMap().get(member.getDimNumber());
        } else {
            this.getMdxNumMap().put(member.getDimNumber(), member.getMdxNumber());
            longNumber = member.getMdxNumber();
        }
        String keyString = null;
        if (parentInfo == null) {
            sepCount = longNumber.split("!").length - 1;
            expandInfo.setLevel(sepCount);
        } else {
            keyString = this.getKeyString(rowIndex, colIndex, longNumber);
            sepCount = longNumber.split("!").length - 1;
            expandInfo.setLevel(sepCount);
            expandInfo.setDimension(parentInfo.getDimension());
            expandInfo.setIndex(parentInfo.getIndex());
            if (this.dimLongNumberMap.containsKey(this.getKeyString(rowIndex, colIndex, this.subStringLongnumber(longNumber)))) {
                NumberExpandExtInfo parentExpandExtInfo = this.dimLongNumberMap.get(this.getKeyString(rowIndex, colIndex, this.subStringLongnumber(longNumber)));
                parentExpandExtInfo.setExpandStatus(true);
            }
        }
        NumberExpandExtInfo rootNumberExpandInfo = null;
        if (parentInfo != null && (rootNumberExpandInfo = parentInfo.getParentNumberExpandInfo()) == null) {
            rootNumberExpandInfo = parentInfo;
        }
        expandInfo.setParentNumberExpandInfo(rootNumberExpandInfo);
        expandInfo.setName(member.getName());
        expandInfo.setNumber(member.getNumber());
        expandInfo.setLongNumber(longNumber);
        expandInfo.setMember(member);
        expandInfo.setLeaf(true);
        expandInfo.setHasDownward(true);
        expandInfo.setDimension(new DimensionObject());
        expandInfo.getDimension().setNumber(dimMember.getType());
        expandInfo.getDimension().setField(dimMember.getRefField());
        if (keyString == null) {
            return expandInfo;
        }
        if (!this.dimLongNumberMap.containsKey(keyString)) {
            this.dimLongNumberMap.put(keyString, expandInfo);
        } else if (!((Object)((Object)expandInfo)).equals((Object)this.dimLongNumberMap.get(keyString))) {
            this.dimLongNumberMap.put(keyString, expandInfo);
        }
        return expandInfo;
    }

    private String getKeyString(int rowIndex, int colIndex, String longNumber) {
        NumberExpandExtInfo tmpExpInfo = null;
        StringBuilder keyString = new StringBuilder();
        for (int index = 0; index < this.getHeadCols(); ++index) {
            if (index == colIndex) continue;
            tmpExpInfo = (NumberExpandExtInfo)((Object)this.tblMain.getCell(rowIndex, index).getValue());
            if (tmpExpInfo == null && this.tblMain.getCell(rowIndex, index).getMergeBlock() != null) {
                tmpExpInfo = (NumberExpandExtInfo)((Object)this.tblMain.getCell(this.tblMain.getCell(rowIndex, index).getMergeBlock().getTop(), index).getValue());
            }
            if (tmpExpInfo == null) continue;
            keyString.append(tmpExpInfo.getLongNumber()).append("_");
        }
        return keyString.append(longNumber).toString();
    }

    private String subStringLongnumber(String currentLongNumber) {
        return currentLongNumber.substring(0, currentLongNumber.lastIndexOf("!"));
    }

    public void setResult(IDimDrillResult result) {
        this.result = result;
    }

    public IDimDrillResult getResult() {
        return this.result;
    }

    public void buildForDrill(KDTMouseEvent e) throws Exception {
        int clickCount = e.getClickCount();
        int type = e.getType();
        int rowIndex = e.getRowIndex();
        int colIndex = e.getColIndex();
        if (clickCount == 1 && (type == 1 || type == 0)) {
            ICell cell = null;
            if (type == 1) {
                cell = this.tblMain.getCell(rowIndex, colIndex);
            } else if (type == 0) {
                cell = this.tblMain.getHeadRow(rowIndex).getCell(colIndex);
            }
            if (cell != null && cell.getValue() instanceof NumberExpandExtInfo) {
                NumberExpandExtInfo expandInfo = (NumberExpandExtInfo)((Object)cell.getValue());
                if (this.getRender().inRect(expandInfo, e.getX(), e.getY())) {
                    this.setExpand(true);
                    this.setTreeDisplayStyle(cell, expandInfo, false);
                }
            }
        }
    }

    protected void setTreeDisplayStyle(ICell cell, NumberExpandExtInfo expandInfo, boolean isAll) throws Exception {
        if (!expandInfo.isLeaf()) {
            this.expandTable(cell, expandInfo, isAll);
        }
    }

    private void expandTable(ICell cell, NumberExpandExtInfo expandInfo, boolean isAll) throws Exception {
        if (cell == null || expandInfo == null) {
            return;
        }
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(expandInfo.getDimension().getNumber())) {
            this.expandOrgUnitDim(cell, expandInfo, isAll);
        } else {
            this.expandExtDim(cell, expandInfo, isAll);
        }
    }

    protected boolean checkEmptyRow(IRow row) {
        boolean check = true;
        if (row == null) {
            return false;
        }
        ICell cell = null;
        int colCount = this.tblMain.getColumnCount();
        for (int colIndex = this.getHeadCols(); colIndex < colCount; ++colIndex) {
            cell = row.getCell(colIndex);
            if (cell.getValue() == null || !(cell.getValue() instanceof BigDecimal) && !(cell.getValue() instanceof String)) continue;
            check = false;
            break;
        }
        return check;
    }

    public static int getIndex(String string, int i, String str) {
        Matcher slashMatcher = Pattern.compile(str).matcher(string);
        int mIdx = 0;
        while (slashMatcher.find() && ++mIdx != i) {
        }
        return slashMatcher.start();
    }

    private void expandRow(ICell cell, NumberExpandExtInfo expandInfo, boolean hided) {
        if (cell == null || expandInfo == null) {
            return;
        }
        IRow row = null;
        ICell _cell = null;
        ICell _tmpCell = null;
        ICell _firstCell = null;
        NumberExpandExtInfo _expandInfo = null;
        NumberExpandExtInfo _tmpExpandInfo = null;
        NumberExpandExtInfo nextTopExpandInfo = null;
        NumberExpandExtInfo nextExpandInfo = null;
        String nextTopExpandNumber = "";
        String nextExpandNumber = "";
        String longNumber = null;
        String parentLongNumber = expandInfo.getLongNumber();
        int pLevel = expandInfo.getLevel();
        int pIndex = expandInfo.getIndex();
        int rowIndex = cell.getRowIndex();
        int colIndex = cell.getColumnIndex();
        int _rowIndex = rowIndex + 1;
        int _rowCount = -1;
        ICell _nextCell = this.tblMain.getRow(rowIndex).getCell(colIndex + 1);
        if (_nextCell.getValue() != null && _nextCell.getValue() instanceof NumberExpandExtInfo && !StringUtils.isEmpty((String)(nextTopExpandInfo = (NumberExpandExtInfo)((Object)_nextCell.getValue())).getNumber())) {
            nextTopExpandNumber = nextTopExpandInfo.getNumber();
        }
        String tmpLongNumber = null;
        ICell preCell = this.tblMain.getRow(rowIndex).getCell(colIndex - 1 < 0 ? 0 : colIndex - 1);
        _rowCount = this.tblMain.getRowCount();
        ArrayList<Integer> deleteRows = new ArrayList<Integer>();
        while (_rowIndex < _rowCount) {
            row = this.tblMain.getRow(_rowIndex);
            _cell = row.getCell(colIndex);
            _firstCell = row.getCell(colIndex + 1);
            if (_firstCell.getValue() instanceof NumberExpandExtInfo) {
                nextExpandInfo = (NumberExpandExtInfo)((Object)_firstCell.getValue());
            } else if (_firstCell.getMergeBlock() != null && (_firstCell = this.tblMain.getCell(_firstCell.getMergeBlock().getTop(), _firstCell.getMergeBlock().getLeft())).getValue() instanceof NumberExpandExtInfo) {
                nextExpandInfo = (NumberExpandExtInfo)((Object)_firstCell.getValue());
            }
            if (nextExpandInfo != null && !StringUtils.isEmpty((String)nextExpandInfo.getNumber())) {
                nextExpandNumber = nextExpandInfo.getNumber();
            }
            if ((_cell = this.getMegerCell(_cell)).getValue() != null && !_cell.getValue().equals(cell.getValue())) {
                _expandInfo = (NumberExpandExtInfo)((Object)row.getCell(colIndex).getValue());
                longNumber = _expandInfo.getLongNumber();
                if (_expandInfo.getIndex() != expandInfo.getIndex() || longNumber.equals(parentLongNumber)) break;
                if (longNumber.startsWith(parentLongNumber + "!") && (hided || !longNumber.startsWith(tmpLongNumber + "!"))) {
                    if (!hided && !_expandInfo.isExpandStatus()) {
                        tmpLongNumber = _expandInfo.getLongNumber();
                    }
                    if (hided || this.isHideRow(row)) {
                        deleteRows.add(row.getRowIndex());
                    }
                }
            } else {
                KDTMergeBlock block = _cell.getMergeBlock();
                if (block != null && (_tmpExpandInfo = (NumberExpandExtInfo)((Object)(_tmpCell = this.tblMain.getCell(block.getTop(), block.getLeft())).getValue())) != null && _rowIndex > block.getBottom()) {
                    if (_tmpExpandInfo.getIndex() != expandInfo.getIndex()) break;
                    if (nextTopExpandInfo != null) {
                        nextTopExpandInfo.setExpandStatus(!hided);
                    }
                    String orgLongNumber = _tmpExpandInfo.getLongNumber();
                    longNumber = nextExpandInfo.getLongNumber();
                    if (!(_tmpExpandInfo != expandInfo && !orgLongNumber.startsWith(parentLongNumber + "!") || _tmpExpandInfo != expandInfo && !orgLongNumber.startsWith(parentLongNumber + "!") || !hided && longNumber.startsWith(tmpLongNumber + "!"))) {
                        if (!hided && !nextExpandInfo.isExpandStatus()) {
                            tmpLongNumber = nextExpandInfo.getLongNumber();
                        }
                        if (hided || this.isHideRow(row)) {
                            deleteRows.add(row.getRowIndex());
                        }
                    }
                }
            }
            ++_rowIndex;
        }
        IRow removeRow = null;
        int count = 0;
        for (int i = 0; i < deleteRows.size(); ++i) {
            removeRow = this.tblMain.removeRow((Integer)deleteRows.get(i) - count);
            if (removeRow == null) continue;
            ++count;
        }
        this.removeEmptyRow();
        this.mergeCell1();
    }

    private boolean isSameParent(NumberExpandExtInfo expandInfo, NumberExpandExtInfo _expandInfo) {
        return expandInfo.getParentNumberExpandInfo() == null && _expandInfo.getParentNumberExpandInfo() != null && ((Object)((Object)_expandInfo.getParentNumberExpandInfo())).equals((Object)expandInfo) || _expandInfo.getParentNumberExpandInfo() != null && ((Object)((Object)_expandInfo.getParentNumberExpandInfo())).equals((Object)expandInfo.getParentNumberExpandInfo());
    }

    protected void setHideRow(IRow row) {
        this.getUserObject(row).put(IS_HIDE_ROW, Boolean.TRUE);
    }

    protected boolean isHideRow(IRow row) {
        return Boolean.TRUE.equals(this.getUserObject(row).get(IS_HIDE_ROW));
    }

    protected Map getUserObject(IRow row) {
        if (row.getUserObject() == null) {
            row.setUserObject(new HashMap());
        }
        return (Map)row.getUserObject();
    }

    protected void setFirtRow(IRow row) {
        if (this.isFirst()) {
            this.getUserObject(row).put(IS_FIRST_ROW, Boolean.TRUE);
        }
    }

    protected boolean isFirstRow(IRow row) {
        return Boolean.TRUE.equals(this.getUserObject(row).get(IS_FIRST_ROW));
    }

    private void queryRowBeforeProcess(ICell cell, NumberExpandExtInfo expandInfo, boolean isAll) {
        this.removeSubRow(cell, expandInfo);
        this.dataStatusMap.remove(cell.getKDTCell());
        if (isAll && !this.dataStatusMap.containsKey(cell.getKDTCell())) {
            this.dataStatusMap.put(cell.getKDTCell(), ALL_EXPANDED);
        } else if (!this.dataStatusMap.containsKey(cell.getKDTCell())) {
            this.dataStatusMap.put(cell.getKDTCell(), SUB_EXPANDED);
        }
    }

    private int getEndRowCount(int rowIndex, int colIndex, String parentLongNumber, ICell cell) {
        IRow row = null;
        ICell _cell = null;
        NumberExpandExtInfo _expandInfo = null;
        String longNumber = null;
        for (int _rowIndex = rowIndex + 1; _rowIndex < this.tblMain.getRowCount(); ++_rowIndex) {
            row = this.tblMain.getRow(_rowIndex);
            if (row.getStyleAttributes().isHided()) continue;
            _cell = row.getCell(colIndex);
            KDTMergeBlock mergeBlock = cell.getMergeBlock();
            if (mergeBlock != null && _rowIndex <= mergeBlock.getBottom() || _cell.getValue() == null || _cell.getValue() == cell.getValue() || (longNumber = (_expandInfo = (NumberExpandExtInfo)((Object)row.getCell(colIndex).getValue())).getLongNumber()).startsWith(parentLongNumber + "!")) continue;
            return _rowIndex;
        }
        return this.tblMain.getRowCount();
    }

    private void removeSubRow(ICell cell, NumberExpandExtInfo expandInfo) {
        if (cell == null || expandInfo == null) {
            return;
        }
        IRow row = null;
        ICell _cell = null;
        NumberExpandExtInfo _expandInfo = null;
        String longNumber = null;
        String parentLongNumber = expandInfo.getLongNumber();
        int rowIndex = cell.getRowIndex();
        int colIndex = cell.getColumnIndex();
        int rowCount = this.getEndRowCount(rowIndex, colIndex, parentLongNumber, cell);
        int selectIndex = expandInfo.getIndex();
        for (int _rowIndex = rowIndex + 1; _rowIndex < rowCount; ++_rowIndex) {
            KDTMergeBlock mergeBlock;
            row = this.tblMain.getRow(_rowIndex);
            if (row.getStyleAttributes().isHided() || (mergeBlock = cell.getMergeBlock()) != null && _rowIndex <= mergeBlock.getBottom() || (_cell = row.getCell(colIndex)).getValue() == null || _cell.getValue() == cell.getValue()) continue;
            _expandInfo = (NumberExpandExtInfo)((Object)row.getCell(colIndex).getValue());
            longNumber = _expandInfo.getLongNumber();
            int Index2 = _expandInfo.getIndex();
            if (Index2 != selectIndex || !this.isLeaderMemberRelation(this.getKeyString(_rowIndex, colIndex, longNumber), this.getKeyString(rowIndex, colIndex, parentLongNumber))) break;
            Map<Integer, List<Integer>> beforeMergeMap = this.getBeforeMergeMap(row);
            this.tblMain.removeRow(_rowIndex);
            --_rowIndex;
            --rowCount;
            this.removeAfter(beforeMergeMap);
        }
    }

    private void removeAfter(Map<Integer, List<Integer>> beforeMergeMap) {
        if (beforeMergeMap == null) {
            return;
        }
        for (Map.Entry<Integer, List<Integer>> entry : beforeMergeMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            Integer col = entry.getKey();
            Integer top = entry.getValue().get(0);
            Integer bottom = entry.getValue().get(1);
            this.tblMain.getMergeManager().mergeBlock(top.intValue(), col.intValue(), bottom.intValue(), col.intValue());
        }
    }

    private Map<Integer, List<Integer>> getBeforeMergeMap(IRow row) {
        HashMap<Integer, List<Integer>> beforeMerge = new HashMap<Integer, List<Integer>>();
        for (int c = 0; c < this.getHeadCols(); ++c) {
            int diff;
            ICell cell2 = row.getCell(c);
            KDTMergeBlock mergeBlock2 = cell2.getMergeBlock();
            if (mergeBlock2 == null || (diff = mergeBlock2.getBottom() - mergeBlock2.getTop()) != 0 && diff != 1) continue;
            for (int c1 = 0; c1 < c; ++c1) {
                if (!beforeMerge.containsKey(c1)) {
                    beforeMerge.put(c1, new ArrayList());
                }
                List list = (List)beforeMerge.get(c1);
                ICell cell1 = row.getCell(c1);
                KDTMergeBlock mergeBlock1 = cell1.getMergeBlock();
                if (mergeBlock1 == null) continue;
                list.add(mergeBlock1.getTop());
                list.add(mergeBlock1.getBottom() - 1);
            }
        }
        if (beforeMerge.isEmpty()) {
            return null;
        }
        return beforeMerge;
    }

    private boolean isLeaderMemberRelation(String memberKeyString, String leaderKeyString) {
        if (StringUtils.isEmpty((String)memberKeyString) || StringUtils.isEmpty((String)leaderKeyString)) {
            return false;
        }
        String[] memberArray = memberKeyString.split("_");
        String[] leaderArray = leaderKeyString.split("_");
        if (memberArray == null || leaderArray == null || memberArray.length != leaderArray.length) {
            return false;
        }
        for (int i = 0; i < memberArray.length; ++i) {
            if (!memberArray[i].startsWith(leaderArray[i] + "!")) continue;
            return true;
        }
        return false;
    }

    private boolean isHasExpandRows(ICell cell, NumberExpandExtInfo expandInfo, boolean isAll) {
        if (cell == null || expandInfo == null) {
            return true;
        }
        IRow row = null;
        ICell _cell = null;
        NumberExpandExtInfo _expandInfo = null;
        String longNumber = null;
        String parentLongNumber = expandInfo.getLongNumber();
        int rowIndex = cell.getRowIndex();
        int colIndex = cell.getColumnIndex();
        for (int _rowIndex = rowIndex + 1; _rowIndex < this.tblMain.getRowCount(); ++_rowIndex) {
            row = this.tblMain.getRow(_rowIndex);
            _cell = row.getCell(colIndex);
            KDTMergeBlock mergeBlock = cell.getMergeBlock();
            if (mergeBlock != null && _rowIndex <= mergeBlock.getBottom() || _cell.getValue() == null || _cell.getValue() == cell.getValue()) continue;
            _expandInfo = (NumberExpandExtInfo)((Object)row.getCell(colIndex).getValue());
            longNumber = _expandInfo.getLongNumber();
            if (_expandInfo.getIndex() != expandInfo.getIndex() || !this.getKeyString(_rowIndex, colIndex, longNumber).startsWith(this.getKeyString(rowIndex, colIndex, parentLongNumber) + "!")) break;
            if (!(isAll ? !_expandInfo.isLeaf() && !_expandInfo.isHasExpendData() : _expandInfo.getLevel() > expandInfo.getLevel() + 1)) continue;
            return false;
        }
        return true;
    }

    private boolean checkExpandHasDataCellForRow(ICell cell, NumberExpandExtInfo expandInfo, boolean isAll) {
        return expandInfo.isHasExpendData() && this.isHasExpandRows(cell, expandInfo, isAll);
    }

    protected void expandOrgUnitDim(ICell cell, NumberExpandExtInfo expandInfo, boolean isAll) throws Exception {
        if (cell == null || expandInfo == null) {
            return;
        }
        if (expandInfo.isExpandStatus() && this.isExpand()) {
            this.expandRow(cell, expandInfo, true);
            expandInfo.setExpandStatus(false);
        } else {
            this.queryRowBeforeProcess(cell, expandInfo, isAll);
            this.querySubOrgUnitData(cell, expandInfo, isAll);
            expandInfo.setExpandStatus(true);
        }
    }

    private void setTblColor() {
        int rowCount = this.tblMain.getRowCount();
        int flag = -1;
        for (int i = 0; i < rowCount; ++i) {
            if (this.tblMain.getRow(i).getStyleAttributes().isHided()) continue;
            if (flag == 1) {
                this.tblMain.getRow(i).getStyleAttributes().setBackground(new Color(204, 225, 204));
            } else {
                this.tblMain.getRow(i).getStyleAttributes().setBackground(new Color(255, 255, 255));
            }
            flag *= -1;
        }
    }

    protected void querySubOrgUnitData(ICell cell, NumberExpandExtInfo expandInfo, boolean isAllOrg) throws Exception {
        if (cell == null || expandInfo == null) {
            return;
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor(this.getOwner());
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        final ICell _cell = cell;
        final NumberExpandExtInfo _expandInfo = expandInfo;
        final boolean _isAllOrg = isAllOrg;
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                HashMap<String, Boolean> isAllMap = new HashMap<String, Boolean>();
                isAllMap.put("isAllOrg", _isAllOrg);
                return BgAnalyseDrillTableHelper.this.getInterface().getAnalyseDataDrill(BgAnalyseDrillTableHelper.this.getBgschemeId(), BgAnalyseDrillTableHelper.this.getOrgIds(), BgAnalyseDrillTableHelper.this.analyseObjTexts(), isAllMap, BgAnalyseDrillTableHelper.this.isAduit(), BgAnalyseDrillTableHelper.this.getExpendOrgUnitParam(_cell, _expandInfo));
            }

            public void afterExec(Object result) throws Exception {
                IDimDrillResult _result = (IDimDrillResult)result;
                IRow row = null;
                IRow pRow = null;
                BgOrgUnitInfo orgUnitInfo = null;
                NumberExpandExtInfo subExpandInfo = null;
                if (!_result.getSubOrgUnits().isEmpty()) {
                    pRow = BgAnalyseDrillTableHelper.this.tblMain.getRow(_cell.getRowIndex());
                    boolean isMuiltOrgUnit = _result.getSubOrgUnits().size() > 1;
                    int in = _result.getSubOrgUnits().size();
                    for (int i = 0; i < in; ++i) {
                        orgUnitInfo = _result.getSubOrgUnits().get(i);
                        if (orgUnitInfo.isIsVirtual()) {
                            BgAnalyseDrillTableHelper.this.virtualOrgMap.put(orgUnitInfo.getOrgUnitID(), orgUnitInfo);
                        }
                        MbgViewListDimensionInfo dim = BgAnalyseDrillTableHelper.this.getDim(_cell);
                        BgDimensionMember mem = BgAnalyseDrillTableHelper.this.getMem(orgUnitInfo, _expandInfo);
                        HashMap<String, Cloneable> userMap = new HashMap<String, Cloneable>(2);
                        userMap.put(BgAnalyseDrillTableHelper.DIM, dim);
                        userMap.put(BgAnalyseDrillTableHelper.MEM, mem);
                        subExpandInfo = BgAnalyseDrillTableHelper.this.getOrgUnitExpandInfo(orgUnitInfo, _expandInfo, _cell.getRowIndex(), _cell.getColumnIndex(), mem);
                        if (_isAllOrg) {
                            subExpandInfo.setExpandStatus(true);
                            subExpandInfo.setHasExpendData(true);
                        }
                        int addRowCount = 0;
                        if (BgAnalyseDrillTableHelper.isValidMerge(_cell)) {
                            KDTMergeBlock mergeBlock = _cell.getMergeBlock();
                            for (int j = mergeBlock.getTop(); j < mergeBlock.getBottom() + 1; ++j) {
                                if (BgAnalyseDrillTableHelper.this.tblMain.getRow(j).getStyleAttributes().isHided()) continue;
                                row = BgAnalyseDrillTableHelper.this.addSubRow(_cell, _expandInfo, subExpandInfo, userMap);
                                this.dealSubRow4MergeOrg(_cell, _result, row, pRow, orgUnitInfo, isMuiltOrgUnit, mem, j, ++addRowCount, i + 1);
                            }
                            BgAnalyseDrillTableHelper.this.tblMain.getMergeManager().mergeBlock(row.getRowIndex() - addRowCount + 1, _cell.getColumnIndex(), row.getRowIndex(), _cell.getColumnIndex());
                            continue;
                        }
                        row = BgAnalyseDrillTableHelper.this.addSubRow(_cell, _expandInfo, subExpandInfo, userMap);
                        this.dealSubRowOrg(_cell, _result, row, pRow, orgUnitInfo, isMuiltOrgUnit, mem, ++addRowCount);
                    }
                    BgAnalyseDrillTableHelper.this.removeEmptyRow();
                } else {
                    _expandInfo.setLeaf(true);
                    BgAnalyseDrillTableHelper.this.tblMain.repaint();
                }
                BgAnalyseDrillTableHelper.this.mergeCell1();
            }

            private void dealSubRow4MergeOrg(ICell _cell2, IDimDrillResult _result, IRow row, IRow pRow, BgOrgUnitInfo orgUnitInfo, boolean isMuiltOrgUnit, BgDimensionMember mem, int mergeIndex, int addRowCount, int subMemberIndex) {
                BgAnalyseDrillTableHelper.this.fillAfterCurCol4Merge(_cell2, row, mergeIndex, pRow, addRowCount, subMemberIndex);
                BgAnalyseDrillTableHelper.this.fillBeforeCurCol(_cell2, row, pRow);
                IRow mergeRow = BgAnalyseDrillTableHelper.this.tblMain.getRow(mergeIndex);
                this.fillSubRowData(_result, row, mergeRow, orgUnitInfo, isMuiltOrgUnit, mem);
            }

            private void dealSubRowOrg(ICell _cell2, IDimDrillResult _result, IRow row, IRow pRow, BgOrgUnitInfo orgUnitInfo, boolean isMuiltOrgUnit, BgDimensionMember mem, int addRowCount) {
                BgAnalyseDrillTableHelper.this.fillAfterCurCol(_cell2, row, pRow, addRowCount);
                BgAnalyseDrillTableHelper.this.fillBeforeCurCol(_cell2, row, pRow);
                this.fillSubRowData(_result, row, pRow, orgUnitInfo, isMuiltOrgUnit, mem);
            }

            private void fillSubRowData(IDimDrillResult _result, IRow row, IRow pRow, BgOrgUnitInfo orgUnitInfo, boolean isMuiltOrgUnit, BgDimensionMember mem) {
                Object cellUserMap = null;
                String[] parseFormulaPara = null;
                BgScenarioInfo bgScenarioInfo = null;
                String transitAnalyseObj = null;
                int colCount = BgAnalyseDrillTableHelper.this.tblMain.getColumnCount();
                for (int colIndex = BgAnalyseDrillTableHelper.this.getHeadCols(); colIndex < colCount; ++colIndex) {
                    BgNViewDataInfo bgData;
                    Map dataMap;
                    Map mp;
                    Object object;
                    ICell pCell = pRow.getCell(colIndex);
                    if (!(pCell.getUserObject() instanceof Map)) continue;
                    HashMap<String, Object> userMapCell = new HashMap<String, Object>(4);
                    String formulaStr = BgAnalyseDrillTableHelper.getFormula(pCell);
                    userMapCell.put(BgAnalyseDrillTableHelper.FORMULA, formulaStr);
                    String verNumber = BgAnalyseDrillTableHelper.this.getVersion(pCell);
                    userMapCell.put(BgAnalyseDrillTableHelper.VERSION, verNumber);
                    userMapCell.put(BgAnalyseDrillTableHelper.ANALYSE_OBJ, BgAnalyseDrillTableHelper.this.getAnalyseObj(pCell));
                    userMapCell.put(BgAnalyseDrillTableHelper.CURRENCY, BgAnalyseDrillTableHelper.this.getCurrencyObj(pCell));
                    userMapCell.put(BgAnalyseDrillTableHelper.ELEMENT, BgAnalyseDrillTableHelper.this.getEleObj(pCell));
                    userMapCell.put(BgAnalyseDrillTableHelper.MEM, mem);
                    String analyseObj = BgAnalyseDrillTableHelper.this.getAnalyseObj(pCell);
                    parseFormulaPara = BgNFSHelper.parseFormulaPara(formulaStr);
                    bgScenarioInfo = (BgScenarioInfo)BgAnalyseDrillTableHelper.this.scenarioMap.get(parseFormulaPara[3]);
                    String keyStr = DimUtils.getDimDataKey(formulaStr, verNumber);
                    ICell cell = row.getCell(colIndex);
                    cell.setUserObject(userMapCell);
                    if (BgAnalyseObjConstants.isContainsEF(analyseObj)) {
                        analyseObj = BgAnalyseObjConstants.EF;
                        parseFormulaPara[3] = BgAnalyseObjConstants.EF;
                        keyStr = DimUtils.getDimDataKey(BgNFSHelper.getFormulaFromParam(parseFormulaPara), verNumber);
                    } else if (BgAnalyseObjConstants.isLastYear(analyseObj)) {
                        analyseObj = BgAnalyseObjConstants.BYD;
                    } else if (BgAnalyseObjConstants.isLastYearRate(analyseObj)) {
                        analyseObj = BgAnalyseObjConstants.BYGR;
                    } else if (BgAnalyseObjConstants.isCurYear(analyseObj)) {
                        analyseObj = BgAnalyseObjConstants.CYTD;
                    } else if (BgAnalyseObjConstants.BA03.equals(analyseObj)) {
                        transitAnalyseObj = analyseObj;
                        analyseObj = BgAnalyseObjConstants.BA01;
                    }
                    if (isMuiltOrgUnit) {
                        if (_result.getDimData().containsKey(analyseObj) && (object = _result.getDimData().get(analyseObj)) instanceof Map && (mp = (Map)object).containsKey(orgUnitInfo.getOrgUnitID()) && (dataMap = (Map)mp.get(orgUnitInfo.getOrgUnitID())).containsKey(keyStr)) {
                            bgData = (BgNViewDataInfo)dataMap.get(keyStr);
                            if (StringUtils.isEmpty((String)transitAnalyseObj)) {
                                BgAnalyseDrillTableHelper.this.setValue(cell, analyseObj, bgData);
                            } else {
                                BgAnalyseDrillTableHelper.this.setValue(cell, analyseObj, bgData, transitAnalyseObj);
                            }
                        }
                    } else if (_result.getDimData().containsKey(analyseObj) && (object = _result.getDimData().get(analyseObj)) instanceof Map && (dataMap = (Map)(mp = (Map)object).get(orgUnitInfo.getOrgUnitID())) != null && dataMap.containsKey(keyStr)) {
                        bgData = (BgNViewDataInfo)dataMap.get(keyStr);
                        if (StringUtils.isEmpty((String)transitAnalyseObj)) {
                            BgAnalyseDrillTableHelper.this.setValue(cell, analyseObj, bgData);
                        } else {
                            BgAnalyseDrillTableHelper.this.setValue(cell, analyseObj, bgData, transitAnalyseObj);
                        }
                    }
                    transitAnalyseObj = null;
                }
            }
        });
        dialog.show();
    }

    private void fillAfterCurCol4Merge(ICell _cell, IRow row, int mergeIndex, IRow pRow, int addRowCount, int subMemberIndex) {
        ICell cell = null;
        ICell mergeCell = null;
        IRow mergeRow = null;
        KDTMergeBlock _mergeBlock = _cell.getMergeBlock();
        int cycle = _mergeBlock.getBottom() - _mergeBlock.getTop() + 1;
        int colCount = this.getHeadCols();
        for (int colIndex = _cell.getColumnIndex() + 1; colIndex < colCount; ++colIndex) {
            mergeRow = this.tblMain.getRow(pRow.getRowIndex() + addRowCount - 1);
            if (mergeRow.getStyleAttributes().isHided()) continue;
            mergeCell = mergeRow.getCell(colIndex);
            KDTMergeBlock mergeBlock = this.getMergeBlock(mergeCell.getRowIndex(), mergeCell.getColumnIndex());
            boolean isValidMerge = BgAnalyseDrillTableHelper.isValidMerge(mergeCell);
            if (isValidMerge) {
                mergeCell = this.tblMain.getCell(mergeBlock.getTop(), mergeBlock.getLeft());
            }
            cell = row.getCell(colIndex);
            if (mergeCell == null) continue;
            if (mergeCell.getValue() instanceof NumberExpandExtInfo) {
                NumberExpandExtInfo tmpExpandInfo = (NumberExpandExtInfo)((Object)mergeCell.getValue());
                if (isValidMerge) {
                    if (cell.getRowIndex() - cycle * subMemberIndex == mergeBlock.getTop()) {
                        cell.setValue((Object)tmpExpandInfo.clone(true));
                        continue;
                    }
                    ICell lastCell = this.tblMain.getCell(row.getRowIndex() - 1, colIndex);
                    cell.setValue((Object)((NumberExpandExtInfo)((Object)lastCell.getValue())));
                    continue;
                }
                cell.setValue((Object)tmpExpandInfo.clone(true));
                continue;
            }
            cell.setValue(mergeCell.getValue());
        }
    }

    private void fillAfterCurCol(ICell _cell, IRow row, IRow pRow, int addRowCount) {
        ICell cell = null;
        ICell pCell = null;
        int colCount = this.getHeadCols();
        for (int colIndex = _cell.getColumnIndex() + 1; colIndex < colCount; ++colIndex) {
            pCell = pRow.getCell(colIndex);
            cell = row.getCell(colIndex);
            boolean isValidMerge = BgAnalyseDrillTableHelper.isValidMerge(pCell);
            if (pCell.getValue() instanceof NumberExpandExtInfo) {
                NumberExpandExtInfo tmpExpandInfo = (NumberExpandExtInfo)((Object)pCell.getValue());
                if (isValidMerge) {
                    if (addRowCount > 1) {
                        ICell lastCell = this.tblMain.getCell(row.getRowIndex() - 1, colIndex);
                        cell.setValue((Object)((NumberExpandExtInfo)((Object)lastCell.getValue())));
                        continue;
                    }
                    cell.setValue((Object)tmpExpandInfo.clone(false));
                    continue;
                }
                cell.setValue((Object)tmpExpandInfo.clone(false));
                continue;
            }
            cell.setValue(pCell.getValue());
        }
    }

    protected void mergeCell1() {
        int top = 0;
        this.tblMain.getMergeManager().removeAllMergeBlock();
        for (int colIndex = 0; colIndex <= this.getHeadCols(); ++colIndex) {
            ICell prevCell = null;
            int bottom = colIndex == 0 ? this.tblMain.getRowCount() - 1 : 1;
            for (int rowIndex = 0; rowIndex < this.tblMain.getRowCount(); ++rowIndex) {
                ICell currCell = this.tblMain.getCell(rowIndex, colIndex);
                if (colIndex > 0) {
                    ICell beforeCell = this.tblMain.getCell(rowIndex, colIndex - 1);
                    if (BgAnalyseDrillTableHelper.isValidMerge(beforeCell)) {
                        KDTMergeBlock mergeBlock = beforeCell.getMergeBlock();
                        if (rowIndex > bottom) {
                            prevCell = null;
                        }
                        top = mergeBlock.getTop();
                        bottom = mergeBlock.getBottom();
                    } else {
                        prevCell = null;
                        continue;
                    }
                }
                if (prevCell != null) {
                    Object prevCellValue = prevCell.getValue();
                    Object currCellValue = currCell.getValue();
                    if (prevCellValue instanceof NumberExpandExtInfo && currCellValue instanceof NumberExpandExtInfo) {
                        if (top <= rowIndex && rowIndex <= bottom) {
                            if (((NumberExpandExtInfo)((Object)prevCellValue)).getNumber().equals(((NumberExpandExtInfo)((Object)currCellValue)).getNumber())) {
                                KDTMergeBlock prevMergeBlock = this.getMergeBlock(prevCell.getRowIndex(), colIndex);
                                if (prevMergeBlock != null) {
                                    this.mergeBlock(prevMergeBlock.getTop(), colIndex, rowIndex, colIndex);
                                } else {
                                    this.mergeBlock(prevCell.getRowIndex(), colIndex, rowIndex, colIndex);
                                }
                            } else {
                                this.mergeBlock(prevCell.getRowIndex(), colIndex, currCell.getRowIndex() - 1, colIndex);
                            }
                        } else {
                            this.mergeBlock(prevCell.getRowIndex(), colIndex, rowIndex, colIndex);
                        }
                    }
                }
                prevCell = currCell;
            }
        }
    }

    private void mergeBlock(int top, int left, int bottom, int right) {
        if (top != bottom) {
            this.tblMain.getMergeManager().mergeBlock(top, left, bottom, right);
        }
    }

    private void mergeCell() {
        ICell currCell = null;
        this.tblMain.getMergeManager().removeAllMergeBlock();
        ICell firstCell = null;
        for (int colIndex = 0; colIndex < this.getHeadCols(); ++colIndex) {
            for (int rowIndex = 0; rowIndex < this.tblMain.getRowCount(); ++rowIndex) {
                currCell = this.tblMain.getCell(rowIndex, colIndex);
                if (firstCell == null) {
                    firstCell = currCell;
                    continue;
                }
                if (firstCell.getValue() == currCell.getValue()) continue;
                if (firstCell.getRowIndex() != currCell.getRowIndex() - 1) {
                    this.tblMain.getMergeManager().mergeBlock(firstCell.getRowIndex(), colIndex, currCell.getRowIndex() - 1, colIndex);
                }
                firstCell = currCell;
            }
        }
    }

    private void fillBeforeCurCol(ICell _cell, IRow row, IRow pRow) {
        ICell cell = null;
        ICell pCell = null;
        int rowIndex = pRow.getRowIndex();
        int colCount = _cell.getColumnIndex();
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            pCell = pRow.getCell(colIndex);
            cell = row.getCell(colIndex);
            if (pCell.getValue() instanceof NumberExpandExtInfo) {
                NumberExpandExtInfo tmpExpandInfo = (NumberExpandExtInfo)((Object)pCell.getValue());
                if (BgAnalyseDrillTableHelper.isValidMerge(pCell)) {
                    rowIndex = pCell.getMergeBlock().getBottom();
                }
                cell.setValue((Object)tmpExpandInfo);
                continue;
            }
            cell.setValue(pCell.getValue());
        }
    }

    private IRow addSubRow(ICell _cell, NumberExpandExtInfo _expandInfo, NumberExpandExtInfo subExpandInfo, Map<String, Object> userMap) {
        int insertRowIndex = this.getInsertRowIndex(_cell.getRowIndex(), _cell.getColumnIndex(), _expandInfo);
        IRow row = this.tblMain.addRow(insertRowIndex);
        row.getCell(_cell.getColumnIndex()).setValue((Object)subExpandInfo);
        row.getCell(_cell.getColumnIndex()).setUserObject(userMap);
        return row;
    }

    public static boolean isValidMerge(ICell _cell) {
        KDTMergeBlock mergeBlock = _cell.getMergeBlock();
        return mergeBlock != null && mergeBlock.getTop() != mergeBlock.getBottom();
    }

    public static boolean isValidLeftRightMerge(ICell _cell) {
        KDTMergeBlock mergeBlock = _cell.getMergeBlock();
        return mergeBlock != null && mergeBlock.getLeft() != mergeBlock.getRight();
    }

    protected BgDimensionMember getMem(BgOrgUnitInfo orgUnitInfo, NumberExpandExtInfo _expandInfo) {
        BgDimensionMember mem = new BgDimensionMember(_expandInfo.getDimension().getNumber(), orgUnitInfo.getOrgUnitID(), orgUnitInfo.getName(), orgUnitInfo.getNumber());
        mem.setSortValue((Comparable)((Object)orgUnitInfo.getLongNumber()));
        mem.setSrcNumber(_expandInfo.getMember().getSrcNumber());
        return mem;
    }

    protected int getInsertRowIndex(int pRowIndex, int pColIndex, NumberExpandExtInfo expandInfo) {
        if (pRowIndex + 1 == this.tblMain.getRowCount()) {
            return pRowIndex + 1;
        }
        int rowIndex = pRowIndex;
        IRow row = null;
        NumberExpandExtInfo subExpandInfo = null;
        int rowCount = this.tblMain.getRowCount();
        for (int index = pRowIndex + 1; index < rowCount; ++index) {
            row = this.tblMain.getRow(index);
            rowIndex = index;
            if (row.getCell(pColIndex).getMergeBlock() != null && row.getCell(pColIndex).getMergeBlock().getTop() <= pRowIndex && row.getCell(pColIndex).getMergeBlock().getBottom() >= pRowIndex) continue;
            subExpandInfo = (NumberExpandExtInfo)((Object)row.getCell(pColIndex).getValue());
            if (subExpandInfo.getIndex() != expandInfo.getIndex() || !subExpandInfo.getLongNumber().startsWith(expandInfo.getLongNumber())) {
                return rowIndex;
            }
            if (expandInfo == subExpandInfo || subExpandInfo == null) continue;
            if (expandInfo.getLongNumber() != null && subExpandInfo.getLongNumber() != null && subExpandInfo.getLongNumber().equals(expandInfo.getLongNumber())) {
                --rowIndex;
                break;
            }
            if (subExpandInfo.getLevel() > expandInfo.getLevel() || !subExpandInfo.getNumber().equals(expandInfo.getNumber()) && subExpandInfo.getLevel() > expandInfo.getLevel()) continue;
            --rowIndex;
            break;
        }
        return rowIndex + 1;
    }

    private NumberExpandExtInfo getOrgUnitExpandInfo(BgOrgUnitInfo orgUnitInfo, NumberExpandExtInfo parentInfo, int rowIndex, int colIndex, BgDimensionMember bgDimensionMember) {
        int sepCount;
        if (orgUnitInfo == null) {
            return null;
        }
        NumberExpandExtInfo expandInfo = new NumberExpandExtInfo();
        expandInfo.setId(orgUnitInfo.getOrgUnitID());
        String keyString = null;
        String currentLongNumber = orgUnitInfo.getLongNumber();
        if (parentInfo == null) {
            sepCount = currentLongNumber.split("!").length - 1;
            expandInfo.setLevel(sepCount);
        } else {
            keyString = this.getKeyString(rowIndex, colIndex, orgUnitInfo.getLongNumber());
            sepCount = currentLongNumber.split("!").length - 1;
            expandInfo.setLevel(sepCount);
            expandInfo.setDimension(parentInfo.getDimension());
            expandInfo.setIndex(parentInfo.getIndex());
            if (this.orgLongNumberMap.containsKey(this.getKeyString(rowIndex, colIndex, this.subStringLongnumber(currentLongNumber)))) {
                NumberExpandExtInfo parentExpandExtInfo = this.orgLongNumberMap.get(this.getKeyString(rowIndex, colIndex, this.subStringLongnumber(currentLongNumber)));
                parentExpandExtInfo.setExpandStatus(true);
            }
        }
        expandInfo.setMember(DimUtils.transDimMember(bgDimensionMember));
        expandInfo.setLeaf(orgUnitInfo.isIsLeaf());
        expandInfo.setNumber(orgUnitInfo.getNumber());
        expandInfo.setName(orgUnitInfo.getName());
        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
        expandInfo.setObject(orgUnitInfo);
        expandInfo.setExpandStatus(false);
        expandInfo.setHasDownward(true);
        DimensionObject dimension = new DimensionObject();
        dimension.setNumber(DimensionConstants.DEF_ORGUNIT_NUMBER);
        expandInfo.setDimension(dimension);
        if (keyString == null) {
            return expandInfo;
        }
        if (!this.orgLongNumberMap.containsKey(keyString)) {
            this.orgLongNumberMap.put(keyString, expandInfo);
        } else if (!((Object)((Object)expandInfo)).equals((Object)this.orgLongNumberMap.get(keyString))) {
            this.orgLongNumberMap.put(keyString, expandInfo);
        }
        return expandInfo;
    }

    protected BgOrgUnitInfo getQueryOrgUnit(NumberExpandExtInfo expandInfo) {
        if (expandInfo != null && expandInfo.getObject() instanceof BgOrgUnitInfo) {
            return (BgOrgUnitInfo)expandInfo.getObject();
        }
        return null;
    }

    protected List<BgOrgUnitInfo> getQueryOrgUnit(ICell cell) {
        ArrayList<BgOrgUnitInfo> orgs = null;
        if (cell == null) {
            return null;
        }
        KDTMergeBlock block = this.tblMain.getMergeManager().getMergeBlockOfCell(cell.getRowIndex(), cell.getColumnIndex());
        if (!this.isOrgOnCol()) {
            if (block == null) {
                NumberExpandExtInfo _expandInfo = (NumberExpandExtInfo)((Object)this.tblMain.getCell(cell.getRowIndex(), this.getOrgUnitRowColIndex(this.getRowDimensions())).getValue());
                if (orgs == null) {
                    orgs = new ArrayList<BgOrgUnitInfo>();
                }
                orgs.add(this.getQueryOrgUnit(_expandInfo));
            } else {
                for (int i = block.getTop(); i <= block.getBottom(); ++i) {
                    ICell orgCell = this.tblMain.getCell(i, this.getOrgUnitRowColIndex(this.getRowDimensions()));
                    if (orgCell == null) continue;
                    orgCell = this.getMegerCell(orgCell);
                    NumberExpandExtInfo _expandInfo = (NumberExpandExtInfo)((Object)orgCell.getValue());
                    if (orgs == null) {
                        orgs = new ArrayList();
                    }
                    orgs.add(this.getQueryOrgUnit(_expandInfo));
                }
            }
        } else {
            return this.getOrgUnits();
        }
        return orgs;
    }

    protected NumberExpandExtInfo getOrgUnit(ICell cell) {
        if (cell == null) {
            return null;
        }
        ICell orgCell = this.tblMain.getCell(cell.getRowIndex(), this.getOrgUnitRowColIndex(this.getRowDimensions()));
        if (orgCell != null) {
            orgCell = this.getMegerCell(orgCell);
            return (NumberExpandExtInfo)((Object)orgCell.getValue());
        }
        return null;
    }

    protected ICell getMegerCell(ICell cell) {
        if (cell == null) {
            return cell;
        }
        KDTMergeBlock block = this.tblMain.getMergeManager().getMergeBlockOfCell(cell.getRowIndex(), cell.getColumnIndex());
        if (block != null) {
            cell = this.tblMain.getCell(block.getTop(), block.getLeft());
        }
        return cell;
    }

    protected List<BgOrgUnitInfo> getQueryOrgUnitNums(NumberExpandExtInfo expandInfo) {
        BgOrgUnitInfo orgUnit = null;
        ArrayList<BgOrgUnitInfo> orgUnits = new ArrayList<BgOrgUnitInfo>();
        if (expandInfo != null) {
            orgUnit = new BgOrgUnitInfo();
            orgUnit.setOrgUnitID(expandInfo.getId());
            orgUnit.setNumber(expandInfo.getNumber());
            orgUnit.setLongNumber(expandInfo.getLongNumber());
            orgUnits.add(orgUnit);
        } else {
            ICell cell = null;
            NumberExpandExtInfo _expandInfo = null;
            int in = this.tblMain.getRowCount();
            for (int i = 0; i < in; ++i) {
                cell = this.tblMain.getCell(i, this.getOrgUnitRowColIndex(this.getRowDimensions()));
                if (cell == null || !(cell.getValue() instanceof NumberExpandExtInfo)) continue;
                _expandInfo = (NumberExpandExtInfo)((Object)cell.getValue());
                orgUnit = new BgOrgUnitInfo();
                orgUnit.setOrgUnitID(_expandInfo.getId());
                orgUnit.setNumber(_expandInfo.getNumber());
                orgUnit.setLongNumber(_expandInfo.getLongNumber());
                if (_expandInfo.getObject() instanceof BgOrgUnitInfo) {
                    BgOrgUnitInfo _bgOrgUnit = (BgOrgUnitInfo)_expandInfo.getObject();
                    orgUnit.setId(_bgOrgUnit.getId());
                }
                orgUnits.add(orgUnit);
            }
        }
        return orgUnits;
    }

    private int getOrgUnitRowColIndex(List<MbgViewListDimensionInfo> rowDimension) {
        for (int i = 0; i < rowDimension.size(); ++i) {
            MbgViewListDimensionInfo dim = rowDimension.get(i);
            if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
            return i;
        }
        return -1;
    }

    protected IDimDrillParameter getQueryParam(ICell cell, NumberExpandExtInfo expandInfo) throws Exception {
        ICell _cell = null;
        boolean hasOrgUnit = false;
        boolean hasPeriod = false;
        DimDrillParameter parameter = new DimDrillParameter();
        parameter.setViewStates(this.getViewStates());
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(expandInfo.getDimension().getNumber())) {
            hasOrgUnit = true;
            parameter.setBgOrgUnit(this.getQueryOrgUnit(expandInfo));
            parameter.getQueryOrgUnits().addAll(this.getQueryOrgUnitNums(expandInfo));
        } else {
            parameter.getQueryOrgUnits().addAll(this.getQueryOrgUnit(cell));
        }
        if (!hasOrgUnit) {
            parameter.getQueryDimNumbers().addAll(this.getQueryDimNumbers(expandInfo));
        }
        parameter.setBgOrgViewId(BOSUuid.read((String)this.getOrgViewId()));
        parameter.setBgSchemeId(BOSUuid.read((String)this.getBgschemeId()));
        parameter.setBgVersions(this.getVersions());
        parameter.setValueType(this.getValueType());
        if (expandInfo.isHasDownward()) {
            KDTMergeBlock block = this.tblMain.getMergeManager().getMergeBlockOfCell(cell.getRowIndex(), cell.getColumnIndex());
            if (block != null) {
                for (int r = block.getTop(); r < block.getBottom() + 1; ++r) {
                    int colCount = this.tblMain.getColumnCount();
                    for (int colIndex = this.getHeadCols(); colIndex < colCount; ++colIndex) {
                        String analyseObj;
                        _cell = this.tblMain.getCell(r, colIndex);
                        if (_cell == null || !(_cell.getUserObject() instanceof Map) || !BgAnalyseObjConstants.BA01.equals(analyseObj = this.getAnalyseObj(_cell)) && !BgAnalyseObjConstants.BA02.equals(analyseObj) && !BgAnalyseObjConstants.AD.equals(analyseObj)) continue;
                        parameter.getDimDatas().add(BgAnalyseDrillTableHelper.getFormula(_cell));
                    }
                }
            } else {
                int colCount = this.tblMain.getColumnCount();
                for (int colIndex = this.getHeadCols(); colIndex < colCount; ++colIndex) {
                    String analyseObj;
                    _cell = this.tblMain.getCell(cell.getRowIndex(), colIndex);
                    if (_cell == null || !(_cell.getUserObject() instanceof Map) || !BgAnalyseObjConstants.BA01.equals(analyseObj = this.getAnalyseObj(_cell)) && !BgAnalyseObjConstants.BA02.equals(analyseObj) && !BgAnalyseObjConstants.AD.equals(analyseObj)) continue;
                    parameter.getDimDatas().add(BgAnalyseDrillTableHelper.getFormula(_cell));
                }
            }
        }
        List<String> dimDatas = parameter.getDimDatas();
        HashSet<String> hashSet = new HashSet<String>(dimDatas);
        parameter.getDimDatas().clear();
        parameter.getDimDatas().addAll(hashSet);
        parameter.setShowSeal(false);
        parameter.setMutilAnalyse(true);
        return parameter;
    }

    protected List<String> getQueryDimNumbers(NumberExpandExtInfo expandInfo) {
        ArrayList<String> dimNumbers = new ArrayList<String>();
        if (expandInfo != null) {
            dimNumbers.add(expandInfo.getMember().getDimNumber());
        }
        return dimNumbers;
    }

    protected List<BgPeriodInfo> getQueryPeriodNums() {
        return this.getQueryPeriodNums(null);
    }

    protected List<BgPeriodInfo> getQueryPeriodNums(NumberExpandExtInfo expandInfo) {
        BgPeriodInfo bgPeriod = null;
        ArrayList<BgPeriodInfo> bgPeriods = new ArrayList<BgPeriodInfo>();
        if (expandInfo != null) {
            bgPeriod = new BgPeriodInfo();
            bgPeriod.setId(BOSUuid.read((String)expandInfo.getId()));
            bgPeriod.setNumber(expandInfo.getNumber());
            bgPeriod.setLongNumber(expandInfo.getLongNumber());
            bgPeriods.add(bgPeriod);
        } else {
            ICell cell = null;
            Object _expandInfo = null;
            block0: for (int r = 0; r < this.tblMain.getHeadRowCount(); ++r) {
                int in = this.tblMain.getColumnCount();
                for (int c = this.getHeadCols(); c < in; ++c) {
                    cell = this.tblMain.getHeadRow(r).getCell(c);
                    if (cell == null || !(cell.getUserObject() instanceof Map)) continue;
                    MbgViewListDimensionInfo dim = this.getDim(cell);
                    BgDimensionMember mem = BgAnalyseDrillTableHelper.getMem(cell);
                    if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(dim.getNumber())) continue block0;
                    bgPeriod = new BgPeriodInfo();
                    bgPeriod.setNumber(mem.getNumber());
                    bgPeriod.setLongNumber((String)((Object)mem.getSortValue()));
                    bgPeriods.add(bgPeriod);
                }
            }
        }
        return bgPeriods;
    }

    protected IDimDrillParameter getExpendOrgUnitParam(ICell cell, NumberExpandExtInfo expandInfo) throws Exception {
        IDimDrillParameter parameter = this.getQueryParam(cell, expandInfo);
        parameter.setHasExpendOrgUnit(true);
        return parameter;
    }

    protected IDimDrillParameter getExpendExtDimParam(ICell cell, NumberExpandExtInfo expandInfo) throws Exception {
        IDimDrillParameter parameter = this.getQueryParam(cell, expandInfo);
        parameter.setHasExpandDimNum(true);
        return parameter;
    }

    protected void queryExtDimData(ICell cell, NumberExpandExtInfo expandInfo, boolean isAllDim) throws Exception {
        if (cell == null || expandInfo == null) {
            return;
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor(this.getOwner());
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        final ICell _cell = cell;
        final NumberExpandExtInfo _expandInfo = expandInfo;
        final boolean _isAllDim = isAllDim;
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                HashMap<String, Boolean> isAllMap = new HashMap<String, Boolean>();
                if (!DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(_expandInfo.getDimension().getNumber())) {
                    isAllMap.put("isAllDim", _isAllDim);
                } else {
                    isAllMap.put("isAllAcc", _isAllDim);
                }
                return BgAnalyseDrillTableHelper.this.getInterface().getAnalyseDataDrill(BgAnalyseDrillTableHelper.this.getBgschemeId(), BgAnalyseDrillTableHelper.this.getOrgIds(), BgAnalyseDrillTableHelper.this.analyseObjTexts(), isAllMap, BgAnalyseDrillTableHelper.this.isAduit(), BgAnalyseDrillTableHelper.this.getExpendExtDimParam(_cell, _expandInfo));
            }

            public void afterExec(Object result) throws Exception {
                IDimDrillResult _result = (IDimDrillResult)result;
                IRow row = null;
                IRow pRow = null;
                IMember subMember = null;
                NumberExpandExtInfo subExpandInfo = null;
                boolean isMuiltOrgUnit = _result.getSubOrgUnits().size() > 1;
                pRow = BgAnalyseDrillTableHelper.this.tblMain.getRow(_cell.getRowIndex());
                int in = _result.getSubDimNumbers().size();
                for (int i = 0; i < in; ++i) {
                    subMember = _result.getSubDimNumbers().get(i);
                    if (_expandInfo.getNumber().equals(subMember.getNumber())) continue;
                    MbgViewListDimensionInfo dim = BgAnalyseDrillTableHelper.this.getDim(_cell);
                    BgDimensionMember mem = BgAnalyseDrillTableHelper.this.getMem(subMember, _expandInfo);
                    HashMap<String, Cloneable> userMap = new HashMap<String, Cloneable>(2);
                    userMap.put(BgAnalyseDrillTableHelper.DIM, dim);
                    userMap.put(BgAnalyseDrillTableHelper.MEM, mem);
                    subExpandInfo = BgAnalyseDrillTableHelper.this.getMemberExpandInfo(subMember, _expandInfo, _cell.getRowIndex(), _cell.getColumnIndex(), mem);
                    if (_result.getLeafDataMap().containsKey(subMember.getDimNumber())) {
                        subExpandInfo.setLeaf(_result.getLeafDataMap().get(subMember.getDimNumber()));
                    } else {
                        subExpandInfo.setLeaf(true);
                    }
                    int addRowCount = 0;
                    if (BgAnalyseDrillTableHelper.isValidMerge(_cell)) {
                        KDTMergeBlock mergeBlock = _cell.getMergeBlock();
                        for (int j = mergeBlock.getTop(); j < mergeBlock.getBottom() + 1; ++j) {
                            if (BgAnalyseDrillTableHelper.this.tblMain.getRow(j).getStyleAttributes().isHided()) continue;
                            row = BgAnalyseDrillTableHelper.this.addSubRow(_cell, _expandInfo, subExpandInfo, userMap);
                            BgAnalyseDrillTableHelper.this.dealMergeExtDim(_cell, _expandInfo, _result, row, pRow, subExpandInfo, isMuiltOrgUnit, j, ++addRowCount, i + 1);
                        }
                        BgAnalyseDrillTableHelper.this.tblMain.getMergeManager().mergeBlock(row.getRowIndex() - addRowCount + 1, _cell.getColumnIndex(), row.getRowIndex(), _cell.getColumnIndex());
                        continue;
                    }
                    row = BgAnalyseDrillTableHelper.this.addSubRow(_cell, _expandInfo, subExpandInfo, userMap);
                    BgAnalyseDrillTableHelper.this.dealExtDim(_cell, _expandInfo, _result, row, pRow, subExpandInfo, isMuiltOrgUnit, ++addRowCount);
                }
                BgAnalyseDrillTableHelper.this.removeEmptyRow();
                BgAnalyseDrillTableHelper.this.mergeCell1();
            }
        });
        dialog.show();
    }

    private void dealExtDim(ICell _cell, NumberExpandExtInfo _expandInfo, IDimDrillResult _result, IRow row, IRow pRow, NumberExpandExtInfo subExpandInfo, boolean isMuiltOrgUnit, int addRowCount) {
        this.fillAfterCurCol(_cell, row, pRow, addRowCount);
        this.fillBeforeCurCol(_cell, row, pRow);
        this.fillExtDimData(pRow, _expandInfo, _result, row, subExpandInfo, isMuiltOrgUnit);
    }

    private void dealMergeExtDim(ICell _cell, NumberExpandExtInfo _expandInfo, IDimDrillResult _result, IRow row, IRow pRow, NumberExpandExtInfo subExpandInfo, boolean isMuiltOrgUnit, int mergeIndex, int addRowCount, int subMemberIndex) {
        this.fillAfterCurCol4Merge(_cell, row, mergeIndex, pRow, addRowCount, subMemberIndex);
        this.fillBeforeCurCol(_cell, row, pRow);
        IRow mergeRow = this.tblMain.getRow(mergeIndex);
        this.fillExtDimData(mergeRow, _expandInfo, _result, row, subExpandInfo, isMuiltOrgUnit);
    }

    private void fillExtDimData(IRow pRow, NumberExpandExtInfo _expandInfo, IDimDrillResult _result, IRow row, NumberExpandExtInfo subExpandInfo, boolean isMuiltOrgUnit) {
        int colCount = this.tblMain.getColumnCount();
        for (int colIndex = this.getHeadCols(); colIndex < colCount; ++colIndex) {
            Map dataMap;
            Map mp;
            Object object;
            String orgUnitId;
            BgNViewDataInfo bgData;
            ICell pCell = this.tblMain.getCell(pRow.getRowIndex(), colIndex);
            if (!(pCell.getUserObject() instanceof Map)) continue;
            HashMap<String, Object> userMapCell = new HashMap<String, Object>();
            String formulaStr = BgAnalyseDrillTableHelper.getFormula(pCell);
            String verNumber = this.getVersion(pCell);
            userMapCell.put(VERSION, verNumber);
            String analyseObj = this.getAnalyseObj(pCell);
            userMapCell.put(ANALYSE_OBJ, analyseObj);
            userMapCell.put(CURRENCY, this.getCurrencyObj(pCell));
            userMapCell.put(ELEMENT, this.getEleObj(pCell));
            userMapCell.put(MEM, BgAnalyseDrillTableHelper.getMem(pCell));
            String[] formulaStrs = BgNFSHelper.parseFormulaPara(formulaStr);
            formulaStrs[0] = formulaStrs[0].replaceAll(_expandInfo.getMember().getDimNumber(), subExpandInfo.getMember().getDimNumber());
            formulaStr = BgNFSHelper.getFormulaFromParam(formulaStrs);
            userMapCell.put(FORMULA, formulaStr);
            String keyStr = DimUtils.getDimDataKey(formulaStr, verNumber);
            ICell cell = row.getCell(colIndex);
            cell.setUserObject(userMapCell);
            String orgId = this.getOrgIdForCell(cell);
            String transitAnalyseObj = null;
            if (BgAnalyseObjConstants.isContainsEF(analyseObj)) {
                analyseObj = BgAnalyseObjConstants.EF;
                formulaStrs[3] = BgAnalyseObjConstants.EF;
                keyStr = DimUtils.getDimDataKey(BgNFSHelper.getFormulaFromParam(formulaStrs), verNumber);
            } else if (BgAnalyseObjConstants.isLastYear(analyseObj)) {
                analyseObj = BgAnalyseObjConstants.BYD;
            } else if (BgAnalyseObjConstants.isLastYearRate(analyseObj)) {
                analyseObj = BgAnalyseObjConstants.BYGR;
            } else if (BgAnalyseObjConstants.isCurYear(analyseObj)) {
                analyseObj = BgAnalyseObjConstants.CYTD;
            } else if (BgAnalyseObjConstants.BA03.equals(analyseObj)) {
                transitAnalyseObj = analyseObj;
                analyseObj = BgAnalyseObjConstants.BA01;
            }
            if (isMuiltOrgUnit) {
                Map dataMap2;
                Map mp2;
                Object object2;
                if (!_result.getDimData().containsKey(analyseObj) || !((object2 = _result.getDimData().get(analyseObj)) instanceof Map) || !(mp2 = (Map)object2).containsKey(orgId) || (dataMap2 = (Map)mp2.get(orgId)) == null || !dataMap2.containsKey(keyStr)) continue;
                bgData = (BgNViewDataInfo)dataMap2.get(keyStr);
                if (StringUtils.isEmpty((String)transitAnalyseObj)) {
                    this.setValue(cell, analyseObj, bgData);
                    continue;
                }
                this.setValue(cell, analyseObj, bgData, transitAnalyseObj);
                continue;
            }
            String string = orgUnitId = _result.getCurrOrgUnit() != null ? _result.getCurrOrgUnit().getOrgUnitID() : null;
            if (orgUnitId == null && !_result.getSubOrgUnits().isEmpty()) {
                orgUnitId = _result.getSubOrgUnits().get(0).getOrgUnitID();
            }
            if (!_result.getDimData().containsKey(analyseObj) || !((object = _result.getDimData().get(analyseObj)) instanceof Map) || !(mp = (Map)object).containsKey(orgUnitId) || (dataMap = (Map)mp.get(orgUnitId)) == null || !dataMap.containsKey(keyStr)) continue;
            bgData = (BgNViewDataInfo)dataMap.get(keyStr);
            if (StringUtils.isEmpty((String)transitAnalyseObj)) {
                this.setValue(cell, analyseObj, bgData);
                continue;
            }
            this.setValue(cell, analyseObj, bgData, transitAnalyseObj);
        }
    }

    private String getOrgIdForCell(ICell cell) {
        String orgId = null;
        if (!this.isOrgOnCol()) {
            NumberExpandExtInfo orgExpandInfo = this.getOrgUnit(cell);
            orgId = orgExpandInfo.getId();
        } else {
            BgDimensionMember orgMem = BgAnalyseDrillTableHelper.getMem(cell);
            orgId = orgMem.getAttribute();
        }
        return orgId;
    }

    protected BgDimensionMember getMem(IMember subMember, NumberExpandExtInfo _expandInfo) {
        String srcNumber = subMember.getDimNumber().split(":")[0];
        BgDimensionMember mem = new BgDimensionMember(_expandInfo.getDimension().getNumber(), _expandInfo.getDimension().getField(), subMember.getName(), subMember.getNumber());
        mem.setSortValue((Comparable)((Object)subMember.getMdxNumber()));
        mem.setSrcNumber(srcNumber);
        return mem;
    }

    private BgSchemeDimensionHelper getBgSchemeDimensionHelper() throws EASBizException, BOSException {
        String bgScehemeId = this.getBgschemeId();
        if (this.schemeDimensionHelper == null) {
            this.schemeDimensionHelper = new BgSchemeDimensionHelper(bgScehemeId);
        }
        return this.schemeDimensionHelper;
    }

    protected KDTMergeBlock getMergeBlock(int rowIndex, int colIndex) {
        return this.tblMain.getMergeManager().getMergeBlockOfCell(rowIndex, colIndex);
    }

    protected void expandExtDim(ICell cell, NumberExpandExtInfo expandInfo, boolean isAll) throws Exception {
        if (cell == null || expandInfo == null) {
            return;
        }
        if (expandInfo.isExpandStatus() && this.isExpand()) {
            this.expandRow(cell, expandInfo, true);
            expandInfo.setExpandStatus(false);
        } else {
            this.queryRowBeforeProcess(cell, expandInfo, isAll);
            this.queryExtDimData(cell, expandInfo, isAll);
            expandInfo.setExpandStatus(true);
        }
    }

    public boolean isExpand() {
        return this.isExpand;
    }

    public void setExpand(boolean isExpand) {
        this.isExpand = isExpand;
    }

    protected IMBGViewListFormFacade getInterface() throws BOSException {
        return MBGViewListFormFacadeFactory.getRemoteInstance();
    }

    protected IDimDrillParameter getDrillParameter() throws EASBizException, BOSException {
        DimDrillParameter parameter = new DimDrillParameter();
        parameter.setViewStates(this.getViewStates());
        parameter.setHasInit(true);
        parameter.setQueryOrgUnits(this.getOrgUnits());
        parameter.setBgSchemeId(BOSUuid.read((String)this.getBgschemeId()));
        parameter.setBgVersions(this.getVersions());
        parameter.setBgOrgViewId(BOSUuid.read((String)this.getOrgViewId()));
        parameter.setBgTemplateIds(null);
        parameter.setPeriodStandardNumber(null);
        parameter.setShowSeal(false);
        parameter.setMutilAnalyse(true);
        return parameter;
    }

    private List<IMember> getVersions() {
        MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)this.view.getSheetManagers().get(0)).getDimensionManager();
        List<IMbgViewListObject> rowCols = dimensionManager.getRowCols();
        ArrayList<IMember> list = new ArrayList<IMember>();
        for (IMbgViewListObject item : rowCols) {
            MbgViewListRowCol rowCol = (MbgViewListRowCol)item;
            BgDimensionBaseInfo versionDimension = DimensionCommonHelper.searchDimension(DimensionConstants.DEF_VERSION_NUMBER, rowCol.getDimensions());
            if (versionDimension == null) continue;
            List selectMembers = versionDimension.getSelectMembers();
            for (int i = 0; i < selectMembers.size(); ++i) {
                IMember transDimMember = DimUtils.transDimMember((BgDimensionMember)selectMembers.get(i));
                String versionId = this.vesionIdMap.get(transDimMember.getNumber());
                transDimMember.setMdxNumber(versionId);
                transDimMember.setInnerId(Integer.valueOf(versionId));
                list.add(transDimMember);
            }
        }
        return list;
    }

    private Set<String> getOrgIds() {
        return this.orgIds;
    }

    public void setOrgIds(Set<String> orgIds) {
        this.orgIds = orgIds;
    }

    private boolean isHideMbgDim() {
        return this.hideMbgDim;
    }

    public void setHideExtDim(boolean hideMbgDim) {
        this.hideMbgDim = hideMbgDim;
    }

    public void initPop(PopupMenuManager mgr) {
        int i;
        ActionListener[] actionListeners;
        if (!this.menuSectionNotAllExp.containsMenuItemName("allExpAction")) {
            this.menuSectionNotAllExp.insertBefore((JMenuItem)this.menuItemNotAllExp);
            actionListeners = this.menuItemNotAllExp.getActionListeners();
            for (i = 0; i < actionListeners.length; ++i) {
                this.menuItemNotAllExp.removeActionListener(actionListeners[i]);
            }
            this.menuItemNotAllExp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BgAnalyseDrillTableHelper.this.expDirect();
                }
            });
        }
        if (mgr.findMenuSection("notAllExpAction") == null) {
            mgr.addMenuSection(this.menuSectionNotAllExp);
        } else if (mgr.findMenuSection("notAllExpAction") != null) {
            mgr.removeMenuSection("notAllExpAction");
            mgr.addMenuSection(this.menuSectionNotAllExp);
        }
        if (!this.menuSectionAllExp.containsMenuItemName("allExpAction")) {
            this.menuSectionAllExp.insertBefore((JMenuItem)this.menuItemAllExp);
            actionListeners = this.menuItemAllExp.getActionListeners();
            for (i = 0; i < actionListeners.length; ++i) {
                this.menuItemAllExp.removeActionListener(actionListeners[i]);
            }
            this.menuItemAllExp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BgAnalyseDrillTableHelper.this.expAll();
                }
            });
        }
        if (mgr.findMenuSection("allExpAction") == null) {
            mgr.addMenuSection(this.menuSectionAllExp);
        } else if (mgr.findMenuSection("allExpAction") != null) {
            mgr.removeMenuSection("allExpAction");
            mgr.addMenuSection(this.menuSectionAllExp);
        }
    }

    public void expAll() {
        int activeColumnIndex = this.tblMain.getSelectManager().getActiveColumnIndex();
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        boolean expandSign = ALL_EXPANDED.equals(this.tblMain.getCell(activeRowIndex, activeColumnIndex));
        if (BgAnalyseDrillTableHelper.getExpandParam()) {
            List<ICell> selectedCells = this.getSelectedCells();
            if (selectedCells.size() >= 1) {
                for (int i = 0; i < selectedCells.size(); ++i) {
                    KDTMergeBlock mergeBlock = selectedCells.get(i).getKDTCell().getMergeBlock();
                    if (mergeBlock != null && (mergeBlock.getRight() != selectedCells.get(i).getColumnIndex() || mergeBlock.getTop() != selectedCells.get(i).getRowIndex())) continue;
                    this.expandCell(selectedCells.get(i).getColumnIndex(), selectedCells.get(i).getRowIndex(), true, expandSign);
                }
            }
        } else {
            this.expandCell(activeColumnIndex, activeRowIndex, true, expandSign);
        }
    }

    public void expDirect() {
        int activeColumnIndex = this.tblMain.getSelectManager().getActiveColumnIndex();
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        boolean expandSign = SUB_EXPANDED.equals(this.dataStatusMap.get(this.tblMain.getCell(activeRowIndex, activeColumnIndex)));
        if (BgAnalyseDrillTableHelper.getExpandParam()) {
            List<ICell> selectedCells = this.getSelectedCells();
            if (selectedCells.size() >= 1) {
                for (int i = 0; i < selectedCells.size(); ++i) {
                    KDTMergeBlock mergeBlock = selectedCells.get(i).getKDTCell().getMergeBlock();
                    if (mergeBlock != null && (mergeBlock.getRight() != selectedCells.get(i).getColumnIndex() || mergeBlock.getTop() != selectedCells.get(i).getRowIndex())) continue;
                    this.expandCell(selectedCells.get(i).getColumnIndex(), selectedCells.get(i).getRowIndex(), false, expandSign);
                }
            }
        } else {
            this.expandCell(activeColumnIndex, activeRowIndex, false, expandSign);
        }
    }

    private void expandCell(int activeColumnIndex, int activeRowIndex, boolean isAll, boolean expandSign) {
        if (activeColumnIndex < this.getHeadCols() && this.tblMain.getCell(activeRowIndex, activeColumnIndex) != null && this.tblMain.getCell(activeRowIndex, activeColumnIndex).getValue() instanceof NumberExpandExtInfo) {
            NumberExpandExtInfo expInfo = (NumberExpandExtInfo)((Object)this.tblMain.getCell(activeRowIndex, activeColumnIndex).getValue());
            if (expInfo != null && expInfo.isExpandStatus() && expandSign) {
                return;
            }
            try {
                this.setExpand(false);
                this.setTreeDisplayStyle(this.tblMain.getCell(activeRowIndex, activeColumnIndex), expInfo, isAll);
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage(), (Throwable)e1);
            }
        } else {
            MsgBox.showWarning((Component)this.getOwner(), (String)EASResource.getString((String)RES_PATH, (String)"selectRowExpand"));
            SysUtil.abort();
        }
    }

    private List<ICell> getSelectedCells() {
        Object cell = null;
        KDTSelectBlock block = null;
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range == null) {
            return null;
        }
        int rangeSize = range.size();
        int rowBegin = 0;
        int rowEnd = 0;
        int colBegin = 0;
        int colEnd = 0;
        ArrayList<ICell> cellList = new ArrayList<ICell>();
        int maxColIndex = -1;
        int maxRowIndex = -1;
        for (int i = 0; i < rangeSize; ++i) {
            block = (KDTSelectBlock)range.get(i);
            colBegin = block.getBeginCol();
            colEnd = block.getEndCol();
            rowBegin = block.getBeginRow();
            rowEnd = block.getEndRow();
            for (int rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                for (int colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                    if (this.tblMain.getCell(rowIndex, colIndex) == null) continue;
                    cellList.add(this.tblMain.getCell(rowIndex, colIndex));
                }
            }
        }
        if (cellList.isEmpty()) {
            MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"noSelectCell"));
        }
        Collections.sort(cellList, new Comparator<ICell>(){

            @Override
            public int compare(ICell o1, ICell o2) {
                if (o1 == null || o2 == null) {
                    return -1;
                }
                int re = o2.getRowIndex() - o1.getRowIndex();
                if (re == 0) {
                    return o2.getColumnIndex() - o1.getColumnIndex();
                }
                return re;
            }
        });
        return cellList;
    }

    private Set<BgOrgUnitInfo> getBgOrgUnits() {
        return this.bgOrgInfos;
    }

    public void setBgOrgs(Set<BgOrgUnitInfo> bgOrgInfos) {
        this.bgOrgInfos = bgOrgInfos;
    }

    private List<BgPeriodInfo> getPeriods() {
        return this.periods;
    }

    public void setPeriods(List<BgPeriodInfo> periods) {
        this.periods = periods;
    }

    protected static boolean getExpandParam() {
        boolean paramValue = false;
        IRowSet rst = null;
        try {
            rst = SQLFacadeFactory.getRemoteInstance().getRowset("SELECT FVALUE FROM T_MBG_PARAM where FNUMBER = 'traceParam'");
            if (rst != null && rst.next()) {
                paramValue = Boolean.parseBoolean(rst.getString(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != rst) {
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        return paramValue;
    }

    private final class CellDisplayParser
    implements IUserCellDisplayParser {
        private CellDisplayParser() {
        }

        public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
            return BgAnalyseDrillTableHelper.this.formatCellDisplay(rowIndex, colIndex, cell, value);
        }
    }
}

