/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.common.BgAnalyseObjConstants;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgAnalyseTableHelper {
    private static final String RES_PATH = "com.kingdee.eas.ma.mbg.BudgetResource";
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseTableHelper.class);
    private static final long serialVersionUID = 479833658155427210L;
    private KDTable tblMain = null;
    private MbgViewListManager view = null;
    private Map<String, Map<String, Map<String, BgNViewDataInfo>>> dataMap = null;
    private List<String> analyseObjTexts = null;
    private boolean onlyBgDataType = false;
    private MbgViewListDimensionInfo removeScenDim = null;
    public static final String DIM = "dimension";
    public static final String MEM = "member";
    public static final String FORMULA = "formula";
    public static final String VERSION = "version";
    public static final String CURRENCY = "currency";
    public static final String ELEMENT = "element";
    public static final String ANALYSE_OBJ = "ANALYSE";
    private static final String ANALYSE_NAME = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BudgetResource", (String)"lessThanOne");
    private Map<String, Integer> scenMap = null;

    private Map<String, Integer> getScenMap() {
        return this.scenMap;
    }

    public void setScenMap(Map<String, Integer> scenMap) {
        this.scenMap = scenMap;
    }

    private MbgViewListDimensionInfo getRemoveScenDim() {
        return this.removeScenDim;
    }

    private void setRemoveScenDim(MbgViewListDimensionInfo removeScenDim) {
        this.removeScenDim = removeScenDim;
    }

    private boolean isOnlyBgDataType() {
        return this.onlyBgDataType;
    }

    public BgAnalyseTableHelper(KDTable table, MbgViewListManager view, Map<String, Map<String, Map<String, BgNViewDataInfo>>> dataMap, List<String> analyseObjTexts, boolean onlyBgDataType) {
        this.tblMain = table;
        this.view = this.clone(view);
        this.dataMap = dataMap;
        this.analyseObjTexts = analyseObjTexts;
        this.onlyBgDataType = onlyBgDataType;
    }

    private MbgViewListManager clone(MbgViewListManager view2) {
        MbgViewListManager _view = view2.clone();
        MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)_view.getSheetManagers().get(0)).getDimensionManager();
        dimensionManager.clone();
        List<IMbgViewListObject> rowCols = dimensionManager.getRowCols();
        for (int i = 0; i < rowCols.size(); ++i) {
            MbgViewListRowCol rowCol = (MbgViewListRowCol)rowCols.get(i);
            List<MbgViewListDimensionInfo> dimensions = rowCol.getDimensions();
            rowCol.setDimensions((List)((ArrayList)dimensions).clone());
        }
        return _view;
    }

    private void dealDims(int scenInColIndex, List<MbgViewListDimensionInfo> rowColDimensions) {
        rowColDimensions.add(scenInColIndex + 1, this.getAnalyseDim(rowColDimensions.get(scenInColIndex)));
        if (this.isOnlyBgDataType()) {
            this.setRemoveScenDim(rowColDimensions.remove(scenInColIndex));
        }
    }

    private MbgViewListSheetManager getSheet() {
        return (MbgViewListSheetManager)this.view.getSheetManagers().get(0);
    }

    private int getHeadRows() {
        return this.getColDimensions().size();
    }

    public int getHeadCols() {
        return this.getRowDimensions().size();
    }

    private List<IMbgViewListObject> getRows() {
        return this.getSheet().getDimensionManager().getRows();
    }

    private List<IMbgViewListObject> getCols() {
        return this.getSheet().getDimensionManager().getColumns();
    }

    private List<MbgViewListDimensionInfo> getRowDimensions() {
        return this.getSheet().getDimensionManager().getRowDimension();
    }

    private List<MbgViewListDimensionInfo> getColDimensions() {
        return this.getSheet().getDimensionManager().getColDimension();
    }

    private int getScenInColIndex(List colDimension) {
        for (int i = 0; i < colDimension.size(); ++i) {
            MbgViewListDimensionInfo dim = (MbgViewListDimensionInfo)colDimension.get(i);
            if (!DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dim.getNumber())) continue;
            return i;
        }
        return -1;
    }

    private boolean isContainsScen(List<MbgViewListDimensionInfo> dims) {
        for (int i = 0; i < dims.size(); ++i) {
            MbgViewListDimensionInfo mbgViewListDimensionInfo = dims.get(i);
            if (!DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(mbgViewListDimensionInfo.getNumber())) continue;
            return true;
        }
        return false;
    }

    private MbgViewListDimensionInfo getAnalyseDim(MbgViewListDimensionInfo scentDimensionInfo) {
        MbgViewListDimensionInfo analyseDim = this.createAnalyseDimension(ANALYSE_NAME, ANALYSE_OBJ);
        for (int i = 0; i < this.analyseObjTexts.size(); ++i) {
            String analyseName = this.analyseObjTexts.get(i);
            String analyseScenNumber = null;
            BgDimensionMember member = null;
            if (this.isOnlyBgDataType() && BgAnalyseObjConstants.r15.equals(analyseName)) {
                List selectMembers = scentDimensionInfo.getSelectMembers();
                for (int j = 0; j < selectMembers.size(); ++j) {
                    BgDimensionMember bgDimensionMember = (BgDimensionMember)selectMembers.get(j);
                    Integer scenType = this.getScenMap().get(bgDimensionMember.getNumber());
                    analyseScenNumber = scenType == 0 ? BgAnalyseObjConstants.BA01 : BgAnalyseObjConstants.BA02;
                    member = new BgDimensionMember(ANALYSE_OBJ, ANALYSE_OBJ, bgDimensionMember.getName(), analyseScenNumber);
                    analyseDim.getSelectMembers().add(member);
                }
                continue;
            }
            analyseScenNumber = BgAnalyseObjConstants.getAnalyseScen(analyseName);
            member = new BgDimensionMember(ANALYSE_OBJ, ANALYSE_OBJ, analyseName, analyseScenNumber);
            analyseDim.getSelectMembers().add(member);
        }
        return analyseDim;
    }

    private MbgViewListDimensionInfo createAnalyseDimension(String name, String number) {
        MbgViewListDimensionInfo dim = new MbgViewListDimensionInfo(null);
        dim.setName(name);
        dim.setNumber(number);
        return dim;
    }

    public void buildTable() throws Exception {
        if (this.tblMain == null || this.view == null || this.dataMap == null || this.dataMap.isEmpty() || this.analyseObjTexts == null || this.analyseObjTexts == null) {
            return;
        }
        boolean isHasData = false;
        for (Map.Entry<String, Map<String, Map<String, BgNViewDataInfo>>> entry : this.dataMap.entrySet()) {
            Map<String, Map<String, BgNViewDataInfo>> value = entry.getValue();
            if (value == null || value.isEmpty()) continue;
            for (Map.Entry<String, Map<String, BgNViewDataInfo>> entry1 : value.entrySet()) {
                Map<String, BgNViewDataInfo> value1 = entry1.getValue();
                if (value1 == null || value1.isEmpty()) continue;
                isHasData = true;
            }
        }
        if (!isHasData) {
            this.clearTable();
            return;
        }
        long start = System.currentTimeMillis();
        this.dealViewManager();
        this.clearTable();
        long start1 = System.currentTimeMillis();
        this.dealRows();
        this.dealCols();
        logger.info((Object)("dealRowCols() cost time:" + (System.currentTimeMillis() - start1)));
        if (!this.isOnlyBgDataType()) {
            this.deleteRowsAndCols();
        }
        this.fillFormulas();
        this.fillData();
        logger.info((Object)("buildTable() cost time:" + (System.currentTimeMillis() - start)));
    }

    private void dealViewManager() {
        long start = System.currentTimeMillis();
        List colDimension = this.getSheet().getDimensionManager().getColDimension();
        int scenInColIndex = this.getScenInColIndex(colDimension);
        if (scenInColIndex != -1) {
            List<MbgViewListDimensionInfo> colDimensions = this.getColDimensions();
            this.dealDims(scenInColIndex, colDimensions);
            List<IMbgViewListObject> cols = this.getCols();
            for (int i = 0; i < cols.size(); ++i) {
                MbgViewListRowCol col = (MbgViewListRowCol)cols.get(i);
                List<MbgViewListDimensionInfo> dimensions = col.getDimensions();
                scenInColIndex = this.getScenInColIndex(dimensions);
                this.dealDims(scenInColIndex, dimensions);
            }
        } else {
            List<MbgViewListDimensionInfo> rowDimensions = this.getRowDimensions();
            this.dealDims(scenInColIndex, rowDimensions);
            List<IMbgViewListObject> rows = this.getRows();
            for (int i = 0; i < rows.size(); ++i) {
                MbgViewListRowCol row = (MbgViewListRowCol)rows.get(i);
                List<MbgViewListDimensionInfo> dimensions = row.getDimensions();
                scenInColIndex = this.getScenInColIndex(dimensions);
                this.dealDims(scenInColIndex, dimensions);
            }
        }
        logger.info((Object)("dealViewManager()() cost time:" + (System.currentTimeMillis() - start)));
    }

    private void deleteRowsAndCols() {
        block8: {
            block7: {
                List colDimension = this.getSheet().getDimensionManager().getColDimension();
                int scenInColIndex = this.getScenInColIndex(colDimension);
                if (scenInColIndex == -1) break block7;
                int columnsCount = this.tblMain.getColumnCount();
                int headRowCount = this.tblMain.getHeadRowCount();
                ArrayList<Integer> deleteCols = new ArrayList<Integer>();
                for (int j = this.getHeadCols(); j < columnsCount; ++j) {
                    for (int i = 0; i < headRowCount - 1; ++i) {
                        Object userObject1 = this.tblMain.getHeadRow(i).getCell(j).getUserObject();
                        Object userObject2 = this.tblMain.getHeadRow(i + 1).getCell(j).getUserObject();
                        this.dealDeleteMem(deleteCols, j, userObject1, userObject2);
                    }
                }
                if (deleteCols.isEmpty()) break block8;
                IColumn removeColumn = null;
                int count = 0;
                for (int i = 0; i < deleteCols.size(); ++i) {
                    removeColumn = this.tblMain.removeColumn((Integer)deleteCols.get(i) - count);
                    if (removeColumn == null) continue;
                    ++count;
                }
                break block8;
            }
            ArrayList<Integer> deleteRows = new ArrayList<Integer>();
            int headCols = this.getHeadCols();
            for (int j = 0; j < this.tblMain.getRowCount3(); ++j) {
                for (int i = 0; i < headCols; ++i) {
                    Object userObject1 = this.tblMain.getRow(j).getCell(i).getUserObject();
                    Object userObject2 = this.tblMain.getRow(j + 1).getCell(i).getUserObject();
                    this.dealDeleteMem(deleteRows, j, userObject1, userObject2);
                }
            }
            if (!deleteRows.isEmpty()) {
                IRow removeRow = null;
                int count = 0;
                for (int i = 0; i < deleteRows.size(); ++i) {
                    removeRow = this.tblMain.removeRow((Integer)deleteRows.get(i) - count);
                    if (removeRow == null) continue;
                    ++count;
                }
            }
        }
    }

    private void dealDeleteMem(List<Integer> deleteCols, int index, Object userObject1, Object userObject2) {
        if (userObject1 instanceof Map && userObject2 instanceof Map) {
            Map userMap1 = (Map)userObject1;
            BgDimensionMember mem1 = (BgDimensionMember)userMap1.get(MEM);
            MbgViewListDimensionInfo dim1 = (MbgViewListDimensionInfo)userMap1.get(DIM);
            Map userMap2 = (Map)userObject2;
            BgDimensionMember mem2 = (BgDimensionMember)userMap2.get(MEM);
            MbgViewListDimensionInfo dim2 = (MbgViewListDimensionInfo)userMap2.get(DIM);
            if (DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dim1.getNumber()) && ANALYSE_OBJ.equals(dim2.getNumber())) {
                int scenType;
                if (BgAnalyseObjConstants.r15.equals(mem2.getName())) {
                    return;
                }
                int scenTypeValue = this.getScenMap().get(mem1.getNumber());
                if (scenTypeValue != (scenType = BgAnalyseObjConstants.getScenType(mem2.getName()))) {
                    deleteCols.add(index);
                }
            }
        }
    }

    private void fillData() {
        long start = System.currentTimeMillis();
        int headCols = this.getHeadCols();
        int rowCount3 = this.tblMain.getRowCount3();
        int columnCount = this.tblMain.getColumnCount();
        String analyseObjOfCell = null;
        for (int r = 0; r < rowCount3; ++r) {
            for (int c = headCols; c < columnCount; ++c) {
                BgNViewDataInfo dataValue;
                Map<String, BgNViewDataInfo> map2;
                Map<String, Map<String, BgNViewDataInfo>> map;
                ICell cell = this.tblMain.getCell(r, c);
                String formula = BgAnalyseTableHelper.getFormula(cell);
                String version = BgAnalyseTableHelper.getVersion(cell);
                String analyseObj = this.getAnalyseObj(cell);
                BgDimensionMember orgMember = BgAnalyseTableHelper.getMem(cell);
                String orgId = orgMember.getAttribute();
                if (BgAnalyseObjConstants.isContainsEF(analyseObj)) {
                    analyseObj = BgAnalyseObjConstants.EF;
                }
                if (!((map = this.dataMap.get(analyseObj)) instanceof Map) || !((map2 = map.get(orgId)) instanceof Map)) continue;
                if (BgAnalyseObjConstants.isContainsEF(analyseObj)) {
                    String[] params = BgNFSHelper.parseFormulaPara(formula);
                    params[3] = BgAnalyseObjConstants.EF;
                    formula = BgNFSHelper.getFormulaFromParam(params);
                }
                if ((dataValue = map2.get(formula + "_" + version)) == null) continue;
                if (BgAnalyseObjConstants.BA01.equals(analyseObj)) {
                    cell.setValue((Object)dataValue.getBudgetValueNoDef());
                    continue;
                }
                if (BgAnalyseObjConstants.BA02.equals(analyseObj)) {
                    cell.setValue((Object)dataValue.getBizActualNoDef());
                    continue;
                }
                if (BgAnalyseObjConstants.EF.equals(analyseObj)) {
                    analyseObjOfCell = this.getAnalyseObj(cell);
                    if (BgAnalyseObjConstants.EP.equals(analyseObjOfCell)) {
                        cell.setValue((Object)dataValue.getExeProcess());
                        continue;
                    }
                    if (BgAnalyseObjConstants.EF.equals(analyseObjOfCell)) {
                        cell.setValue((Object)dataValue.getExeDiff());
                        continue;
                    }
                    if (!BgAnalyseObjConstants.EFR.equals(analyseObjOfCell)) continue;
                    cell.setValue((Object)dataValue.getExeDiffRate());
                    continue;
                }
                if (!BgAnalyseObjConstants.EB.equals(analyseObj)) continue;
                cell.setValue((Object)dataValue.getBudgetValueNoDef());
            }
        }
        logger.info((Object)("fillData() cost time:" + (System.currentTimeMillis() - start)));
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (value instanceof BigDecimal) {
            // empty if block
        }
        return value;
    }

    private void fillFormulas() {
        long start = System.currentTimeMillis();
        if (this.tblMain == null) {
            return;
        }
        int headRows = this.getHeadRows();
        int headCols = this.getHeadCols();
        int rowCount3 = this.tblMain.getRowCount3();
        int columnCount = this.tblMain.getColumnCount();
        List<BgDimensionMember> rowMembers = null;
        List<BgDimensionMember> colMembers = null;
        ArrayList<BgDimensionMember> allMembers = null;
        for (int r = 0; r < rowCount3; ++r) {
            for (int c = headCols; c < columnCount; ++c) {
                allMembers = new ArrayList<BgDimensionMember>();
                ICell cell = this.tblMain.getCell(r, c);
                rowMembers = this.getMembersByCurRow(r, headCols);
                colMembers = this.getMembersByCurCol(c, headRows);
                allMembers.addAll(rowMembers);
                allMembers.addAll(colMembers);
                this.buildFormula(allMembers, cell);
            }
        }
        logger.info((Object)("fillFormulas() cost time:" + (System.currentTimeMillis() - start)));
    }

    private List<BgDimensionMember> getMembersByCurCol(int c, int headRows) {
        ArrayList<BgDimensionMember> mems = null;
        for (int r = 0; r < headRows; ++r) {
            if (mems == null) {
                mems = new ArrayList<BgDimensionMember>();
            }
            ICell cell = this.tblMain.getHeadRow(r).getCell(c);
            mems.add(BgAnalyseTableHelper.getMem(cell));
        }
        return mems;
    }

    private List<BgDimensionMember> getMembersByCurRow(int r, int headCols) {
        ArrayList<BgDimensionMember> mems = null;
        for (int c = 0; c < headCols; ++c) {
            if (mems == null) {
                mems = new ArrayList<BgDimensionMember>();
            }
            ICell cell = this.tblMain.getCell(r, c);
            mems.add(BgAnalyseTableHelper.getMem(cell));
        }
        return mems;
    }

    private void buildFormula(List<BgDimensionMember> members, ICell cell) {
        if (members == null || members.isEmpty() || cell == null) {
            return;
        }
        HashMap<Integer, String> _item = new HashMap<Integer, String>();
        String _element = null;
        String _period = null;
        String _currency = null;
        String _version = null;
        String _scenario = null;
        String _analyseNumber = null;
        BgDimensionMember _org = null;
        BgDimensionMember member = null;
        Integer scenType = -1;
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            member = members.get(i);
            if (member.getType() == null || member.getNumber() == null) continue;
            if (ANALYSE_OBJ.equals(member.getType())) {
                _analyseNumber = member.getNumber();
                if (this.isOnlyBgDataType() || !BgAnalyseObjConstants.isCurrPeriodDataByNumber(_analyseNumber)) continue;
                _analyseNumber = scenType == 0 ? BgAnalyseObjConstants.BA01 : BgAnalyseObjConstants.BA02;
                continue;
            }
            if (MBGLayoutConstants.BG_PERIOD.equalsIgnoreCase(member.getType())) {
                if ("BGPERIOD".equals(member.getNumber())) {
                    _period = "";
                    continue;
                }
                _period = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_ELEMENT.equalsIgnoreCase(member.getType())) {
                _element = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(member.getType())) {
                _currency = member.getNumber();
                continue;
            }
            if (MBGLayoutConstants.BG_ORGANIZATION.equalsIgnoreCase(member.getType())) {
                _org = member;
                continue;
            }
            if (MBGLayoutConstants.BG_SCENARIO.equalsIgnoreCase(member.getType())) {
                _scenario = member.getNumber();
                scenType = this.getScenMap().get(_scenario);
                continue;
            }
            if (MBGLayoutConstants.BG_VERSION.equalsIgnoreCase(member.getType())) {
                _version = member.getNumber();
                continue;
            }
            if (member.getNumber() == null || member.getAttribute() == null) continue;
            _item.put(DimensionCommonHelper.getField(member.getAttribute().toUpperCase()), member.getSrcNumber() + ":" + member.getNumber());
        }
        if (_item.isEmpty() || _period == null || _element == null || _currency == null || _version == null || _analyseNumber == null) {
            return;
        }
        if (_scenario == null && this.isOnlyBgDataType()) {
            scenType = BgAnalyseObjConstants.getScenTypeByNumber(_analyseNumber);
            if (scenType != 2) {
                List selectMembers;
                MbgViewListDimensionInfo removeScenDimen = this.getRemoveScenDim();
                if (removeScenDimen != null && (selectMembers = removeScenDimen.getSelectMembers()) != null && !selectMembers.isEmpty()) {
                    for (int i = 0; i < selectMembers.size(); ++i) {
                        BgDimensionMember mem = (BgDimensionMember)selectMembers.get(i);
                        Integer memScenType = this.getScenMap().get(mem.getNumber());
                        if (scenType != memScenType) continue;
                        _scenario = mem.getNumber();
                    }
                }
            } else {
                _scenario = _analyseNumber;
            }
        }
        String _bgFormula = BgViewHelper.parseItemFormula(_element, _currency, _period, _scenario, _item);
        HashMap<String, Object> userMap = new HashMap<String, Object>(4);
        userMap.put(FORMULA, _bgFormula);
        userMap.put(MEM, _org);
        userMap.put(ANALYSE_OBJ, _analyseNumber);
        userMap.put(VERSION, _version);
        userMap.put(CURRENCY, _currency);
        userMap.put(ELEMENT, _element);
        cell.setUserObject(userMap);
    }

    public static BgDimensionMember getMem(ICell cell) {
        BgDimensionMember mem = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            mem = (BgDimensionMember)userMap.get(MEM);
        }
        return mem;
    }

    public static String getFormula(ICell cell) {
        String formula = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            formula = (String)userMap.get(FORMULA);
        }
        return formula;
    }

    public static String getVersion(ICell cell) {
        String version = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            version = (String)userMap.get(VERSION);
        }
        return version;
    }

    private String getAnalyseObj(ICell cell) {
        String analyseObj = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            analyseObj = (String)userMap.get(ANALYSE_OBJ);
        }
        return analyseObj;
    }

    private MbgViewListDimensionInfo getDim(ICell cell) {
        MbgViewListDimensionInfo dim = null;
        Object userObject = cell.getUserObject();
        if (userObject instanceof Map) {
            Map userMap = (Map)userObject;
            dim = (MbgViewListDimensionInfo)userMap.get(DIM);
        }
        return dim;
    }

    private void clearTable() {
        this.tblMain.removeRows();
        this.tblMain.removeHeadRows();
        this.tblMain.removeColumns();
    }

    private void dealCols() throws Exception {
        int headCols = this.getHeadCols();
        List<IMbgViewListObject> cols = this.getCols();
        this.initIndex(cols, headCols);
        this.initCols(cols);
        this.mergeAndSetCols(cols);
    }

    private void mergeAndSetCols(List<IMbgViewListObject> cols) {
        for (int i = 0; i < cols.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)cols.get(i);
            this.dealRowCol(rowColObj, true);
        }
    }

    private void initCols(List<IMbgViewListObject> cols) {
        int count = 0;
        for (int i = 0; i < cols.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)cols.get(i);
            rowColObj.setIndex(i);
            List<MbgViewListDimensionInfo> dimensions = rowColObj.getDimensions();
            int addColCount = 1;
            for (int j = 0; j < dimensions.size(); ++j) {
                MbgViewListDimensionInfo mbgViewListDimensionInfo = dimensions.get(j);
                int size = mbgViewListDimensionInfo.getSelectMembers().size();
                addColCount *= size;
            }
            count += addColCount;
        }
        for (int j = 0; j < count; ++j) {
            this.tblMain.addColumn();
        }
    }

    private void dealCell(int rowIndex, int colIndex, int bottom, int right, MbgViewListDimensionInfo bgDimensionInfo, BgDimensionMember bgDimensionMember) {
        HashMap<String, Cloneable> userMap = new HashMap<String, Cloneable>(2);
        userMap.put(DIM, bgDimensionInfo);
        userMap.put(MEM, bgDimensionMember);
        for (int i = rowIndex; i <= bottom; ++i) {
            for (int j = colIndex; j <= right; ++j) {
                ICell cell = this.tblMain.getCell(i, j);
                cell.setValue((Object)bgDimensionMember.getName());
                cell.setUserObject(userMap);
            }
        }
    }

    private void dealHeadCell(int rowIndex, int colIndex, int bottom, int right, MbgViewListDimensionInfo bgDimensionInfo, BgDimensionMember bgDimensionMember) {
        HashMap<String, Cloneable> userMap = new HashMap<String, Cloneable>(2);
        userMap.put(DIM, bgDimensionInfo);
        userMap.put(MEM, bgDimensionMember);
        for (int i = rowIndex; i <= bottom; ++i) {
            for (int j = colIndex; j <= right; ++j) {
                ICell headCell = this.getHeadCell(i, j);
                headCell.setValue((Object)bgDimensionMember.getName());
                headCell.setUserObject(userMap);
            }
        }
    }

    private ICell getHeadCell(int rowIndex, int colIndex) {
        return this.tblMain.getHeadRow(rowIndex).getCell(colIndex);
    }

    private void dealRows() throws Exception {
        int headRows = this.getHeadRows();
        for (int i = 0; i < headRows; ++i) {
            this.tblMain.addHeadRow();
        }
        List<IMbgViewListObject> rows = this.getRows();
        List<MbgViewListDimensionInfo> rowDimensions = this.getRowDimensions();
        int colIndex = -1;
        for (int k = 0; k < rowDimensions.size(); ++k) {
            MbgViewListDimensionInfo bgDimensionInfo = rowDimensions.get(k);
            this.tblMain.addColumn();
            this.tblMain.getHeadRow(0).getCell(++colIndex).setValue((Object)bgDimensionInfo.getName());
            this.tblMain.getHeadRow(0).getCell(colIndex).setUserObject((Object)bgDimensionInfo);
            this.tblMain.getHeadMergeManager().mergeBlock(0, colIndex, headRows - 1, colIndex);
        }
        this.initIndex(rows, 0);
        this.initRows(rows);
        this.mergeAndSetRow(rows);
    }

    private void mergeAndSetRow(List<IMbgViewListObject> rows) {
        for (int i = 0; i < rows.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)rows.get(i);
            this.dealRowCol(rowColObj, false);
        }
    }

    private void initRows(List<IMbgViewListObject> rows) {
        int count = 0;
        for (int i = 0; i < rows.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)rows.get(i);
            rowColObj.setIndex(i);
            List<MbgViewListDimensionInfo> dimensions = rowColObj.getDimensions();
            int addRowCount = 1;
            for (int j = 0; j < dimensions.size(); ++j) {
                MbgViewListDimensionInfo mbgViewListDimensionInfo = dimensions.get(j);
                int size = mbgViewListDimensionInfo.getSelectMembers().size();
                addRowCount *= size;
            }
            count += addRowCount;
        }
        for (int j = 0; j < count; ++j) {
            this.tblMain.addRow();
        }
    }

    private void dealRowCol(MbgViewListRowCol rowColObj, boolean isHead) {
        List<MbgViewListDimensionInfo> dimensions = rowColObj.getDimensions();
        for (int i = 0; i < dimensions.size(); ++i) {
            MbgViewListDimensionInfo mbgViewListDimensionInfo = dimensions.get(i);
            List selectMembers = mbgViewListDimensionInfo.getSelectMembers();
            int count = this.getBeforeDimMemsCount(dimensions, i);
            int startIndex = rowColObj.getStartIndex();
            for (int k = 0; k < count; ++k) {
                for (int j = 0; j < selectMembers.size(); ++j) {
                    startIndex = this.mergeSameDimMember(i, j, dimensions, startIndex, isHead);
                }
            }
        }
    }

    private int getBeforeDimMemsCount(List<MbgViewListDimensionInfo> dimensions, int i) {
        int count = 1;
        for (int j = i - 1; j >= 0; --j) {
            int size = dimensions.get(j).getSelectMembers().size();
            count *= size;
        }
        return count;
    }

    private int mergeSameDimMember(int dimIndex, int memIndex, List<MbgViewListDimensionInfo> dimensions, int startIndex, boolean isHead) {
        int otherMemsCount = this.getOtherDimMemCount(dimIndex, dimensions);
        int left = -1;
        int right = -1;
        int top = -1;
        int bottom = -1;
        if (isHead) {
            top = dimIndex;
            bottom = dimIndex;
            left = startIndex;
            right = left + otherMemsCount - 1;
        } else {
            left = dimIndex;
            right = dimIndex;
            top = startIndex;
            bottom = top + otherMemsCount - 1;
        }
        MbgViewListDimensionInfo mbgViewListDimensionInfo = dimensions.get(dimIndex);
        BgDimensionMember member = (BgDimensionMember)mbgViewListDimensionInfo.getSelectMembers().get(memIndex);
        KDTMergeManager mergeManager = this.dealCell(isHead, top, left, bottom, right, mbgViewListDimensionInfo, member);
        mergeManager.mergeBlock(top, left, bottom, right);
        startIndex = isHead ? right + 1 : bottom + 1;
        return startIndex;
    }

    private KDTMergeManager dealCell(boolean isHead, int rowIndex, int colIndex, int bottom, int right, MbgViewListDimensionInfo mbgViewListDimensionInfo, BgDimensionMember member) {
        KDTMergeManager mergeManager;
        if (isHead) {
            mergeManager = this.tblMain.getHeadMergeManager();
            this.dealHeadCell(rowIndex, colIndex, bottom, right, mbgViewListDimensionInfo, member);
        } else {
            mergeManager = this.tblMain.getMergeManager();
            this.dealCell(rowIndex, colIndex, bottom, right, mbgViewListDimensionInfo, member);
        }
        return mergeManager;
    }

    private int getOtherDimMemCount(int dimIndex, List<MbgViewListDimensionInfo> dimensions) {
        int sum = 1;
        for (int i = dimIndex + 1; i < dimensions.size(); ++i) {
            MbgViewListDimensionInfo mbgViewListDimensionInfo2 = dimensions.get(i);
            int membersCount = mbgViewListDimensionInfo2.getSelectMembers().size();
            sum *= membersCount;
        }
        return sum;
    }

    private void initIndex(List<IMbgViewListObject> rows, int start) {
        for (int i = 0; i < rows.size(); ++i) {
            MbgViewListRowCol rowColObj = (MbgViewListRowCol)rows.get(i);
            rowColObj.setIndex(i);
            List<MbgViewListDimensionInfo> dimensions = rowColObj.getDimensions();
            int selectMemCount = 1;
            for (int j = 0; j < dimensions.size(); ++j) {
                MbgViewListDimensionInfo dimensionInfo = dimensions.get(j);
                List selectMembers = dimensionInfo.getSelectMembers();
                selectMemCount *= selectMembers.size();
            }
            if (i == 0) {
                rowColObj.setStartIndex(0 + start);
                rowColObj.setEndIndex(selectMemCount - 1 + start);
                continue;
            }
            rowColObj.setStartIndex(((MbgViewListRowCol)rows.get(i - 1)).getEndIndex() + 1 + start);
            rowColObj.setEndIndex(rowColObj.getStartIndex() + selectMemCount - 1 + start);
        }
    }

    private void addDimensionAfterScen(List<MbgViewListDimensionInfo> dimensions, MbgViewListDimensionInfo dimInfo) {
        for (int j = 0; j < dimensions.size(); ++j) {
            MbgViewListDimensionInfo dimensionInfo = dimensions.get(j);
            if (!DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dimensionInfo.getNumber())) continue;
            dimensions.add(j + 1, dimInfo);
        }
    }

    public static void dealDimAndIndexMember(AnalyseMember members, String dimNumber, String bgScehemeId) throws Exception {
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(bgScehemeId);
        String index = dimNumber.split(",")[0].split(":")[1];
        String indexSrc = dimNumber.split(",")[0].split(":")[0];
        BgDimensionInfo dimInfo = schemeHelper.getDimension(DimensionBaseConstants.DEF_ACCOUNT_NUMBER);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)dimInfo.getViewId(), CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)index, CompareType.EQUALS));
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("longNumber");
        view.getSelector().add("isLeaf");
        view.getSelector().add("level");
        BgAccountCollection col = BgAccountFactory.getRemoteInstance().getBgAccountCollection(view);
        BgDimensionMember indexMember = new BgDimensionMember(dimInfo.getType(), dimInfo.getAttribute(), col.get(0).getName(), index);
        indexMember.setLeaf(col.get(0).isIsLeaf());
        indexMember.setLevel(col.get(0).getLevel());
        indexMember.setSortValue((Comparable)((Object)col.get(0).getLongNumber()));
        indexMember.setSrcNumber(indexSrc);
        members.setBgIndex(indexMember);
        List<String> dimNumbers = schemeHelper.getAccAndOtherDim(true);
        BgDimensionInfo dimension = null;
        HashSet<String> viewidSet = new HashSet<String>();
        HashMap<String, String> viewMap = new HashMap<String, String>();
        ArrayList<BgDimensionInfo> dimensions = new ArrayList<BgDimensionInfo>();
        for (int i = 0; i < dimNumbers.size(); ++i) {
            dimension = schemeHelper.getDimension(dimNumbers.get(i));
            if (dimension == null) continue;
            dimensions.add(dimension);
            viewidSet.add(dimension.getViewId());
            viewMap.put(dimension.getViewId(), dimension.getAttribute() + ":" + dimension.getType());
        }
        String[] dims = dimNumber.split(",");
        HashMap<String, String> dimMap = new HashMap<String, String>();
        HashSet<String> numSet = new HashSet<String>();
        for (int i = 1; i < dims.length; ++i) {
            dimMap.put(dims[i].split(":")[0], dims[i].split(":")[1]);
            numSet.add(dims[i].split(":")[1]);
        }
        view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("viewId", viewidSet, CompareType.INCLUDE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("number", numSet, CompareType.INCLUDE));
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("mbgDim.srcNumber");
        view.getSelector().add("viewId");
        MbgMemberCollection colls = MbgMemberFactory.getRemoteInstance().getMbgMemberCollection(view);
        ArrayList<BgDimensionMember> dimMembers = new ArrayList<BgDimensionMember>();
        BgDimensionMember dimMember = null;
        BgDimensionMember combinMember = null;
        for (int i = 0; i < colls.size(); ++i) {
            MbgMemberInfo info = colls.get(i);
            if (!viewMap.containsKey(info.getViewId().toString()) || !dimMap.containsKey(info.getMbgDim().getSrcNumber()) || !info.getNumber().equals(dimMap.get(info.getMbgDim().getSrcNumber()))) continue;
            dimMember = new BgDimensionMember(((String)viewMap.get(info.getViewId().toString())).split(":")[1], ((String)viewMap.get(info.getViewId().toString())).split(":")[0], info.getName(), info.getNumber());
            dimMember.setSrcNumber(info.getMbgDim().getSrcNumber());
            dimMembers.add(dimMember);
        }
        Collections.sort(dimMembers, new Comparator<BgDimensionMember>(){

            @Override
            public int compare(BgDimensionMember o1, BgDimensionMember o2) {
                String str1 = o1.getAttribute().substring(1);
                String str2 = o2.getAttribute().substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        String combinAttribute = null;
        String combinName = null;
        String combinNumber = null;
        String combinSrc = null;
        String combinType = null;
        if (dimMembers.size() > 0) {
            for (int i = 0; i < dimMembers.size(); ++i) {
                combinAttribute = combinAttribute + "," + ((BgDimensionMember)dimMembers.get(i)).getAttribute();
                combinName = combinName + "," + ((BgDimensionMember)dimMembers.get(i)).getName();
                combinNumber = combinNumber + "," + ((BgDimensionMember)dimMembers.get(i)).getNumber();
                combinSrc = combinSrc + "," + ((BgDimensionMember)dimMembers.get(i)).getSrcNumber();
                combinType = combinType + "," + ((BgDimensionMember)dimMembers.get(i)).getType();
            }
            if (combinType != null && combinAttribute != null && combinName != null && combinNumber != null) {
                combinMember = new BgDimensionMember(combinType.substring(5), combinAttribute.substring(5), combinName.substring(5), combinNumber.substring(5));
                combinMember.setSrcNumber(combinSrc.substring(5));
                members.setDimMember(combinMember);
            }
        }
    }

    private final class CellDisplayParser
    implements IUserCellDisplayParser {
        private CellDisplayParser() {
        }

        public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
            return BgAnalyseTableHelper.this.formatCellDisplay(rowIndex, colIndex, cell, value);
        }
    }
}

