/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgExamineCollection;
import com.kingdee.eas.ma.mbg.BgExamineFactory;
import com.kingdee.eas.ma.mbg.BgExamineGroupInfo;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineNoPassEnum;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgExamineRefBgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgExamineStateEnum;
import com.kingdee.eas.ma.mbg.BgExamineSubsetInfo;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgScopeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.BgExamineHelper;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class BgExamineExportHelper {
    public static final String ENCODING = "UTF-8";
    private static final String DOCUMENT_BGEXAMINE = "BgExamine";
    private static final String DOCUMENT_NUMBER = "number";
    private static final String DOCUMENT_NAME = "name";
    private static final String DOCUMENT_HINT = "hint";
    private static final String DOCUMENT_ERRORDATA = "errorData";
    private static final String DOCUMENT_NOPASS = "noPass";
    private static final String DOCUMENT_DESCRIPTION = "description";
    private static final String DOCUMENT_SEQ = "seq";
    private static final String DOCUMENT_FORMULA = "formula";
    private static final String DOCUMENT_SCOPE = "bgScope";
    private static final String DOCUMENT_BGMEMBERALIAS = "bgMemberAlias";
    private static final String DOCUMENT_BGMEMBERNUM = "bgMemberNum";
    private static final String DOCUMENT_BGMEMBERTYPE = "bgMemberType";
    private static final String DOCUMENT_BIZDATATYPE = "bizDataType";
    private static final String DOCUMENT_FILLTYPE = "fillType";
    private static final String DOCUMENT_MBGDIMNUM = "mbgDimNum";
    private static final String DOCUMENT_REFFIELD = "refField";
    private static final String DOCUMENT_BGEXAMINEREFBGTEMPLATE = "bgExamineRefBgTemplate";
    private static final String DOCUMENT_SRCS = "SRCS";
    private static final String DOCUMENT_BGEXAMINESUBSET = "bgExamineSubset";
    private static final String DOCUMENT_BGEXAMINEGROUP = "bgExamineGroup";

    public static Map<String, MbgDimInfo> getFieldDimMap() throws Exception {
        HashMap<String, MbgDimInfo> fieldDimMap = new HashMap<String, MbgDimInfo>();
        MbgDimCollection mbgColls = DimUtils.getDimensionColls();
        if (mbgColls != null) {
            MbgDimInfo mbgDim = null;
            int in = mbgColls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = mbgColls.get(i);
                fieldDimMap.put(mbgDim.getRefField(), mbgDim);
            }
        }
        return fieldDimMap;
    }

    public static Map<String, MbgDimInfo> getMbgDimMap() throws Exception {
        HashMap<String, MbgDimInfo> mbgDimMap = new HashMap<String, MbgDimInfo>();
        MbgDimCollection mbgColls = DimUtils.getDimensionColls();
        if (mbgColls != null) {
            MbgDimInfo mbgDim = null;
            int in = mbgColls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = mbgColls.get(i);
                mbgDimMap.put(mbgDim.getNumber(), mbgDim);
            }
        }
        return mbgDimMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportBgExamine(List<String> selectIds, File file) throws Exception {
        Map<String, MbgDimInfo> fieldDimMap = BgExamineExportHelper.getFieldDimMap();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add(DOCUMENT_NUMBER);
        sic.add(DOCUMENT_NAME);
        sic.add(DOCUMENT_FORMULA);
        sic.add(DOCUMENT_HINT);
        sic.add(DOCUMENT_ERRORDATA);
        sic.add(DOCUMENT_NOPASS);
        sic.add(DOCUMENT_DESCRIPTION);
        sic.add("bgExamineSubset.*");
        sic.add("bgExamineSubset.bgScope.*");
        sic.add("srcNumbers");
        sic.add("bgExamineGroup.id");
        sic.add("bgExamineGroup.number");
        sic.add("bgExamineGroup.name");
        evi.setSelector(sic);
        evi.setSorter(new SorterItemCollection());
        evi.getSorter().add(new SorterItemInfo(DOCUMENT_NUMBER));
        evi.getSorter().add(new SorterItemInfo("bgExamineSubset.seq"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(selectIds), CompareType.INCLUDE));
        BgExamineCollection bgExamines = BgExamineFactory.getRemoteInstance().getBgExamineCollection(evi);
        evi.getSelector().clear();
        evi.getSelector().add("bgExamine.id");
        evi.getSelector().add("bgTemplate.id");
        evi.getSelector().add("bgTemplate.number");
        evi.getSelector().add("bgTemplate.name");
        evi.getSorter().clear();
        evi.getSorter().add(new SorterItemInfo("bgExamine.id"));
        evi.getSorter().add(new SorterItemInfo("bgTemplate.number"));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgExamine.id", new HashSet<String>(selectIds), CompareType.INCLUDE));
        BgExamineRefBgTemplateCollection refBgTemplate = BgExamineRefBgTemplateFactory.getRemoteInstance().getBgExamineRefBgTemplateCollection(evi);
        HashMap<String, List<BgExamineRefBgTemplateInfo>> refBgTemplateMap = new HashMap<String, List<BgExamineRefBgTemplateInfo>>();
        String id = null;
        for (int i = 0; i < refBgTemplate.size(); ++i) {
            BgExamineRefBgTemplateInfo info = refBgTemplate.get(i);
            id = info.getBgExamine().getId().toString();
            if (!refBgTemplateMap.containsKey(id)) {
                refBgTemplateMap.put(id, new ArrayList());
            }
            ((List)refBgTemplateMap.get(id)).add(info);
        }
        Document doc = DocumentHelper.createDocument();
        Element rootElement = doc.addElement(DOCUMENT_BGEXAMINE);
        rootElement.addComment(BgCommCHelper.getMessageStr((String)BgExamineHelper.BGEXAMINE_RESOURCE, (String)"bgExamineExportMsg"));
        for (int i = 0; i < bgExamines.size(); ++i) {
            BgExamineExportHelper.buildDocument(rootElement, bgExamines.get(i), refBgTemplateMap, fieldDimMap);
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(ENCODING);
        try (FileOutputStream out = new FileOutputStream(file);){
            XMLWriter writer = new XMLWriter((OutputStream)out, format);
            writer.write(doc);
            writer.close();
        }
    }

    private static void buildDocument(Element rootElement, BgExamineInfo bgExamineInfo, Map<String, List<BgExamineRefBgTemplateInfo>> refBgTemplateMap, Map<String, MbgDimInfo> fieldDimMap) {
        Element bizElement = rootElement.addElement(DOCUMENT_BGEXAMINE);
        BgViewHelper.addElementText(bizElement, DOCUMENT_NUMBER, bgExamineInfo.getNumber());
        BgViewHelper.addElementText(bizElement, DOCUMENT_NAME, bgExamineInfo.getName());
        BgViewHelper.addElementText(bizElement, DOCUMENT_NOPASS, bgExamineInfo.getNoPass().getName());
        BgViewHelper.addElementText(bizElement, DOCUMENT_DESCRIPTION, bgExamineInfo.getDescription());
        BgViewHelper.addElementText(bizElement, DOCUMENT_SRCS, bgExamineInfo.getSrcNumbers());
        BgExamineSubsetInfo bgExamineSubsetInfo = null;
        for (int index = 0; index < bgExamineInfo.getBgExamineSubset().size(); ++index) {
            bgExamineSubsetInfo = bgExamineInfo.getBgExamineSubset().get(index);
            BgExamineExportHelper.buildDocument(bizElement, bgExamineSubsetInfo, fieldDimMap);
        }
        BgExamineExportHelper.buildDocument(bizElement, refBgTemplateMap.get(bgExamineInfo.getId().toString()));
        BgExamineExportHelper.buildDocument(bizElement, bgExamineInfo.getBgExamineGroup());
    }

    private static void buildDocument(Element bizElement, BgExamineGroupInfo bgExamineGroupInfo) {
        if (bizElement == null || bgExamineGroupInfo == null) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BGEXAMINEGROUP);
        BgViewHelper.addElementText(tElement, DOCUMENT_NUMBER, bgExamineGroupInfo.getNumber());
        BgViewHelper.addElementText(tElement, DOCUMENT_NAME, bgExamineGroupInfo.getName());
    }

    private static void buildDocument(Element bizElement, BgExamineSubsetInfo bgExamineSubsetInfo, Map<String, MbgDimInfo> fieldDimMap) {
        Element subSetElement = bizElement.addElement(DOCUMENT_BGEXAMINESUBSET);
        BgViewHelper.addElementText(subSetElement, DOCUMENT_NAME, bgExamineSubsetInfo.getName());
        BgViewHelper.addElementText(subSetElement, DOCUMENT_SEQ, bgExamineSubsetInfo.getSeq());
        BgViewHelper.addElementText(subSetElement, DOCUMENT_ERRORDATA, bgExamineSubsetInfo.getErrorData());
        BgViewHelper.addElementText(subSetElement, DOCUMENT_HINT, bgExamineSubsetInfo.getHint());
        BgViewHelper.addElementText(subSetElement, DOCUMENT_FORMULA, bgExamineSubsetInfo.getBizFormula());
        for (int i = 0; i < bgExamineSubsetInfo.getBgScope().size(); ++i) {
            BgExamineExportHelper.buildDocument(subSetElement, bgExamineSubsetInfo.getBgScope().get(i), fieldDimMap);
        }
    }

    private static void buildDocument(Element bizElement, BgScopeInfo bgScopeInfo, Map<String, MbgDimInfo> fieldDimMap) {
        Element scopeElement = bizElement.addElement(DOCUMENT_SCOPE);
        BgViewHelper.addElementText(scopeElement, DOCUMENT_BGMEMBERALIAS, bgScopeInfo.getBgMemberAlias());
        BgViewHelper.addElementText(scopeElement, DOCUMENT_BGMEMBERNUM, bgScopeInfo.getBgMemberNum());
        BgViewHelper.addElementText(scopeElement, DOCUMENT_BGMEMBERTYPE, bgScopeInfo.getBgMemberType());
        BgViewHelper.addElementText(scopeElement, DOCUMENT_BIZDATATYPE, bgScopeInfo.getBizDataType().getName());
        BgViewHelper.addElementText(scopeElement, DOCUMENT_FILLTYPE, bgScopeInfo.getFillType().getName());
        BgViewHelper.addElementText(scopeElement, DOCUMENT_MBGDIMNUM, fieldDimMap.get(bgScopeInfo.getRefField()).getNumber());
        BgViewHelper.addElementText(scopeElement, DOCUMENT_REFFIELD, bgScopeInfo.getRefField());
        BgViewHelper.addElementText(scopeElement, DOCUMENT_SEQ, bgScopeInfo.getSeq());
    }

    private static void buildDocument(Element bizElement, List<BgExamineRefBgTemplateInfo> refTemps) {
        if (bizElement == null || refTemps == null || refTemps.isEmpty()) {
            return;
        }
        for (int i = 0; i < refTemps.size(); ++i) {
            BgExamineExportHelper.buildDocument(bizElement, refTemps.get(i));
        }
    }

    private static void buildDocument(Element bizElement, BgExamineRefBgTemplateInfo bgExamineRefBgTemplateInfo) {
        if (bizElement == null || bgExamineRefBgTemplateInfo == null || StringUtils.isEmpty((String)bgExamineRefBgTemplateInfo.getBgTemplate().getNumber())) {
            return;
        }
        Element tElement = bizElement.addElement(DOCUMENT_BGEXAMINEREFBGTEMPLATE);
        BgViewHelper.addElementText(tElement, DOCUMENT_NUMBER, bgExamineRefBgTemplateInfo.getBgTemplate().getNumber());
        BgViewHelper.addElementText(tElement, DOCUMENT_NAME, bgExamineRefBgTemplateInfo.getBgTemplate().getName());
    }

    public static String importBgExamine(String bgSchemeId, String orgUnitId, String filePath, ErrorHandleModeEnum errorHandle, String bgExamineGroupId) throws Exception {
        Map<String, MbgDimInfo> mbgDimMap = BgExamineExportHelper.getMbgDimMap();
        LinkedHashMap<String, BgExamineInfo> bgExamineMap = new LinkedHashMap<String, BgExamineInfo>();
        HashMap<String, BgTemplateCollection> refBgTempMap = new HashMap<String, BgTemplateCollection>();
        BgExamineExportHelper.unParse(filePath, bgExamineMap, refBgTempMap, mbgDimMap, bgExamineGroupId);
        return BgExamineFactory.getRemoteInstance().importBgExamine(bgSchemeId, orgUnitId, bgExamineMap, refBgTempMap, errorHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unParse(String filePath, Map<String, BgExamineInfo> bgExamineMap, Map<String, BgTemplateCollection> refBgTempMap, Map<String, MbgDimInfo> mbgDimMap, String bgExamineGroupId) throws Exception {
        SAXReader reader = new SAXReader();
        try (FileInputStream fis = null;){
            fis = new FileInputStream(new File(filePath));
            Document document = reader.read((InputStream)fis);
            Element rootElement = document.getRootElement();
            fis.close();
            boolean hasElement = false;
            Iterator it = rootElement.elementIterator(DOCUMENT_BGEXAMINE);
            while (it.hasNext()) {
                hasElement = true;
                BgExamineExportHelper.unParseBgExamine((Element)it.next(), bgExamineMap, refBgTempMap, mbgDimMap, bgExamineGroupId);
            }
            if (!hasElement) {
                throw new BgFormException(BgFormException.SHOWEXCEPTION, new Object[]{EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"openFileError")});
            }
        }
    }

    private static void unParseBgExamine(Element bizElement, Map<String, BgExamineInfo> bgExamineMap, Map<String, BgTemplateCollection> refBgTempMap, Map<String, MbgDimInfo> mbgDimMap, String bgExamineGroupId) {
        BgExamineInfo bgExamineInfo = new BgExamineInfo();
        bgExamineInfo.setId(BOSUuid.create((BOSObjectType)bgExamineInfo.getBOSType()));
        bgExamineInfo.setState(BgExamineStateEnum.SAVED);
        bgExamineMap.put(bgExamineInfo.getId().toString(), bgExamineInfo);
        bgExamineInfo.setNumber(BgViewHelper.getElementValue(bizElement, DOCUMENT_NUMBER));
        bgExamineInfo.setName(BgViewHelper.getElementValue(bizElement, DOCUMENT_NAME));
        bgExamineInfo.setNoPass(BgExamineNoPassEnum.getEnum(BgViewHelper.getElementValue(bizElement, DOCUMENT_NOPASS)));
        bgExamineInfo.setDescription(BgViewHelper.getElementValue(bizElement, DOCUMENT_DESCRIPTION));
        bgExamineInfo.setSrcNumbers(BgViewHelper.getElementValue(bizElement, DOCUMENT_SRCS));
        bgExamineInfo.setEnableTime(new Timestamp(System.currentTimeMillis()));
        bgExamineInfo.setEnableUser(SysContext.getSysContext().getCurrentUserInfo());
        Iterator it = bizElement.elementIterator(DOCUMENT_BGEXAMINESUBSET);
        while (it.hasNext()) {
            BgExamineSubsetInfo subSet = new BgExamineSubsetInfo();
            subSet.setBgExamine(bgExamineInfo);
            bgExamineInfo.getBgExamineSubset().add(subSet);
            BgExamineExportHelper.unParseSubSet((Element)it.next(), subSet, mbgDimMap);
        }
        it = bizElement.elementIterator(DOCUMENT_BGEXAMINEREFBGTEMPLATE);
        while (it.hasNext()) {
            BgExamineExportHelper.unParseRefBgTemplate((Element)it.next(), bgExamineInfo.getId().toString(), refBgTempMap);
        }
        BgExamineExportHelper.umParseBizCalcGroup(bgExamineInfo, bizElement, bgExamineGroupId);
    }

    private static void umParseBizCalcGroup(BgExamineInfo bgExamineInfo, Element bizElement, String bgExamineGroupId) {
        if (StringUtils.isEmpty((String)bgExamineGroupId)) {
            if (BgViewHelper.getElementValue(bizElement, DOCUMENT_BGEXAMINEGROUP) != null) {
                Iterator it = bizElement.elementIterator(DOCUMENT_BGEXAMINEGROUP);
                while (it.hasNext()) {
                    Element bgExamineGroupElement = (Element)it.next();
                    BgExamineGroupInfo bgExamineGroupInfo = new BgExamineGroupInfo();
                    if (bgExamineGroupElement != null) {
                        bgExamineGroupInfo.setNumber(BgViewHelper.getElementValue(bgExamineGroupElement, DOCUMENT_NUMBER));
                        bgExamineGroupInfo.setName(BgViewHelper.getElementValue(bgExamineGroupElement, DOCUMENT_NAME));
                        if (BgViewHelper.getElementValue(bgExamineGroupElement, DOCUMENT_NUMBER).equals("PRE")) {
                            bgExamineGroupInfo.setId(BOSUuid.read((String)"PCto8jovS9md/v3tQ45tMIdbVAE="));
                        } else {
                            bgExamineGroupInfo.setId(BOSUuid.create((BOSObjectType)bgExamineGroupInfo.getBOSType()));
                        }
                    } else {
                        bgExamineGroupInfo.setId(BOSUuid.read((String)"PCto8jovS9md/v3tQ45tMIdbVAE="));
                        bgExamineGroupInfo.setNumber("PRE");
                        bgExamineGroupInfo.setName(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"default_group"));
                    }
                    bgExamineInfo.setBgExamineGroup(bgExamineGroupInfo);
                }
            } else {
                BgExamineGroupInfo bgExamineGroupInfo = new BgExamineGroupInfo();
                bgExamineGroupInfo.setId(BOSUuid.read((String)"PCto8jovS9md/v3tQ45tMIdbVAE="));
                bgExamineGroupInfo.setNumber("PRE");
                bgExamineGroupInfo.setName(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgExamineResource", (String)"default_group"));
                bgExamineInfo.setBgExamineGroup(bgExamineGroupInfo);
            }
        } else {
            BgExamineGroupInfo bgExamineGroupInfo = new BgExamineGroupInfo();
            bgExamineGroupInfo.setId(BOSUuid.read((String)bgExamineGroupId));
            bgExamineInfo.setBgExamineGroup(bgExamineGroupInfo);
        }
    }

    private static void unParseSubSet(Element subSetElement, BgExamineSubsetInfo subSetInfo, Map<String, MbgDimInfo> mbgDimMap) {
        subSetInfo.setId(BOSUuid.create((BOSObjectType)subSetInfo.getBOSType()));
        subSetInfo.setName(BgViewHelper.getElementValue(subSetElement, DOCUMENT_NAME));
        subSetInfo.setErrorData(new BigDecimal(BgViewHelper.getElementValue(subSetElement, DOCUMENT_ERRORDATA) != null ? BgViewHelper.getElementValue(subSetElement, DOCUMENT_ERRORDATA) : "0"));
        subSetInfo.setSeq(Integer.valueOf(BgViewHelper.getElementValue(subSetElement, DOCUMENT_SEQ)));
        subSetInfo.setHint(BgViewHelper.getElementValue(subSetElement, DOCUMENT_HINT));
        subSetInfo.setBizFormula(BgViewHelper.getElementValue(subSetElement, DOCUMENT_FORMULA));
        Iterator it = subSetElement.elementIterator(DOCUMENT_SCOPE);
        while (it.hasNext()) {
            BgScopeInfo scope = new BgScopeInfo();
            scope.setBgExamineSubset(subSetInfo);
            subSetInfo.getBgScope().add(scope);
            BgExamineExportHelper.unParseScope((Element)it.next(), scope, mbgDimMap);
        }
    }

    private static void unParseScope(Element scopeElement, BgScopeInfo scopeInfo, Map<String, MbgDimInfo> mbgDimMap) {
        scopeInfo.setId(BOSUuid.create((BOSObjectType)scopeInfo.getBOSType()));
        scopeInfo.setSeq(Integer.parseInt(BgViewHelper.getElementValue(scopeElement, DOCUMENT_SEQ)));
        scopeInfo.setBgMemberAlias(BgViewHelper.getElementValue(scopeElement, DOCUMENT_BGMEMBERALIAS));
        scopeInfo.setBgMemberNum(BgViewHelper.getElementValue(scopeElement, DOCUMENT_BGMEMBERNUM));
        scopeInfo.setBgMemberType(Integer.parseInt(BgViewHelper.getElementValue(scopeElement, DOCUMENT_BGMEMBERTYPE)));
        scopeInfo.setBizDataType(BgMemberSelectTypeEnum.getEnum(BgViewHelper.getElementValue(scopeElement, DOCUMENT_BIZDATATYPE)));
        scopeInfo.setFillType(DimensionMemberTypeEnum.getEnum(BgViewHelper.getElementValue(scopeElement, DOCUMENT_FILLTYPE)));
        String mbgDimNum = BgViewHelper.getElementValue(scopeElement, DOCUMENT_MBGDIMNUM);
        if (!StringUtils.isEmpty((String)mbgDimNum) && mbgDimMap.get(mbgDimNum) != null) {
            scopeInfo.setRefField(mbgDimMap.get(mbgDimNum).getRefField());
        } else {
            scopeInfo.setRefField(BgViewHelper.getElementValue(scopeElement, DOCUMENT_REFFIELD));
        }
    }

    private static void unParseRefBgTemplate(Element refBgTemplateElement, String bgExamineId, Map<String, BgTemplateCollection> refBgTempMap) {
        if (StringUtils.isEmpty((String)BgViewHelper.getElementValue(refBgTemplateElement, DOCUMENT_NUMBER))) {
            return;
        }
        if (!refBgTempMap.containsKey(bgExamineId)) {
            refBgTempMap.put(bgExamineId, new BgTemplateCollection());
        }
        BgTemplateInfo bgTemplateInfo = new BgTemplateInfo();
        refBgTempMap.get(bgExamineId).add(bgTemplateInfo);
        bgTemplateInfo.setNumber(BgViewHelper.getElementValue(refBgTemplateElement, DOCUMENT_NUMBER));
        bgTemplateInfo.setName(BgViewHelper.getElementValue(refBgTemplateElement, DOCUMENT_NAME));
    }
}

