/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgParamCHelper;
import com.kingdee.eas.ma.mbg.BgCalculateSchemeInfo;
import com.kingdee.eas.ma.mbg.BgCourseOperateEnum;
import com.kingdee.eas.ma.mbg.BgFormAuditFacadeFactory;
import com.kingdee.eas.ma.mbg.BgNFormFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgFormAuditFacade;
import com.kingdee.eas.ma.mbg.client.BgCourseCommentEditUI;
import com.kingdee.eas.ma.mbg.client.BgCourseProcessUI;
import com.kingdee.eas.ma.mbg.client.BgFinalizedClientHelper;
import com.kingdee.eas.ma.mbg.client.BgFormAntiAuditIdeaEditUI;
import com.kingdee.eas.ma.mbg.client.BgFormAuditIdeaEditUI;
import com.kingdee.eas.ma.mbg.client.BgSpecialCourseProcessUI;
import com.kingdee.eas.ma.mbg.client.MBGFormCourseProcessUI;
import com.kingdee.eas.ma.mbg.client.MbgViewListFormCourseProcessUI;
import com.kingdee.eas.ma.mbg.client.utils.BgAdjustCheckClientHelper;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.utils.MBgExamineClientUtils;
import com.kingdee.eas.ma.mbg.client.utils.MbgCHelper;
import com.kingdee.eas.ma.mbg.progress.IProgressMonitor;
import com.kingdee.eas.ma.mbg.progress.IRunnableWithProgress;
import com.kingdee.eas.ma.mbg.progress.ProgressDialogNew;
import com.kingdee.eas.ma.mbg.progress.TimeMark;
import com.kingdee.eas.ma.mbg.utils.BgNSHelper;
import com.kingdee.eas.ma.mbg.utils.BgParamUtils;
import com.kingdee.eas.ma.mbg.utils.MBgExamineUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgFormAuditClientHelper {
    private static final Logger logger = Logger.getLogger(BgFormAuditClientHelper.class);
    public static final String RES = "com.kingdee.eas.ma.mbg.client.ActionResource";
    public LongTimeDialog dialog = null;

    public static BgFormAuditClientHelper getInstance() {
        return new BgFormAuditClientHelper();
    }

    private void initDialog(Component component) {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor(component);
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
        }
    }

    public static void checkProgressLoading(Component component, ActionEvent actionEvent, ProgressDialogNew progressDialog) {
        if (progressDialog != null && progressDialog.isLoading) {
            String actionName = "";
            actionName = progressDialog.getActionEvent() != null ? BgFormAuditClientHelper.getActionName(progressDialog.getActionEvent()) : BgFormAuditClientHelper.getActionName(actionEvent);
            MsgBox.showInfo((Component)component, (String)EASResource.getString((String)RES, (String)"doingAction", (Object[])new Object[]{actionName, actionName}));
            SysUtil.abort();
        }
    }

    public static String getActionName(ActionEvent actionEvent) {
        String actionName = "";
        if (actionEvent.getSource() instanceof KDWorkButton) {
            actionName = ((KDWorkButton)actionEvent.getSource()).getText();
        }
        return actionName;
    }

    public static void loadMonitorMsg(ProgressDialogNew dialogNew, boolean canBackRun) {
        if (canBackRun && dialogNew != null) {
            dialogNew.setWindowMsgTitle(EASResource.getString((String)RES, (String)"progress"));
            dialogNew.setMsg(EASResource.getString((String)RES, (String)"actionOver"));
        }
    }

    public Map<String, String> beforeUnCertificate(Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId) throws UIException {
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)auditOrgId)) {
            return null;
        }
        int re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_antiCertificate"));
        if (re == 1 || re == 2) {
            return null;
        }
        boolean hasQuit = false;
        int qus = MsgBox.showConfirm2New((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "question_antiCertificate_idea"));
        if (qus == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_ID", billIds);
            uiContext.put((Object)"OPERATE", (Object)BgCourseOperateEnum.AntiCertificate);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCourseCommentEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            hasQuit = ((BgCourseCommentEditUI)uiWindow.getUIObject()).isHasQuit();
        } else {
            hasQuit = true;
        }
        if (!hasQuit) {
            return null;
        }
        Map<String, String> auditParams = this.getUnCertificateParams(bgSchemeId, userId, auditOrgId, true, qus != 0);
        return auditParams;
    }

    public void unCertificate(ProgressDialogNew progressDialog, ActionEvent actionEvent, Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId) throws EASBizException, BOSException {
        BgFormAuditClientHelper.checkProgressLoading(component, actionEvent, progressDialog);
        Map<String, String> auditParams = BgFormAuditClientHelper.getInstance().beforeUnCertificate(component, bgSchemeId, userId, billIds, auditOrgId);
        if (auditParams == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        BgFormAuditClientHelper.loadMonitorMsg(progressDialog, true);
        IRunnableWithProgress runnableWithProgress = this.getUnCertificateProgress(actionEvent, component, billIds, auditParams, startTime);
        try {
            progressDialog.run(true, true, runnableWithProgress, progressDialog, false);
        }
        catch (Exception e) {
            logger.error((Object)("batch " + BgFormAuditClientHelper.getActionName(actionEvent) + " errror"), (Throwable)e);
        }
    }

    protected IRunnableWithProgress getUnCertificateProgress(final ActionEvent actionEvent, final Component component, final List<String> billIds, final Map auditParams, long startTime) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec(IProgressMonitor monitor) {
                Map result = null;
                String actionName = BgFormAuditClientHelper.getActionName(actionEvent);
                TimeMark mark = new TimeMark((CoreUI)component);
                try {
                    if (mark != null) {
                        mark.Start();
                    }
                    monitor.beginTask(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName, -1);
                    monitor.setTaskName(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName);
                    monitor.subTaskBegin(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"doAction", (Object[])new Object[]{actionName}));
                    try {
                        result = BgFormAuditFacadeFactory.getRemoteInstance().unCertificate(billIds, auditParams);
                    }
                    catch (BgPeriodException ex) {
                        MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                        SysUtil.abort();
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Component)component, (Throwable)e);
                    SysUtil.abort();
                }
                finally {
                    monitor.subTaskBegin(actionName + EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"over"));
                    monitor.done();
                    if (mark != null) {
                        mark.Stop();
                    }
                }
                MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)component);
                return result;
            }

            @Override
            public void afterExec(Object result) throws Exception {
                BgFormAuditClientHelper.showUnCertificateResult(component, billIds, result, auditParams, false);
            }
        };
    }

    public void unCertificate(Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId) throws UIException {
        this.unCertificate(component, bgSchemeId, userId, billIds, auditOrgId, false);
    }

    public void unCertificate(final Component component, String bgSchemeId, String userId, final List<String> billIds, String auditOrgId, final boolean isInForm) throws UIException {
        boolean hasQuit;
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)auditOrgId)) {
            return;
        }
        int re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_antiCertificate"));
        if (re == 1 || re == 2) {
            return;
        }
        int qus = MsgBox.showConfirm2New((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "question_antiCertificate_idea"));
        if (qus == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_ID", billIds);
            uiContext.put((Object)"OPERATE", (Object)BgCourseOperateEnum.AntiCertificate);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCourseCommentEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            hasQuit = ((BgCourseCommentEditUI)uiWindow.getUIObject()).isHasQuit();
        } else {
            hasQuit = true;
        }
        if (!hasQuit) {
            return;
        }
        final Map<String, String> auditParams = this.getUnCertificateParams(bgSchemeId, userId, auditOrgId, true, qus != 0);
        this.initDialog(component);
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map obj = null;
                try {
                    obj = BgFormAuditFacadeFactory.getRemoteInstance().unCertificate(billIds, auditParams);
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                return obj;
            }

            public void afterExec(Object _result) throws Exception {
                BgFormAuditClientHelper.showUnCertificateResult(component, billIds, _result, auditParams, isInForm);
            }
        });
        this.dialog.show();
    }

    protected Map<String, String> getUnCertificateParams(String bgSchemeId, String userId, String auditOrgId, boolean isReqMutex, boolean isRecordCourseComment) {
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_SCHEME_ID", bgSchemeId);
        auditParams.put("AUDIT_ORGUNIT_ID", auditOrgId);
        auditParams.put("AUDIT_USER_ID", userId);
        auditParams.put("AUDIT_DATA_STATE", String.valueOf(3));
        auditParams.put("AUDIT_BILL_STATE", String.valueOf(40));
        auditParams.put("AUDIT_PARAM", String.valueOf(10));
        if (isReqMutex) {
            auditParams.put("CHECK_MUTEX", String.valueOf(isReqMutex));
        }
        auditParams.put("CHECK_REPORT", String.valueOf(false));
        auditParams.put("CHECK_EXAMINE", String.valueOf(false));
        auditParams.put("CHECK_WORKFLOW", String.valueOf(true));
        if (isRecordCourseComment) {
            auditParams.put("AUDIT_COURSE_COMMENT_STATE", BgCourseOperateEnum.AntiCertificate.getName());
        }
        return auditParams;
    }

    public Map<String, String> beforeCertificate(Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId, BOSUuid bgOrgViewId) throws UIException {
        boolean hasQuit;
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)auditOrgId) || bgOrgViewId == null) {
            return null;
        }
        int re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_certificate"));
        if (re == 1 || re == 2) {
            return null;
        }
        int qus = MsgBox.showConfirm2New((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "question_certificate_idea"));
        if (qus == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_ID", billIds);
            uiContext.put((Object)"OPERATE", (Object)BgCourseOperateEnum.Certificate);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCourseCommentEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            hasQuit = ((BgCourseCommentEditUI)uiWindow.getUIObject()).isHasQuit();
        } else {
            hasQuit = true;
        }
        if (!hasQuit) {
            return null;
        }
        Map<String, String> auditParams = this.getCertificateParams(bgSchemeId, userId, auditOrgId, true, qus != 0);
        return auditParams;
    }

    public void certificate(ProgressDialogNew progressDialog, ActionEvent actionEvent, Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId, BOSUuid bgOrgViewId) throws EASBizException, BOSException {
        BgFormAuditClientHelper.checkProgressLoading(component, actionEvent, progressDialog);
        Map<String, String> auditParams = BgFormAuditClientHelper.getInstance().beforeCertificate(component, bgSchemeId, userId, billIds, auditOrgId, bgOrgViewId);
        if (auditParams == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        BgFormAuditClientHelper.loadMonitorMsg(progressDialog, true);
        IRunnableWithProgress runnableWithProgress = this.getCertificateProgress(actionEvent, component, billIds, auditParams, startTime, bgOrgViewId.toString());
        try {
            progressDialog.run(true, true, runnableWithProgress, progressDialog, false);
        }
        catch (Exception e) {
            logger.error((Object)("batch " + BgFormAuditClientHelper.getActionName(actionEvent) + " errror"), (Throwable)e);
        }
    }

    protected IRunnableWithProgress getCertificateProgress(final ActionEvent actionEvent, final Component component, final List<String> billIds, final Map auditParams, long startTime, final String bgOrgViewId) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec(IProgressMonitor monitor) {
                Map result = null;
                String actionName = BgFormAuditClientHelper.getActionName(actionEvent);
                TimeMark mark = new TimeMark((CoreUI)component);
                try {
                    if (mark != null) {
                        mark.Start();
                    }
                    monitor.beginTask(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName, -1);
                    monitor.setTaskName(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName);
                    monitor.subTaskBegin(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"doAction", (Object[])new Object[]{actionName}));
                    try {
                        result = BgFormAuditFacadeFactory.getRemoteInstance().certificate(billIds, auditParams);
                    }
                    catch (BgPeriodException ex) {
                        MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                        SysUtil.abort();
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Component)component, (Throwable)e);
                    SysUtil.abort();
                }
                finally {
                    monitor.subTaskBegin(actionName + EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"over"));
                    monitor.done();
                    if (mark != null) {
                        mark.Stop();
                    }
                }
                MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)component);
                return result;
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (!StringUtils.isEmpty((String)bgOrgViewId)) {
                    BgFormAuditClientHelper.showCertificateResult(component, BOSUuid.read((String)bgOrgViewId), billIds, result, auditParams, false);
                }
            }
        };
    }

    public void certificate(Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId, BOSUuid bgOrgViewId) throws UIException {
        this.certificate(component, bgSchemeId, userId, billIds, auditOrgId, bgOrgViewId, false);
    }

    public void certificate(final Component component, String bgSchemeId, String userId, final List<String> billIds, String auditOrgId, final BOSUuid bgOrgViewId, final boolean isInForm) throws UIException {
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)auditOrgId) || bgOrgViewId == null) {
            return;
        }
        int re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_certificate"));
        if (re == 1 || re == 2) {
            return;
        }
        boolean hasQuit = false;
        int qus = MsgBox.showConfirm2New((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "question_certificate_idea"));
        if (qus == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_ID", billIds);
            uiContext.put((Object)"OPERATE", (Object)BgCourseOperateEnum.Certificate);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCourseCommentEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            hasQuit = ((BgCourseCommentEditUI)uiWindow.getUIObject()).isHasQuit();
        } else {
            hasQuit = true;
        }
        if (!hasQuit) {
            return;
        }
        final Map<String, String> auditParams = this.getCertificateParams(bgSchemeId, userId, auditOrgId, true, qus != 0);
        this.initDialog(component);
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map obj = null;
                try {
                    obj = BgFormAuditFacadeFactory.getRemoteInstance().certificate(billIds, auditParams);
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                return obj;
            }

            public void afterExec(Object _result) throws Exception {
                BgFormAuditClientHelper.showCertificateResult(component, bgOrgViewId, billIds, _result, auditParams, isInForm);
            }
        });
        this.dialog.show();
    }

    protected Map<String, String> getCertificateParams(String bgSchemeId, String userId, String auditOrgId, boolean isReqMutex, boolean isRecordCourseComment) {
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_SCHEME_ID", bgSchemeId);
        auditParams.put("AUDIT_ORGUNIT_ID", auditOrgId);
        auditParams.put("AUDIT_USER_ID", userId);
        auditParams.put("AUDIT_DATA_STATE", String.valueOf(3));
        auditParams.put("AUDIT_BILL_STATE", String.valueOf(41));
        auditParams.put("AUDIT_PARAM", String.valueOf(9));
        if (isReqMutex) {
            auditParams.put("CHECK_MUTEX", String.valueOf(isReqMutex));
        }
        if (BgNSHelper.isVerifyOfCertificate()) {
            auditParams.put("CHECK_REPORT", String.valueOf(true));
        } else {
            auditParams.put("CHECK_REPORT", String.valueOf(false));
        }
        if (BgParamCHelper.isExamineCheckOnlyUnionReport()) {
            auditParams.put("CHECK_EXAMINE", String.valueOf(false));
        } else {
            auditParams.put("CHECK_EXAMINE", String.valueOf(true));
        }
        auditParams.put("CHECK_WORKFLOW", String.valueOf(true));
        if (isRecordCourseComment) {
            auditParams.put("AUDIT_COURSE_COMMENT_STATE", BgCourseOperateEnum.Certificate.getName());
        }
        return auditParams;
    }

    public Map<String, String> beforeBack(Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId) throws BOSException, EASBizException {
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)auditOrgId)) {
            return null;
        }
        int re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_back"));
        if (re == 1 || re == 2) {
            return null;
        }
        boolean hasQuit = false;
        int qus = MsgBox.showConfirm2New((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "question_back_idea"));
        if (qus == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_ID", billIds);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCourseCommentEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            hasQuit = ((BgCourseCommentEditUI)uiWindow.getUIObject()).isHasQuit();
        } else {
            hasQuit = true;
        }
        if (!hasQuit) {
            return null;
        }
        Map<String, String> auditParams = this.getBackParams(bgSchemeId, userId, auditOrgId, true, qus != 0);
        return auditParams;
    }

    public void back(ProgressDialogNew progressDialog, ActionEvent actionEvent, Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId) throws EASBizException, BOSException {
        BgFormAuditClientHelper.checkProgressLoading(component, actionEvent, progressDialog);
        Map<String, String> auditParams = BgFormAuditClientHelper.getInstance().beforeBack(component, bgSchemeId, userId, billIds, auditOrgId);
        if (auditParams == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        BgFormAuditClientHelper.loadMonitorMsg(progressDialog, true);
        IRunnableWithProgress runnableWithProgress = this.getBackProgress(actionEvent, component, billIds, auditParams, startTime);
        try {
            progressDialog.run(true, true, runnableWithProgress, progressDialog, false);
        }
        catch (Exception e) {
            logger.error((Object)("batch " + BgFormAuditClientHelper.getActionName(actionEvent) + " errror"), (Throwable)e);
        }
    }

    protected IRunnableWithProgress getBackProgress(final ActionEvent actionEvent, final Component component, final List<String> billIds, final Map auditParams, long startTime) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec(IProgressMonitor monitor) {
                Map result = null;
                String actionName = BgFormAuditClientHelper.getActionName(actionEvent);
                TimeMark mark = new TimeMark((CoreUI)component);
                try {
                    if (mark != null) {
                        mark.Start();
                    }
                    monitor.beginTask(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName, -1);
                    monitor.setTaskName(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName);
                    monitor.subTaskBegin(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"doAction", (Object[])new Object[]{actionName}));
                    try {
                        result = BgFormAuditFacadeFactory.getRemoteInstance().back(billIds, auditParams);
                    }
                    catch (BgPeriodException ex) {
                        MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                        SysUtil.abort();
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Component)component, (Throwable)e);
                    SysUtil.abort();
                }
                finally {
                    monitor.subTaskBegin(actionName + EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"over"));
                    monitor.done();
                    if (mark != null) {
                        mark.Stop();
                    }
                }
                MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)component);
                return result;
            }

            @Override
            public void afterExec(Object result) throws Exception {
                BgFormAuditClientHelper.showBackResult(component, billIds, result, auditParams, false);
            }
        };
    }

    public void back(Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId) throws BOSException, EASBizException {
        this.back(component, bgSchemeId, userId, billIds, auditOrgId, false);
    }

    public void back(final Component component, String bgSchemeId, String userId, final List<String> billIds, String auditOrgId, final boolean isInForm) throws BOSException, EASBizException {
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)auditOrgId)) {
            return;
        }
        int re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_back"));
        if (re == 1 || re == 2) {
            return;
        }
        boolean hasQuit = false;
        int qus = MsgBox.showConfirm2New((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "question_back_idea"));
        if (qus == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_ID", billIds);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCourseCommentEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            hasQuit = ((BgCourseCommentEditUI)uiWindow.getUIObject()).isHasQuit();
        } else {
            hasQuit = true;
        }
        if (!hasQuit) {
            return;
        }
        final Map<String, String> auditParams = this.getBackParams(bgSchemeId, userId, auditOrgId, true, qus != 0);
        this.initDialog(component);
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map obj = null;
                try {
                    obj = BgFormAuditFacadeFactory.getRemoteInstance().back(billIds, auditParams);
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                return obj;
            }

            public void afterExec(Object _result) throws Exception {
                BgFormAuditClientHelper.showBackResult(component, billIds, _result, auditParams, isInForm);
            }
        });
        this.dialog.show();
    }

    protected Map<String, String> getBackParams(String bgSchemeId, String userId, String auditOrgId, boolean isReqMutex, boolean isRecordCourseComment) {
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_SCHEME_ID", bgSchemeId);
        auditParams.put("AUDIT_ORGUNIT_ID", auditOrgId);
        auditParams.put("AUDIT_USER_ID", userId);
        auditParams.put("AUDIT_DATA_STATE", String.valueOf(1));
        auditParams.put("AUDIT_BILL_STATE", String.valueOf(42));
        auditParams.put("AUDIT_PARAM", String.valueOf(8));
        if (isReqMutex) {
            auditParams.put("CHECK_MUTEX", String.valueOf(isReqMutex));
        }
        auditParams.put("CHECK_REPORT", String.valueOf(false));
        auditParams.put("CHECK_EXAMINE", String.valueOf(false));
        auditParams.put("CHECK_WORKFLOW", String.valueOf(true));
        if (isRecordCourseComment) {
            auditParams.put("AUDIT_COURSE_COMMENT_STATE", BgCourseOperateEnum.Back.getName());
        }
        return auditParams;
    }

    public Map<String, String> beforeCourse(Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId, BOSUuid bgOrgViewId) {
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)auditOrgId) || bgOrgViewId == null) {
            return null;
        }
        int re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_isReport"));
        if (re == 1 || re == 2) {
            return null;
        }
        Map<String, String> auditParams = this.getCourseParams(bgSchemeId, userId, auditOrgId, true);
        try {
            int rc;
            BgCalculateSchemeInfo calcScheme;
            if (BgParamUtils.checkFinalized(null) && (calcScheme = BgFinalizedClientHelper.getCalcSchemeByBgScheme(bgSchemeId)) != null && (rc = MsgBox.showConfirm2New((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFinalizedResource", (String)"is_calcScheme_formCousr", (Object[])new Object[]{calcScheme.getName()}))) == 0) {
                BgFinalizedClientHelper.calcSchemeCourse(component, billIds, auditParams, bgOrgViewId);
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return auditParams;
    }

    public void course(ProgressDialogNew progressDialog, ActionEvent actionEvent, Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId, BOSUuid bgOrgViewId) throws EASBizException, BOSException {
        BgFormAuditClientHelper.checkProgressLoading(component, actionEvent, progressDialog);
        Map<String, String> auditParams = BgFormAuditClientHelper.getInstance().beforeCourse(component, bgSchemeId, userId, billIds, auditOrgId, bgOrgViewId);
        if (auditParams == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        BgFormAuditClientHelper.loadMonitorMsg(progressDialog, true);
        IRunnableWithProgress runnableWithProgress = this.getCourseProgress(actionEvent, component, billIds, auditParams, startTime, bgOrgViewId.toString());
        try {
            progressDialog.run(true, true, runnableWithProgress, progressDialog, false);
        }
        catch (Exception e) {
            logger.error((Object)("batch " + BgFormAuditClientHelper.getActionName(actionEvent) + " errror"), (Throwable)e);
        }
    }

    protected IRunnableWithProgress getCourseProgress(final ActionEvent actionEvent, final Component component, final List<String> billIds, final Map auditParams, long startTime, final String bgOrgViewId) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec(IProgressMonitor monitor) {
                Map result = null;
                String actionName = BgFormAuditClientHelper.getActionName(actionEvent);
                TimeMark mark = new TimeMark((CoreUI)component);
                try {
                    if (mark != null) {
                        mark.Start();
                    }
                    monitor.beginTask(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName, -1);
                    monitor.setTaskName(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName);
                    monitor.subTaskBegin(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"doAction", (Object[])new Object[]{actionName}));
                    try {
                        result = BgFormAuditFacadeFactory.getRemoteInstance().courses(billIds, auditParams);
                    }
                    catch (BgPeriodException ex) {
                        MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                        SysUtil.abort();
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Component)component, (Throwable)e);
                    SysUtil.abort();
                }
                finally {
                    monitor.subTaskBegin(actionName + EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"over"));
                    monitor.done();
                    if (mark != null) {
                        mark.Stop();
                    }
                }
                MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)component);
                return result;
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (!StringUtils.isEmpty((String)bgOrgViewId)) {
                    BgFormAuditClientHelper.showCourseResult(component, BOSUuid.read((String)bgOrgViewId), billIds, result, auditParams);
                }
            }
        };
    }

    public void course(final Component component, String bgSchemeId, String userId, final List<String> billIds, String auditOrgId, final BOSUuid bgOrgViewId) {
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)auditOrgId) || bgOrgViewId == null) {
            return;
        }
        int re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_isReport"));
        if (re == 1 || re == 2) {
            return;
        }
        final Map<String, String> auditParams = this.getCourseParams(bgSchemeId, userId, auditOrgId, true);
        try {
            int rc;
            BgCalculateSchemeInfo calcScheme;
            if (BgParamUtils.checkFinalized(null) && (calcScheme = BgFinalizedClientHelper.getCalcSchemeByBgScheme(bgSchemeId)) != null && (rc = MsgBox.showConfirm2New((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgFinalizedResource", (String)"is_calcScheme_formCousr", (Object[])new Object[]{calcScheme.getName()}))) == 0) {
                BgFinalizedClientHelper.calcSchemeCourse(component, billIds, auditParams, bgOrgViewId);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initDialog(component);
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map obj = null;
                try {
                    obj = BgFormAuditFacadeFactory.getRemoteInstance().courses(billIds, auditParams);
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                return obj;
            }

            public void afterExec(Object _result) throws Exception {
                BgFormAuditClientHelper.showCourseResult(component, bgOrgViewId, billIds, _result, auditParams);
            }
        });
        this.dialog.show();
    }

    protected Map<String, String> getCourseParams(String bgSchemeId, String userId, String auditOrgId, boolean isReqMutex) {
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_SCHEME_ID", bgSchemeId);
        auditParams.put("AUDIT_ORGUNIT_ID", auditOrgId);
        auditParams.put("AUDIT_USER_ID", userId);
        auditParams.put("AUDIT_DATA_STATE", String.valueOf(3));
        auditParams.put("AUDIT_BILL_STATE", String.valueOf(40));
        auditParams.put("AUDIT_PARAM", String.valueOf(7));
        if (isReqMutex) {
            auditParams.put("CHECK_MUTEX", String.valueOf(isReqMutex));
        }
        if (BgNSHelper.isVerifyOfCourse()) {
            auditParams.put("CHECK_REPORT", String.valueOf(true));
        } else {
            auditParams.put("CHECK_REPORT", String.valueOf(false));
        }
        auditParams.put("CHECK_EXAMINE", String.valueOf(true));
        auditParams.put("CHECK_WORKFLOW", String.valueOf(true));
        auditParams.put("AUDIT_COURSE_COMMENT_STATE", BgCourseOperateEnum.Course.getName());
        return auditParams;
    }

    public Map<String, String> beforeBatchAudit(Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId, BOSUuid bgOrgViewId, boolean isReqMutex, boolean isConfirm, boolean isExamineCheck) throws UIException {
        boolean hasQuit;
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)auditOrgId) || bgOrgViewId == null) {
            return null;
        }
        int re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"askBatchAuditBgForm"));
        if (re == 1 || re == 2) {
            return null;
        }
        int qus = MsgBox.showConfirm2New((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "question_Audit_idea"));
        if (qus == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_ID", billIds);
            uiContext.put((Object)"OPERATE", (Object)BgCourseOperateEnum.Confirm);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCourseCommentEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            hasQuit = ((BgCourseCommentEditUI)uiWindow.getUIObject()).isHasQuit();
        } else {
            hasQuit = true;
        }
        if (!hasQuit) {
            return null;
        }
        try {
            BgAdjustCheckClientHelper.adjustCheckBgForm(component, billIds);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)component, (Throwable)e);
            SysUtil.abort();
        }
        Map<String, String> auditParams = this.getAuditParams(bgSchemeId, userId, auditOrgId, isReqMutex, isExamineCheck, qus != 0);
        return auditParams;
    }

    public void batchAudit(ProgressDialogNew progressDialog, ActionEvent actionEvent, Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId, BOSUuid bgOrgViewId, boolean isReqMutex, boolean isConfirm, boolean isExamineCheck) throws EASBizException, BOSException {
        BgFormAuditClientHelper.checkProgressLoading(component, actionEvent, progressDialog);
        Map<String, String> auditParams = BgFormAuditClientHelper.getInstance().beforeBatchAudit(component, bgSchemeId, userId, billIds, auditOrgId, bgOrgViewId, isReqMutex, isConfirm, isExamineCheck);
        if (auditParams == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        BgFormAuditClientHelper.loadMonitorMsg(progressDialog, true);
        IRunnableWithProgress runnableWithProgress = this.getBatchAuditProgress(actionEvent, component, billIds, auditParams, startTime, bgOrgViewId.toString(), isReqMutex, isConfirm);
        try {
            progressDialog.run(true, true, runnableWithProgress, progressDialog, false);
        }
        catch (Exception e) {
            logger.error((Object)("batch " + BgFormAuditClientHelper.getActionName(actionEvent) + " errror"), (Throwable)e);
        }
    }

    protected IRunnableWithProgress getBatchAuditProgress(final ActionEvent actionEvent, final Component component, final List<String> billIds, final Map auditParams, long startTime, final String bgOrgViewId, boolean isReqMutex, final boolean isConfirm) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec(IProgressMonitor monitor) {
                Map result = null;
                String actionName = BgFormAuditClientHelper.getActionName(actionEvent);
                TimeMark mark = new TimeMark((CoreUI)component);
                try {
                    if (mark != null) {
                        mark.Start();
                    }
                    monitor.beginTask(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName, -1);
                    monitor.setTaskName(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName);
                    monitor.subTaskBegin(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"doAction", (Object[])new Object[]{actionName}));
                    try {
                        result = BgFormAuditFacadeFactory.getRemoteInstance().audit(billIds, auditParams);
                    }
                    catch (BgPeriodException ex) {
                        MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                        SysUtil.abort();
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Component)component, (Throwable)e);
                    SysUtil.abort();
                }
                finally {
                    monitor.subTaskBegin(actionName + EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"over"));
                    monitor.done();
                    if (mark != null) {
                        mark.Stop();
                    }
                }
                MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)component);
                return result;
            }

            @Override
            public void afterExec(Object result) throws Exception {
                if (!StringUtils.isEmpty((String)bgOrgViewId)) {
                    BgFormAuditClientHelper.showAuditResult(component, BOSUuid.read((String)bgOrgViewId), billIds, result, auditParams, isConfirm);
                }
            }
        };
    }

    public void batchAudit(Component component, String bgSchemeId, String userId, List<String> billIds, String auditOrgId, BOSUuid bgOrgViewId, boolean isReqMutex, boolean isConfirm) throws UIException {
        this.batchAudit(component, bgSchemeId, userId, billIds, auditOrgId, bgOrgViewId, isReqMutex, isConfirm, true);
    }

    public void batchAudit(final Component component, String bgSchemeId, String userId, final List<String> billIds, String auditOrgId, final BOSUuid bgOrgViewId, boolean isReqMutex, final boolean isConfirm, boolean isExamineCheck) throws UIException {
        boolean hasQuit;
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)auditOrgId) || bgOrgViewId == null) {
            return;
        }
        int re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"askBatchAuditBgForm"));
        if (re == 1 || re == 2) {
            return;
        }
        int qus = MsgBox.showConfirm2New((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "question_Audit_idea"));
        if (qus == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_ID", billIds);
            uiContext.put((Object)"OPERATE", (Object)BgCourseOperateEnum.Confirm);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCourseCommentEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            hasQuit = ((BgCourseCommentEditUI)uiWindow.getUIObject()).isHasQuit();
        } else {
            hasQuit = true;
        }
        if (!hasQuit) {
            return;
        }
        try {
            BgAdjustCheckClientHelper.adjustCheckBgForm(component, billIds);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)component, (Throwable)e);
            SysUtil.abort();
        }
        final Map<String, String> auditParams = this.getAuditParams(bgSchemeId, userId, auditOrgId, isReqMutex, isExamineCheck, qus != 0);
        this.initDialog(component);
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map obj = null;
                try {
                    obj = BgFormAuditFacadeFactory.getRemoteInstance().audit(billIds, auditParams);
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                return obj;
            }

            public void afterExec(Object _result) throws Exception {
                BgFormAuditClientHelper.showAuditResult(component, bgOrgViewId, billIds, _result, auditParams, isConfirm);
            }
        });
        this.dialog.show();
    }

    protected Map<String, String> getAuditParams(String bgSchemeId, String userId, String auditOrgId, boolean isReqMutex) {
        return this.getAuditParams(bgSchemeId, userId, auditOrgId, isReqMutex, true, true);
    }

    public void audit(final Component component, String bgSchemeId, String userId, final IObjectValue model, String auditOrgId, final Object bgOrgViewId) {
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || model == null || StringUtils.isEmpty((String)auditOrgId) || bgOrgViewId == null) {
            return;
        }
        final boolean isRoll = component instanceof CoreUI && Boolean.TRUE.equals(((CoreUI)component).getUIContext().get("IS_ROLL"));
        final ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(model.getString(model.getPKField()));
        try {
            BgAdjustCheckClientHelper.adjustCheckBgForm(component, billIds);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)component, (Throwable)e);
            SysUtil.abort();
        }
        final Map<String, String> auditParams = this.getAuditParams(bgSchemeId, userId, auditOrgId, false, this.checkExamineCheck(component), true);
        this.initDialog(component);
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map obj = null;
                try {
                    obj = BgFormAuditFacadeFactory.getRemoteInstance().auditCheck(billIds, auditParams);
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                return obj;
            }

            public void afterExec(Object _result) throws Exception {
                BOSUuid _bgOrgViewId = null;
                if (bgOrgViewId instanceof BOSUuid) {
                    _bgOrgViewId = (BOSUuid)bgOrgViewId;
                } else if (bgOrgViewId instanceof String) {
                    _bgOrgViewId = BOSUuid.read((String)((String)bgOrgViewId));
                }
                boolean check = BgFormAuditClientHelper.showCheckResult(component, _bgOrgViewId, billIds, _result, false, isRoll);
                if (check) {
                    BgFormAuditClientHelper.this.afterAudit(component, model, auditParams);
                }
            }
        });
        this.dialog.show();
    }

    protected boolean checkExamineCheck(Component component) {
        boolean isExamineCheck = true;
        if (BgParamCHelper.isExamineCheckOnlyUnionReport()) {
            HashSet<String> courseUI = new HashSet<String>();
            courseUI.add(BgCourseProcessUI.class.getName());
            courseUI.add(BgSpecialCourseProcessUI.class.getName());
            courseUI.add(MbgViewListFormCourseProcessUI.class.getName());
            courseUI.add(MBGFormCourseProcessUI.class.getName());
            if (component != null && courseUI.contains(component.getClass().getName())) {
                isExamineCheck = false;
            }
        }
        return isExamineCheck;
    }

    protected Map<String, String> getAuditParams(String bgSchemeId, String userId, String auditOrgId, boolean isReqMutex, boolean isExamineCheck, boolean isRecordCourseComment) {
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_SCHEME_ID", bgSchemeId);
        auditParams.put("AUDIT_ORGUNIT_ID", auditOrgId);
        auditParams.put("AUDIT_USER_ID", userId);
        auditParams.put("AUDIT_DATA_STATE", String.valueOf(9));
        auditParams.put("AUDIT_BILL_STATE", String.valueOf(2));
        auditParams.put("AUDIT_PARAM", String.valueOf(0));
        if (isReqMutex) {
            auditParams.put("CHECK_MUTEX", String.valueOf(isReqMutex));
        }
        if (BgNSHelper.isCompulsionReportCheck(null)) {
            auditParams.put("CHECK_REPORT", String.valueOf(true));
        } else {
            auditParams.put("CHECK_REPORT", String.valueOf(false));
        }
        auditParams.put("CHECK_EXAMINE", String.valueOf(true));
        auditParams.put("CHECK_WORKFLOW", String.valueOf(true));
        auditParams.put("CHECK_EXAMINE", String.valueOf(isExamineCheck));
        if (isRecordCourseComment) {
            auditParams.put("AUDIT_COURSE_COMMENT_STATE", BgCourseOperateEnum.Confirm.getName());
        }
        return auditParams;
    }

    protected boolean afterAudit(Component component, IObjectValue model, Map<String, String> auditParams) throws Exception {
        boolean audit = false;
        if (model == null || auditParams == null) {
            return audit;
        }
        int re = MsgBox.showConfirm2((String)(this.getMessageStr("com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", "auditIdea") + model.getString("name") + this.getMessageStr("com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", "bgForm")));
        if (re == 1 || re == 2) {
            return audit;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGFORM_PROCESSUI", (Object)component);
        uiContext.put((Object)"BGFORM_AUDIT_TYPE", (Object)"BGFORM_AUDIT");
        uiContext.put((Object)"AUDIT_PARAM", auditParams);
        uiContext.put((Object)"BGFORM_INFO", (Object)model);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgFormAuditIdeaEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (uiWindow != null && uiWindow.getUIObject() instanceof BgFormAuditIdeaEditUI && !((BgFormAuditIdeaEditUI)uiWindow.getUIObject()).isCancel()) {
            audit = true;
            ((CoreUI)component).getUIWindow().close();
            MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)((CoreUI)component).getUIContext().get("Owner"));
        }
        return audit;
    }

    protected IBgFormAuditFacade getInterface() throws Exception {
        return BgFormAuditFacadeFactory.getRemoteInstance();
    }

    protected String getMessageStr(String sourceStr, String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)sourceStr, (String)key) : "";
    }

    public Map<String, String> beforeBatchUnAudit(CoreUI component, String bgSchemeId, String userId, Map<String, String[]> billMap, String auditOrgId, boolean isReqMutex) throws EASBizException, BOSException, UuidException {
        boolean hasQuit;
        int re;
        boolean isConfirm = false;
        Set hasBizPast = BgNFormFacadeFactory.getRemoteInstance().checkBizPastData(BOSUuid.read((String)bgSchemeId), new ArrayList<String>(billMap.keySet()));
        if (hasBizPast != null && !hasBizPast.isEmpty()) {
            StringBuffer detailMsg = new StringBuffer();
            for (String id : hasBizPast) {
                if (detailMsg.length() > 0) {
                    detailMsg.append("\r\n");
                }
                detailMsg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", (String)"cantBatchAntiAuditByBizCalcDetail", (Object[])billMap.get(id)));
            }
            int re2 = MsgBox.showConfirm3a((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", (String)"cantBatchAntiAuditByBizCalcTitle"), (String)detailMsg.toString());
            if (re2 != 0) {
                return null;
            }
        } else {
            isConfirm = true;
        }
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)auditOrgId)) {
            return null;
        }
        if (isConfirm && ((re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"askBatchUnAuditBgForm"))) == 1 || re == 2)) {
            return null;
        }
        int qus = MsgBox.showConfirm2New((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "question_antiAudit_idea"));
        if (qus == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_ID", new ArrayList<String>(billMap.keySet()));
            uiContext.put((Object)"OPERATE", (Object)BgCourseOperateEnum.UnConfirm);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCourseCommentEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            hasQuit = ((BgCourseCommentEditUI)uiWindow.getUIObject()).isHasQuit();
        } else {
            hasQuit = true;
        }
        if (!hasQuit) {
            return null;
        }
        Map<String, String> auditParams = this.getUnAuditParams(bgSchemeId, userId, auditOrgId, isReqMutex, qus != 0, false);
        return auditParams;
    }

    public void batchUnAudit(ProgressDialogNew progressDialog, ActionEvent actionEvent, CoreUI component, String bgSchemeId, String userId, Map<String, String[]> billMap, String auditOrgId, boolean isReqMutex) throws EASBizException, BOSException {
        BgFormAuditClientHelper.checkProgressLoading((Component)component, actionEvent, progressDialog);
        Map<String, String> auditParams = BgFormAuditClientHelper.getInstance().beforeBatchUnAudit(component, bgSchemeId, userId, billMap, auditOrgId, isReqMutex);
        if (auditParams == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        BgFormAuditClientHelper.loadMonitorMsg(progressDialog, true);
        IRunnableWithProgress runnableWithProgress = this.getBatchUnAuditProgress(actionEvent, (Component)component, new ArrayList<String>(billMap.keySet()), auditParams, startTime);
        try {
            progressDialog.run(true, true, runnableWithProgress, progressDialog, false);
        }
        catch (Exception e) {
            logger.error((Object)("batch " + BgFormAuditClientHelper.getActionName(actionEvent) + " errror"), (Throwable)e);
        }
    }

    protected IRunnableWithProgress getBatchUnAuditProgress(final ActionEvent actionEvent, final Component component, final List<String> billIds, final Map auditParams, long startTime) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object exec(IProgressMonitor monitor) {
                Map result = null;
                String actionName = BgFormAuditClientHelper.getActionName(actionEvent);
                TimeMark mark = new TimeMark((CoreUI)component);
                try {
                    if (mark != null) {
                        mark.Start();
                    }
                    monitor.beginTask(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName, -1);
                    monitor.setTaskName(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"bgForm") + actionName);
                    monitor.subTaskBegin(EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"doAction", (Object[])new Object[]{actionName}));
                    try {
                        result = BgFormAuditFacadeFactory.getRemoteInstance().unAudit(billIds, auditParams);
                    }
                    catch (BgPeriodException ex) {
                        MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                        SysUtil.abort();
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Component)component, (Throwable)e);
                    SysUtil.abort();
                }
                finally {
                    monitor.subTaskBegin(actionName + EASResource.getString((String)BgFormAuditClientHelper.RES, (String)"over"));
                    monitor.done();
                    if (mark != null) {
                        mark.Stop();
                    }
                }
                MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)component);
                return result;
            }

            @Override
            public void afterExec(Object result) throws Exception {
                BgFormAuditClientHelper.showUnAuditResult(component, billIds, result, auditParams, false);
            }
        };
    }

    public boolean batchUnAudit(CoreUI component, String bgSchemeId, String userId, Map<String, String[]> billMap, String auditOrgId, boolean isReqMutex) throws Exception {
        Set hasBizPast = BgNFormFacadeFactory.getRemoteInstance().checkBizPastData(BOSUuid.read((String)bgSchemeId), new ArrayList<String>(billMap.keySet()));
        if (hasBizPast != null && !hasBizPast.isEmpty()) {
            StringBuffer detailMsg = new StringBuffer();
            for (String id : hasBizPast) {
                if (detailMsg.length() > 0) {
                    detailMsg.append("\r\n");
                }
                detailMsg.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", (String)"cantBatchAntiAuditByBizCalcDetail", (Object[])billMap.get(id)));
            }
            int re = MsgBox.showConfirm3a((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", (String)"cantBatchAntiAuditByBizCalcTitle"), (String)detailMsg.toString());
            if (re != 0) {
                return false;
            }
            this.batchUnAudit((Component)component, bgSchemeId, userId, new ArrayList<String>(billMap.keySet()), auditOrgId, true, false);
        } else {
            this.batchUnAudit((Component)component, bgSchemeId, userId, new ArrayList<String>(billMap.keySet()), auditOrgId, true, true);
        }
        MbgCHelper.getIntance().asyncRefreshListUI(component);
        return true;
    }

    public void batchUnAudit(final Component component, String bgSchemeId, String userId, final List<String> billIds, String auditOrgId, boolean isReqMutex, boolean isConfirm) throws Exception {
        boolean hasQuit;
        int re;
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || billIds == null || billIds.isEmpty() || StringUtils.isEmpty((String)auditOrgId)) {
            return;
        }
        if (isConfirm && ((re = MsgBox.showConfirm2((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"askBatchUnAuditBgForm"))) == 1 || re == 2)) {
            return;
        }
        int qus = MsgBox.showConfirm2New((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormCourseResource", "question_antiAudit_idea"));
        if (qus == 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"BGFORM_ID", billIds);
            uiContext.put((Object)"OPERATE", (Object)BgCourseOperateEnum.UnConfirm);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCourseCommentEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            hasQuit = ((BgCourseCommentEditUI)uiWindow.getUIObject()).isHasQuit();
        } else {
            hasQuit = true;
        }
        if (!hasQuit) {
            return;
        }
        final Map<String, String> auditParams = this.getUnAuditParams(bgSchemeId, userId, auditOrgId, isReqMutex, qus != 0, true);
        this.initDialog(component);
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map obj = null;
                try {
                    obj = BgFormAuditFacadeFactory.getRemoteInstance().unAudit(billIds, auditParams);
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                return obj;
            }

            public void afterExec(Object result) throws Exception {
                BgFormAuditClientHelper.showUnAuditResult(component, billIds, result, auditParams, false);
            }
        });
        this.dialog.show();
    }

    public void unAudit(Component component, String bgSchemeId, String userId, IObjectValue model, String auditOrgId) throws Exception {
        this.unAudit(component, bgSchemeId, userId, model, auditOrgId, false);
    }

    public void unAudit(final Component component, String bgSchemeId, String userId, final IObjectValue model, String auditOrgId, boolean isInForm) throws Exception {
        boolean isRoll;
        if (component == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)userId) || model == null || StringUtils.isEmpty((String)auditOrgId)) {
            return;
        }
        final ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(model.getString(model.getPKField()));
        final Map<String, String> auditParams = this.getUnAuditParams(bgSchemeId, userId, auditOrgId, false, true, false);
        boolean bl = isRoll = component instanceof CoreUI && Boolean.TRUE.equals(((CoreUI)component).getUIContext().get("IS_ROLL"));
        if (isRoll) {
            auditParams.put("AUDIT_BILL_STATE", String.valueOf(6));
        }
        this.initDialog(component);
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Map obj = null;
                try {
                    obj = BgFormAuditFacadeFactory.getRemoteInstance().unAuditCheck(billIds, auditParams);
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                return obj;
            }

            public void afterExec(Object result) throws Exception {
                boolean check = BgFormAuditClientHelper.showAntiAuditCheckResult(component, billIds, result, auditParams);
                if (check) {
                    BgFormAuditClientHelper.this.afterAntiAudit(component, model, auditParams);
                }
            }
        });
        this.dialog.show();
    }

    private boolean afterAntiAudit(Component component, IObjectValue model, Map<String, String> auditParams) throws Exception {
        boolean antiAudit = false;
        int re = MsgBox.showConfirm2((String)(this.getMessageStr("com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", "unAuditIdea") + model.getString("name") + this.getMessageStr("com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", "bgForm")));
        if (re == 1 || re == 2) {
            return antiAudit;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGFORM_PROCESSUI", (Object)component);
        uiContext.put((Object)"BGFORM_AUDIT_TYPE", (Object)"BGFORM_ANTIAUDIT");
        uiContext.put((Object)"AUDIT_PARAM", auditParams);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgFormAntiAuditIdeaEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (uiWindow != null && uiWindow.getUIObject() instanceof BgFormAntiAuditIdeaEditUI && !((BgFormAntiAuditIdeaEditUI)uiWindow.getUIObject()).isCancel()) {
            antiAudit = true;
            ((CoreUI)component).getUIWindow().close();
            MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)((CoreUI)component).getUIContext().get("Owner"));
        }
        return antiAudit;
    }

    protected Map<String, String> getUnAuditParams(String bgSchemeId, String userId, String auditOrgId, boolean isReqMutex, boolean isRecordCourseComment, boolean isFilterSubmitIdea) {
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_SCHEME_ID", bgSchemeId);
        auditParams.put("AUDIT_ORGUNIT_ID", auditOrgId);
        auditParams.put("AUDIT_USER_ID", userId);
        auditParams.put("AUDIT_DATA_STATE", String.valueOf(1));
        auditParams.put("AUDIT_BILL_STATE", String.valueOf(1));
        auditParams.put("AUDIT_PARAM", String.valueOf(1));
        if (isReqMutex) {
            auditParams.put("CHECK_MUTEX", String.valueOf(isReqMutex));
        }
        auditParams.put("CHECK_REPORT", String.valueOf(false));
        auditParams.put("CHECK_EXAMINE", String.valueOf(false));
        auditParams.put("CHECK_WORKFLOW", String.valueOf(true));
        if (isRecordCourseComment) {
            auditParams.put("AUDIT_COURSE_COMMENT_STATE", BgCourseOperateEnum.UnConfirm.getName());
        }
        if (isFilterSubmitIdea && !isRecordCourseComment) {
            auditParams.put("FILTER_BATCH_ANTIAUDIT_SUBMITIDEA", String.valueOf(true));
        }
        return auditParams;
    }

    public static boolean showCheckResult(Component component, BOSUuid bgOrgViewId, List<String> billIds, Object _result) throws Exception {
        return BgFormAuditClientHelper.showCheckResult(component, bgOrgViewId, billIds, _result, false, false);
    }

    public static boolean showCheckResult(Component component, BOSUuid bgOrgViewId, List<String> billIds, Object _result, boolean isConfirm, boolean isRoll) throws Exception {
        boolean check = false;
        if (component == null || billIds == null || !(_result instanceof Map)) {
            return check;
        }
        Map result = (Map)_result;
        if (result != null && !result.isEmpty()) {
            BgFormAuditClientHelper.showReportCheck(component, result);
            boolean examineCheck = BgFormAuditClientHelper.showBgExamineCheck(result, bgOrgViewId, billIds);
            StringBuffer context = new StringBuffer();
            int errorSize = 0;
            errorSize += BgFormAuditClientHelper.processMutex(result, context);
            errorSize += BgFormAuditClientHelper.processState(result, context, null, isConfirm, isRoll);
            errorSize += BgFormAuditClientHelper.processWorkFlow(result, context);
            errorSize += BgFormAuditClientHelper.processBgTemplateSequenceSet(result, context);
            if (!examineCheck) {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"auditError"), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"checkExamineNoAudit"), (int)2);
            } else if (errorSize > 0) {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"auditError"), (String)context.toString(), (int)2);
            } else {
                check = true;
            }
        } else {
            check = true;
        }
        return check;
    }

    public static void showAuditResult(Component component, BOSUuid bgOrgViewId, List<String> billIds, Object _result, Map<String, String> auditParams, boolean isConfirm) throws Exception {
        if (!(_result instanceof Map)) {
            return;
        }
        Map result = (Map)_result;
        if (result != null && !result.isEmpty()) {
            BgFormAuditClientHelper.showReportCheck(component, result);
            boolean examineCheck = BgFormAuditClientHelper.showBgExamineCheck(result, bgOrgViewId, billIds);
            StringBuffer context = new StringBuffer();
            int succeedSize = 0;
            succeedSize = BgFormAuditClientHelper.processSucceed(result, context, auditParams);
            BgFormAuditClientHelper.processMutex(result, context);
            BgFormAuditClientHelper.processState(result, context, auditParams, isConfirm, false);
            BgFormAuditClientHelper.processWorkFlow(result, context);
            BgFormAuditClientHelper.processBgTemplateSequenceSet(result, context);
            if (!examineCheck) {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"auditError"), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"checkExamineNoAudit"), (int)2);
            } else if (context.length() > 0) {
                String title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"batchAuditSucceed");
                if (succeedSize == 0) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"batchAuditError");
                } else if (succeedSize != billIds.size()) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"batchAuditWarning");
                }
                MsgBox.showDetailAndOK((Component)component, (String)title, (String)context.toString(), (int)1);
            } else {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"auditTitle"), (String)context.toString(), (int)1);
            }
        }
    }

    public static boolean showAntiAuditCheckResult(Component component, List<String> billIds, Object _result, Map<String, String> auditParams) throws Exception {
        boolean check = false;
        if (null == component || null == billIds || !(_result instanceof Map)) {
            return check;
        }
        Map result = (Map)_result;
        if (null != result && !result.isEmpty()) {
            int errorSize = 0;
            StringBuffer context = new StringBuffer();
            errorSize += BgFormAuditClientHelper.processMutex(result, context);
            errorSize += BgFormAuditClientHelper.processState(result, context, auditParams);
            errorSize += BgFormAuditClientHelper.processWorkFlow(result, context);
            errorSize += BgFormAuditClientHelper.processParentNoEdit(result, context);
            errorSize += BgFormAuditClientHelper.processAdjust(result, context);
            errorSize += BgFormAuditClientHelper.processPastData(result, context);
            errorSize += BgFormAuditClientHelper.processDaily(result, context);
            errorSize += BgFormAuditClientHelper.processUnionData(result, context);
            errorSize += BgFormAuditClientHelper.processAudOrg(result, context, auditParams);
            errorSize += BgFormAuditClientHelper.processUnAuditOrgUnit(result, context);
            if ((errorSize += BgFormAuditClientHelper.processIsRolled(result, context)) > 0) {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"antiAuditError"), (String)context.toString(), (int)2);
            } else {
                check = true;
            }
        } else {
            check = true;
        }
        return check;
    }

    public static void showUnAuditResult(Component component, List<String> billIds, Object _result, Map<String, String> auditParams, boolean isInForm) throws Exception {
        if (!(_result instanceof Map)) {
            return;
        }
        Map result = (Map)_result;
        if (result != null && !result.isEmpty()) {
            StringBuffer context = new StringBuffer();
            int succeedSize = 0;
            succeedSize = BgFormAuditClientHelper.processSucceed(result, context, auditParams);
            BgFormAuditClientHelper.processMutex(result, context);
            BgFormAuditClientHelper.processState(result, context, auditParams);
            BgFormAuditClientHelper.processWorkFlow(result, context);
            BgFormAuditClientHelper.processParentNoEdit(result, context);
            BgFormAuditClientHelper.processAdjust(result, context);
            BgFormAuditClientHelper.processPastData(result, context);
            BgFormAuditClientHelper.processDaily(result, context);
            BgFormAuditClientHelper.processUnionData(result, context);
            BgFormAuditClientHelper.processAudOrg(result, context, auditParams);
            BgFormAuditClientHelper.processUnAuditOrgUnit(result, context);
            BgFormAuditClientHelper.processBgTemplateSequenceSet(result, context);
            BgFormAuditClientHelper.processIsRolled(result, context);
            if (context.length() > 0) {
                String title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"batchUnAuditSucceed");
                if (component.getClass().getName().toUpperCase(Locale.ENGLISH).endsWith("PROCESSUI")) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unAuditFormSucceed");
                }
                if (succeedSize == 0) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgAuditIdeaResource", (String)"antiAuditNotPass");
                } else if (succeedSize < billIds.size()) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"batchUnAuditWarning");
                }
                MsgBox.showDetailAndOK((Component)component, (String)title, (String)context.toString(), (int)1);
            } else {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"antiAuditTitle"), (String)context.toString(), (int)1);
            }
            if (isInForm && succeedSize > 0) {
                ((CoreUI)component).getUIWindow().close();
                MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)((CoreUI)component).getUIContext().get("Owner"));
            }
        }
    }

    private static int processIsRolled(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_ISROLLED")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_ISROLLED");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"antiAuditIsRolled", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processUnAuditOrgUnit(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_AUDIT_ORGUNIT")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_AUDIT_ORGUNIT");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unAuditOrgUnit", (Object[])new String[]{tmpStrs2[0], tmpStrs2[1], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processCartificateOrgUnit(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_CARTIFICATE_ORGUNIT")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_CARTIFICATE_ORGUNIT");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unCartificateOrgUnit", (Object[])new String[]{tmpStrs2[0], tmpStrs2[1], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    public static void showCourseResult(Component component, BOSUuid bgOrgViewId, List<String> billIds, Object _result, Map<String, String> auditParams) throws Exception {
        if (!(_result instanceof Map)) {
            return;
        }
        Map result = (Map)_result;
        if (result != null && !result.isEmpty()) {
            BgFormAuditClientHelper.showReportCheck(component, result);
            boolean examineCheck = BgFormAuditClientHelper.showBgExamineCheck(result, bgOrgViewId, billIds);
            StringBuffer context = new StringBuffer();
            int succeedSize = 0;
            succeedSize = BgFormAuditClientHelper.processSucceed(result, context, auditParams);
            BgFormAuditClientHelper.processMutex(result, context);
            BgFormAuditClientHelper.processState(result, context, auditParams);
            BgFormAuditClientHelper.processCourse(result, context);
            BgFormAuditClientHelper.processCourseFormType(result, context);
            BgFormAuditClientHelper.processCourseReadOnly(result, context);
            BgFormAuditClientHelper.processWorkFlow(result, context);
            BgFormAuditClientHelper.processBgTemplateSequenceSet(result, context);
            if (!examineCheck) {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"courseError"), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"checkExamineNoCourse"), (int)2);
            } else if (context.length() > 0) {
                String title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"courseSucceed");
                if (succeedSize == 0) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"courseError");
                } else if (succeedSize < billIds.size()) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"courseWarning");
                }
                MsgBox.showDetailAndOK((Component)component, (String)title, (String)context.toString(), (int)2);
            } else {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_isReport_over"), (String)context.toString(), (int)1);
            }
        }
    }

    public static void showCertificateResult(Component component, BOSUuid bgOrgViewId, List<String> billIds, Object _result, Map<String, String> auditParams, boolean isInForm) throws Exception {
        if (!(_result instanceof Map)) {
            return;
        }
        Map result = (Map)_result;
        if (result != null && !result.isEmpty()) {
            BgFormAuditClientHelper.showReportCheck(component, result);
            boolean examineCheck = BgFormAuditClientHelper.showBgExamineCheck(result, bgOrgViewId, billIds);
            StringBuffer context = new StringBuffer();
            int succeedSize = 0;
            succeedSize = BgFormAuditClientHelper.processSucceed(result, context, auditParams);
            BgFormAuditClientHelper.processMutex(result, context);
            BgFormAuditClientHelper.processState(result, context, auditParams);
            BgFormAuditClientHelper.processWorkFlow(result, context);
            if (!examineCheck) {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"certificateError"), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"checkExamineNoCertificate"), (int)1);
            } else if (context.length() > 0) {
                String title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"certificateSucceed");
                if (succeedSize == 0) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"certificateError");
                } else if (succeedSize < billIds.size()) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"certificateWarning");
                }
                MsgBox.showDetailAndOK((Component)component, (String)title, (String)context.toString(), (int)1);
            } else {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_certificate_all_over"), (String)context.toString(), (int)1);
            }
            if (isInForm && succeedSize > 0) {
                ((CoreUI)component).getUIWindow().close();
                MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)((CoreUI)component).getUIContext().get("Owner"));
            }
        }
    }

    public static void showUnCertificateResult(Component component, List<String> billIds, Object _result, Map<String, String> auditParams, boolean isInForm) throws Exception {
        if (!(_result instanceof Map)) {
            return;
        }
        Map result = (Map)_result;
        if (result != null && !result.isEmpty()) {
            StringBuffer context = new StringBuffer();
            int succeedSize = 0;
            succeedSize = BgFormAuditClientHelper.processSucceed(result, context, auditParams);
            BgFormAuditClientHelper.processMutex(result, context);
            BgFormAuditClientHelper.processState(result, context, auditParams);
            BgFormAuditClientHelper.processWorkFlow(result, context);
            BgFormAuditClientHelper.processParentNoEdit(result, context);
            BgFormAuditClientHelper.processAudOrg(result, context, auditParams);
            BgFormAuditClientHelper.processCartificateOrgUnit(result, context);
            BgFormAuditClientHelper.processUncAndBack(result, context);
            if (context.length() > 0) {
                String title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"unCertificateSucceed");
                if (succeedSize == 0) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"unCertificateError");
                } else if (succeedSize < billIds.size()) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"unCertificateWarning");
                }
                MsgBox.showDetailAndOK((Component)component, (String)title, (String)context.toString(), (int)1);
            } else {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_antiCertificate_over"), (String)context.toString(), (int)1);
            }
            if (isInForm && succeedSize > 0) {
                ((CoreUI)component).getUIWindow().close();
                MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)((CoreUI)component).getUIContext().get("Owner"));
            }
        }
    }

    public static void showBackResult(Component component, List<String> billIds, Object _result, Map<String, String> auditParams, boolean isInForm) throws Exception {
        if (!(_result instanceof Map)) {
            return;
        }
        Map result = (Map)_result;
        if (result != null && !result.isEmpty()) {
            StringBuffer context = new StringBuffer();
            int succeedSize = 0;
            succeedSize = BgFormAuditClientHelper.processSucceed(result, context, auditParams);
            BgFormAuditClientHelper.processMutex(result, context);
            BgFormAuditClientHelper.processState(result, context, auditParams);
            BgFormAuditClientHelper.processWorkFlow(result, context);
            BgFormAuditClientHelper.processParentNoEdit(result, context);
            BgFormAuditClientHelper.processUncAndBack(result, context);
            if (context.length() > 0) {
                String title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"backSucceed");
                if (succeedSize == 0) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"backError");
                } else if (succeedSize < billIds.size()) {
                    title = BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"backWarning");
                }
                MsgBox.showDetailAndOK((Component)component, (String)title, (String)context.toString(), (int)1);
            } else {
                MsgBox.showDetailAndOK((Component)component, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormCourseResource", (String)"question_back_over"), (String)context.toString(), (int)1);
            }
            if (isInForm && succeedSize > 0) {
                ((CoreUI)component).getUIWindow().close();
                MbgCHelper.getIntance().asyncRefreshListUI((CoreUI)((CoreUI)component).getUIContext().get("Owner"));
            }
        }
    }

    public static void showReportCheck(Component component, Map<String, Object> result) throws Exception {
        if (result.containsKey("CHECK_RESULT_REPORT")) {
            List nopass;
            boolean isExit = false;
            List check = (List)result.get("CHECK_RESULT_REPORT");
            if (check.size() >= 3 && check.get(3) != null) {
                isExit = true;
                UIContext uiContext = new UIContext((Object)component);
                uiContext.put((Object)"String", (Object)check.get(3).toString());
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI", (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            if (check.size() >= 3 && check.get(2) != null && (nopass = (List)check.get(2)).size() > 0) {
                MsgBox.showWarning((String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "ReportCheckError"));
            }
            if (isExit) {
                SysUtil.abort();
            }
        }
    }

    private static boolean showBgExamineCheck(Map<String, Object> result, BOSUuid bgOrgViewId, List<String> billIds) throws Exception {
        boolean examineCheck = false;
        if (result.containsKey("CHECK_RESULT_EXAMINE")) {
            List results = (List)result.get("CHECK_RESULT_EXAMINE");
            if (results != null) {
                examineCheck = MBgExamineUtils.check(results);
                MBgExamineClientUtils.getInstance().showCheckReport(results, bgOrgViewId, false, billIds);
            }
        } else {
            examineCheck = true;
        }
        return examineCheck;
    }

    private static int processSucceed(Map<String, Object> result, StringBuffer context, Map<String, String> auditParams) {
        int size = 0;
        if (result == null || context == null || auditParams == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_SUCCEED")) {
            String[] tmpStrs2 = null;
            int type = Integer.valueOf(auditParams.get("AUDIT_PARAM"));
            Map bgFormMap = (Map)result.get("CHECK_RESULT_SUCCEED");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    if (type == 0) {
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"auditSucceed", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    if (type == 1) {
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unAuditSucceed", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    if (type == 7) {
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"courseSucceed", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    if (type == 8) {
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"backSucceed", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    if (type == 9) {
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"certificateSucceed", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    if (type != 10) continue;
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unCertificateSucceed", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processState(Map<String, Object> result, StringBuffer context, Map<String, String> auditParams) {
        return BgFormAuditClientHelper.processState(result, context, auditParams, false, false);
    }

    private static int processState(Map<String, Object> result, StringBuffer context, Map<String, String> auditParams, boolean isConfirm, boolean isRoll) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        boolean isUnAudit = false;
        boolean isReport = false;
        boolean isUnCerit = false;
        boolean isCerit = false;
        boolean courseAudit = false;
        boolean isBack = false;
        if (auditParams != null && auditParams.get("AUDIT_BILL_STATE") != null) {
            if (String.valueOf(6).equals(auditParams.get("AUDIT_BILL_STATE"))) {
                isRoll = true;
            } else if (String.valueOf(9).equals(auditParams.get("AUDIT_PARAM"))) {
                isCerit = true;
            } else if (String.valueOf(10).equals(auditParams.get("AUDIT_PARAM"))) {
                isUnCerit = true;
            } else if (auditParams.get("AUDIT_BILL_STATE").equals(String.valueOf(40))) {
                isReport = true;
            } else if (String.valueOf(0).equals(auditParams.get("AUDIT_PARAM")) && auditParams.get("AUDIT_BILL_STATE").equals(String.valueOf(2))) {
                if (isConfirm) {
                    courseAudit = true;
                }
            } else if (String.valueOf(8).equals(auditParams.get("AUDIT_PARAM"))) {
                isBack = true;
            } else {
                isUnAudit = auditParams.get("AUDIT_BILL_STATE").equals(String.valueOf(1));
            }
        }
        if (result.containsKey("CHECK_RESULT_STATE")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_STATE");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    if (isCerit) {
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"certificateByState", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    if (courseAudit) {
                        if (BgParamCHelper.isNeedCertificate()) {
                            context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"courseAuditByState", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                            continue;
                        }
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"courseAuditByState1", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    if (isUnCerit) {
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unCertificateByState", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    if (isReport) {
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"reportByState", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    if (isBack) {
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"backByState", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    if (isRoll) {
                        if (auditParams != null && String.valueOf(6).equals(auditParams.get("AUDIT_BILL_STATE"))) {
                            context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"rollUnAuditByState", (Object[])new String[]{tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                            continue;
                        }
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"rollAuditByState", (Object[])new String[]{tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)(isUnAudit ? "unAuditByState" : "auditByState"), (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processParentNoEdit(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_PARENT_NOEDIT")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_PARENT_NOEDIT");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unAuditByParentState", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2], tmpStrs2[5]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processCourseFormType(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_COURSE_FORMTYPE")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_COURSE_FORMTYPE");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"courseSpecialForm", (Object[])new String[]{tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processCourseReadOnly(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_COURSE_READONLY")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_COURSE_READONLY");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"courseReadOnly", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processBgTemplateSequenceSet(Map<String, Object> result, StringBuffer context) {
        int size;
        block10: {
            block9: {
                size = 0;
                if (result == null || context == null) {
                    return size;
                }
                if (!result.containsKey("CHECK_RESULT_BGTEMPLATE_SEQUENCESET")) break block9;
                String[] tmpStrs2 = null;
                Map bgFormMap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET");
                if (bgFormMap == null) break block10;
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    String otherMsg = tmpStrs2[5];
                    if (otherMsg.indexOf("#") > 0) {
                        String[] otherStr = otherMsg.split("#");
                        Object[] msgArr = new String[2 + otherStr.length];
                        msgArr[0] = tmpStrs2[4];
                        msgArr[1] = tmpStrs2[0];
                        for (int i = 0; i < otherStr.length; ++i) {
                            msgArr[i + 2] = otherStr[i];
                        }
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"checkBgTemplate_Sequence", (Object[])msgArr) + "\r\n");
                        continue;
                    }
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"auditByBgTemplateSequenceSet", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[5]}) + "\r\n");
                }
                break block10;
            }
            if (result.containsKey("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX")) {
                String[] tmpStrs3 = null;
                Map bgFormMap = (Map)result.get("CHECK_RESULT_BGTEMPLATE_SEQUENCESET_EX");
                if (bgFormMap != null) {
                    size = bgFormMap.size();
                    for (String[] tmpStrs3 : bgFormMap.values()) {
                        String otherMsg = tmpStrs3[5];
                        if (otherMsg.indexOf("#") > 0) {
                            String[] otherStr = otherMsg.split("#");
                            Object[] msgArr = new String[2 + otherStr.length];
                            msgArr[0] = tmpStrs3[4];
                            msgArr[1] = tmpStrs3[0];
                            for (int i = 0; i < otherStr.length; ++i) {
                                msgArr[i + 2] = otherStr[i];
                            }
                            context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"checkBgTemplate_Sequence_Ex", (Object[])msgArr) + "\r\n");
                            continue;
                        }
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"auditByBgTemplateSequenceSet", (Object[])new String[]{tmpStrs3[4], tmpStrs3[0], tmpStrs3[5]}) + "\r\n");
                    }
                }
            }
        }
        return size;
    }

    private static int processCourse(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_COURSE")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_COURSE");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"courseByAtCtreateOrgUnit", (Object[])new String[]{tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processWorkFlow(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_WORKFLOW")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_WORKFLOW");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"auditByWorkFlow", (Object[])new String[]{tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processUncAndBack(Map<String, Object> result, StringBuffer context) {
        int size;
        block6: {
            block5: {
                size = 0;
                if (result == null || context == null) {
                    return size;
                }
                if (!result.containsKey("CHECK_RESULT_BACK_STATE")) break block5;
                String[] tmpStrs2 = null;
                Map bgFormMap = (Map)result.get("CHECK_RESULT_BACK_STATE");
                if (bgFormMap == null) break block6;
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"backByParentState", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2], tmpStrs2[5]}) + "\r\n");
                }
                break block6;
            }
            if (result.containsKey("CHECK_RESULT_UNCARTIFICATE_STATE")) {
                String[] tmpStrs3 = null;
                Map bgFormMap = (Map)result.get("CHECK_RESULT_UNCARTIFICATE_STATE");
                if (bgFormMap != null) {
                    size = bgFormMap.size();
                    for (String[] tmpStrs3 : bgFormMap.values()) {
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unCertificateByParentState", (Object[])new String[]{tmpStrs3[4], tmpStrs3[0], tmpStrs3[2], tmpStrs3[5]}) + "\r\n");
                    }
                }
            }
        }
        return size;
    }

    private static int processAdjust(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_ADJUST")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_ADJUST");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unAuditByAdjust", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processDaily(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_DAILY")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_DAILY");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unAuditByDaily", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processPastData(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_PASTDATA")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_PASTDATA");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unAuditByPastData", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processUnionData(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_UNION")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_UNION");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"unAuditByUnion", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processMutex(Map<String, Object> result, StringBuffer context) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_MUTEX")) {
            String[] tmpStrs2 = null;
            Map bgFormMap = (Map)result.get("CHECK_RESULT_MUTEX");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"auditByMutex", (Object[])new String[]{tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }

    private static int processAudOrg(Map<String, Object> result, StringBuffer context, Map<String, String> auditParams) {
        int size = 0;
        if (result == null || context == null) {
            return size;
        }
        if (result.containsKey("CHECK_RESULT_AUDORG")) {
            String[] tmpStrs2 = null;
            int type = Integer.valueOf(auditParams.get("AUDIT_PARAM"));
            Map bgFormMap = (Map)result.get("CHECK_RESULT_AUDORG");
            if (bgFormMap != null) {
                size = bgFormMap.size();
                for (String[] tmpStrs2 : bgFormMap.values()) {
                    if (type == 1) {
                        context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"auditByParent", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                        continue;
                    }
                    if (type != 10) continue;
                    context.append(BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"certificateByParent", (Object[])new String[]{tmpStrs2[4], tmpStrs2[0], tmpStrs2[2]}) + "\r\n");
                }
            }
        }
        return size;
    }
}

