/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.log.client.ExcelFileFilter;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.client.worktable.WorkTableID;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MbgViewlistMeasureUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgFormExportBaseUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.MbgExportThreadProcessor;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgFormExportUtils
extends BgFormExportBaseUtils {
    private static final Logger logger = CoreUIObject.getLogger(BgFormExportUtils.class);

    public static KDSBook exportViewListExcelFile(BgFormInfo _bgFormInfo, MbgExportThreadProcessor threadProcessor) throws Exception {
        Map tmpMap = BgFormExportUtils.getViewListExcelExportParams(_bgFormInfo, threadProcessor);
        return BgNFCHelper.exportExcel(tmpMap);
    }

    public static Book exportViewListExcelFile2007(BgFormInfo _bgFormInfo, MbgExportThreadProcessor threadProcessor) throws Exception {
        Map tmpMap = BgFormExportUtils.getViewListExcelExportParams(_bgFormInfo, threadProcessor);
        Book _book = BgNFCHelper.exportExcel2007(tmpMap);
        BgNFSHelper.stopBookProtection(_book);
        List sheetName = (List)tmpMap.get("EXPORT_SHEETNAME");
        int sheetSize = _book.getSheetCount();
        for (int sheetIndex = sheetSize - 1; sheetIndex >= 0; --sheetIndex) {
            BgNFSHelper.stopSheetProtection(_book.getSheet(sheetIndex).getSheetOption());
            if (_book.getSheet(sheetIndex).isHide()) continue;
            _book.getSheet(sheetIndex).setName((String)sheetName.get(sheetSize - sheetIndex - 1));
        }
        BgFormExportUtils.setSheetHide(null, _bgFormInfo, _book);
        return _book;
    }

    private static Map getViewListExcelExportParams(BgFormInfo _bgFormInfo, MbgExportThreadProcessor threadProcessor) throws Exception {
        Book book = threadProcessor.getBook(_bgFormInfo.getId().toString());
        if (book != null) {
            BgFormExportUtils.setSheetHide(null, _bgFormInfo, book);
        }
        MbgViewlistMeasureUnitHelper measureHelper = BgFormExportUtils.getViewlistMeasureUnitHelper(_bgFormInfo, threadProcessor);
        return BgFormExportUtils.getViewListExcelExportParams(book, measureHelper);
    }

    private static MbgViewlistMeasureUnitHelper getViewlistMeasureUnitHelper(BgFormInfo _bgFormInfo, MbgExportThreadProcessor threadProcessor) throws BOSException {
        Map elementObjMap = BgElementHelper.getElementoObjMap();
        TemplateStyleInfo templateStyle = threadProcessor.getTemplateStyle(_bgFormInfo);
        MbgViewlistMeasureUnitHelper viewlistMeasureHelper = new MbgViewlistMeasureUnitHelper(threadProcessor.getAccountDataTypeMap(), templateStyle, elementObjMap);
        return viewlistMeasureHelper;
    }

    public static void verify(CoreUI coreUI, KDTextField txtFilepath) throws Exception {
        if (StringUtils.isEmpty((String)txtFilepath.getText())) {
            txtFilepath.requestFocus();
            MsgBox.showWarning((Component)coreUI, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "selectOutFilepath"));
            SysUtil.abort();
        } else {
            File file = new File(txtFilepath.getText());
            if (!file.isDirectory()) {
                txtFilepath.requestFocus();
                MsgBox.showWarning((Component)coreUI, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "errorFilepath"));
                SysUtil.abort();
            }
        }
    }

    public static void btnSelectPath_actionPerformed(CoreUI coreUI, KDTextField txtFilepath, ActionEvent e) throws Exception {
        String path = txtFilepath.getText();
        KDFileChooser fc = new KDFileChooser();
        fc.setFileSelectionMode(1);
        fc.setDialogTitle(BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgIEResource", "export"));
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setCurrentDirectory(new File(path));
        if (fc.showSaveDialog((Component)coreUI) == 0) {
            File file = fc.getSelectedFile();
            txtFilepath.setText(file.getPath());
        }
    }

    public static Map getExportBgFormMap(Map uiContext) throws BOSException {
        LinkedHashMap _orgUnitMap = new LinkedHashMap();
        Map<String, String[]> _tmpMap = null;
        ArrayList<String> bgFormIds = new ArrayList<String>();
        if (uiContext.containsKey("WORKTABLEID_All") && uiContext.get("WORKTABLEID_All") instanceof List) {
            List workTableIds = (List)uiContext.get("WORKTABLEID_All");
            if (workTableIds != null && !workTableIds.isEmpty()) {
                for (int i = 0; i < workTableIds.size(); ++i) {
                    bgFormIds.add(((WorkTableID)workTableIds.get(i)).getId());
                }
            }
        } else if (uiContext.containsKey("ID") && uiContext.get("ID") != null) {
            bgFormIds.add(String.valueOf(uiContext.get("ID")));
        }
        if (!bgFormIds.isEmpty()) {
            int index;
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("orgUnit.id");
            evi.setSelector(sic);
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(bgFormIds), CompareType.INCLUDE));
            BgFormCollection colls = BgFormFactory.getRemoteInstance().getBgFormCollection(evi);
            HashMap<String, BgFormInfo> sortMap = new HashMap<String, BgFormInfo>();
            BgFormInfo info = null;
            String[] _bgFormInfo = null;
            if (colls != null && !colls.isEmpty()) {
                for (index = 0; index < colls.size(); ++index) {
                    info = colls.get(index);
                    sortMap.put(info.getId().toString(), info);
                }
            }
            for (index = 0; index < bgFormIds.size(); ++index) {
                if (!sortMap.containsKey(bgFormIds.get(index))) continue;
                info = (BgFormInfo)sortMap.get(bgFormIds.get(index));
                String bgFormId = info.getId().toString();
                String number = info.getNumber().toString();
                String name = info.getName().toString();
                String orgUnitId = info.getOrgUnit().getId().toString();
                if (_orgUnitMap.containsKey(orgUnitId)) {
                    _tmpMap = (Map)_orgUnitMap.get(orgUnitId);
                } else {
                    _tmpMap = new LinkedHashMap();
                    _orgUnitMap.put(orgUnitId, _tmpMap);
                }
                _bgFormInfo = new String[]{bgFormId, number, name};
                if (_tmpMap == null) continue;
                _tmpMap.put(bgFormId, _bgFormInfo);
            }
        }
        return _orgUnitMap;
    }
}

