/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.client.designer.IDisplayValueProvider;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import java.util.GregorianCalendar;

public class BgItemDisplayProvider
implements IDisplayValueProvider {
    public Object getDisplayValue(Cell cell, int viewMode) {
        if (viewMode == 0 && !BgNFSHelper.checkIsEmptyValue(cell)) {
            if (cell.hasFormula()) {
                return "";
            }
            if (cell.getValue().getValue() instanceof GregorianCalendar) {
                return cell.getText();
            }
            String _text = cell.getText();
            if (!StringUtils.isEmpty((String)_text) && ("#DIV/0!".equals(_text) || _text.indexOf("#BAD FUNCTION") >= 0)) {
                Object obj = cell.getSheet().getBook().getUserObjectValue("ERRORHANDLER");
                if (obj instanceof ReportCalculateErrorProvider) {
                    ReportCalculateErrorProvider rcep = (ReportCalculateErrorProvider)obj;
                    if ("#DIV/0!".equals(_text)) {
                        return rcep.getZeroDivDisplayAs();
                    }
                    if (_text.indexOf("#BAD FUNCTION") >= 0) {
                        return rcep.getExceptionReplacer();
                    }
                }
                return _text;
            }
        }
        if (viewMode == 10) {
            ItemFormula item = (ItemFormula)cell.getUserObjectValue("ITEM");
            if (item == null) {
                if (cell.hasFormula()) {
                    return "";
                }
                return null;
            }
            String formula = item.getFormula();
            if (!StringUtils.isEmpty((String)formula)) {
                return BgNFSHelper.getDisplayFormula(formula, null);
            }
            return null;
        }
        return null;
    }
}

