/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.OrderObject;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormEntryFactory;
import com.kingdee.eas.ma.mbg.BgFormFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgGatherInfo;
import com.kingdee.eas.ma.mbg.BgNFormFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.client.BgDecGatherProcessDialogUI;
import com.kingdee.eas.ma.mbg.client.BgDecomposeGatherReportUI;
import com.kingdee.eas.ma.mbg.client.BgMultiDecomposeGatherUI;
import com.kingdee.eas.ma.mbg.client.utils.MBGViewListFormClientHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgMultiDecomposeGatherHelper {
    public static final String PROCESSTYPE = "PROCESSTYPE";
    public static final String ORGUNITIDSET = "ORGUNITIDSET";
    public static final String SHEETNAME = "SHEETNAME";
    public static final String ORGUNITINFOS = "ORGUNITINFOS";
    public static final String ISCALCBIZ = "ISCALCBIZ";
    public static final String ISCLEAREXPRESSION = "ISCLEAREXPRESSION";
    protected IUIObject uiObj = null;
    private BgFormInfo bgFormInfo;
    private List<String> ids;
    protected BgSchemeDimensionHelper schemeHelper = null;
    private boolean isAdjust;
    private static String MBG_RESOURCE = "com.kingdee.eas.ma.mbg.MBGFormResource";
    private CommonQueryDialog dialog = null;
    private Map<String, BigDecimal> otherMutilGatherValue = new HashMap<String, BigDecimal>();

    public IUIObject getUiObj() {
        return this.uiObj;
    }

    public void setUiObj(IUIObject uiObj) {
        this.uiObj = uiObj;
    }

    public BgFormInfo getBgFormInfo() {
        return this.bgFormInfo;
    }

    public void setBgFormInfo(BgFormInfo bgFormInfo) {
        this.bgFormInfo = bgFormInfo;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        return this.schemeHelper;
    }

    public void setSchemeHelper(BgSchemeDimensionHelper schemeHelper) {
        this.schemeHelper = schemeHelper;
    }

    public boolean isAdjust() {
        return this.isAdjust;
    }

    public void setAdjust(boolean adjust) {
        this.isAdjust = adjust;
    }

    private BgMultiDecomposeGatherUI getDialogUI() throws Exception {
        BgMultiDecomposeGatherUI gatherUI = new BgMultiDecomposeGatherUI(this.getUiObj());
        gatherUI.getUIContext().put("BGFORMINFO", this.getBgFormInfo());
        gatherUI.getUIContext().put("ISSINGLEFORM", false);
        return gatherUI;
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        this.dialog = new CommonQueryDialog();
        BgMultiDecomposeGatherUI multiDecomposeGatherUI = this.getDialogUI();
        this.dialog.setOwner((Component)((CoreUI)this.getUiObj()));
        this.dialog.setParentUIClassName(multiDecomposeGatherUI.getMetaDataPK().getFullName());
        this.dialog.setEntityViewInfo(new EntityViewInfo());
        this.dialog.setQueryObjectPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.ma.mbg", "BgFormListQuery"));
        this.dialog.setWidth(800);
        this.dialog.setHeight(525);
        this.dialog.addUserPanel((KDPanel)multiDecomposeGatherUI);
        this.dialog.setTitle(multiDecomposeGatherUI.getUITitle());
        this.dialog.setShowFilter(false);
        this.dialog.setShowSorter(false);
        this.dialog.setDisVisiableDefaultView(true);
        return this.dialog;
    }

    public CommonQueryDialog getDialog() {
        try {
            this.dialog = this.getCommonQueryDialog();
        }
        catch (Exception e) {
            SysUtil.abort();
        }
        return this.dialog;
    }

    public Map<String, Object> showGatherUI() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if (this.getDialog().show()) {
            BgMultiDecomposeGatherUI userPanel = (BgMultiDecomposeGatherUI)this.dialog.getUserPanel(0);
            boolean calcBiz = userPanel.isCalcBiz();
            boolean clearExpression = userPanel.isClearExpression();
            String[] sheetNames = userPanel.getSheetNames();
            Map<BgProcessEnum, Set<String>> selectOrgUnitIds = userPanel.getSelectOrgUnitIds();
            Map<String, BgOrgUnitInfo> orgUnitInfos = userPanel.getOrgUnitInfos();
            for (Map.Entry<BgProcessEnum, Set<String>> entry : selectOrgUnitIds.entrySet()) {
                BgProcessEnum processEnum = entry.getKey();
                Set<String> orgIds = entry.getValue();
                HashMap<String, Object> childMap = new HashMap<String, Object>();
                childMap.put(ISCALCBIZ, calcBiz);
                childMap.put(ISCLEAREXPRESSION, clearExpression);
                childMap.put(PROCESSTYPE, (Object)processEnum);
                childMap.put(SHEETNAME, sheetNames);
                childMap.put(ORGUNITIDSET, orgIds);
                childMap.put(ORGUNITINFOS, this.toOrgUnitInfos(orgIds, orgUnitInfos));
                paramMap.put(processEnum.getName(), childMap);
            }
        }
        return paramMap;
    }

    private List<BgOrgUnitInfo> toOrgUnitInfos(Set<String> orgIds, Map<String, BgOrgUnitInfo> orgUnitInfos) {
        ArrayList<BgOrgUnitInfo> bgOrgUnitInfos = new ArrayList<BgOrgUnitInfo>();
        for (String orgId : orgIds) {
            if (null == orgUnitInfos || !orgUnitInfos.containsKey(orgId)) continue;
            bgOrgUnitInfos.add(orgUnitInfos.get(orgId));
        }
        return bgOrgUnitInfos;
    }

    public void gather() throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setSelector(BgNFSHelper.getSelectors());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(this.ids), CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        BgFormCollection bgForms = BgFormFactory.getRemoteInstance().getBgFormCollection(viewInfo);
        this.setBgFormInfo(bgForms.get(0));
        Map<String, Object> paramMap = this.showGatherUI();
        if (paramMap.isEmpty()) {
            return;
        }
        UIContext map = new UIContext((Object)this.getUiObj());
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgDecGatherProcessDialogUI.class.getName(), (Map)map);
        if (window != null && window.getUIObject() instanceof BgDecGatherProcessDialogUI) {
            BgDecGatherProcessDialogUI ui = (BgDecGatherProcessDialogUI)window.getUIObject();
            this.initParameterValue(ui, bgForms, paramMap);
            ui.init();
            window.show();
        }
    }

    private void initParameterValue(BgDecGatherProcessDialogUI ui, BgFormCollection bgForms, Map<String, Object> paramMap) {
        if (ui == null || bgForms == null || paramMap == null) {
            return;
        }
        int paramCount = 4;
        Class[] cla = new Class[]{BgFormInfo.class, Map.class, BgSchemeDimensionHelper.class, Boolean.TYPE};
        ui.setUITitle(EASResource.getString((String)MBG_RESOURCE, (String)"gatherTitle"));
        ui.setInvokeClass(this.getClass().getName());
        ui.setInvokeMethod("invoke");
        ui.setInvokeMethodParmeterType(cla);
        ui.setShowTableMessage(true);
        ui.setTableReportUI(BgDecomposeGatherReportUI.class.getName());
        ArrayList<Object[]> temp = new ArrayList<Object[]>();
        int in = bgForms.size();
        for (int i = 0; i < in; ++i) {
            Object[] parameterItem = new Object[]{bgForms.get(i), paramMap, this.schemeHelper, this.isAdjust};
            temp.add(parameterItem);
        }
        Object[][] parameterArray = (Object[][])temp.toArray((T[])new Object[0][0]);
        ui.setInvokeMethodParmeterValue(parameterArray);
        ui.setCountSum(parameterArray.length);
    }

    public Object[] invoke(BgFormInfo info, Map<String, Object> paramMap, BgSchemeDimensionHelper schemeHelper, boolean isAdjust) throws Exception {
        Object[] obj = new Object[]{"", this.runGather(info, paramMap, schemeHelper, isAdjust)};
        return obj;
    }

    private List<Map<OrderObject, String>> runGather(BgFormInfo info, Map<String, Object> paramMap, BgSchemeDimensionHelper schemeHelper, boolean isAdjust) throws Exception {
        Map sourceDataMap;
        ArrayList<Map<OrderObject, String>> messages = new ArrayList<Map<OrderObject, String>>();
        if (info == null || paramMap == null) {
            return messages;
        }
        BgTemFormTypeEnum formType = info.getBgTemplate().getFormType();
        this.setSchemeHelper(schemeHelper);
        this.setAdjust(isAdjust);
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)formType)) {
            this.getErrorMsg(messages, info, EASResource.getString((String)MBG_RESOURCE, (String)"gather.bgFormType.error"));
            return messages;
        }
        if (this.isAdjust()) {
            if (!BgFormStateEnum.Adjusted.equals((Object)info.getState())) {
                this.getErrorMsg(messages, info, EASResource.getString((String)MBG_RESOURCE, (String)"gather.bgFormState1.error"));
                return messages;
            }
        } else if (!BgFormStateEnum.Edited.equals((Object)info.getState()) && !BgFormStateEnum.Back.equals((Object)info.getState())) {
            this.getErrorMsg(messages, info, EASResource.getString((String)MBG_RESOURCE, (String)"gather.bgFormState.error"));
            return messages;
        }
        if (!BgProcessEnum.C04.equals((Object)info.getProcessType())) {
            this.getErrorMsg(messages, info, EASResource.getString((String)MBG_RESOURCE, (String)"gather.bgFormProcessType.error"));
            return messages;
        }
        IMbgViewBase view = info.getView(null, info.getBgScheme());
        if (BgTemFormTypeEnum.VIEWLIST.equals((Object)info.getBgTemplate().getFormType())) {
            Map result = MBGViewListFormFacadeFactory.getRemoteInstance().loadViewManagersForProvider(info, null, schemeHelper.getBgOrgViewId(), (MbgViewListManager)view, null, null, false);
            view = (IMbgViewBase)result.get("dimensino.member");
            BgFormInfo clone = (BgFormInfo)info.clone();
            for (Map map : paramMap.values()) {
                clone.setProcessType((BgProcessEnum)((Object)map.get(PROCESSTYPE)));
                Map vilewListData = MBGViewListFormFacadeFactory.getRemoteInstance().synchronizationMember(clone, clone.getOrgUnit().getId().toString(), (MbgViewListManager)view, (Set)map.get(ORGUNITIDSET));
                view = (MbgViewListManager)vilewListData.get("dimensino.member");
            }
            HashMap<String, MbgViewListManager> hashMap = new HashMap<String, MbgViewListManager>();
            hashMap.put(clone.getOrgUnit().getId().toString(), (MbgViewListManager)view);
            BgFormEntryFactory.getRemoteInstance().saveDimensionData(info.getId().toString(), hashMap);
            HashMap dimensionManagerMap = new HashMap();
            ArrayList<MbgViewListDimensionManager> dimensionManagers = new ArrayList<MbgViewListDimensionManager>();
            List<? extends IMbgSheetBase> sheetManagers = view.getSheetManagers();
            int in = sheetManagers.size();
            for (int i = 0; i < in; ++i) {
                dimensionManagers.add(((MbgViewListSheetManager)sheetManagers.get(i)).getDimensionManager());
            }
            dimensionManagerMap.put(info.getOrgUnit().getId().toString(), dimensionManagers);
            sourceDataMap = MBGFormFacadeFactory.getRemoteInstance().queryViewData((IObjectValue)info, dimensionManagerMap, info.getDataType(), true, BOSUuid.read((String)schemeHelper.getBgOrgViewId()), false, null, false);
        } else {
            sourceDataMap = BgFormFactory.getRemoteInstance().getBgDataInfo(info, null);
        }
        Map oldSourceDataMap = (Map)BgAnalyseHelper.clone(sourceDataMap);
        ArrayList<BgGatherInfo> gatherInfos = new ArrayList<BgGatherInfo>();
        for (Map map : paramMap.values()) {
            this.runProcessTypeGather(info, view, map, sourceDataMap, gatherInfos);
        }
        BgFormFacadeFactory.getRemoteInstance().saveGatherInfos(gatherInfos);
        if (this.isAdjust()) {
            Map<String, Map<String, BgAdjustFormDiversityData>> map = this.convertToAdjustMap(oldSourceDataMap, sourceDataMap);
            if (BgTemFormTypeEnum.VIEWLIST.equals((Object)info.getBgTemplate().getFormType())) {
                BgAdjustFacadaFactory.getRemoteInstance().saveAndGetViewSheet((IObjectValue)info, info.getOrgUnit().getId().toString(), map);
            } else {
                BgNFormFacadeFactory.getRemoteInstance().savaAdjustData((IObjectValue)info, map.get(info.getOrgUnit().getId().toString()));
            }
        } else if (sourceDataMap != null && !sourceDataMap.isEmpty()) {
            MBGFormFacadeFactory.getRemoteInstance().saveBgData(info.getId().toString(), sourceDataMap, true);
        }
        return null;
    }

    private Map<String, Map<String, BgAdjustFormDiversityData>> convertToAdjustMap(Map<String, Map<String, BgNViewDataInfo>> oldSourceDataMap, Map<String, Map<String, BgNViewDataInfo>> targetDataMap) {
        HashMap<String, Map<String, BgAdjustFormDiversityData>> adjustMap = new HashMap<String, Map<String, BgAdjustFormDiversityData>>();
        for (Map.Entry<String, Map<String, BgNViewDataInfo>> targetDataEntry : targetDataMap.entrySet()) {
            String orgId = targetDataEntry.getKey();
            Map<String, BgNViewDataInfo> targetDataEntryValue = targetDataEntry.getValue();
            Map<String, BgNViewDataInfo> sourceDataEntryValue = oldSourceDataMap.get(orgId);
            adjustMap.put(orgId, new HashMap());
            for (Map.Entry<String, BgNViewDataInfo> dataInfoEntry : targetDataEntryValue.entrySet()) {
                String formula = dataInfoEntry.getKey();
                Map adjustFormDiversityDataMap = (Map)adjustMap.get(orgId);
                BgNViewDataInfo newValue = dataInfoEntry.getValue();
                if (newValue == null) continue;
                if (sourceDataEntryValue == null || sourceDataEntryValue.isEmpty()) {
                    if (newValue.getBudgetValueNoDef() == null || newValue.getBudgetValueNoDef().compareTo(BigDecimal.ZERO) == 0) continue;
                    this.createDivInfo(formula, newValue.getBudgetValueNoDef(), BigDecimal.ZERO, adjustFormDiversityDataMap);
                    continue;
                }
                if (sourceDataEntryValue.containsKey(formula)) {
                    String formulaNotVe = formula.split("_")[0];
                    if (adjustFormDiversityDataMap.containsKey(formulaNotVe)) {
                        this.updateDivInfo(formulaNotVe, newValue.getBudgetValue(), adjustFormDiversityDataMap);
                        continue;
                    }
                    this.createDivInfo(formula, newValue.getBudgetValueNoDef(), sourceDataEntryValue.get(formula).getValue(), adjustFormDiversityDataMap);
                    continue;
                }
                this.createDivInfo(formula, newValue.getBudgetValueNoDef(), BigDecimal.ZERO, adjustFormDiversityDataMap);
            }
        }
        return adjustMap;
    }

    private void updateDivInfo(String formulaStr, BigDecimal newValue, Map adjustMap) {
        BgAdjustFormDiversityData divData = (BgAdjustFormDiversityData)adjustMap.get(formulaStr);
        if (divData != null) {
            divData.setNewValue(newValue);
            divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        }
    }

    private void runProcessTypeGather(BgFormInfo info, IMbgViewBase view, Map<String, Object> childParamMap, Map sourceDataMap, ArrayList<BgGatherInfo> gatherInfos) throws Exception {
        DimensionCacheHelper cacheHelper = this.getCacheHelper(info);
        if (view == null) {
            return;
        }
        IBgDimensionManagerBase dimManager = null;
        BgDimensionBaseInfo dimension = null;
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            dimManager = view.getSheetManagers().get(s).getDimensionManager();
            for (int d = 0; d < dimManager.getPageDisplayDimension().size(); ++d) {
                if (!(dimManager.getPageDisplayDimension().get(d) instanceof BgDimensionBaseInfo)) continue;
                dimension = (BgDimensionBaseInfo)dimManager.getPageDisplayDimension().get(d);
                dimension.setLayout("col");
                dimManager.getColDisplayDimension().add(dimension);
                if (!(dimManager instanceof MbgViewListDimensionManager)) continue;
                MbgViewListDimensionManager viewDimManager = (MbgViewListDimensionManager)dimManager;
                for (int r = 0; r < viewDimManager.getColumns().size(); ++r) {
                    if (!(viewDimManager.getColumns().get(r) instanceof MbgViewListRowCol)) continue;
                    ((MbgViewListRowCol)viewDimManager.getColumns().get(r)).getDimensions().add(((MbgViewListDimensionInfo)dimension).clone());
                }
            }
            dimManager.getPageDisplayDimension().clear();
        }
        BgMultiDecomposeGatherHelper.filterBudgetScenario(view, cacheHelper);
        Map<String, Map<String, BgNViewDataInfo>> bgDataMap = this.queryData(info, view, childParamMap);
        this.replaceBgDataMap(info, bgDataMap, view, childParamMap, cacheHelper, sourceDataMap, gatherInfos);
        boolean isClearExpression = Boolean.parseBoolean(childParamMap.containsKey(ISCLEAREXPRESSION) ? childParamMap.get(ISCLEAREXPRESSION).toString() : "");
        if (this.isAdjust() && !BgTemFormTypeEnum.VIEWLIST.equals((Object)info.getBgTemplate().getFormType())) {
            this.fillData(info, sourceDataMap, childParamMap, cacheHelper);
        } else if (!this.isAdjust() && isClearExpression) {
            this.clearExpression(info);
        }
    }

    protected final void clearExpression(BgFormInfo info) throws Exception {
        Book book = info.getBook();
        Sheet sheet = null;
        Cell cell = null;
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell) || !BgNFSHelper.checkHasExpression(cell)) continue;
                    BgNFSHelper.clearExpression(cell);
                }
            }
        }
        info.setBook(book);
        BgFormFactory.getRemoteInstance().save((CoreBaseInfo)info);
    }

    protected final void fillData(BgFormInfo info, Map<String, Map<String, BgNViewDataInfo>> virtualBgDataMap, Map<String, Object> paramMap, DimensionCacheHelper cacheHelper) throws Exception {
        Book book = info.getBook();
        Sheet sheet = null;
        Cell cell = null;
        ItemFormula formula = null;
        String currVersionNumber = info.getBgVersion().getNumber();
        String currOrgUnitId = info.getOrgUnit().getId().toString();
        String versionNumber = null;
        String cellOrgId = null;
        BgNViewDataInfo bgData = null;
        boolean isClearExpression = Boolean.parseBoolean(paramMap.containsKey(ISCLEAREXPRESSION) ? paramMap.get(ISCLEAREXPRESSION).toString() : "");
        for (int s = 0; s < book.getSheetCount(); ++s) {
            sheet = book.getSheet(s);
            for (int rowIndex = 0; rowIndex <= sheet.getMaxRowIndex(); ++rowIndex) {
                for (int colIndex = 0; colIndex <= sheet.getMaxColIndex(); ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    formula = BgNFSHelper.getItemFormula(cell);
                    if (isClearExpression && BgNFSHelper.checkHasFormulaOfCell(cell) && BgNFSHelper.checkHasExpression(cell)) {
                        BgNFSHelper.clearExpression(cell);
                    }
                    if (formula == null) continue;
                    BgNFSHelper.removeCellChangeLastUpdataTime(cell);
                    versionNumber = formula.getExt("Version");
                    cellOrgId = formula.getExt("ORGUNITID");
                    if (versionNumber == null) {
                        versionNumber = currVersionNumber;
                    }
                    if (cellOrgId == null) {
                        cellOrgId = currOrgUnitId;
                    }
                    if (!versionNumber.equals(currVersionNumber) || !cellOrgId.equals(currOrgUnitId) || !this.isBudgetScenario(formula.getFormula(), cacheHelper)) continue;
                    bgData = MBGViewListFormClientHelper.getData(virtualBgDataMap, cellOrgId, formula.getFormula(), versionNumber, false);
                    if (bgData == null) {
                        BgNFSHelper.setValue(cell, null);
                        continue;
                    }
                    BgNFSHelper.setValue(cell, bgData.getBudgetValueNoDef());
                }
            }
        }
        info.setBook(book);
        BgFormFactory.getRemoteInstance().save((CoreBaseInfo)info);
    }

    protected List<String> buildFormula(BgFormInfo info, IMbgViewBase view) throws Exception {
        if (BgTemFormTypeEnum.VIEWLIST.equals((Object)info.getBgTemplate().getFormType())) {
            FormulaProcessor processor = new FormulaProcessor();
            processor.curVersionNumber = info.getBgVersion().getNumber();
            BgViewHelper.buildFormula((MbgViewListManager)view, (BgViewHelper.IFormulaProcessor)processor, this.getSchemeHelper(), null);
            return new ArrayList<String>(processor.formulas);
        }
        return BgNFSHelper.getFormulaListOfBook(info.getBook());
    }

    private boolean isBudgetScenario(String formula, DimensionCacheHelper cacheHelper) throws EASBizException, BOSException {
        String[] formulas = BgNFSHelper.parseFormulaPara(formula);
        return cacheHelper.getBudgetScens().contains(formulas[3]);
    }

    private void replaceBgDataMap(BgFormInfo info, Map<String, Map<String, BgNViewDataInfo>> bgDataMap, IMbgViewBase view, Map<String, Object> paramMap, DimensionCacheHelper cacheHelper, Map<String, Map<String, BgNViewDataInfo>> sourceDataMap, ArrayList<BgGatherInfo> gatherInfos) throws Exception {
        BgProcessEnum processType = (BgProcessEnum)((Object)paramMap.get(PROCESSTYPE));
        HashSet<String> formulaList = new HashSet<String>(this.buildFormula(info, view));
        Map<String, BgNViewDataInfo> subBgDataMap = null;
        String currentOrgUnitId = info.getOrgUnit().getId().toString();
        String versionNumber = info.getBgVersion().getNumber();
        Set orgUnitIds = (Set)paramMap.get(ORGUNITIDSET);
        if (sourceDataMap.get(currentOrgUnitId) == null) {
            sourceDataMap.put(currentOrgUnitId, new HashMap());
        }
        Map<String, BgNViewDataInfo> subUibgDataMap = sourceDataMap.get(currentOrgUnitId);
        DimensionMemberCheckHelper checkHelper = DimensionMemberCheckHelper.getRemoteIntance(cacheHelper, currentOrgUnitId, null, this.getSchemeHelper(), view, true);
        BigDecimal value = null;
        String formulaKey = null;
        for (String formula : formulaList) {
            value = null;
            if (!this.isBudgetScenario(formula, cacheHelper) || !checkHelper.canSave(formula, null, null)) continue;
            formulaKey = formula + "_" + versionNumber;
            for (String orgUnitId : orgUnitIds) {
                subBgDataMap = bgDataMap == null ? null : bgDataMap.get(orgUnitId);
                if (subBgDataMap == null || subBgDataMap.get(formulaKey) == null || subBgDataMap.get(formulaKey).getBudgetValueNoDef() == null) continue;
                value = value == null ? subBgDataMap.get(formulaKey).getBudgetValueNoDef() : value.add(subBgDataMap.get(formulaKey).getBudgetValueNoDef());
                BgMultiDecomposeGatherHelper.addGatherInfo(gatherInfos, info, formula, orgUnitId, subBgDataMap.get(formulaKey).getBudgetValueNoDef(), processType);
            }
            if ((value = this.doAfter(formulaKey, value)) != null) {
                if (subUibgDataMap.get(formulaKey) != null) {
                    subUibgDataMap.get(formulaKey).setBudgetValue(value);
                    continue;
                }
                MBGViewListFormClientHelper.getData(sourceDataMap, currentOrgUnitId, formula, versionNumber, true).setBudgetValue(value);
                continue;
            }
            if (subUibgDataMap.get(formulaKey) != null) {
                subUibgDataMap.get(formulaKey).setBudgetValue(null);
            } else {
                MBGViewListFormClientHelper.createNullData(sourceDataMap, currentOrgUnitId, formula, versionNumber);
            }
            BgMultiDecomposeGatherHelper.addGatherInfo(gatherInfos, info, formula, null, null, processType);
        }
    }

    protected Map<String, BigDecimal> getOtherMutilGatherValue() {
        return this.otherMutilGatherValue;
    }

    protected BigDecimal doAfter(String formulaKey, BigDecimal value) {
        BigDecimal newValue = value;
        if (this.getOtherMutilGatherValue() != null) {
            if (this.getOtherMutilGatherValue().get(formulaKey) != null) {
                if (newValue == null) {
                    newValue = this.getOtherMutilGatherValue().get(formulaKey);
                } else {
                    newValue = newValue.add(this.getOtherMutilGatherValue().get(formulaKey));
                    this.getOtherMutilGatherValue().put(formulaKey, newValue);
                }
            } else if (newValue != null) {
                this.getOtherMutilGatherValue().put(formulaKey, newValue);
            }
        }
        return newValue;
    }

    public static final void addGatherInfo(List<BgGatherInfo> gatherInfos, BgFormInfo bgFormInfo, String formula, String sourceOrgUnitId, BigDecimal sourceValue, BgProcessEnum processType) {
        BgGatherInfo info = new BgGatherInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCreatorID(SysContext.getSysContext().getCurrentUserInfo().getId());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setBgSchemeId(bgFormInfo.getBgScheme().getId());
        info.setOrgUnitId(bgFormInfo.getOrgUnit().getId());
        info.setFormula(formula);
        info.setVersionId(bgFormInfo.getBgVersion().getVersionId());
        info.setSourceProcessType(processType);
        info.setType(0);
        if (sourceOrgUnitId != null) {
            info.setSourceOrgUnitId(BOSUuid.read((String)sourceOrgUnitId));
        }
        if (sourceValue != null) {
            info.setSourceValue(sourceValue);
        }
        gatherInfos.add(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Map<String, Map<String, BgNViewDataInfo>> queryData(BgFormInfo info, IMbgViewBase view, Map<String, Object> paramMap) throws Exception {
        try {
            info.put("ORGUNIT_ID", paramMap.get(ORGUNITIDSET));
            ArrayList<IBgDimensionManagerBase> dimensionManagers = new ArrayList<IBgDimensionManagerBase>();
            for (int s = 0; s < view.getSheetManagers().size(); ++s) {
                this.sysOrgMember(view.getSheetManagers().get(s).getDimensionManager(), (List)paramMap.get(ORGUNITINFOS));
                dimensionManagers.add(view.getSheetManagers().get(s).getDimensionManager());
            }
            Boolean isCalcBiz = (Boolean)paramMap.get(ISCALCBIZ);
            BgFormStateEnum initState = info.getState();
            if (BgFormStateEnum.Approved.equals((Object)info.getState()) && this.isAdjust()) {
                info.setState(BgFormStateEnum.Adjusted);
            }
            Map result = MBGFormFacadeFactory.getRemoteInstance().queryBgData(info.getId(), (IObjectValue)info, dimensionManagers, DimensionCommonHelper.getDataType((BgProcessEnum)((Object)paramMap.get(PROCESSTYPE))), false, null, false, null, isCalcBiz);
            info.setState(initState);
            Map map = result;
            return map;
        }
        finally {
            info.remove("ORGUNIT_ID");
        }
    }

    private void sysOrgMember(IBgDimensionManagerBase dimensionManager, List<BgOrgUnitInfo> bgOrgUnitInfos) {
        List dimension = dimensionManager.getDimension();
        Iterator iterator = dimension.iterator();
        HashSet<String> existsOrg = new HashSet<String>();
        BgDimensionBaseInfo dimensionInfo = (BgDimensionBaseInfo)iterator.next();
        if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimensionInfo.getNumber())) {
            List members = dimensionInfo.getMember();
            int in = members.size();
            for (int i = 0; i < in; ++i) {
                BgDimensionMember member;
                Object obj = members.get(i);
                if (obj instanceof MbgViewListDimensionMember) {
                    member = (MbgViewListDimensionMember)obj;
                    existsOrg.add(member.getNumber());
                    continue;
                }
                if (obj instanceof BgDimensionMember) {
                    member = (BgDimensionMember)obj;
                    existsOrg.add(member.getNumber());
                    continue;
                }
                member = (MbgDimensionMember)obj;
                existsOrg.add(((MbgDimensionMember)member).getNumber());
            }
        }
        ArrayList<BgDimensionMember> newMembers = new ArrayList<BgDimensionMember>();
        for (BgOrgUnitInfo info : bgOrgUnitInfos) {
            if (existsOrg.contains(info.getNumber())) continue;
            if (dimensionManager instanceof MbgViewListDimensionManager) {
                MbgViewListDimensionMember vMember = new MbgViewListDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, info.getOrgUnitID(), info.getName(), info.getNumber());
                newMembers.add(vMember);
                continue;
            }
            BgDimensionMember member = new BgDimensionMember(DimensionConstants.DEF_ORGUNIT_NUMBER, info.getOrgUnitID(), info.getName(), info.getNumber());
            newMembers.add(member);
        }
        if (dimensionManager instanceof MbgViewListDimensionManager) {
            MbgViewListDimensionManager dimManager = (MbgViewListDimensionManager)dimensionManager;
            List<IMbgViewListObject> rowCols = dimManager.getRowCols();
            block2: for (int r = 0; r < rowCols.size(); ++r) {
                if (!(rowCols.get(r) instanceof MbgViewListRowCol)) continue;
                MbgViewListRowCol object = (MbgViewListRowCol)rowCols.get(r);
                List<MbgViewListDimensionInfo> dimens = object.getDimensions();
                for (MbgViewListDimensionInfo dimInfo : dimens) {
                    if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimInfo.getNumber())) continue;
                    dimInfo.getMember().addAll(newMembers);
                    continue block2;
                }
            }
            List dimensions = dimManager.getDimension();
            for (int i = 0; i < dimensions.size(); ++i) {
                MbgViewListDimensionInfo dimInfo;
                if (!(dimensions.get(i) instanceof MbgViewListDimensionInfo) || !DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals((dimInfo = (MbgViewListDimensionInfo)dimensions.get(i)).getNumber())) continue;
                dimInfo.getMember().addAll(newMembers);
                break;
            }
        } else {
            List rowdimensions = dimensionManager.getRowDimension();
            for (Object dimInfo : rowdimensions) {
                if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(((BgDimensionBaseInfo)dimInfo).getNumber())) continue;
                ((BgDimensionBaseInfo)dimInfo).getMember().addAll(newMembers);
                break;
            }
            List coldimensions = dimensionManager.getColDimension();
            for (BgDimensionInfo dimInfo : coldimensions) {
                if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimInfo.getNumber())) continue;
                dimInfo.getMember().addAll(newMembers);
                break;
            }
            List pagedimensions = dimensionManager.getPageDimension();
            for (int i = pagedimensions.size() - 1; i >= 0; --i) {
                BgDimensionInfo dimInfo = (BgDimensionInfo)pagedimensions.get(i);
                if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimInfo.getNumber())) continue;
                dimInfo.getMember().addAll(newMembers);
                dimensionManager.getRowDimension().add(dimInfo);
                pagedimensions.remove(i);
                break;
            }
        }
    }

    public static void filterBudgetScenario(IMbgViewBase view, DimensionCacheHelper cacheHelper) throws EASBizException, BOSException {
        List dimensions = null;
        BgDimensionBaseInfo dimension = null;
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            dimensions = view instanceof MbgViewListManager ? ((MbgViewListSheetManager)((MbgViewListManager)view).getSheetManagers().get(s)).getDimensionManager().getAllDimensions() : ((IMbgViewManager)view).getSheetManagers().get(s).getDimensionManager().getDimension();
            for (int d = 0; d < dimensions.size(); ++d) {
                if (!(dimensions.get(d) instanceof BgDimensionBaseInfo) || !DimensionConstants.DEF_SCENARIO_NUMBER.equals((dimension = (BgDimensionBaseInfo)dimensions.get(d)).getNumber())) continue;
                Iterator it = dimension.getMember().iterator();
                while (it.hasNext()) {
                    if (cacheHelper.getBudgetScens().contains(BgViewHelper.getNumber(it.next()))) continue;
                    it.remove();
                }
            }
        }
    }

    private DimensionCacheHelper getCacheHelper(BgFormInfo info) throws BOSException, EASBizException {
        if (BgTemFormTypeEnum.VIEWLIST.equals((Object)info.getBgTemplate().getFormType())) {
            DimensionMemberCheckFactory checkFactory = new DimensionMemberCheckFactory(null, null, this.getSchemeHelper(), info.isDecompose());
            return checkFactory.getCacheHelper();
        }
        IMbgViewManager view = this.getFormView(info);
        return DimensionMemberCheckHelper.getRemoteIntance(null, info.getOrgUnit().getId().toString(), info.getBgTemplate().getId().toString(), this.getSchemeHelper(), view, info.isDecompose()).getCacheHelper();
    }

    private IMbgViewManager getFormView(BgFormInfo info) throws BOSException, EASBizException {
        IMbgViewManager view = (IMbgViewManager)DimensionCommonHelper.getBgFormView(null, info);
        view = TemplateFacadeFactory.getRemoteInstance().reParseDimensionMembers(info.getOrgUnit().getId().toString(), info.getBgScheme().getId().toString(), view, info.getCreateTime(), (IObjectValue)info);
        return view;
    }

    private void getErrorMsg(List<Map<OrderObject, String>> messages, BgFormInfo bgFormInfo, String failedMsg) {
        OrderObject formTitle = new OrderObject("formTitle", EASResource.getString((String)MBG_RESOURCE, (String)"formTitle"), 2);
        OrderObject orgTitle = new OrderObject("orgTitle", EASResource.getString((String)MBG_RESOURCE, (String)"orgTitle"), 1);
        OrderObject failedTitle = new OrderObject("failedTitle", EASResource.getString((String)MBG_RESOURCE, (String)"failedTitle"), 3);
        HashMap<OrderObject, String> baseMsg = new HashMap<OrderObject, String>();
        baseMsg.put(formTitle, bgFormInfo.getNumber() + "(" + bgFormInfo.getName() + ")");
        baseMsg.put(orgTitle, bgFormInfo.getOrgUnit().getNumber() + "(" + bgFormInfo.getOrgUnit().getName() + ")");
        baseMsg.put(failedTitle, failedMsg);
        messages.add(baseMsg);
    }

    public void createDivInfo(String formulaStr, BigDecimal newValue, BigDecimal oldValue, Map adjustMap) {
        formulaStr = formulaStr.split("_")[0];
        BgAdjustFormDiversityData divData = new BgAdjustFormDiversityData();
        divData.setFormula(formulaStr);
        divData.setNewValue(newValue);
        divData.setOldValue(oldValue);
        divData.setAdjustTime(new Timestamp(System.currentTimeMillis()));
        adjustMap.put(formulaStr, divData);
    }

    public static class FormulaProcessor
    implements BgViewHelper.IFormulaProcessor {
        Map<Integer, String> clone = new HashMap<Integer, String>();
        public Set<String> formulas = new HashSet<String>();
        public String curVersionNumber = null;

        @Override
        public void process(String formula, String versionNumber, String scenarioNumber) {
            if (!this.curVersionNumber.equals(versionNumber)) {
                return;
            }
            this.formulas.add(formula);
        }

        @Override
        public Map<Integer, String> getCloneMap() {
            return this.clone;
        }
    }
}

