/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IEditableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Ref3DExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.client.BgElementF7UI;
import com.kingdee.eas.ma.base.client.BgPeriodF7UI;
import com.kingdee.eas.ma.base.client.BgScenarioF7UI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.client.BgCurrencyF7UI;
import com.kingdee.eas.ma.mbg.client.ProjectSameFormulaUI;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNLockProtectHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.FormulaUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgNFillHelper {
    public static final Logger logger = Logger.getLogger((String)BgNFillHelper.class.getName());
    public static final String CMD_BGFORMULA = "BgFormula";
    public static final String CMD_BGACTUALS = "BgActualS";
    public static final String CMD_BGBAL = "BgBal";
    public static final String CMD_BGFORMULAF = "BgFormulaF";
    public static final String CMD_BGACTUALSF = "BgActualSF";
    public static final String CMD_BGBALF = "BgBalF";
    public static final String CMD_BGADJUST = "BgAdjust";
    public static final String CMD_BGADJUSTF = "BgAdjustF";
    public static final String CMD_BGAVLBAL = "BgAvlBal";
    public static final String CMD_BGAVLBALF = "BgAvlBalF";
    public static final String CMD_BGACTUALEXT = "BgActualExt";
    public static final String CMD_BGACTUALEXTF = "BgActualExtF";
    public static final String CMD_MBGACTUALS = "MbgActualS";
    public static final String CMD_MBGAGGREGATE = "MbgAggregate";
    public static final String CMD_MBGFORMULA = "MbgFormula";
    public static final String CMD_MBGACTUALSF = "MbgActualSF";
    public static final String CMD_MBGAGGREGATEF = "MbgAggregateF";
    public static final String CMD_MBGFORMULAF = "MbgFormulaF";

    public static void showCurrency(IUIObject win, Sheet sheet) {
        block10: {
            UIContext uiContext = new UIContext((Object)win);
            IUIWindow uiWindow = null;
            try {
                DimensionMemberSelectHelper.addIds(win, uiContext, DimensionConstants.DEF_CURRENCY_NUMBER);
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.mbg.client.BgCurrencyF7UI", (Map)uiContext);
            }
            catch (UIException e) {
                logger.error((Object)e);
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            catch (BOSException e) {
                logger.error((Object)e);
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            uiWindow.show();
            BgCurrencyF7UI f7ui = (BgCurrencyF7UI)uiWindow.getUIObject();
            if (f7ui.getResultColl() == null || f7ui.getResultColl().size() <= 0) break block10;
            CurrencyCollection coll = f7ui.getResultColl();
            Range range = sheet.getSelectionRange();
            range.setIgnoreProtected(true);
            if (range.size() > 0) {
                CellBlock block = range.getBlock(0);
                if (block.getRow() == block.getRow2() && block.getCol() != block.getCol2()) {
                    int index = 0;
                    int j = block.getRow();
                    for (int k = block.getCol(); k <= (coll.size() >= block.getCol2() - block.getCol() + 1 ? block.getCol() + coll.size() - 1 : block.getCol2()); ++k) {
                        Cell cell = sheet.getCell(j, k, true);
                        if (BgNFSHelper.isCellFromTemplate(cell)) continue;
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", "bgFillValueType_currency", true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillValue", coll.get(index % coll.size()).getNumber(), true);
                        BgNTemplateHelper.setValue(cell, coll.get(index % coll.size()).getName(), true);
                        ++index;
                    }
                } else if (block.getCol() == block.getCol2()) {
                    int index = 0;
                    int k = block.getCol();
                    for (int j = block.getRow(); j <= (coll.size() >= block.getRow2() - block.getRow() + 1 ? block.getRow() + coll.size() - 1 : block.getRow2()); ++j) {
                        Cell cell = sheet.getCell(j, k, true);
                        if (BgNFSHelper.isCellFromTemplate(cell)) continue;
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", "bgFillValueType_currency", true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillValue", coll.get(index % coll.size()).getNumber(), true);
                        BgNTemplateHelper.setValue(cell, coll.get(index % coll.size()).getName(), true);
                        ++index;
                    }
                }
            }
        }
    }

    public static void showScenario(IUIObject win, Sheet sheet) {
        block10: {
            Range range = BgNFillHelper.getSelectRange(win, sheet);
            range.setIgnoreProtected(true);
            UIContext uiContext = new UIContext((Object)win);
            uiContext.put((Object)"isFilterText", (Object)new Boolean(false));
            uiContext.put((Object)"isChooseOne", (Object)new Boolean(false));
            IUIWindow uiWindow = null;
            try {
                DimensionMemberSelectHelper.addIds(win, uiContext, DimensionConstants.DEF_SCENARIO_NUMBER);
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.base.client.BgScenarioF7UI", (Map)uiContext);
            }
            catch (UIException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            uiWindow.show();
            BgScenarioF7UI f7ui = (BgScenarioF7UI)uiWindow.getUIObject();
            if (f7ui.getResult() == null || f7ui.getResult().getResult().size() == 0) break block10;
            BgScenarioCollection eleColl = f7ui.getResult().getResult();
            if (range.size() > 0) {
                CellBlock block = range.getBlock(0);
                if (block.getRow() == block.getRow2() && block.getCol() != block.getCol2()) {
                    int index = 0;
                    int j = block.getRow();
                    for (int k = block.getCol(); k <= (eleColl.size() >= block.getCol2() - block.getCol() + 1 ? block.getCol() + eleColl.size() - 1 : block.getCol2()); ++k) {
                        Cell cell = sheet.getCell(j, k, true);
                        if (BgNFSHelper.isCellFromTemplate(cell)) continue;
                        sheet.getBook().setSkipListeners(true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", "bgFillValueType_scenario", true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillValue", eleColl.get(index % eleColl.size()).getNumber(), true);
                        BgNTemplateHelper.setValue(cell, eleColl.get(index % eleColl.size()).getName(), true);
                        sheet.getBook().setSkipListeners(false);
                        ++index;
                    }
                } else if (block.getCol() == block.getCol2()) {
                    int index = 0;
                    int k = block.getCol();
                    for (int j = block.getRow(); j <= (eleColl.size() >= block.getRow2() - block.getRow() + 1 ? block.getRow() + eleColl.size() - 1 : block.getRow2()); ++j) {
                        Cell cell = sheet.getCell(j, k, true);
                        if (BgNFSHelper.isCellFromTemplate(cell)) continue;
                        sheet.getBook().setSkipListeners(true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", "bgFillValueType_scenario", true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillValue", eleColl.get(index % eleColl.size()).getNumber(), true);
                        BgNTemplateHelper.setValue(cell, eleColl.get(index % eleColl.size()).getName(), true);
                        sheet.getBook().setSkipListeners(false);
                        ++index;
                    }
                }
            }
        }
    }

    public static void showElement(IUIObject win, Sheet sheet) {
        block10: {
            Range range = BgNFillHelper.getSelectRange(win, sheet);
            range.setIgnoreProtected(true);
            UIContext uiContext = new UIContext((Object)win);
            uiContext.put((Object)"isFilterText", (Object)new Boolean(false));
            uiContext.put((Object)"isChooseOne", (Object)new Boolean(false));
            IUIWindow uiWindow = null;
            try {
                DimensionMemberSelectHelper.addIds(win, uiContext, DimensionConstants.DEF_ELEMENT_NUMBER);
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.base.client.BgElementF7UI", (Map)uiContext);
            }
            catch (UIException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            uiWindow.show();
            BgElementF7UI f7ui = (BgElementF7UI)uiWindow.getUIObject();
            if (f7ui.getResult() == null || f7ui.getResult().getResult().size() == 0) break block10;
            BgElementCollection eleColl = f7ui.getResult().getResult();
            if (range.size() > 0) {
                CellBlock block = range.getBlock(0);
                if (block.getRow() == block.getRow2() && block.getCol() != block.getCol2()) {
                    int index = 0;
                    int j = block.getRow();
                    for (int k = block.getCol(); k <= (eleColl.size() >= block.getCol2() - block.getCol() + 1 ? block.getCol() + eleColl.size() - 1 : block.getCol2()); ++k) {
                        Cell cell = sheet.getCell(j, k, true);
                        if (BgNFSHelper.isCellFromTemplate(cell)) continue;
                        sheet.getBook().setSkipListeners(true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", "bgFillValueType_element", true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillValue", eleColl.get(index % eleColl.size()).getNumber(), true);
                        BgNTemplateHelper.setValue(cell, eleColl.get(index % eleColl.size()).getName(), true);
                        boolean isAttachFormula = eleColl.get(index % eleColl.size()).getDataType().getValue() != 5 && eleColl.get(index % eleColl.size()).getDataType().getValue() != 4;
                        sheet.getBook().setSkipListeners(false);
                        BgNTemplateHelper.setBgDataValue(cell, "isAttachFormula", String.valueOf(isAttachFormula), true);
                        ++index;
                    }
                } else if (block.getCol() == block.getCol2()) {
                    int index = 0;
                    int k = block.getCol();
                    for (int j = block.getRow(); j <= (eleColl.size() >= block.getRow2() - block.getRow() + 1 ? block.getRow() + eleColl.size() - 1 : block.getRow2()); ++j) {
                        Cell cell = sheet.getCell(j, k, true);
                        if (BgNFSHelper.isCellFromTemplate(cell)) continue;
                        sheet.getBook().setSkipListeners(true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", "bgFillValueType_element", true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillValue", eleColl.get(index % eleColl.size()).getNumber(), true);
                        BgNTemplateHelper.setValue(cell, eleColl.get(index % eleColl.size()).getName(), true);
                        boolean isAttachFormula = eleColl.get(index % eleColl.size()).getDataType().getValue() != 5 && eleColl.get(index % eleColl.size()).getDataType().getValue() != 4;
                        sheet.getBook().setSkipListeners(false);
                        BgNTemplateHelper.setBgDataValue(cell, "isAttachFormula", String.valueOf(isAttachFormula), true);
                        ++index;
                    }
                }
            }
        }
    }

    public static Range getSelectRange(IUIObject win, Sheet sheet) {
        CellBlock block;
        Range range = sheet.getSelectionRange();
        range.setIgnoreProtected(true);
        if (range.size() > 1) {
            MsgBox.showWarning((Component)((Component)win), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BudgetResource", (String)"notSelectMulti"));
            SysUtil.abort();
        } else if (range.size() == 1 && (block = range.getBlock(0)).getRow() != block.getRow2() && block.getCol() != block.getCol2()) {
            MsgBox.showWarning((Component)((Component)win), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BudgetResource", (String)"selectSingle"));
            SysUtil.abort();
        }
        return range;
    }

    public static void showBgPeriod(IUIObject win, Sheet sheet, BgSchemeInfo bgSchemeInfo) throws UIException {
        block11: {
            java.util.Date beginDate = null;
            java.util.Date endDate = null;
            String bgSchemeId = null;
            if (bgSchemeInfo != null) {
                bgSchemeId = bgSchemeInfo.getId().toString();
                beginDate = BgNPeriodHelper.getDayBegin((java.util.Date)bgSchemeInfo.getDateFrom());
                endDate = BgNPeriodHelper.getDayEnd((java.util.Date)bgSchemeInfo.getDateTo());
            }
            Range range = BgNFillHelper.getSelectRange(win, sheet);
            range.setIgnoreProtected(true);
            UIContext uiContext = new UIContext((Object)win);
            uiContext.put((Object)"bgPeriodEnum", null);
            uiContext.put((Object)"beginDate", (Object)beginDate);
            uiContext.put((Object)"endDate", (Object)endDate);
            uiContext.put((Object)"isMultiSelect", (Object)Boolean.TRUE);
            uiContext.put((Object)"BGSCHEME_ID", (Object)bgSchemeId);
            IUIFactory uiFactory = null;
            IUIWindow uiWindow = null;
            try {
                DimensionMemberSelectHelper.addBgPeriodNumber(win, uiContext);
                uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                uiWindow = uiFactory.create("com.kingdee.eas.ma.base.client.BgPeriodF7UI", (Map)uiContext, null, OprtState.EDIT);
            }
            catch (UIException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            catch (EASBizException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e);
                return;
            }
            uiWindow.show();
            BgPeriodF7UI f7ui = (BgPeriodF7UI)uiWindow.getUIObject();
            if (f7ui.getBgPeriodCollection() == null || f7ui.getBgPeriodCollection().size() <= 0) break block11;
            BgPeriodCollection coll = f7ui.getBgPeriodCollection();
            if (range.size() > 0) {
                CellBlock block = range.getBlock(0);
                if (block.getRow() == block.getRow2() && block.getCol() != block.getCol2()) {
                    int index = 0;
                    int j = block.getRow();
                    for (int k = block.getCol(); k <= (coll.size() >= block.getCol2() - block.getCol() + 1 ? block.getCol() + coll.size() - 1 : block.getCol2()); ++k) {
                        Cell cell = sheet.getCell(j, k, true);
                        if (BgNFSHelper.isCellFromTemplate(cell)) continue;
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", "bgFillValueType_period", true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillValue", coll.get(index % coll.size()).getNumber(), true);
                        BgNTemplateHelper.setValue(cell, coll.get(index % coll.size()).getName(), true);
                        ++index;
                    }
                } else if (block.getCol() == block.getCol2()) {
                    int index = 0;
                    int k = block.getCol();
                    for (int j = block.getRow(); j <= (coll.size() >= block.getRow2() - block.getRow() + 1 ? block.getRow() + coll.size() - 1 : block.getRow2()); ++j) {
                        Cell cell = sheet.getCell(j, k, true);
                        if (BgNFSHelper.isCellFromTemplate(cell)) continue;
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillType", "bgFillValueType_period", true);
                        BgNTemplateHelper.setBgDataValue(cell, "bgFillValue", coll.get(index % coll.size()).getNumber(), true);
                        BgNTemplateHelper.setValue(cell, coll.get(index % coll.size()).getName(), true);
                        ++index;
                    }
                }
            }
        }
    }

    public static void createBgFormula(IUIObject win, Sheet sheet, IObjectValue value, String formulaKind, boolean needItemVariable, boolean isEnumForm, String orgUnitId, boolean isMustAllDim) throws BOSException, EASBizException {
        int k;
        int j;
        CellBlock block;
        int i;
        Range range = sheet.getSelectionRange();
        Protection pro = sheet.getSheetOption().getProtection(false);
        boolean isPro = false;
        if (pro != null && pro.isProtected() && !pro.allowEditObjects()) {
            isPro = true;
        }
        range.setIgnoreProtected(true);
        Map mapSelectionCell = null;
        mapSelectionCell = BgNTemplateHelper.getSelectCells(sheet);
        int num = range.size();
        if (num <= 0) {
            logger.debug((Object)"range.size=0");
            return;
        }
        int maxCol = sheet.getMaxColIndex();
        int maxRow = sheet.getMaxRowIndex();
        boolean hasNotLock = false;
        for (i = 0; i < num; ++i) {
            block = range.getBlock(i);
            for (j = block.getRow(); j <= Math.min(maxRow, block.getRow2()); ++j) {
                for (k = block.getCol(); k <= Math.min(maxCol, block.getCol2()); ++k) {
                    Cell currentIteratorCell = sheet.getCell(j, k, false);
                    if (currentIteratorCell == null || isPro && BgNLockProtectHelper.isCellLocked(currentIteratorCell)) continue;
                    hasNotLock = true;
                }
            }
        }
        if (!hasNotLock) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"cellLock"));
            SysUtil.abort();
        }
        for (i = 0; i < num; ++i) {
            block = range.getBlock(i);
            for (j = block.getRow(); j <= Math.min(maxRow, block.getRow2()); ++j) {
                for (k = block.getCol(); k <= Math.min(maxCol, block.getCol2()); ++k) {
                    HashMap map;
                    Cell cell;
                    if (sheet.getMergeBlock(j, k) != null || BgNTemplateHelper.getItemFormulaObject(cell = sheet.getCell(j, k, false), "bgFillType") != null) continue;
                    if (value instanceof BgFormInfo) {
                        if (isPro && BgNLockProtectHelper.isCellLocked(cell)) continue;
                        map = new HashMap();
                        BgNFillHelper.initAllFormulaElement(sheet, j, k, map, mapSelectionCell);
                        BgNFillHelper.subCreateBgFormula(sheet, map, j, k, value, formulaKind);
                        continue;
                    }
                    if (isPro && BgNLockProtectHelper.isCellLocked(cell)) continue;
                    map = new HashMap();
                    BgNFillHelper.initAllFormulaElement(sheet, j, k, map, mapSelectionCell);
                    BgNFillHelper.subCreateBgFormula(sheet, map, j, k, value, formulaKind);
                }
            }
            BgNTemplateHelper.dealWith(sheet.getBook(), orgUnitId, null, false, false, needItemVariable, isEnumForm, null, DimensionMemberSelectHelper.getSchemeHelper(win), isMustAllDim);
        }
    }

    public static void initAllFormulaElement(Sheet sheet, int rowIndex, int colIndex, HashMap map, Map mapSelectionCell) throws BOSException, EASBizException {
        Range range = sheet.getSelectionRange();
        range.setIgnoreProtected(true);
        for (int i = 0; i < range.size(); ++i) {
            CellBlock block = range.getBlock(i);
            BgNFillHelper.initFormulaElement(sheet, rowIndex, colIndex, block, map, "bgFillValueType_item", mapSelectionCell);
            BgNFillHelper.initFormulaElement(sheet, rowIndex, colIndex, block, map, "bgFillValueType_element", mapSelectionCell);
            BgNFillHelper.initFormulaElement(sheet, rowIndex, colIndex, block, map, "bgFillValueType_period", mapSelectionCell);
            BgNFillHelper.initFormulaElement(sheet, rowIndex, colIndex, block, map, "bgFillValueType_currency", mapSelectionCell);
        }
    }

    public static void subCreateBgFormula(Sheet sheet, HashMap map, int rowIndex, int colIndex, IObjectValue value, String formulaKind) {
        if (map.isEmpty()) {
            return;
        }
        Cell cell = sheet.getCell(rowIndex, colIndex, true);
        if (BgNTemplateHelper.checkHaveBgFillType(cell)) {
            return;
        }
        boolean isBgForm = false;
        if (value instanceof BgFormInfo) {
            isBgForm = true;
        }
        if (!map.isEmpty() && map.get("isAttachFormula") != null && map.get("isAttachFormula").toString().equals("false")) {
            return;
        }
        String itemCombinStr = map.get("bgFillValueType_item") == null ? "" : map.get("bgFillValueType_item").toString();
        String bgPeriodNumber = map.get("bgFillValueType_period") == null ? "" : map.get("bgFillValueType_period").toString();
        String elementNumber = map.get("bgFillValueType_element") == null ? "" : map.get("bgFillValueType_element").toString();
        String currencyNumber = map.get("bgFillValueType_currency") == null ? "" : map.get("bgFillValueType_currency").toString();
        String beginTime = null;
        String endTime = null;
        if (StringUtils.isEmpty((String)bgPeriodNumber)) {
            beginTime = "";
            endTime = "";
        } else {
            beginTime = BgNFillHelper.getBeginTime(bgPeriodNumber);
            endTime = BgNFillHelper.getEndTime(bgPeriodNumber);
        }
        String periodType = "MONTH";
        String aggregateType = "";
        String actualType = "all";
        String orgNumber = "";
        String bgSchemeNumber = "";
        if (isBgForm) {
            BgFormInfo info = (BgFormInfo)value;
            bgPeriodNumber = bgPeriodNumber.equals("") ? info.getBgPeriod().getNumber() : bgPeriodNumber;
            currencyNumber = currencyNumber.equals("") ? info.getCurrency().getNumber() : currencyNumber;
            orgNumber = info.getOrgUnit().getNumber();
            bgSchemeNumber = info.getBgScheme().getNumber();
            beginTime = String.valueOf(info.getBgPeriod().getBeginDate());
            endTime = String.valueOf(info.getBgPeriod().getEndDate());
        }
        int isEleNotNullCount = 0;
        if (!StringUtils.isEmpty((String)currencyNumber)) {
            ++isEleNotNullCount;
        }
        if (!StringUtils.isEmpty((String)bgPeriodNumber)) {
            ++isEleNotNullCount;
        }
        if (!StringUtils.isEmpty((String)elementNumber)) {
            ++isEleNotNullCount;
        }
        if (!StringUtils.isEmpty((String)itemCombinStr)) {
            ++isEleNotNullCount;
        }
        if (isEleNotNullCount < 2) {
            return;
        }
        String _formula = null;
        _formula = formulaKind.equalsIgnoreCase(CMD_BGAVLBAL) || formulaKind.equalsIgnoreCase(CMD_BGAVLBALF) ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\")" : (formulaKind.equalsIgnoreCase(CMD_BGACTUALEXT) || formulaKind.equalsIgnoreCase(CMD_BGACTUALEXTF) ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + beginTime + "\",\"" + endTime + "\",\"" + periodType + "\")" : (formulaKind.equalsIgnoreCase(CMD_MBGACTUALS) || formulaKind.equalsIgnoreCase(CMD_BGACTUALEXTF) ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\",\"" + actualType + "\")" : (formulaKind.equalsIgnoreCase(CMD_MBGAGGREGATE) || formulaKind.equalsIgnoreCase(CMD_BGACTUALEXTF) ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\",\"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + aggregateType + "\")" : "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\")")));
        BgNFSHelper.setExpression(cell, _formula);
    }

    public static void initFormulaElement(Sheet sheet, int rowIndex, int colIndex, CellBlock block, HashMap map, String elementType, Map mapSelectionCell) {
        String tmpStr;
        int y;
        int x;
        CellBlock mergeBlock;
        CellBlock blockMerge;
        Cell tmpCell;
        int m;
        int minRow = block.getRow();
        int maxRow = Math.min(sheet.getMaxRowIndex(), block.getRow2());
        int minCol = block.getCol();
        int maxCol = Math.min(sheet.getMaxColIndex(), block.getCol2());
        boolean isInit = false;
        for (m = rowIndex - 1; m >= minRow; --m) {
            tmpCell = sheet.getCell(m, colIndex, false);
            if (sheet.getMergeBlock(m, colIndex) != null) {
                blockMerge = sheet.getMergeBlock(m, colIndex);
                tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), false);
            }
            if (tmpCell == null || !BgNFillHelper.isInBlock(tmpCell, block)) continue;
            if (tmpCell.getValue() == null && tmpCell.getMerge(false) != null) {
                mergeBlock = tmpCell.getMerge(false);
                x = mergeBlock.getRow();
                y = mergeBlock.getCol();
                tmpCell = sheet.getCell(x, y, false);
            }
            if (!BgNFillHelper.isInBlock(tmpCell, mapSelectionCell) || BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType").equals(elementType)) continue;
            if (elementType.equals("bgFillValueType_element")) {
                map.put("isAttachFormula", BgNTemplateHelper.getBgDataValue(tmpCell, "isAttachFormula"));
            }
            if (elementType.equals("bgFillValueType_item")) {
                if (map.get(elementType) != null) {
                    tmpStr = map.get(elementType).toString();
                    map.put(elementType, tmpStr + "," + BgNTemplateHelper.getBgFillValue(tmpCell));
                    continue;
                }
                map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
                continue;
            }
            map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
            isInit = true;
            break;
        }
        if (!isInit) {
            for (m = rowIndex + 1; m <= maxRow; ++m) {
                tmpCell = sheet.getCell(m, colIndex, false);
                if (sheet.getMergeBlock(m, colIndex) != null) {
                    blockMerge = sheet.getMergeBlock(m, colIndex);
                    tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), false);
                }
                if (tmpCell == null || !BgNFillHelper.isInBlock(tmpCell, block)) continue;
                if (tmpCell.getValue() == null && tmpCell.getMerge(false) != null) {
                    tmpCell.getMerge(false);
                    mergeBlock = tmpCell.getMerge(false);
                    x = mergeBlock.getRow();
                    y = mergeBlock.getCol();
                    tmpCell = sheet.getCell(x, y, false);
                }
                if (!BgNFillHelper.isInBlock(tmpCell, mapSelectionCell) || BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType").equals(elementType)) continue;
                if (elementType.equals("bgFillValueType_element")) {
                    map.put("isAttachFormula", BgNTemplateHelper.getBgDataValue(tmpCell, "isAttachFormula"));
                }
                if (elementType.equals("bgFillValueType_item")) {
                    if (map.get(elementType) != null) {
                        tmpStr = map.get(elementType).toString();
                        map.put(elementType, tmpStr + "," + BgNTemplateHelper.getBgFillValue(tmpCell));
                        continue;
                    }
                    map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
                    continue;
                }
                map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
                isInit = true;
                break;
            }
        }
        if (!isInit) {
            for (m = colIndex - 1; m >= minCol; --m) {
                tmpCell = sheet.getCell(rowIndex, m, false);
                if (sheet.getMergeBlock(rowIndex, m) != null) {
                    blockMerge = sheet.getMergeBlock(rowIndex, m);
                    tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), false);
                }
                if (tmpCell == null || !BgNFillHelper.isInBlock(tmpCell, block)) continue;
                if (tmpCell.getValue() == null && tmpCell.getMerge(false) != null) {
                    mergeBlock = tmpCell.getMerge(false);
                    x = mergeBlock.getRow();
                    y = mergeBlock.getCol();
                    tmpCell = sheet.getCell(x, y, false);
                }
                if (!BgNFillHelper.isInBlock(tmpCell, mapSelectionCell) || BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType").equals(elementType)) continue;
                if (elementType.equals("bgFillValueType_element")) {
                    map.put("isAttachFormula", BgNTemplateHelper.getBgDataValue(tmpCell, "isAttachFormula"));
                }
                if (elementType.equals("bgFillValueType_item")) {
                    if (map.get(elementType) != null) {
                        tmpStr = map.get(elementType).toString();
                        map.put(elementType, tmpStr + "," + BgNTemplateHelper.getBgFillValue(tmpCell));
                        continue;
                    }
                    map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
                    continue;
                }
                map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
                isInit = true;
                break;
            }
        }
        if (!isInit) {
            for (m = colIndex + 1; m <= maxCol; ++m) {
                tmpCell = sheet.getCell(rowIndex, m, false);
                if (sheet.getMergeBlock(rowIndex, m) != null) {
                    blockMerge = sheet.getMergeBlock(rowIndex, m);
                    tmpCell = sheet.getCell(blockMerge.getRow(), blockMerge.getCol(), false);
                }
                if (tmpCell == null || !BgNFillHelper.isInBlock(tmpCell, block)) continue;
                if (tmpCell.getValue() == null && tmpCell.getMerge(false) != null) {
                    mergeBlock = tmpCell.getMerge(false);
                    x = mergeBlock.getRow();
                    y = mergeBlock.getCol();
                    tmpCell = sheet.getCell(x, y, false);
                }
                if (!BgNFillHelper.isInBlock(tmpCell, mapSelectionCell) || BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType") == null || !BgNTemplateHelper.getBgDataValue(tmpCell, "bgFillType").equals(elementType)) continue;
                if (elementType.equals("bgFillValueType_element")) {
                    map.put("isAttachFormula", BgNTemplateHelper.getBgDataValue(tmpCell, "isAttachFormula"));
                }
                if (elementType.equals("bgFillValueType_item")) {
                    if (map.get(elementType) != null) {
                        tmpStr = map.get(elementType).toString();
                        map.put(elementType, tmpStr + "," + BgNTemplateHelper.getBgFillValue(tmpCell));
                        continue;
                    }
                    map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
                    continue;
                }
                map.put(elementType, BgNTemplateHelper.getBgFillValue(tmpCell));
                isInit = true;
                break;
            }
        }
    }

    public static boolean isInBlock(Cell cell, Map mapSelectionCell) {
        if (cell == null || mapSelectionCell == null || mapSelectionCell.isEmpty()) {
            return false;
        }
        return mapSelectionCell.containsKey(cell.getRow() + "-" + cell.getCol());
    }

    private static boolean isInBlock(Cell cell, CellBlock block) {
        if (cell == null || block == null) {
            return false;
        }
        int minRow = block.getRow();
        int maxRow = block.getRow2();
        int minCol = block.getCol();
        int maxCol = block.getCol2();
        return cell.getRow() >= minRow && cell.getRow() <= maxRow && cell.getCol() >= minCol && cell.getCol() <= maxCol;
    }

    public static String[] parseStrFormulaToArray(String formula) {
        List list = new ArrayList();
        try {
            list = TableToolkit.parseFormula((String)formula, (boolean)false);
        }
        catch (ParserException e1) {
            return new String[0];
        }
        if (list == null || list.isEmpty()) {
            return new String[0];
        }
        FormulaHint hint = (FormulaHint)list.get(0);
        String[] params = hint.getParams();
        return params;
    }

    public static void mutiUpdateFormula(IUIObject ui, Sheet sheet, String orgUnitId) throws ParserException {
        if (sheet == null) {
            return;
        }
        Range range = sheet.getSelectionRange();
        range.setIgnoreProtected(true);
        int num = range.size();
        if (num <= 0) {
            return;
        }
        Protection pro = sheet.getSheetOption().getProtection(false);
        boolean isPro = false;
        if (pro != null && pro.isProtected() && !pro.allowEditObjects()) {
            isPro = true;
        }
        CellBlock block = null;
        Cell cell = null;
        boolean hasNotLock = false;
        boolean hasExpress = false;
        int maxRow = sheet.getMaxRowIndex();
        int maxCol = sheet.getMaxColIndex();
        for (int i = 0; i < num; ++i) {
            block = range.getBlock(i);
            if (block == null) continue;
            int xn = Math.min(maxRow, block.getRow2());
            for (int x = block.getRow(); x <= xn; ++x) {
                int yn = Math.min(maxCol, block.getCol2());
                for (int y = block.getCol(); y <= yn; ++y) {
                    cell = sheet.getCell(x, y, false);
                    if (cell == null) continue;
                    if (BgNFSHelper.checkHasExpression(cell)) {
                        hasExpress = true;
                    }
                    if (!isPro || !BgNLockProtectHelper.isCellLocked(cell)) {
                        hasNotLock = true;
                    }
                    if (hasExpress && !hasNotLock) break;
                }
                if (hasExpress && !hasNotLock) break;
            }
            if (hasExpress && !hasNotLock) break;
        }
        if (hasExpress && !hasNotLock) {
            MsgBox.showWarning((Component)((Component)ui), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgFormResource", (String)"expressLock"));
            SysUtil.abort();
        }
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("Owner", ui);
        ctx.put("ORGUNIT_ID", orgUnitId);
        IUIWindow messageDialog = null;
        try {
            ctx.put("BGSCHEME_HELPER", DimensionMemberSelectHelper.getSchemeHelper(ui));
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            messageDialog = uiFactory.create(ProjectSameFormulaUI.class.getName(), ctx);
            messageDialog.show();
        }
        catch (UIException uiFactory) {
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)((Component)ui), (Throwable)e);
            return;
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Component)ui), (Throwable)e);
            return;
        }
        String[] expressionStrs = ((ProjectSameFormulaUI)messageDialog.getUIObject()).getExpressionStrs();
        if (expressionStrs == null) {
            return;
        }
        HashSet<String> expressionType = new HashSet<String>();
        expressionType.add(CMD_MBGAGGREGATE.toLowerCase());
        expressionType.add("Mbgadjust".toLowerCase());
        expressionType.add("MbgAdjustDate".toLowerCase());
        for (int i = 0; i < num; ++i) {
            block = range.getBlock(i);
            int rowCount = Math.min(maxRow, block.getRow2());
            for (int rowIndex = block.getRow(); rowIndex <= rowCount; ++rowIndex) {
                int colCount = Math.min(maxCol, block.getCol2());
                for (int colIndex = block.getCol(); colIndex <= colCount; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasExpression(cell)) continue;
                    String tempFormula = BgNFSHelper.getExpression(cell);
                    String newFormual = BgNFillHelper.checkExpression(ui, cell, tempFormula, expressionStrs, expressionType);
                    BgNFSHelper.setExpression(cell, newFormual);
                }
            }
        }
        FormulaUtils.clearBgScenario();
    }

    public static void subCreateBgFormulaFromItemFormula(Cell cell, IObjectValue value, String formulaKind) {
        if (cell == null) {
            return;
        }
        boolean isBgForm = false;
        if (value instanceof BgFormInfo) {
            isBgForm = true;
        }
        String itemCombinStr = "";
        String bgPeriodNumber = "";
        String elementNumber = "";
        String currencyNumber = "";
        String orgNumber = "";
        String bgSchemeNumber = "";
        String beginTime = "";
        String endTime = "";
        String periodType = "MONTH";
        String actualType = "all";
        String aggregateType = "";
        if (BgNFSHelper.checkHasFormulaOfCell(cell)) {
            String itemFormula = BgNFSHelper.getFormulaOfCell(cell);
            itemFormula = BgNTemplateHelper.get6ParematerItemFormula(itemFormula);
            List list = new ArrayList();
            try {
                list = TableToolkit.parseFormula((String)itemFormula, (boolean)false);
            }
            catch (ParserException e1) {
                return;
            }
            if (list == null || list.isEmpty()) {
                return;
            }
            FormulaHint hint = (FormulaHint)list.get(0);
            String[] params = hint.getParams();
            if (params.length == 6 && hint.name.equalsIgnoreCase("BgItem")) {
                itemCombinStr = params[0] == null ? "" : params[0];
                bgPeriodNumber = params[1] == null ? "" : params[1];
                elementNumber = params[2] == null ? "" : params[2];
                currencyNumber = params[5] == null ? "" : params[5];
                orgNumber = "";
                bgSchemeNumber = "";
                if (StringUtils.isEmpty((String)bgPeriodNumber)) {
                    beginTime = "";
                    endTime = "";
                } else {
                    beginTime = BgNFillHelper.getBeginTime(bgPeriodNumber);
                    endTime = BgNFillHelper.getEndTime(bgPeriodNumber);
                }
            }
        } else {
            return;
        }
        if (isBgForm) {
            BgFormInfo info = (BgFormInfo)value;
            bgPeriodNumber = bgPeriodNumber.equals("") ? info.getBgPeriod().getNumber() : bgPeriodNumber;
            currencyNumber = currencyNumber.equals("") ? info.getCurrency().getNumber() : currencyNumber;
            orgNumber = info.getOrgUnit().getNumber();
            bgSchemeNumber = info.getBgScheme().getNumber();
            beginTime = String.valueOf(info.getBgPeriod().getBeginDate());
            endTime = String.valueOf(info.getBgPeriod().getEndDate());
        }
        String _formula = null;
        _formula = formulaKind.equalsIgnoreCase(CMD_BGAVLBAL) || formulaKind.equalsIgnoreCase(CMD_BGAVLBALF) ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\")" : (formulaKind.equalsIgnoreCase(CMD_BGACTUALEXT) || formulaKind.equalsIgnoreCase(CMD_BGACTUALEXTF) ? (BgPeriodNVariableHelper.checkCanConvert((String)bgPeriodNumber) ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\",\"" + periodType + "\")" : "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + beginTime + "\",\"" + endTime + "\",\"" + periodType + "\")") : (formulaKind.equalsIgnoreCase(CMD_MBGACTUALS) || formulaKind.equalsIgnoreCase(CMD_BGACTUALEXTF) ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\",\"" + actualType + "\")" : (formulaKind.equalsIgnoreCase(CMD_MBGAGGREGATE) || formulaKind.equalsIgnoreCase(CMD_BGACTUALEXTF) ? "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + itemCombinStr + "\", \"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\",\"" + elementNumber + "\",\"" + currencyNumber + "\",\"" + aggregateType + "\")" : "=" + formulaKind + "(\"" + orgNumber + "\",\"" + bgSchemeNumber + "\",\"" + elementNumber + "\", \"" + itemCombinStr + "\",\"" + currencyNumber + "\",\"" + bgPeriodNumber + "\",\"" + bgPeriodNumber + "\")")));
        BgNFSHelper.setExpression(cell, _formula);
    }

    public static String checkExpression(IUIObject ui, Cell cell, String expressions, final String[] expressionStrs, final Set<String> expressionType) {
        if (StringUtils.isEmpty((String)expressions) || expressionStrs == null || expressionType == null || expressionType.isEmpty()) {
            return null;
        }
        String _expressions = null;
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)expressions);
            if (expression instanceof Ref3DExpr) {
                return expressions;
            }
            expression = ExcelFormulaPaserHelper.walk((Expression)expression, (IEditableExpressionHandler)new IEditableExpressionHandler(){

                public Expression handle(Expression expr) {
                    return BgNFillHelper.checkExpression(expr, expressionStrs, expressionType);
                }
            });
            _expressions = '=' + expression.toString();
        }
        catch (Exception ex) {
            MsgBox.showWarning((Component)((Component)ui), (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"formulaErrorDetail", (Object[])new Integer[]{cell.getRow() + 1, cell.getCol() + 1}));
            SysUtil.abort();
            logger.error((Object)expressions);
            logger.error((Object)ex);
        }
        return _expressions;
    }

    private static Expression checkExpression(Expression expression, String[] expressionStrs, Set<String> expressionType) {
        if (expression instanceof FunctionExpr) {
            expression = BgNFillHelper.checkFunctionExpr((FunctionExpr)expression, expressionStrs, expressionType);
        } else if (expression instanceof BinaryOperationExpr) {
            BgNFillHelper.checkBinaryOperationExpr((BinaryOperationExpr)expression, expressionStrs, expressionType);
        } else if (expression instanceof UnaryOperationExpr) {
            BgNFillHelper.checkUnaryOperationExpr((UnaryOperationExpr)expression, expressionStrs, expressionType);
        }
        return expression;
    }

    private static Expression checkFunctionExpr(FunctionExpr funExpr, String[] expressionStrs, Set<String> expressionType) {
        if (expressionStrs == null || expressionType == null) {
            return funExpr;
        }
        String funcionName = funExpr.funcionName.toLowerCase();
        if (expressionType.contains(funcionName)) {
            funExpr = FormulaUtils.replaceExprParams(funExpr, expressionStrs);
        }
        return funExpr;
    }

    private static void checkBinaryOperationExpr(BinaryOperationExpr boExpr, String[] expressionStrs, Set<String> expressionType) {
        BgNFillHelper.checkExpression(boExpr.left, expressionStrs, expressionType);
        BgNFillHelper.checkExpression(boExpr.right, expressionStrs, expressionType);
    }

    private static void checkUnaryOperationExpr(UnaryOperationExpr boExpr, String[] expressionStrs, Set<String> expressionType) {
    }

    public static String getBeginTime(String bgPeriodNumber) {
        String period = null;
        Date _beginDate = null;
        int year = BgNPeriodHelper.parserBgPeriodYear((String)bgPeriodNumber);
        int state = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNumber);
        switch (state) {
            case 1: {
                _beginDate = new Date(BgPeriodHelper.getFirstDay((int)year).getTime());
                break;
            }
            case 2: {
                int halfyear = BgNPeriodHelper.parserBgPeriodHalfYearOrQuarterOrMonth((String)bgPeriodNumber);
                _beginDate = new Date(BgPeriodHelper.getHalfYearFirstDay((int)year, (int)halfyear).getTime());
                break;
            }
            case 3: {
                int quarter = BgNPeriodHelper.parserBgPeriodHalfYearOrQuarterOrMonth((String)bgPeriodNumber);
                _beginDate = new Date(BgPeriodHelper.getQuarterFirstDay((int)year, (int)quarter).getTime());
                break;
            }
            case 4: {
                int month = BgNPeriodHelper.parserBgPeriodHalfYearOrQuarterOrMonth((String)bgPeriodNumber);
                _beginDate = new Date(BgPeriodHelper.getMonthFirstDay((int)year, (int)month).getTime());
                break;
            }
            case 5: {
                int week = BgNPeriodHelper.parserBgPeriodWeekOrTenDaysOrDay((String)bgPeriodNumber);
                _beginDate = new Date(BgPeriodHelper.getYearWeekFirstDay((int)year, (int)week).getTime());
                break;
            }
            case 7: {
                int month = BgNPeriodHelper.parserBgPeriodHalfYearOrQuarterOrMonth((String)bgPeriodNumber);
                int day = BgNPeriodHelper.parserBgPeriodWeekOrTenDaysOrDay((String)bgPeriodNumber);
                _beginDate = new Date(BgPeriodHelper.getDay((int)year, (int)month, (int)day).getTime());
                break;
            }
            case 9: {
                int month = BgNPeriodHelper.parserBgPeriodHalfYearOrQuarterOrMonth((String)bgPeriodNumber);
                int tendays = BgNPeriodHelper.parserBgPeriodWeekOrTenDaysOrDay((String)bgPeriodNumber);
                _beginDate = new Date(BgPeriodHelper.getTenDaysFirstDay((int)year, (int)month, (int)tendays).getTime());
            }
        }
        period = String.valueOf(_beginDate);
        return period;
    }

    public static String getEndTime(String bgPeriodNumber) {
        String period = null;
        Date _endDate = null;
        int year = BgNPeriodHelper.parserBgPeriodYear((String)bgPeriodNumber);
        int state = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNumber);
        switch (state) {
            case 1: {
                _endDate = new Date(BgPeriodHelper.getLastDay((int)year).getTime());
                break;
            }
            case 2: {
                int halfyear = BgNPeriodHelper.parserBgPeriodHalfYearOrQuarterOrMonth((String)bgPeriodNumber);
                _endDate = new Date(BgPeriodHelper.getHalfYearLastDay((int)year, (int)halfyear).getTime());
                break;
            }
            case 3: {
                int quarter = BgNPeriodHelper.parserBgPeriodHalfYearOrQuarterOrMonth((String)bgPeriodNumber);
                _endDate = new Date(BgPeriodHelper.getQuarterLastDay((int)year, (int)quarter).getTime());
                break;
            }
            case 4: {
                int month = BgNPeriodHelper.parserBgPeriodHalfYearOrQuarterOrMonth((String)bgPeriodNumber);
                _endDate = new Date(BgPeriodHelper.getMonthLastDay((int)year, (int)month).getTime());
                break;
            }
            case 5: {
                int week = BgNPeriodHelper.parserBgPeriodWeekOrTenDaysOrDay((String)bgPeriodNumber);
                _endDate = new Date(BgPeriodHelper.getYearWeekFirstDay((int)year, (int)week).getTime());
                break;
            }
            case 7: {
                int month = BgNPeriodHelper.parserBgPeriodHalfYearOrQuarterOrMonth((String)bgPeriodNumber);
                int day = BgNPeriodHelper.parserBgPeriodWeekOrTenDaysOrDay((String)bgPeriodNumber);
                _endDate = new Date(BgPeriodHelper.getDay((int)year, (int)month, (int)day).getTime());
                break;
            }
            case 9: {
                int month = BgNPeriodHelper.parserBgPeriodHalfYearOrQuarterOrMonth((String)bgPeriodNumber);
                int tendays = BgNPeriodHelper.parserBgPeriodWeekOrTenDaysOrDay((String)bgPeriodNumber);
                _endDate = new Date(BgPeriodHelper.getTenDaysLastDay((int)year, (int)month, (int)tendays).getTime());
            }
        }
        period = String.valueOf(_endDate);
        return period;
    }
}

