/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgOrgUnitLoadAllUtils {
    private static Logger logger = Logger.getLogger((String)BgOrgUnitLoadAllUtils.class.getName());
    private boolean isLoadAllOrgs = true;
    private Component owner = null;

    public BgOrgUnitLoadAllUtils(Component owner) {
        this.owner = owner;
    }

    public boolean isLoadAllOrgs() {
        return this.isLoadAllOrgs;
    }

    public void loadAllOrgTree(KDTree treeOrgUnit) {
        if (this.isLoadAllOrgs) {
            try {
                this.loadAllOrgsNode(treeOrgUnit);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                logger.error((Object)e1);
            }
        }
    }

    private void loadAllOrgsNode(KDTree treeOrgUnit) throws Exception {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeOrgUnit.getModel().getRoot();
        if (treeOrgUnit.getSelectionPath() != null) {
            root = (DefaultKingdeeTreeNode)treeOrgUnit.getSelectionPath().getLastPathComponent();
        }
        this.treeOrgUnitView(treeOrgUnit, root);
    }

    private void treeOrgUnitView(final KDTree treeOrgUnit, DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        final DefaultKingdeeTreeNode tmpNode = root;
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor(this.owner);
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgOrgUnitLoadAllUtils.this.treeOrgUnitSelectAll(treeOrgUnit, tmpNode);
                BgOrgUnitLoadAllUtils.this.isLoadAllOrgs = false;
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private void treeOrgUnitSelectAll(KDTree treeOrgUnit, DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        if (this.canTheNodeBeSelected(root)) {
            treeOrgUnit.fireTreeNodeStateChange((TreeNode)root);
        }
        DefaultKingdeeTreeNode node = null;
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            TreePath path;
            node = (DefaultKingdeeTreeNode)children.nextElement();
            if (this.canTheNodeBeSelected(node)) {
                treeOrgUnit.fireTreeNodeStateChange((TreeNode)node);
            }
            if (!treeOrgUnit.isExpanded(path = new TreePath(node.getPath()))) {
                treeOrgUnit.fireTreeWillExpand(path);
            }
            if (node.isLeaf()) continue;
            this.treeOrgUnitSelectAll(treeOrgUnit, node);
        }
    }

    private boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }
}

