/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.IFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSpecialDimRelaGroupRefCollection;
import com.kingdee.eas.ma.mbg.BgSpecialDimRelaGroupRefFactory;
import com.kingdee.eas.ma.mbg.BgSpecialDimRelaGroupRefInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsFactory;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryCollection;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.BgNTemplateProcessUI;
import com.kingdee.eas.ma.mbg.client.BgSpecialTemplateProcessUI;
import com.kingdee.eas.ma.mbg.client.action.actions.ActionDimensionChange;
import com.kingdee.eas.ma.mbg.client.common.BgDimensionPromptBox;
import com.kingdee.eas.ma.mbg.client.utils.IBgSpecialFormProcessUI;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberSelectDialog;
import com.kingdee.eas.ma.mbg.common.AbstractBookParseHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.LineFlowLayout;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSpecialBudgetHelper;
import com.kingdee.eas.ma.mbg.utils.DimSettingDisplayInfo;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgSpecialBudgetClientHelper {
    private static Logger logger = Logger.getLogger((String)BgSpecialBudgetClientHelper.class.getName());
    public static final String COL_DIMENSION = "dimension";
    public static final String COL_MEMBER = "member";
    public static final String COL_DIMRELAGROUP = "dimRelaGroup";
    public static final String COL_HIDE = "hide";
    public static final Color REQUIRED_COLOR = new Color(252, 251, 223);
    public static final String PAGE_PANEL_NAME = "pagePnl";
    public static final String DIMENSION_NUMBER = "dimensionNumber";
    public static final String DIMENSION_NAME = "dimensionName";
    public static final String MEMBER_NAME = "memberName";
    public static final String MEMBER_DISP_NAEM = "memberDisplayName";

    public static void getSpecialItemSelector(SelectorItemCollection sic) {
        sic.add("bgSpecialItems.dimensionNumber");
        sic.add("bgSpecialItems.dimensionName");
        sic.add("bgSpecialItems.memberName");
        sic.add("bgSpecialItems.memberDisplayName");
        sic.add("bgSpecialItems.canAddMember");
        sic.add("bgSpecialItems.dimensionAlias");
        sic.add("bgSpecialItems.hide");
    }

    public static BgSpecialItemsInfo getBgSpecialItemByTemplate(BgTemplateInfo bgTemplateInfo) throws BOSException {
        return BgSpecialBudgetHelper.getBgSpecialItemByTemplate(null, bgTemplateInfo);
    }

    public static BgSpecialItemsInfo getBgSpecialItemByForm(BgFormInfo bgFormInfo) throws BOSException {
        return BgSpecialBudgetHelper.getBgSpecialItemByForm(null, bgFormInfo);
    }

    public static boolean checkHasBgItemFormula(BgTemplateInfo bgTemplateInfo) {
        Book book = null;
        try {
            book = bgTemplateInfo.getBook();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return BgSpecialBudgetClientHelper.checkHasBgItemFormula(book);
    }

    public static boolean checkHasBgItemFormula(Book book) {
        boolean isHasFormula = false;
        if (book == null || book.getSheetCount() <= 0) {
            return isHasFormula;
        }
        block0: for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            int maxRow = sheet.getMaxRowIndex();
            int maxCol = sheet.getMaxColIndex();
            for (int r = 0; r <= maxRow; ++r) {
                Row row = sheet.getRow(r, false);
                if (row == null) continue;
                for (int c = 0; c <= maxCol; ++c) {
                    Cell cell = row.getCell(c, false);
                    if (!BgNFSHelper.checkHasItemFormula(cell)) continue;
                    isHasFormula = true;
                    break block0;
                }
            }
        }
        return isHasFormula;
    }

    public static BgSpecialItemsInfo queryBgSpecialItemByBgTemplate(String bgTemplateId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)bgTemplateId)) {
            return null;
        }
        return BgSpecialItemsFactory.getRemoteInstance().getBgSpecialItemsInfo("select id, dimensionNumber, dimensionName, memberName where bgTemplate = '" + bgTemplateId + "'");
    }

    public static void loadDimensionTable(KDTable dimensionTable, BgSchemeDimensionHelper schemeHelper, BgTemplateInfo bgTemplateInfo) throws EASBizException, BOSException {
        if (dimensionTable == null || bgTemplateInfo == null || schemeHelper == null) {
            return;
        }
        BgSpecialItemsInfo bgSpecialItemsInfo = bgTemplateInfo.getBgSpecialItems().get(0);
        bgSpecialItemsInfo = BgSpecialDimRelaGroupRefFactory.getRemoteInstance().addDimRelaGroupForBgSpecialItems(bgSpecialItemsInfo);
        bgTemplateInfo.getBgSpecialItems().clear();
        bgTemplateInfo.getBgSpecialItems().add(bgSpecialItemsInfo);
        BgSpecialBudgetClientHelper.loadDimensionTable(dimensionTable, schemeHelper, bgSpecialItemsInfo, null, false, false);
    }

    public static void loadDimensionTable(KDTable dimensionTable, BgSchemeDimensionHelper schemeHelper, BgSpecialItemsInfo bgSpecialItemsInfo, String orgUnitId, boolean isLoadMember, boolean isForm) throws EASBizException, BOSException {
        if (bgSpecialItemsInfo == null) {
            return;
        }
        Map<String, BgDimSettingsInfo> dimSettingMap = schemeHelper.getDimSettingMap();
        dimensionTable.setUserObject((Object)bgSpecialItemsInfo);
        Map specialDimensions = null;
        if (isLoadMember) {
            specialDimensions = MBGViewListFormFacadeFactory.getRemoteInstance().reParseSpecialCanAddMembers(bgSpecialItemsInfo, orgUnitId, schemeHelper);
            bgSpecialItemsInfo.setSpecialDimensions(specialDimensions);
        } else {
            specialDimensions = bgSpecialItemsInfo.getSpecialDimensions(schemeHelper);
        }
        if (specialDimensions.isEmpty()) {
            return;
        }
        IRow row = null;
        MbgViewListDimensionInfo bgDimensionInfo = null;
        BgDimSettingsInfo bgDimSettingInfo = null;
        for (String dimNumber : specialDimensions.keySet()) {
            bgDimensionInfo = (MbgViewListDimensionInfo)specialDimensions.get(dimNumber);
            bgDimSettingInfo = dimSettingMap.get(bgDimensionInfo.getNumber());
            row = dimensionTable.addRow();
            DimSettingDisplayInfo displayInfo = new DimSettingDisplayInfo(bgDimSettingInfo);
            if (!StringUtils.isEmpty((String)bgDimensionInfo.getAlias())) {
                displayInfo.setAlias(bgDimensionInfo.getAlias());
            }
            row.getCell(COL_DIMENSION).setValue((Object)displayInfo);
            if (isForm) {
                if (bgDimensionInfo.getCanAddMember().size() == 1) {
                    row.getCell(COL_MEMBER).setValue(bgDimensionInfo.getCanAddMember().get(0));
                } else {
                    row.getCell(COL_MEMBER).setUserObject((Object)bgDimensionInfo);
                }
            } else {
                row.getCell(COL_MEMBER).setValue((Object)MbgViewListResultData.getResultData(bgDimensionInfo));
            }
            row.getCell(COL_HIDE).setValue((Object)(!bgDimensionInfo.isShow() ? 1 : 0));
        }
        BgSpecialDimRelaGroupRefCollection colls = bgSpecialItemsInfo.getDimRelaGroupRef();
        int count = dimensionTable.getRowCount();
        for (int i = 0; i < colls.size(); ++i) {
            DimensionRelationshipGroupInfo group = colls.get(i).getDimRelaGroup();
            if (group == null) {
                return;
            }
            DimRelashipGroupEntryCollection entrys = group.getEntries();
            HashSet<String> dimensions = new HashSet<String>();
            for (int j = 0; j < entrys.size(); ++j) {
                dimensions.add(entrys.get(j).getDimNumber());
            }
            for (int index = 0; index < count; ++index) {
                DimSettingDisplayInfo dimSett = (DimSettingDisplayInfo)dimensionTable.getRow(index).getCell(COL_DIMENSION).getValue();
                if (!dimensions.contains(dimSett.getDimSettingInfo().getDimNumber())) continue;
                dimensionTable.getRow(index).getCell(COL_DIMRELAGROUP).setValue((Object)colls.get(i).getDimRelaGroup());
            }
        }
    }

    public static BgSpecialItemsInfo getNewInfo(KDTable dimensionTable, BgTemplateInfo bgTemplateInfo, BgSchemeDimensionHelper schemeHelper) {
        BgSpecialItemsInfo info = new BgSpecialItemsInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setBgTemplate(bgTemplateInfo);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.getDimRelaGroupRef().addCollection(BgSpecialBudgetClientHelper.getDimRelationshipGroup(dimensionTable, info));
        info.unParseDimensions(BgSpecialBudgetClientHelper.getSpecialDimensions(dimensionTable, schemeHelper), schemeHelper, true);
        return info;
    }

    public static BgSpecialItemsInfo getNewInfo(KDTable dimensionTable, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper) {
        BgSpecialItemsInfo info = new BgSpecialItemsInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setBgForm(bgFormInfo);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.getDimRelaGroupRef().clear();
        info.getDimRelaGroupRef().addCollection(BgSpecialBudgetClientHelper.getDimRelationshipGroup(dimensionTable, info));
        info.unParseDimensions(BgSpecialBudgetClientHelper.getSpecialDimensions(dimensionTable, schemeHelper), schemeHelper, false);
        return info;
    }

    public static BgSpecialItemsInfo getNewInfo(MbgViewListDimensionInfo memberDimension, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper) {
        BgSpecialItemsInfo info = new BgSpecialItemsInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setBgForm(bgFormInfo);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        LinkedHashMap<String, MbgViewListDimensionInfo> specialDimensions = new LinkedHashMap<String, MbgViewListDimensionInfo>();
        specialDimensions.put(memberDimension.getNumber(), memberDimension);
        info.unParseDimensions(specialDimensions, schemeHelper, false);
        return info;
    }

    public static void updateBgSpecialInfo(KDTable dimensionTable, BgTemplateInfo bgTemplateInfo, BgSchemeDimensionHelper schemeHelper) {
        if (dimensionTable == null || bgTemplateInfo == null || schemeHelper == null) {
            return;
        }
        BgSpecialItemsInfo info = bgTemplateInfo.getBgSpecialItems().get(0);
        BgSpecialBudgetClientHelper.updateBgSpecialInfo(dimensionTable, info, schemeHelper, true);
    }

    public static void updateBgSpecialInfo(KDTable dimensionTable, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper) {
        if (dimensionTable == null || bgFormInfo == null || schemeHelper == null) {
            return;
        }
        BgSpecialItemsInfo info = bgFormInfo.getBgSpecialItems().get(0);
        BgSpecialBudgetClientHelper.updateBgSpecialInfo(dimensionTable, info, schemeHelper, false);
    }

    public static void updateBgSpecialInfo(KDTable dimensionTable, BgSpecialItemsInfo info, BgSchemeDimensionHelper schemeHelper, boolean isTemplate) {
        BgSpecialBudgetClientHelper.updateBgSpecialInfo(dimensionTable, info, schemeHelper, null, isTemplate);
    }

    public static void updateBgSpecialInfo(KDTable dimensionTable, BgSpecialItemsInfo info, BgSchemeDimensionHelper schemeHelper, Integer memberValueMode, boolean isTemplate) {
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        info.getDimRelaGroupRef().clear();
        info.getDimRelaGroupRef().addCollection(BgSpecialBudgetClientHelper.getDimRelationshipGroup(dimensionTable, info));
        info.unParseDimensions(BgSpecialBudgetClientHelper.getSpecialDimensions(dimensionTable, schemeHelper), schemeHelper, isTemplate);
    }

    public static BgSpecialDimRelaGroupRefCollection getDimRelationshipGroup(KDTable dimensionTable, BgSpecialItemsInfo info) {
        if (dimensionTable == null) {
            return null;
        }
        int count = dimensionTable.getRowCount();
        HashSet<String> existGroup = new HashSet<String>();
        BgSpecialDimRelaGroupRefCollection coll = new BgSpecialDimRelaGroupRefCollection();
        for (int i = 0; i < count; ++i) {
            DimensionRelationshipGroupInfo group = (DimensionRelationshipGroupInfo)dimensionTable.getRow(i).getCell(COL_DIMRELAGROUP).getValue();
            if (group == null || existGroup.contains(group.getId().toString())) continue;
            existGroup.add(group.getId().toString());
            BgSpecialDimRelaGroupRefInfo dimRelaGroupRef = new BgSpecialDimRelaGroupRefInfo();
            dimRelaGroupRef.setDimRelaGroup(group);
            dimRelaGroupRef.setBgSpecialItems(info);
            coll.add(dimRelaGroupRef);
        }
        return coll;
    }

    public static String getSpecialItemDimNumberForBgForm(KDTable dimensionTable, BgSchemeDimensionHelper schemeHelper) {
        return BgSpecialItemsInfo.getSpecialItemDimNumberForBgForm(BgSpecialBudgetClientHelper.getSpecialDimensions(dimensionTable, schemeHelper), schemeHelper);
    }

    public static Map<String, MbgViewListDimensionInfo> getSpecialDimensions(KDTable dimensionTable, BgSchemeDimensionHelper schemeHelper) {
        LinkedHashMap<String, MbgViewListDimensionInfo> specialDimensions = new LinkedHashMap<String, MbgViewListDimensionInfo>();
        int count = dimensionTable.getRowCount();
        DimSettingDisplayInfo dimension = null;
        Object member = null;
        Object isHide = null;
        String dimNumber = null;
        StringBuffer dimName = new StringBuffer();
        StringBuffer memDisName = new StringBuffer();
        MbgViewListDimensionInfo memberDimension = null;
        for (int index = 0; index < count; ++index) {
            IRow row = dimensionTable.getRow(index);
            if (!(row.getCell(COL_DIMENSION).getValue() instanceof DimSettingDisplayInfo)) {
                return null;
            }
            dimension = (DimSettingDisplayInfo)row.getCell(COL_DIMENSION).getValue();
            member = row.getCell(COL_MEMBER).getValue();
            isHide = row.getCell(COL_HIDE).getValue();
            dimNumber = dimension.getDimSettingInfo().getDimNumber();
            dimName = dimName.append(dimension.getDimSettingInfo().getDimName()).append(",");
            memberDimension = new MbgViewListDimensionInfo(null);
            schemeHelper.getDimension(dimNumber).cloneValue(memberDimension);
            if (memberDimension.getAlias() != null) {
                memberDimension.setName(memberDimension.getAlias());
            }
            memberDimension.setAlias(dimension.getAlias());
            if (member != null) {
                if (member instanceof List) {
                    memberDimension.getCanAddMember().add((BgDimensionMember)((List)member).get(0));
                } else if (member instanceof BgDimensionMember) {
                    memberDimension.getCanAddMember().add(member);
                } else if (member instanceof MbgViewListResultData) {
                    MbgViewListResultData resultData = (MbgViewListResultData)member;
                    memberDimension.setMemberType(resultData.getMemberType());
                    memberDimension.getCanAddMember().addAll(resultData.getCanAddMembers());
                }
            }
            memberDimension.setShow(!Boolean.TRUE.equals(isHide));
            specialDimensions.put(memberDimension.getNumber(), memberDimension);
        }
        return specialDimensions;
    }

    public static Map<String, Set<String>> getFilterMapByUI(BgNTemplateProcessUI processUI) throws EASBizException, BOSException {
        if (processUI == null || processUI.getTemplateInfo() == null || processUI.getSchemeHelper() == null) {
            return null;
        }
        return BgSpecialBudgetHelper.getFilterMapByBgTemplate(null, processUI.getTemplateInfo(), processUI.getSchemeHelper());
    }

    public static Component getPageDimensionPanel(SpreadContext sc, CoreUI owerUI, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper, OrgUnitInfo orgUnitInfo) throws Exception {
        KDPanel kdPanel = new KDPanel();
        kdPanel.setLayout((LayoutManager)new BorderLayout());
        kdPanel.add(BgSpecialBudgetClientHelper.getBgSpecialItemsComponet(owerUI, bgFormInfo, schemeHelper, orgUnitInfo), (Object)"North");
        kdPanel.add((Component)sc, (Object)"Center");
        kdPanel.revalidate();
        return kdPanel;
    }

    private static Component getBgSpecialItemsComponet(CoreUI owerUI, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo == null && bgFormInfo.getOrgUnit() != null) {
            orgUnitInfo = bgFormInfo.getOrgUnit();
        }
        if (orgUnitInfo == null) {
            return null;
        }
        return BgSpecialBudgetClientHelper.parseSpecialItemsComponet(owerUI, bgFormInfo, schemeHelper, orgUnitInfo.getId().toString());
    }

    public static Component parseSpecialItemsComponet(CoreUI ownerUi, BgTemplateInfo bgTemplateInfo, BgSchemeDimensionHelper schemeHelper, String orgUnitId) throws Exception {
        KDPanel page = new KDPanel();
        page.setName(PAGE_PANEL_NAME);
        page.setLayout((LayoutManager)new LineFlowLayout(0));
        page.setEnabled(true);
        BgSpecialBudgetClientHelper.parseSpecialItemPanel(page, ownerUi, bgTemplateInfo, schemeHelper, orgUnitId);
        return page;
    }

    public static Component parseSpecialItemsComponet(CoreUI ownerUi, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper, String orgUnitId) throws Exception {
        KDPanel page = new KDPanel();
        page.setName(PAGE_PANEL_NAME);
        page.setLayout((LayoutManager)new LineFlowLayout(0));
        page.setEnabled(true);
        BgSpecialBudgetClientHelper.parseSpecialItemPanel(page, ownerUi, bgFormInfo, schemeHelper, orgUnitId);
        return page;
    }

    private static void parseSpecialItemPanel(KDPanel page, CoreUI ownerUi, BgTemplateInfo bgTemplateInfo, BgSchemeDimensionHelper schemeHelper, String orgUnitId) throws Exception {
        List<? extends BgDimensionBaseInfo> bgDimensions = BgSpecialBudgetHelper.getBgDimensionsByTemplate(null, bgTemplateInfo, schemeHelper);
        BgSpecialBudgetClientHelper.parseSpecialItemPanel(page, ownerUi, bgDimensions, schemeHelper, orgUnitId);
    }

    private static void parseSpecialItemPanel(KDPanel page, CoreUI ownerUi, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper, String orgUnitId) throws Exception {
        List<? extends BgDimensionBaseInfo> bgDimensions = BgSpecialBudgetHelper.getBgDimensionsByBgForm(null, bgFormInfo, schemeHelper);
        BgSpecialBudgetClientHelper.parseSpecialItemPanel(page, ownerUi, bgDimensions, schemeHelper, orgUnitId);
    }

    private static void parseSpecialItemPanel(KDPanel page, CoreUI ownerUi, List<? extends BgDimensionBaseInfo> bgDimensions, BgSchemeDimensionHelper schemeHelper, String orgUnitId) throws Exception {
        if (bgDimensions.isEmpty()) {
            return;
        }
        List<KDPanel> subPnl = BgSpecialBudgetClientHelper.createBgSpecialItemsPnl(ownerUi, orgUnitId, bgDimensions, false, null);
        if (!subPnl.isEmpty()) {
            for (int index = 0; index < subPnl.size(); ++index) {
                page.add((Component)subPnl.get(index));
            }
        }
    }

    private static List<KDPanel> createBgSpecialItemsPnl(CoreUI ownerUI, String orgUnitId, List<? extends BgDimensionBaseInfo> bgDimenions, boolean isF7Enable, String permissionNumber) throws Exception {
        ArrayList<KDPanel> subPnl = new ArrayList<KDPanel>();
        if (bgDimenions != null && bgDimenions.size() > 0) {
            for (int j = 0; j < bgDimenions.size(); ++j) {
                BgDimensionBaseInfo dimensionInfo = bgDimenions.get(j);
                KDPanel pnl = BgSpecialBudgetClientHelper.createSubPnl(ownerUI, orgUnitId, dimensionInfo, isF7Enable, permissionNumber);
                subPnl.add(pnl);
            }
        }
        return subPnl;
    }

    private static KDPanel createSubPnl(CoreUI ownerUI, String orgUnitId, BgDimensionBaseInfo dimensionInfo, boolean isF7Enable, String permissionNumber) throws Exception {
        if (dimensionInfo == null) {
            return null;
        }
        KDPanel subPnl = new KDPanel();
        subPnl.setName(dimensionInfo.getNumber() + "_PNL");
        subPnl.setVisible(dimensionInfo.isShow());
        subPnl.add((Component)BgSpecialBudgetClientHelper.createF7Container(ownerUI, orgUnitId, dimensionInfo, isF7Enable, permissionNumber));
        return subPnl;
    }

    private static KDLabelContainer createF7Container(CoreUI ownerUI, String orgUnitId, BgDimensionBaseInfo dimensionInfo, boolean isEnable, String permissionNumber) throws Exception {
        if (dimensionInfo == null) {
            return null;
        }
        KDBizPromptBox f7 = BgSpecialBudgetClientHelper.getDimensionF7(ownerUI, dimensionInfo, orgUnitId, isEnable);
        KDLabelContainer cont = BgSpecialBudgetClientHelper.createContainer();
        cont.setBoundLabelText(StringUtils.isEmpty((String)dimensionInfo.getAlias()) ? dimensionInfo.getName() : dimensionInfo.getAlias());
        cont.setBoundEditor((JComponent)f7);
        cont.setName("DimensionF7KDLabelContainer");
        return cont;
    }

    private static KDLabelContainer createContainer() {
        KDLabelContainer cont = new KDLabelContainer();
        cont.setBounds(new Rectangle(240, 19));
        cont.setBoundLabelLength(80);
        cont.setBoundLabelUnderline(true);
        cont.setPreferredSize(new Dimension(240, 19));
        cont.setMinimumSize(new Dimension(240, 19));
        return cont;
    }

    private static KDBizPromptBox getDimensionF7(CoreUI ownerUI, BgDimensionBaseInfo dimensionInfo, String orgUnitId, boolean isEnable) throws Exception {
        if (ownerUI == null || dimensionInfo == null) {
            return null;
        }
        KDBizPromptBox f7 = BgSpecialBudgetClientHelper.parseDimensionF7(ownerUI, dimensionInfo, orgUnitId, isEnable);
        if (f7 != null) {
            f7.setDisplayFormatter((IFormatter)new AbstractBookParseHelper.DimensionF7Formatter(dimensionInfo.getShowType()));
        }
        return f7;
    }

    private static KDBizPromptBox parseDimensionF7(CoreUI owner, BgDimensionBaseInfo dimensionInfo, String orgUnitId, boolean isEnable) {
        BgDimensionPromptBox prmt = new BgDimensionPromptBox();
        NewDimensionMemberSelectDialog dialog = new NewDimensionMemberSelectDialog((Component)owner, dimensionInfo, orgUnitId, false, false);
        HashMap<String, Set<String>> filterValueMap = new HashMap<String, Set<String>>();
        Set<String> numberSet = null;
        BgDimensionMember member = null;
        List members = dimensionInfo.getMember();
        if (members == null || members.isEmpty()) {
            members = dimensionInfo.getCanAddMember();
        }
        if (dimensionInfo.getMemberValueType().getValue() != 2 && members != null && !members.isEmpty()) {
            for (int i = 0; i < members.size(); ++i) {
                if (!(members.get(i) instanceof BgDimensionMember)) continue;
                member = (BgDimensionMember)members.get(i);
                String srcNumber = member.getSrcNumber();
                if (!filterValueMap.containsKey(srcNumber)) {
                    numberSet = new HashSet();
                    filterValueMap.put(srcNumber, numberSet);
                } else {
                    numberSet = (Set)filterValueMap.get(srcNumber);
                }
                if (numberSet == null) continue;
                numberSet.add(member.getNumber());
            }
        }
        dialog.setFilterValueMap(filterValueMap);
        dialog.setOnlySelectItem(true);
        prmt.setEditable(false);
        prmt.setCommitFormat("$number$");
        prmt.setEditFormat("$number$");
        prmt.setEnabledMultiSelection(false);
        prmt.setSelector(dialog);
        prmt.addDataChangeListener(new ActionDimensionChange((IUIObject)owner));
        prmt.setEnabled(isEnable);
        prmt.setName(dimensionInfo.getNumber());
        if (owner instanceof BgSpecialTemplateProcessUI) {
            if (dimensionInfo.getMember() != null && dimensionInfo.getMember().size() > 0) {
                prmt.setDataNoNotify(dimensionInfo.getMember().get(0));
            }
        } else if (members != null && members.size() > 0) {
            prmt.setDataNoNotify(members.get(0));
        } else {
            prmt.setDataNoNotify(null);
        }
        return prmt;
    }

    public static void fillAndbuildFormula(Book book, BgFormInfo bgFormInfo, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        BgSpecialBudgetHelper.fillAndbuildFormula(null, book, bgFormInfo, schemeHelper);
    }

    public static void removeEditHelper(KDTable table) {
        if (table != null) {
            ActionMap am = table.getActionMap();
            am.remove("Cut");
            am.remove("Paste");
            am.remove("Copy");
            am.remove("Delete");
        }
    }

    public static void fillSpecialItem(Object ownerUi) {
        if (ownerUi instanceof IBgSpecialFormProcessUI) {
            ((IBgSpecialFormProcessUI)ownerUi).fillSpecialItem();
        }
    }

    public static void addItemFormulaCell(Object ownerUi, Cell cell) {
        if (ownerUi instanceof IBgSpecialFormProcessUI) {
            ((IBgSpecialFormProcessUI)ownerUi).addCell(cell);
        }
    }

    public static void afterFillItemFormula(Object ownerUi) {
        if (ownerUi instanceof IBgSpecialFormProcessUI) {
            ((IBgSpecialFormProcessUI)ownerUi).afterFill();
        }
    }
}

