/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectSingleKey;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.SQLFacadeFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgTypeFactory;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.IBgType;
import com.kingdee.eas.ma.mbg.MBgAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.client.MBGAddActualFormProcessUI;
import com.kingdee.eas.ma.mbg.client.MBGFormProcessUI;
import com.kingdee.eas.ma.mbg.client.form.BgViewAdjustProvider;
import com.kingdee.eas.ma.mbg.client.form.MBGBaseFormContextManager;
import com.kingdee.eas.ma.mbg.client.template.MBGContextManager;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.provider.form.MBGBaseFormProvider;
import com.kingdee.eas.ma.mbg.provider.form.MBGFormProvider;
import com.kingdee.eas.ma.mbg.query.BgAnalyseConstants;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class BgViewClientHelper {
    public static final String RES_CLIENT = "com.kingdee.eas.ma.mbg.client.BgViewClientResource";

    public static String getString(String key) {
        return EASResource.getString((String)RES_CLIENT, (String)key);
    }

    public static BgTypeInfo getSelfBgTYpe() {
        BgTypeInfo info = null;
        try {
            IBgType bgType = BgTypeFactory.getRemoteInstance();
            info = bgType.getBgTypeInfo((IObjectPK)new ObjectSingleKey((Object)"bgMAAAAKIcA7rHKd"));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return info;
    }

    public static BgTypeInfo getBgTYpe(String bgTypeId) {
        BgTypeInfo info = null;
        try {
            IBgType bgType = BgTypeFactory.getRemoteInstance();
            info = bgType.getBgTypeInfo((IObjectPK)new ObjectSingleKey((Object)bgTypeId));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return info;
    }

    public static void afterDataFill_PeriodName(KDTable tblMain, KDTDataRequestEvent e) {
        if (e == null || tblMain.getColumn("bgPeriod.number") == null || !tblMain.getColumn("bgPeriod.number").getStyleAttributes().isHided()) {
            return;
        }
        IRow row = null;
        String pnumber = null;
        String pname = null;
        int in = e.getLastRow();
        for (int i = e.getFirstRow(); i <= in; ++i) {
            row = tblMain.getRow(i);
            pname = (String)row.getCell("bgPeriod.name").getValue();
            pnumber = (String)row.getCell("bgPeriod.number").getValue();
            if (StringUtils.isEmpty((String)pnumber)) continue;
            String prefix = pnumber.substring(0, 4);
            pname = pname + "(" + prefix + ")";
            row.getCell("bgPeriod.name").setValue((Object)pname);
        }
    }

    public static void checkItemDimeinsionEmpty(CoreUI ui, IBgDimensionManagerBase bm) {
        if (ui != null && bm != null) {
            for (int i = 0; i < bm.getDimension().size(); ++i) {
                BgDimensionInfo dimen = (BgDimensionInfo)bm.getDimension().get(i);
                if (!"BGITEM".equalsIgnoreCase(dimen.getType()) || !dimen.getMember().isEmpty()) continue;
                String msg = dimen.getAttribute();
                if (dimen.getAttribute().indexOf(",") > 0) {
                    msg = msg.substring(msg.lastIndexOf(",") + 1);
                }
                msg = MessageFormat.format(BgViewClientHelper.getString("noBgItemMember"), msg);
                MsgBox.showInfo((Component)ui, (String)msg);
            }
        }
    }

    public static void reloadBookFormBgForm(MBGBaseFormContextManager contextManager) throws Exception {
        BgViewClientHelper.reloadBookFormBgForm(contextManager, false);
    }

    public static void reloadBookFormBgForm(MBGBaseFormContextManager contextManager, boolean isOnlyLoadBook) throws Exception {
        Book book = null;
        if (isOnlyLoadBook) {
            if (contextManager.getProvider() instanceof MBGFormProvider) {
                book = ((MBGFormProvider)contextManager.getProvider()).loadBook();
            }
        } else {
            book = (Book)((MBGBaseFormProvider)contextManager.getProvider()).load();
        }
        contextManager.getSpreadContext().setBook(book);
        contextManager.registerFormulaToBook();
        contextManager.getProvider().fillData(contextManager.getSpreadContext().getBook());
        BgViewClientHelper.checkItemDimeinsionEmpty(contextManager.getOwnerUI(), contextManager.getProvider().getBgDimensionManager());
        contextManager.getSpreadContext().getBook().getUndoManager().discardAllEdits();
        contextManager.enableCal();
        contextManager.getSpreadContext().repaint();
        if (contextManager.getOwnerUI() instanceof MBGFormProcessUI) {
            try {
                ((MBGFormProcessUI)contextManager.getOwnerUI()).actionCalculate_actionPerformed(new ActionEvent(contextManager.getOwnerUI(), 0, MBGFormProcessUI.class.getName() + "$ActionCalculate"));
            }
            catch (Exception e1) {
                contextManager.getOwnerUI().handUIExceptionAndAbort(e1);
            }
        } else if (contextManager.getOwnerUI() instanceof MBGAddActualFormProcessUI) {
            try {
                ((MBGAddActualFormProcessUI)contextManager.getOwnerUI()).actionCalculate_actionPerformed(new ActionEvent(contextManager.getOwnerUI(), 0, MBGAddActualFormProcessUI.class.getName() + "$ActionCalculate"));
            }
            catch (Exception e1) {
                contextManager.getOwnerUI().handUIExceptionAndAbort(e1);
            }
        }
    }

    public static Set<String> getMbgOrgUnitNumber(KDBizPromptBox prmtOrgUnit) {
        HashSet<String> numberSet = new HashSet<String>();
        if (prmtOrgUnit == null) {
            return numberSet;
        }
        List<OrgUnitInfo> orgUnits = BgViewClientHelper.getOrgUnitFromPromptBox(prmtOrgUnit);
        String curLongNumber = null;
        String[] numbers = null;
        for (OrgUnitInfo info : orgUnits) {
            curLongNumber = info.getLongNumber();
            for (String num : numbers = curLongNumber.split(BgBaseConstants.SEP_ONE_STR)) {
                if (StringUtils.isEmpty((String)num) || numberSet.contains(num)) continue;
                numberSet.add(num);
            }
        }
        return numberSet;
    }

    public static List<OrgUnitInfo> getOrgUnitFromPromptBox(KDBizPromptBox prmtOrgunit) {
        ArrayList<OrgUnitInfo> orgUnits = new ArrayList<OrgUnitInfo>();
        if (prmtOrgunit == null) {
            return orgUnits;
        }
        if (prmtOrgunit.getData() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] _orgUnits = (OrgUnitInfo[])prmtOrgunit.getData();
            int in = _orgUnits.length;
            for (int i = 0; i < in; ++i) {
                orgUnits.add(_orgUnits[i]);
            }
        } else if (prmtOrgunit.getData() instanceof OrgUnitInfo) {
            OrgUnitInfo _orgUnit = (OrgUnitInfo)prmtOrgunit.getData();
            orgUnits.add(_orgUnit);
        }
        return orgUnits;
    }

    public static List<String> getMbgSchemeInfo(List<OrgUnitInfo> orgUnits) throws Exception {
        List bgSchemeIds = null;
        if (orgUnits == null || orgUnits.isEmpty()) {
            return bgSchemeIds;
        }
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        for (OrgUnitInfo orgUnit : orgUnits) {
            orgUnitIds.add(orgUnit.getId().toString());
        }
        bgSchemeIds = MBgAnalyseFacadeFactory.getRemoteInstance().getCommRootScheme(orgUnitIds);
        return bgSchemeIds;
    }

    public static void setBgSchemeF7(KDBizPromptBox prmtOrgUnit, KDBizPromptBox prmtBgScheme) throws Exception {
        prmtBgScheme.setData(null);
        if (prmtOrgUnit.getData() != null) {
            EntityViewInfo view = prmtBgScheme.getEntityViewInfo();
            if (view == null) {
                view = new EntityViewInfo();
            }
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("isFiling", (Object)Boolean.FALSE, CompareType.EQUALS));
            Set<String> numberSet = BgViewClientHelper.getMbgOrgUnitNumber(prmtOrgUnit);
            view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.number", numberSet, CompareType.INCLUDE));
            prmtBgScheme.setEntityViewInfo(view);
        }
    }

    public static void prmtScheme_willShow(Component owner, KDBizPromptBox prmtOrgUnit) {
        if (prmtOrgUnit.getData() == null) {
            prmtOrgUnit.requestFocus(true);
            MsgBox.showWarning((Component)owner, (String)BgCommCHelper.getMessageStr((String)BgAnalyseConstants.ANALYSE_RESOURCESTR, (String)"selectOrgUnit"));
            SysUtil.abort();
        }
    }

    public static SelectorItemCollection getBgSchemeSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("dateFrom");
        sic.add("dateTo");
        sic.add("period");
        sic.add("refCube");
        sic.add("orgUnit.*");
        return sic;
    }

    public static void addBeforeAction(CoreUI owner, KDTree treeOrgUnit, BOSUuid orgViewId, BOSUuid orgUnitId, boolean isContainSealUp, boolean isOnlyNoLeaf) {
        BgViewClientHelper.addBeforeAction(owner, treeOrgUnit, orgViewId, orgUnitId, isContainSealUp, true, isOnlyNoLeaf, null);
    }

    public static void addBeforeAction(CoreUI owner, KDTree treeOrgUnit, BOSUuid orgViewId, BOSUuid orgUnitId, boolean isContainSealUp, boolean isShowVirtualOrg, boolean isOnlyNoLeaf, Set canDisplayOrgNumbers) {
        JMenuItem menuItem = null;
        boolean isLoadCurSelect = false;
        ActionListener[] lis = null;
        for (int i = 0; i < treeOrgUnit.getPopupMenu().getComponentCount(); ++i) {
            if (!(treeOrgUnit.getPopupMenu().getComponent(i) instanceof JMenuItem)) continue;
            menuItem = (JMenuItem)treeOrgUnit.getPopupMenu().getComponent(i);
            if ("actopenll".equals(menuItem.getActionCommand())) {
                isLoadCurSelect = true;
                lis = menuItem.getActionListeners();
            } else if ("actopenall".equals(menuItem.getActionCommand())) {
                isLoadCurSelect = false;
                lis = menuItem.getActionListeners();
            } else {
                lis = null;
            }
            if (lis == null || lis.length <= 0) continue;
            for (int l = 0; l < lis.length; ++l) {
                BeforeAction action = null;
                if (lis[l] instanceof BeforeAction) {
                    action = (BeforeAction)lis[l];
                } else {
                    action = new BeforeAction(owner, treeOrgUnit, lis[l], isLoadCurSelect, isShowVirtualOrg, isOnlyNoLeaf, canDisplayOrgNumbers);
                    menuItem.removeActionListener(lis[l]);
                    menuItem.addActionListener(action);
                }
                action.orgViewId = orgViewId;
                action.orgUnitId = orgUnitId;
                action.isContainSealUp = isContainSealUp;
            }
        }
    }

    private static void loadAllNode(CoreUI owner, final KDTree treeOrgUnit, final boolean isLoadCurSelect, final BOSUuid orgViewId, final BOSUuid orgUnitId, final boolean isContainSealUp, final boolean isShowVirtualOrg, final boolean isOnlyNoLeaf, final Set canDisplayOrgNumbers) {
        if (treeOrgUnit.getModel() == treeOrgUnit.getUserObject()) {
            return;
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)owner);
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgViewClientHelper.loadAllNode(treeOrgUnit, isLoadCurSelect, orgViewId, orgUnitId, isContainSealUp, isShowVirtualOrg, isOnlyNoLeaf, canDisplayOrgNumbers);
                treeOrgUnit.setUserObject((Object)treeOrgUnit.getModel());
                treeOrgUnit.updateUI();
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private static void loadAllNode(KDTree treeOrgUnit, boolean isLoadCurSelect, BOSUuid orgViewId, BOSUuid orgUnitId, boolean isContainSealUp, boolean isShowVirtualOrg, boolean isOnlyNoLeaf, Set canDisplayOrgNumbers) {
        try {
            TreeModel treeModel = BgOrgUnitFactory.getRemoteInstance().getFullBgOrgModel(orgViewId.toString(), null, isContainSealUp, false, true, isShowVirtualOrg, isOnlyNoLeaf);
            HashMap<String, DefaultKingdeeTreeNode> nodes = new HashMap<String, DefaultKingdeeTreeNode>();
            BgViewClientHelper.addNodeToMap((DefaultKingdeeTreeNode)treeModel.getRoot(), nodes);
            BgViewClientHelper.copy((DefaultKingdeeTreeNode)treeOrgUnit.getModel().getRoot(), nodes, treeOrgUnit.getModel().getRoot(), canDisplayOrgNumbers);
            treeOrgUnit.updateUI();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private static void addNodeToMap(DefaultKingdeeTreeNode node, Map<String, DefaultKingdeeTreeNode> nodes) {
        BgOrgUnitInfo org = null;
        DefaultKingdeeTreeNode child = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            BgOrgUnitUtils.setLoadChild(node);
            BgOrgUnitUtils.dealBgNode(node, false);
            child = (DefaultKingdeeTreeNode)node.getChildAt(i);
            org = (BgOrgUnitInfo)child.getUserObject();
            if (org == null) continue;
            nodes.put(org.getId().toString(), child);
            BgViewClientHelper.addNodeToMap(child, nodes);
        }
    }

    private static void copy(DefaultKingdeeTreeNode node, Map<String, DefaultKingdeeTreeNode> nodes, Object root, Set canDisplayOrgNumbers) {
        if (root == node || BgOrgUnitUtils.isLoadedChild(node)) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                BgViewClientHelper.copy((DefaultKingdeeTreeNode)node.getChildAt(i), nodes, root, canDisplayOrgNumbers);
            }
        } else {
            int i;
            BgOrgUnitInfo bgOrgUnit = (BgOrgUnitInfo)node.getUserObject();
            if (bgOrgUnit.isIsLeaf() || !nodes.containsKey(bgOrgUnit.getId().toString())) {
                return;
            }
            BgOrgUnitUtils.setLoadChild(node);
            DefaultKingdeeTreeNode source = nodes.get(bgOrgUnit.getId().toString());
            node.removeAllChildren();
            ArrayList<DefaultKingdeeTreeNode> nodeList = new ArrayList<DefaultKingdeeTreeNode>();
            for (i = 0; i < source.getChildCount(); ++i) {
                if ((DefaultKingdeeTreeNode)source.getChildAt(i) != null && ((DefaultKingdeeTreeNode)source.getChildAt(i)).getUserObject() instanceof BgOrgUnitInfo && canDisplayOrgNumbers != null && !canDisplayOrgNumbers.isEmpty() && !canDisplayOrgNumbers.contains(((BgOrgUnitInfo)((DefaultKingdeeTreeNode)source.getChildAt(i)).getUserObject()).getNumber())) continue;
                nodeList.add((DefaultKingdeeTreeNode)source.getChildAt(i));
            }
            for (i = 0; i < nodeList.size(); ++i) {
                node.add((MutableTreeNode)nodeList.get(i));
            }
        }
    }

    public static void checkBgAdjustDataMap(Map<String, Map<String, BgAdjustFormDiversityData>> adjustDataMap) {
        if (adjustDataMap == null || adjustDataMap.isEmpty()) {
            return;
        }
        if (BgViewClientHelper.isDeleteAllData()) {
            return;
        }
        boolean check = true;
        Map<String, BgAdjustFormDiversityData> tmpMap = null;
        BgAdjustFormDiversityData bgData2 = null;
        Iterator<Map<String, BgAdjustFormDiversityData>> iter = adjustDataMap.values().iterator();
        block0: while (iter.hasNext() && check) {
            tmpMap = iter.next();
            for (BgAdjustFormDiversityData bgData2 : tmpMap.values()) {
                if (bgData2 == null || bgData2.getNewValue() == null) continue;
                check = false;
                continue block0;
            }
        }
        if (check) {
            adjustDataMap.clear();
        }
    }

    public static void checkBgDataMap(Map<String, Map<String, BgNViewDataInfo>> mbgDataMap, int valueType) {
        if (mbgDataMap == null || mbgDataMap.isEmpty()) {
            return;
        }
        if (BgViewClientHelper.isDeleteAllData()) {
            return;
        }
        boolean check = true;
        Map<String, BgNViewDataInfo> tmpMap = null;
        BgNViewDataInfo bgData2 = null;
        Iterator<Map<String, BgNViewDataInfo>> iter = mbgDataMap.values().iterator();
        block0: while (iter.hasNext() && check) {
            tmpMap = iter.next();
            for (BgNViewDataInfo bgData2 : tmpMap.values()) {
                if (bgData2 == null) continue;
                if (valueType == 1) {
                    if (bgData2.getBudgetValueNoDef() == null) continue;
                    check = false;
                    continue block0;
                }
                if (valueType == 64 || valueType == 128) {
                    if (bgData2.getBudgetValueNoDef() == null && bgData2.getBizActualNoDef() == null) continue;
                    check = false;
                    continue block0;
                }
                if (valueType != 16 || bgData2.getAddActualNoDef() == null) continue;
                check = false;
                continue block0;
            }
        }
        if (check) {
            mbgDataMap.clear();
        }
    }

    public static void confirmClearWidth(MBGContextManager contextManager, IMbgSheetManager sheetManager) {
        int rs;
        if (BgViewClientHelper.isSetWidth(sheetManager) && (rs = MsgBox.showConfirm2New((Component)contextManager.getOwnerUI(), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"confirmClearWidth"))) == 1) {
            sheetManager.getWidthMap().clear();
        }
    }

    private static boolean isSetWidth(IMbgSheetManager sheetManager) {
        int defRowWidth = sheetManager.getWidth(true, -1);
        int defColWidth = sheetManager.getWidth(false, -1);
        int defWidth = -1;
        for (Map.Entry<String, Integer> entry : sheetManager.getWidthMap().entrySet()) {
            defWidth = entry.getKey().startsWith("row") ? defRowWidth : defColWidth;
            if (defWidth == entry.getValue()) continue;
            return true;
        }
        return false;
    }

    public static void checkOrgBeforeAction(MBGFormProvider provider, Sheet sheet) {
        String curOrgNumForBgForm;
        if (provider == null || sheet == null || provider.getOrgUnitInfo() == null || !(provider instanceof MBGFormProvider)) {
            return;
        }
        int sheetIndex = sheet.getIndex();
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((IMbgViewManager)provider.getCurMbgViewManager()).getSheetManagers().get(sheetIndex).getDimensionManager());
        if (!isorgOnPageOrView) {
            return;
        }
        String curOrgNumForDimensionData = provider.getOrgNumsForCurSheet(sheetIndex, new HashSet<String>());
        if (!curOrgNumForDimensionData.equals(curOrgNumForBgForm = provider.getOrgUnitInfo().getNumber())) {
            MsgBox.showInfo((String)EASResource.getString((String)RES_CLIENT, (String)"pleaseChooseFormOrg"));
            SysUtil.abort();
        }
    }

    public static void checkSelfOrg(MBGContextManager contextManager) {
        if (contextManager.getProvider() instanceof BgViewAdjustProvider) {
            BgViewClientHelper.checkOrgBeforeAction((BgViewAdjustProvider)contextManager.getProvider(), contextManager.getSpreadContext().getBook().getActiveSheet());
        }
    }

    public static void resetTreeSelectPathNoNotify(KDTree tree, TreePath oldPath) {
        if (tree == null || oldPath == null) {
            return;
        }
        TreeSelectionListener[] lns = tree.getTreeSelectionListeners();
        if (lns != null) {
            for (TreeSelectionListener ln : lns) {
                tree.removeTreeSelectionListener(ln);
            }
        }
        tree.setSelectionPath(oldPath);
        if (lns != null) {
            for (TreeSelectionListener ln : lns) {
                tree.addTreeSelectionListener(ln);
            }
        }
    }

    public static String getBudgetViewID(String bgSchemeId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bgDimSettings.bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)2, CompareType.EQUALS));
        CoreBaseCollection coll = BgDimSettingsMemberFactory.getRemoteInstance().getCollection(view);
        if (coll != null && coll.size() != 0) {
            return ((BgDimSettingsMemberInfo)coll.get(0)).getMemberID().toString();
        }
        return null;
    }

    protected static boolean isDeleteAllData() {
        boolean paramValue = false;
        try {
            IRowSet rst = SQLFacadeFactory.getRemoteInstance().getRowset("SELECT FVALUE FROM T_MBG_PARAM where FNUMBER = 'deleteAllData'");
            if (rst != null && rst.next()) {
                paramValue = Boolean.parseBoolean(rst.getString(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return paramValue;
    }

    private static class BeforeAction
    implements ActionListener {
        CoreUI owner = null;
        KDTree treeOrgUnit = null;
        ActionListener listener = null;
        boolean isLoadCurSelect = false;
        BOSUuid orgViewId = null;
        BOSUuid orgUnitId = null;
        boolean isContainSealUp = false;
        boolean isShowVirtualOrg = true;
        boolean isOnlyNoLeaf = false;
        Set canDisplayOrgNumbers = null;

        private BeforeAction(CoreUI owner, KDTree treeOrgUnit, ActionListener listener, boolean isLoadCurSelect, boolean isShowVirtualOrg, boolean isOnlyNoLeaf, Set canDisplayOrgNumbers) {
            this.owner = owner;
            this.treeOrgUnit = treeOrgUnit;
            this.listener = listener;
            this.isLoadCurSelect = isLoadCurSelect;
            this.isShowVirtualOrg = isShowVirtualOrg;
            this.isOnlyNoLeaf = isOnlyNoLeaf;
            this.canDisplayOrgNumbers = canDisplayOrgNumbers;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgViewClientHelper.loadAllNode(this.owner, this.treeOrgUnit, this.isLoadCurSelect, this.orgViewId, this.orgUnitId, this.isContainSealUp, this.isShowVirtualOrg, this.isOnlyNoLeaf, this.canDisplayOrgNumbers);
            this.listener.actionPerformed(e);
        }
    }
}

