/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.data.impl.DataSetWrapperFactory;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgPropertySortCollection;
import com.kingdee.eas.ma.base.BgPropertySortFactory;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.IBgProperty;
import com.kingdee.eas.ma.base.IBgPropertySort;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgViewFactory;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.MemberSegregationRuleEnum;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.MbgDimHelper;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListResultData;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.ma.mbg.utils.SourceDisplayInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgViewMemberSelectHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgViewMemberSelectHelper.class);
    public static final String COL_ID = "id";
    public static final String COL_NUMBER = "number";
    public static final String COL_NAME = "name";
    public static final String COL_DESC = "description";
    public static final String COL_LEVEL = "level";
    public static final String COL_LONGNUMBER = "longNumber";
    public static final String COL_ISLEAF = "isLeaf";
    public static final String COL_PROSORT = "proSortName";
    public static final String COL_DIMENSION = "dimension";
    public static final String COL_FILLTYPE = "fillType";
    public static final String COL_ALIAS = "alias";
    public static final String COL_ORG_UNIT = "orgUnit";
    public static Color lockColor = new Color(230, 230, 230);

    public static void doubleVaClick(KDTable tblVaLeft, KDTable tblVaRight, boolean isMultiSelect, boolean isPro) throws Exception {
        BgViewMemberSelectHelper.doubleVaClick(tblVaLeft, tblVaRight, isMultiSelect, isPro, false);
    }

    public static void doubleVaClick(KDTable tblVaLeft, KDTable tblVaRight, boolean isMultiSelect, boolean isPro, boolean isAddAfterActive) throws Exception {
        int currRowIndex = tblVaLeft.getSelectManager().getActiveRowIndex();
        if (currRowIndex >= 0) {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            rows.add(currRowIndex);
            BgViewMemberSelectHelper.addRows(rows, tblVaLeft, tblVaRight, isMultiSelect, isPro, isAddAfterActive);
        }
    }

    public static void addRows(List<Integer> rows, KDTable tblVaLeft, KDTable tblVaRight, boolean isMultiSelect, boolean isPro) throws EASBizException, BOSException {
        BgViewMemberSelectHelper.addRows(rows, tblVaLeft, tblVaRight, isMultiSelect, isPro, false);
    }

    public static void addRows(List<Integer> rows, KDTable tblVaLeft, KDTable tblVaRight, boolean isMultiSelect, boolean isPro, boolean isAddAfterActive) throws EASBizException, BOSException {
        int i;
        int active;
        IRow rowRight;
        if (rows == null) {
            return;
        }
        Collections.sort(rows);
        HashSet<String> selectedNumbers = new HashSet<String>();
        String num = null;
        Object obj = null;
        for (int i2 = 0; i2 < tblVaRight.getRowCount(); ++i2) {
            rowRight = tblVaRight.getRow(i2);
            obj = isPro ? rowRight.getCell(COL_ID).getValue() : rowRight.getCell(COL_NUMBER).getValue();
            if (obj == null) continue;
            if (obj instanceof String) {
                num = (String)obj;
            } else if (obj instanceof NumberExpandInfo) {
                num = ((NumberExpandInfo)obj).getNumber();
            }
            if (num == null) continue;
            selectedNumbers.add(num);
        }
        int count = active = tblVaRight.getSelectManager().getActiveRowIndex();
        int index = 0;
        boolean hasHide = false;
        for (i = 0; i < tblVaRight.getRowCount(); ++i) {
            rowRight = tblVaRight.getRow(i);
            if (!rowRight.getStyleAttributes().isHided()) {
                index = i;
                continue;
            }
            hasHide = true;
        }
        for (i = 0; i < rows.size(); ++i) {
            IRow rowLeft = tblVaLeft.getRow(rows.get(i).intValue());
            String number = null;
            obj = isPro ? rowLeft.getCell(COL_ID).getValue() : rowLeft.getCell(COL_NUMBER).getValue();
            if (obj instanceof String) {
                number = (String)obj;
            } else if (obj instanceof NumberExpandInfo) {
                number = ((NumberExpandInfo)obj).getNumber();
            }
            if (selectedNumbers.contains(number)) continue;
            if (!isMultiSelect && tblVaRight.getRowCount() >= 1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"singleSelect"));
                return;
            }
            rowRight = isAddAfterActive ? (active >= 0 ? tblVaRight.addRow(++count) : (hasHide ? tblVaRight.addRow(index + 1 + i) : tblVaRight.addRow())) : tblVaRight.addRow();
            rowRight.getCell(COL_ID).setValue(rowLeft.getCell(COL_ID).getValue());
            rowRight.getCell(COL_NUMBER).setValue(rowLeft.getCell(COL_NUMBER).getValue());
            rowRight.getCell(COL_NAME).setValue(rowLeft.getCell(COL_NAME).getValue());
            if (rowRight.getCell(COL_DESC) != null) {
                rowRight.getCell(COL_DESC).setValue(rowLeft.getCell(COL_DESC).getValue());
            }
            if (!isPro || rowLeft.getCell(COL_PROSORT) == null || rowRight.getCell(COL_PROSORT) == null) continue;
            rowRight.getCell(COL_PROSORT).setValue(rowLeft.getCell(COL_PROSORT).getValue());
        }
    }

    public static void addMemberRows(CoreUI owner, List rows, KDTable tblLeft, KDTable tblRight, BgDimensionBaseInfo dimension, int type, Boolean isMultiSelect, boolean isOnlyLeaf) {
        BgViewMemberSelectHelper.addMemberRows(owner, rows, tblLeft, tblRight, dimension, type, isMultiSelect, isOnlyLeaf, false, false, null);
    }

    public static void addMemberRows(CoreUI owner, List rows, KDTable tblLeft, KDTable tblRight, BgDimensionBaseInfo dimension, int type, Boolean isMultiSelect, boolean isOnlyLeaf, boolean isAddAfterActive, boolean isTree, Map<String, String> numLongNumMap) {
        int active;
        if (rows == null || rows.isEmpty()) {
            return;
        }
        DimensionMemberTypeEnum fillType = null;
        String number = null;
        boolean tag = false;
        HashSet<String> selectedNumbers = new HashSet<String>();
        for (int i = 0; i < tblRight.getRowCount(); ++i) {
            dimension = ((SourceDisplayInfo)tblRight.getCell(i, COL_DIMENSION).getValue()).getDimension();
            number = NumberExpandHelper.getNumber((IRow)tblRight.getRow(i));
            if (tblRight.getCell(i, COL_FILLTYPE).getValue() instanceof DimensionMemberTypeEnum) {
                fillType = (DimensionMemberTypeEnum)((Object)tblRight.getCell(i, COL_FILLTYPE).getValue());
            }
            if (fillType == null) continue;
            selectedNumbers.add(dimension.getNumber() + "_" + number + "_" + fillType.getValue());
        }
        int count = active = tblRight.getSelectManager().getActiveRowIndex();
        int index = 0;
        boolean hasHide = false;
        for (int i = 0; i < tblRight.getRowCount(); ++i) {
            IRow rowRight = tblRight.getRow(i);
            if (!rowRight.getStyleAttributes().isHided()) {
                index = i;
                continue;
            }
            hasHide = true;
        }
        boolean hasNoLeaf = false;
        if (isAddAfterActive && active < 0 && !hasHide && isTree && !DimensionConstants.filterMemberDim.contains(dimension.getType())) {
            Integer[] arr = rows.toArray(new Integer[rows.size()]);
            int temp = 0;
            for (int i = 0; i < arr.length - 1; ++i) {
                for (int j = 0; j < arr.length - i - 1; ++j) {
                    int level2;
                    int rowIndex1 = arr[j];
                    int rowIndex2 = arr[j + 1];
                    int level1 = Integer.valueOf(tblLeft.getRow(rowIndex1).getCell(COL_LEVEL).getValue().toString());
                    if (level1 <= (level2 = Integer.valueOf(tblLeft.getRow(rowIndex2).getCell(COL_LEVEL).getValue().toString()).intValue())) continue;
                    temp = arr[j];
                    arr[j] = arr[j + 1];
                    arr[j + 1] = temp;
                }
            }
            rows = Arrays.asList(arr);
        }
        for (int i = 0; i < rows.size(); ++i) {
            int rowIndex = (Integer)rows.get(i);
            IRow row = tblLeft.getRow(rowIndex);
            if (row.getStyleAttributes().isHided()) continue;
            if (0 == type && isOnlyLeaf && row.getCell(COL_NUMBER).getValue() instanceof NumberExpandInfo && !((NumberExpandInfo)row.getCell(COL_NUMBER).getValue()).isLeaf()) {
                hasNoLeaf = true;
                continue;
            }
            number = NumberExpandHelper.getNumber((IRow)row);
            if (selectedNumbers.contains(dimension.getNumber() + "_" + number + "_" + type)) continue;
            if (!BgNumberHelper.checkNumber((String)number)) {
                tag = true;
                continue;
            }
            if (!isMultiSelect.booleanValue() && tblRight.getRowCount() >= 1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"singleSelect"));
                return;
            }
            String compareValue = NumberExpandHelper.getNumber((IRow)row);
            IRow newRow = null;
            ++count;
            if (isAddAfterActive) {
                if (active >= 0) {
                    newRow = tblRight.addRow(count);
                } else if (hasHide) {
                    newRow = tblRight.addRow(index + 1 + i);
                } else if (isTree && !DimensionConstants.filterMemberDim.contains(dimension.getType())) {
                    if (numLongNumMap.containsKey(compareValue)) {
                        String longNumber = numLongNumMap.get(compareValue);
                        int flag = -1;
                        String num = null;
                        String pNum = null;
                        for (int j = 0; j < tblRight.getRowCount(); ++j) {
                            num = NumberExpandHelper.getNumber((IRow)tblRight.getRow(j));
                            if (longNumber == null) continue;
                            if (longNumber.equals(num)) {
                                pNum = num;
                                flag = j;
                            }
                            if (pNum == null || numLongNumMap.get(num) == null || !numLongNumMap.get(num).equals(pNum)) continue;
                            flag = j;
                        }
                        newRow = flag != -1 ? tblRight.addRow(flag + 1) : tblRight.addRow();
                    } else {
                        newRow = tblRight.addRow();
                    }
                } else {
                    newRow = tblRight.addRow();
                }
            } else {
                newRow = tblRight.addRow();
            }
            newRow.getCell(COL_DIMENSION).setValue((Object)new SourceDisplayInfo(dimension));
            newRow.getCell(COL_NUMBER).setValue((Object)compareValue);
            newRow.getCell(COL_NAME).setValue(row.getCell(COL_NAME).getValue());
            newRow.getCell(COL_FILLTYPE).setValue((Object)DimensionMemberTypeEnum.getEnum(type));
            if (newRow.getCell(COL_DESC) != null) {
                newRow.getCell(COL_DESC).setValue(row.getCell(COL_DESC).getValue());
            }
            if (newRow.getCell(COL_ORG_UNIT) != null) {
                newRow.getCell(COL_ORG_UNIT).setValue(row.getCell(COL_ORG_UNIT).getValue());
            }
            if (type != 0 && !(row.getUserObject() instanceof TreeBaseInfo)) continue;
        }
        if (tag) {
            MsgBox.showInfo((Component)owner, (String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgTemplateResource", (String)"checkMemberNumber"));
        } else if (hasNoLeaf) {
            MsgBox.showInfo((Component)owner, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"selectLeafMember"));
        }
    }

    public static void addPeriodRows(CoreUI ownerUi, List<Integer> rows, KDTable tblLeft, KDTable tblRight, Boolean isMultiSelect, boolean isOnlyLeaf) throws EASBizException, BOSException {
        IRow rowLeft;
        IRow rowRight;
        int i;
        if (rows == null) {
            return;
        }
        Collections.sort(rows);
        HashSet<String> selectedNumbers = new HashSet<String>();
        HashSet<String> allNumbers = new HashSet<String>();
        for (i = 0; i < tblRight.getRowCount(); ++i) {
            rowRight = tblRight.getRow(i);
            selectedNumbers.add((String)rowRight.getCell(COL_NUMBER).getValue());
        }
        allNumbers.addAll(selectedNumbers);
        for (i = 0; i < rows.size(); ++i) {
            rowLeft = tblLeft.getRow(rows.get(i).intValue());
            String number = null;
            if (!(rowLeft.getCell(COL_NUMBER).getValue() instanceof NumberExpandInfo)) continue;
            number = ((NumberExpandInfo)rowLeft.getCell(COL_NUMBER).getValue()).getNumber();
            allNumbers.add(number);
        }
        if (allNumbers.size() > 1) {
            BgPeriodDispFactory.getRemoteInstance().checkPeriodType(allNumbers, true);
        }
        boolean hasNoLeaf = false;
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            rowLeft = tblLeft.getRow(rows.get(i2).intValue());
            String number = null;
            if (rowLeft.getCell(COL_NUMBER).getValue() instanceof NumberExpandInfo) {
                NumberExpandInfo nInfo = (NumberExpandInfo)rowLeft.getCell(COL_NUMBER).getValue();
                if (!nInfo.isLeaf() && isOnlyLeaf) {
                    hasNoLeaf = true;
                    continue;
                }
                number = nInfo.getNumber();
            } else {
                number = (String)rowLeft.getCell(COL_NUMBER).getValue();
            }
            if (selectedNumbers.contains(number)) continue;
            if (!isMultiSelect.booleanValue() && tblRight.getRowCount() >= 1) {
                MsgBox.showInfo((Component)ownerUi, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.TemplateResource", (String)"singleSelect"));
                return;
            }
            rowRight = tblRight.addRow();
            rowRight.getCell(COL_NUMBER).setValue((Object)number);
            rowRight.getCell(COL_NAME).setValue(rowLeft.getCell(COL_NAME).getValue());
            rowRight.getCell(COL_ALIAS).setValue(rowLeft.getCell(COL_ALIAS).getValue());
        }
        if (hasNoLeaf) {
            MsgBox.showInfo((Component)ownerUi, (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"selectLeafMember"));
        }
    }

    public static void loadBgVariate(final String bgSchemeId, final String dimNumber, final KDTable tblVaLeft, final String quickText) throws BOSException {
        if (bgSchemeId == null || dimNumber == null) {
            return;
        }
        tblVaLeft.getDataRequestManager().putBindContents(COL_ID, "mainQuery", COL_ID);
        tblVaLeft.getDataRequestManager().putBindContents(COL_NUMBER, "mainQuery", COL_NUMBER);
        tblVaLeft.getDataRequestManager().putBindContents(COL_NAME, "mainQuery", COL_NAME);
        tblVaLeft.getDataRequestManager().setDataRequestMode(1);
        BgViewMemberSelectHelper.removeRequestDataListener(tblVaLeft);
        tblVaLeft.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                try {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(BgViewMemberSelectHelper.COL_ID);
                    sic.add(BgViewMemberSelectHelper.COL_NUMBER);
                    sic.add(BgViewMemberSelectHelper.COL_NAME);
                    sic.add("dimNumber");
                    sic.add("memberNumber");
                    sic.add("bgScheme.id");
                    viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("dimNumber", (Object)dimNumber, CompareType.EQUALS));
                    String maskString = "#0 and #1";
                    if (!StringUtils.isEmpty((String)quickText)) {
                        filter.getFilterItems().add(new FilterItemInfo(BgViewMemberSelectHelper.COL_NUMBER, (Object)("%" + quickText + "%"), CompareType.LIKE));
                        filter.getFilterItems().add(new FilterItemInfo(BgViewMemberSelectHelper.COL_NAME, (Object)("%" + quickText + "%"), CompareType.LIKE));
                        maskString = maskString + "and ( #2 or #3)";
                    }
                    filter.setMaskString(maskString);
                    viewInfo.setFilter(filter);
                    viewInfo.setSorter(new SorterItemCollection());
                    SorterItemInfo sortInfo = new SorterItemInfo("memberNumber");
                    sortInfo.setSortType(SortType.ASCEND);
                    viewInfo.getSorter().add(sortInfo);
                    EntityObjectInfo entity = BgEntityUtil.getEntity((BOSObjectType)new BgVariateInfo().getBOSType());
                    IDataProvider mainExec = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)entity.getFullName()));
                    mainExec.setObjectView(viewInfo);
                    Uuid queryId = mainExec.openQuery();
                    List allIdList = mainExec.getQueryKeys(queryId);
                    mainExec.option().isAutoTranslateEnum = true;
                    mainExec.option().pageCount = tblVaLeft.getDataRequestManager().getPageRowCount();
                    int start = (Integer)e.getParam1();
                    int length = (Integer)e.getParam2() - start + 1;
                    IRowSet res = mainExec.executeQuery(queryId, start, length);
                    e.setRowSet(res);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        tblVaLeft.checkParsed();
        tblVaLeft.removeRows();
    }

    public static List<BgVariateInfo> getBgVariateLst(KDTable tblVaRight) throws BOSException {
        if (tblVaRight.getRowCount() == 0) {
            return null;
        }
        ArrayList<BgVariateInfo> result = new ArrayList<BgVariateInfo>();
        BgVariateInfo bgVariateInfo = null;
        IRow row = null;
        int count = tblVaRight.getRowCount();
        for (int index = 0; index < count; ++index) {
            row = tblVaRight.getRow(index);
            if (row.getUserObject() != null && row.getUserObject() instanceof BgVariateInfo) {
                bgVariateInfo = (BgVariateInfo)row.getUserObject();
            } else {
                bgVariateInfo = new BgVariateInfo();
                bgVariateInfo.setId(BOSUuid.read((String)row.getCell(COL_ID).getValue().toString()));
                bgVariateInfo.setNumber(row.getCell(COL_NUMBER).getValue().toString());
                bgVariateInfo.setName(row.getCell(COL_NAME).getValue().toString());
            }
            result.add(bgVariateInfo);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    public static void loadBgPropertySortType(BgSchemeDimensionHelper schemeHelper, final BgDimensionBaseInfo dim, final KDTable tblProLeft, final String quickText, final NumberExpandHelper proNumberHelper) throws EASBizException, BOSException {
        if (dim == null || dim.getNumber() == null || schemeHelper == null) {
            return;
        }
        tblProLeft.getDataRequestManager().putBindContents(COL_ID, "mainQuery", COL_ID);
        tblProLeft.getDataRequestManager().putBindContents(COL_NUMBER, "mainQuery", COL_NUMBER);
        tblProLeft.getDataRequestManager().putBindContents(COL_NAME, "mainQuery", COL_NAME);
        tblProLeft.getDataRequestManager().putBindContents(COL_LEVEL, "mainQuery", COL_LEVEL);
        tblProLeft.getDataRequestManager().putBindContents(COL_LONGNUMBER, "mainQuery", COL_LONGNUMBER);
        tblProLeft.getDataRequestManager().putBindContents(COL_ISLEAF, "mainQuery", COL_ISLEAF);
        tblProLeft.getDataRequestManager().setDataRequestMode(1);
        BgViewMemberSelectHelper.removeRequestDataListener(tblProLeft);
        tblProLeft.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSorter(new SorterItemCollection());
                evi.getSorter().add(new SorterItemInfo(BgViewMemberSelectHelper.COL_NUMBER));
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add(BgViewMemberSelectHelper.COL_ID);
                evi.getSelector().add(BgViewMemberSelectHelper.COL_NUMBER);
                evi.getSelector().add(BgViewMemberSelectHelper.COL_NAME);
                evi.setFilter(new FilterInfo());
                String mbgDimId = null;
                try {
                    if (!DimensionConstants.DEF_ACCOUNT_NUMBER.equalsIgnoreCase(dim.getNumber())) {
                        String dimNum = dim.getNumber();
                        CoreBaseInfo mbgDimInfo = MbgDimFactory.getRemoteInstance().getValue("select id where number = '" + dimNum + "'");
                        if (mbgDimInfo != null && mbgDimInfo.getId() != null) {
                            mbgDimId = mbgDimInfo.getId().toString();
                        }
                        evi.getFilter().getFilterItems().add(new FilterItemInfo("mbgDim.id", (Object)mbgDimId));
                    } else {
                        evi.getFilter().getFilterItems().add(new FilterItemInfo("sourcetype", (Object)"E68E9293"));
                    }
                    String maskString = "#0 ";
                    if (!StringUtils.isEmpty((String)quickText)) {
                        evi.getFilter().getFilterItems().add(new FilterItemInfo(BgViewMemberSelectHelper.COL_NUMBER, (Object)("%" + quickText + "%"), CompareType.LIKE));
                        evi.getFilter().getFilterItems().add(new FilterItemInfo(BgViewMemberSelectHelper.COL_NAME, (Object)("%" + quickText + "%"), CompareType.LIKE));
                        maskString = maskString + "and ( #1 or #2)";
                    }
                    evi.getFilter().setMaskString(maskString);
                    IBgPropertySort iBgPropertySort = BgPropertySortFactory.getRemoteInstance();
                    BgViewMemberSelectHelper.entiryExecutor(tblProLeft, proNumberHelper, e, (ICoreBase)iBgPropertySort, evi, evi.getFilter(), null, null);
                }
                catch (Exception e1) {
                    logger.error((Object)"loadBgPropertySortType error");
                }
            }
        });
        tblProLeft.checkParsed();
        tblProLeft.removeRows();
    }

    public static void loadBgPropertyType(BgSchemeDimensionHelper schemeHelper, final BgDimensionBaseInfo dim, final KDTable tblProLeft, final String[] filterFields, final String quickText, final NumberExpandHelper proNumberHelper, final String orgId) throws EASBizException, BOSException {
        if (dim != null && dim.getNumber() != null && schemeHelper != null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSorter(new SorterItemCollection());
            evi.getSorter().add(new SorterItemInfo(COL_NUMBER));
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add(COL_ID);
            evi.getSelector().add(COL_NUMBER);
            evi.getSelector().add(COL_NAME);
            evi.setFilter(new FilterInfo());
            String mbgDimId = null;
            MbgViewInfo viewInfo = null;
            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("sourcetype", (Object)"33F82845"));
            } else if (!DimensionConstants.DEF_ACCOUNT_NUMBER.equalsIgnoreCase(dim.getNumber())) {
                String dimNum = dim.getNumber();
                CoreBaseInfo mbgDimInfo = MbgDimFactory.getRemoteInstance().getValue("select id where number = '" + dimNum + "'");
                if (mbgDimInfo != null && mbgDimInfo.getId() != null) {
                    mbgDimId = mbgDimInfo.getId().toString();
                }
                evi.getFilter().getFilterItems().add(new FilterItemInfo("mbgDim.id", (Object)mbgDimId));
                String viewId = dim.getViewId();
                if (viewId == null) {
                    viewId = schemeHelper.getDimension(dim.getNumber()).getViewId();
                }
                viewInfo = MbgViewFactory.getRemoteInstance().getMbgViewInfo("select id,segregationRule where id = '" + viewId + "'");
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("sourcetype", (Object)"E68E9293"));
            }
            final MbgViewInfo mbgViewInfo = viewInfo;
            IBgPropertySort IBgPropertySort2 = BgPropertySortFactory.getRemoteInstance();
            BgPropertySortCollection bgProSortColls = null;
            bgProSortColls = IBgPropertySort2.getBgPropertySortCollection(evi);
            if (bgProSortColls == null || bgProSortColls.isEmpty()) {
                return;
            }
            final HashSet<String> bgProSortIds = new HashSet<String>();
            int size = bgProSortColls.size();
            for (int i = 0; i < size; ++i) {
                bgProSortIds.add(bgProSortColls.get(i).getId().toString());
            }
            tblProLeft.getDataRequestManager().putBindContents(COL_ID, "mainQuery", COL_ID);
            tblProLeft.getDataRequestManager().putBindContents(COL_NUMBER, "mainQuery", COL_NUMBER);
            tblProLeft.getDataRequestManager().putBindContents(COL_NAME, "mainQuery", COL_NAME);
            tblProLeft.getDataRequestManager().putBindContents(COL_LEVEL, "mainQuery", COL_LEVEL);
            tblProLeft.getDataRequestManager().putBindContents(COL_LONGNUMBER, "mainQuery", COL_LONGNUMBER);
            tblProLeft.getDataRequestManager().putBindContents(COL_ISLEAF, "mainQuery", COL_ISLEAF);
            tblProLeft.getDataRequestManager().putBindContents(COL_PROSORT, "mainQuery", "bgPropertySort.name");
            tblProLeft.getDataRequestManager().setDataRequestMode(1);
            BgViewMemberSelectHelper.removeRequestDataListener(tblProLeft);
            tblProLeft.addRequestRowSetListener(new RequestRowSetListener(){

                public void doRequestRowSet(RequestRowSetEvent e) {
                    try {
                        IBgProperty iBgProperty = BgPropertyFactory.getRemoteInstance();
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(BgViewMemberSelectHelper.COL_ID);
                        sic.add(BgViewMemberSelectHelper.COL_NUMBER);
                        sic.add(BgViewMemberSelectHelper.COL_NAME);
                        sic.add(BgViewMemberSelectHelper.COL_LEVEL);
                        sic.add(BgViewMemberSelectHelper.COL_LONGNUMBER);
                        sic.add(BgViewMemberSelectHelper.COL_ISLEAF);
                        sic.add("bgPropertySort.id");
                        sic.add("bgPropertySort.number");
                        sic.add("bgPropertySort.name");
                        sic.add("bgPropertySort.segregationRule");
                        sic.add("orgUnit.id");
                        viewInfo.getSelector().addObjectCollection((IObjectCollection)sic);
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("bgPropertySort.id", (Object)bgProSortIds, CompareType.INCLUDE));
                        String maskString = "#0 ";
                        if (!StringUtils.isEmpty((String)quickText)) {
                            if (filterFields == null) {
                                filter.getFilterItems().add(new FilterItemInfo(BgViewMemberSelectHelper.COL_NUMBER, (Object)("%" + quickText + "%"), CompareType.LIKE));
                                filter.getFilterItems().add(new FilterItemInfo(BgViewMemberSelectHelper.COL_NAME, (Object)("%" + quickText + "%"), CompareType.LIKE));
                                maskString = maskString + "and ( #1 or #2)";
                            } else {
                                maskString = maskString + "and ( ";
                                for (int i = 0; i < filterFields.length; ++i) {
                                    if (i > 0) {
                                        maskString = maskString + " or ";
                                    }
                                    maskString = maskString + "#" + (i + 1);
                                    filter.getFilterItems().add(new FilterItemInfo(filterFields[i], (Object)("%" + quickText + "%"), CompareType.LIKE));
                                }
                                maskString = maskString + ")";
                            }
                        }
                        if (!dim.getCanAddMember().isEmpty()) {
                            HashSet<String> numbers = new HashSet<String>();
                            for (int i = 0; i < dim.getCanAddMember().size(); ++i) {
                                numbers.add(BgViewHelper.getNumber(dim.getCanAddMember().get(i)));
                            }
                            filter.getFilterItems().add(new FilterItemInfo(BgViewMemberSelectHelper.COL_NUMBER, numbers, CompareType.INCLUDE));
                            maskString = filterFields != null ? maskString + " and #" + (filterFields.length + 1) : (!StringUtils.isEmpty((String)quickText) ? maskString + " and #3" : maskString + " and #1");
                        }
                        filter.setMaskString(maskString);
                        viewInfo.setFilter(filter);
                        viewInfo.setSorter(new SorterItemCollection());
                        SorterItemInfo sortInfo1 = new SorterItemInfo("bgPropertySort.longNumber");
                        viewInfo.getSorter().add(sortInfo1);
                        SorterItemInfo sortInfo = new SorterItemInfo(BgViewMemberSelectHelper.COL_LONGNUMBER);
                        sortInfo.setSortType(SortType.ASCEND);
                        viewInfo.getSorter().add(sortInfo);
                        BgViewMemberSelectHelper.entiryExecutor(tblProLeft, proNumberHelper, e, (ICoreBase)iBgProperty, viewInfo, filter, orgId, mbgViewInfo);
                    }
                    catch (Exception e1) {
                        logger.error((Object)("" + e1));
                    }
                }
            });
            tblProLeft.checkParsed();
            tblProLeft.removeRows();
        }
    }

    public static void entiryExecutor(KDTable tblProLeft, NumberExpandHelper proNumberHelper, RequestRowSetEvent e, ICoreBase bizIntance, EntityViewInfo viewInfo, FilterInfo filter, String orgId, MbgViewInfo mbgViewInfo) throws BOSException, SQLException, EASBizException, UuidException {
        EntityObjectInfo entity = BgEntityUtil.getEntity((BOSObjectType)bizIntance.getType());
        IDataProvider mainExec = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)entity.getFullName()));
        mainExec.setObjectView(viewInfo);
        proNumberHelper.setFilter(filter, bizIntance);
        Uuid queryId = mainExec.openQuery();
        List allIdList = mainExec.getQueryKeys(queryId);
        mainExec.option().isAutoTranslateEnum = true;
        mainExec.option().pageCount = tblProLeft.getDataRequestManager().getPageRowCount();
        int start = (Integer)e.getParam1();
        int length = (Integer)e.getParam2() - start + 1;
        IRowSet res = mainExec.executeQuery(queryId, start, length);
        if (orgId != null && !tblProLeft.getParent().toString().contains("BizCalcMainUI") && !tblProLeft.getParent().toString().contains("FunctionSelectF7UI")) {
            HashSet<String> idSet = new HashSet<String>();
            while (res.next()) {
                BizEnumValueDTO senum = (BizEnumValueDTO)res.getObject(10);
                String segregation = senum.getValue().toString();
                if (Integer.valueOf(segregation) == 1) {
                    MemberSegregationRuleEnum segregationRule = mbgViewInfo.getSegregationRule();
                    if (MemberSegregationRuleEnum.SEGREGATEORG.equals((Object)segregationRule)) {
                        if (!res.getString(11).equals(orgId)) continue;
                        idSet.add(res.getString(1));
                        continue;
                    }
                    if (MemberSegregationRuleEnum.SEGREGATEEQUALS.equals((Object)segregationRule)) {
                        OrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getRemoteInstance().getOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgId)));
                        Set parentAndChildOrgUnitIds = MbgDimHelper.getParentAndChildrenOrgUnitIds((OrgUnitInfo)orgUnitInfo);
                        if (parentAndChildOrgUnitIds == null || !parentAndChildOrgUnitIds.isEmpty() && !parentAndChildOrgUnitIds.contains(res.getString(11))) continue;
                        idSet.add(res.getString(1));
                        continue;
                    }
                    idSet.add(res.getString(1));
                    continue;
                }
                idSet.add(res.getString(1));
            }
            FilterInfo tmpTreeFilter = new FilterInfo();
            if (!idSet.isEmpty()) {
                tmpTreeFilter.getFilterItems().add(new FilterItemInfo(COL_ID, idSet, CompareType.INCLUDE));
            } else {
                tmpTreeFilter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)"000000000000000000000000000=", CompareType.EQUALS));
            }
            viewInfo.getFilter().mergeFilter(tmpTreeFilter, "and");
            mainExec = EntityExecutorFactory.getRemoteInstance((IMetaDataPK)MetaDataPK.create((String)entity.getFullName()));
            mainExec.setObjectView(viewInfo);
            queryId = mainExec.openQuery();
            allIdList = mainExec.getQueryKeys(queryId);
            mainExec.option().isAutoTranslateEnum = true;
            mainExec.option().pageCount = tblProLeft.getDataRequestManager().getPageRowCount();
            start = (Integer)e.getParam1();
            length = (Integer)e.getParam2() - start + 1;
            res = mainExec.executeQuery(queryId, start, length);
        }
        e.setRowSet(res);
    }

    public static void removeRequestDataListener(KDTable kdTable) {
        DataSetWrapperFactory dataSetFactory = kdTable.getDataRequestManager().getDataSetFactory();
        EventListener[] listener = dataSetFactory.getRequestRowSetListeners();
        for (int i = 0; i < listener.length; ++i) {
            dataSetFactory.removeRequestRowSetListener((RequestRowSetListener)listener[i]);
        }
    }

    public static List<BgPropertyInfo> getBgPropertyLst(KDTable tblProRight) throws BOSException {
        if (tblProRight.getRowCount() == 0) {
            return null;
        }
        ArrayList<BgPropertyInfo> result = new ArrayList<BgPropertyInfo>();
        BgPropertyInfo bgPropertyInfo = null;
        IRow row = null;
        int count = tblProRight.getRowCount();
        for (int index = 0; index < count; ++index) {
            row = tblProRight.getRow(index);
            if (row.getUserObject() != null && row.getUserObject() instanceof BgPropertyInfo) {
                bgPropertyInfo = (BgPropertyInfo)row.getUserObject();
            } else {
                bgPropertyInfo = new BgPropertyInfo();
                bgPropertyInfo.setId(BOSUuid.read((String)row.getCell(COL_ID).getValue().toString()));
                bgPropertyInfo.setNumber(row.getCell(COL_NUMBER).getValue().toString());
                bgPropertyInfo.setName(row.getCell(COL_NAME).getValue().toString());
                BgPropertySortInfo sortInfo = new BgPropertySortInfo();
                sortInfo.setName(row.getCell(COL_PROSORT).getValue().toString());
                bgPropertyInfo.setBgPropertySort(sortInfo);
            }
            result.add(bgPropertyInfo);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    public static List<BgDimensionMember> getMemberList(DimensionMemberSelectHelper selectHelper, KDTable tblRight) {
        ArrayList<BgDimensionMember> result = null;
        if (tblRight.getRowCount() > 0 && selectHelper != null) {
            result = new ArrayList<BgDimensionMember>();
            for (int i = 0; i < tblRight.getRowCount(); ++i) {
                IRow row = tblRight.getRow(i);
                BgDimensionBaseInfo dimension = ((SourceDisplayInfo)row.getCell(COL_DIMENSION).getValue()).getDimension();
                String number = NumberExpandHelper.getNumber((IRow)row);
                String name = (String)row.getCell(COL_NAME).getValue();
                DimensionMemberTypeEnum type = (DimensionMemberTypeEnum)((Object)row.getCell(COL_FILLTYPE).getValue());
                BgDimensionMember member = (BgDimensionMember)row.getUserObject();
                if (member == null) {
                    member = new BgDimensionMember(dimension.getNumber(), dimension.getRefField(), name, number);
                }
                member.setFillType(type.getValue());
                member.setSrcNumber(selectHelper.getSrcNumber(dimension.getNumber()));
                result.add(member);
            }
        }
        return result;
    }

    public static void reFillMembers(BgDimensionBaseInfo dimension, KDTable tblRight, DimensionMemberSelectHelper selectHelper, List members, Map<String, Map<String, String>> extDataMap) {
        if (members != null && !members.isEmpty()) {
            tblRight.removeRows();
            for (int i = 0; i < members.size(); ++i) {
                if (!(members.get(i) instanceof BgDimensionMember)) continue;
                BgDimensionMember member = (BgDimensionMember)members.get(i);
                if (member.getSrcNumber() == null) {
                    member.setSrcNumber(selectHelper.getSrcNumber(member.getType()));
                }
                if (member.isFilled() || member.getType() != null && !dimension.getNumber().equals(member.getType())) continue;
                IRow row = tblRight.addRow();
                row.setUserObject((Object)member);
                row.getCell(COL_DIMENSION).setValue((Object)new SourceDisplayInfo(dimension));
                row.getCell(COL_NUMBER).setValue((Object)member.getNumber());
                row.getCell(COL_NAME).setValue((Object)member.getName());
                row.getCell(COL_FILLTYPE).setValue((Object)DimensionMemberTypeEnum.getEnum(member.getFillType()));
                if (extDataMap == null || extDataMap.isEmpty() || tblRight.getColumn(COL_DESC) == null || tblRight.getColumn(COL_ORG_UNIT) == null) continue;
                row.getCell(COL_DESC).setValue(extDataMap.get(member.getNumber()) != null ? extDataMap.get(member.getNumber()).get(COL_DESC) : null);
                row.getCell(COL_ORG_UNIT).setValue(extDataMap.get(member.getNumber()) != null ? extDataMap.get(member.getNumber()).get(COL_ORG_UNIT) : null);
            }
        }
    }

    public static void reFillMembers(BgDimensionBaseInfo dimension, KDTable tblRight, DimensionMemberSelectHelper selectHelper, List members) {
        BgViewMemberSelectHelper.reFillMembers(dimension, tblRight, selectHelper, members, null);
    }

    public static void reFillVariates(KDTable tblVaRight, List members) {
        if (members != null && !members.isEmpty()) {
            tblVaRight.removeRows();
            int size = members.size();
            for (int i = 0; i < size; ++i) {
                IRow row;
                Serializable variateInfo;
                if (members.get(i) instanceof BgVariateInfo) {
                    variateInfo = (BgVariateInfo)members.get(i);
                    if (variateInfo == null) continue;
                    row = tblVaRight.addRow();
                    row.setUserObject((Object)variateInfo);
                    row.getCell(COL_ID).setValue((Object)variateInfo.getId().toString());
                    row.getCell(COL_NUMBER).setValue((Object)variateInfo.getNumber());
                    row.getCell(COL_NAME).setValue((Object)variateInfo.getName());
                    continue;
                }
                if (!(members.get(i) instanceof BgDimensionMember) || (variateInfo = (BgDimensionMember)members.get(i)) == null) continue;
                row = tblVaRight.addRow();
                row.setUserObject((Object)variateInfo);
                row.getCell(COL_NUMBER).setValue((Object)((BgDimensionMember)variateInfo).getNumber());
                row.getCell(COL_NAME).setValue((Object)((BgDimensionMember)variateInfo).getName());
            }
        }
    }

    public static void reFillPropertys(KDTable tblProRight, List members) {
        if (members != null && !members.isEmpty()) {
            tblProRight.removeRows();
            int size = members.size();
            for (int i = 0; i < size; ++i) {
                BgPropertyInfo bgPropertyInfo;
                if (!(members.get(i) instanceof BgPropertyInfo) || (bgPropertyInfo = (BgPropertyInfo)members.get(i)) == null) continue;
                IRow row = tblProRight.addRow();
                row.setUserObject((Object)bgPropertyInfo);
                row.getCell(COL_ID).setValue((Object)bgPropertyInfo.getId().toString());
                row.getCell(COL_NUMBER).setValue((Object)bgPropertyInfo.getNumber());
                row.getCell(COL_NAME).setValue((Object)bgPropertyInfo.getName());
                row.getCell(COL_PROSORT).setValue((Object)bgPropertyInfo.getBgPropertySort().getName().toString());
            }
        }
    }

    public static void updateMembersName(BgSchemeDimensionHelper bgSchemeDimensionHelper, boolean isCsl, String orgId, BgDimensionBaseInfo dim, MbgViewListResultData newData) throws EASBizException, BOSException {
        if (bgSchemeDimensionHelper == null || StringUtils.isEmpty((String)orgId) || dim == null) {
            return;
        }
        ArrayList members = new ArrayList();
        members.addAll(newData.getMembers());
        members.addAll(newData.getCanAddMembers());
        HashMap<String, BgDimensionMember> memberMap = new HashMap<String, BgDimensionMember>();
        for (int i = 0; i < members.size(); ++i) {
            if (!(members.get(i) instanceof BgDimensionMember)) continue;
            BgDimensionMember member = (BgDimensionMember)members.get(i);
            memberMap.put(member.getNumber(), member);
        }
        String bgSchemeId = bgSchemeDimensionHelper.getBgSchemeId();
        String bgOrgViewId = bgSchemeDimensionHelper.getBgOrgViewId();
        if (isCsl && !DimensionConstants.necessary.contains(dim.getNumber())) {
            bgOrgViewId = null;
        }
        DimensionFilterHelper helper = DimensionFilterHelper.getRemoteIntance(bgSchemeDimensionHelper.getDimensionOnCheck(dim.getNumber()), orgId, bgSchemeId, bgOrgViewId, null);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(helper.getSelector());
        evi.setFilter(helper.getFilter());
        evi.getFilter().getFilterItems().add(new FilterItemInfo(COL_NUMBER, new HashSet(memberMap.keySet()), CompareType.INCLUDE));
        IDataProvider dataProvider = helper.getQueryExecutor();
        dataProvider.setObjectView(evi);
        IRowSet rowset = dataProvider.executeQuery();
        try {
            while (rowset.next()) {
                String number = rowset.getString(COL_NUMBER);
                String name = rowset.getString(COL_NAME);
                if (!memberMap.containsKey(number)) continue;
                ((BgDimensionMember)memberMap.get(number)).setName(name);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (memberMap.isEmpty()) {
            return;
        }
        if (newData.getMembers().isEmpty()) {
            for (int i = 0; i < newData.getMembers().size(); ++i) {
                if (!memberMap.containsKey(((BgDimensionMember)newData.getMembers().get(i)).getNumber())) continue;
                ((BgDimensionMember)newData.getMembers().get(i)).setName(((BgDimensionMember)memberMap.get(((BgDimensionMember)newData.getMembers().get(i)).getNumber())).getName());
            }
        }
        if (newData.getCanAddMembers().isEmpty()) {
            for (int i = 0; i < newData.getCanAddMembers().size(); ++i) {
                if (!memberMap.containsKey(((BgDimensionMember)newData.getCanAddMembers().get(i)).getNumber())) continue;
                ((BgDimensionMember)newData.getCanAddMembers().get(i)).setName(((BgDimensionMember)memberMap.get(((BgDimensionMember)newData.getCanAddMembers().get(i)).getNumber())).getName());
            }
        }
    }
}

