/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.newrpt.client.designer.IBookProvider;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgGatherFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.IBgGatherFacade;
import com.kingdee.eas.ma.mbg.client.BgDecomposeAdjustProcessUI;
import com.kingdee.eas.ma.mbg.client.BgDecomposeSpecialAdjustProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNFProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNFormDescomposeProcessUI;
import com.kingdee.eas.ma.mbg.client.BgNFormEditUI;
import com.kingdee.eas.ma.mbg.client.utils.BudgetUtilForClient;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BudgetProvider
extends IBookProvider {
    private static final Logger logger = Logger.getLogger((String)BudgetProvider.class.getName());
    private BgNFProcessUI ui = null;
    private String[] sheetIds = null;

    private BudgetProvider() {
    }

    public BudgetProvider(Component obj) {
        this.ui = (BgNFProcessUI)((Object)obj);
    }

    protected IBgGatherFacade getGatherInterface() throws Exception {
        return BgGatherFacadeFactory.getRemoteInstance();
    }

    public Book loadBook() throws Exception {
        Book book = null;
        if (this.getBudgetInfo() == null) {
            this.setEditValue(this.createNewReport());
        }
        if (this.getBudgetInfo().getData() != null) {
            book = this.getBudgetInfo().getBook();
        }
        if (book != null && OprtState.ADDNEW.equals(this.ui.getOprtState())) {
            this.sheetIds = new String[book.getSheetCount()];
            int in = book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                this.sheetIds[i] = book.getSheet(i).getID();
            }
            book = BgNFSHelper.setFormAddNewSign(this.getBudgetInfo(), book);
        }
        if (book != null) {
            BudgetUtilForClient.prepareReportInfo4Display(this.getBudgetInfo(), book);
        }
        return book;
    }

    public IObjectValue getEditValue() {
        return super.getEditValue();
    }

    public BgFormInfo getBudgetInfo() {
        return (BgFormInfo)this.getEditValue();
    }

    public void restoreBook(Book book) throws Exception {
        BudgetUtilForClient.prepareReportInfo4Save(this.getBudgetInfo(), book);
        this.getBudgetInfo().setBook(book);
        if (this.ui instanceof BgNFormDescomposeProcessUI) {
            this.getBudgetInfo().put("GATHER_FORMULA", ((BgNFormDescomposeProcessUI)this.ui).getGatherInfos());
        } else if (this.ui instanceof BgDecomposeAdjustProcessUI) {
            this.getBudgetInfo().put("GATHER_FORMULA", ((BgDecomposeAdjustProcessUI)this.ui).getGatherInfos());
        } else if (this.ui instanceof BgDecomposeSpecialAdjustProcessUI) {
            this.getBudgetInfo().put("GATHER_FORMULA", ((BgDecomposeSpecialAdjustProcessUI)this.ui).getGatherInfos());
        }
    }

    public IObjectValue createNewReport() throws Exception {
        UIContext uiContext = new UIContext(this.ui.getUIContext().get("Owner"));
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, this.ui.getUIContext().get(BgBaseConstants.ORGUNIT_INFO));
        uiContext.put((Object)BgBaseConstants.ORGUNIT_CU, this.ui.getUIContext().get(BgBaseConstants.ORGUNIT_CU));
        uiContext.put((Object)"BGSCHEME_INFO", this.ui.getUIContext().get("BGSCHEME_INFO"));
        if (this.ui.getUIContext().get("BGFORM_LINK_SCHEME") != null) {
            uiContext.put((Object)"BGFORM_LINK_SCHEME", this.ui.getUIContext().get("BGFORM_LINK_SCHEME"));
        }
        if (this.ui.getUIContext().get("BGFORM_LINK_TEMPLATE") != null) {
            uiContext.put((Object)"BGFORM_LINK_TEMPLATE", this.ui.getUIContext().get("BGFORM_LINK_TEMPLATE"));
        }
        if (this.ui.getUIContext().get("BGFORM_LINK_PERIOD") != null) {
            uiContext.put((Object)"BGFORM_LINK_PERIOD", this.ui.getUIContext().get("BGFORM_LINK_PERIOD"));
        }
        if (this.ui.getUIContext().get("BGFORM_LINK_CURRENCY") != null) {
            uiContext.put((Object)"BGFORM_LINK_CURRENCY", this.ui.getUIContext().get("BGFORM_LINK_CURRENCY"));
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        boolean hasSubmit = false;
        IObjectValue model = null;
        if (uiWindow.getUIObject() instanceof BgNFormEditUI) {
            hasSubmit = ((BgNFormEditUI)uiWindow.getUIObject()).isHasSubmit();
            model = uiWindow.getUIObject().getDataObject();
            this.setEditValue(model);
        }
        if (!hasSubmit || model == null || !(model instanceof BgFormInfo)) {
            SysUtil.abort();
        }
        return model;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getEditUIName() {
        return BgNFormEditUI.class.getName();
    }

    public IBgForm getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected SelectorItemCollection getSelectors() {
        return BgNFSHelper.getSelectors();
    }

    public IObjectValue queryEditData(IObjectPK pk) throws Exception {
        IObjectValue iObjectValue = null;
        try {
            iObjectValue = this.getBizInterface().getValue(pk, this.getSelectors(), (Set)this.ui.getUIContext().get("BGFROM_DATA_STATE"));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            if (e.getCause() instanceof EASBizException) {
                if (e.getCause().getCause() != null) {
                    MsgBox.showDetailAndOK(null, (String)e.getCause().getMessage(), (String)e.getCause().getCause().getMessage(), (int)0);
                } else {
                    MsgBox.showInfo(null, (String)e.getCause().getMessage());
                }
                SysUtil.abort();
            }
            throw e;
        }
        return iObjectValue;
    }

    public void restoreSheetId(Book book) {
        int in = book.getSheetCount();
        for (int i = 0; i < in; ++i) {
            book.getSheet(i).setID(this.sheetIds[i]);
        }
    }

    public boolean audit(BOSUuid bgFormId, BOSUuid auditorId) throws Exception {
        return this.ui.getFacadeInterface().auditForm(bgFormId, auditorId);
    }

    public boolean audit(BOSUuid bgFormId, BOSUuid auditorId, String idea) throws Exception {
        return this.ui.getFacadeInterface().auditForm(bgFormId, auditorId, idea);
    }

    public boolean antiAudit(BOSUuid bgFormId, BOSUuid auditorId, String idea) throws Exception {
        return this.ui.getFacadeInterface().submitAntiAudit(bgFormId, this.ui.getOrgUnitInfo().getId(), auditorId, idea);
    }

    public String getBizFactoryName() {
        return BgFormFactory.class.getName();
    }
}

