/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptCommentTank;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplatePostilCollection;
import com.kingdee.eas.ma.mbg.BgTemplatePostilInfo;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.BgCommentCommonHelper;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgTemplateCommentTank;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class BudgetUtilForClient
extends RptUtilForClient {
    public static void prepareReportInfo4Save(ReportBaseInfo info, Book book) {
        BudgetUtilForClient.checkSheetParam(info, book);
        if (info instanceof IDimDataQuery) {
            try {
                int i;
                BgCommentCommonHelper.saveBgComments(book, (IDimDataQuery)info);
                ReportVariables variables = ReportVariables.loadFromBook((Book)book);
                PostilInfo _postilInfo = null;
                PostilCollection _postils = new PostilCollection();
                PostilCollection postils = info.getPostils();
                Comment _comment = book.getComment();
                if (_comment != null) {
                    if (_comment instanceof RptCommentTank) {
                        int size = ((RptCommentTank)_comment).getSize();
                        for (int i2 = 0; i2 < size; ++i2) {
                            _postilInfo = ((RptCommentTank)_comment).getEntry(i2).getTrueSource();
                            _postilInfo.setPostilType(PostilTypeEnum.REPORT);
                            _postilInfo.setReport(info);
                            if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                                _postilInfo.setDescription(BgNConstants.BLANK_STR);
                            }
                            if (_postilInfo.getId() != null) {
                                _postilInfo.setStatus(2);
                            }
                            _postils.add(_postilInfo);
                        }
                    } else {
                        _postilInfo = new PostilInfo();
                        _postilInfo.setPostilType(PostilTypeEnum.REPORT);
                        _postilInfo.setReport(info);
                        _postilInfo.setDescription(_comment.getText());
                        if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                            _postilInfo.setDescription(BgNConstants.BLANK_STR);
                        }
                        _postilInfo.setStatus(1);
                        _postils.add(_postilInfo);
                    }
                } else if (postils != null) {
                    int in = postils.size();
                    for (i = 0; i < in; ++i) {
                        _postilInfo = postils.get(i);
                        if (_postilInfo.getPostilType().getValue() != 1) continue;
                        _postilInfo.setStatus(3);
                        _postils.add(_postilInfo);
                    }
                }
                for (i = 0; i < book.getSheetCount(); ++i) {
                    Sheet sheet = book.getSheet(i);
                    String name = sheet.getSheetName();
                    RptSheetParamInfo pinfo = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
                    pinfo.setSheetID(sheet.getID());
                    pinfo.setRelaType(ReportTypeEnum.REPORT);
                    if (info.getSheetParam().get(i) != null) {
                        for (int m = 0; m < info.getSheetParam().size(); ++m) {
                            if (!info.getSheetParam().get(m).getSheetID().equals(sheet.getID())) continue;
                            pinfo.setId(info.getSheetParam().get(m).getId());
                            info.getSheetParam().set(m, pinfo);
                            break;
                        }
                    } else {
                        info.getSheetParam().add(pinfo);
                    }
                    BudgetUtilForClient.pickPostil(info, sheet, _postils, pinfo);
                    if (postils == null) continue;
                    int in = postils.size();
                    for (int j = 0; j < in; ++j) {
                        _postilInfo = postils.get(j);
                        if (_postilInfo.getPostilType().getValue() != 3 || !_postilInfo.getSheet().getId().equals((Object)pinfo.getId())) continue;
                        pinfo.getPostils().add(_postilInfo);
                    }
                }
                info.put("postils", (Object)_postils);
            }
            catch (Exception e) {
                Logger.getLogger(BudgetUtilForClient.class).debug((Object)e.getStackTrace(), (Throwable)e);
            }
        }
    }

    public static void checkSheetParam(ReportBaseInfo info, Book book) {
        BgNFSHelper.checkSheetParam(info, book);
    }

    public static void prepareTemplateInfo4Save(BgTemplateInfo info, Book book) {
        int i;
        ReportVariables variables = ReportVariables.loadFromBook((Book)book);
        BgTemplatePostilInfo _postilInfo = null;
        BgTemplatePostilCollection _postils = new BgTemplatePostilCollection();
        BgTemplatePostilCollection postils = info.getPostils();
        Comment _comment = book.getComment();
        if (_comment != null) {
            int i2;
            int size;
            if (_comment instanceof BgTemplateCommentTank) {
                size = ((BgTemplateCommentTank)_comment).getSize();
                for (i2 = 0; i2 < size; ++i2) {
                    _postilInfo = ((BgTemplateCommentTank)_comment).getEntry(i2).getTrueSource();
                    _postilInfo.setPostilType(PostilTypeEnum.REPORT);
                    _postilInfo.setTemplate(info);
                    if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                        _postilInfo.setDescription(BgNConstants.BLANK_STR);
                    }
                    _postils.add(_postilInfo);
                }
            } else if (_comment instanceof RptCommentTank) {
                size = ((RptCommentTank)_comment).getSize();
                for (i2 = 0; i2 < size; ++i2) {
                    _postilInfo = new BgTemplatePostilInfo();
                    _postilInfo.setPostilType(PostilTypeEnum.REPORT);
                    _postilInfo.setTemplate(info);
                    _postilInfo.setDescription(((RptCommentTank)_comment).getEntry(i2).getContent());
                    if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                        _postilInfo.setDescription(BgNConstants.BLANK_STR);
                    }
                    _postils.add(_postilInfo);
                }
            } else {
                _postilInfo = new BgTemplatePostilInfo();
                _postilInfo.setPostilType(PostilTypeEnum.REPORT);
                _postilInfo.setTemplate(info);
                _postilInfo.setDescription(_comment.getText());
                if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                    _postilInfo.setDescription(BgNConstants.BLANK_STR);
                }
                _postils.add(_postilInfo);
            }
        } else if (postils != null) {
            int in = postils.size();
            for (i = 0; i < in; ++i) {
                _postilInfo = postils.get(i);
                if (_postilInfo.getPostilType().getValue() != 1) continue;
                _postils.add(_postilInfo);
            }
        }
        for (i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            String name = sheet.getSheetName();
            RptSheetParamInfo pinfo = VariablesHelper.variables2SheetParams((ReportVariables)variables, (String)name, (boolean)true, null);
            pinfo.setSheetID(sheet.getID());
            pinfo.setRelaType(ReportTypeEnum.REPORT);
            if (info.getSheetParam().get(i) != null) {
                for (int m = 0; m < info.getSheetParam().size(); ++m) {
                    if (!info.getSheetParam().get(m).getSheetID().equals(sheet.getID())) continue;
                    pinfo.setId(info.getSheetParam().get(m).getId());
                    info.getSheetParam().set(m, pinfo);
                    break;
                }
            } else {
                info.getSheetParam().add(pinfo);
            }
            BudgetUtilForClient.pickTempaltePostil(info, sheet, _postils, pinfo);
        }
        info.put("postils", (Object)_postils);
    }

    public static void prepareTemplateInfo4Display(BgTemplateInfo info, Book book) {
        BgCommentCommonHelper.prepareTemplateInfo4Display(info, book);
    }

    public static void prepareReportInfo4Display(ReportBaseInfo info, Book book) {
        BookProperties properties = BookProperties.loadFromBook((Book)book);
        ReportVariables variables = properties.getVariables();
        RptSheetParamCollection sheetParam = info.getSheetParam();
        RptPeriodTypeEnum periodType = info.getPeriodType();
        if (periodType == null) {
            periodType = RptPeriodTypeEnum.MONTHLY;
        }
        for (int i = 0; sheetParam != null && i < sheetParam.size(); ++i) {
            RptSheetParamInfo p = sheetParam.get(i);
            if (periodType == null) {
                periodType = RptPeriodTypeEnum.MONTHLY;
            }
            ReportVariables sheetV = VariablesHelper.sheetParams2Variables((RptSheetParamInfo)p, (RptPeriodTypeEnum)periodType);
            sheetV.remove("StartYear", p.getSheetName());
            sheetV.remove("StartPeriod", p.getSheetName());
            sheetV.remove("EndYear", p.getSheetName());
            sheetV.remove("EndPeriod", p.getSheetName());
            variables.remove("StartYear", p.getSheetName());
            variables.remove("StartPeriod", p.getSheetName());
            variables.remove("EndYear", p.getSheetName());
            variables.remove("EndPeriod", p.getSheetName());
            variables.addAll(sheetV, false);
        }
        properties.restoreToBook(book);
    }

    private static void pickTempaltePostil(BgTemplateInfo info, Sheet sheet, BgTemplatePostilCollection postils, RptSheetParamInfo p) {
        BgTemplatePostilInfo _postilInfo = null;
        Comment _comment = null;
        BgTemplateCommentTank _ct = null;
        _comment = sheet.getComment();
        if (_comment != null) {
            if (_comment instanceof BgTemplateCommentTank) {
                _ct = (BgTemplateCommentTank)_comment;
                int in = _ct.getSize();
                for (int i = 0; i < in; ++i) {
                    _postilInfo = _ct.getEntry(i).getSource();
                    _postilInfo.setPostilType(PostilTypeEnum.SHEET);
                    _postilInfo.setSheet(p);
                    _postilInfo.setTemplate(info);
                    if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                        _postilInfo.setDescription(BgNConstants.BLANK_STR);
                    }
                    postils.add(_postilInfo);
                }
            } else {
                _postilInfo = new BgTemplatePostilInfo();
                _postilInfo.setPostilType(PostilTypeEnum.SHEET);
                _postilInfo.setSheet(p);
                _postilInfo.setTemplate(info);
                _postilInfo.setDescription(_comment.getText());
                if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                    _postilInfo.setDescription(BgNConstants.BLANK_STR);
                }
                postils.add(_postilInfo);
            }
        }
        Sheet.ICellsIterator it = sheet.getCellsIterator(null, false, true);
        while (it.hasNext()) {
            Cell cell = it.next();
            _ct = BudgetUtilForClient.getReportComment(cell);
            if (_ct == null) continue;
            int in = _ct.getSize();
            for (int i = 0; i < in; ++i) {
                _postilInfo = _ct.getEntry(i).getTrueSource();
                _postilInfo.setPostilType(PostilTypeEnum.CELL);
                _postilInfo.setSheet(p);
                _postilInfo.setCellName(cell.getName(false, false));
                _postilInfo.setTemplate(info);
                if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                    _postilInfo.setDescription(BgNConstants.BLANK_STR);
                }
                postils.add(_postilInfo);
                ItemFormula f = (ItemFormula)cell.getUserObjectValue("ITEM");
                if (f == null) continue;
                String num = f.getItemNumber();
                if (num == null || num.trim().length() < 1) {
                    num = f.getDItemNumber();
                }
                _postilInfo.setItemNumber(num);
            }
        }
    }

    public static BgTemplateCommentTank getReportComment(Cell cell) {
        return BgCommentCommonHelper.getReportComment(cell, null, true);
    }

    public static BgTemplateCommentTank convertComment(Comment c, UserInfo author) {
        return BgCommentCommonHelper.convertComment(c, author, null);
    }

    private static void pickPostil(ReportBaseInfo info, Sheet sheet, PostilCollection postils, RptSheetParamInfo p) {
        PostilInfo _postilInfo = null;
        Comment _comment = null;
        RptCommentTank _ct = null;
        _comment = sheet.getComment();
        if (_comment != null) {
            if (_comment instanceof RptCommentTank) {
                _ct = (RptCommentTank)_comment;
                int in = _ct.getSize();
                for (int i = 0; i < in; ++i) {
                    _postilInfo = _ct.getEntry(i).getSource();
                    _postilInfo.setPostilType(PostilTypeEnum.SHEET);
                    _postilInfo.setSheet(p);
                    _postilInfo.setReport(info);
                    if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                        _postilInfo.setDescription(BgNConstants.BLANK_STR);
                    }
                    postils.add(_postilInfo);
                    p.getPostils().add(_postilInfo);
                }
            } else {
                _postilInfo = new PostilInfo();
                _postilInfo.setPostilType(PostilTypeEnum.SHEET);
                _postilInfo.setSheet(p);
                _postilInfo.setReport(info);
                _postilInfo.setDescription(_comment.getText());
                if (StringUtils.isEmpty((String)_postilInfo.getDescription())) {
                    _postilInfo.setDescription(BgNConstants.BLANK_STR);
                }
                postils.add(_postilInfo);
                p.getPostils().add(_postilInfo);
            }
        }
    }
}

