/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.MultiLangItemList;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.base.uiframe.client.UINewFrame;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CostCenterF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.IBgAccount;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.client.BgOrgDialog;
import com.kingdee.eas.ma.base.client.DimMetaDataTreeDialog;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.utils.BgLocaleHelper;
import com.kingdee.eas.ma.base.utils.VirtualDataInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionFactory;
import com.kingdee.eas.ma.mbg.DimensionPropSrcCollection;
import com.kingdee.eas.ma.mbg.DimensionPropSrcInfo;
import com.kingdee.eas.ma.mbg.DimensionSourceCollection;
import com.kingdee.eas.ma.mbg.DimensionSourceFactory;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.client.utils.NewDimensionMemberDialog;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MbgViewListCalcutor;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.calcRow.AbstractCalcExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.ColExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.ConstExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.ExprParseHelper;
import com.kingdee.eas.ma.mbg.common.calcRow.IExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.RowExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.SpaceWhiteExpr;
import com.kingdee.eas.ma.mbg.common.calcRow.UnkownExpr;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgTempRptReportPropertyAdapter;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckFactory;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.IGetBgSchemeNumber;
import com.kingdee.eas.ma.mbg.utils.SourceDisplayInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;

public class DimensionClientHelper {
    public static final String COL_srcProperty = "srcProperty";
    public static final String COL_displayName = "displayName";
    private static List basePropLst = new ArrayList();
    private static List accViewPropLst = null;
    private static List cashItemPropLst = null;
    private static List expTypePropLst = null;
    private static List rptItemPropLst = null;
    private static List costItemPropLst = null;
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String PARENT = "parent.name";
    public static final String PARENT_NUMBER = "parent.number";
    public static final String LEVEL = "level";
    public static final String ISLEAF = "isLeaf";
    public static final String LONGNUMBER = "longNumber";

    public static void loadPropSrc(DimensionSourceInfo source, KDTable table, EntityObjectInfo entity) {
        if (table != null) {
            table.removeRows();
            table.setUserObject((Object)source);
            if (!source.getProperties().isEmpty() && entity != null) {
                DimensionPropSrcCollection col = DimensionClientHelper.sortPropMap(source.getProperties());
                for (int i = 0; i < col.size(); ++i) {
                    DimensionPropSrcInfo propSrc = col.get(i);
                    IRow row = table.addRow();
                    row.setUserObject((Object)propSrc);
                    row.getCell(COL_srcProperty).setValue((Object)DimensionClientHelper.getPropAlias(entity, propSrc));
                    MultiLangItemList list = DimensionClientHelper.createMultiLangInfo((IObjectValue)propSrc, "dimPropName");
                    row.getCell(COL_displayName).setValue((Object)list);
                    if (propSrc.getProperty() != null) {
                        row.getCell(COL_displayName).setUserObject((Object)propSrc.getProperty());
                        row.getCell(COL_displayName).getStyleAttributes().setLocked(true);
                    }
                    if (source.getSrcID().equals("9DA99826")) {
                        if (accViewPropLst.contains(propSrc.getDimSrcPropName())) {
                            row.getStyleAttributes().setLocked(true);
                        }
                    } else if (source.getSrcID().equals("05A167FF")) {
                        if (cashItemPropLst.contains(propSrc.getDimSrcPropName())) {
                            row.getStyleAttributes().setLocked(true);
                        }
                    } else if (source.getSrcID().equals("237A9505")) {
                        if (rptItemPropLst.contains(propSrc.getDimSrcPropName())) {
                            row.getStyleAttributes().setLocked(true);
                        }
                    } else if (source.getSrcID().equals("78E4BC94")) {
                        if (expTypePropLst.contains(propSrc.getDimSrcPropName())) {
                            row.getStyleAttributes().setLocked(true);
                        }
                    } else if (source.getSrcID().equals("548C5A91")) {
                        if (costItemPropLst.contains(propSrc.getDimSrcPropName())) {
                            row.getStyleAttributes().setLocked(true);
                        }
                    } else if (DimensionConstants.DEF_INDEX_NUMBER.equals(source.getDimension().getNumber()) && basePropLst.contains(propSrc.getDimSrcPropName())) {
                        row.getStyleAttributes().setLocked(true);
                    }
                    if (propSrc.getProperty() == null) continue;
                    row.getStyleAttributes().setLocked(true);
                }
            }
            table.repaint();
        }
    }

    public static void loadBgIndexSortSrc(DimensionSourceInfo source, KDTable table, EntityObjectInfo entity) {
        DimensionPropSrcInfo info = new DimensionPropSrcInfo();
        BOSUuid id = BOSUuid.create((BOSObjectType)info.getBOSType());
        info.setId(id);
        info.setProperty(null);
        info.setSource(new DimensionSourceInfo());
        info.setDimSrcFieldName("FbgIndexSort");
        info.setId(id);
        info.setDimSrcPropName("bgIndexSort");
        info.setDimSrcPropIsMultiLang(false);
        info.setDimPropName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"bgIndexSort"));
        List langList = KDBizMultiLangBox.getLanguageList();
        if (langList != null && langList.size() > 0) {
            for (int i = 0; i < langList.size(); ++i) {
                LanguageInfo currentLang = (LanguageInfo)langList.get(i);
                Locale l = currentLang.getLocale();
                if (LocaleUtils.locale_l1.equals(l)) {
                    info.setDimPropName("bgIndexSort", l);
                    continue;
                }
                info.setDimPropName(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"bgIndexSort"), l);
            }
        }
        DimensionClientHelper.addIndexSortRow(table, info, entity);
    }

    private static void addIndexSortRow(KDTable table, DimensionPropSrcInfo propSrc, EntityObjectInfo entity) {
        boolean flag = false;
        int nameIndex = 0;
        for (int i = 0; i < table.getRowCount(); ++i) {
            if (table.getRow(i).getCell(0).getValue().toString().equalsIgnoreCase(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"bgIndexSort"))) {
                flag = true;
            }
            if (!table.getRow(i).getCell(0).getValue().toString().equalsIgnoreCase(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)NAME))) continue;
            nameIndex = i;
        }
        if (!flag) {
            IRow row = table.addRow(nameIndex + 1);
            row.setUserObject((Object)propSrc);
            row.getCell(COL_srcProperty).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"bgIndexSort"));
            MultiLangItemList list = DimensionClientHelper.createMultiLangInfo((IObjectValue)propSrc, "dimPropName");
            row.getCell(COL_displayName).setValue((Object)list);
            if (propSrc.getProperty() != null) {
                row.getCell(COL_displayName).setUserObject((Object)propSrc.getProperty());
                row.getCell(COL_displayName).getStyleAttributes().setLocked(true);
            }
        }
    }

    public static String getPropAlias(EntityObjectInfo entity, DimensionPropSrcInfo propSrc) {
        String alias = BgEntityUtil.getEntityPropertyAlias((EntityObjectInfo)entity, (String)propSrc.getDimSrcPropName(), null);
        if (alias != null) {
            return alias;
        }
        return propSrc.getDimPropName();
    }

    public static void storePropSrc(KDTable table, EntityObjectInfo entity) {
        if (table == null || !(table.getUserObject() instanceof DimensionSourceInfo) || entity == null) {
            return;
        }
        DimensionSourceInfo source = (DimensionSourceInfo)table.getUserObject();
        source.getProperties().clear();
        for (int i = 0; i < table.getRowCount(); ++i) {
            IRow row = table.getRow(i);
            DimensionPropSrcInfo procSrc = (DimensionPropSrcInfo)row.getUserObject();
            procSrc.setSource(source);
            procSrc.setOrder(i);
            if (row.getCell(COL_srcProperty).getValue() instanceof VirtualDataInfo) {
                VirtualDataInfo data = (VirtualDataInfo)row.getCell(COL_srcProperty).getValue();
                procSrc.setDimSrcPropIsMultiLang(data.isMultilingual());
                procSrc.setDimSrcFieldName(data.getTableField());
                procSrc.setDimSrcPropName(data.getName());
            }
            if (row.getCell(COL_displayName).getValue() instanceof MultiLangItemList) {
                MultiLangItem[] items = ((MultiLangItemList)row.getCell(COL_displayName).getValue()).getItems();
                for (int m = 0; m < items.length; ++m) {
                    procSrc.setDimPropName((String)items[m].getData(), items[m].getLang().getLocale());
                }
            }
            source.getProperties().add(procSrc);
        }
    }

    public static MultiLangItemList createMultiLangInfo(IObjectValue obj, String property) {
        List langList = KDBizMultiLangBox.getLanguageList();
        MultiLangItem[] items = new MultiLangItem[langList.size()];
        MultiLangItem currItem = null;
        for (int i = 0; i < langList.size(); ++i) {
            LanguageInfo currentLang = (LanguageInfo)langList.get(i);
            Locale l = currentLang.getLocale();
            items[i] = new MultiLangItem(currentLang, BgLocaleHelper.get((IObjectValue)obj, (String)property, (Locale)l));
            if (!LocaleUtils.getDefaultLocale().equals(l)) continue;
            currItem = items[i];
        }
        MultiLangItemList list = new MultiLangItemList(items);
        list.setCurrentItem(currItem);
        return list;
    }

    public static LanguageInfo getLang(Locale locale) {
        List langs = KDBizMultiLangBox.getLanguageList();
        for (int i = 0; i < langs.size(); ++i) {
            LanguageInfo lang = (LanguageInfo)langs.get(i);
            if (!locale.equals(lang.getLocale())) continue;
            return lang;
        }
        return null;
    }

    public static void setDisplayNameEditor(KDTable table) {
        table.checkParsed();
        KDBizMultiLangBox f7 = new KDBizMultiLangBox();
        f7.putClientProperty((Object)"All_Modal", (Object)Boolean.TRUE);
        f7.setMaxLength(80);
        table.getColumn(COL_displayName).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)f7));
    }

    public static ICellEditor createEntityPropertyF7(CoreUI owner, EntityObjectInfo entity) {
        if (owner != null) {
            DimMetaDataTreeDialog f7 = new DimMetaDataTreeDialog(owner, entity.getAlias(), true, entity);
            KDPromptBox box = new KDPromptBox();
            box.setSelector((KDPromptSelector)f7);
            return new KDTDefaultCellEditor((IKDEditor)box);
        }
        return null;
    }

    public static void loadSourceNameInfo(DimensionSourceCollection sources) throws EASBizException, BOSException {
        DimensionCommonHelper.loadSourceNameInfo(null, sources);
    }

    public static void loadSourceNameInfo(List<DimensionSourceInfo> sources) throws EASBizException, BOSException {
        DimensionCommonHelper.loadSourceNameInfo(null, sources);
    }

    public static KDBizPromptBox getDimensionF7(CoreUI owner, BgDimensionInfo dimensionInfo, String orgId) throws Exception {
        return DimensionClientHelper.getDimensionF7(owner, dimensionInfo, orgId, true);
    }

    public static KDBizPromptBox getDimensionF7(CoreUI owner, BgDimensionInfo dimensionInfo, String orgId, boolean isMulti) throws Exception {
        return DimensionClientHelper.getDimensionF7(owner, dimensionInfo, orgId, isMulti, BigDecimal.ZERO);
    }

    public static KDBizPromptBox getDimensionF7(CoreUI owner, BgDimensionInfo dimensionInfo, String orgId, boolean isMulti, BigDecimal versionNum) throws Exception {
        KDBizPromptBox prmt = new KDBizPromptBox();
        prmt.setEditable(false);
        if (DimensionConstants.DEF_ORGUNIT_NUMBER.equalsIgnoreCase(dimensionInfo.getNumber())) {
            CostCenterF7 f7 = new CostCenterF7();
            prmt.setSelector((KDPromptSelector)f7);
        } else {
            NewDimensionMemberDialog f7 = new NewDimensionMemberDialog(owner, dimensionInfo, orgId, isMulti);
            f7.setShowFilterRadioBtn(true);
            f7.setVersionNum(versionNum);
            prmt.setSelector((KDPromptSelector)f7);
            prmt.addDataChangeListener((DataChangeListener)f7);
        }
        return prmt;
    }

    public static Set getSeletedIDs(int enumValue) {
        HashSet<String> ids = new HashSet<String>();
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcType", (Object)enumValue));
        env.setFilter(filter);
        CoreBaseCollection dimsrc = null;
        try {
            dimsrc = DimensionSourceFactory.getRemoteInstance().getCollection(env);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (dimsrc != null) {
            for (int i = 0; i < dimsrc.size(); ++i) {
                DimensionSourceInfo src = (DimensionSourceInfo)dimsrc.get(i);
                ids.add(src.getSrcID());
            }
        }
        return ids;
    }

    public static EntityViewInfo getBaseDataEntityView() {
        Set ids = DimensionClientHelper.getSeletedIDs(0);
        ids.add("F90B0133");
        EntityViewInfo env = new EntityViewInfo();
        if (ids != null && ids.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("DBbossType", (Object)ids, CompareType.NOTINCLUDE));
            env.setFilter(filter);
        }
        return env;
    }

    public static EntityViewInfo getGeneralEntityView() {
        Set ids = DimensionClientHelper.getSeletedIDs(3);
        EntityViewInfo env = new EntityViewInfo();
        if (ids != null && ids.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(ID, (Object)ids, CompareType.NOTINCLUDE));
            env.setFilter(filter);
        }
        SorterItemCollection sorts = env.getSorter();
        SorterItemInfo sort = new SorterItemInfo(NUMBER);
        sort.setSortType(SortType.ASCEND);
        sorts.add(sort);
        env.setSorter(sorts);
        return env;
    }

    public static DimensionPropSrcCollection sortPropMap(DimensionPropSrcCollection propColl) {
        if (propColl == null) {
            return null;
        }
        DimensionPropSrcCollection col = new DimensionPropSrcCollection();
        col.addCollection(propColl);
        col.sort("order");
        return col;
    }

    public static void initYear(KDComboBox cbxYear) throws BOSException {
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodYearCol = null;
        int year = Calendar.getInstance().get(1);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        SorterItemCollection sorts = view.getSorter();
        SorterItemInfo sort = new SorterItemInfo("year");
        sort.setSortType(SortType.DESCEND);
        sorts.add(sort);
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(1));
        set.add(new Integer(8));
        items.add(new FilterItemInfo("periodType", set, CompareType.INCLUDE));
        view.setFilter(filter);
        bgPeriodYearCol = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(view);
        cbxYear.addItems(bgPeriodYearCol.toArray());
        boolean isSelected = false;
        int count = cbxYear.getItemCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                bgPeriodInfo = (BgPeriodInfo)cbxYear.getItemAt(i);
                if (bgPeriodInfo.getYear() != year || bgPeriodInfo.getPeriodType() != BgPeriodEnum.YEAR) continue;
                isSelected = true;
                cbxYear.setSelectedIndex(i);
                break;
            }
        }
        if (!isSelected && count > 0) {
            bgPeriodInfo = (BgPeriodInfo)cbxYear.getItemAt(0);
            cbxYear.setSelectedIndex(0, false);
        }
        if (count == 0) {
            cbxYear.setSelectedIndex(-1, false);
        }
    }

    public static BgDimensionBaseInfo getSelectDimension(KDComboBox cbxDimension) {
        if (cbxDimension != null && cbxDimension.getSelectedItem() != null && cbxDimension.getSelectedItem() instanceof SourceDisplayInfo) {
            return ((SourceDisplayInfo)cbxDimension.getSelectedItem()).getDimension();
        }
        return null;
    }

    public static void setSelectDimension(KDComboBox cbxDimensio, BgDimensionInfo dimension) {
        if (dimension != null) {
            for (int i = 0; i < cbxDimensio.getItemCount(); ++i) {
                BgDimensionInfo disInfo = (BgDimensionInfo)((SourceDisplayInfo)cbxDimensio.getItemAt(i)).getDimension();
                if (!disInfo.getNumber().equals(dimension.getNumber())) continue;
                cbxDimensio.setSelectedIndex(i);
                return;
            }
        }
        cbxDimensio.setSelectedIndex(-1);
    }

    public static boolean checkEntityProp(EntityObjectInfo entity, String fieldsName) {
        PropertyCollection propCol = entity.getEntityProperties();
        for (int i = 0; i < propCol.size(); ++i) {
            PropertyInfo propInfo = propCol.get(i);
            if (!propInfo.getName().equals(fieldsName)) continue;
            return true;
        }
        return false;
    }

    public static void setSrcNumber(DimensionSourceCollection sources) {
        if (sources == null || sources.isEmpty()) {
            return;
        }
        try {
            Map srcNumbers = DimensionFactory.getRemoteInstance().createDimensionSrcNumber((IObjectCollection)sources);
            for (int i = 0; i < sources.size(); ++i) {
                DimensionSourceInfo source = sources.get(i);
                source.setSrcNumber((String)srcNumbers.get(source.getSrcID()));
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static String getOrgUnitId(FormulaWizardUI formulaWizardUI) {
        OrgUnitInfo orgInfo = DimensionClientHelper.getOrgUnitInfo(formulaWizardUI);
        if (orgInfo != null) {
            return orgInfo.getId().toString();
        }
        return null;
    }

    public static String getOrgUnitNumber(FormulaWizardUI formulaWizardUI) {
        OrgUnitInfo orgInfo = DimensionClientHelper.getOrgUnitInfo(formulaWizardUI);
        if (orgInfo != null) {
            return orgInfo.getNumber();
        }
        return null;
    }

    public static OrgUnitInfo getOrgUnitInfo(FormulaWizardUI formulaWizardUI) {
        if (formulaWizardUI != null && formulaWizardUI.getRptContext() != null) {
            BgRptReportPropertyAdapter adapter;
            if (formulaWizardUI.getRptContext().getPropertyAdapter() instanceof BgRptReportPropertyAdapter && (adapter = (BgRptReportPropertyAdapter)formulaWizardUI.getRptContext().getPropertyAdapter()).getOrgUnit() != null) {
                return adapter.getOrgUnit();
            }
            if (formulaWizardUI.getRptContext().getReportInfo() instanceof IObjectValue) {
                IObjectValue report = (IObjectValue)formulaWizardUI.getRptContext().getReportInfo();
                if (report.get("orgUnit") instanceof OrgUnitInfo) {
                    return (OrgUnitInfo)report.get("orgUnit");
                }
                if (report.get("company") instanceof OrgUnitInfo) {
                    return (OrgUnitInfo)report.get("company");
                }
            }
        }
        return SysContext.getSysContext().getCurrentCostUnit();
    }

    public static RptSrcTypeEnum getSourceType(FormulaWizardUI formulaWizardUI) {
        BgRptReportPropertyAdapter adapter;
        if (formulaWizardUI != null && formulaWizardUI.getRptContext() != null && formulaWizardUI.getRptContext().getPropertyAdapter() instanceof BgRptReportPropertyAdapter && (adapter = (BgRptReportPropertyAdapter)formulaWizardUI.getRptContext().getPropertyAdapter()).getReportProperty("report.sourcetype") != null) {
            return RptSrcTypeEnum.getEnum((Integer)adapter.getReportProperty("report.sourcetype"));
        }
        return RptSrcTypeEnum.PT_BUDGET_REPORT;
    }

    public static BgSchemeInfo getBgSchemeInfo(FormulaWizardUI formulaWizardUI) {
        BgSchemeInfo bgSchemeInfo = null;
        if (formulaWizardUI != null && formulaWizardUI.getRptContext() != null) {
            IObjectValue report;
            IGetBgSchemeNumber adapter;
            if (formulaWizardUI.getRptContext().getPropertyAdapter() instanceof IGetBgSchemeNumber && (adapter = (IGetBgSchemeNumber)formulaWizardUI.getRptContext().getPropertyAdapter()).getBgSchemeNumber() != null) {
                try {
                    bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, name, number , dateFrom, dateTo where number = '" + adapter.getBgSchemeNumber() + "'");
                    return bgSchemeInfo;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (formulaWizardUI.getRptContext().getReportInfo() instanceof IObjectValue && (report = (IObjectValue)formulaWizardUI.getRptContext().getReportInfo()).get("bgscheme") instanceof BgSchemeInfo) {
                return (BgSchemeInfo)report.get("bgscheme");
            }
        }
        if (bgSchemeInfo == null) {
            String schemeid = DimensionClientHelper.getBgSchemeId(formulaWizardUI);
            if (schemeid == null && formulaWizardUI.getUserObject() instanceof BgSchemeInfo) {
                BgSchemeInfo schemeInfo = (BgSchemeInfo)formulaWizardUI.getUserObject();
                schemeid = schemeInfo.getId().toString();
            }
            if (schemeid != null) {
                try {
                    bgSchemeInfo = BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, name, number, dateFrom, dateTo where id = '" + schemeid + "'");
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
        }
        return bgSchemeInfo;
    }

    private static String getBgSchemeId(Object ui) {
        Map uiContext = null;
        if (ui instanceof IUIObject) {
            uiContext = ((IUIObject)ui).getUIContext();
        } else if (ui instanceof KDDialog) {
            uiContext = ((UIModelDialog)ui).getUIObject().getUIContext();
        } else if (ui instanceof UINewFrame) {
            uiContext = ((UINewFrame)ui).getUIObject().getUIContext();
        }
        if (uiContext != null) {
            if (uiContext.containsKey("BGSCHEME_ID")) {
                return (String)uiContext.get("BGSCHEME_ID");
            }
            if (uiContext.containsKey("bgSchemeID")) {
                return (String)uiContext.get("bgSchemeID");
            }
            if (uiContext.containsKey("BGSCHEME_INFO")) {
                if (uiContext.get("BGSCHEME_INFO") instanceof BgSchemeInfo) {
                    return ((BgSchemeInfo)uiContext.get("BGSCHEME_INFO")).getId().toString();
                }
            } else if (uiContext.containsKey("bgScheme") && uiContext.get("bgScheme") instanceof BgSchemeInfo) {
                return ((BgSchemeInfo)uiContext.get("bgScheme")).getId().toString();
            }
            if (ui != uiContext.get("Owner")) {
                return DimensionClientHelper.getBgSchemeId(uiContext.get("Owner"));
            }
        }
        return null;
    }

    public static BgSchemeInfo getBgSchemeInfoFromTemp(FormulaWizardUI formulaWizardUI) {
        if (formulaWizardUI != null && formulaWizardUI.getRptContext() != null) {
            IObjectValue report;
            BgTempRptReportPropertyAdapter adapter;
            if (formulaWizardUI.getRptContext().getPropertyAdapter() instanceof BgTempRptReportPropertyAdapter && (adapter = (BgTempRptReportPropertyAdapter)formulaWizardUI.getRptContext().getPropertyAdapter()).getReportProperty("scheme.id") != null) {
                try {
                    return BgSchemeFactory.getRemoteInstance().getBgSchemeInfo("select id, name, number, dateTo, dateFrom where id = '" + adapter.getReportProperty("scheme.id") + "'");
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if (formulaWizardUI.getRptContext().getReportInfo() instanceof IObjectValue && (report = (IObjectValue)formulaWizardUI.getRptContext().getReportInfo()).get("bgscheme") instanceof BgSchemeInfo) {
                return (BgSchemeInfo)report.get("bgscheme");
            }
        }
        return null;
    }

    public static void setCurrentOrg(KDBizPromptBox orgUnitBox, OrgUnitInfo orgUnit) {
        if (orgUnitBox != null && orgUnitBox.getSelector() instanceof BgOrgDialog && orgUnit != null) {
            ((BgOrgDialog)orgUnitBox.getSelector()).setOrgUnit(orgUnit);
        }
    }

    public static DimensionSourceInfo getSource(KDTable table) {
        if (table != null && table.getUserObject() instanceof DimensionSourceInfo) {
            return (DimensionSourceInfo)table.getUserObject();
        }
        return null;
    }

    public static KDTable getCurrTable(KDTabbedPane tbnMain) {
        if (tbnMain == null) {
            return null;
        }
        return DimensionClientHelper.getTable(tbnMain, tbnMain.getSelectedIndex());
    }

    public static KDTable getTable(KDTabbedPane tbnMain, int index) {
        if (tbnMain.getComponentAt(index) instanceof KDTable) {
            return (KDTable)tbnMain.getComponentAt(index);
        }
        return null;
    }

    public static DimensionSourceCollection loadSourceCollForAlias(Set sourceIDSet) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        DimensionSourceCollection collection = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("dimension.*"));
        sic.add(new SelectorItemInfo("dimension.srcs.*"));
        sic.add(new SelectorItemInfo("dimension.srcs.*"));
        sic.add(new SelectorItemInfo("properties.*"));
        sic.add(new SelectorItemInfo("properties.property.*"));
        sic.add(new SelectorItemInfo("*"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        filter.getFilterItems().add(new FilterItemInfo(ID, (Object)sourceIDSet, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            collection = DimensionSourceFactory.getRemoteInstance().getDimensionSourceCollection(view);
            if (collection != null && !collection.isEmpty()) {
                HashMap<Integer, DimensionSourceInfo> sources = new HashMap<Integer, DimensionSourceInfo>();
                for (int i = 0; i < collection.size(); ++i) {
                    sources.put(DimensionCommonHelper.getField(collection.get(i).getDimension().getRefField()), collection.get(i));
                }
                Object[] keys = sources.keySet().toArray();
                Arrays.sort(keys);
                collection = new DimensionSourceCollection();
                for (int i = 0; i < keys.length; ++i) {
                    collection.add((DimensionSourceInfo)sources.get(keys[i]));
                }
            }
            DimensionClientHelper.loadSourceNameInfo(collection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return collection;
    }

    public static String getDimensionNumberMessage(BgSchemeDimensionHelper schemeHelper, String dimNumber) throws EASBizException, BOSException {
        if (dimNumber == null || schemeHelper == null) {
            return "";
        }
        String formatString = EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgFormDimensionRelationResource", (String)"dimensionNumber");
        StringBuffer res = new StringBuffer();
        String[] nums = DimensionFormulaHelper.splitCombinations(dimNumber);
        BgDimensionInfo dimension = null;
        for (int i = 0; i < nums.length; ++i) {
            String srcNumber = DimensionFormulaHelper.getSrcNumber(nums[i]);
            String number = DimensionFormulaHelper.getMemberNumber(nums[i]);
            dimension = schemeHelper.getDimensionBySrcNumber().get(srcNumber);
            if (dimension == null) continue;
            if (res.length() > 0) {
                res.append(",");
            }
            res.append(MessageFormat.format(formatString, dimension.getName(), number));
        }
        return res.toString();
    }

    public static boolean isDetailDataCell(BgFormInfo bgForm, DimensionMemberCheckFactory dfactory, String itemFormula, String orgUnitId, IMbgViewBase view, String editScen) throws EASBizException, BOSException {
        DimensionMemberCheckHelper helper = dfactory.getHelper(orgUnitId, view);
        return helper.canSave(itemFormula, editScen, null);
    }

    public static Map getPolAlMap(Set dimIdSet, String dimNumber, BgSchemeInfo bgScheme) {
        HashMap result = new HashMap();
        HashMap<String, Integer> polAlMap = new HashMap<String, Integer>();
        HashMap<String, Boolean> isFreezedMap = new HashMap<String, Boolean>();
        HashMap<String, String> idMap = new HashMap<String, String>();
        result.put("polAlMap", polAlMap);
        result.put("isFreezedMap", isFreezedMap);
        result.put("idMap", idMap);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add(ID);
        evi.getSelector().add("isEnabled");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(ID.toLowerCase(), (Object)dimIdSet, CompareType.INCLUDE);
        filter.getFilterItems().add(item);
        evi.setFilter(filter);
        try {
            IBgAccount corebase = null;
            if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber)) {
                corebase = BgAccountFactory.getRemoteInstance();
                evi.getSelector().add("polAlgorithm");
            } else if (!DimensionConstants.necessary.contains(dimNumber)) {
                corebase = MbgMemberFactory.getRemoteInstance();
                evi.getSelector().add("aggregation");
            } else {
                return result;
            }
            CoreBaseCollection col = corebase.getCollection(evi);
            if (col != null) {
                for (int i = 0; i < col.size(); ++i) {
                    CoreBaseInfo displayInfo = col.get(i);
                    if (displayInfo instanceof BgAccountInfo) {
                        polAlMap.put(displayInfo.getId().toString(), ((BgAccountInfo)displayInfo).getPolAlgorithm() == null ? null : Integer.valueOf(((BgAccountInfo)displayInfo).getPolAlgorithm().getValue()));
                        isFreezedMap.put(displayInfo.getId().toString(), !((BgAccountInfo)displayInfo).isIsEnabled());
                    } else if (displayInfo instanceof MbgMemberInfo) {
                        polAlMap.put(displayInfo.getId().toString(), ((MbgMemberInfo)displayInfo).getAggregation() == null ? null : Integer.valueOf(((MbgMemberInfo)displayInfo).getAggregation().getValue()));
                        isFreezedMap.put(displayInfo.getId().toString(), !((MbgMemberInfo)displayInfo).isIsEnabled());
                    }
                    idMap.put(displayInfo.getId().toString(), displayInfo.getId().toString());
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean verifyExpr(CoreUIObject owner, MbgViewListManager viewManager) {
        MbgViewListSheetManager sheet = null;
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            sheet = (MbgViewListSheetManager)viewManager.getSheetManagers().get(s);
            DimensionClientHelper.verifyExpr((Component)owner, sheet.getDimensionManager().getRows(), false);
            DimensionClientHelper.verifyExpr((Component)owner, sheet.getDimensionManager().getColumns(), true);
        }
        return false;
    }

    public static boolean verifyExpr(Component owner, List<IMbgViewListObject> rowCols, boolean isCol) {
        MbgViewListCalcutor calc = null;
        List<IExpr> exprs = null;
        for (int r = 0; r < rowCols.size(); ++r) {
            if (!(rowCols.get(r) instanceof MbgViewListCalcutor)) continue;
            calc = (MbgViewListCalcutor)rowCols.get(r);
            exprs = ExprParseHelper.parse(calc.getFormula());
            DimensionClientHelper.verifyExpr(owner, exprs, false, calc.getInitIndex(), isCol);
        }
        return false;
    }

    public static boolean verifyExpr(Component owner, List<IExpr> exprs, boolean hasOther, Integer curIndex, boolean isCol) {
        Iterator<IExpr> it = exprs.iterator();
        while (it.hasNext()) {
            IExpr expr = it.next();
            if (expr instanceof SpaceWhiteExpr) {
                it.remove();
            } else if (expr instanceof UnkownExpr) {
                MsgBox.showInfo((Component)owner, (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"parseError"), ((UnkownExpr)expr).getValue()));
                SysUtil.abort();
            } else if (isCol && expr instanceof RowExpr) {
                MsgBox.showInfo((Component)owner, (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"checkCalcColHasRow"), expr.getSource()));
                SysUtil.abort();
            } else if (!isCol && expr instanceof ColExpr) {
                MsgBox.showInfo((Component)owner, (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"checkCalcRowHasCol"), expr.getSource()));
                SysUtil.abort();
            }
            if (expr instanceof RowExpr && curIndex != null && curIndex + 1 == ((RowExpr)expr).getRow()) {
                MsgBox.showInfo((Component)owner, (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"checkCacRowOwner"), expr.getSource()));
                SysUtil.abort();
            }
            if (expr instanceof ColExpr && curIndex != null && curIndex + 1 == ((ColExpr)expr).getCol()) {
                MsgBox.showInfo((Component)owner, (String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.ViewListTemplateResource", (String)"checkCacColOwner"), expr.getSource()));
                SysUtil.abort();
                continue;
            }
            if (!(expr instanceof AbstractCalcExpr) && !(expr instanceof ConstExpr)) continue;
            hasOther = true;
        }
        return hasOther;
    }

    static {
        basePropLst.add("bgIndexSort");
        basePropLst.add("bgAccountType");
        basePropLst.add("periodAlgorithm");
        basePropLst.add("formula");
        basePropLst.add("polymerizeAlgorithm");
        basePropLst.add("fpDirection");
        basePropLst.add("elimType");
        accViewPropLst = new ArrayList(basePropLst);
        accViewPropLst.add(LEVEL);
        accViewPropLst.add("DC");
        accViewPropLst.add("PLType");
        accViewPropLst.add("CAA.name");
        cashItemPropLst = new ArrayList(basePropLst);
        cashItemPropLst.add("type");
        cashItemPropLst.add("direction");
        cashItemPropLst.add("asstAccount.name");
        expTypePropLst = new ArrayList(basePropLst);
        expTypePropLst.add("operationType.name");
        rptItemPropLst = new ArrayList(basePropLst);
        rptItemPropLst.add("dc");
        rptItemPropLst.add("reportClass.name");
        costItemPropLst = new ArrayList(basePropLst);
        costItemPropLst.add("CostProperty");
        costItemPropLst.add("ItemType");
    }
}

