/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.client.utils.IBgSchemeFilter;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.IGetSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.SourceDisplayInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DimensionMemberSelectHelper
implements IBgSchemeFilter {
    private BgSchemeDimensionHelper schemeHelper = null;
    protected List<BgDimensionBaseInfo> dimensions = new ArrayList<BgDimensionBaseInfo>();
    protected BgDimensionInfo selectDim = null;

    public void setSelectDim(BgDimensionInfo selectDim) {
        this.selectDim = selectDim;
    }

    public BgDimensionInfo getSelectDim() {
        return this.selectDim;
    }

    public DimensionMemberSelectHelper() {
    }

    public BgSchemeDimensionHelper getSchemeHelper() {
        return this.schemeHelper;
    }

    public void setSchemeHelper(BgSchemeDimensionHelper schemeHelper) {
        this.schemeHelper = schemeHelper;
    }

    public DimensionMemberSelectHelper(BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        this.schemeHelper = schemeHelper;
    }

    public final void loadDimension(boolean isOnlyRefDim, boolean isOnlySelectItem) {
        this.loadDimension(isOnlyRefDim, isOnlySelectItem, null, null, false);
    }

    public void loadDimension(boolean isOnlyRefDim, boolean isOnlySelectItem, BgDimensionBaseInfo dimensionInfo, Map<String, Set<String>> filterValueMap, boolean isHideOrg) {
        this.dimensions.clear();
        if (dimensionInfo == null) {
            List<String> dimNumbers = this.schemeHelper.getAccAndOtherDim(isOnlyRefDim);
            BgDimensionInfo dimension = null;
            for (int i = 0; i < dimNumbers.size(); ++i) {
                dimension = this.schemeHelper.getDimension(dimNumbers.get(i));
                if (dimension == null || isHideOrg && DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimension.getNumber())) continue;
                this.dimensions.add(dimension);
            }
        } else if (this.schemeHelper.getDimension(dimensionInfo.getNumber()) != null) {
            this.dimensions.add(this.schemeHelper.getDimension(dimensionInfo.getNumber()));
            this.selectDim = this.schemeHelper.getDimension(dimensionInfo.getNumber());
            if (dimensionInfo.getType() != null) {
                this.selectDim.setType(dimensionInfo.getType());
            }
        } else {
            this.dimensions.add(dimensionInfo);
            BgDimensionInfo nullDim = new BgDimensionInfo(null);
            nullDim.setType("");
            nullDim.setNumber("");
            this.selectDim = nullDim;
        }
        boolean boo = false;
        int valueType = -1;
        int memberSize = -1;
        for (int i = this.dimensions.size() - 1; i >= 0; --i) {
            if (dimensionInfo != null && dimensionInfo.getMemberValueType() != null) {
                valueType = dimensionInfo.getMemberValueType().getValue();
                memberSize = dimensionInfo.getMember().size();
                boolean bl = boo = valueType == 2 || valueType == 1 && memberSize == 0;
            }
            if (boo || filterValueMap == null || filterValueMap.containsKey(this.schemeHelper.getSrcNumber(this.dimensions.get(i).getNumber()))) continue;
            this.dimensions.remove(i);
        }
    }

    public void loadDimension(KDComboBox cbxDimension) {
        if (this.dimensions != null && this.dimensions.size() > 0) {
            cbxDimension.removeAllItems();
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            cbxDimension.addItem((Object)new SourceDisplayInfo(this.dimensions.get(i)));
        }
    }

    public String getSrcNumber(String dimNumber) {
        return this.schemeHelper.getSrcNumber(dimNumber);
    }

    public String getRefField(String dimNumber) {
        return this.schemeHelper.getRefField(dimNumber);
    }

    public BgDimensionInfo getDimension(String dimNumber) {
        return this.schemeHelper.getDimension(dimNumber);
    }

    public void addIdList(IUIObject win, UIContext uiContext, String dimNumber) throws EASBizException, BOSException {
        DimensionMemberSelectHelper.addIds(win, uiContext, dimNumber);
    }

    public static void addIds(IUIObject win, UIContext uiContext, String dimNumber) throws EASBizException, BOSException {
        BgSchemeDimensionHelper schemeHelper = DimensionMemberSelectHelper.getSchemeHelper(win);
        if (schemeHelper != null) {
            uiContext.put((Object)"IDList", schemeHelper.getMemberSet(dimNumber, false));
        }
    }

    public static BgSchemeDimensionHelper getSchemeHelper(Object win) throws EASBizException, BOSException {
        IUIWindow w;
        IGetSchemeHelper helper = null;
        if (win instanceof IGetSchemeHelper) {
            helper = (IGetSchemeHelper)win;
        } else if (win instanceof IUIWindow && (w = (IUIWindow)win).getUIObject() instanceof IGetSchemeHelper) {
            helper = (IGetSchemeHelper)w.getUIObject();
        }
        if (helper != null) {
            return helper.getSchemeHelper();
        }
        return null;
    }

    public static void addBgPeriodNumber(IUIObject win, UIContext uiContext) throws EASBizException, BOSException {
        BgSchemeDimensionHelper schemeHelper = DimensionMemberSelectHelper.getSchemeHelper(win);
        if (schemeHelper != null) {
            uiContext.put((Object)"bgPeriodTypeNumbers", schemeHelper.getMemberSet(DimensionConstants.DEF_PERIOD_NUMBER, true));
        }
    }

    public void addIdFilter(KDBizPromptBox prmt, String dimNumber) {
        DimensionMemberSelectHelper.addIdFilter(prmt, dimNumber, this.getSchemeHelper());
    }

    public static void addIdFilter(KDBizPromptBox prmt, String dimNumber, BgSchemeDimensionHelper schemeHelper) {
        if (schemeHelper != null) {
            boolean flag;
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            if (schemeHelper.getMemberSet(dimNumber, false) == null) {
                return;
            }
            String getDimensionMemberIdSqlString = "select fmemberId from T_mbg_bgdimsettingsmember where FBGDIMSETTINGSID in (SELECT fid FROM T_mbg_bgdimsettings where FBGSCHEMEID ='" + schemeHelper.getBgSchemeId() + "' and fdimnumber ='" + dimNumber + "')";
            boolean bl = flag = dimNumber.equals(DimensionConstants.DEF_SCENARIO_NUMBER) || dimNumber.equals(DimensionConstants.DEF_CURRENCY_NUMBER) || dimNumber.equals(DimensionConstants.DEF_ELEMENT_NUMBER) || dimNumber.equals(DimensionConstants.DEF_VERSION_NUMBER);
            if (flag) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)getDimensionMemberIdSqlString, CompareType.INNER));
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("id", schemeHelper.getMemberSet(dimNumber, false), CompareType.INCLUDE));
            }
            prmt.setEntityViewInfo(evi);
            prmt.getQueryAgent().resetRuntimeEntityView();
            DimensionMemberSelectHelper.checkMember(prmt, dimNumber, schemeHelper);
        }
    }

    public static void addIdFilter(KDBizPromptBox prmt, String dimNumber, BgSchemeDimensionHelper schemeHelper, FilterItemCollection filers) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        if (schemeHelper != null && dimNumber != null && schemeHelper != null) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", schemeHelper.getMemberSet(dimNumber, false), CompareType.INCLUDE));
        }
        if (filers != null && !filers.isEmpty()) {
            evi.getFilter().getFilterItems().addObjectCollection((IObjectCollection)filers);
        }
        prmt.setEntityViewInfo(evi);
        prmt.getQueryAgent().resetRuntimeEntityView();
        if (schemeHelper != null) {
            DimensionMemberSelectHelper.checkMember(prmt, dimNumber, schemeHelper);
        }
    }

    public static void checkMember(KDBizPromptBox prmt, String dimNumber, BgSchemeDimensionHelper schemeHelper) {
        if (schemeHelper != null) {
            // empty if block
        }
    }

    private static String getNumber(KDBizPromptBox prmt) {
        String number = null;
        if (prmt.getData() instanceof String) {
            number = (String)prmt.getData();
        } else if (prmt.getData() instanceof DataBaseInfo) {
            number = ((DataBaseInfo)prmt.getData()).getNumber();
        } else if (prmt.getData() instanceof BgDimensionMember) {
            number = ((BgDimensionMember)prmt.getData()).getCombNumber();
        }
        return number;
    }

    public static void checkItemComb(KDBizPromptBox budgetProject, BgSchemeDimensionHelper schemeHelper) {
    }

    public static void checkPeriod(KDBizPromptBox prmtEndPeriod, BgSchemeDimensionHelper schemeHelper) {
    }
}

