/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.client.utils.NumberExpandHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.bgcsl.provider.BgCslViewListFormProvider;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.client.MbgViewListFormProcessUI;
import com.kingdee.eas.ma.mbg.client.NewDimensionMemberF7UI;
import com.kingdee.eas.ma.mbg.client.ViewListAddPeriodF7UI;
import com.kingdee.eas.ma.mbg.client.common.ICalculate;
import com.kingdee.eas.ma.mbg.client.viewListForm.MBGViewListBaseFormContextManager;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgSheetRange;
import com.kingdee.eas.ma.mbg.common.IMbgSheetBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.provider.ViewListProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormAdjustProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormBaseProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MBGViewListFormProvider;
import com.kingdee.eas.ma.mbg.provider.viewListForm.MbgViewListFormRollProvider;
import com.kingdee.eas.ma.mbg.utils.BgAdjustFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MBGViewListFormCommonHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MBGViewListFormClientHelper
extends MBGViewListFormCommonHelper {
    private static final Logger logger = CoreUIObject.getLogger(MBGViewListFormClientHelper.class);
    private Map<String, Map<String, BgNViewDataInfo>> bgDataMap = null;
    private Map<String, Map<String, BgAdjustFormDiversityData>> adjustMap = null;

    public static void reloadBookFormBgForm(MBGViewListBaseFormContextManager contextManager) throws Exception {
        MBGViewListFormClientHelper.reloadBookFormBgForm(contextManager, false);
    }

    public static void reloadBookFormBgForm(MBGViewListBaseFormContextManager contextManager, boolean isOnlyLoadBook) throws Exception {
        Book book = null;
        int sheetIndex = contextManager.getSpreadContext().getBook().getActiveSheetIndex();
        if (isOnlyLoadBook) {
            book = contextManager.getProvider().loadBook();
        } else {
            contextManager.getProvider().resetBookParserHelper();
            book = (Book)contextManager.getProvider().load(false);
        }
        book.getSheet(0).setSelected(false);
        contextManager.getSpreadContext().setBook(book);
        contextManager.registerFormulaToBook();
        contextManager.getProvider().fillData(contextManager.getSpreadContext().getBook());
        contextManager.getProvider().dealWithSheetPermission(contextManager.getSpreadContext().getBook());
        MBGViewListFormClientHelper.checkItemDimeinsionEmpty((CoreUIObject)contextManager.getOwnerUI(), contextManager.getProvider().getBgDimensionManager());
        contextManager.getSpreadContext().getBook().getUndoManager().discardAllEdits();
        contextManager.enableCal();
        contextManager.getSpreadContext().repaint();
        if (contextManager.getOwnerUI() instanceof ICalculate) {
            try {
                ((ICalculate)contextManager.getOwnerUI()).actionCalculate_actionPerformed(new ActionEvent(contextManager.getOwnerUI(), 0, MbgViewListFormProcessUI.class.getName() + "$ActionCalculate"));
            }
            catch (Exception e1) {
                contextManager.getOwnerUI().handUIExceptionAndAbort(e1);
            }
        }
        book.setActiveSheet(sheetIndex);
    }

    public static void checkOrgBeforeAction(ViewListProvider provider, Sheet sheet) {
        String curOrgNumForBgForm;
        if (provider == null || sheet == null || provider.getOrgUnitInfo() == null || !(provider instanceof MBGViewListFormBaseProvider) && !(provider instanceof BgCslViewListFormProvider)) {
            return;
        }
        int sheetIndex = sheet.getIndex();
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(((MbgViewListSheetManager)((MbgViewListManager)provider.getCurMbgViewManager()).getSheetManagers().get(sheetIndex)).getDimensionManager());
        if (!isorgOnPageOrView) {
            return;
        }
        String curOrgNumForDimensionData = provider.getOrgNumsForCurSheet(sheetIndex, new HashSet<String>());
        if (!curOrgNumForDimensionData.equals(curOrgNumForBgForm = provider.getOrgUnitInfo().getNumber())) {
            if (provider instanceof BgCslViewListFormProvider) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.MBGViewListFormResource", (String)"pleaseChooseFormCslOrg"));
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.MBGViewListFormResource", (String)"pleaseChooseFormOrg"));
            }
            SysUtil.abort();
        }
    }

    public static void checkCanRemove(CoreUI f7UI, BgDimensionBaseInfo selectDimension, Object sourceDimension, BgMemberSelectTypeEnum selectType, KDTable table, List<Integer> rows, String orgId, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        String bgFormId = (String)f7UI.getUIContext().get("BGFORM_ID");
        IMbgSheetBase sheetManager = (IMbgSheetBase)f7UI.getUIContext().get("sheetManager");
        String groupUnitId = (String)f7UI.getUIContext().get("GROUPORG_ID");
        if (StringUtils.isEmpty((String)bgFormId) || sheetManager == null || selectDimension == null) {
            return;
        }
        HashMap<String, String> number_name = new HashMap<String, String>();
        LinkedHashMap<String, Integer> number_rowIndex = new LinkedHashMap<String, Integer>();
        LinkedHashSet<String> remove = new LinkedHashSet<String>();
        HashMap<String, BgDimensionMember> removeInfo = new HashMap<String, BgDimensionMember>();
        HashMap<String, BgDimensionMember> newMembers = new HashMap<String, BgDimensionMember>();
        HashMap<String, Set<String>> subMembers = new HashMap<String, Set<String>>();
        String number2 = null;
        String name = null;
        for (int r = 0; r < table.getRowCount(); ++r) {
            BgDimensionMember member;
            IRow row = table.getRow(r);
            if (row.getStyleAttributes().isHided()) continue;
            number2 = NumberExpandHelper.getNumber((IRow)row);
            name = String.valueOf(row.getCell("name").getValue());
            number_name.put(number2, name);
            number_rowIndex.put(number2, r);
            if (rows.contains(new Integer(r))) {
                remove.add(number2);
                if (!BgMemberSelectTypeEnum.Member.equals((Object)selectType)) continue;
                if (row.getUserObject() instanceof BgDimensionMember) {
                    member = (BgDimensionMember)row.getUserObject();
                    removeInfo.put(member.getNumber(), member);
                    MBGViewListFormClientHelper.addSubMembers(subMembers, member.getNumber(), member.getNumber());
                    continue;
                }
                if (!(f7UI instanceof ViewListAddPeriodF7UI)) continue;
                member = new BgDimensionMember(selectDimension.getNumber(), selectDimension.getRefField(), name, number2);
                member.setSrcNumber(schemeHelper.getSrcNumber(selectDimension.getNumber()));
                removeInfo.put(member.getNumber(), member);
                MBGViewListFormClientHelper.addSubMembers(subMembers, member.getNumber(), member.getNumber());
                continue;
            }
            if (!BgMemberSelectTypeEnum.Member.equals((Object)selectType)) continue;
            member = null;
            if (f7UI instanceof NewDimensionMemberF7UI) {
                member = ((NewDimensionMemberF7UI)f7UI).getMemberOfRow(row);
            } else if (f7UI instanceof ViewListAddPeriodF7UI) {
                member = new BgDimensionMember(selectDimension.getNumber(), selectDimension.getRefField(), name, number2);
                member.setSrcNumber(schemeHelper.getSrcNumber(selectDimension.getNumber()));
            }
            if (member == null) continue;
            newMembers.put(member.getName(), member);
            MBGViewListFormClientHelper.addSubMembers(subMembers, member.getNumber(), member.getNumber());
        }
        if (BgMemberSelectTypeEnum.Property.equals((Object)selectType) || BgMemberSelectTypeEnum.Variate.equals((Object)selectType)) {
            Map memberInfo = MBGFormFacadeFactory.getRemoteInstance().queryMembers(orgId, schemeHelper, selectType, selectDimension.getNumber(), new HashSet(number_name.keySet()));
            if (memberInfo == null || memberInfo.isEmpty()) {
                return;
            }
            Map subMap = null;
            for (String number2 : memberInfo.keySet()) {
                subMap = (Map)memberInfo.get(number2);
                for (BgDimensionMember member : subMap.values()) {
                    MBGViewListFormClientHelper.addSubMembers(subMembers, number2, member.getNumber());
                    if (remove.contains(number2)) {
                        removeInfo.put(member.getNumber(), member);
                        continue;
                    }
                    newMembers.put(member.getNumber(), member);
                }
            }
        }
        if (removeInfo.isEmpty() || !(sourceDimension instanceof MbgViewListDimensionInfo)) {
            return;
        }
        Object[] layouts = DimensionCommonHelper.searchViewListLayout((MbgViewListSheetManager)sheetManager, (MbgViewListDimensionInfo)sourceDimension);
        String layout = (String)layouts[0];
        int layoutIndex = (Integer)layouts[1];
        try {
            List result = MBGFormFacadeFactory.getRemoteInstance().getHasDataMember(bgFormId, orgId, sheetManager, selectDimension.getNumber(), new ArrayList(removeInfo.values()), new ArrayList(newMembers.values()), schemeHelper, layout, layoutIndex, groupUnitId);
            if (result != null) {
                int total = rows.size();
                int fail = 0;
                String detailFormat = EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionAddNewResource", (String)"removeMemberFail");
                StringBuffer detail = new StringBuffer();
                for (String number2 : remove) {
                    if (!subMembers.containsKey(number2)) continue;
                    ((Set)subMembers.get(number2)).retainAll(result);
                    if (((Set)subMembers.get(number2)).isEmpty()) continue;
                    rows.remove(number_rowIndex.get(number2));
                    ++fail;
                    if (detail.length() > 0) {
                        detail.append("\r\n");
                    }
                    detail.append(MessageFormat.format(detailFormat, (String)number_name.get(number2)));
                }
                String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionAddNewResource", (String)"removeMemberNoSuccess"), total, fail);
                if (fail > 0) {
                    MsgBox.showDetailAndOK((Component)f7UI, (String)msg, (String)detail.toString(), (int)1);
                }
            }
        }
        catch (BOSException e) {
            f7UI.handUIExceptionAndAbort((Exception)((Object)e));
        }
        catch (EASBizException e) {
            f7UI.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    public static void hideToolBar(SpreadContext spreadContext) {
        spreadContext.getToolBarManager().setItemVisible("ToolItem_Copy", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_Paste", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_Undo", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_Redo", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_Print", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_PrintPreview", false);
        spreadContext.getToolBarManager().setItemVisible("ToolItem_PrintSetup", false);
        spreadContext.getToolBarManager().getToolBar("style").setVisible(false);
    }

    public static void buildFormula(MbgViewListSheetManager sheetManager, BgViewHelper.IFormulaProcessor processor, BgSchemeDimensionHelper schemeHelper, BgDimensionMember queryMember) throws BOSException {
        BgViewHelper.buildFormula(sheetManager, processor, schemeHelper, queryMember);
    }

    public static Set<String> buildFormula(MbgViewListSheetManager sheetManager, BgSchemeDimensionHelper schemeHelper, BgDimensionMember queryMember) throws BOSException {
        final HashSet<String> formulas = new HashSet<String>();
        final HashMap clone = new HashMap();
        BgViewHelper.IFormulaProcessor processor = new BgViewHelper.IFormulaProcessor(){

            @Override
            public void process(String formula, String versionNumber, String scenarioNumber) {
                if (!StringUtils.isEmpty((String)formula)) {
                    formulas.add(formula);
                }
            }

            @Override
            public Map<Integer, String> getCloneMap() {
                return clone;
            }
        };
        MBGViewListFormClientHelper.buildFormula(sheetManager, processor, schemeHelper, queryMember);
        return formulas;
    }

    public static void collectFormulas(CoreUI f7UI, BgDimensionBaseInfo selectDimension, Object sourceDimension, KDTable table, List<Integer> rows, BgSchemeDimensionHelper schemeHelper) throws Exception {
        String orgUnitId;
        BgDimensionBaseInfo dimension = selectDimension;
        List<BgDimensionMember> remove = MBGViewListFormClientHelper.getSelectBgDimensionMember(table, rows);
        Sheet sheet = (Sheet)f7UI.getUIContext().get("sheet");
        if (sheet == null) {
            return;
        }
        ViewListProvider provider = (ViewListProvider)f7UI.getUIContext().get("provider");
        IMbgSheetBase sheetManager = (IMbgSheetBase)f7UI.getUIContext().get("sheetManager");
        Object[] layouts = DimensionCommonHelper.searchViewListLayout((MbgViewListSheetManager)sheetManager, (MbgViewListDimensionInfo)sourceDimension);
        String layout = (String)layouts[0];
        if (provider != null && provider.getEditValue() instanceof BgFormInfo) {
            String versionNumber = ((BgFormInfo)provider.getEditValue()).getBgVersion().getNumber();
            if (dimension.getNumber().equals(DimensionConstants.DEF_VERSION_NUMBER)) {
                ArrayList<String> versionNumbers = new ArrayList<String>();
                for (BgDimensionMember temp : remove) {
                    versionNumbers.add(temp.getNumber());
                }
                if (!versionNumbers.contains(versionNumber)) {
                    return;
                }
            }
        }
        if ((orgUnitId = (String)f7UI.getUIContext().get("ROWCOLORG_ID")) == null) {
            orgUnitId = (String)f7UI.getUIContext().get(BgBaseConstants.ORGUNIT_ID);
        }
        StringBuffer sb = new StringBuffer();
        Set<String> formulas = MBGViewListFormClientHelper.getFormulas(f7UI.getUIContext(), orgUnitId, dimension.getNumber(), sourceDimension, schemeHelper, remove);
        String currentFormulas = MBGViewListFormClientHelper.getFormulaString(orgUnitId, formulas);
        if (sheet.getUserObject("deletedFormulasFromAddMember") != null) {
            sb.append((String)sheet.getUserObject("deletedFormulasFromAddMember").getValue());
            sb.append("@@");
        }
        if (currentFormulas != null) {
            sb.append(currentFormulas);
            sheet.setUserObject("deletedFormulasFromAddMember", (Object)sb.toString());
        }
    }

    public static void resetBgDataInfo(MBGViewListFormProvider provider, List formulas, String orgId, List versionNumbers) {
        for (int j = 0; j < formulas.size(); ++j) {
            for (int i = 0; i < versionNumbers.size(); ++i) {
                MBGViewListFormClientHelper.createNullData(provider.getBgDataMap(), orgId, (String)formulas.get(j), (String)versionNumbers.get(i));
            }
        }
    }

    public static void resetBgAdjustData(MBGViewListFormAdjustProvider provider, List formulas, String orgId) {
        for (int j = 0; j < formulas.size(); ++j) {
            String formula = (String)formulas.get(j);
            if (provider.getAdjustMap() == null || orgId == null) {
                return;
            }
            Map subMap = null;
            if (!provider.getAdjustMap().containsKey(orgId) || !(subMap = (Map)provider.getAdjustMap().get(orgId)).containsKey(formula.toString())) continue;
            BgAdjustFormDiversityData data = (BgAdjustFormDiversityData)subMap.get(formula.toString());
            data.setNewValue(null);
        }
    }

    public static Set<String> getFormulas(Map uiContext, String orgUnitId, String dimensionNumber, Object sourceDimension, BgSchemeDimensionHelper schemeHelper, List<BgDimensionMember> removeDetailMembers) throws EASBizException, BOSException {
        HashSet<String> formulas;
        block9: {
            HashMap<String, BgDimensionMember> memberNumber;
            IMbgSheetBase sheetManager;
            block8: {
                formulas = new HashSet<String>();
                sheetManager = (IMbgSheetBase)uiContext.get("sheetManager");
                Object[] layouts = DimensionCommonHelper.searchViewListLayout((MbgViewListSheetManager)sheetManager, (MbgViewListDimensionInfo)sourceDimension);
                String layout = (String)layouts[0];
                int layoutIndex = (Integer)layouts[1];
                BgDimensionBaseInfo dimension = null;
                for (int i = 0; i < sheetManager.getDimensionManager().getDimension().size(); ++i) {
                    if (!(sheetManager.getDimensionManager().getDimension().get(i) instanceof BgDimensionBaseInfo) || !dimensionNumber.equals(((BgDimensionBaseInfo)sheetManager.getDimensionManager().getDimension().get(i)).getNumber())) continue;
                    dimension = (BgDimensionBaseInfo)sheetManager.getDimensionManager().getDimension().get(i);
                    break;
                }
                if (dimension == null) {
                    return null;
                }
                memberNumber = new HashMap<String, BgDimensionMember>();
                for (int m = 0; m < removeDetailMembers.size(); ++m) {
                    BgDimensionMember member = removeDetailMembers.get(m);
                    memberNumber.put(member.getNumber(), member);
                }
                HashMap formulaMap = new HashMap();
                if (!(sheetManager instanceof MbgViewListSheetManager)) break block8;
                MbgViewListSheetManager _sheetManager = (MbgViewListSheetManager)sheetManager;
                MbgViewListDimensionInfo _dimension = null;
                if ("page".equals(layout)) {
                    _dimension = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(dimensionNumber, _sheetManager.getDimensionManager().getPageDimension());
                } else {
                    List<IMbgViewListObject> rows = null;
                    rows = "row".equals(layout) ? _sheetManager.getDimensionManager().getRows() : _sheetManager.getDimensionManager().getColumns();
                    MbgViewListRowCol rowObj = (MbgViewListRowCol)rows.get(layoutIndex);
                    _dimension = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(dimensionNumber, rowObj.getDimensions());
                }
                for (BgDimensionMember member : memberNumber.values()) {
                    _dimension.getMember().clear();
                    _dimension.getMember().add(member);
                    if (member.getSrcNumber() == null) {
                        member.setType(dimensionNumber);
                    }
                    formulas.addAll(MBGViewListFormClientHelper.buildFormula((MbgViewListSheetManager)sheetManager, schemeHelper, member));
                }
                break block9;
            }
            if (!(sheetManager instanceof IMbgSheetManager)) break block9;
            Iterator it = memberNumber.values().iterator();
            while (it.hasNext()) {
                formulas.addAll(BgViewHelper.buildFormula((IMbgSheetManager)sheetManager, null, schemeHelper));
            }
        }
        return formulas;
    }

    public static List getVerisonNumbers(IMbgSheetBase sheetManager, List<BgDimensionMember> remove, BgDimensionBaseInfo dimension, String versionNumber) {
        ArrayList<String> versionNubmers = new ArrayList<String>();
        List selectMembers = new ArrayList();
        if (versionNumber != null) {
            versionNubmers.add(versionNumber);
        } else if (dimension.getNumber().equalsIgnoreCase(MBGLayoutConstants.BG_VERSION)) {
            for (int i = 0; i < remove.size(); ++i) {
                versionNubmers.add(remove.get(i).getNumber());
            }
        } else {
            BgDimensionBaseInfo searchDimension = DimensionCommonHelper.searchDimension(MBGLayoutConstants.BG_VERSION, sheetManager.getDimensionManager().getDimension());
            if (searchDimension.getLayout().equals("row")) {
                searchDimension = DimensionCommonHelper.searchDimension(MBGLayoutConstants.BG_VERSION, sheetManager.getDimensionManager().getRowDimension());
                selectMembers = searchDimension.getSelectMembers();
            } else if (searchDimension.getLayout().equals("col")) {
                searchDimension = DimensionCommonHelper.searchDimension(MBGLayoutConstants.BG_VERSION, sheetManager.getDimensionManager().getColDimension());
                selectMembers = searchDimension.getSelectMembers();
            } else if (searchDimension.getLayout().equals("page")) {
                searchDimension = DimensionCommonHelper.searchDimension(MBGLayoutConstants.BG_VERSION, sheetManager.getDimensionManager().getPageDimension());
                selectMembers = searchDimension.getSelectMembers();
            }
            for (int i = 0; i < selectMembers.size(); ++i) {
                versionNubmers.add(BgViewHelper.getNumber(selectMembers.get(i)));
            }
        }
        return versionNubmers;
    }

    public Map<String, Map<String, BgNViewDataInfo>> getBgDataMap() {
        return this.bgDataMap;
    }

    public void setBgDataMap(Map<String, Map<String, BgNViewDataInfo>> bgDataMap) {
        this.bgDataMap = bgDataMap;
    }

    public Map<String, Map<String, BgAdjustFormDiversityData>> getAdjustMap() {
        return this.adjustMap;
    }

    public void setAdjustMap(Map<String, Map<String, BgAdjustFormDiversityData>> adjustMap) {
        this.adjustMap = adjustMap;
    }

    public static List<BgDimensionMember> getSelectBgDimensionMember(KDTable table, List<Integer> rows) {
        ArrayList<BgDimensionMember> remove = new ArrayList<BgDimensionMember>();
        IRow row = null;
        String number = null;
        String name = null;
        for (int r = 0; r < table.getRowCount(); ++r) {
            BgDimensionMember member;
            row = table.getRow(r);
            number = NumberExpandHelper.getNumber((IRow)row);
            name = String.valueOf(row.getCell("name").getValue());
            if (!rows.contains(r)) continue;
            if (row.getUserObject() instanceof BgDimensionMember) {
                member = (BgDimensionMember)row.getUserObject();
            } else {
                member = new BgDimensionMember(null, null, name, number);
                member.setNumber(number);
                member.setName(name);
            }
            remove.add(member);
        }
        return remove;
    }

    public static String getFormulaString(String orgUnitId, Set<String> formulas) {
        String formulasString = null;
        if (formulas.size() > 0) {
            StringBuffer formulasSb = new StringBuffer();
            for (String formula : formulas) {
                String formulaStr = orgUnitId + "##" + formula;
                formulasSb.append(formulaStr).append("@@");
            }
            if (formulasSb.length() > 0) {
                formulasString = formulasSb.toString();
                formulasString = formulasString.substring(0, formulasString.length() - 2);
            }
        }
        return formulasString;
    }

    public static String getOrgNumberOfCell(ViewListProvider provider, Cell cell) {
        String orgNumber = null;
        MbgViewListSheetManager sheetManager = (MbgViewListSheetManager)provider.getCurMbgSheetManager();
        Sheet sheet = cell.getSheet();
        if (BgNFSHelper.checkHasItemFormula(cell)) {
            orgNumber = BgNFSHelper.getItemFormula(cell).getExt("ORGUNIT");
        } else {
            int sheetIndex = sheet.getIndex();
            boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(sheetManager.getDimensionManager());
            if (isorgOnPageOrView) {
                orgNumber = provider.getOrgNumsForCurSheet(sheetIndex, new HashSet<String>());
            } else {
                BgDimensionMember orgMember = null;
                boolean isOrgOnCol = MBgTemplateHelper.isOrgOnCol(sheetManager.getDimensionManager());
                IMbgViewListObject rowColObj = null;
                if (isOrgOnCol) {
                    rowColObj = ViewListHelper.getDimension(sheet.getColumn(cell.getCol(), false));
                    if (rowColObj instanceof MbgViewListRowCol && (orgMember = MBGViewListFormClientHelper.getOrgMember((MbgViewListRowCol)rowColObj)) != null) {
                        orgNumber = orgMember.getNumber();
                    }
                } else {
                    rowColObj = ViewListHelper.getDimension(sheet.getRow(cell.getRow(), false));
                    if (rowColObj instanceof MbgViewListRowCol && (orgMember = MBGViewListFormClientHelper.getOrgMember((MbgViewListRowCol)rowColObj)) != null) {
                        orgNumber = orgMember.getNumber();
                    }
                }
            }
        }
        return orgNumber;
    }

    public static boolean checkCanEditByBgFormState(MBGViewListFormProvider provider, Cell cell) {
        MbgViewListSheetManager sheetManager = (MbgViewListSheetManager)provider.getCurMbgSheetManager();
        Map<String, String> orgIdAndNumMap = provider.getOrgIdAndNumMap(sheetManager.getDimensionManager().getAllDimensions());
        HashMap<String, String> orgNumAndIdMap = new HashMap<String, String>(orgIdAndNumMap.size());
        for (Map.Entry<String, String> entry : orgIdAndNumMap.entrySet()) {
            orgNumAndIdMap.put(entry.getValue(), entry.getKey());
        }
        String cellOrgNumber = MBGViewListFormClientHelper.getOrgNumberOfCell(provider, cell);
        Map<String, BgFormStateEnum> orgIdFormState = provider.orgIdFormState;
        if (orgNumAndIdMap.containsKey(cellOrgNumber)) {
            String orgId = (String)orgNumAndIdMap.get(cellOrgNumber);
            if (orgIdFormState != null && orgIdFormState.containsKey(orgId)) {
                BgFormStateEnum bgFormStateEnum = orgIdFormState.get(orgId);
                if (bgFormStateEnum == null) {
                    return true;
                }
                if (provider instanceof MbgViewListFormRollProvider) {
                    if (!BgFormStateEnum.RollEdited.equals((Object)bgFormStateEnum)) {
                        return false;
                    }
                } else if (provider instanceof MBGViewListFormAdjustProvider) {
                    if (!BgFormStateEnum.Adjusted.equals((Object)bgFormStateEnum) && !BgFormStateEnum.Approved.equals((Object)bgFormStateEnum)) {
                        return false;
                    }
                } else if (!(BgFormStateEnum.Edited.equals((Object)bgFormStateEnum) || BgFormStateEnum.Back.equals((Object)bgFormStateEnum) || BgFormStateEnum.REFERRING.equals((Object)bgFormStateEnum))) {
                    return !provider.checkInProInst(orgId) && (BgFormStateEnum.REFERRING.equals((Object)bgFormStateEnum) || BgFormStateEnum.Approving.equals((Object)bgFormStateEnum));
                }
            }
        }
        return true;
    }

    public static Boolean checkCanEditOtherBgForm(ViewListProvider provider, Cell cell) {
        Boolean canEdit = true;
        MbgViewListSheetManager sheetManager = (MbgViewListSheetManager)provider.getCurMbgSheetManager();
        Sheet sheet = cell.getSheet();
        String curOrgNumForBgForm = provider.getOrgUnitInfo().getNumber();
        boolean isorgOnPageOrView = MBgTemplateHelper.isOrgOnPageOrView(sheetManager.getDimensionManager());
        HashSet<String> orgNums = new HashSet<String>();
        String curOrgNumForDimensionData = provider.getOrgNumsForCurSheet(sheet.getIndex(), orgNums);
        String cellOrgNumber = MBGViewListFormClientHelper.getOrgNumberOfCell(provider, cell);
        if (!(!isorgOnPageOrView && orgNums.size() <= 1 || StringUtils.isEmpty((String)cellOrgNumber) || curOrgNumForBgForm.equals(cellOrgNumber) || sheetManager.isCanEditOtherAddedBgForm().booleanValue())) {
            canEdit = false;
        }
        return canEdit;
    }

    public static Map<String, Set<String>> checkFormualHasAdjust(BgFormInfo bgFormInfo, Book book) throws EASBizException, BOSException {
        HashMap<String, Set<String>> formulas = new HashMap<String, Set<String>>();
        if (bgFormInfo == null || book == null) {
            return formulas;
        }
        for (int s = 0; s < book.getSheetCount(); ++s) {
            Sheet sheet = book.getSheet(s);
            for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                    Cell cell = sheet.getCell(r, c, false);
                    ItemFormula itemFormula = BgNFSHelper.getItemFormula(cell);
                    if (itemFormula == null) continue;
                    String orgId = itemFormula.getExt("ORGUNITID");
                    if (orgId == null) {
                        orgId = bgFormInfo.getOrgUnit().getId().toString();
                    }
                    if (!formulas.containsKey(orgId)) {
                        formulas.put(orgId, new HashSet());
                    }
                    ((Set)formulas.get(orgId)).add(itemFormula.getFormula());
                }
            }
        }
        return BgAdjustFacadaFactory.getRemoteInstance().checkHasAdjust(bgFormInfo.getBgScheme().getId().toString(), formulas, bgFormInfo.getBgVersion().getNumber(), bgFormInfo.getProcessType());
    }

    public static void showAdjust(BgFormInfo bgFormInfo, Book book) {
        try {
            Map<String, Set<String>> formulas = MBGViewListFormClientHelper.checkFormualHasAdjust(bgFormInfo, book);
            if (formulas == null || formulas.isEmpty()) {
                return;
            }
            Sheet sheet = null;
            Cell cell = null;
            String orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
            ItemFormula itemFormula = null;
            String orgId = null;
            BgSheetRange editRange = null;
            StyleAttributes edit = Styles.getEmptySA();
            edit.setBackground(BgNConstants.EDIT_COLOR);
            for (int s = 0; s < book.getSheetCount(); ++s) {
                sheet = book.getSheet(s);
                editRange = new BgSheetRange(sheet);
                for (int r = 0; r <= sheet.getMaxRowIndex(); ++r) {
                    for (int c = 0; c <= sheet.getMaxColIndex(); ++c) {
                        cell = sheet.getCell(r, c, false);
                        itemFormula = BgNFSHelper.getItemFormula(cell);
                        if (itemFormula == null) continue;
                        orgId = itemFormula.getExt("ORGUNITID");
                        if (orgId == null) {
                            orgId = orgUnitId;
                        }
                        if (!formulas.containsKey(orgId) || !formulas.get(orgId).contains(itemFormula.getFormula())) continue;
                        editRange.addCell(r, c);
                        BgNFSHelper.setAdjustBeforeColor(cell, BgNConstants.EDIT_COLOR);
                    }
                }
                Range rg = editRange.getRange();
                if (rg == null) continue;
                rg.setIgnoreProtected(true);
                rg.setStyle(edit, Styles.getEmptySA());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

