/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.mbg.BgAdjustBillFactory;
import com.kingdee.eas.ma.mbg.BgAdjustBillInfo;
import com.kingdee.eas.ma.mbg.BgExamineCheckFactory;
import com.kingdee.eas.ma.mbg.BgExamineFacadeFactory;
import com.kingdee.eas.ma.mbg.BgExamineFactory;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgExamineResult;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.IBgExamineCheck;
import com.kingdee.eas.ma.mbg.IBgExamineFacade;
import com.kingdee.eas.ma.mbg.client.BgExamineSpeResultViewUI;
import com.kingdee.eas.ma.mbg.client.utils.BgNFCHelper;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.utils.BgFormHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class MBgExamineClientUtils {
    public static int PASS = 1;
    public static int NOPASS = 0;
    public static String PASS_STATE = "PASS_STATE";
    public static String IS_FROM_REPORTQUERY = "IS_FROM_REPORTQUERY";
    public static String IS_MULTI_ORGUNIT = "IS_MULTI_ORGUNIT";
    public static String Examine = "Examine";
    public static String ORGUNIT_MAP = "ORGUNIT_MAP";
    public static String SEARCH_TEXT = "SEARCH_TEXT";
    public static String BGEXAMINE_CHECK_INFO = "BGEXAMINE_CHECK_INFO";
    public LongTimeDialog dialog = null;

    public static MBgExamineClientUtils getInstance() {
        return new MBgExamineClientUtils();
    }

    protected IBgExamineFacade getBgExamineInterface() throws Exception {
        return BgExamineFacadeFactory.getRemoteInstance();
    }

    protected IBgExamineCheck getBgExamCheckInterface() throws Exception {
        return BgExamineCheckFactory.getRemoteInstance();
    }

    public boolean canExamine(String billId) throws Exception {
        if (StringUtils.isEmpty((String)billId)) {
            return false;
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(billId);
        return this.canExamine(billIds);
    }

    public boolean canExamine(List<String> billIds) throws Exception {
        if (billIds == null || billIds.isEmpty()) {
            return false;
        }
        return this.getBgExamineInterface().canExamine(billIds);
    }

    public List<String> canExamineByAdjust(String billId) throws Exception {
        ArrayList<String> examineIds = new ArrayList<String>();
        if (StringUtils.isEmpty((String)billId)) {
            return examineIds;
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(billId);
        return this.canExamineByAdjust(billIds);
    }

    public List<String> canExamineByAdjust(List<String> billIds) throws Exception {
        List<String> examineIds = new ArrayList<String>();
        if (billIds == null || billIds.isEmpty()) {
            return examineIds;
        }
        examineIds = this.getBgExamineInterface().canExamineByAdjustBill(billIds);
        return examineIds;
    }

    public void examineCheck(Component component, String billId, String faceMethod, boolean hasShowReport) throws Exception {
        this.examineCheck(component, null, billId, null, null, faceMethod, hasShowReport);
    }

    public void examineCheck(Component component, List<String> billIds, String faceMethod, boolean hasShowReport) throws Exception {
        this.examineCheck(component, null, billIds, null, null, faceMethod, hasShowReport);
    }

    public void examineCheck(Component component, String billId, Object[] params, String faceMethod, boolean hasShowReport) throws Exception {
        this.examineCheck(component, null, billId, null, params, faceMethod, hasShowReport);
    }

    public void examineCheck(Component component, BOSUuid bgOrgViewId, String billId, List<String> examineIds, Object[] params, String faceMethod, boolean hasShowReport) throws Exception {
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(billId);
        this.examineCheckLocal(component, true, billIds, examineIds, params, faceMethod, hasShowReport);
    }

    public void examineCheck(Component component, BOSUuid bgOrgViewId, Object obj, List<String> examineIds, Object[] params, String faceMethod, boolean hasShowReport) throws Exception {
        this.examineCheckLocal(component, true, obj, examineIds, params, faceMethod, hasShowReport);
    }

    public void examineCheck(Component component, BOSUuid bgOrgViewId, List<String> billIds, List<String> examineIds, Object[] params, String faceMethod, boolean hasShowReport) throws Exception {
        this.examineCheckLocal(component, true, billIds, examineIds, params, faceMethod, hasShowReport);
    }

    public void examineCheckByAdjust(Component component, BOSUuid bgOrgViewId, List<String> billIds, List<String> examineIds, Object[] params, String faceMethod, boolean hasShowReport) throws Exception {
        this.examineCheckLocal(component, false, billIds, examineIds, params, faceMethod, hasShowReport);
    }

    public void setDialog(Component component) {
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor(component);
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
        }
    }

    private void examineCheckLocal(final Component component, final boolean hasBgForm, final Object obj, final List<String> examineIds, final Object[] params, final String faceMethod, final boolean hasShowReport) throws Exception {
        if (component == null || obj == null) {
            return;
        }
        final ArrayList<String> billIds = new ArrayList<String>();
        if (obj instanceof List) {
            billIds.addAll((List)obj);
        } else if (obj instanceof Map && ((Map)obj).containsKey("BGFORM_INFO") && ((Map)obj).get("BGFORM_INFO") instanceof Map) {
            Map bgFormMap = (Map)((Map)obj).get("BGFORM_INFO");
            for (String bgFormId : bgFormMap.keySet()) {
                billIds.add(bgFormId);
            }
        }
        if (billIds.isEmpty()) {
            return;
        }
        if (this.dialog == null) {
            Window win = SwingUtilities.getWindowAncestor(component);
            if (win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)win);
            }
        }
        if (this.dialog == null) {
            return;
        }
        this.dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                Object obj2 = null;
                try {
                    obj2 = hasBgForm ? MBgExamineClientUtils.this.getBgExamineInterface().examines(billIds) : MBgExamineClientUtils.this.getBgExamineInterface().examinesByAdjustBill(billIds, examineIds);
                }
                catch (BgPeriodException ex) {
                    MsgBox.showDetailAndOK((Component)component, (String)ex.getMessage(), (String)ex.getCause().getMessage(), (int)0);
                    SysUtil.abort();
                }
                catch (Exception ex) {
                    throw ex;
                }
                return obj2;
            }

            public void afterExec(Object result) throws Exception {
                if (result instanceof BgExamineResult) {
                    ArrayList<BgExamineResult> list = new ArrayList<BgExamineResult>();
                    list.add((BgExamineResult)((Object)result));
                    result = list;
                }
                if (result instanceof List) {
                    List checkResult = result;
                    Boolean showWarning = false;
                    Boolean check = null;
                    for (int index = 0; index < checkResult.size(); ++index) {
                        if (checkResult.get(index) == null || ((BgExamineResult)checkResult.get((int)index)).result) continue;
                        check = false;
                        if ("afterRefer".equalsIgnoreCase(faceMethod)) {
                            if (!showWarning.booleanValue()) {
                                MsgBox.showWarning((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkExamineNoPass"));
                            }
                            showWarning = true;
                            continue;
                        }
                        if ("afterCourse".equalsIgnoreCase(faceMethod)) {
                            if (!showWarning.booleanValue()) {
                                MsgBox.showWarning((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkExamineNoCourse"));
                            }
                            showWarning = true;
                            continue;
                        }
                        if ("afterBatchAudit".equalsIgnoreCase(faceMethod)) {
                            if (!showWarning.booleanValue()) {
                                MsgBox.showWarning((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkExamineNoAudit"));
                            }
                            showWarning = true;
                            continue;
                        }
                        if ("afterAudit".equalsIgnoreCase(faceMethod)) {
                            if (!showWarning.booleanValue()) {
                                MsgBox.showWarning((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkExamineNoAudit"));
                            }
                            showWarning = true;
                            continue;
                        }
                        if ("afterAuditBill".equalsIgnoreCase(faceMethod)) {
                            if (!showWarning.booleanValue()) {
                                MsgBox.showWarning((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkExamineNoAuditBill"));
                            }
                            showWarning = true;
                            continue;
                        }
                        if ("afterReferBill".equalsIgnoreCase(faceMethod)) {
                            if (!showWarning.booleanValue()) {
                                MsgBox.showWarning((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkExamineNoReferBill"));
                            }
                            showWarning = true;
                            continue;
                        }
                        if ("afterCslAudit".equals(faceMethod)) {
                            if (!showWarning.booleanValue()) {
                                MsgBox.showWarning((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.bgcsl.BgCslFormResource", "checkExamineNoCslAudit"));
                            }
                            showWarning = true;
                            continue;
                        }
                        if ("afterWorkAudit".equals(faceMethod)) {
                            if (!showWarning.booleanValue()) {
                                MsgBox.showWarning((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.bgcsl.BgCslFormResource", "checkExamineNoWorkAudit"));
                            }
                            showWarning = true;
                            continue;
                        }
                        if (!"afterCslAdjAudit".equals(faceMethod)) continue;
                        if (!showWarning.booleanValue()) {
                            MsgBox.showWarning((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.bgcsl.BgCslFormResource", "checkExamineNoCslAdjAudit"));
                        }
                        showWarning = true;
                    }
                    if (check == null) {
                        check = true;
                    }
                    MBgExamineClientUtils.this.setHasExamineCheck(component, check);
                    if (hasShowReport || !check.booleanValue()) {
                        BOSUuid bgOrgViewId = MBgExamineClientUtils.this.getBgOrgViewId(hasBgForm, billIds);
                        if (bgOrgViewId != null) {
                            MBgExamineClientUtils.this.showCheckReport(checkResult, bgOrgViewId, faceMethod == null, (List<String>)billIds);
                        } else {
                            BOSUuid unionId = MBgExamineClientUtils.getUnionId(billIds);
                            MBgExamineClientUtils.this.showCheckCslReport(checkResult, unionId, faceMethod == null, (List<String>)billIds);
                        }
                    }
                    if (!StringUtils.isEmpty((String)faceMethod) && check.booleanValue()) {
                        try {
                            Method method = component.getClass().getMethod(faceMethod, Object.class, Object[].class);
                            if (method != null) {
                                method.invoke((Object)component, obj, params);
                            }
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    MBgExamineClientUtils.this.setHasExamineCheck(component, false);
                }
            }
        });
        this.dialog.show();
    }

    private void setHasExamineCheck(Component component, boolean check) throws Exception {
        if (component == null) {
            return;
        }
        Method method = component.getClass().getMethod("setHasExamineCheck", Boolean.TYPE);
        if (method != null) {
            method.invoke((Object)component, check);
        }
    }

    private BOSUuid getBgOrgViewId(boolean hasBgForm, List<String> billIds) throws Exception {
        if (billIds == null || billIds.isEmpty()) {
            return null;
        }
        BgSchemeInfo schemeInfo = null;
        String billId = billIds.get(0);
        if (hasBgForm) {
            String bosType = BOSUuid.read((String)billId).getType().toString();
            if ("3BA5F027".equals(bosType)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("bgScheme.id");
                BgFormInfo bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectStringPK(billId), sic);
                if (bgFormInfo != null) {
                    schemeInfo = MbgDataHelper.getBgSchemeInfo(bgFormInfo.getBgScheme().getId());
                }
            }
        } else {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("bgScheme.id");
            BgAdjustBillInfo bgAdjustBill = BgAdjustBillFactory.getRemoteInstance().getBgAdjustBillInfo((IObjectPK)new ObjectStringPK(billId), sic);
            if (bgAdjustBill != null) {
                schemeInfo = MbgDataHelper.getBgSchemeInfo(bgAdjustBill.getBgScheme().getId());
            }
        }
        if (schemeInfo != null) {
            return schemeInfo.getEditOrgViewId();
        }
        return null;
    }

    public static BOSUuid getUnionId(List<String> billIds) throws Exception {
        IRowSet rst;
        if (billIds == null || billIds.isEmpty()) {
            return null;
        }
        BOSUuid unionId = null;
        String billId = billIds.get(0);
        String sql = null;
        String bosType = BOSUuid.read((String)billId).getType().toString();
        if ("AD34C4CD".equals(bosType)) {
            sql = "select FOrgTreeId from T_MBG_BgCslAdjForm where FID = '" + billId + "'";
        } else if ("655ADD42".equals(bosType)) {
            sql = "select FOrgTreeId from T_MBG_BgCslForm where FID = '" + billId + "'";
        } else if ("9E7BD5E2".equals(bosType)) {
            sql = "select FOrgTreeId from T_MBG_MbgWorkPaper where FID = '" + billId + "'";
        }
        if (sql != null && (rst = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL()).next()) {
            unionId = BOSUuid.read((String)rst.getString("FOrgTreeId"));
        }
        return unionId;
    }

    public void showCheckReport(Component component, String billId, BOSUuid bgOrgViewId, boolean showMessage) throws Exception {
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        Object result = this.getBgExamCheckInterface().getReport(billId);
        if (billId == null) {
            return;
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(billId);
        if (result instanceof BgExamineResult) {
            this.showCheckReport((BgExamineResult)result, null, true, billIds);
        } else if (result instanceof List) {
            this.showCheckReport((List)result, null, true, billIds);
        } else if (this.getBgExamineInterface().canExamine(billId)) {
            MsgBox.showInfo((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkPleaseCheckExamine"));
        } else {
            MsgBox.showInfo((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkCanExamine"));
        }
    }

    public void showCheckReport(BgExamineResult result, BOSUuid bgOrgViewId, boolean showMessage, List<String> billIds) throws Exception {
        ArrayList<BgExamineResult> newResult = new ArrayList<BgExamineResult>();
        newResult.add(result);
        this.showCheckReport(newResult, bgOrgViewId, showMessage, billIds);
    }

    public void showCheckReport(List<BgExamineResult> result, BOSUuid bgOrgViewId, boolean showMessage, List<String> billIds) throws Exception {
        int index;
        if (result == null || result.isEmpty()) {
            return;
        }
        boolean resultNull = false;
        boolean show = false;
        for (index = 0; index < result.size(); ++index) {
            if (result.get(index) == null) continue;
            resultNull = true;
        }
        if (!resultNull) {
            return;
        }
        for (index = 0; index < result.size(); ++index) {
            if (!result.get((int)index).examines.isEmpty()) continue;
            show = true;
        }
        if (show && showMessage) {
            MsgBox.showWarning((String)BgCommCHelper.getMessageStr((String)"com.kingdee.eas.ma.mbg.client.BgExamineCheckResource", (String)"checknullByScope"));
        } else {
            if (show && !showMessage && BgFormHelper.checkInProInst(billIds.get(0))) {
                return;
            }
            UIContext uiContext = new UIContext();
            uiContext.put((Object)BGEXAMINE_CHECK_INFO, result);
            uiContext.put((Object)"BGORGVIEW_ID", (Object)bgOrgViewId);
            uiContext.put((Object)"findModel", (Object)"false");
            uiContext.put((Object)"BGFORM_IDS", billIds);
            if (this.dialog != null) {
                uiContext.put((Object)"owner", (Object)this.dialog.getOwner());
            }
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getExamineViewUI(), (Map)uiContext);
            uiWindow.show();
        }
    }

    public void showCheckCslReport(Component component, String billId, BOSUuid unionId, boolean showMessage) throws Exception {
        if (StringUtils.isEmpty((String)billId)) {
            return;
        }
        Object result = this.getBgExamCheckInterface().getReport(billId);
        if (billId == null) {
            return;
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(billId);
        if (result instanceof BgExamineResult) {
            this.showCheckCslReport((BgExamineResult)result, unionId, true, billIds);
        } else if (result instanceof List) {
            this.showCheckCslReport((List)result, unionId, true, billIds);
        } else if (this.getBgExamineInterface().canExamine(billId)) {
            MsgBox.showInfo((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.mbg.client.BgFormResource", "checkPleaseCheckExamine"));
        } else if ("com.kingdee.eas.ma.bgcsl.client.BgCslAdjFormProcessUI".equals(component.getClass().getName()) || "com.kingdee.eas.ma.bgcsl.client.BgCslAdjFormSpecialProcessUi".equals(component.getClass().getName())) {
            MsgBox.showInfo((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.bgcsl.BgCslAdjFormResource", "checkCanExamine"));
        } else {
            MsgBox.showInfo((Component)component, (String)BgNFCHelper.getMessageStr("com.kingdee.eas.ma.bgcsl.BgCslFormResource", "checkCanExamine"));
        }
    }

    public void showCheckCslReport(BgExamineResult result, BOSUuid unionId, boolean showMessage, List<String> billIds) throws Exception {
        ArrayList<BgExamineResult> newResult = new ArrayList<BgExamineResult>();
        newResult.add(result);
        this.showCheckCslReport(newResult, unionId, showMessage, billIds);
    }

    public void showCheckCslReport(List<BgExamineResult> result, BOSUuid unionId, boolean showMessage, List<String> billIds) throws Exception {
        this.showCheckCslReport(result, unionId, showMessage, null, billIds);
    }

    public void showCheckCslReport(BgExamineResult result, BOSUuid unionId, boolean showMessage, String resource, List<String> billIds) throws Exception {
        ArrayList<BgExamineResult> newResult = new ArrayList<BgExamineResult>();
        newResult.add(result);
        this.showCheckCslReport(newResult, unionId, showMessage, resource, billIds);
    }

    public void showCheckCslReport(List<BgExamineResult> result, BOSUuid unionId, boolean showMessage, String resource, List<String> billIds) throws Exception {
        int index;
        boolean resultNull = true;
        boolean show = false;
        for (index = 0; index < result.size(); ++index) {
            if (result.get(index) == null) continue;
            resultNull = false;
        }
        if (resultNull) {
            return;
        }
        for (index = 0; index < result.size(); ++index) {
            if (result.get((int)index).examines == null) continue;
            show = false;
        }
        if (resource == null) {
            resource = "com.kingdee.eas.ma.mbg.client.BgExamineCheckResource";
        }
        if (show && showMessage) {
            MsgBox.showWarning((String)BgCommCHelper.getMessageStr((String)resource, (String)"checknullByScope"));
        } else {
            UIContext uiContext = new UIContext();
            uiContext.put((Object)BGEXAMINE_CHECK_INFO, result);
            uiContext.put((Object)"UNION_ID", (Object)(unionId != null ? unionId.toString() : null));
            uiContext.put((Object)"BGFORM_IDS", billIds);
            uiContext.put((Object)"findModel", (Object)"false");
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(this.getExamineViewUI(), (Map)uiContext);
            uiWindow.show();
        }
    }

    protected String getExamineViewUI() {
        return BgExamineSpeResultViewUI.class.getName();
    }

    public void filterReportByBillID(BgExamineResult result, String billId) throws EASBizException, BOSException {
        ArrayList<BgExamineResult> newResult = new ArrayList<BgExamineResult>();
        newResult.add(result);
        this.filterReportByBillIDArray(newResult, billId);
    }

    public void filterReportByBillIDArray(List<BgExamineResult> result, String billId) throws EASBizException, BOSException {
        HashSet<String> billIds = new HashSet<String>();
        if (!StringUtils.isEmpty((String)billId)) {
            billIds.add(billId);
        }
        this.filterReportByBillIDArray(result, billIds);
    }

    public void filterReportByBillIDArray(List<BgExamineResult> result, Set<String> billIds) throws EASBizException, BOSException {
        if (billIds == null || billIds.isEmpty() || result == null || result.isEmpty()) {
            return;
        }
        Set<String> refBgExamineIdSet = this.getExamine(billIds);
        List<BgExamineInfo> examines = result.get((int)0).examines;
        Iterator<BgExamineInfo> iterator = examines.iterator();
        while (iterator.hasNext()) {
            BgExamineInfo examine = iterator.next();
            if (refBgExamineIdSet.contains(examine.getId().toString())) continue;
            iterator.remove();
        }
        List<BgExamineInfo> errors = result.get((int)0).errors;
        Iterator<BgExamineInfo> iterator2 = errors.iterator();
        while (iterator2.hasNext()) {
            BgExamineInfo examine = iterator2.next();
            if (refBgExamineIdSet.contains(examine.getId().toString())) continue;
            iterator2.remove();
        }
    }

    protected Set<String> getExamine(String billId) throws EASBizException, BOSException {
        HashSet<String> billIds = new HashSet<String>();
        if (!StringUtils.isEmpty((String)billId)) {
            billIds.add(billId);
        }
        return this.getExamine(billIds);
    }

    protected Set<String> getExamine(Set<String> billIds) throws EASBizException, BOSException {
        return BgExamineFactory.getRemoteInstance().getExamines(billIds);
    }
}

