/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.eas.fi.newrpt.client.designer.FormulaPicker;
import com.kingdee.eas.fi.newrpt.client.designer.event.FormulaPickListener;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.fi.rpt.api.IRptContextManager;
import com.kingdee.eas.fi.rpt.client.FormulaPickerUI;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.IFormulaPickerListener;
import com.kingdee.eas.fi.rpt.client.IFormulaWizardListener;
import com.kingdee.eas.fi.rpt.client.RptFormula;
import com.kingdee.eas.fi.rpt.client.RptFormulaComp;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import org.apache.log4j.Logger;

public class MbgFormulaPicker
implements ISpreadWizzard {
    private static final Logger logger = Logger.getLogger(MbgFormulaPicker.class);
    private FormulaPickerUI realWizard;
    private FormulaPickListener pickListener;
    private Component parentUI;
    private boolean isK3 = false;
    private RptContextManager rptContextManager;
    public static String formulaFilter = "exclude:formulas{BgItemM,MbgItemM,BgItem,Item,FpItem,DItem,keyWord,bgact};exclude:categorys{fm_fp}";

    public MbgFormulaPicker(Component owner) throws Exception {
        this.parentUI = owner;
    }

    public void setRptContextManager(RptContextManager context) {
        this.rptContextManager = context;
    }

    public void show() {
        try {
            if (this.realWizard == null) {
                this.initWizard();
            }
            if (this.pickListener != null) {
                this.realWizard.setFormulaLine(this.pickListener.pickFormulaLine());
            } else {
                this.realWizard.setFormulaLine(null);
            }
            this.pick(this.realWizard.getFormulaLine());
        }
        catch (Exception e) {
            logger.error((Object)e.getStackTrace(), (Throwable)e);
            SysUtil.abort((Throwable)e);
        }
    }

    private void pick(String line) throws Exception {
        Expression exp;
        RptFormula fm = null;
        FunctionExpr function = null;
        if (!StringUtils.isEmpty((String)line) && (exp = ExcelFormulaPaserHelper.parse((String)line)) instanceof FunctionExpr) {
            function = (FunctionExpr)exp;
        }
        if (function != null) {
            RptFormulaComp comp = RptFormulaComp.getInstance();
            comp.setK3(this.isK3);
            comp.load();
            fm = RptFormulaComp.getInstance().getFormula(function.funcionName);
            if ("BgItem".equalsIgnoreCase(function.funcionName)) {
                RptFormula fmm = RptFormulaComp.getInstance().getFormula("bgitemm");
                if (fm != null && fmm != null) {
                    fm.setWizard(fmm.getWizard());
                    fm.getParameters().clear();
                    fm.getParameters().addAll(fmm.getParameters());
                }
            }
        }
        if (this.parentUI instanceof SpreadContext) {
            this.rptContextManager.put(SpreadContext.class, (Object)this.parentUI);
        }
        if (function != null && fm != null) {
            FormulaWizardUI wizard = FormulaWizardUI.creatFormulaWizard((String)fm.getWizard(), (Object)this.parentUI);
            wizard.setRptContext((IRptContextManager)this.rptContextManager);
            wizard.addFormulaWizardListener(new IFormulaWizardListener(){

                public void wizardSetout(FormulaWizardUI wizard) {
                }

                public void wizardReturnee(FormulaWizardUI wizard, String formulaLine, boolean isOk) {
                    if (isOk && MbgFormulaPicker.this.pickListener != null) {
                        MbgFormulaPicker.this.pickListener.setFormulaLine(formulaLine);
                    }
                }
            });
            wizard.setUserObject((Object)line);
            FormulaHint hint = new FormulaHint();
            hint.params = new String[function.parameters.size()];
            for (int i = 0; i < function.parameters.size(); ++i) {
                Expression e = (Expression)function.parameters.get(i);
                hint.params[i] = e instanceof StringExpr ? ((StringExpr)e).value : e.toString();
            }
            hint.name = function.funcionName;
            hint.text = line;
            wizard.setLoadOnce(true);
            wizard.open(function.funcionName, hint);
        } else {
            boolean showAdvn = !StringUtils.isEmpty((String)line);
            this.realWizard.setUserObject((Object)line);
            this.realWizard.setRptContext(this.rptContextManager);
            this.realWizard.setFormulaLine(line);
            this.realWizard.setK3(this.isK3);
            this.realWizard.open(formulaFilter, showAdvn, null);
        }
    }

    private void initWizard() throws Exception {
        this.realWizard = FormulaPicker.getFormulaPicker((Component)this.parentUI);
        this.realWizard.addFormulaPickerListener(new IFormulaPickerListener(){

            public void pickerSetout(FormulaPickerUI picker) {
            }

            public void pickerReturnee(FormulaPickerUI picker, String formulaLine, boolean isOk) {
                if (isOk) {
                    MbgFormulaPicker.this.pickListener.setFormulaLine(formulaLine);
                }
            }
        });
    }

    public void setFormulaPickListener(FormulaPickListener l) {
        this.pickListener = l;
    }

    public boolean prepare() {
        return true;
    }

    public boolean isModal() {
        return true;
    }

    public void commit() {
    }
}

