/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.client.utils;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.swing.KDButtonGroup;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.fi.newrpt.DesignerResource;
import com.kingdee.eas.fi.newrpt.client.designer.IItemFormulaProvider;
import com.kingdee.eas.fi.newrpt.client.designer.event.FormulaPickListener;
import com.kingdee.eas.ma.mbg.client.utils.MbgFormulaPicker;
import com.kingdee.eas.ma.mbg.client.utils.MbgItemFormulaChangeEvent;
import com.kingdee.eas.ma.mbg.client.utils.MbgItemFormulaChangeListener;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MbgItemFormulaPanel
extends KDPanel {
    private static final long serialVersionUID = -4911153025073003176L;
    private KDWorkButton btnItem;
    private KDTextField txtItemFormula;
    private KDWorkButton btnOption;
    private KDButtonGroup grpOption;
    private int state = 1;
    private boolean showItem = true;
    private KDPopupMenu popupOptionMenu = null;
    private KDCheckBoxMenuItem menuAlwaysShow = null;
    private KDCheckBoxMenuItem menuShowAsNeeded = null;
    private KDCheckBoxMenuItem menuNeverShow = null;
    private ItemPanelStateChangeListener itemPanelStateChangeListener;
    private IItemFormulaProvider formulaProvider;
    private int width = 1;
    private MbgItemFormulaChangeListener itemFormulaChangeListener;
    private MbgFormulaPicker wizard;
    private SpreadContext spreadContext;
    private MbgItemFormulaChangeEvent itemFormulaChangeEvent = new MbgItemFormulaChangeEvent((Object)this, null);
    private Set managingFocusForwardTraversalKeys;
    private boolean isEditable = true;

    public MbgItemFormulaPanel(SpreadContext container) {
        this.spreadContext = container;
        this.setLayout(new ItemPanelLayout());
        this.initComponents();
        this.initCompActions();
    }

    private void initComponents() {
        this.btnItem = new KDWorkButton();
        this.txtItemFormula = new KDTextField();
        this.btnOption = new KDWorkButton();
        this.add((Component)this.btnItem);
        this.btnItem.setToolTipText(DesignerResource.getString((String)"itemFormulaPanel_formula"));
        this.btnItem.setIcon(EASResource.getIcon((String)"imgTbtn_formulaguide"));
        this.add((Component)this.txtItemFormula);
        this.btnOption.setToolTipText(DesignerResource.getString((String)"notShowItemFormula"));
        this.btnOption.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.add((Component)this.btnOption);
        this.menuAlwaysShow = new KDCheckBoxMenuItem(DesignerResource.getString((String)"alwaysShowItemFormula"));
        this.menuShowAsNeeded = new KDCheckBoxMenuItem(DesignerResource.getString((String)"ShowItemFormulaAsNeeded"));
        this.menuNeverShow = new KDCheckBoxMenuItem(DesignerResource.getString((String)"NeverShowItemFormula"));
        this.grpOption = new KDButtonGroup();
        this.grpOption.add((AbstractButton)this.menuAlwaysShow);
        this.grpOption.add((AbstractButton)this.menuShowAsNeeded);
        this.grpOption.add((AbstractButton)this.menuNeverShow);
        this.popupOptionMenu = new KDPopupMenu();
        this.popupOptionMenu.add((JMenuItem)this.menuAlwaysShow);
        this.popupOptionMenu.add((JMenuItem)this.menuShowAsNeeded);
        this.popupOptionMenu.add((JMenuItem)this.menuNeverShow);
        this.grpOption.setSelected(this.menuShowAsNeeded.getModel(), true);
        this.btnOption.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"2_ItemFormulaPanel"));
        this.txtItemFormula.setSelectAllOnFocus(false);
    }

    public void addItemFormulaChangeListener(MbgItemFormulaChangeListener l) {
        this.itemFormulaChangeListener = l;
        this.txtItemFormula.setFocusTraversalKeys(0, this.getManagingFocusForwardTraversalKeys());
        KeyStroke ks = KeyStroke.getKeyStroke(10, 0);
        String strKey = "FORMULA_ENTER";
        this.txtItemFormula.getInputMap().put(ks, strKey);
        this.txtItemFormula.getActionMap().put(strKey, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MbgItemFormulaPanel.this.update();
                MbgItemFormulaPanel.this.spreadContext.requestFocus();
            }
        });
    }

    private void update() {
        if (this.txtItemFormula.isFocusOwner()) {
            String text = this.txtItemFormula.getText();
            this.itemFormulaChangeEvent.setFormula(text);
            this.itemFormulaChangeListener.formulaChanged(this.itemFormulaChangeEvent);
        }
    }

    Set getManagingFocusForwardTraversalKeys() {
        if (this.managingFocusForwardTraversalKeys == null) {
            this.managingFocusForwardTraversalKeys = new HashSet();
            this.managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 2));
            this.managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        }
        return this.managingFocusForwardTraversalKeys;
    }

    private void setShowState(int s) {
        this.state = s;
        this.spreadContext.getFacadeManager().getPromptPanel().setAdjustable(s != 2);
        this.setItemFormulaLine(this.txtItemFormula.getText());
    }

    public void setShowMode(int s) {
        if (s == 0) {
            this.showItem = true;
            this.menuAlwaysShow.doClick();
        } else if (s == 1) {
            this.menuShowAsNeeded.doClick();
        } else if (s == 2) {
            this.menuNeverShow.doClick();
        }
    }

    public void refreshItemFormula(Range range, int viewMode) {
        if (range == null) {
            this.setItemFormulaLine(null);
        }
        if (this.formulaProvider != null) {
            this.setItemFormulaLine(this.formulaProvider.getDisplayingItemFormula(range, viewMode));
            if (this.isEditable) {
                this.setEditable(this.formulaProvider.editable());
            }
        }
    }

    public void setItemFormulaLine(String formula) {
        if (formula == null) {
            formula = "";
        }
        this.txtItemFormula.setText(formula);
        if (this.state == 1) {
            this.setPanelVisible(!StringUtils.isEmpty((String)formula));
        } else if (this.state == 0) {
            this.setPanelVisible(true);
        } else {
            this.setPanelVisible(false);
        }
    }

    private void initCompActions() {
        this.btnItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbgItemFormulaPanel.this.initWizard();
                MbgItemFormulaPanel.this.wizard.show();
            }
        });
        this.btnOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rectangle bounds = MbgItemFormulaPanel.this.btnOption.getBounds();
                MbgItemFormulaPanel.this.popupOptionMenu.show((Component)MbgItemFormulaPanel.this.btnOption, bounds.x, bounds.y + bounds.height);
            }
        });
        this.menuAlwaysShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbgItemFormulaPanel.this.setShowState(0);
            }
        });
        this.menuShowAsNeeded.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbgItemFormulaPanel.this.setShowState(1);
            }
        });
        this.menuNeverShow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MbgItemFormulaPanel.this.setShowState(2);
            }
        });
    }

    public void setPanelVisible(boolean visible) {
        if (visible && this.showItem && this.txtItemFormula.isVisible() && this.btnItem.isVisible()) {
            return;
        }
        this.showItem = visible;
        this.txtItemFormula.setVisible(visible);
        this.btnItem.setVisible(visible);
        this.doLayout();
    }

    public void setStateChangeListener(ItemPanelStateChangeListener l) {
        this.itemPanelStateChangeListener = l;
    }

    public IItemFormulaProvider getFormulaProvider() {
        return this.formulaProvider;
    }

    public void setFormulaProvider(IItemFormulaProvider formulaProvider) {
        this.formulaProvider = formulaProvider;
    }

    public void setEnabled(boolean enabled) {
        this.isEditable = enabled;
        this.setEditable(enabled);
    }

    private void setEditable(boolean bEdit) {
        this.txtItemFormula.setEditable(bEdit);
        this.btnItem.setEnabled(bEdit);
    }

    private void initWizard() {
        try {
            if (this.wizard != null) {
                return;
            }
            this.wizard = new MbgFormulaPicker((Component)((Object)this));
            this.wizard.setFormulaPickListener(new FormulaPickListener(){

                public String pickFormulaLine() {
                    String s = MbgItemFormulaPanel.this.txtItemFormula.getText();
                    if (s == null || s.trim().length() < 1 || s.charAt(0) != '=') {
                        return MbgItemFormulaPanel.this.formulaProvider.defaultItemFormula();
                    }
                    return s;
                }

                public void setFormulaLine(String line) {
                    String string = '=' + line;
                    MbgItemFormulaPanel.this.txtItemFormula.setText(string);
                    if (MbgItemFormulaPanel.this.itemFormulaChangeListener != null) {
                        MbgItemFormulaChangeEvent e = new MbgItemFormulaChangeEvent(MbgItemFormulaPanel.this.wizard);
                        e.setFormula(string);
                        MbgItemFormulaPanel.this.itemFormulaChangeListener.formulaChanged(e);
                    }
                }
            });
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
    }

    public void doPickItemFormula() {
        this.btnItem.doClick();
    }

    public Dimension getPreferredSize() {
        Dimension dim = new Dimension(this.width, 20);
        return dim;
    }

    private class ItemPanelLayout
    implements LayoutManager {
        private static final int PANEL_HEIGHT = 20;
        private int itemFormulaWidth = 300;

        private ItemPanelLayout() {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = MbgItemFormulaPanel.this.getHeight();
            Insets insets = MbgItemFormulaPanel.this.getInsets();
            int left = insets.left;
            int top = insets.top;
            int bottom = insets.bottom;
            int compH = h - top - bottom;
            int x = left;
            int y = top;
            x += 2;
            if (MbgItemFormulaPanel.this.showItem) {
                int total = MbgItemFormulaPanel.this.getBounds().width;
                MbgItemFormulaPanel.this.btnItem.setBounds(x, y, compH + 2, compH);
                MbgItemFormulaPanel.this.txtItemFormula.setLocation(x += compH + 2, y);
                int itemWidth = total - x - 16 - 1;
                if (itemWidth < 0 && total < x + 16 + 2) {
                    itemWidth = this.itemFormulaWidth;
                } else {
                    this.itemFormulaWidth = itemWidth;
                }
                MbgItemFormulaPanel.this.txtItemFormula.setSize(itemWidth, compH);
                MbgItemFormulaPanel.this.txtItemFormula.setBounds(x, y, itemWidth, compH);
                x += itemWidth + 1;
            }
            MbgItemFormulaPanel.this.btnOption.setBounds(x, y, 16, compH);
            int newWidth = x + ((MbgItemFormulaPanel)MbgItemFormulaPanel.this).btnOption.getBounds().width;
            if (MbgItemFormulaPanel.this.itemPanelStateChangeListener != null && newWidth != MbgItemFormulaPanel.this.width) {
                MbgItemFormulaPanel.this.width = newWidth;
                MbgItemFormulaPanel.this.itemPanelStateChangeListener.changeWidth(MbgItemFormulaPanel.this.width);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(parent.getWidth(), 20);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(parent.getWidth(), 20);
        }
    }

    public static interface ItemPanelStateChangeListener {
        public void changeWidth(int var1);
    }
}

